/*
 * Decompiled with CFR 0.152.
 */
package gregapi.recipes.maps;

import gregapi.code.ArrayListNoNulls;
import gregapi.data.CS;
import gregapi.data.FL;
import gregapi.data.TD;
import gregapi.oredict.OreDictItemData;
import gregapi.oredict.OreDictMaterialStack;
import gregapi.recipes.Recipe;
import gregapi.recipes.maps.RecipeMapSpecialSingleInput;
import gregapi.util.OM;
import gregapi.util.ST;
import gregapi.util.UT;
import java.util.Collection;
import net.minecraft.item.ItemStack;

public class RecipeMapShredder
extends RecipeMapSpecialSingleInput {
    public RecipeMapShredder(Collection<Recipe> aRecipeList, String aUnlocalizedName, String aNameLocal, String aNameNEI, long aProgressBarDirection, long aProgressBarAmount, String aNEIGUIPath, long aInputItemsCount, long aOutputItemsCount, long aMinimalInputItems, long aInputFluidCount, long aOutputFluidCount, long aMinimalInputFluids, long aMinimalInputs, long aPower, String aNEISpecialValuePre, long aNEISpecialValueMultiplier, String aNEISpecialValuePost, boolean aShowVoltageAmperageInNEI, boolean aNEIAllowed, boolean aConfigAllowed, boolean aNeedsOutputs, boolean aCombinePower, boolean aUseBucketSizeIn, boolean aUseBucketSizeOut) {
        super(aRecipeList, aUnlocalizedName, aNameLocal, aNameNEI, aProgressBarDirection, aProgressBarAmount, aNEIGUIPath, aInputItemsCount, aOutputItemsCount, aMinimalInputItems, aInputFluidCount, aOutputFluidCount, aMinimalInputFluids, aMinimalInputs, aPower, aNEISpecialValuePre, aNEISpecialValueMultiplier, aNEISpecialValuePost, aShowVoltageAmperageInNEI, aNEIAllowed, aConfigAllowed, aNeedsOutputs, aCombinePower, aUseBucketSizeIn, aUseBucketSizeOut);
    }

    @Override
    public Recipe getRecipeFor(ItemStack aInput) {
        OreDictItemData aData = OM.anydata(aInput);
        if (aData == null || aData.mPrefix != null && (!aData.mPrefix.contains(TD.Prefix.RECYCLABLE) || aData.mPrefix.containsAny(TD.Prefix.DUST_BASED, TD.Prefix.ORE, TD.Prefix.ORE_PROCESSING_BASED, TD.Prefix.IS_CONTAINER)) || aData.mMaterial != null && aData.mMaterial.mMaterial.contains(TD.Atomic.ANTIMATTER) || FL.getFluid(aInput, true) != null) {
            return null;
        }
        ArrayListNoNulls<OreDictMaterialStack> tList = new ArrayListNoNulls<OreDictMaterialStack>();
        for (OreDictMaterialStack tMaterial : aData.getAllMaterialStacks()) {
            if (tMaterial.mMaterial.mTargetPulver.mAmount <= 0L) continue;
            OM.stack(UT.Code.units(tMaterial.mAmount, 648648000L, tMaterial.mMaterial.mTargetPulver.mAmount, false), tMaterial.mMaterial.mTargetPulver.mMaterial).addToList(tList);
        }
        if (tList.isEmpty()) {
            return null;
        }
        ItemStack[] tOutputs = new ItemStack[Math.min(tList.size(), this.mOutputItemsCount)];
        int i = 0;
        int tDuration = 0;
        for (OreDictMaterialStack tMaterial : tList) {
            ItemStack tStack;
            tDuration = (int)((long)tDuration + UT.Code.units(tMaterial.mAmount, 648648000L, (tMaterial.mMaterial.containsAny(TD.Properties.QUARTZ) ? 64 : (tMaterial.mMaterial.containsAny(TD.Properties.BRITTLE, TD.Properties.STRETCHY, TD.Properties.BOUNCY, TD.Properties.STONE, TD.Properties.WOOD, TD.Properties.FOOD, TD.Properties.MEAT, TD.Properties.ROTTEN) ? 2 : 256)) * Math.max(1, tMaterial.mMaterial.mToolQuality + 1), true));
            if (i >= tOutputs.length || (tStack = OM.dust(tMaterial)) == null) continue;
            tOutputs[i++] = tStack;
        }
        if (!UT.Code.exists(0, tOutputs)) {
            return null;
        }
        return new Recipe(false, false, false, ST.array(ST.amount(1L, aInput)), tOutputs, null, null, CS.ZL_FS, CS.ZL_FS, Math.max(1, tDuration), 16L, 0L);
    }
}

