/*
 * Decompiled with CFR 0.152.
 */
package gregapi.recipes.maps;

import gregapi.block.IPrefixBlock;
import gregapi.code.ArrayListNoNulls;
import gregapi.code.ItemStackContainer;
import gregapi.data.CS;
import gregapi.data.OP;
import gregapi.data.TD;
import gregapi.oredict.OreDictItemData;
import gregapi.oredict.OreDictMaterial;
import gregapi.oredict.OreDictMaterialStack;
import gregapi.recipes.Recipe;
import gregapi.recipes.maps.RecipeMapSpecialSingleInput;
import gregapi.util.OM;
import gregapi.util.ST;
import gregapi.util.UT;
import java.util.Collection;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;

public class RecipeMapHammer
extends RecipeMapSpecialSingleInput {
    private List<Recipe> mBufferedDynamicRecipes = null;

    public RecipeMapHammer(Collection<Recipe> aRecipeList, String aUnlocalizedName, String aNameLocal, String aNameNEI, long aProgressBarDirection, long aProgressBarAmount, String aNEIGUIPath, long aInputItemsCount, long aOutputItemsCount, long aMinimalInputItems, long aInputFluidCount, long aOutputFluidCount, long aMinimalInputFluids, long aMinimalInputs, long aPower, String aNEISpecialValuePre, long aNEISpecialValueMultiplier, String aNEISpecialValuePost, boolean aShowVoltageAmperageInNEI, boolean aNEIAllowed, boolean aConfigAllowed, boolean aNeedsOutputs, boolean aCombinePower, boolean aUseBucketSizeIn, boolean aUseBucketSizeOut) {
        super(aRecipeList, aUnlocalizedName, aNameLocal, aNameNEI, aProgressBarDirection, aProgressBarAmount, aNEIGUIPath, aInputItemsCount, aOutputItemsCount, aMinimalInputItems, aInputFluidCount, aOutputFluidCount, aMinimalInputFluids, aMinimalInputs, aPower, aNEISpecialValuePre, aNEISpecialValueMultiplier, aNEISpecialValuePost, aShowVoltageAmperageInNEI, aNEIAllowed, aConfigAllowed, aNeedsOutputs, aCombinePower, aUseBucketSizeIn, aUseBucketSizeOut);
    }

    @Override
    public List<Recipe> getNEIAllRecipes() {
        List<Recipe> rList = super.getNEIAllRecipes();
        if (this.mBufferedDynamicRecipes == null) {
            this.mBufferedDynamicRecipes = new ArrayListNoNulls<Recipe>();
            for (OreDictMaterial tMaterial : OP.crushed.mRegisteredMaterials) {
                for (ItemStackContainer tThing : tMaterial.mRegisteredItems) {
                    ItemStack tStack = tThing.toStack();
                    Block tBlock = ST.block(tStack);
                    if (tBlock == CS.NB || tBlock instanceof IPrefixBlock && tBlock != CS.BlocksGT.ore) continue;
                    this.mBufferedDynamicRecipes.add(this.getRecipeFor(tStack));
                }
            }
        }
        rList.addAll(this.mBufferedDynamicRecipes);
        return rList;
    }

    @Override
    public List<Recipe> getNEIRecipes(ItemStack ... aOutputs) {
        List<Recipe> rList = super.getNEIRecipes(aOutputs);
        for (ItemStack aOutput : aOutputs) {
            OreDictItemData aData = OM.anyassociation(aOutput);
            if (aData == null || aData.mPrefix != OP.crushed) continue;
            for (ItemStackContainer tStack : aData.mMaterial.mMaterial.mRegisteredItems) {
                rList.add(this.getRecipeFor(tStack.toStack()));
            }
            break;
        }
        return rList;
    }

    @Override
    public Recipe getRecipeFor(ItemStack aInput) {
        OreDictItemData aData = OM.anydata(aInput);
        if (aData == null || !aData.validData() || aData.mPrefix == OP.oreBedrock || aData.mMaterial.mMaterial.contains(TD.Atomic.ANTIMATTER) || !aData.mPrefix.contains(TD.Prefix.ORE) || aData.mPrefix.containsAny(TD.Prefix.DUST_ORE, TD.Prefix.IS_CONTAINER)) {
            return null;
        }
        OreDictMaterial aCrushedMat = aData.mMaterial.mMaterial.mTargetCrushing.mMaterial;
        long aCrushedAmount = aData.mMaterial.mMaterial.mTargetCrushing.mAmount;
        long aMultiplier = aData.mMaterial.mMaterial.mOreMultiplier * aData.mMaterial.mMaterial.mOreProcessingMultiplier * (aData.mPrefix == OP.blockRaw ? 9 : (aData.mPrefix.contains(TD.Prefix.DENSE_ORE) ? 2 : 1));
        if (aData.mPrefix == OP.orePoor) {
            ItemStack tOutput = OP.crushedTiny.mat(aCrushedMat, UT.Code.units(aCrushedAmount, 648648000L, 2L * aMultiplier, false));
            if (tOutput == null) {
                tOutput = OP.dustTiny.mat(aCrushedMat, UT.Code.units(aCrushedAmount, 648648000L, 2L * aMultiplier, false));
            }
            return tOutput == null ? null : new Recipe(false, false, true, ST.array(ST.amount(1L, aInput)), ST.array(tOutput), null, null, CS.ZL_FS, CS.ZL_FS, Math.max(1, 16 * tOutput.stackSize * Math.max(1, aData.mMaterial.mMaterial.mToolQuality + 1)), 16L, 0L);
        }
        if (aData.mPrefix == OP.oreSmall || aData.mPrefix == OP.oreRich || aData.mPrefix == OP.oreNormal) {
            return null;
        }
        ItemStack[] tOutputs = new ItemStack[Math.max(1, this.mOutputItemsCount)];
        tOutputs[0] = OP.crushed.mat(aCrushedMat, UT.Code.units(aCrushedAmount, 648648000L, aMultiplier, false));
        if (tOutputs[0] == null) {
            tOutputs[0] = OP.dust.mat(aCrushedMat, UT.Code.units(aCrushedAmount, 648648000L, aMultiplier, false));
        }
        if (tOutputs[0] == null) {
            return null;
        }
        int i = 0;
        int tDuration = 32 * tOutputs[0].stackSize * Math.max(1, aData.mMaterial.mMaterial.mToolQuality + 1);
        for (OreDictMaterialStack tMaterial : aData.mPrefix.mByProducts) {
            ItemStack tStack;
            tDuration = (int)((long)tDuration + UT.Code.units(tMaterial.mAmount, 648648000L, 64 * Math.max(1, tMaterial.mMaterial.mToolQuality + 1), true));
            if (i >= tOutputs.length - 1 || (tStack = OM.dust(tMaterial.mMaterial.mTargetCrushing.mMaterial, UT.Code.units(tMaterial.mAmount, 648648000L, tMaterial.mMaterial.mTargetCrushing.mAmount, false))) == null) continue;
            tOutputs[++i] = tStack;
        }
        return new Recipe(false, false, true, ST.array(ST.amount(1L, aInput)), tOutputs, null, null, CS.ZL_FS, CS.ZL_FS, Math.max(1, tDuration), 16L, 0L);
    }
}

