/*
 * Decompiled with CFR 0.152.
 */
package gregapi.recipes.maps;

import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IIndividual;
import gregapi.data.CS;
import gregapi.data.FL;
import gregapi.data.IL;
import gregapi.data.MT;
import gregapi.data.OP;
import gregapi.item.bumble.IItemBumbleBee;
import gregapi.random.IHasWorldAndCoords;
import gregapi.recipes.Recipe;
import gregapi.util.ST;
import gregapi.util.UT;
import java.util.Collection;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class RecipeMapBumblelyzer
extends Recipe.RecipeMap {
    public RecipeMapBumblelyzer(Collection<Recipe> aRecipeList, String aUnlocalizedName, String aNameLocal, String aNameNEI, long aProgressBarDirection, long aProgressBarAmount, String aNEIGUIPath, long aInputItemsCount, long aOutputItemsCount, long aMinimalInputItems, long aInputFluidCount, long aOutputFluidCount, long aMinimalInputFluids, long aMinimalInputs, long aPower, String aNEISpecialValuePre, long aNEISpecialValueMultiplier, String aNEISpecialValuePost, boolean aShowVoltageAmperageInNEI, boolean aNEIAllowed, boolean aConfigAllowed, boolean aNeedsOutputs, boolean aCombinePower, boolean aUseBucketSizeIn, boolean aUseBucketSizeOut) {
        super(aRecipeList, aUnlocalizedName, aNameLocal, aNameNEI, aProgressBarDirection, aProgressBarAmount, aNEIGUIPath, aInputItemsCount, aOutputItemsCount, aMinimalInputItems, aInputFluidCount, aOutputFluidCount, aMinimalInputFluids, aMinimalInputs, aPower, aNEISpecialValuePre, aNEISpecialValueMultiplier, aNEISpecialValuePost, false, aShowVoltageAmperageInNEI, aNEIAllowed, aConfigAllowed, aNeedsOutputs, aCombinePower, aUseBucketSizeIn, aUseBucketSizeOut);
    }

    @Override
    public Recipe findRecipe(IHasWorldAndCoords aTileEntity, Recipe aRecipe, boolean aNotUnificated, long aSize, ItemStack aSpecialSlot, FluidStack[] aFluids, ItemStack ... aInputs) {
        Recipe rRecipe = super.findRecipe(aTileEntity, aRecipe, aNotUnificated, aSize, aSpecialSlot, aFluids, aInputs);
        if (aInputs == null || aFluids == null || aFluids.length < 1 || aFluids[0] == null || CS.GAPI_POST.mFinishedServerStarted <= 0) {
            return rRecipe;
        }
        if (rRecipe == null && (CS.FluidsGT.HONEY.contains(aFluids[0].getFluid().getName()) || FL.Honeydew.is(aFluids[0]))) {
            for (ItemStack aInput : aInputs) {
                if (!ST.valid(aInput)) continue;
                if ((aInput = ST.amount(1L, aInput)).getItem() instanceof IItemBumbleBee) {
                    if (((IItemBumbleBee)aInput.getItem()).bumbleType(aInput) < 5) {
                        return new Recipe(false, false, false, ST.array(aInput, OP.plateTiny.mat(MT.Paper, (long)aInput.stackSize)), ST.array(((IItemBumbleBee)aInput.getItem()).bumbleScan(aInput)), null, null, FL.array(FL.amount(aFluids[0], 10L)), null, 64L, 16L, 0L);
                    }
                    return new Recipe(false, false, false, ST.array(aInput), ST.array(aInput), null, null, null, null, 1L, 16L, 0L);
                }
                if (!IL.FR_Bee_Drone.equal(aInput, true, true) && !IL.FR_Bee_Princess.equal(aInput, true, true) && !IL.FR_Bee_Queen.equal(aInput, true, true)) continue;
                try {
                    IIndividual tIndividual = AlleleManager.alleleRegistry.getIndividual(aInput);
                    if (tIndividual == null || !tIndividual.analyze()) {
                        return new Recipe(false, false, false, ST.array(aInput), ST.array(aInput), null, null, null, null, 1L, 16L, 0L);
                    }
                    ItemStack rOutput = ST.copy(aInput);
                    tIndividual.writeToNBT(UT.NBT.getOrCreate(rOutput));
                    return new Recipe(false, false, false, ST.array(aInput), ST.array(rOutput), null, null, FL.array(FL.amount(aFluids[0], 50L)), null, 64L, 16L, 0L);
                }
                catch (Throwable e) {
                    e.printStackTrace(CS.ERR);
                }
            }
        }
        return rRecipe;
    }
}

