/*
 * Decompiled with CFR 0.152.
 */
package gregapi.recipes;

import codechicken.nei.recipe.GuiCraftingRecipe;
import codechicken.nei.recipe.GuiUsageRecipe;
import gregapi.code.ArrayListNoNulls;
import gregapi.code.HashSetNoNulls;
import gregapi.code.ItemStackContainer;
import gregapi.code.ItemStackMap;
import gregapi.config.Config;
import gregapi.data.CS;
import gregapi.data.FL;
import gregapi.data.FM;
import gregapi.data.IL;
import gregapi.data.LH;
import gregapi.data.RM;
import gregapi.gui.Slot_Base;
import gregapi.oredict.OreDictItemData;
import gregapi.oredict.OreDictManager;
import gregapi.random.IHasWorldAndCoords;
import gregapi.recipes.IRecipeMapHandler;
import gregapi.tileentity.ITileEntityInventoryGUI;
import gregapi.util.OM;
import gregapi.util.ST;
import gregapi.util.UT;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;

public class Recipe {
    public ItemStack[] mInputs;
    public ItemStack[] mOutputs;
    public FluidStack[] mFluidInputs;
    public FluidStack[] mFluidOutputs;
    public long[] mChances;
    public long[] mMaxChances;
    public Object mSpecialItems;
    public long mDuration;
    public long mEUt;
    public long mSpecialValue;
    public boolean mEnabled = true;
    public boolean mHidden = false;
    public boolean mFakeRecipe = false;
    public boolean mCanBeBuffered = true;
    public boolean mNeedsEmptyOutput = false;

    public static void reInit() {
        for (RecipeMap tMapEntry : RecipeMap.RECIPE_MAPS.values()) {
            tMapEntry.reInit();
        }
    }

    public int getOutputChance(long aIndex) {
        if (aIndex < 0L || aIndex >= (long)this.mChances.length) {
            return this.getMaxChance(aIndex);
        }
        return (int)this.mChances[(int)aIndex];
    }

    public int getMaxChance(long aIndex) {
        if (aIndex < 0L || aIndex >= (long)this.mMaxChances.length) {
            return 10000;
        }
        return (int)this.mMaxChances[(int)aIndex];
    }

    public ItemStack getRepresentativeInput(long aIndex) {
        if (aIndex < 0L || aIndex >= (long)this.mInputs.length) {
            return null;
        }
        return ST.copy(this.mInputs[(int)aIndex]);
    }

    public ItemStack getOutput(long aIndex) {
        if (aIndex < 0L || aIndex >= (long)this.mOutputs.length) {
            return null;
        }
        return ST.copy(this.mOutputs[(int)aIndex]);
    }

    public FluidStack getRepresentativeFluidInput(long aIndex) {
        if (aIndex < 0L || aIndex >= (long)this.mFluidInputs.length || this.mFluidInputs[(int)aIndex] == null) {
            return null;
        }
        return this.mFluidInputs[(int)aIndex].copy();
    }

    public FluidStack getFluidOutput(long aIndex) {
        if (aIndex < 0L || aIndex >= (long)this.mFluidOutputs.length || this.mFluidOutputs[(int)aIndex] == null) {
            return null;
        }
        return this.mFluidOutputs[(int)aIndex].copy();
    }

    public Recipe copy() {
        return new Recipe(this);
    }

    public Recipe setSpecialNumber(long aNumber) {
        this.mSpecialValue = aNumber;
        return this;
    }

    public Recipe setNoBuffering() {
        this.mCanBeBuffered = false;
        return this;
    }

    public Recipe setNeedEmptyOut() {
        this.mNeedsEmptyOutput = true;
        return this;
    }

    public boolean blockINblockOUT() {
        return this.mInputs.length == 1 && this.mOutputs.length == 1 && this.mFluidInputs.length == 0 && this.mFluidOutputs.length == 0 && ST.block(this.mInputs[0]) != CS.NB && ST.block(this.mOutputs[0]) != CS.NB && this.mInputs[0].stackSize == 1 && this.mOutputs[0].stackSize == 1;
    }

    public long getAbsoluteTotalPower() {
        return Math.abs(this.mEUt * this.mDuration);
    }

    public FluidStack[] getFluidOutputs() {
        return this.getFluidOutputs(CS.RNGSUS, 1);
    }

    public FluidStack[] getFluidOutputs(Random aRandom) {
        return this.getFluidOutputs(aRandom, 1);
    }

    public FluidStack[] getFluidOutputs(Random aRandom, int aProcessCount) {
        FluidStack[] rArray = new FluidStack[this.mFluidOutputs.length];
        for (int i = 0; i < rArray.length; ++i) {
            rArray[i] = FL.mul(this.getFluidOutput(i), aProcessCount);
        }
        return rArray;
    }

    public ItemStack[] getOutputs() {
        return this.getOutputs(CS.RNGSUS, 1);
    }

    public ItemStack[] getOutputs(Random aRandom) {
        return this.getOutputs(aRandom, 1);
    }

    public ItemStack[] getOutputs(Random aRandom, int aProcessCount) {
        ItemStack[] rArray = new ItemStack[this.mOutputs.length];
        if (aRandom == null) {
            aRandom = new Random();
        }
        for (int i = 0; i < rArray.length; ++i) {
            ItemStack tOutput = this.getOutput(i);
            if (tOutput == null) continue;
            int tChance = this.getOutputChance(i);
            if (tChance > 0) {
                int tMax = this.getMaxChance(i);
                if (tChance >= tMax) {
                    rArray[i] = ST.mul_(aProcessCount, tOutput);
                    continue;
                }
                int k = tOutput.stackSize * aProcessCount;
                for (int j = 0; j < k; ++j) {
                    if (aRandom.nextInt(tMax) >= tChance) continue;
                    if (rArray[i] == null) {
                        rArray[i] = ST.amount(1L, tOutput);
                        continue;
                    }
                    ++rArray[i].stackSize;
                }
                continue;
            }
            rArray[i] = tOutput;
        }
        return rArray;
    }

    public boolean checkStacksEqual(boolean aDecreaseStacksizeBySuccess, boolean aDontCheckStackSizes, ItemStack ... aInputs) {
        boolean[] tChecked = new boolean[aInputs.length];
        for (ItemStack tInput : this.mInputs) {
            if (!ST.valid(tInput)) continue;
            boolean temp = true;
            for (int i = 0; i < aInputs.length; ++i) {
                if (tChecked[i]) continue;
                ItemStack aInput = aInputs[i];
                if (ST.valid(aInput)) {
                    if (!aDontCheckStackSizes && aInput.stackSize < tInput.stackSize || !OreDictManager.INSTANCE.equal_(false, aInput, tInput, !tInput.hasTagCompound())) continue;
                    if (aDecreaseStacksizeBySuccess) {
                        aInput.stackSize -= tInput.stackSize;
                    }
                    tChecked[i] = true;
                    temp = false;
                    break;
                }
                tChecked[i] = true;
            }
            if (!temp) continue;
            return false;
        }
        return true;
    }

    @Deprecated
    public boolean isRecipeInputEqual(boolean aDecreaseStacksizeBySuccess, FluidStack[] aFluidInputs, ItemStack ... aInputs) {
        return this.isRecipeInputEqual(aDecreaseStacksizeBySuccess, false, aFluidInputs, aInputs);
    }

    public boolean isRecipeInputEqual(boolean aDecreaseStacksizeBySuccess, boolean aDontCheckStackSizes, FluidStack[] aFluidInputs, ItemStack ... aInputs) {
        if (this.mFluidInputs.length > 0 && (aFluidInputs == null || aFluidInputs.length < 1)) {
            return false;
        }
        if (this.mInputs.length > 0 && (aInputs == null || aInputs.length < 1)) {
            return false;
        }
        for (FluidStack tFluid : this.mFluidInputs) {
            if (tFluid == null) continue;
            boolean temp = true;
            FluidStack[] fluidStackArray = aFluidInputs;
            int n = fluidStackArray.length;
            for (int i = 0; i < n; ++i) {
                FluidStack aFluid = fluidStackArray[i];
                if (aFluid == null || !aFluid.isFluidEqual(tFluid) || !aDontCheckStackSizes && aFluid.amount < tFluid.amount) continue;
                temp = false;
                break;
            }
            if (!temp) continue;
            return false;
        }
        if (!this.checkStacksEqual(false, aDontCheckStackSizes, aInputs)) {
            return false;
        }
        if (aDecreaseStacksizeBySuccess) {
            block2: for (FluidStack tFluid : this.mFluidInputs) {
                if (tFluid == null) continue;
                for (FluidStack aFluid : aFluidInputs) {
                    if (aFluid == null || !aFluid.isFluidEqual(tFluid) || aFluid.amount < tFluid.amount) continue;
                    aFluid.amount -= tFluid.amount;
                    continue block2;
                }
            }
            this.checkStacksEqual(true, false, aInputs);
        }
        return true;
    }

    public boolean isRecipeInputEqual(boolean aDecreaseStacksizeBySuccess, boolean aDontCheckStackSizes, IFluidTank[] aFluidInputs, ItemStack ... aInputs) {
        if (this.mFluidInputs.length > 0 && (aFluidInputs == null || aFluidInputs.length < 1)) {
            return false;
        }
        if (this.mInputs.length > 0 && (aInputs == null || aInputs.length < 1)) {
            return false;
        }
        for (FluidStack tFluid : this.mFluidInputs) {
            if (tFluid == null) continue;
            boolean temp = true;
            IFluidTank[] iFluidTankArray = aFluidInputs;
            int n = iFluidTankArray.length;
            for (int i = 0; i < n; ++i) {
                IFluidTank tTank = iFluidTankArray[i];
                FluidStack aFluid = tTank.getFluid();
                if (aFluid == null || !aFluid.isFluidEqual(tFluid) || !aDontCheckStackSizes && aFluid.amount < tFluid.amount) continue;
                temp = false;
                break;
            }
            if (!temp) continue;
            return false;
        }
        if (!this.checkStacksEqual(false, aDontCheckStackSizes, aInputs)) {
            return false;
        }
        if (aDecreaseStacksizeBySuccess) {
            block2: for (FluidStack tFluid : this.mFluidInputs) {
                if (tFluid == null) continue;
                for (IFluidTank tTank : aFluidInputs) {
                    FluidStack aFluid = tTank.getFluid();
                    if (aFluid == null || !aFluid.isFluidEqual(tFluid) || aFluid.amount < tFluid.amount) continue;
                    tTank.drain(tFluid.amount, true);
                    continue block2;
                }
            }
            this.checkStacksEqual(true, false, aInputs);
        }
        return true;
    }

    public int isRecipeInputEqual(int aMaxProcessCount, IFluidTank[] aFluidInputs, ItemStack ... aInputs) {
        int rProcessCount;
        if (aMaxProcessCount <= 0) {
            return 0;
        }
        if (this.mFluidInputs.length > 0 && (aFluidInputs == null || aFluidInputs.length < 1)) {
            return 0;
        }
        if (this.mInputs.length > 0 && (aInputs == null || aInputs.length < 1)) {
            return 0;
        }
        for (rProcessCount = 0; rProcessCount < aMaxProcessCount; ++rProcessCount) {
            for (FluidStack tFluid : this.mFluidInputs) {
                if (tFluid == null) continue;
                boolean temp = true;
                IFluidTank[] iFluidTankArray = aFluidInputs;
                int n = iFluidTankArray.length;
                for (int i = 0; i < n; ++i) {
                    IFluidTank tTank = iFluidTankArray[i];
                    FluidStack aFluid = tTank.getFluid();
                    if (aFluid == null || !aFluid.isFluidEqual(tFluid) || aFluid.amount < tFluid.amount) continue;
                    temp = false;
                    break;
                }
                if (!temp) continue;
                return rProcessCount;
            }
            if (!this.checkStacksEqual(false, false, aInputs)) {
                return rProcessCount;
            }
            block3: for (FluidStack tFluid : this.mFluidInputs) {
                if (tFluid == null) continue;
                for (IFluidTank tTank : aFluidInputs) {
                    FluidStack aFluid = tTank.getFluid();
                    if (aFluid == null || !aFluid.isFluidEqual(tFluid) || aFluid.amount < tFluid.amount) continue;
                    tTank.drain(tFluid.amount, true);
                    continue block3;
                }
            }
            this.checkStacksEqual(true, false, aInputs);
        }
        return rProcessCount;
    }

    private Recipe(Recipe aRecipe) {
        this.mInputs = ST.copyArray(aRecipe.mInputs);
        this.mOutputs = ST.copyArray(aRecipe.mOutputs);
        this.mSpecialItems = aRecipe.mSpecialItems;
        this.mChances = Arrays.copyOf(aRecipe.mChances, aRecipe.mChances.length);
        this.mMaxChances = Arrays.copyOf(aRecipe.mMaxChances, aRecipe.mMaxChances.length);
        this.mFluidInputs = FL.copy(aRecipe.mFluidInputs);
        this.mFluidOutputs = FL.copy(aRecipe.mFluidOutputs);
        this.mEUt = aRecipe.mEUt;
        this.mDuration = aRecipe.mDuration;
        this.mSpecialValue = aRecipe.mSpecialValue;
        this.mNeedsEmptyOutput = aRecipe.mNeedsEmptyOutput;
        this.mCanBeBuffered = aRecipe.mCanBeBuffered;
        this.mFakeRecipe = aRecipe.mFakeRecipe;
        this.mEnabled = aRecipe.mEnabled;
        this.mHidden = aRecipe.mHidden;
    }

    public Recipe(boolean aOptimize, boolean aUnificate, ItemStack[] aInputs, ItemStack[] aOutputs, Object aSpecialItems, long[] aChances, FluidStack[] aFluidInputs, FluidStack[] aFluidOutputs, long aDuration, long aEUt, long aSpecialValue) {
        this(aOptimize, aUnificate, true, aInputs, aOutputs, aSpecialItems, aChances, aFluidInputs, aFluidOutputs, aDuration, aEUt, aSpecialValue);
    }

    public Recipe(boolean aOptimize, boolean aUnificate, boolean aCanBeBuffered, ItemStack[] aInputs, ItemStack[] aOutputs, Object aSpecialItems, long[] aChances, FluidStack[] aFluidInputs, FluidStack[] aFluidOutputs, long aDuration, long aEUt, long aSpecialValue) {
        int i;
        this.mCanBeBuffered = aCanBeBuffered;
        if (aInputs == null) {
            aInputs = CS.ZL_IS;
        }
        if (aOutputs == null) {
            aOutputs = CS.ZL_IS;
        }
        if (aFluidInputs == null) {
            aFluidInputs = CS.ZL_FS;
        }
        if (aFluidOutputs == null) {
            aFluidOutputs = CS.ZL_FS;
        }
        if (aChances == null) {
            long[] lArray = aChances = aOutputs.length <= 0 ? CS.ZL_LONG : new long[aOutputs.length];
        }
        if (aChances.length < aOutputs.length) {
            aChances = Arrays.copyOf(aChances, aOutputs.length);
        }
        aInputs = UT.Code.getWithoutTrailingNulls(aInputs).toArray(CS.ZL_IS);
        aOutputs = UT.Code.getWithoutTrailingNulls(aOutputs).toArray(CS.ZL_IS);
        if (aUnificate) {
            OreDictManager.INSTANCE.setStackArray_(true, aInputs);
            OreDictManager.INSTANCE.setStackArray_(true, aOutputs);
        }
        for (int i2 = 0; i2 < aFluidOutputs.length; ++i2) {
            if (!FL.zero(aFluidOutputs[i2])) continue;
            aFluidOutputs[i2] = CS.NF;
        }
        aFluidInputs = UT.Code.getWithoutNulls(aFluidInputs).toArray(CS.ZL_FS);
        aFluidOutputs = UT.Code.getWithoutNulls(aFluidOutputs).toArray(CS.ZL_FS);
        int l = UT.Code.bindInt(aDuration / 16L);
        for (i = 0; i < aChances.length; ++i) {
            if (aChances[i] > 0L) continue;
            aChances[i] = 10000L;
        }
        for (i = 0; i < aInputs.length; ++i) {
            if (aInputs[i] == null) continue;
            aInputs[i] = ST.copy_(aInputs[i]);
            if (aInputs[i].stackSize == 0) continue;
            l = Math.min(aInputs[i].stackSize, l);
        }
        for (i = 0; i < aOutputs.length; ++i) {
            if (aOutputs[i] == null) continue;
            aOutputs[i] = ST.validMeta_(aOutputs[i]);
            if (aOutputs[i].stackSize == 0) continue;
            l = Math.min(aOutputs[i].stackSize, l);
        }
        for (i = 0; i < aFluidInputs.length; ++i) {
            aFluidInputs[i] = aFluidInputs[i].copy();
            if (aFluidInputs[i].amount == 0) continue;
            l = Math.min(aFluidInputs[i].amount, l);
        }
        for (i = 0; i < aFluidOutputs.length; ++i) {
            aFluidOutputs[i] = aFluidOutputs[i].copy();
            if (aFluidOutputs[i].amount == 0) continue;
            l = Math.min(aFluidOutputs[i].amount, l);
        }
        if (aOptimize) {
            int j;
            for (i = 0; i < aInputs.length; ++i) {
                if (aInputs[i] == CS.NI || ST.meta_(aInputs[i]) == Short.MAX_VALUE) continue;
                for (j = 0; j < aOutputs.length; ++j) {
                    if (aOutputs[j] == null || !ST.equal_(aInputs[i], aOutputs[j], false)) continue;
                    if (aInputs[i].stackSize >= aOutputs[j].stackSize) {
                        aInputs[i].stackSize -= aOutputs[j].stackSize;
                        l = Math.min(aInputs[i].stackSize, l);
                        aOutputs[j] = CS.NI;
                        continue;
                    }
                    aOutputs[j].stackSize -= aInputs[i].stackSize;
                    l = Math.min(aOutputs[i].stackSize, l);
                }
            }
            while (l > 1) {
                boolean temp = true;
                for (j = 0; temp && j < aInputs.length; ++j) {
                    if (aInputs[j] == null || aInputs[j].stackSize % l == 0) continue;
                    temp = false;
                }
                for (j = 0; temp && j < aOutputs.length; ++j) {
                    if (aOutputs[j] == null || aOutputs[j].stackSize % l == 0) continue;
                    temp = false;
                }
                for (j = 0; temp && j < aFluidInputs.length; ++j) {
                    if (aFluidInputs[j].amount % l == 0) continue;
                    temp = false;
                }
                for (j = 0; temp && j < aFluidOutputs.length; ++j) {
                    if (aFluidOutputs[j].amount % l == 0) continue;
                    temp = false;
                }
                if (temp) {
                    for (j = 0; j < aInputs.length; ++j) {
                        if (aInputs[j] == null) continue;
                        aInputs[j].stackSize /= l;
                    }
                    for (j = 0; j < aOutputs.length; ++j) {
                        if (aOutputs[j] == null) continue;
                        aOutputs[j].stackSize /= l;
                    }
                    for (j = 0; j < aFluidInputs.length; ++j) {
                        aFluidInputs[j].amount /= l;
                    }
                    for (j = 0; j < aFluidOutputs.length; ++j) {
                        aFluidOutputs[j].amount /= l;
                    }
                    aDuration /= (long)l;
                    break;
                }
                --l;
            }
        }
        for (i = 0; i < aInputs.length; ++i) {
            if (aInputs[i] == CS.NI || aInputs[i].stackSize <= 64) continue;
            aInputs[i].stackSize = 64;
        }
        for (i = 0; i < aOutputs.length; ++i) {
            if (aOutputs[i] == CS.NI) continue;
            aOutputs[i] = ST.update(aOutputs[i]);
            if (aOutputs[i].stackSize <= 64) continue;
            aOutputs[i].stackSize = 64;
        }
        this.mInputs = aInputs;
        this.mOutputs = aOutputs;
        this.mSpecialItems = aSpecialItems;
        this.mChances = aChances;
        this.mMaxChances = new long[aChances.length];
        Arrays.fill(this.mMaxChances, 10000L);
        this.mFluidInputs = aFluidInputs;
        this.mFluidOutputs = aFluidOutputs;
        this.mDuration = aDuration;
        this.mSpecialValue = aSpecialValue;
        this.mEUt = aEUt;
    }

    public static class RecipeMap
    implements Runnable {
        public static final Map<String, RecipeMap> RECIPE_MAPS = new HashMap<String, RecipeMap>();
        public static final List<RecipeMap> RECIPE_MAP_LIST = new ArrayList<RecipeMap>();
        public static final List<RecipeMap> FUEL_MAP_LIST = new ArrayList<RecipeMap>();
        public final List<IRecipeMapHandler> mRecipeMapHandlers = new ArrayListNoNulls<IRecipeMapHandler>();
        public final List<ItemStack> mRecipeMachineList = ST.arraylist(new ItemStack[0]);
        public final ItemStackMap<ItemStackContainer, Collection<Recipe>> mRecipeItemMap = new ItemStackMap();
        public final Map<String, Collection<Recipe>> mRecipeFluidMap = new HashMap<String, Collection<Recipe>>();
        public final Map<String, Long> mMinInputTankSizes = new HashMap<String, Long>();
        public final Collection<Recipe> mRecipeList;
        public int mRecipeListSize = 0;
        public final String mNameInternal;
        public final String mNameLocal;
        public final String mNameLocalUnderscored;
        public final String mNameNEI;
        public final String mGUIPath;
        public final String mNEISpecialValuePre;
        public final String mNEISpecialValuePost;
        public final byte mProgressBarDirection;
        public final byte mProgressBarAmount;
        public final int mInputItemsCount;
        public final int mOutputItemsCount;
        public final int mInputFluidCount;
        public final int mOutputFluidCount;
        public final int mMinimalInputItems;
        public final int mMinimalInputFluids;
        public final int mMinimalInputs;
        public final long mNEISpecialValueMultiplier;
        public final long mPower;
        public final boolean mNEIAllowed;
        public final boolean mShowVoltageAmperageInNEI;
        public final boolean mNeedsOutputs;
        public final boolean mCombinePower;
        public final boolean mUseBucketSizeIn;
        public final boolean mUseBucketSizeOut;
        public boolean mLogErrors = true;
        public int mMaxFluidInputSize = 1000;
        public int mMaxFluidOutputSize = 1000;
        public Config mConfigFile = null;
        private Recipe oRecipe = null;
        @Deprecated
        public static RecipeMap sMaceratorRecipes = new RecipeMap();
        @Deprecated
        public static RecipeMap sFurnaceRecipes = RM.Furnace;
        @Deprecated
        public static RecipeMap sMicrowaveRecipes = RM.Microwave;
        @Deprecated
        public static RecipeMap sFurnaceFuel = FM.Furnace;
        @Deprecated
        public static RecipeMap sByProductList = RM.ByProductList;
        @Deprecated
        public static RecipeMap sCrucibleSmelting = RM.CrucibleSmelting;
        @Deprecated
        public static RecipeMap sCrucibleAlloying = RM.CrucibleAlloying;
        @Deprecated
        public static RecipeMap sGenerifierRecipes = RM.Generifier;
        @Deprecated
        public static RecipeMap sSharpeningRecipes = RM.Sharpening;
        @Deprecated
        public static RecipeMap sSifterRecipes = RM.Sifting;
        @Deprecated
        public static RecipeMap sHammerRecipes = RM.Hammer;
        @Deprecated
        public static RecipeMap sChiselRecipes = RM.Chisel;
        @Deprecated
        public static RecipeMap sShredderRecipes = RM.Shredder;
        @Deprecated
        public static RecipeMap sCrusherRecipes = RM.Crusher;
        @Deprecated
        public static RecipeMap sLatheRecipes = RM.Lathe;
        @Deprecated
        public static RecipeMap sCutterRecipes = RM.Cutter;
        @Deprecated
        public static RecipeMap sCoagulatorRecipes = RM.Coagulator;
        @Deprecated
        public static RecipeMap sSqueezerRecipes = RM.Squeezer;
        @Deprecated
        public static RecipeMap sJuicerRecipes = RM.Juicer;
        @Deprecated
        public static RecipeMap sMortarRecipes = RM.Mortar;
        @Deprecated
        public static RecipeMap sCompressorRecipes = RM.Compressor;
        @Deprecated
        public static RecipeMap sCentrifugeRecipes = RM.Centrifuge;
        @Deprecated
        public static RecipeMap sElectrolyzerRecipes = RM.Electrolyzer;
        @Deprecated
        public static RecipeMap sRollingMillRecipes = RM.RollingMill;
        @Deprecated
        public static RecipeMap sRollBenderRecipes = RM.RollBender;
        @Deprecated
        public static RecipeMap sRollFormerRecipes = RM.RollFormer;
        @Deprecated
        public static RecipeMap sClusterMillRecipes = RM.ClusterMill;
        @Deprecated
        public static RecipeMap sWiremillRecipes = RM.Wiremill;
        @Deprecated
        public static RecipeMap sMixerRecipes = RM.Mixer;
        @Deprecated
        public static RecipeMap sCannerRecipes = RM.Canner;
        @Deprecated
        public static RecipeMap sInjectorRecipes = RM.Injector;
        @Deprecated
        public static RecipeMap sRoastingRecipes = RM.Roasting;
        @Deprecated
        public static RecipeMap sDryingRecipes = RM.Drying;
        @Deprecated
        public static RecipeMap sFermenterRecipes = RM.Fermenter;
        @Deprecated
        public static RecipeMap sDistilleryRecipes = RM.Distillery;
        @Deprecated
        public static RecipeMap sExtruderRecipes = RM.Extruder;
        @Deprecated
        public static RecipeMap sPolarizerRecipes = RM.Polarizer;
        @Deprecated
        public static RecipeMap sLoomRecipes = RM.Loom;
        @Deprecated
        public static RecipeMap sCookingRecipes = RM.Cooking;
        @Deprecated
        public static RecipeMap sPressRecipes = RM.Press;
        @Deprecated
        public static RecipeMap sBathRecipes = RM.Bath;
        @Deprecated
        public static RecipeMap sSmelterRecipes = RM.Smelter;
        @Deprecated
        public static RecipeMap sLaserEngraverRecipes = RM.LaserEngraver;
        @Deprecated
        public static RecipeMap sWelderRecipes = RM.Welder;
        @Deprecated
        public static RecipeMap sCrystallisationCrucibleRecipes = RM.CrystallisationCrucible;
        @Deprecated
        public static RecipeMap sScannerVisualsRecipes = RM.ScannerVisuals;
        @Deprecated
        public static RecipeMap sPrinterRecipes = RM.Printer;
        @Deprecated
        public static RecipeMap sSluiceRecipes = RM.Sluice;
        @Deprecated
        public static RecipeMap sMagneticSeparatorRecipes = RM.MagneticSeparator;
        @Deprecated
        public static RecipeMap sAutocrafterRecipes = RM.Autocrafter;
        @Deprecated
        public static RecipeMap sMassfabRecipes = RM.Massfab;
        @Deprecated
        public static RecipeMap sScannerMolecularRecipes = RM.ScannerMolecular;
        @Deprecated
        public static RecipeMap sReplicatorRecipes = RM.Replicator;
        @Deprecated
        public static RecipeMap sSlicerRecipes = RM.Slicer;
        @Deprecated
        public static RecipeMap sCokeOvenRecipes = RM.CokeOven;
        @Deprecated
        public static RecipeMap sDistillationTowerRecipes = RM.DistillationTower;
        @Deprecated
        public static RecipeMap sAutoclaveRecipes = RM.Autoclave;
        @Deprecated
        public static RecipeMap sBoxinatorRecipes = RM.Boxinator;
        @Deprecated
        public static RecipeMap sUnboxinatorRecipes = RM.Unboxinator;
        @Deprecated
        public static RecipeMap sFusionRecipes = RM.Fusion;
        @Deprecated
        public static RecipeMap sBlastRecipes = RM.BlastFurnace;
        @Deprecated
        public static RecipeMap sImplosionRecipes = RM.ImplosionCompressor;
        @Deprecated
        public static RecipeMap sVacuumRecipes = RM.VacuumFreezer;
        @Deprecated
        public static RecipeMap sAssemblerRecipes = RM.Assembler;
        @Deprecated
        public static RecipeMap sCNCRecipes = RM.CNC;
        @Deprecated
        public static RecipeMap sFuelsBurn = FM.Burn;
        @Deprecated
        public static RecipeMap sFuelsGas = FM.Gas;
        @Deprecated
        public static RecipeMap sFuelsHot = FM.Hot;
        @Deprecated
        public static RecipeMap sFuelsPlasma = FM.Plasma;
        @Deprecated
        public static RecipeMap sFuelsEngine = FM.Engine;
        @Deprecated
        public static RecipeMap sFuelsTurbine = FM.Turbine;
        @Deprecated
        public static RecipeMap sFuelsMagic = FM.Magic;

        public RecipeMap(Collection<Recipe> aRecipeList, String aNameInternal, String aNameLocal, String aNameNEI, long aProgressBarDirection, long aProgressBarAmount, String aNEIGUIPath, long aInputItemsCount, long aOutputItemsCount, long aMinimalInputItems, long aInputFluidCount, long aOutputFluidCount, long aMinimalInputFluids, long aMinimalInputs, long aPower, String aNEISpecialValuePre, long aNEISpecialValueMultiplier, String aNEISpecialValuePost, boolean aFuelMap, boolean aShowVoltageAmperageInNEI, boolean aNEIAllowed, boolean aConfigAllowed, boolean aNeedsOutputs, boolean aCombinePower, boolean aUseBucketSizeIn, boolean aUseBucketSizeOut) {
            this.mNEIAllowed = aNEIAllowed;
            this.mShowVoltageAmperageInNEI = aShowVoltageAmperageInNEI;
            this.mNeedsOutputs = aNeedsOutputs;
            this.mCombinePower = aCombinePower;
            this.mUseBucketSizeIn = aUseBucketSizeIn;
            this.mUseBucketSizeOut = aUseBucketSizeOut;
            this.mRecipeList = aRecipeList == null ? new HashSetNoNulls() : aRecipeList;
            this.mNameInternal = aNameInternal;
            this.mNameLocal = aNameLocal;
            StringBuilder tBuilder = new StringBuilder(this.mNameLocal.length());
            for (char tChar : this.mNameLocal.toCharArray()) {
                if (tChar == '(' || tChar == ')' || tChar == '[' || tChar == ']' || tChar == '{' || tChar == '}' || tChar == '\"' || tChar == '\'' || tChar == '<' || tChar == '>' || tChar == '\u00b0' || tChar == '~' || tChar == '$' || tChar == '%' || tChar == '#' || tChar == '+' || tChar == '*' || tChar == '\u00a7' || tChar == '!' || tChar == '?' || tChar == '.' || tChar == ',' || tChar == ':' || tChar == ';') continue;
                if (tChar == ' ' || tChar == '-' || tChar == '=' || tChar == '&' || tChar == '^' || tChar == '|' || tChar == '/' || tChar == '\\') {
                    tBuilder.append('_');
                    continue;
                }
                tBuilder.append(tChar);
            }
            this.mNameLocalUnderscored = tBuilder.toString();
            this.mNameNEI = aNameNEI == null ? this.mNameInternal : aNameNEI;
            this.mGUIPath = aNEIGUIPath.endsWith(".png") ? aNEIGUIPath : aNEIGUIPath + ".png";
            this.mNEISpecialValuePre = aNEISpecialValuePre;
            this.mNEISpecialValueMultiplier = aNEISpecialValueMultiplier;
            this.mNEISpecialValuePost = aNEISpecialValuePost;
            this.mPower = aPower;
            this.mMinimalInputItems = (int)aMinimalInputItems;
            this.mInputItemsCount = (int)Math.max(aInputItemsCount, (long)this.mMinimalInputItems);
            this.mOutputItemsCount = (int)aOutputItemsCount;
            this.mMinimalInputFluids = (int)aMinimalInputFluids;
            this.mInputFluidCount = (int)Math.max(aInputFluidCount, (long)this.mMinimalInputFluids);
            this.mOutputFluidCount = (int)aOutputFluidCount;
            this.mMinimalInputs = (int)aMinimalInputs;
            this.mProgressBarDirection = (byte)aProgressBarDirection;
            this.mProgressBarAmount = (byte)aProgressBarAmount;
            LH.add(this.mNameInternal, this.mNameLocal);
            if (RECIPE_MAPS.containsKey(this.mNameInternal)) {
                throw new IllegalArgumentException("Recipe Map Name already exists: " + this.mNameInternal);
            }
            RECIPE_MAPS.put(this.mNameInternal, this);
            RECIPE_MAP_LIST.add(this);
            if (aFuelMap) {
                FUEL_MAP_LIST.add(this);
            }
            if (aConfigAllowed) {
                if (CS.GAPI.mBeforePreInit != null) {
                    CS.GAPI.mBeforePreInit.add(this);
                } else {
                    this.run();
                }
            }
        }

        public RecipeMap() {
            this(null, "", "", "", 0L, 0L, "", 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, "", 0L, "", false, false, false, false, false, true, true);
            this.mLogErrors = false;
        }

        public String toString() {
            return this.mNameInternal;
        }

        @Override
        public void run() {
            this.mConfigFile = new Config(CS.DirectoriesGT.CONFIG_RECIPES, this.mNameLocalUnderscored + ".cfg");
        }

        @Deprecated
        public RecipeMap(Collection<Recipe> aRecipeList, String aNameInternal, String aNameLocal, String aNameNEI, long aProgressBarDirection, long aProgressBarAmount, String aNEIGUIPath, long aInputItemsCount, long aOutputItemsCount, long aMinimalInputItems, long aInputFluidCount, long aOutputFluidCount, long aMinimalInputFluids, long aMinimalInputs, long aPower, String aNEISpecialValuePre, long aNEISpecialValueMultiplier, String aNEISpecialValuePost, boolean aShowVoltageAmperageInNEI, boolean aNEIAllowed, boolean aConfigAllowed, boolean aNeedsOutputs, boolean aCombinePower, boolean aUseBucketSizeIn, boolean aUseBucketSizeOut) {
            this(aRecipeList, aNameInternal, aNameLocal, aNameNEI, aProgressBarDirection, aProgressBarAmount, aNEIGUIPath, aInputItemsCount, aOutputItemsCount, aMinimalInputItems, aInputFluidCount, aOutputFluidCount, aMinimalInputFluids, aMinimalInputs, aPower, aNEISpecialValuePre, aNEISpecialValueMultiplier, aNEISpecialValuePost, false, aShowVoltageAmperageInNEI, aNEIAllowed, aConfigAllowed, aNeedsOutputs, aCombinePower, aUseBucketSizeIn, aUseBucketSizeOut);
        }

        @Deprecated
        public RecipeMap(Collection<Recipe> aRecipeList, String aNameInternal, String aNameLocal, String aNameNEI, long aProgressBarDirection, long aProgressBarAmount, String aNEIGUIPath, long aInputItemsCount, long aOutputItemsCount, long aMinimalInputItems, long aInputFluidCount, long aOutputFluidCount, long aMinimalInputFluids, long aMinimalInputs, long aPower, String aNEISpecialValuePre, long aNEISpecialValueMultiplier, String aNEISpecialValuePost, boolean aShowVoltageAmperageInNEI, boolean aNEIAllowed, boolean aConfigAllowed, boolean aNeedsOutputs, boolean aCombinePower) {
            this(aRecipeList, aNameInternal, aNameLocal, aNameNEI, aProgressBarDirection, aProgressBarAmount, aNEIGUIPath, aInputItemsCount, aOutputItemsCount, aMinimalInputItems, aInputFluidCount, aOutputFluidCount, aMinimalInputFluids, aMinimalInputs, aPower, aNEISpecialValuePre, aNEISpecialValueMultiplier, aNEISpecialValuePost, aShowVoltageAmperageInNEI, aNEIAllowed, aConfigAllowed, aNeedsOutputs, aCombinePower, true, true);
        }

        @Deprecated
        public RecipeMap(Collection<Recipe> aRecipeList, String aNameInternal, String aNameLocal, String aNameNEI, long aProgressBarDirection, long aProgressBarAmount, String aNEIGUIPath, long aInputItemsCount, long aOutputItemsCount, long aMinimalInputItems, long aInputFluidCount, long aOutputFluidCount, long aMinimalInputFluids, long aMinimalInputs, long aPower, String aNEISpecialValuePre, long aNEISpecialValueMultiplier, String aNEISpecialValuePost, boolean aShowVoltageAmperageInNEI, boolean aNEIAllowed, boolean aConfigAllowed, boolean aNeedsOutputs) {
            this(aRecipeList, aNameInternal, aNameLocal, aNameNEI, aProgressBarDirection, aProgressBarAmount, aNEIGUIPath, aInputItemsCount, aOutputItemsCount, aMinimalInputItems, aInputFluidCount, aOutputFluidCount, aMinimalInputFluids, aMinimalInputs, aPower, aNEISpecialValuePre, aNEISpecialValueMultiplier, aNEISpecialValuePost, aShowVoltageAmperageInNEI, aNEIAllowed, aConfigAllowed, aNeedsOutputs, false);
        }

        @Deprecated
        public RecipeMap(Collection<Recipe> aRecipeList, String aNameInternal, String aNameLocal, String aNameNEI, long aProgressBarDirection, long aProgressBarAmount, String aNEIGUIPath, long aInputItemsCount, long aOutputItemsCount, long aMinimalInputItems, long aInputFluidCount, long aOutputFluidCount, long aMinimalInputFluids, long aPower, String aNEISpecialValuePre, long aNEISpecialValueMultiplier, String aNEISpecialValuePost, boolean aShowVoltageAmperageInNEI, boolean aNEIAllowed, boolean aConfigAllowed, boolean aNeedsOutputs) {
            this(aRecipeList, aNameInternal, aNameLocal, aNameNEI, aProgressBarDirection, aProgressBarAmount, aNEIGUIPath, aInputItemsCount, aOutputItemsCount, aMinimalInputItems, aInputFluidCount, aOutputFluidCount, aMinimalInputFluids, 0L, aPower, aNEISpecialValuePre, aNEISpecialValueMultiplier, aNEISpecialValuePost, aShowVoltageAmperageInNEI, aNEIAllowed, aConfigAllowed, aNeedsOutputs);
        }

        @Deprecated
        public RecipeMap(Collection<Recipe> aRecipeList, String aNameInternal, String aNameLocal, String aNameNEI, long aProgressBarDirection, long aProgressBarAmount, String aNEIGUIPath, long aInputItemsCount, long aOutputItemsCount, long aMinimalInputItems, long aInputFluidCount, long aOutputFluidCount, long aMinimalInputFluids, long aPower, String aNEISpecialValuePre, long aNEISpecialValueMultiplier, String aNEISpecialValuePost, boolean aShowVoltageAmperageInNEI, boolean aNEIAllowed, boolean aConfigAllowed) {
            this(aRecipeList, aNameInternal, aNameLocal, aNameNEI, aProgressBarDirection, aProgressBarAmount, aNEIGUIPath, aInputItemsCount, aOutputItemsCount, aMinimalInputItems, aInputFluidCount, aOutputFluidCount, aMinimalInputFluids, 0L, aPower, aNEISpecialValuePre, aNEISpecialValueMultiplier, aNEISpecialValuePost, aShowVoltageAmperageInNEI, aNEIAllowed, aConfigAllowed, true);
        }

        @Deprecated
        public RecipeMap(Collection<Recipe> aRecipeList, String aNameInternal, String aNameLocal, String aNameNEI, long aProgressBarDirection, long aProgressBarAmount, String aNEIGUIPath, long aInputItemsCount, long aOutputItemsCount, long aMinimalInputItems, long aInputFluidCount, long aOutputFluidCount, long aMinimalInputFluids, long aPower, String aNEISpecialValuePre, long aNEISpecialValueMultiplier, String aNEISpecialValuePost, boolean aShowVoltageAmperageInNEI, boolean aNEIAllowed) {
            this(aRecipeList, aNameInternal, aNameLocal, aNameNEI, aProgressBarDirection, aProgressBarAmount, aNEIGUIPath, aInputItemsCount, aOutputItemsCount, aMinimalInputItems, aInputFluidCount, aOutputFluidCount, aMinimalInputFluids, 0L, aPower, aNEISpecialValuePre, aNEISpecialValueMultiplier, aNEISpecialValuePost, aShowVoltageAmperageInNEI, aNEIAllowed, true, true);
        }

        @Deprecated
        public RecipeMap(Collection<Recipe> aRecipeList, String aNameInternal, String aNameLocal, String aNameNEI, long aProgressBarDirection, long aProgressBarAmount, String aNEIGUIPath, long aInputItemsCount, long aOutputItemsCount, long aMinimalInputItems, long aMinimalInputFluids, long aPower, String aNEISpecialValuePre, long aNEISpecialValueMultiplier, String aNEISpecialValuePost, boolean aShowVoltageAmperageInNEI, boolean aNEIAllowed) {
            this(aRecipeList, aNameInternal, aNameLocal, aNameNEI, aProgressBarDirection, aProgressBarAmount, aNEIGUIPath, aInputItemsCount, aOutputItemsCount, aMinimalInputItems, 0L, 0L, aMinimalInputFluids, 0L, aPower, aNEISpecialValuePre, aNEISpecialValueMultiplier, aNEISpecialValuePost, aShowVoltageAmperageInNEI, aNEIAllowed, true, true);
        }

        @Deprecated
        public RecipeMap(Collection<Recipe> aRecipeList, String aNameInternal, String aNameLocal, String aNameNEI, String aNEIGUIPath, long aInputItemsCount, long aOutputItemsCount, long aMinimalInputItems, long aMinimalInputFluids, long aPower, String aNEISpecialValuePre, long aNEISpecialValueMultiplier, String aNEISpecialValuePost, boolean aShowVoltageAmperageInNEI, boolean aNEIAllowed) {
            this(aRecipeList, aNameInternal, aNameLocal, aNameNEI, 0L, 1L, aNEIGUIPath, aInputItemsCount, aOutputItemsCount, aMinimalInputItems, 0L, 0L, aMinimalInputFluids, 0L, aPower, aNEISpecialValuePre, aNEISpecialValueMultiplier, aNEISpecialValuePost, aShowVoltageAmperageInNEI, aNEIAllowed, true, true);
        }

        public Recipe addRecipe(boolean aOptimize, ItemStack[] aInputs, ItemStack[] aOutputs, Object aSpecial, long[] aOutputChances, FluidStack[] aFluidInputs, FluidStack[] aFluidOutputs, long aDuration, long aEUt, long aSpecialValue) {
            return this.addRecipe(new Recipe(aOptimize, true, true, aInputs, aOutputs, aSpecial, aOutputChances, aFluidInputs, aFluidOutputs, aDuration, aEUt, aSpecialValue));
        }

        public Recipe addRecipe(Recipe aRecipe) {
            return this.addRecipe(aRecipe, true, false, false, true);
        }

        public Recipe addRecipe1(boolean aOptimize, long aEUt, long aDuration, long aChance, ItemStack aInput, ItemStack aOutput) {
            return this.addRecipe(new Recipe(aOptimize, true, true, ST.array(aInput), ST.array(aOutput), CS.NI, new long[]{aChance}, CS.ZL_FS, CS.ZL_FS, aDuration, aEUt, 0L));
        }

        public Recipe addRecipe2(boolean aOptimize, long aEUt, long aDuration, long aChance, ItemStack aInput1, ItemStack aInput2, ItemStack aOutput) {
            return this.addRecipe(new Recipe(aOptimize, true, true, ST.array(aInput1, aInput2), ST.array(aOutput), CS.NI, new long[]{aChance}, CS.ZL_FS, CS.ZL_FS, aDuration, aEUt, 0L));
        }

        public Recipe addRecipeX(boolean aOptimize, long aEUt, long aDuration, long aChance, ItemStack[] aInputs, ItemStack aOutput) {
            return this.addRecipe(new Recipe(aOptimize, true, true, aInputs, ST.array(aOutput), CS.NI, new long[]{aChance}, CS.ZL_FS, CS.ZL_FS, aDuration, aEUt, 0L));
        }

        public Recipe addRecipe1(boolean aOptimize, long aEUt, long aDuration, ItemStack aInput, ItemStack ... aOutputs) {
            return this.addRecipe(new Recipe(aOptimize, true, true, ST.array(aInput), aOutputs, CS.NI, CS.ZL_LONG, CS.ZL_FS, CS.ZL_FS, aDuration, aEUt, 0L));
        }

        public Recipe addRecipe2(boolean aOptimize, long aEUt, long aDuration, ItemStack aInput1, ItemStack aInput2, ItemStack ... aOutputs) {
            return this.addRecipe(new Recipe(aOptimize, true, true, ST.array(aInput1, aInput2), aOutputs, CS.NI, CS.ZL_LONG, CS.ZL_FS, CS.ZL_FS, aDuration, aEUt, 0L));
        }

        public Recipe addRecipeX(boolean aOptimize, long aEUt, long aDuration, ItemStack[] aInputs, ItemStack ... aOutputs) {
            return this.addRecipe(new Recipe(aOptimize, true, true, aInputs, aOutputs, CS.NI, CS.ZL_LONG, CS.ZL_FS, CS.ZL_FS, aDuration, aEUt, 0L));
        }

        public Recipe addRecipe1(boolean aOptimize, long aEUt, long aDuration, long[] aChances, ItemStack aInput, ItemStack ... aOutputs) {
            return this.addRecipe(new Recipe(aOptimize, true, true, ST.array(aInput), aOutputs, CS.NI, aChances, CS.ZL_FS, CS.ZL_FS, aDuration, aEUt, 0L));
        }

        public Recipe addRecipe2(boolean aOptimize, long aEUt, long aDuration, long[] aChances, ItemStack aInput1, ItemStack aInput2, ItemStack ... aOutputs) {
            return this.addRecipe(new Recipe(aOptimize, true, true, ST.array(aInput1, aInput2), aOutputs, CS.NI, aChances, CS.ZL_FS, CS.ZL_FS, aDuration, aEUt, 0L));
        }

        public Recipe addRecipeX(boolean aOptimize, long aEUt, long aDuration, long[] aChances, ItemStack[] aInputs, ItemStack ... aOutputs) {
            return this.addRecipe(new Recipe(aOptimize, true, true, aInputs, aOutputs, CS.NI, aChances, CS.ZL_FS, CS.ZL_FS, aDuration, aEUt, 0L));
        }

        public Recipe addRecipe0(boolean aOptimize, long aEUt, long aDuration, long aChance, FluidStack aFluidInput, FluidStack aFluidOutput, ItemStack aOutput) {
            return this.addRecipe(new Recipe(aOptimize, true, true, CS.ZL_IS, ST.array(aOutput), CS.NI, new long[]{aChance}, FL.array(aFluidInput), FL.array(aFluidOutput), aDuration, aEUt, 0L));
        }

        public Recipe addRecipe1(boolean aOptimize, long aEUt, long aDuration, long aChance, ItemStack aInput, FluidStack aFluidInput, FluidStack aFluidOutput, ItemStack aOutput) {
            return this.addRecipe(new Recipe(aOptimize, true, true, ST.array(aInput), ST.array(aOutput), CS.NI, new long[]{aChance}, FL.array(aFluidInput), FL.array(aFluidOutput), aDuration, aEUt, 0L));
        }

        public Recipe addRecipe2(boolean aOptimize, long aEUt, long aDuration, long aChance, ItemStack aInput1, ItemStack aInput2, FluidStack aFluidInput, FluidStack aFluidOutput, ItemStack aOutput) {
            return this.addRecipe(new Recipe(aOptimize, true, true, ST.array(aInput1, aInput2), ST.array(aOutput), CS.NI, new long[]{aChance}, FL.array(aFluidInput), FL.array(aFluidOutput), aDuration, aEUt, 0L));
        }

        public Recipe addRecipeX(boolean aOptimize, long aEUt, long aDuration, long aChance, ItemStack[] aInputs, FluidStack aFluidInput, FluidStack aFluidOutput, ItemStack aOutput) {
            return this.addRecipe(new Recipe(aOptimize, true, true, aInputs, ST.array(aOutput), CS.NI, new long[]{aChance}, FL.array(aFluidInput), FL.array(aFluidOutput), aDuration, aEUt, 0L));
        }

        public Recipe addRecipe0(boolean aOptimize, long aEUt, long aDuration, FluidStack aFluidInput, FluidStack aFluidOutput, ItemStack ... aOutputs) {
            return this.addRecipe(new Recipe(aOptimize, true, true, CS.ZL_IS, aOutputs, CS.NI, CS.ZL_LONG, FL.array(aFluidInput), FL.array(aFluidOutput), aDuration, aEUt, 0L));
        }

        public Recipe addRecipe1(boolean aOptimize, long aEUt, long aDuration, ItemStack aInput, FluidStack aFluidInput, FluidStack aFluidOutput, ItemStack ... aOutputs) {
            return this.addRecipe(new Recipe(aOptimize, true, true, ST.array(aInput), aOutputs, CS.NI, CS.ZL_LONG, FL.array(aFluidInput), FL.array(aFluidOutput), aDuration, aEUt, 0L));
        }

        public Recipe addRecipe2(boolean aOptimize, long aEUt, long aDuration, ItemStack aInput1, ItemStack aInput2, FluidStack aFluidInput, FluidStack aFluidOutput, ItemStack ... aOutputs) {
            return this.addRecipe(new Recipe(aOptimize, true, true, ST.array(aInput1, aInput2), aOutputs, CS.NI, CS.ZL_LONG, FL.array(aFluidInput), FL.array(aFluidOutput), aDuration, aEUt, 0L));
        }

        public Recipe addRecipeX(boolean aOptimize, long aEUt, long aDuration, ItemStack[] aInputs, FluidStack aFluidInput, FluidStack aFluidOutput, ItemStack ... aOutputs) {
            return this.addRecipe(new Recipe(aOptimize, true, true, aInputs, aOutputs, CS.NI, CS.ZL_LONG, FL.array(aFluidInput), FL.array(aFluidOutput), aDuration, aEUt, 0L));
        }

        public Recipe addRecipe0(boolean aOptimize, long aEUt, long aDuration, long[] aChances, FluidStack aFluidInput, FluidStack aFluidOutput, ItemStack ... aOutputs) {
            return this.addRecipe(new Recipe(aOptimize, true, true, CS.ZL_IS, aOutputs, CS.NI, aChances, FL.array(aFluidInput), FL.array(aFluidOutput), aDuration, aEUt, 0L));
        }

        public Recipe addRecipe1(boolean aOptimize, long aEUt, long aDuration, long[] aChances, ItemStack aInput, FluidStack aFluidInput, FluidStack aFluidOutput, ItemStack ... aOutputs) {
            return this.addRecipe(new Recipe(aOptimize, true, true, ST.array(aInput), aOutputs, CS.NI, aChances, FL.array(aFluidInput), FL.array(aFluidOutput), aDuration, aEUt, 0L));
        }

        public Recipe addRecipe2(boolean aOptimize, long aEUt, long aDuration, long[] aChances, ItemStack aInput1, ItemStack aInput2, FluidStack aFluidInput, FluidStack aFluidOutput, ItemStack ... aOutputs) {
            return this.addRecipe(new Recipe(aOptimize, true, true, ST.array(aInput1, aInput2), aOutputs, CS.NI, aChances, FL.array(aFluidInput), FL.array(aFluidOutput), aDuration, aEUt, 0L));
        }

        public Recipe addRecipeX(boolean aOptimize, long aEUt, long aDuration, long[] aChances, ItemStack[] aInputs, FluidStack aFluidInput, FluidStack aFluidOutput, ItemStack ... aOutputs) {
            return this.addRecipe(new Recipe(aOptimize, true, true, aInputs, aOutputs, CS.NI, aChances, FL.array(aFluidInput), FL.array(aFluidOutput), aDuration, aEUt, 0L));
        }

        public Recipe addRecipe0(boolean aOptimize, long aEUt, long aDuration, FluidStack aFluidInput, FluidStack ... aFluidOutputs) {
            return this.addRecipe(new Recipe(aOptimize, true, true, CS.ZL_IS, CS.ZL_IS, CS.NI, CS.ZL_LONG, FL.array(aFluidInput), aFluidOutputs, aDuration, aEUt, 0L));
        }

        public Recipe addRecipe1(boolean aOptimize, long aEUt, long aDuration, ItemStack aInput, FluidStack aFluidInput, FluidStack ... aFluidOutputs) {
            return this.addRecipe(new Recipe(aOptimize, true, true, ST.array(aInput), CS.ZL_IS, CS.NI, CS.ZL_LONG, FL.array(aFluidInput), aFluidOutputs, aDuration, aEUt, 0L));
        }

        public Recipe addRecipe2(boolean aOptimize, long aEUt, long aDuration, ItemStack aInput1, ItemStack aInput2, FluidStack aFluidInput, FluidStack ... aFluidOutputs) {
            return this.addRecipe(new Recipe(aOptimize, true, true, ST.array(aInput1, aInput2), CS.ZL_IS, CS.NI, CS.ZL_LONG, FL.array(aFluidInput), aFluidOutputs, aDuration, aEUt, 0L));
        }

        public Recipe addRecipeX(boolean aOptimize, long aEUt, long aDuration, ItemStack[] aInputs, FluidStack aFluidInput, FluidStack ... aFluidOutputs) {
            return this.addRecipe(new Recipe(aOptimize, true, true, aInputs, CS.ZL_IS, CS.NI, CS.ZL_LONG, FL.array(aFluidInput), aFluidOutputs, aDuration, aEUt, 0L));
        }

        public Recipe addRecipe0(boolean aOptimize, long aEUt, long aDuration, long aChance, FluidStack[] aFluidInputs, FluidStack aFluidOutput, ItemStack aOutput) {
            return this.addRecipe(new Recipe(aOptimize, true, true, CS.ZL_IS, ST.array(aOutput), CS.NI, new long[]{aChance}, aFluidInputs, FL.array(aFluidOutput), aDuration, aEUt, 0L));
        }

        public Recipe addRecipe1(boolean aOptimize, long aEUt, long aDuration, long aChance, ItemStack aInput, FluidStack[] aFluidInputs, FluidStack aFluidOutput, ItemStack aOutput) {
            return this.addRecipe(new Recipe(aOptimize, true, true, ST.array(aInput), ST.array(aOutput), CS.NI, new long[]{aChance}, aFluidInputs, FL.array(aFluidOutput), aDuration, aEUt, 0L));
        }

        public Recipe addRecipe2(boolean aOptimize, long aEUt, long aDuration, long aChance, ItemStack aInput1, ItemStack aInput2, FluidStack[] aFluidInputs, FluidStack aFluidOutput, ItemStack aOutput) {
            return this.addRecipe(new Recipe(aOptimize, true, true, ST.array(aInput1, aInput2), ST.array(aOutput), CS.NI, new long[]{aChance}, aFluidInputs, FL.array(aFluidOutput), aDuration, aEUt, 0L));
        }

        public Recipe addRecipeX(boolean aOptimize, long aEUt, long aDuration, long aChance, ItemStack[] aInputs, FluidStack[] aFluidInputs, FluidStack aFluidOutput, ItemStack aOutput) {
            return this.addRecipe(new Recipe(aOptimize, true, true, aInputs, ST.array(aOutput), CS.NI, new long[]{aChance}, aFluidInputs, FL.array(aFluidOutput), aDuration, aEUt, 0L));
        }

        public Recipe addRecipe0(boolean aOptimize, long aEUt, long aDuration, FluidStack[] aFluidInputs, FluidStack aFluidOutput, ItemStack ... aOutputs) {
            return this.addRecipe(new Recipe(aOptimize, true, true, CS.ZL_IS, aOutputs, CS.NI, CS.ZL_LONG, aFluidInputs, FL.array(aFluidOutput), aDuration, aEUt, 0L));
        }

        public Recipe addRecipe1(boolean aOptimize, long aEUt, long aDuration, ItemStack aInput, FluidStack[] aFluidInputs, FluidStack aFluidOutput, ItemStack ... aOutputs) {
            return this.addRecipe(new Recipe(aOptimize, true, true, ST.array(aInput), aOutputs, CS.NI, CS.ZL_LONG, aFluidInputs, FL.array(aFluidOutput), aDuration, aEUt, 0L));
        }

        public Recipe addRecipe2(boolean aOptimize, long aEUt, long aDuration, ItemStack aInput1, ItemStack aInput2, FluidStack[] aFluidInputs, FluidStack aFluidOutput, ItemStack ... aOutputs) {
            return this.addRecipe(new Recipe(aOptimize, true, true, ST.array(aInput1, aInput2), aOutputs, CS.NI, CS.ZL_LONG, aFluidInputs, FL.array(aFluidOutput), aDuration, aEUt, 0L));
        }

        public Recipe addRecipeX(boolean aOptimize, long aEUt, long aDuration, ItemStack[] aInputs, FluidStack[] aFluidInputs, FluidStack aFluidOutput, ItemStack ... aOutputs) {
            return this.addRecipe(new Recipe(aOptimize, true, true, aInputs, aOutputs, CS.NI, CS.ZL_LONG, aFluidInputs, FL.array(aFluidOutput), aDuration, aEUt, 0L));
        }

        public Recipe addRecipe0(boolean aOptimize, long aEUt, long aDuration, long[] aChances, FluidStack[] aFluidInputs, FluidStack aFluidOutput, ItemStack ... aOutputs) {
            return this.addRecipe(new Recipe(aOptimize, true, true, CS.ZL_IS, aOutputs, CS.NI, aChances, aFluidInputs, FL.array(aFluidOutput), aDuration, aEUt, 0L));
        }

        public Recipe addRecipe1(boolean aOptimize, long aEUt, long aDuration, long[] aChances, ItemStack aInput, FluidStack[] aFluidInputs, FluidStack aFluidOutput, ItemStack ... aOutputs) {
            return this.addRecipe(new Recipe(aOptimize, true, true, ST.array(aInput), aOutputs, CS.NI, aChances, aFluidInputs, FL.array(aFluidOutput), aDuration, aEUt, 0L));
        }

        public Recipe addRecipe2(boolean aOptimize, long aEUt, long aDuration, long[] aChances, ItemStack aInput1, ItemStack aInput2, FluidStack[] aFluidInputs, FluidStack aFluidOutput, ItemStack ... aOutputs) {
            return this.addRecipe(new Recipe(aOptimize, true, true, ST.array(aInput1, aInput2), aOutputs, CS.NI, aChances, aFluidInputs, FL.array(aFluidOutput), aDuration, aEUt, 0L));
        }

        public Recipe addRecipeX(boolean aOptimize, long aEUt, long aDuration, long[] aChances, ItemStack[] aInputs, FluidStack[] aFluidInputs, FluidStack aFluidOutput, ItemStack ... aOutputs) {
            return this.addRecipe(new Recipe(aOptimize, true, true, aInputs, aOutputs, CS.NI, aChances, aFluidInputs, FL.array(aFluidOutput), aDuration, aEUt, 0L));
        }

        public Recipe addRecipe0(boolean aOptimize, long aEUt, long aDuration, FluidStack[] aFluidInputs, FluidStack ... aFluidOutputs) {
            return this.addRecipe(new Recipe(aOptimize, true, true, CS.ZL_IS, CS.ZL_IS, CS.NI, CS.ZL_LONG, aFluidInputs, aFluidOutputs, aDuration, aEUt, 0L));
        }

        public Recipe addRecipe1(boolean aOptimize, long aEUt, long aDuration, ItemStack aInput, FluidStack[] aFluidInputs, FluidStack ... aFluidOutputs) {
            return this.addRecipe(new Recipe(aOptimize, true, true, ST.array(aInput), CS.ZL_IS, CS.NI, CS.ZL_LONG, aFluidInputs, aFluidOutputs, aDuration, aEUt, 0L));
        }

        public Recipe addRecipe2(boolean aOptimize, long aEUt, long aDuration, ItemStack aInput1, ItemStack aInput2, FluidStack[] aFluidInputs, FluidStack ... aFluidOutputs) {
            return this.addRecipe(new Recipe(aOptimize, true, true, ST.array(aInput1, aInput2), CS.ZL_IS, CS.NI, CS.ZL_LONG, aFluidInputs, aFluidOutputs, aDuration, aEUt, 0L));
        }

        public Recipe addRecipeX(boolean aOptimize, long aEUt, long aDuration, ItemStack[] aInputs, FluidStack[] aFluidInputs, FluidStack ... aFluidOutputs) {
            return this.addRecipe(new Recipe(aOptimize, true, true, aInputs, CS.ZL_IS, CS.NI, CS.ZL_LONG, aFluidInputs, aFluidOutputs, aDuration, aEUt, 0L));
        }

        public Recipe addRecipe0(boolean aOptimize, long aEUt, long aDuration, long aChance, FluidStack[] aFluidInputs, FluidStack[] aFluidOutputs, ItemStack aOutput) {
            return this.addRecipe(new Recipe(aOptimize, true, true, CS.ZL_IS, ST.array(aOutput), CS.NI, new long[]{aChance}, aFluidInputs, aFluidOutputs, aDuration, aEUt, 0L));
        }

        public Recipe addRecipe1(boolean aOptimize, long aEUt, long aDuration, long aChance, ItemStack aInput, FluidStack[] aFluidInputs, FluidStack[] aFluidOutputs, ItemStack aOutput) {
            return this.addRecipe(new Recipe(aOptimize, true, true, ST.array(aInput), ST.array(aOutput), CS.NI, new long[]{aChance}, aFluidInputs, aFluidOutputs, aDuration, aEUt, 0L));
        }

        public Recipe addRecipe2(boolean aOptimize, long aEUt, long aDuration, long aChance, ItemStack aInput1, ItemStack aInput2, FluidStack[] aFluidInputs, FluidStack[] aFluidOutputs, ItemStack aOutput) {
            return this.addRecipe(new Recipe(aOptimize, true, true, ST.array(aInput1, aInput2), ST.array(aOutput), CS.NI, new long[]{aChance}, aFluidInputs, aFluidOutputs, aDuration, aEUt, 0L));
        }

        public Recipe addRecipeX(boolean aOptimize, long aEUt, long aDuration, long aChance, ItemStack[] aInputs, FluidStack[] aFluidInputs, FluidStack[] aFluidOutputs, ItemStack aOutput) {
            return this.addRecipe(new Recipe(aOptimize, true, true, aInputs, ST.array(aOutput), CS.NI, new long[]{aChance}, aFluidInputs, aFluidOutputs, aDuration, aEUt, 0L));
        }

        public Recipe addRecipe0(boolean aOptimize, long aEUt, long aDuration, FluidStack[] aFluidInputs, FluidStack[] aFluidOutputs, ItemStack ... aOutputs) {
            return this.addRecipe(new Recipe(aOptimize, true, true, CS.ZL_IS, aOutputs, CS.NI, CS.ZL_LONG, aFluidInputs, aFluidOutputs, aDuration, aEUt, 0L));
        }

        public Recipe addRecipe1(boolean aOptimize, long aEUt, long aDuration, ItemStack aInput, FluidStack[] aFluidInputs, FluidStack[] aFluidOutputs, ItemStack ... aOutputs) {
            return this.addRecipe(new Recipe(aOptimize, true, true, ST.array(aInput), aOutputs, CS.NI, CS.ZL_LONG, aFluidInputs, aFluidOutputs, aDuration, aEUt, 0L));
        }

        public Recipe addRecipe2(boolean aOptimize, long aEUt, long aDuration, ItemStack aInput1, ItemStack aInput2, FluidStack[] aFluidInputs, FluidStack[] aFluidOutputs, ItemStack ... aOutputs) {
            return this.addRecipe(new Recipe(aOptimize, true, true, ST.array(aInput1, aInput2), aOutputs, CS.NI, CS.ZL_LONG, aFluidInputs, aFluidOutputs, aDuration, aEUt, 0L));
        }

        public Recipe addRecipeX(boolean aOptimize, long aEUt, long aDuration, ItemStack[] aInputs, FluidStack[] aFluidInputs, FluidStack[] aFluidOutputs, ItemStack ... aOutputs) {
            return this.addRecipe(new Recipe(aOptimize, true, true, aInputs, aOutputs, CS.NI, CS.ZL_LONG, aFluidInputs, aFluidOutputs, aDuration, aEUt, 0L));
        }

        public Recipe addRecipe0(boolean aOptimize, long aEUt, long aDuration, long[] aChances, FluidStack[] aFluidInputs, FluidStack[] aFluidOutputs, ItemStack ... aOutputs) {
            return this.addRecipe(new Recipe(aOptimize, true, true, CS.ZL_IS, aOutputs, CS.NI, aChances, aFluidInputs, aFluidOutputs, aDuration, aEUt, 0L));
        }

        public Recipe addRecipe1(boolean aOptimize, long aEUt, long aDuration, long[] aChances, ItemStack aInput, FluidStack[] aFluidInputs, FluidStack[] aFluidOutputs, ItemStack ... aOutputs) {
            return this.addRecipe(new Recipe(aOptimize, true, true, ST.array(aInput), aOutputs, CS.NI, aChances, aFluidInputs, aFluidOutputs, aDuration, aEUt, 0L));
        }

        public Recipe addRecipe2(boolean aOptimize, long aEUt, long aDuration, long[] aChances, ItemStack aInput1, ItemStack aInput2, FluidStack[] aFluidInputs, FluidStack[] aFluidOutputs, ItemStack ... aOutputs) {
            return this.addRecipe(new Recipe(aOptimize, true, true, ST.array(aInput1, aInput2), aOutputs, CS.NI, aChances, aFluidInputs, aFluidOutputs, aDuration, aEUt, 0L));
        }

        public Recipe addRecipeX(boolean aOptimize, long aEUt, long aDuration, long[] aChances, ItemStack[] aInputs, FluidStack[] aFluidInputs, FluidStack[] aFluidOutputs, ItemStack ... aOutputs) {
            return this.addRecipe(new Recipe(aOptimize, true, true, aInputs, aOutputs, CS.NI, aChances, aFluidInputs, aFluidOutputs, aDuration, aEUt, 0L));
        }

        public Recipe addRecipe1(boolean aOptimize, boolean aCheckForCollisions, boolean aFakeRecipe, boolean aHidden, boolean aLogErrors, long aEUt, long aDuration, long aChance, ItemStack aInput, ItemStack aOutput) {
            return this.addRecipe(new Recipe(aOptimize, true, true, ST.array(aInput), ST.array(aOutput), CS.NI, new long[]{aChance}, CS.ZL_FS, CS.ZL_FS, aDuration, aEUt, 0L), aCheckForCollisions, aFakeRecipe, aHidden, aLogErrors);
        }

        public Recipe addRecipe2(boolean aOptimize, boolean aCheckForCollisions, boolean aFakeRecipe, boolean aHidden, boolean aLogErrors, long aEUt, long aDuration, long aChance, ItemStack aInput1, ItemStack aInput2, ItemStack aOutput) {
            return this.addRecipe(new Recipe(aOptimize, true, true, ST.array(aInput1, aInput2), ST.array(aOutput), CS.NI, new long[]{aChance}, CS.ZL_FS, CS.ZL_FS, aDuration, aEUt, 0L), aCheckForCollisions, aFakeRecipe, aHidden, aLogErrors);
        }

        public Recipe addRecipeX(boolean aOptimize, boolean aCheckForCollisions, boolean aFakeRecipe, boolean aHidden, boolean aLogErrors, long aEUt, long aDuration, long aChance, ItemStack[] aInputs, ItemStack aOutput) {
            return this.addRecipe(new Recipe(aOptimize, true, true, aInputs, ST.array(aOutput), CS.NI, new long[]{aChance}, CS.ZL_FS, CS.ZL_FS, aDuration, aEUt, 0L), aCheckForCollisions, aFakeRecipe, aHidden, aLogErrors);
        }

        public Recipe addRecipe1(boolean aOptimize, boolean aCheckForCollisions, boolean aFakeRecipe, boolean aHidden, boolean aLogErrors, long aEUt, long aDuration, ItemStack aInput, ItemStack ... aOutputs) {
            return this.addRecipe(new Recipe(aOptimize, true, true, ST.array(aInput), aOutputs, CS.NI, CS.ZL_LONG, CS.ZL_FS, CS.ZL_FS, aDuration, aEUt, 0L), aCheckForCollisions, aFakeRecipe, aHidden, aLogErrors);
        }

        public Recipe addRecipe2(boolean aOptimize, boolean aCheckForCollisions, boolean aFakeRecipe, boolean aHidden, boolean aLogErrors, long aEUt, long aDuration, ItemStack aInput1, ItemStack aInput2, ItemStack ... aOutputs) {
            return this.addRecipe(new Recipe(aOptimize, true, true, ST.array(aInput1, aInput2), aOutputs, CS.NI, CS.ZL_LONG, CS.ZL_FS, CS.ZL_FS, aDuration, aEUt, 0L), aCheckForCollisions, aFakeRecipe, aHidden, aLogErrors);
        }

        public Recipe addRecipeX(boolean aOptimize, boolean aCheckForCollisions, boolean aFakeRecipe, boolean aHidden, boolean aLogErrors, long aEUt, long aDuration, ItemStack[] aInputs, ItemStack ... aOutputs) {
            return this.addRecipe(new Recipe(aOptimize, true, true, aInputs, aOutputs, CS.NI, CS.ZL_LONG, CS.ZL_FS, CS.ZL_FS, aDuration, aEUt, 0L), aCheckForCollisions, aFakeRecipe, aHidden, aLogErrors);
        }

        public Recipe addRecipe1(boolean aOptimize, boolean aCheckForCollisions, boolean aFakeRecipe, boolean aHidden, boolean aLogErrors, long aEUt, long aDuration, long[] aChances, ItemStack aInput, ItemStack ... aOutputs) {
            return this.addRecipe(new Recipe(aOptimize, true, true, ST.array(aInput), aOutputs, CS.NI, aChances, CS.ZL_FS, CS.ZL_FS, aDuration, aEUt, 0L), aCheckForCollisions, aFakeRecipe, aHidden, aLogErrors);
        }

        public Recipe addRecipe2(boolean aOptimize, boolean aCheckForCollisions, boolean aFakeRecipe, boolean aHidden, boolean aLogErrors, long aEUt, long aDuration, long[] aChances, ItemStack aInput1, ItemStack aInput2, ItemStack ... aOutputs) {
            return this.addRecipe(new Recipe(aOptimize, true, true, ST.array(aInput1, aInput2), aOutputs, CS.NI, aChances, CS.ZL_FS, CS.ZL_FS, aDuration, aEUt, 0L), aCheckForCollisions, aFakeRecipe, aHidden, aLogErrors);
        }

        public Recipe addRecipeX(boolean aOptimize, boolean aCheckForCollisions, boolean aFakeRecipe, boolean aHidden, boolean aLogErrors, long aEUt, long aDuration, long[] aChances, ItemStack[] aInputs, ItemStack ... aOutputs) {
            return this.addRecipe(new Recipe(aOptimize, true, true, aInputs, aOutputs, CS.NI, aChances, CS.ZL_FS, CS.ZL_FS, aDuration, aEUt, 0L), aCheckForCollisions, aFakeRecipe, aHidden, aLogErrors);
        }

        public Recipe addRecipe0(boolean aOptimize, boolean aCheckForCollisions, boolean aFakeRecipe, boolean aHidden, boolean aLogErrors, long aEUt, long aDuration, long aChance, FluidStack aFluidInput, FluidStack aFluidOutput, ItemStack aOutput) {
            return this.addRecipe(new Recipe(aOptimize, true, true, CS.ZL_IS, ST.array(aOutput), CS.NI, new long[]{aChance}, FL.array(aFluidInput), FL.array(aFluidOutput), aDuration, aEUt, 0L), aCheckForCollisions, aFakeRecipe, aHidden, aLogErrors);
        }

        public Recipe addRecipe1(boolean aOptimize, boolean aCheckForCollisions, boolean aFakeRecipe, boolean aHidden, boolean aLogErrors, long aEUt, long aDuration, long aChance, ItemStack aInput, FluidStack aFluidInput, FluidStack aFluidOutput, ItemStack aOutput) {
            return this.addRecipe(new Recipe(aOptimize, true, true, ST.array(aInput), ST.array(aOutput), CS.NI, new long[]{aChance}, FL.array(aFluidInput), FL.array(aFluidOutput), aDuration, aEUt, 0L), aCheckForCollisions, aFakeRecipe, aHidden, aLogErrors);
        }

        public Recipe addRecipe2(boolean aOptimize, boolean aCheckForCollisions, boolean aFakeRecipe, boolean aHidden, boolean aLogErrors, long aEUt, long aDuration, long aChance, ItemStack aInput1, ItemStack aInput2, FluidStack aFluidInput, FluidStack aFluidOutput, ItemStack aOutput) {
            return this.addRecipe(new Recipe(aOptimize, true, true, ST.array(aInput1, aInput2), ST.array(aOutput), CS.NI, new long[]{aChance}, FL.array(aFluidInput), FL.array(aFluidOutput), aDuration, aEUt, 0L), aCheckForCollisions, aFakeRecipe, aHidden, aLogErrors);
        }

        public Recipe addRecipeX(boolean aOptimize, boolean aCheckForCollisions, boolean aFakeRecipe, boolean aHidden, boolean aLogErrors, long aEUt, long aDuration, long aChance, ItemStack[] aInputs, FluidStack aFluidInput, FluidStack aFluidOutput, ItemStack aOutput) {
            return this.addRecipe(new Recipe(aOptimize, true, true, aInputs, ST.array(aOutput), CS.NI, new long[]{aChance}, FL.array(aFluidInput), FL.array(aFluidOutput), aDuration, aEUt, 0L), aCheckForCollisions, aFakeRecipe, aHidden, aLogErrors);
        }

        public Recipe addRecipe0(boolean aOptimize, boolean aCheckForCollisions, boolean aFakeRecipe, boolean aHidden, boolean aLogErrors, long aEUt, long aDuration, FluidStack aFluidInput, FluidStack aFluidOutput, ItemStack ... aOutputs) {
            return this.addRecipe(new Recipe(aOptimize, true, true, CS.ZL_IS, aOutputs, CS.NI, CS.ZL_LONG, FL.array(aFluidInput), FL.array(aFluidOutput), aDuration, aEUt, 0L), aCheckForCollisions, aFakeRecipe, aHidden, aLogErrors);
        }

        public Recipe addRecipe1(boolean aOptimize, boolean aCheckForCollisions, boolean aFakeRecipe, boolean aHidden, boolean aLogErrors, long aEUt, long aDuration, ItemStack aInput, FluidStack aFluidInput, FluidStack aFluidOutput, ItemStack ... aOutputs) {
            return this.addRecipe(new Recipe(aOptimize, true, true, ST.array(aInput), aOutputs, CS.NI, CS.ZL_LONG, FL.array(aFluidInput), FL.array(aFluidOutput), aDuration, aEUt, 0L), aCheckForCollisions, aFakeRecipe, aHidden, aLogErrors);
        }

        public Recipe addRecipe2(boolean aOptimize, boolean aCheckForCollisions, boolean aFakeRecipe, boolean aHidden, boolean aLogErrors, long aEUt, long aDuration, ItemStack aInput1, ItemStack aInput2, FluidStack aFluidInput, FluidStack aFluidOutput, ItemStack ... aOutputs) {
            return this.addRecipe(new Recipe(aOptimize, true, true, ST.array(aInput1, aInput2), aOutputs, CS.NI, CS.ZL_LONG, FL.array(aFluidInput), FL.array(aFluidOutput), aDuration, aEUt, 0L), aCheckForCollisions, aFakeRecipe, aHidden, aLogErrors);
        }

        public Recipe addRecipeX(boolean aOptimize, boolean aCheckForCollisions, boolean aFakeRecipe, boolean aHidden, boolean aLogErrors, long aEUt, long aDuration, ItemStack[] aInputs, FluidStack aFluidInput, FluidStack aFluidOutput, ItemStack ... aOutputs) {
            return this.addRecipe(new Recipe(aOptimize, true, true, aInputs, aOutputs, CS.NI, CS.ZL_LONG, FL.array(aFluidInput), FL.array(aFluidOutput), aDuration, aEUt, 0L), aCheckForCollisions, aFakeRecipe, aHidden, aLogErrors);
        }

        public Recipe addRecipe0(boolean aOptimize, boolean aCheckForCollisions, boolean aFakeRecipe, boolean aHidden, boolean aLogErrors, long aEUt, long aDuration, long[] aChances, FluidStack aFluidInput, FluidStack aFluidOutput, ItemStack ... aOutputs) {
            return this.addRecipe(new Recipe(aOptimize, true, true, CS.ZL_IS, aOutputs, CS.NI, aChances, FL.array(aFluidInput), FL.array(aFluidOutput), aDuration, aEUt, 0L), aCheckForCollisions, aFakeRecipe, aHidden, aLogErrors);
        }

        public Recipe addRecipe1(boolean aOptimize, boolean aCheckForCollisions, boolean aFakeRecipe, boolean aHidden, boolean aLogErrors, long aEUt, long aDuration, long[] aChances, ItemStack aInput, FluidStack aFluidInput, FluidStack aFluidOutput, ItemStack ... aOutputs) {
            return this.addRecipe(new Recipe(aOptimize, true, true, ST.array(aInput), aOutputs, CS.NI, aChances, FL.array(aFluidInput), FL.array(aFluidOutput), aDuration, aEUt, 0L), aCheckForCollisions, aFakeRecipe, aHidden, aLogErrors);
        }

        public Recipe addRecipe2(boolean aOptimize, boolean aCheckForCollisions, boolean aFakeRecipe, boolean aHidden, boolean aLogErrors, long aEUt, long aDuration, long[] aChances, ItemStack aInput1, ItemStack aInput2, FluidStack aFluidInput, FluidStack aFluidOutput, ItemStack ... aOutputs) {
            return this.addRecipe(new Recipe(aOptimize, true, true, ST.array(aInput1, aInput2), aOutputs, CS.NI, aChances, FL.array(aFluidInput), FL.array(aFluidOutput), aDuration, aEUt, 0L), aCheckForCollisions, aFakeRecipe, aHidden, aLogErrors);
        }

        public Recipe addRecipeX(boolean aOptimize, boolean aCheckForCollisions, boolean aFakeRecipe, boolean aHidden, boolean aLogErrors, long aEUt, long aDuration, long[] aChances, ItemStack[] aInputs, FluidStack aFluidInput, FluidStack aFluidOutput, ItemStack ... aOutputs) {
            return this.addRecipe(new Recipe(aOptimize, true, true, aInputs, aOutputs, CS.NI, aChances, FL.array(aFluidInput), FL.array(aFluidOutput), aDuration, aEUt, 0L), aCheckForCollisions, aFakeRecipe, aHidden, aLogErrors);
        }

        public Recipe addRecipe0(boolean aOptimize, boolean aCheckForCollisions, boolean aFakeRecipe, boolean aHidden, boolean aLogErrors, long aEUt, long aDuration, FluidStack aFluidInput, FluidStack ... aFluidOutputs) {
            return this.addRecipe(new Recipe(aOptimize, true, true, CS.ZL_IS, CS.ZL_IS, CS.NI, CS.ZL_LONG, FL.array(aFluidInput), aFluidOutputs, aDuration, aEUt, 0L), aCheckForCollisions, aFakeRecipe, aHidden, aLogErrors);
        }

        public Recipe addRecipe1(boolean aOptimize, boolean aCheckForCollisions, boolean aFakeRecipe, boolean aHidden, boolean aLogErrors, long aEUt, long aDuration, ItemStack aInput, FluidStack aFluidInput, FluidStack ... aFluidOutputs) {
            return this.addRecipe(new Recipe(aOptimize, true, true, ST.array(aInput), CS.ZL_IS, CS.NI, CS.ZL_LONG, FL.array(aFluidInput), aFluidOutputs, aDuration, aEUt, 0L), aCheckForCollisions, aFakeRecipe, aHidden, aLogErrors);
        }

        public Recipe addRecipe2(boolean aOptimize, boolean aCheckForCollisions, boolean aFakeRecipe, boolean aHidden, boolean aLogErrors, long aEUt, long aDuration, ItemStack aInput1, ItemStack aInput2, FluidStack aFluidInput, FluidStack ... aFluidOutputs) {
            return this.addRecipe(new Recipe(aOptimize, true, true, ST.array(aInput1, aInput2), CS.ZL_IS, CS.NI, CS.ZL_LONG, FL.array(aFluidInput), aFluidOutputs, aDuration, aEUt, 0L), aCheckForCollisions, aFakeRecipe, aHidden, aLogErrors);
        }

        public Recipe addRecipeX(boolean aOptimize, boolean aCheckForCollisions, boolean aFakeRecipe, boolean aHidden, boolean aLogErrors, long aEUt, long aDuration, ItemStack[] aInputs, FluidStack aFluidInput, FluidStack ... aFluidOutputs) {
            return this.addRecipe(new Recipe(aOptimize, true, true, aInputs, CS.ZL_IS, CS.NI, CS.ZL_LONG, FL.array(aFluidInput), aFluidOutputs, aDuration, aEUt, 0L), aCheckForCollisions, aFakeRecipe, aHidden, aLogErrors);
        }

        public Recipe addRecipe0(boolean aOptimize, boolean aCheckForCollisions, boolean aFakeRecipe, boolean aHidden, boolean aLogErrors, long aEUt, long aDuration, long aChance, FluidStack[] aFluidInputs, FluidStack aFluidOutput, ItemStack aOutput) {
            return this.addRecipe(new Recipe(aOptimize, true, true, CS.ZL_IS, ST.array(aOutput), CS.NI, new long[]{aChance}, aFluidInputs, FL.array(aFluidOutput), aDuration, aEUt, 0L), aCheckForCollisions, aFakeRecipe, aHidden, aLogErrors);
        }

        public Recipe addRecipe1(boolean aOptimize, boolean aCheckForCollisions, boolean aFakeRecipe, boolean aHidden, boolean aLogErrors, long aEUt, long aDuration, long aChance, ItemStack aInput, FluidStack[] aFluidInputs, FluidStack aFluidOutput, ItemStack aOutput) {
            return this.addRecipe(new Recipe(aOptimize, true, true, ST.array(aInput), ST.array(aOutput), CS.NI, new long[]{aChance}, aFluidInputs, FL.array(aFluidOutput), aDuration, aEUt, 0L), aCheckForCollisions, aFakeRecipe, aHidden, aLogErrors);
        }

        public Recipe addRecipe2(boolean aOptimize, boolean aCheckForCollisions, boolean aFakeRecipe, boolean aHidden, boolean aLogErrors, long aEUt, long aDuration, long aChance, ItemStack aInput1, ItemStack aInput2, FluidStack[] aFluidInputs, FluidStack aFluidOutput, ItemStack aOutput) {
            return this.addRecipe(new Recipe(aOptimize, true, true, ST.array(aInput1, aInput2), ST.array(aOutput), CS.NI, new long[]{aChance}, aFluidInputs, FL.array(aFluidOutput), aDuration, aEUt, 0L), aCheckForCollisions, aFakeRecipe, aHidden, aLogErrors);
        }

        public Recipe addRecipeX(boolean aOptimize, boolean aCheckForCollisions, boolean aFakeRecipe, boolean aHidden, boolean aLogErrors, long aEUt, long aDuration, long aChance, ItemStack[] aInputs, FluidStack[] aFluidInputs, FluidStack aFluidOutput, ItemStack aOutput) {
            return this.addRecipe(new Recipe(aOptimize, true, true, aInputs, ST.array(aOutput), CS.NI, new long[]{aChance}, aFluidInputs, FL.array(aFluidOutput), aDuration, aEUt, 0L), aCheckForCollisions, aFakeRecipe, aHidden, aLogErrors);
        }

        public Recipe addRecipe0(boolean aOptimize, boolean aCheckForCollisions, boolean aFakeRecipe, boolean aHidden, boolean aLogErrors, long aEUt, long aDuration, FluidStack[] aFluidInputs, FluidStack aFluidOutput, ItemStack ... aOutputs) {
            return this.addRecipe(new Recipe(aOptimize, true, true, CS.ZL_IS, aOutputs, CS.NI, CS.ZL_LONG, aFluidInputs, FL.array(aFluidOutput), aDuration, aEUt, 0L), aCheckForCollisions, aFakeRecipe, aHidden, aLogErrors);
        }

        public Recipe addRecipe1(boolean aOptimize, boolean aCheckForCollisions, boolean aFakeRecipe, boolean aHidden, boolean aLogErrors, long aEUt, long aDuration, ItemStack aInput, FluidStack[] aFluidInputs, FluidStack aFluidOutput, ItemStack ... aOutputs) {
            return this.addRecipe(new Recipe(aOptimize, true, true, ST.array(aInput), aOutputs, CS.NI, CS.ZL_LONG, aFluidInputs, FL.array(aFluidOutput), aDuration, aEUt, 0L), aCheckForCollisions, aFakeRecipe, aHidden, aLogErrors);
        }

        public Recipe addRecipe2(boolean aOptimize, boolean aCheckForCollisions, boolean aFakeRecipe, boolean aHidden, boolean aLogErrors, long aEUt, long aDuration, ItemStack aInput1, ItemStack aInput2, FluidStack[] aFluidInputs, FluidStack aFluidOutput, ItemStack ... aOutputs) {
            return this.addRecipe(new Recipe(aOptimize, true, true, ST.array(aInput1, aInput2), aOutputs, CS.NI, CS.ZL_LONG, aFluidInputs, FL.array(aFluidOutput), aDuration, aEUt, 0L), aCheckForCollisions, aFakeRecipe, aHidden, aLogErrors);
        }

        public Recipe addRecipeX(boolean aOptimize, boolean aCheckForCollisions, boolean aFakeRecipe, boolean aHidden, boolean aLogErrors, long aEUt, long aDuration, ItemStack[] aInputs, FluidStack[] aFluidInputs, FluidStack aFluidOutput, ItemStack ... aOutputs) {
            return this.addRecipe(new Recipe(aOptimize, true, true, aInputs, aOutputs, CS.NI, CS.ZL_LONG, aFluidInputs, FL.array(aFluidOutput), aDuration, aEUt, 0L), aCheckForCollisions, aFakeRecipe, aHidden, aLogErrors);
        }

        public Recipe addRecipe0(boolean aOptimize, boolean aCheckForCollisions, boolean aFakeRecipe, boolean aHidden, boolean aLogErrors, long aEUt, long aDuration, long[] aChances, FluidStack[] aFluidInputs, FluidStack aFluidOutput, ItemStack ... aOutputs) {
            return this.addRecipe(new Recipe(aOptimize, true, true, CS.ZL_IS, aOutputs, CS.NI, aChances, aFluidInputs, FL.array(aFluidOutput), aDuration, aEUt, 0L), aCheckForCollisions, aFakeRecipe, aHidden, aLogErrors);
        }

        public Recipe addRecipe1(boolean aOptimize, boolean aCheckForCollisions, boolean aFakeRecipe, boolean aHidden, boolean aLogErrors, long aEUt, long aDuration, long[] aChances, ItemStack aInput, FluidStack[] aFluidInputs, FluidStack aFluidOutput, ItemStack ... aOutputs) {
            return this.addRecipe(new Recipe(aOptimize, true, true, ST.array(aInput), aOutputs, CS.NI, aChances, aFluidInputs, FL.array(aFluidOutput), aDuration, aEUt, 0L), aCheckForCollisions, aFakeRecipe, aHidden, aLogErrors);
        }

        public Recipe addRecipe2(boolean aOptimize, boolean aCheckForCollisions, boolean aFakeRecipe, boolean aHidden, boolean aLogErrors, long aEUt, long aDuration, long[] aChances, ItemStack aInput1, ItemStack aInput2, FluidStack[] aFluidInputs, FluidStack aFluidOutput, ItemStack ... aOutputs) {
            return this.addRecipe(new Recipe(aOptimize, true, true, ST.array(aInput1, aInput2), aOutputs, CS.NI, aChances, aFluidInputs, FL.array(aFluidOutput), aDuration, aEUt, 0L), aCheckForCollisions, aFakeRecipe, aHidden, aLogErrors);
        }

        public Recipe addRecipeX(boolean aOptimize, boolean aCheckForCollisions, boolean aFakeRecipe, boolean aHidden, boolean aLogErrors, long aEUt, long aDuration, long[] aChances, ItemStack[] aInputs, FluidStack[] aFluidInputs, FluidStack aFluidOutput, ItemStack ... aOutputs) {
            return this.addRecipe(new Recipe(aOptimize, true, true, aInputs, aOutputs, CS.NI, aChances, aFluidInputs, FL.array(aFluidOutput), aDuration, aEUt, 0L), aCheckForCollisions, aFakeRecipe, aHidden, aLogErrors);
        }

        public Recipe addRecipe0(boolean aOptimize, boolean aCheckForCollisions, boolean aFakeRecipe, boolean aHidden, boolean aLogErrors, long aEUt, long aDuration, FluidStack[] aFluidInputs, FluidStack ... aFluidOutputs) {
            return this.addRecipe(new Recipe(aOptimize, true, true, CS.ZL_IS, CS.ZL_IS, CS.NI, CS.ZL_LONG, aFluidInputs, aFluidOutputs, aDuration, aEUt, 0L), aCheckForCollisions, aFakeRecipe, aHidden, aLogErrors);
        }

        public Recipe addRecipe1(boolean aOptimize, boolean aCheckForCollisions, boolean aFakeRecipe, boolean aHidden, boolean aLogErrors, long aEUt, long aDuration, ItemStack aInput, FluidStack[] aFluidInputs, FluidStack ... aFluidOutputs) {
            return this.addRecipe(new Recipe(aOptimize, true, true, ST.array(aInput), CS.ZL_IS, CS.NI, CS.ZL_LONG, aFluidInputs, aFluidOutputs, aDuration, aEUt, 0L), aCheckForCollisions, aFakeRecipe, aHidden, aLogErrors);
        }

        public Recipe addRecipe2(boolean aOptimize, boolean aCheckForCollisions, boolean aFakeRecipe, boolean aHidden, boolean aLogErrors, long aEUt, long aDuration, ItemStack aInput1, ItemStack aInput2, FluidStack[] aFluidInputs, FluidStack ... aFluidOutputs) {
            return this.addRecipe(new Recipe(aOptimize, true, true, ST.array(aInput1, aInput2), CS.ZL_IS, CS.NI, CS.ZL_LONG, aFluidInputs, aFluidOutputs, aDuration, aEUt, 0L), aCheckForCollisions, aFakeRecipe, aHidden, aLogErrors);
        }

        public Recipe addRecipeX(boolean aOptimize, boolean aCheckForCollisions, boolean aFakeRecipe, boolean aHidden, boolean aLogErrors, long aEUt, long aDuration, ItemStack[] aInputs, FluidStack[] aFluidInputs, FluidStack ... aFluidOutputs) {
            return this.addRecipe(new Recipe(aOptimize, true, true, aInputs, CS.ZL_IS, CS.NI, CS.ZL_LONG, aFluidInputs, aFluidOutputs, aDuration, aEUt, 0L), aCheckForCollisions, aFakeRecipe, aHidden, aLogErrors);
        }

        public Recipe addRecipe0(boolean aOptimize, boolean aCheckForCollisions, boolean aFakeRecipe, boolean aHidden, boolean aLogErrors, long aEUt, long aDuration, long aChance, FluidStack[] aFluidInputs, FluidStack[] aFluidOutputs, ItemStack aOutput) {
            return this.addRecipe(new Recipe(aOptimize, true, true, CS.ZL_IS, ST.array(aOutput), CS.NI, new long[]{aChance}, aFluidInputs, aFluidOutputs, aDuration, aEUt, 0L), aCheckForCollisions, aFakeRecipe, aHidden, aLogErrors);
        }

        public Recipe addRecipe1(boolean aOptimize, boolean aCheckForCollisions, boolean aFakeRecipe, boolean aHidden, boolean aLogErrors, long aEUt, long aDuration, long aChance, ItemStack aInput, FluidStack[] aFluidInputs, FluidStack[] aFluidOutputs, ItemStack aOutput) {
            return this.addRecipe(new Recipe(aOptimize, true, true, ST.array(aInput), ST.array(aOutput), CS.NI, new long[]{aChance}, aFluidInputs, aFluidOutputs, aDuration, aEUt, 0L), aCheckForCollisions, aFakeRecipe, aHidden, aLogErrors);
        }

        public Recipe addRecipe2(boolean aOptimize, boolean aCheckForCollisions, boolean aFakeRecipe, boolean aHidden, boolean aLogErrors, long aEUt, long aDuration, long aChance, ItemStack aInput1, ItemStack aInput2, FluidStack[] aFluidInputs, FluidStack[] aFluidOutputs, ItemStack aOutput) {
            return this.addRecipe(new Recipe(aOptimize, true, true, ST.array(aInput1, aInput2), ST.array(aOutput), CS.NI, new long[]{aChance}, aFluidInputs, aFluidOutputs, aDuration, aEUt, 0L), aCheckForCollisions, aFakeRecipe, aHidden, aLogErrors);
        }

        public Recipe addRecipeX(boolean aOptimize, boolean aCheckForCollisions, boolean aFakeRecipe, boolean aHidden, boolean aLogErrors, long aEUt, long aDuration, long aChance, ItemStack[] aInputs, FluidStack[] aFluidInputs, FluidStack[] aFluidOutputs, ItemStack aOutput) {
            return this.addRecipe(new Recipe(aOptimize, true, true, aInputs, ST.array(aOutput), CS.NI, new long[]{aChance}, aFluidInputs, aFluidOutputs, aDuration, aEUt, 0L), aCheckForCollisions, aFakeRecipe, aHidden, aLogErrors);
        }

        public Recipe addRecipe0(boolean aOptimize, boolean aCheckForCollisions, boolean aFakeRecipe, boolean aHidden, boolean aLogErrors, long aEUt, long aDuration, FluidStack[] aFluidInputs, FluidStack[] aFluidOutputs, ItemStack ... aOutputs) {
            return this.addRecipe(new Recipe(aOptimize, true, true, CS.ZL_IS, aOutputs, CS.NI, CS.ZL_LONG, aFluidInputs, aFluidOutputs, aDuration, aEUt, 0L), aCheckForCollisions, aFakeRecipe, aHidden, aLogErrors);
        }

        public Recipe addRecipe1(boolean aOptimize, boolean aCheckForCollisions, boolean aFakeRecipe, boolean aHidden, boolean aLogErrors, long aEUt, long aDuration, ItemStack aInput, FluidStack[] aFluidInputs, FluidStack[] aFluidOutputs, ItemStack ... aOutputs) {
            return this.addRecipe(new Recipe(aOptimize, true, true, ST.array(aInput), aOutputs, CS.NI, CS.ZL_LONG, aFluidInputs, aFluidOutputs, aDuration, aEUt, 0L), aCheckForCollisions, aFakeRecipe, aHidden, aLogErrors);
        }

        public Recipe addRecipe2(boolean aOptimize, boolean aCheckForCollisions, boolean aFakeRecipe, boolean aHidden, boolean aLogErrors, long aEUt, long aDuration, ItemStack aInput1, ItemStack aInput2, FluidStack[] aFluidInputs, FluidStack[] aFluidOutputs, ItemStack ... aOutputs) {
            return this.addRecipe(new Recipe(aOptimize, true, true, ST.array(aInput1, aInput2), aOutputs, CS.NI, CS.ZL_LONG, aFluidInputs, aFluidOutputs, aDuration, aEUt, 0L), aCheckForCollisions, aFakeRecipe, aHidden, aLogErrors);
        }

        public Recipe addRecipeX(boolean aOptimize, boolean aCheckForCollisions, boolean aFakeRecipe, boolean aHidden, boolean aLogErrors, long aEUt, long aDuration, ItemStack[] aInputs, FluidStack[] aFluidInputs, FluidStack[] aFluidOutputs, ItemStack ... aOutputs) {
            return this.addRecipe(new Recipe(aOptimize, true, true, aInputs, aOutputs, CS.NI, CS.ZL_LONG, aFluidInputs, aFluidOutputs, aDuration, aEUt, 0L), aCheckForCollisions, aFakeRecipe, aHidden, aLogErrors);
        }

        public Recipe addRecipe0(boolean aOptimize, boolean aCheckForCollisions, boolean aFakeRecipe, boolean aHidden, boolean aLogErrors, long aEUt, long aDuration, long[] aChances, FluidStack[] aFluidInputs, FluidStack[] aFluidOutputs, ItemStack ... aOutputs) {
            return this.addRecipe(new Recipe(aOptimize, true, true, CS.ZL_IS, aOutputs, CS.NI, aChances, aFluidInputs, aFluidOutputs, aDuration, aEUt, 0L), aCheckForCollisions, aFakeRecipe, aHidden, aLogErrors);
        }

        public Recipe addRecipe1(boolean aOptimize, boolean aCheckForCollisions, boolean aFakeRecipe, boolean aHidden, boolean aLogErrors, long aEUt, long aDuration, long[] aChances, ItemStack aInput, FluidStack[] aFluidInputs, FluidStack[] aFluidOutputs, ItemStack ... aOutputs) {
            return this.addRecipe(new Recipe(aOptimize, true, true, ST.array(aInput), aOutputs, CS.NI, aChances, aFluidInputs, aFluidOutputs, aDuration, aEUt, 0L), aCheckForCollisions, aFakeRecipe, aHidden, aLogErrors);
        }

        public Recipe addRecipe2(boolean aOptimize, boolean aCheckForCollisions, boolean aFakeRecipe, boolean aHidden, boolean aLogErrors, long aEUt, long aDuration, long[] aChances, ItemStack aInput1, ItemStack aInput2, FluidStack[] aFluidInputs, FluidStack[] aFluidOutputs, ItemStack ... aOutputs) {
            return this.addRecipe(new Recipe(aOptimize, true, true, ST.array(aInput1, aInput2), aOutputs, CS.NI, aChances, aFluidInputs, aFluidOutputs, aDuration, aEUt, 0L), aCheckForCollisions, aFakeRecipe, aHidden, aLogErrors);
        }

        public Recipe addRecipeX(boolean aOptimize, boolean aCheckForCollisions, boolean aFakeRecipe, boolean aHidden, boolean aLogErrors, long aEUt, long aDuration, long[] aChances, ItemStack[] aInputs, FluidStack[] aFluidInputs, FluidStack[] aFluidOutputs, ItemStack ... aOutputs) {
            return this.addRecipe(new Recipe(aOptimize, true, true, aInputs, aOutputs, CS.NI, aChances, aFluidInputs, aFluidOutputs, aDuration, aEUt, 0L), aCheckForCollisions, aFakeRecipe, aHidden, aLogErrors);
        }

        public Recipe addRecipe(Recipe aRecipe, boolean aCheckForCollisions, boolean aFakeRecipe, boolean aHidden, boolean aLogErrors) {
            if (aRecipe == null) {
                return null;
            }
            aRecipe.mHidden = aHidden;
            aRecipe.mFakeRecipe = aFakeRecipe;
            if (aCheckForCollisions && this.findRecipeInternal(null, null, false, false, Long.MAX_VALUE, null, aRecipe.mFluidInputs, aRecipe.mInputs) != null) {
                return null;
            }
            return this.add(aRecipe, aLogErrors && this.mLogErrors);
        }

        public Recipe addRecipe(Recipe aRecipe, boolean aCheckForCollisions, boolean aFakeRecipe, boolean aHidden) {
            return this.addRecipe(aRecipe, aCheckForCollisions, aFakeRecipe, aHidden, this.mLogErrors);
        }

        public Recipe addFakeRecipe(boolean aCheckForCollisions, ItemStack[] aInputs, ItemStack[] aOutputs, Object aSpecial, long[] aOutputChances, FluidStack[] aFluidInputs, FluidStack[] aFluidOutputs, long aDuration, long aEUt, long aSpecialValue) {
            return this.addFakeRecipe(aCheckForCollisions, new Recipe(false, false, false, aInputs, aOutputs, aSpecial, aOutputChances, aFluidInputs, aFluidOutputs, aDuration, aEUt, aSpecialValue));
        }

        public Recipe addFakeRecipe(boolean aCheckForCollisions, ItemStack[] aInputs, ItemStack[] aOutputs, Object aSpecial, FluidStack[] aFluidInputs, FluidStack[] aFluidOutputs, long aDuration, long aEUt, long aSpecialValue) {
            return this.addFakeRecipe(aCheckForCollisions, new Recipe(false, false, false, aInputs, aOutputs, aSpecial, null, aFluidInputs, aFluidOutputs, aDuration, aEUt, aSpecialValue));
        }

        public Recipe addFakeRecipe(boolean aCheckForCollisions, Recipe aRecipe) {
            return this.addRecipe(aRecipe, aCheckForCollisions, true, false, this.mLogErrors);
        }

        public Recipe add(Recipe aRecipe) {
            return this.add(aRecipe, this.mLogErrors);
        }

        public Recipe add(Recipe aRecipe, boolean aLogErrors) {
            return this.add(aRecipe, aLogErrors, !aRecipe.mFakeRecipe && aRecipe.mCanBeBuffered);
        }

        public synchronized Recipe add(Recipe aRecipe, boolean aLogErrors, boolean aAddConfig) {
            if (!aRecipe.mFakeRecipe) {
                boolean tErrored = false;
                boolean tFailed = false;
                if (aRecipe.mInputs.length + aRecipe.mFluidInputs.length <= 0) {
                    if (aLogErrors) {
                        CS.ERR.println("ERROR: Recipe has no Inputs!");
                    }
                    tFailed = true;
                } else {
                    if (this.mNeedsOutputs && aRecipe.mOutputs.length + aRecipe.mFluidOutputs.length <= 0) {
                        if (aLogErrors) {
                            CS.ERR.println("ERROR: Recipe has no Outputs!");
                        }
                        tFailed = true;
                    }
                    if (aRecipe.mInputs.length < this.mMinimalInputItems) {
                        if (aLogErrors) {
                            CS.ERR.println("ERROR: Recipe has less than the minimal amount of Input ItemStacks!");
                        }
                        tFailed = true;
                    }
                    if (aRecipe.mFluidInputs.length < this.mMinimalInputFluids) {
                        if (aLogErrors) {
                            CS.ERR.println("ERROR: Recipe has less than the minimal amount of Input FluidStacks!");
                        }
                        tFailed = true;
                    }
                    if (aRecipe.mFluidInputs.length + aRecipe.mInputs.length < this.mMinimalInputs) {
                        if (aLogErrors) {
                            CS.ERR.println("ERROR: Recipe has less than the minimal amount of general Inputs!");
                        }
                        tFailed = true;
                    }
                    if (aRecipe.mInputs.length > this.mInputItemsCount) {
                        if (aLogErrors) {
                            CS.ERR.println("ERROR: Recipe has more than the maximum amount of Input ItemStacks!");
                        }
                        tFailed = true;
                    }
                    if (aRecipe.mFluidInputs.length > this.mInputFluidCount) {
                        if (aLogErrors) {
                            CS.ERR.println("ERROR: Recipe has more than the maximum amount of Input FluidStacks!");
                        }
                        tFailed = true;
                    }
                }
                if (aRecipe.mOutputs.length > this.mOutputItemsCount) {
                    if (aLogErrors) {
                        CS.ERR.println("WARNING: Recipe has more than the maximum amount of Output ItemStacks!");
                    }
                    tErrored = true;
                }
                if (aRecipe.mFluidOutputs.length > this.mOutputFluidCount) {
                    if (aLogErrors) {
                        CS.ERR.println("WARNING: Recipe has more than the maximum amount of Output FluidStacks!");
                    }
                    tErrored = true;
                }
                if (aRecipe.mDuration == 0L) {
                    if (aLogErrors) {
                        CS.ERR.println("WARNING: Recipe has no Duration Value!");
                    }
                    tErrored = true;
                }
                if (tErrored || tFailed) {
                    if (aLogErrors) {
                        CS.ERR.println("Recipe Map: " + this.mNameInternal);
                        CS.ERR.println("Input Items:  " + ST.names(aRecipe.mInputs));
                        CS.ERR.println("Input Fluid:  " + FL.configNames(aRecipe.mFluidInputs));
                        CS.ERR.println("Output Items: " + ST.names(aRecipe.mOutputs));
                        CS.ERR.println("Output Fluid: " + FL.configNames(aRecipe.mFluidOutputs));
                        int i = 0;
                        for (StackTraceElement tElement : new Exception().getStackTrace()) {
                            if (tElement.getClassName().equals(RecipeMap.class.getName())) continue;
                            if (i++ >= 5 || tElement.getClassName().startsWith("sun")) break;
                            CS.ERR.println("\tat " + tElement);
                        }
                    }
                    if (tFailed) {
                        return null;
                    }
                }
            }
            for (FluidStack tFluid : aRecipe.mFluidInputs) {
                if (!FL.Error.is(tFluid)) continue;
                CS.ERR.println("Compat: The Fluid for a Recipe has not been found! This might just be for a Mod that is not installed or updated enough!");
                CS.ERR.println("Input Items:  " + ST.names(aRecipe.mInputs));
                CS.ERR.println("Input Fluid:  " + FL.configNames(aRecipe.mFluidInputs));
                CS.ERR.println("Output Items: " + ST.names(aRecipe.mOutputs));
                CS.ERR.println("Output Fluid: " + FL.configNames(aRecipe.mFluidOutputs));
                int i = 0;
                for (StackTraceElement tElement : new Exception().getStackTrace()) {
                    if (tElement.getClassName().equals(RecipeMap.class.getName())) continue;
                    if (i++ >= 5 || tElement.getClassName().startsWith("sun")) break;
                    CS.ERR.println("\tat " + tElement);
                }
                return null;
            }
            if (aAddConfig && this.mConfigFile != null) {
                String tConfigName = "";
                if (aRecipe.mInputs.length > 0) {
                    tConfigName = tConfigName + ST.configNames(aRecipe.mInputs);
                }
                if (aRecipe.mFluidInputs.length > 0) {
                    tConfigName = tConfigName + FL.configNames(aRecipe.mFluidInputs);
                }
                if (UT.Code.stringValid(tConfigName)) {
                    aRecipe.mDuration = this.mConfigFile.get((Object)this.mNameLocalUnderscored, tConfigName, aRecipe.mEnabled ? aRecipe.mDuration : 0L);
                    boolean bl = aRecipe.mEnabled = aRecipe.mDuration > 0L;
                }
            }
            if (!aRecipe.mEnabled || !this.mRecipeList.add(aRecipe)) {
                return null;
            }
            ++this.mRecipeListSize;
            for (FluidStack aFluid : aRecipe.mFluidInputs) {
                if (aFluid == null) continue;
                String aFluidName = aFluid.getFluid().getName();
                this.mMaxFluidInputSize = Math.max(this.mMaxFluidInputSize, aFluid.amount);
                Collection<Recipe> tList = this.mRecipeFluidMap.get(aFluidName);
                if (tList == null) {
                    tList = new HashSet<Recipe>(1);
                    this.mRecipeFluidMap.put(aFluidName, tList);
                }
                tList.add(aRecipe);
                Long tSize = this.mMinInputTankSizes.get(aFluidName);
                if (tSize != null && tSize >= (long)aFluid.amount) continue;
                this.mMinInputTankSizes.put(aFluidName, Long.valueOf(aFluid.amount));
            }
            for (FluidStack aFluid : aRecipe.mFluidOutputs) {
                if (aFluid == null) continue;
                this.mMaxFluidOutputSize = Math.max(this.mMaxFluidOutputSize, aFluid.amount);
            }
            return this.addToItemMap(aRecipe);
        }

        public void reInit() {
            this.mRecipeItemMap.clear();
            for (Recipe tRecipe : this.mRecipeList) {
                OreDictManager.INSTANCE.setStackArray(true, tRecipe.mInputs);
                OreDictManager.INSTANCE.setStackArray(true, tRecipe.mOutputs);
                this.addToItemMap(tRecipe);
            }
            this.mRecipeListSize = this.mRecipeList.size();
        }

        public boolean add(IRecipeMapHandler aRecipeMapHandler) {
            return this.mRecipeMapHandlers.add(aRecipeMapHandler) && aRecipeMapHandler.onAddedToMap(this);
        }

        public Slot_Base getSpecialSlot(ITileEntityInventoryGUI aInventory, int aIndex, int aX, int aY) {
            return null;
        }

        public boolean containsInput(ItemStack aStack, IHasWorldAndCoords aTileEntity, ItemStack aSpecialSlot) {
            if (ST.invalid(aStack)) {
                return false;
            }
            if (this.mRecipeItemMap.containsKey(ST.item_(aStack), (long)ST.meta_(aStack), true)) {
                return true;
            }
            if (this.mRecipeMapHandlers.isEmpty()) {
                return false;
            }
            OreDictItemData aData = OM.data_(aStack);
            for (IRecipeMapHandler tHandler : this.mRecipeMapHandlers) {
                if (!tHandler.containsInput(this, aStack, aData)) continue;
                return true;
            }
            return false;
        }

        public boolean containsInput(FluidStack aFluid, IHasWorldAndCoords aTileEntity, ItemStack aSpecialSlot) {
            return aFluid != null && this.containsInput(aFluid.getFluid(), aTileEntity, aSpecialSlot);
        }

        public boolean containsInput(Fluid aFluid, IHasWorldAndCoords aTileEntity, ItemStack aSpecialSlot) {
            if (aFluid == null) {
                return false;
            }
            if (this.mRecipeFluidMap.containsKey(aFluid.getName())) {
                return true;
            }
            if (this.mRecipeMapHandlers.isEmpty()) {
                return false;
            }
            for (IRecipeMapHandler tHandler : this.mRecipeMapHandlers) {
                if (!tHandler.containsInput(this, aFluid)) continue;
                return true;
            }
            return false;
        }

        public long minTankSize(Fluid aFluid) {
            if (aFluid == null) {
                return 1000L;
            }
            Long tSize = this.mMinInputTankSizes.get(aFluid.getName());
            return tSize == null ? 1000L : Math.max(1000L, tSize);
        }

        public Recipe findRecipe(IHasWorldAndCoords aTileEntity, Recipe aRecipe, boolean aNotUnificated, long aSize, ItemStack aSpecialSlot, FluidStack[] aFluids, ItemStack ... aInputs) {
            return this.findRecipeInternal(aTileEntity, aRecipe, true, aNotUnificated, aSize, aSpecialSlot, aFluids, aInputs);
        }

        public final Recipe findRecipe(IHasWorldAndCoords aTileEntity, Recipe aRecipe, boolean aNotUnificated, long aSize, ItemStack aSpecialSlot, IFluidTank[] aTanks, ItemStack ... aInputs) {
            FluidStack[] aFluids = new FluidStack[aTanks.length];
            for (int i = 0; i < aFluids.length; ++i) {
                aFluids[i] = aTanks[i].getFluid();
            }
            return this.findRecipe(aTileEntity, aRecipe, aNotUnificated, aSize, aSpecialSlot, aFluids, aInputs);
        }

        public Recipe findRecipeInternal(IHasWorldAndCoords aTileEntity, Recipe aRecipe, boolean aLoop, boolean aNotUnificated, long aSize, ItemStack aSpecialSlot, FluidStack[] aFluids, ItemStack ... aInputs) {
            if (this.mRecipeList.isEmpty() && (!aLoop || this.mRecipeMapHandlers.isEmpty())) {
                return null;
            }
            if (CS.GAPI_POST.mFinishedServerStarted > 0) {
                long tItemAmount = UT.Code.getNonNulls(aInputs);
                if (tItemAmount < (long)this.mMinimalInputItems) {
                    return null;
                }
                long tFluidAmount = UT.Code.getNonNulls(aFluids);
                if (tFluidAmount < (long)this.mMinimalInputFluids) {
                    return null;
                }
                if (tFluidAmount + tItemAmount < (long)this.mMinimalInputs) {
                    return null;
                }
            }
            if (aNotUnificated) {
                aInputs = OreDictManager.INSTANCE.getStackArray(true, aInputs);
            }
            if (aRecipe != null && !aRecipe.mFakeRecipe && aRecipe.mCanBeBuffered && aRecipe.isRecipeInputEqual(false, true, aFluids, aInputs)) {
                return aRecipe.mEnabled && UT.Code.abs_greater_equal(aSize * this.mPower, aRecipe.mEUt) ? (this.oRecipe = aRecipe) : null;
            }
            if (this.oRecipe != null && !this.oRecipe.mFakeRecipe && this.oRecipe.mCanBeBuffered && this.oRecipe.isRecipeInputEqual(false, true, aFluids, aInputs)) {
                return this.oRecipe.mEnabled && UT.Code.abs_greater_equal(aSize * this.mPower, this.oRecipe.mEUt) ? this.oRecipe : null;
            }
            if (aLoop && this.mRecipeListSize != this.mRecipeList.size()) {
                CS.ERR.println("RecipeMap for " + this.mNameLocal + " got changed without re-initializing the HashMaps! This is a Bug of whatever Recipe Tweaker Mod you are using!");
                this.reInit();
            }
            try {
                Collection<Recipe> tRecipes;
                if (this.mInputItemsCount > 0) {
                    for (ItemStack itemStack : aInputs) {
                        Object tStack2;
                        if (itemStack == null) continue;
                        tRecipes = this.mRecipeItemMap.get(itemStack);
                        if (tRecipes != null) {
                            for (Recipe recipe : tRecipes) {
                                if (recipe.mFakeRecipe || !recipe.isRecipeInputEqual(false, true, aFluids, aInputs)) continue;
                                return recipe.mEnabled && UT.Code.abs_greater_equal(aSize * this.mPower, recipe.mEUt) ? (this.oRecipe = recipe) : null;
                            }
                        }
                        if ((tRecipes = this.mRecipeItemMap.get(itemStack, 32767L)) != null) {
                            for (Recipe recipe : tRecipes) {
                                if (recipe.mFakeRecipe || !recipe.isRecipeInputEqual(false, true, aFluids, aInputs)) continue;
                                return recipe.mEnabled && UT.Code.abs_greater_equal(aSize * this.mPower, recipe.mEUt) ? (this.oRecipe = recipe) : null;
                            }
                        }
                        if (!ST.equal(itemStack, (ItemStack)(tStack2 = OreDictManager.INSTANCE.getStack_(false, itemStack)), true) && (tRecipes = this.mRecipeItemMap.get((ItemStack)tStack2)) != null) {
                            for (Recipe tRecipe : tRecipes) {
                                if (tRecipe.mFakeRecipe || !tRecipe.isRecipeInputEqual(false, true, aFluids, aInputs)) continue;
                                return tRecipe.mEnabled && UT.Code.abs_greater_equal(aSize * this.mPower, tRecipe.mEUt) ? (this.oRecipe = tRecipe) : null;
                            }
                        }
                        if (itemStack.getItem() == tStack2.getItem() || (tRecipes = this.mRecipeItemMap.get((ItemStack)tStack2, 32767L)) == null) continue;
                        for (Recipe tRecipe : tRecipes) {
                            if (tRecipe.mFakeRecipe || !tRecipe.isRecipeInputEqual(false, true, aFluids, aInputs)) continue;
                            return tRecipe.mEnabled && UT.Code.abs_greater_equal(aSize * this.mPower, tRecipe.mEUt) ? (this.oRecipe = tRecipe) : null;
                        }
                    }
                }
                if (this.mInputFluidCount > 0 && this.mMinimalInputItems == 0) {
                    for (FluidStack fluidStack : aFluids) {
                        if (fluidStack == null || (tRecipes = this.mRecipeFluidMap.get(fluidStack.getFluid().getName())) == null) continue;
                        for (Recipe recipe : tRecipes) {
                            if (recipe.mFakeRecipe || !recipe.isRecipeInputEqual(false, true, aFluids, aInputs)) continue;
                            return recipe.mEnabled && UT.Code.abs_greater_equal(aSize * this.mPower, recipe.mEUt) ? (this.oRecipe = recipe) : null;
                        }
                    }
                }
                if (aLoop && !this.mRecipeMapHandlers.isEmpty()) {
                    for (int i = 0; i < this.mRecipeMapHandlers.size(); ++i) {
                        IRecipeMapHandler tHandler = this.mRecipeMapHandlers.get(i);
                        if (!tHandler.isDone()) continue;
                        this.mRecipeMapHandlers.remove(tHandler);
                    }
                    if (!this.mRecipeMapHandlers.isEmpty()) {
                        aLoop = false;
                        for (ItemStack itemStack : aInputs) {
                            if (!ST.valid(itemStack)) continue;
                            OreDictItemData tData = OM.data_(itemStack);
                            for (IRecipeMapHandler iRecipeMapHandler : this.mRecipeMapHandlers) {
                                if (!iRecipeMapHandler.addRecipesUsing(this, false, itemStack, tData)) continue;
                                aLoop = true;
                            }
                        }
                        for (ItemStack itemStack : aFluids) {
                            if (itemStack == null) continue;
                            for (IRecipeMapHandler tHandler : this.mRecipeMapHandlers) {
                                if (!tHandler.addRecipesUsing(this, false, itemStack.getFluid())) continue;
                                aLoop = true;
                            }
                        }
                        if (aLoop) {
                            return this.findRecipeInternal(aTileEntity, aRecipe, false, aNotUnificated, aSize, aSpecialSlot, aFluids, aInputs);
                        }
                    }
                }
            }
            catch (ConcurrentModificationException e) {
                e.printStackTrace(CS.ERR);
                return this.findRecipeInternal(aTileEntity, null, false, false, aSize, aSpecialSlot, aFluids, aInputs);
            }
            return null;
        }

        public List<Recipe> getNEIAllRecipes() {
            long tTimeBefore = System.currentTimeMillis();
            for (int i = 0; i < this.mRecipeMapHandlers.size(); ++i) {
                IRecipeMapHandler tHandler = this.mRecipeMapHandlers.get(i);
                tHandler.addAllRecipes(this);
                if (tHandler.isDone()) {
                    this.mRecipeMapHandlers.remove(tHandler);
                }
                if (System.currentTimeMillis() - tTimeBefore > 60000L) break;
            }
            ArrayListNoNulls<Recipe> rList = new ArrayListNoNulls<Recipe>();
            for (Recipe tRecipe : this.mRecipeList) {
                if (!tRecipe.mEnabled || tRecipe.mHidden) continue;
                rList.add(tRecipe);
            }
            return rList;
        }

        public List<Recipe> getNEIRecipes(ItemStack ... aOutputs) {
            for (ItemStack aOutput : aOutputs) {
                if (!ST.valid(aOutput)) continue;
                if (IL.Display_Fluid.equal(aOutput, true, true)) {
                    Fluid tFluid = FL.fluid(ST.meta_(aOutput));
                    if (tFluid == null) continue;
                    for (IRecipeMapHandler tHandler : this.mRecipeMapHandlers) {
                        tHandler.addRecipesProducing(this, true, tFluid);
                    }
                    continue;
                }
                OreDictItemData tData = OM.data_(aOutput);
                for (IRecipeMapHandler tHandler : this.mRecipeMapHandlers) {
                    tHandler.addRecipesProducing(this, true, aOutput, tData);
                }
            }
            ArrayListNoNulls<Recipe> rList = new ArrayListNoNulls<Recipe>();
            for (Recipe tRecipe : this.mRecipeList) {
                if (!tRecipe.mEnabled || tRecipe.mHidden) continue;
                block4: for (ItemStack aOutput : aOutputs) {
                    if (aOutput == null) continue;
                    if (IL.Display_Fluid.equal(aOutput, true, true)) {
                        for (FluidStack fluidStack : tRecipe.mFluidOutputs) {
                            if (ST.meta_(aOutput) < 0 || FL.id(fluidStack) != ST.meta_(aOutput)) continue;
                            rList.add(tRecipe);
                            continue block4;
                        }
                        continue;
                    }
                    for (FluidStack fluidStack : tRecipe.mOutputs) {
                        if (fluidStack == null || fluidStack.getItem() != aOutput.getItem() || ST.meta_((ItemStack)fluidStack) != Short.MAX_VALUE && ST.meta_((ItemStack)fluidStack) != ST.meta_(aOutput) && !fluidStack.isItemStackDamageable()) continue;
                        rList.add(tRecipe);
                        continue block4;
                    }
                }
            }
            return rList;
        }

        public List<Recipe> getNEIUsages(ItemStack ... aInputs) {
            for (ItemStack aInput : aInputs) {
                if (!ST.valid(aInput)) continue;
                if (IL.Display_Fluid.equal(aInput, true, true)) {
                    Fluid tFluid = FL.fluid(ST.meta_(aInput));
                    if (tFluid == null) continue;
                    for (IRecipeMapHandler tHandler : this.mRecipeMapHandlers) {
                        tHandler.addRecipesUsing(this, true, tFluid);
                    }
                    continue;
                }
                OreDictItemData tData = OM.data_(aInput);
                for (IRecipeMapHandler tHandler : this.mRecipeMapHandlers) {
                    tHandler.addRecipesUsing(this, true, aInput, tData);
                }
            }
            ArrayListNoNulls<Recipe> rList = new ArrayListNoNulls<Recipe>();
            for (Recipe tRecipe : this.mRecipeList) {
                if (!tRecipe.mEnabled || tRecipe.mHidden) continue;
                block4: for (ItemStack aInput : aInputs) {
                    if (aInput == null) continue;
                    if (IL.Display_Fluid.equal(aInput, true, true)) {
                        for (FluidStack fluidStack : tRecipe.mFluidInputs) {
                            if (ST.meta_(aInput) < 0 || FL.id(fluidStack) != ST.meta_(aInput)) continue;
                            rList.add(tRecipe);
                            continue block4;
                        }
                        continue;
                    }
                    for (FluidStack fluidStack : tRecipe.mInputs) {
                        if (fluidStack == null || fluidStack.getItem() != aInput.getItem() || ST.meta_((ItemStack)fluidStack) != Short.MAX_VALUE && ST.meta_((ItemStack)fluidStack) != ST.meta_(aInput) && !fluidStack.isItemStackDamageable()) continue;
                        rList.add(tRecipe);
                        continue block4;
                    }
                }
            }
            return rList;
        }

        public Recipe addToItemMap(Recipe aRecipe) {
            for (ItemStack aStack : aRecipe.mInputs) {
                if (aStack == null) continue;
                ItemStackContainer tStack = new ItemStackContainer(aStack);
                HashSet<Recipe> tList = (HashSet<Recipe>)this.mRecipeItemMap.get(tStack);
                if (tList == null) {
                    tList = new HashSet<Recipe>(1);
                    this.mRecipeItemMap.put(tStack, (Collection<Recipe>)tList);
                }
                tList.add(aRecipe);
            }
            return aRecipe;
        }

        public boolean openNEI() {
            try {
                GuiCraftingRecipe.openRecipeGui((String)this.mNameNEI, (Object[])new Object[0]);
                return true;
            }
            catch (Throwable throwable) {
                return false;
            }
        }

        public boolean guiRecipes(Object ... aOutputs) {
            try {
                GuiCraftingRecipe.openRecipeGui((String)this.mNameNEI, (Object[])aOutputs);
                return true;
            }
            catch (Throwable throwable) {
                return false;
            }
        }

        public boolean guiUsesNEI(Object ... aInputs) {
            try {
                GuiUsageRecipe.openRecipeGui((String)this.mNameNEI, (Object[])aInputs);
                return true;
            }
            catch (Throwable throwable) {
                return false;
            }
        }
    }
}

