/*
 * Decompiled with CFR 0.152.
 */
package gregapi.recipes;

import gregapi.code.ICondition;
import gregapi.data.CS;
import gregapi.data.MT;
import gregapi.oredict.OreDictItemData;
import gregapi.oredict.OreDictMaterial;
import gregapi.oredict.OreDictPrefix;
import gregapi.recipes.ICraftingRecipeGT;
import gregapi.util.CR;
import gregapi.util.OM;
import gregapi.util.ST;
import gregapi.util.UT;
import java.util.Iterator;
import java.util.List;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraft.world.World;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class AdvancedCraftingXToY
implements ICraftingRecipeGT {
    public final ICondition mCondition;
    public final OreDictPrefix mInput;
    public final OreDictPrefix mOutput;
    public final boolean mAutoCraftable;
    public final int mInputCount;
    public final int mOutputCount;

    public AdvancedCraftingXToY(OreDictPrefix aInput, int aInputCount, OreDictPrefix aOutput, int aOutputCount, boolean aAutoCraftable) {
        this(aInput, aInputCount, aOutput, aOutputCount, aAutoCraftable, MT.NULL.NOT);
    }

    public AdvancedCraftingXToY(OreDictPrefix aInput, int aInputCount, OreDictPrefix aOutput, int aOutputCount, boolean aAutoCraftable, ICondition aCondition) {
        this.mAutoCraftable = aAutoCraftable;
        this.mCondition = aCondition;
        this.mInput = aInput;
        this.mInputCount = aInputCount;
        this.mOutput = aOutput;
        this.mOutputCount = aOutputCount;
        this.mInput.mShapelessManagers.add(this);
        List<IRecipe> tRecipeList = CR.list();
        try {
            for (int i = 0; i < tRecipeList.size(); ++i) {
                OreDictItemData tData;
                IRecipe tRecipe = tRecipeList.get(i);
                if (tRecipe == null) {
                    tRecipeList.remove(i--);
                    continue;
                }
                int tCount = 0;
                OreDictMaterial tMaterial = null;
                if (!(tRecipeList.get(i) instanceof ICraftingRecipeGT)) {
                    Iterator iterator;
                    OreDictItemData tData2;
                    Object tInputs;
                    if (tRecipe instanceof ShapedOreRecipe) {
                        tInputs = ((ShapedOreRecipe)tRecipe).getInput();
                        if (tInputs != null && ((Object[])tInputs).length >= this.mInputCount && (this.mInputCount == 9 || this.mInputCount == 4 && ((Object)tInputs).length == 9 && tInputs[2] == null && tInputs[5] == null && tInputs[6] == null && tInputs[7] == null && tInputs[8] == null)) {
                            for (Iterator tObject : tInputs) {
                                if (tObject == null) continue;
                                if (++tCount > this.mInputCount) {
                                    tCount = 0;
                                } else if (tObject instanceof ItemStack) {
                                    tData2 = OM.data((ItemStack)tObject);
                                    if (tData2 == null || tData2.mPrefix != this.mInput || tData2.mMaterial == null || !this.mCondition.isTrue(tData2.mMaterial.mMaterial)) {
                                        tCount = 0;
                                    } else {
                                        if (tCount == 1) {
                                            tMaterial = tData2.mMaterial.mMaterial;
                                            continue;
                                        }
                                        if (tMaterial == tData2.mMaterial.mMaterial) continue;
                                        tCount = 0;
                                    }
                                } else if (tObject instanceof List) {
                                    if (((List)((Object)tObject)).isEmpty()) {
                                        tCount = 0;
                                    } else {
                                        if (!(((List)((Object)tObject)).get(0) instanceof ItemStack)) continue;
                                        tData2 = OM.data((ItemStack)((List)((Object)tObject)).get(0));
                                        if (tData2 == null || tData2.mPrefix != this.mInput || tData2.mMaterial == null || !this.mCondition.isTrue(tData2.mMaterial.mMaterial)) {
                                            tCount = 0;
                                        } else {
                                            if (tCount == 1) {
                                                tMaterial = tData2.mMaterial.mMaterial;
                                                continue;
                                            }
                                            if (tMaterial == tData2.mMaterial.mMaterial) continue;
                                            tCount = 0;
                                        }
                                    }
                                } else {
                                    tCount = 0;
                                }
                                break;
                            }
                        }
                    } else if (tRecipe instanceof ShapelessOreRecipe) {
                        tInputs = ((ShapelessOreRecipe)tRecipe).getInput();
                        if (tInputs != null && tInputs.size() == this.mInputCount) {
                            iterator = tInputs.iterator();
                            while (iterator.hasNext()) {
                                OreDictItemData tData3;
                                Object tObject = iterator.next();
                                if (tObject == null) continue;
                                ++tCount;
                                if (tObject instanceof ItemStack) {
                                    tData3 = OM.data((ItemStack)tObject);
                                    if (tData3 == null || tData3.mPrefix != this.mInput || tData3.mMaterial == null || !this.mCondition.isTrue(tData3.mMaterial.mMaterial)) {
                                        tCount = 0;
                                    } else {
                                        if (tCount == 1) {
                                            tMaterial = tData3.mMaterial.mMaterial;
                                            continue;
                                        }
                                        if (tMaterial == tData3.mMaterial.mMaterial) continue;
                                        tCount = 0;
                                    }
                                } else if (tObject instanceof List) {
                                    if (((List)tObject).isEmpty()) {
                                        tCount = 0;
                                    } else {
                                        if (!(((List)tObject).get(0) instanceof ItemStack)) continue;
                                        tData3 = OM.data((ItemStack)((List)tObject).get(0));
                                        if (tData3 == null || tData3.mPrefix != this.mInput || tData3.mMaterial == null || !this.mCondition.isTrue(tData3.mMaterial.mMaterial)) {
                                            tCount = 0;
                                        } else {
                                            if (tCount == 1) {
                                                tMaterial = tData3.mMaterial.mMaterial;
                                                continue;
                                            }
                                            if (tMaterial == tData3.mMaterial.mMaterial) continue;
                                            tCount = 0;
                                        }
                                    }
                                } else {
                                    tCount = 0;
                                }
                                break;
                            }
                        }
                    } else if (tRecipe instanceof ShapedRecipes) {
                        tInputs = ((ShapedRecipes)tRecipe).recipeItems;
                        if (tInputs != null && ((Object)tInputs).length >= this.mInputCount && (this.mInputCount == 9 || this.mInputCount == 4 && ((Object)tInputs).length == 9 && tInputs[2] == null && tInputs[5] == null && tInputs[6] == null && tInputs[7] == null && tInputs[8] == null)) {
                            for (Iterator tObject : tInputs) {
                                if (tObject == null) continue;
                                if (++tCount > this.mInputCount) {
                                    tCount = 0;
                                } else {
                                    tData2 = OM.data(tObject);
                                    if (tData2 == null || tData2.mPrefix != this.mInput || tData2.mMaterial == null || !this.mCondition.isTrue(tData2.mMaterial.mMaterial)) {
                                        tCount = 0;
                                    } else {
                                        if (tCount == 1) {
                                            tMaterial = tData2.mMaterial.mMaterial;
                                            continue;
                                        }
                                        if (tMaterial == tData2.mMaterial.mMaterial) continue;
                                        tCount = 0;
                                    }
                                }
                                break;
                            }
                        }
                    } else if (tRecipe instanceof ShapelessRecipes && (tInputs = ((ShapelessRecipes)tRecipe).recipeItems) != null && tInputs.size() == this.mInputCount) {
                        iterator = tInputs.iterator();
                        while (iterator.hasNext()) {
                            Object tObject = iterator.next();
                            if (tObject == null) continue;
                            ++tCount;
                            if (tObject instanceof ItemStack) {
                                OreDictItemData tData4 = OM.data((ItemStack)tObject);
                                if (tData4 == null || tData4.mPrefix != this.mInput || tData4.mMaterial == null || !this.mCondition.isTrue(tData4.mMaterial.mMaterial)) {
                                    tCount = 0;
                                } else {
                                    if (tCount == 1) {
                                        tMaterial = tData4.mMaterial.mMaterial;
                                        continue;
                                    }
                                    if (tMaterial == tData4.mMaterial.mMaterial) continue;
                                    tCount = 0;
                                }
                            } else {
                                tCount = 0;
                            }
                            break;
                        }
                    }
                }
                if (tCount != this.mInputCount || (tData = OM.data(tRecipe.getRecipeOutput())) == null || tData.mPrefix != this.mOutput || tData.mMaterial.mMaterial != tMaterial) continue;
                tRecipeList.remove(i--);
            }
        }
        catch (Throwable e) {
            e.printStackTrace(CS.ERR);
        }
    }

    public boolean matches(InventoryCrafting aGrid, World aWorld) {
        if (this.mInputCount != 9) {
            Container tContainer = (Container)UT.Reflection.getFieldContent(aGrid, "field_70465_c", false, false);
            if (tContainer == null) {
                tContainer = (Container)UT.Reflection.getFieldContent(aGrid, "eventHandler", false, false);
            }
            if (tContainer != null && tContainer.getClass().getName().startsWith("thaumcraft")) {
                return false;
            }
        }
        ItemStack tStack = null;
        OreDictMaterial rMaterial = null;
        int tInventorySize = aGrid.getSizeInventory();
        int tCounter = 0;
        if (tInventorySize < this.mInputCount) {
            return false;
        }
        for (int i = 0; i < tInventorySize; ++i) {
            tStack = aGrid.getStackInSlot(i);
            if (ST.valid(tStack)) {
                OreDictItemData tData = OM.anydata_(tStack);
                if (tData == null || tData.mPrefix != this.mInput) {
                    return false;
                }
                if (rMaterial == null) {
                    rMaterial = tData.mMaterial.mMaterial;
                } else if (rMaterial != tData.mMaterial.mMaterial) {
                    return false;
                }
                ++tCounter;
                continue;
            }
            if (i - tCounter + this.mInputCount < tInventorySize) continue;
            return false;
        }
        return rMaterial != null && tCounter == this.mInputCount && this.hasOutputFor(rMaterial);
    }

    public ItemStack getCraftingResult(InventoryCrafting aGrid) {
        int j = aGrid.getSizeInventory();
        for (int i = 0; i < j; ++i) {
            OreDictItemData tData = OM.anydata(aGrid.getStackInSlot(i));
            if (tData == null || tData.mMaterial == null || !this.mCondition.isTrue(tData.mMaterial.mMaterial)) continue;
            return this.mOutput.mat(tData.mMaterial.mMaterial, (long)this.mOutputCount);
        }
        return ERROR_OUTPUT.copy();
    }

    public boolean hasOutputFor(OreDictMaterial aMaterial) {
        return ST.valid(this.mOutput.mat(aMaterial, (long)this.mOutputCount)) && this.mCondition.isTrue(aMaterial);
    }

    @Override
    public boolean isRemovableByGT() {
        return false;
    }

    @Override
    public boolean isAutocraftableByGT() {
        return this.mAutoCraftable;
    }

    public int getRecipeSize() {
        return this.mInputCount;
    }

    public ItemStack getRecipeOutput() {
        return ERROR_OUTPUT.copy();
    }
}

