/*
 * Decompiled with CFR 0.152.
 */
package gregapi.oredict.configurations;

import gregapi.code.ArrayListNoNulls;
import gregapi.oredict.OreDictMaterialStack;
import gregapi.oredict.configurations.IOreDictConfigurationComponent;
import gregapi.util.OM;

public class OreDictConfigurationComponent
implements IOreDictConfigurationComponent {
    private final ArrayListNoNulls<OreDictMaterialStack> mList;
    private final ArrayListNoNulls<OreDictMaterialStack> mDividedList;
    public final long mCommonDivider;

    public OreDictConfigurationComponent(long aCommonDivider, OreDictMaterialStack ... aComponents) {
        this.mCommonDivider = aCommonDivider;
        this.mList = new ArrayListNoNulls<OreDictMaterialStack>(false, aComponents);
        this.mDividedList = new ArrayListNoNulls();
        for (OreDictMaterialStack tMaterial : this.mList) {
            this.mDividedList.add(OM.stack(tMaterial.mMaterial, tMaterial.mAmount / this.mCommonDivider));
        }
    }

    @Override
    public ArrayListNoNulls<OreDictMaterialStack> getComponents() {
        return this.mDividedList;
    }

    @Override
    public ArrayListNoNulls<OreDictMaterialStack> getUndividedComponents() {
        return this.mList;
    }

    @Override
    public long getCommonDivider() {
        return this.mCommonDivider;
    }
}

