/*
 * Decompiled with CFR 0.152.
 */
package gregapi.item.multiitem;

import cpw.mods.fml.common.Optional;
import gregapi.code.ArrayListNoNulls;
import gregapi.code.TagData;
import gregapi.data.CS;
import gregapi.data.FL;
import gregapi.data.LH;
import gregapi.data.MD;
import gregapi.data.TD;
import gregapi.item.IItemEnergy;
import gregapi.item.IItemProjectile;
import gregapi.item.ItemBase;
import gregapi.item.multiitem.behaviors.IBehavior;
import gregapi.item.multiitem.energy.EnergyStatDebug;
import gregapi.lang.LanguageHandler;
import gregapi.util.ST;
import gregapi.util.UT;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import micdoodle8.mods.galacticraft.core.energy.EnergyConfigHandler;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;

@Optional.InterfaceList(value={@Optional.Interface(iface="ic2.api.item.ISpecialElectricItem", modid="IC2"), @Optional.Interface(iface="ic2.api.item.IElectricItemManager", modid="IC2"), @Optional.Interface(iface="micdoodle8.mods.galacticraft.api.item.IItemElectric", modid="GalacticraftCore")})
public abstract class MultiItem
extends ItemBase
implements IItemEnergy {
    public final HashMap<Short, ArrayList<IBehavior<MultiItem>>> mItemBehaviors = new HashMap();
    public final HashMap<Short, Long[]> mFluidContainerStats = new HashMap();

    public MultiItem(String aModID, String aUnlocalized) {
        super(aModID, aUnlocalized, "Generated Item", null);
        this.setHasSubtypes(true);
        this.setMaxDamage(0);
    }

    public MultiItem addItemBehavior(int aMeta, IBehavior<MultiItem> aBehavior) {
        if (aMeta < 0 || aMeta >= Short.MAX_VALUE || aBehavior == null) {
            return this;
        }
        ArrayList<IBehavior<MultiItem>> tList = this.mItemBehaviors.get((short)aMeta);
        if (tList == null) {
            tList = new ArrayListNoNulls<IBehavior<MultiItem>>();
            this.mItemBehaviors.put((short)aMeta, tList);
        }
        tList.add(aBehavior);
        return this;
    }

    public MultiItem addItemBehavior(IBehavior<MultiItem> aBehavior, int ... aMetas) {
        for (int aMeta : aMetas) {
            this.addItemBehavior(aMeta, aBehavior);
        }
        return this;
    }

    @Override
    public boolean hasProjectile(TagData aProjectileType, ItemStack aStack) {
        ArrayList<IBehavior<MultiItem>> tList = this.mItemBehaviors.get(ST.meta_(aStack));
        if (tList != null) {
            for (IBehavior<MultiItem> tBehavior : tList) {
                if (!tBehavior.hasProjectile(this, aProjectileType, aStack)) continue;
                return true;
            }
        }
        return super.hasProjectile(aProjectileType, aStack);
    }

    @Override
    public IItemProjectile.EntityProjectile getProjectile(TagData aProjectileType, ItemStack aStack, World aWorld, double aX, double aY, double aZ) {
        ArrayList<IBehavior<MultiItem>> tList = this.mItemBehaviors.get(ST.meta_(aStack));
        if (tList != null) {
            for (IBehavior<MultiItem> tBehavior : tList) {
                IItemProjectile.EntityProjectile rArrow = tBehavior.getProjectile(this, aProjectileType, aStack, aWorld, aX, aY, aZ);
                if (rArrow == null) continue;
                return rArrow;
            }
        }
        return super.getProjectile(aProjectileType, aStack, aWorld, aX, aY, aZ);
    }

    @Override
    public IItemProjectile.EntityProjectile getProjectile(TagData aProjectileType, ItemStack aStack, World aWorld, EntityLivingBase aEntity, float aSpeed) {
        ArrayList<IBehavior<MultiItem>> tList = this.mItemBehaviors.get(ST.meta_(aStack));
        if (tList != null) {
            for (IBehavior<MultiItem> tBehavior : tList) {
                IItemProjectile.EntityProjectile rArrow = tBehavior.getProjectile(this, aProjectileType, aStack, aWorld, aEntity, aSpeed);
                if (rArrow == null) continue;
                return rArrow;
            }
        }
        return super.getProjectile(aProjectileType, aStack, aWorld, aEntity, aSpeed);
    }

    @Override
    public ItemStack onDispense(IBlockSource aSource, ItemStack aStack) {
        ArrayList<IBehavior<MultiItem>> tList = this.mItemBehaviors.get(ST.meta_(aStack));
        if (tList != null) {
            for (IBehavior<MultiItem> tBehavior : tList) {
                if (!tBehavior.canDispense(this, aSource, aStack)) continue;
                return tBehavior.onDispense(this, aSource, aStack);
            }
        }
        return super.onDispense(aSource, aStack);
    }

    @Override
    public boolean isItemStackUsable(ItemStack aStack) {
        ArrayList<IBehavior<MultiItem>> tList = this.mItemBehaviors.get(ST.meta_(aStack));
        if (tList != null) {
            for (IBehavior<MultiItem> tBehavior : tList) {
                if (tBehavior.isItemStackUsable(this, aStack)) continue;
                return false;
            }
        }
        return super.isItemStackUsable(aStack);
    }

    public boolean itemInteractionForEntity(ItemStack aStack, EntityPlayer aPlayer, EntityLivingBase aEntity) {
        if (!aPlayer.worldObj.isRemote) {
            this.useEnergy(TD.Energy.EU, aStack, 0L, (EntityLivingBase)aPlayer, null, null, 0, 0, 0, true);
        }
        if (!this.isItemStackUsable(aStack)) {
            return false;
        }
        if (this.destroyCheck(aStack, aPlayer)) {
            return false;
        }
        ArrayList<IBehavior<MultiItem>> tList = this.mItemBehaviors.get(ST.meta_(aStack));
        if (tList != null) {
            for (IBehavior<MultiItem> tBehavior : tList) {
                try {
                    if (tBehavior.onRightClickEntity(this, aStack, aPlayer, (Entity)aEntity)) {
                        this.destroyCheck(aStack, aPlayer);
                        return true;
                    }
                    if (!this.destroyCheck(aStack, aPlayer)) continue;
                    return false;
                }
                catch (Throwable e) {
                    e.printStackTrace(CS.ERR);
                }
            }
        }
        return false;
    }

    public boolean onLeftClickEntity(ItemStack aStack, EntityPlayer aPlayer, Entity aEntity) {
        if (!aPlayer.worldObj.isRemote) {
            this.useEnergy(TD.Energy.EU, aStack, 0L, (EntityLivingBase)aPlayer, null, null, 0, 0, 0, true);
        }
        if (!this.isItemStackUsable(aStack)) {
            return false;
        }
        if (this.destroyCheck(aStack, aPlayer)) {
            return false;
        }
        ArrayList<IBehavior<MultiItem>> tList = this.mItemBehaviors.get(ST.meta_(aStack));
        if (tList != null) {
            for (IBehavior<MultiItem> tBehavior : tList) {
                try {
                    if (tBehavior.onLeftClickEntity(this, aStack, aPlayer, aEntity)) {
                        this.destroyCheck(aStack, aPlayer);
                        return true;
                    }
                    if (!this.destroyCheck(aStack, aPlayer)) continue;
                    return false;
                }
                catch (Throwable e) {
                    e.printStackTrace(CS.ERR);
                }
            }
        }
        return false;
    }

    public boolean onItemUse(ItemStack aStack, EntityPlayer aPlayer, World aWorld, int aX, int aY, int aZ, int aSide, float hitX, float hitY, float hitZ) {
        if (MD.BbLC.owns((IBlockAccess)aWorld, aX, aY, aZ)) {
            return false;
        }
        if (!aWorld.isRemote) {
            this.useEnergy(TD.Energy.EU, aStack, 0L, (EntityLivingBase)aPlayer, null, null, 0, 0, 0, true);
        }
        if (!this.isItemStackUsable(aStack)) {
            return false;
        }
        if (this.destroyCheck(aStack, aPlayer)) {
            return false;
        }
        ArrayList<IBehavior<MultiItem>> tList = this.mItemBehaviors.get(ST.meta_(aStack));
        if (tList != null) {
            for (IBehavior<MultiItem> tBehavior : tList) {
                try {
                    if (tBehavior.onItemUse(this, aStack, aPlayer, aWorld, aX, aY, aZ, UT.Code.side(aSide), hitX, hitY, hitZ)) {
                        this.destroyCheck(aStack, aPlayer);
                        return true;
                    }
                    if (!this.destroyCheck(aStack, aPlayer)) continue;
                    return false;
                }
                catch (Throwable e) {
                    e.printStackTrace(CS.ERR);
                }
            }
        }
        return false;
    }

    public boolean onItemUseFirst(ItemStack aStack, EntityPlayer aPlayer, World aWorld, int aX, int aY, int aZ, int aSide, float hitX, float hitY, float hitZ) {
        if (MD.BbLC.owns((IBlockAccess)aWorld, aX, aY, aZ)) {
            return false;
        }
        if (!aWorld.isRemote) {
            this.useEnergy(TD.Energy.EU, aStack, 0L, (EntityLivingBase)aPlayer, null, null, 0, 0, 0, true);
        }
        if (!this.isItemStackUsable(aStack)) {
            return false;
        }
        if (this.destroyCheck(aStack, aPlayer)) {
            return false;
        }
        ArrayList<IBehavior<MultiItem>> tList = this.mItemBehaviors.get(ST.meta_(aStack));
        if (tList != null) {
            for (IBehavior<MultiItem> tBehavior : tList) {
                try {
                    if (tBehavior.onItemUseFirst(this, aStack, aPlayer, aWorld, aX, aY, aZ, UT.Code.side(aSide), hitX, hitY, hitZ)) {
                        this.destroyCheck(aStack, aPlayer);
                        return true;
                    }
                    if (!this.destroyCheck(aStack, aPlayer)) continue;
                    return false;
                }
                catch (Throwable e) {
                    e.printStackTrace(CS.ERR);
                }
            }
        }
        return false;
    }

    public boolean destroyCheck(ItemStack aStack, EntityPlayer aPlayer) {
        if (aStack.stackSize <= 0) {
            if (aPlayer != null) {
                aPlayer.destroyCurrentEquippedItem();
            }
            return true;
        }
        return false;
    }

    public ItemStack onItemRightClick(ItemStack aStack, World aWorld, EntityPlayer aPlayer) {
        if (!aWorld.isRemote) {
            this.useEnergy(TD.Energy.EU, aStack, 0L, (EntityLivingBase)aPlayer, null, null, 0, 0, 0, true);
        }
        if (!this.isItemStackUsable(aStack)) {
            return aStack;
        }
        ArrayList<IBehavior<MultiItem>> tList = this.mItemBehaviors.get(ST.meta_(aStack));
        if (tList != null) {
            for (IBehavior<MultiItem> tBehavior : tList) {
                try {
                    aStack = tBehavior.onItemRightClick(this, aStack, aWorld, aPlayer);
                }
                catch (Throwable e) {
                    e.printStackTrace(CS.ERR);
                }
            }
        }
        return aStack;
    }

    @Override
    public final void addInformation(ItemStack aStack, EntityPlayer aPlayer, List aList, boolean aF3_H) {
        try {
            Long[] tStats;
            IItemEnergy tEnergyStats;
            String tKey = this.getUnlocalizedName(aStack) + ".tooltip";
            String tString = LanguageHandler.translate(tKey, tKey);
            if (UT.Code.stringValid(tString) && !tKey.equals(tString)) {
                aList.add(tString);
            }
            if ((tEnergyStats = this.getEnergyStats(aStack)) != null) {
                if (tEnergyStats instanceof EnergyStatDebug) {
                    aList.add(LH.Chat.RAINBOW_SLOW + "Works as Infinite Energy Battery");
                } else {
                    for (TagData tEnergyType : tEnergyStats.getEnergyTypes(aStack)) {
                        long tCapacity = tEnergyStats.getEnergyCapacity(tEnergyType, aStack);
                        aList.add(LH.Chat.WHITE + UT.Code.makeString(Math.min(tCapacity, tEnergyStats.getEnergyStored(tEnergyType, aStack))) + " / " + UT.Code.makeString(tCapacity) + " " + tEnergyType.getLocalisedChatNameShort() + LH.Chat.WHITE + " - Size: " + tEnergyStats.getEnergySizeInputRecommended(tEnergyType, aStack));
                    }
                }
            }
            if ((tStats = this.getFluidContainerStats(aStack)) != null && tStats[0] > 0L) {
                FluidStack tFluid = this.getFluidContent(aStack);
                aList.add(LH.Chat.BLUE + (tFluid == null ? "No Fluids Contained" : FL.name(tFluid, true)));
                aList.add(LH.Chat.BLUE + (tFluid == null ? 0 : tFluid.amount) + "L / " + tStats[0] + "L");
            }
            this.addAdditionalToolTips(aList, aStack, aF3_H);
            ArrayList<IBehavior<MultiItem>> tList = this.mItemBehaviors.get(ST.meta_(aStack));
            if (tList != null) {
                for (IBehavior<MultiItem> tBehavior : tList) {
                    aList = tBehavior.getAdditionalToolTips(this, aList, aStack);
                }
            }
        }
        catch (Throwable e) {
            e.printStackTrace(CS.ERR);
        }
        while (aList.remove(null)) {
        }
    }

    public void onUpdate(ItemStack aStack, World aWorld, Entity aPlayer, int aTimer, boolean aIsInHand) {
        ArrayList<IBehavior<MultiItem>> tList = this.mItemBehaviors.get(ST.meta_(aStack));
        if (tList != null) {
            for (IBehavior<MultiItem> tBehavior : tList) {
                tBehavior.onUpdate(this, aStack, aWorld, aPlayer, aTimer, aIsInHand);
            }
        }
    }

    public FluidStack getFluid(ItemStack aStack) {
        return this.getFluidContent(aStack);
    }

    public int getCapacity(ItemStack aStack) {
        Long[] tStats = this.getFluidContainerStats(aStack);
        return tStats == null ? 0 : (int)Math.max(0L, tStats[0]);
    }

    public int fill(ItemStack aStack, FluidStack aFluid, boolean doFill) {
        if (aStack == null || aStack.stackSize != 1) {
            return 0;
        }
        ItemStack tStack = FL.fill(aFluid, aStack, false, false, false, false);
        if (tStack != null) {
            aStack.setItemDamage((int)ST.meta_(tStack));
            aStack.func_150996_a(tStack.getItem());
            return FL.getFluid((ItemStack)tStack, (boolean)false).amount;
        }
        Long[] tStats = this.getFluidContainerStats(aStack);
        if (tStats == null || tStats[0] <= 0L || aFluid == null || aFluid.amount <= 0 || !this.isAllowedToFill(aStack, aFluid)) {
            return 0;
        }
        FluidStack tFluid = this.getFluidContent(aStack);
        if (tFluid == null) {
            if ((long)aFluid.amount <= tStats[0]) {
                if (doFill) {
                    this.setFluidContent(aStack, aFluid);
                }
                return aFluid.amount;
            }
            if (doFill) {
                tFluid = aFluid.copy();
                tFluid.amount = (int)tStats[0].longValue();
                this.setFluidContent(aStack, tFluid);
            }
            return (int)tStats[0].longValue();
        }
        if (!tFluid.isFluidEqual(aFluid)) {
            return 0;
        }
        int space = (int)tStats[0].longValue() - tFluid.amount;
        if (aFluid.amount <= space) {
            if (doFill) {
                tFluid.amount += aFluid.amount;
                this.setFluidContent(aStack, tFluid);
            }
            return aFluid.amount;
        }
        if (doFill) {
            tFluid.amount = (int)tStats[0].longValue();
            this.setFluidContent(aStack, tFluid);
        }
        return space;
    }

    public boolean isAllowedToFill(ItemStack aStack, FluidStack aFluid) {
        return true;
    }

    public FluidStack drain(ItemStack aStack, int aMaxDrain, boolean aDoDrain) {
        if (aStack == null || aStack.stackSize != 1) {
            return null;
        }
        FluidStack tFluid = FL.getFluid(aStack, false);
        if (tFluid != null && aMaxDrain >= tFluid.amount) {
            if (aDoDrain) {
                ItemStack tStack = ST.container(aStack, false);
                if (tStack == null) {
                    aStack.stackSize = 0;
                    return tFluid;
                }
                aStack.setItemDamage((int)ST.meta_(tStack));
                aStack.func_150996_a(tStack.getItem());
            }
            return tFluid;
        }
        Long[] tStats = this.getFluidContainerStats(aStack);
        if (tStats == null || tStats[0] <= 0L) {
            return null;
        }
        tFluid = this.getFluidContent(aStack);
        if (tFluid == null) {
            return null;
        }
        if (tFluid.amount < aMaxDrain) {
            aMaxDrain = tFluid.amount;
        }
        if (aDoDrain) {
            tFluid.amount -= aMaxDrain;
            this.setFluidContent(aStack, tFluid);
        }
        FluidStack tDrained = tFluid.copy();
        tDrained.amount = aMaxDrain;
        return tDrained;
    }

    public FluidStack getFluidContent(ItemStack aStack) {
        Long[] tStats = this.getFluidContainerStats(aStack);
        if (tStats == null || tStats[0] <= 0L) {
            return FL.getFluid(aStack, false);
        }
        return FL.load(aStack.getTagCompound(), "gt.fluidcontent");
    }

    public void setFluidContent(ItemStack aStack, FluidStack aFluid) {
        NBTTagCompound tNBT = aStack.getTagCompound();
        if (tNBT == null) {
            tNBT = UT.NBT.make();
        } else {
            tNBT.removeTag("gt.fluidcontent");
        }
        if (aFluid != null && aFluid.amount > 0) {
            FL.save(tNBT, "gt.fluidcontent", aFluid);
        }
        UT.NBT.set(aStack, tNBT);
        this.isItemStackUsable(aStack);
    }

    public int getItemStackLimit(ItemStack aStack) {
        if (aStack.hasTagCompound() && aStack.getTagCompound().hasKey("gt.energy")) {
            return 1;
        }
        Long[] tStats = this.getFluidContainerStats(aStack);
        if (tStats != null) {
            return (int)tStats[1].longValue();
        }
        return UT.Code.bindStack(this.getDefaultStackLimit(aStack));
    }

    public int getDefaultStackLimit(ItemStack aStack) {
        return 64;
    }

    public double charge(ItemStack aStack, double aCharge, int aTier, boolean aIgnoreTransferLimit, boolean aSimulate) {
        byte by = UT.Code.bind4(aTier);
        aTier = by;
        if (aCharge < (double)CS.V[by]) {
            return 0.0;
        }
        return CS.V[aTier] * this.doEnergyInjection(TD.Energy.EU, aStack, CS.V[aTier], (long)(aCharge / (double)CS.V[aTier]), null, null, 0, 0, 0, !aSimulate);
    }

    public double discharge(ItemStack aStack, double aCharge, int aTier, boolean aIgnoreTransferLimit, boolean aBatteryAlike, boolean aSimulate) {
        byte by = UT.Code.bind4(aTier);
        aTier = by;
        if (aCharge < (double)CS.V[by]) {
            return 0.0;
        }
        return CS.V[aTier] * this.doEnergyExtraction(TD.Energy.EU, aStack, CS.V[aTier], (long)(aCharge / (double)CS.V[aTier]), null, null, 0, 0, 0, !aSimulate);
    }

    @Override
    public boolean isEnergyType(TagData aEnergyType, ItemStack aStack, boolean aEmitting) {
        IItemEnergy tStats = this.getEnergyStats(aStack);
        if (tStats == null) {
            return false;
        }
        return tStats.isEnergyType(aEnergyType, aStack, aEmitting);
    }

    @Override
    public long doEnergyInjection(TagData aEnergyType, ItemStack aStack, long aSize, long aAmount, IInventory aInventory, World aWorld, int aX, int aY, int aZ, boolean aDoInject) {
        IItemEnergy tStats = this.getEnergyStats(aStack);
        if (tStats == null) {
            return 0L;
        }
        return tStats.doEnergyInjection(aEnergyType, aStack, aSize, aAmount, aInventory, aWorld, aX, aY, aZ, aDoInject);
    }

    @Override
    public long doEnergyExtraction(TagData aEnergyType, ItemStack aStack, long aSize, long aAmount, IInventory aInventory, World aWorld, int aX, int aY, int aZ, boolean aDoExtract) {
        IItemEnergy tStats = this.getEnergyStats(aStack);
        if (tStats == null) {
            return 0L;
        }
        return tStats.doEnergyExtraction(aEnergyType, aStack, aSize, aAmount, aInventory, aWorld, aX, aY, aZ, aDoExtract);
    }

    @Override
    public boolean useEnergy(TagData aEnergyType, ItemStack aStack, long aEnergyAmount, EntityLivingBase aPlayer, IInventory aInventory, World aWorld, int aX, int aY, int aZ, boolean aDoUse) {
        IItemEnergy tStats = this.getEnergyStats(aStack);
        if (tStats == null) {
            return false;
        }
        return tStats.useEnergy(aEnergyType, aStack, aEnergyAmount, aPlayer, aInventory, aWorld, aX, aY, aZ, aDoUse);
    }

    @Override
    public ItemStack setEnergyStored(TagData aEnergyType, ItemStack aStack, long aAmount) {
        IItemEnergy tStats = this.getEnergyStats(aStack);
        if (tStats == null) {
            return aStack;
        }
        return tStats.setEnergyStored(aEnergyType, aStack, aAmount);
    }

    @Override
    public long getEnergyStored(TagData aEnergyType, ItemStack aStack) {
        IItemEnergy tStats = this.getEnergyStats(aStack);
        if (tStats == null) {
            return 0L;
        }
        return tStats.getEnergyStored(aEnergyType, aStack);
    }

    @Override
    public long getEnergyCapacity(TagData aEnergyType, ItemStack aStack) {
        IItemEnergy tStats = this.getEnergyStats(aStack);
        if (tStats == null) {
            return 0L;
        }
        return tStats.getEnergyCapacity(aEnergyType, aStack);
    }

    @Override
    public long getEnergySizeInputMin(TagData aEnergyType, ItemStack aStack) {
        IItemEnergy tStats = this.getEnergyStats(aStack);
        if (tStats == null) {
            return 0L;
        }
        return tStats.getEnergySizeInputMin(aEnergyType, aStack);
    }

    @Override
    public long getEnergySizeOutputMin(TagData aEnergyType, ItemStack aStack) {
        IItemEnergy tStats = this.getEnergyStats(aStack);
        if (tStats == null) {
            return 0L;
        }
        return tStats.getEnergySizeOutputMin(aEnergyType, aStack);
    }

    @Override
    public long getEnergySizeInputRecommended(TagData aEnergyType, ItemStack aStack) {
        IItemEnergy tStats = this.getEnergyStats(aStack);
        if (tStats == null) {
            return 0L;
        }
        return tStats.getEnergySizeInputRecommended(aEnergyType, aStack);
    }

    @Override
    public long getEnergySizeOutputRecommended(TagData aEnergyType, ItemStack aStack) {
        IItemEnergy tStats = this.getEnergyStats(aStack);
        if (tStats == null) {
            return 0L;
        }
        return tStats.getEnergySizeOutputRecommended(aEnergyType, aStack);
    }

    @Override
    public long getEnergySizeInputMax(TagData aEnergyType, ItemStack aStack) {
        IItemEnergy tStats = this.getEnergyStats(aStack);
        if (tStats == null) {
            return 0L;
        }
        return tStats.getEnergySizeInputMax(aEnergyType, aStack);
    }

    @Override
    public long getEnergySizeOutputMax(TagData aEnergyType, ItemStack aStack) {
        IItemEnergy tStats = this.getEnergyStats(aStack);
        if (tStats == null) {
            return 0L;
        }
        return tStats.getEnergySizeOutputMax(aEnergyType, aStack);
    }

    @Override
    public Collection<TagData> getEnergyTypes(ItemStack aStack) {
        IItemEnergy tStats = this.getEnergyStats(aStack);
        if (tStats == null) {
            return Collections.emptyList();
        }
        return tStats.getEnergyTypes(aStack);
    }

    @Override
    public boolean canEnergyInjection(TagData aEnergyType, ItemStack aStack, long aSize) {
        IItemEnergy tStats = this.getEnergyStats(aStack);
        return tStats != null && tStats.canEnergyInjection(aEnergyType, aStack, aSize);
    }

    @Override
    public boolean canEnergyExtraction(TagData aEnergyType, ItemStack aStack, long aSize) {
        IItemEnergy tStats = this.getEnergyStats(aStack);
        return tStats != null && tStats.canEnergyExtraction(aEnergyType, aStack, aSize);
    }

    public float discharge(ItemStack aStack, float aEnergy, boolean aDoExtract) {
        if (aEnergy <= 0.0f) {
            return 0.0f;
        }
        long tMaxOut = this.getEnergySizeOutputMax(TD.Energy.EU, aStack);
        if (!this.canEnergyExtraction(TD.Energy.EU, aStack, tMaxOut)) {
            return 0.0f;
        }
        long tAmount = UT.Code.bind(1L, tMaxOut, (long)(aEnergy / EnergyConfigHandler.IC2_RATIO));
        return this.useEnergy(TD.Energy.EU, aStack, tAmount, null, null, null, 0, 0, 0, false) && this.useEnergy(TD.Energy.EU, aStack, tAmount, null, null, null, 0, 0, 0, true) ? (float)tAmount * EnergyConfigHandler.IC2_RATIO : 0.0f;
    }

    public String getToolTip(ItemStack aStack) {
        return null;
    }

    public Item getChargedItem(ItemStack itemStack) {
        return this;
    }

    public Item getEmptyItem(ItemStack itemStack) {
        return this;
    }

    public int getTier(ItemStack aStack) {
        return UT.Code.tierMax(this.getEnergySizeInputMax(TD.Energy.EU, aStack));
    }

    public int getItemEnchantability() {
        return 0;
    }

    public boolean isBookEnchantable(ItemStack aStack, ItemStack aBook) {
        return false;
    }

    public boolean getIsRepairable(ItemStack aStack, ItemStack aMaterial) {
        return false;
    }

    public boolean canProvideEnergy(ItemStack aStack) {
        return true;
    }

    public double getMaxCharge(ItemStack aStack) {
        return this.getEnergyCapacity(TD.Energy.EU, aStack);
    }

    public double getTransferLimit(ItemStack aStack) {
        return this.getEnergySizeInputRecommended(TD.Energy.EU, aStack);
    }

    public double getCharge(ItemStack aStack) {
        return this.getEnergyStored(TD.Energy.EU, aStack);
    }

    public boolean canUse(ItemStack aStack, double aAmount) {
        return this.useEnergy(TD.Energy.EU, aStack, (long)aAmount, null, null, null, 0, 0, 0, false);
    }

    public boolean use(ItemStack aStack, double aAmount, EntityLivingBase aPlayer) {
        return this.useEnergy(TD.Energy.EU, aStack, (long)aAmount, aPlayer, null, null, 0, 0, 0, true);
    }

    public void chargeFromArmor(ItemStack aStack, EntityLivingBase aPlayer) {
    }

    public float getElectricityStored(ItemStack aStack) {
        return (float)this.getEnergyStored(TD.Energy.EU, aStack) * EnergyConfigHandler.IC2_RATIO;
    }

    public float getMaxElectricityStored(ItemStack aStack) {
        return (float)this.getEnergyCapacity(TD.Energy.EU, aStack) * EnergyConfigHandler.IC2_RATIO;
    }

    public void setElectricity(ItemStack aStack, float joules) {
    }

    public float recharge(ItemStack aStack, float aEnergy, boolean aDoInject) {
        return 0.0f;
    }

    public float getTransfer(ItemStack aStack) {
        return 0.0f;
    }

    public int getTierGC(ItemStack aStack) {
        return 1;
    }

    public abstract IItemEnergy getEnergyStats(ItemStack var1);

    public abstract Long[] getFluidContainerStats(ItemStack var1);
}

