/*
 * Decompiled with CFR 0.152.
 */
package gregapi.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregapi.code.TagData;
import gregapi.data.CS;
import gregapi.data.LH;
import gregapi.item.IItemGT;
import gregapi.item.IItemNoGTOverride;
import gregapi.item.IItemProjectile;
import gregapi.item.IItemUpdatable;
import gregapi.lang.LanguageHandler;
import gregapi.util.ST;
import gregapi.util.UT;
import java.util.List;
import net.minecraft.block.BlockDispenser;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.dispenser.BehaviorDefaultDispenseItem;
import net.minecraft.dispenser.BehaviorProjectileDispense;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.dispenser.IPosition;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class ItemBase
extends Item
implements IItemProjectile,
IItemUpdatable,
IItemGT,
IItemNoGTOverride {
    protected IIcon mIcon;
    protected final String mModID;
    protected final String mName;
    protected final String mTooltip;

    public ItemBase(String aModID, String aUnlocalized, String aEnglish, String aEnglishTooltip) {
        if (CS.GAPI.mStartedInit) {
            throw new IllegalStateException("Items can only be initialised within preInit!");
        }
        this.mName = aUnlocalized;
        this.mModID = aModID;
        LH.add(this.mName, aEnglish);
        if (UT.Code.stringValid(aEnglishTooltip)) {
            this.mTooltip = this.mName + ".tooltip_main";
            LH.add(this.mTooltip, aEnglishTooltip);
        } else {
            this.mTooltip = null;
        }
        ST.register(this, this.mName);
        BlockDispenser.dispenseBehaviorRegistry.putObject((Object)this, (Object)new GT_Item_Dispense());
    }

    public void addInformation(ItemStack aStack, EntityPlayer aPlayer, List aList, boolean aF3_H) {
        try {
            if (this.getMaxDamage() > 0 && !this.getHasSubtypes()) {
                aList.add(aStack.getMaxDamage() - this.getDamage(aStack) + " / " + aStack.getMaxDamage());
            }
            if (this.mTooltip != null) {
                aList.add(LanguageHandler.translate(this.mTooltip, this.mTooltip));
            }
            this.addAdditionalToolTips(aList, aStack, aF3_H);
        }
        catch (Throwable e) {
            e.printStackTrace(CS.ERR);
        }
        while (aList.remove(null)) {
        }
    }

    protected void addAdditionalToolTips(List<String> aList, ItemStack aStack, boolean aF3_H) {
    }

    public ItemStack onDispense(IBlockSource aSource, ItemStack aStack) {
        EnumFacing enumfacing = BlockDispenser.func_149937_b((int)aSource.getBlockMetadata());
        IPosition iposition = BlockDispenser.func_149939_a((IBlockSource)aSource);
        ItemStack itemstack1 = aStack.splitStack(1);
        BehaviorDefaultDispenseItem.doDispense((World)aSource.getWorld(), (ItemStack)itemstack1, (int)6, (EnumFacing)enumfacing, (IPosition)iposition);
        return aStack;
    }

    @Override
    public boolean hasProjectile(TagData aProjectileType, ItemStack aStack) {
        return false;
    }

    @Override
    public IItemProjectile.EntityProjectile getProjectile(TagData aProjectileType, ItemStack aStack, World aWorld, double aX, double aY, double aZ) {
        return null;
    }

    @Override
    public IItemProjectile.EntityProjectile getProjectile(TagData aProjectileType, ItemStack aStack, World aWorld, EntityLivingBase aEntity, float aSpeed) {
        return null;
    }

    public final Item setUnlocalizedName(String aName) {
        return this;
    }

    public String toString() {
        return this.mName;
    }

    public final String getUnlocalizedName() {
        return this.mName;
    }

    public String getUnlocalizedName(ItemStack aStack) {
        return this.getHasSubtypes() ? this.mName + "." + ST.meta_(aStack) : this.mName;
    }

    public String getItemStackDisplayName(ItemStack aStack) {
        return StatCollector.translateToLocal((String)this.getUnlocalizedName(aStack));
    }

    public final boolean getShareTag() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister aIconRegister) {
        this.mIcon = aIconRegister.registerIcon(this.mModID + ":" + this.mName);
    }

    public IIcon getIconFromDamage(int aMeta) {
        return this.mIcon;
    }

    public void onCreated(ItemStack aStack, World aWorld, EntityPlayer aPlayer) {
        this.isItemStackUsable(aStack);
    }

    public ItemStack getContainerItem(ItemStack aStack) {
        return null;
    }

    public boolean hasContainerItem(ItemStack aStack) {
        return this.getContainerItem(aStack) != null;
    }

    public boolean doesContainerItemLeaveCraftingGrid(ItemStack aStack) {
        return false;
    }

    @Override
    public void updateItemStack(ItemStack aStack) {
        this.isItemStackUsable(aStack);
    }

    @Override
    public void updateItemStack(ItemStack aStack, World aWorld, int aX, int aY, int aZ) {
        this.updateItemStack(aStack);
    }

    public boolean doesSneakBypassUse(World aWorld, int aX, int aY, int aZ, EntityPlayer aPlayer) {
        return true;
    }

    public boolean isItemStackUsable(ItemStack aStack) {
        return true;
    }

    public ItemStack make(long aMetaData) {
        return ST.make(this, 1L, aMetaData);
    }

    public ItemStack make(long aAmount, long aMetaData) {
        return ST.make(this, aAmount, aMetaData);
    }

    public static class GT_Item_Dispense
    extends BehaviorProjectileDispense {
        public ItemStack dispenseStack(IBlockSource aSource, ItemStack aStack) {
            return ((ItemBase)aStack.getItem()).onDispense(aSource, aStack);
        }

        protected IProjectile getProjectileEntity(World aWorld, IPosition aPosition) {
            return null;
        }
    }
}

