/*
 * Decompiled with CFR 0.152.
 */
package gregapi.cover.covers;

import gregapi.cover.CoverData;
import gregapi.cover.covers.AbstractCoverAttachment;
import gregapi.data.CS;
import gregapi.data.LH;
import gregapi.render.BlockTextureDefault;
import gregapi.render.BlockTextureMulti;
import gregapi.render.ITexture;
import gregapi.tileentity.connectors.MultiTileEntityPipeItem;
import gregapi.util.ST;
import gregapi.util.UT;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;

public class CoverRobotArm
extends AbstractCoverAttachment {
    public final int mTiming;
    public static final ITexture sTextureIn = BlockTextureDefault.get("machines/covers/robotarm/in");
    public static final ITexture sTextureOut = BlockTextureDefault.get("machines/covers/robotarm/out");

    @Override
    public boolean interceptCoverPlacement(byte aCoverSide, CoverData aData, Entity aPlayer) {
        return !aData.mTileEntity.canTick() || !(aData.mTileEntity instanceof IInventory);
    }

    public CoverRobotArm(int aTiming) {
        this.mTiming = Math.max(1, aTiming);
    }

    @Override
    public void onCoverPlaced(byte aSide, CoverData aData, Entity aPlayer, ItemStack aCover) {
        if (aData.mTileEntity instanceof MultiTileEntityPipeItem) {
            aData.visual(aSide, (short)1);
            aData.value(aSide, (short)-1);
        }
        super.onCoverPlaced(aSide, aData, aPlayer, aCover);
    }

    @Override
    public long onToolClick(byte aSide, CoverData aData, String aTool, long aRemainingDurability, long aQuality, Entity aPlayer, List<String> aChatReturn, IInventory aPlayerInventory, boolean aSneaking, ItemStack aStack, byte aSideClicked, float aHitX, float aHitY, float aHitZ) {
        if (aTool.equals("monkeywrench")) {
            if (aData.mTileEntity instanceof MultiTileEntityPipeItem) {
                aData.visual(aSide, (short)1);
                if (aData.mValues[aSide] >= 0) {
                    aData.value(aSide, (short)(-1 - aData.mValues[aSide]));
                }
                return 1000L;
            }
            aData.visual(aSide, (short)(aData.mVisuals[aSide] == 0 ? 1 : 0));
            return 1000L;
        }
        if (aTool.equals("screwdriver")) {
            aData.value(aSide, (short)UT.Code.bind(-32768L, aData.mTileEntity instanceof MultiTileEntityPipeItem ? -1L : 32767L, aData.mValues[aSide] + (aSneaking ? -1 : 1)));
            if (aChatReturn != null) {
                aChatReturn.add(aData.mValues[aSide] < 0 ? "Takes from Slot: " + (-1 - aData.mValues[aSide]) : "Puts into Slot: " + aData.mValues[aSide]);
            }
            return 200L;
        }
        if (aTool.equals("magnifyingglass")) {
            if (aChatReturn != null) {
                aChatReturn.add(aData.mValues[aSide] < 0 ? "Takes from Slot: " + (-1 - aData.mValues[aSide]) : "Puts into Slot: " + aData.mValues[aSide]);
            }
            return 1L;
        }
        return 0L;
    }

    @Override
    public void onTickPre(byte aSide, CoverData aData, long aTimer, boolean aIsServerSide, boolean aReceivedBlockUpdate, boolean aReceivedInventoryUpdate) {
        if (aIsServerSide && CS.SERVER_TIME % (long)this.mTiming == 0L && !aData.mStopped && aData.mTileEntity instanceof IInventory) {
            if (aData.mValues[aSide] < 0) {
                if (aData.mVisuals[aSide] == 0) {
                    ST.moveFrom(aData.delegator(aSide), aData.mTileEntity.getAdjacentTileEntity(aSide), -1 - aData.mValues[aSide], null, true, false, false, true, 64, 1, 64, 1);
                } else {
                    ST.moveFrom(aData.mTileEntity.getAdjacentTileEntity(aSide), aData.delegator(aSide), -1 - aData.mValues[aSide], null, true, false, false, true, 64, 1, 64, 1);
                }
            } else if (aData.mVisuals[aSide] == 0) {
                ST.moveTo(aData.delegator(aSide), aData.mTileEntity.getAdjacentTileEntity(aSide), aData.mValues[aSide], null, false, true, false, true, 64, 1, 64, 1);
            } else {
                ST.moveTo(aData.mTileEntity.getAdjacentTileEntity(aSide), aData.delegator(aSide), aData.mValues[aSide], null, false, true, false, true, 64, 1, 64, 1);
            }
        }
    }

    @Override
    public void addToolTips(List<String> aList, ItemStack aStack, boolean aF3_H) {
        super.addToolTips(aList, aStack, aF3_H);
        aList.add(LH.Chat.CYAN + "Transfers a Stack every " + (this.mTiming == 1 ? "Tick from/to a specific Slot" : this.mTiming + " Ticks from/to a specific Slot"));
        aList.add(LH.Chat.DGRAY + LH.get("gt.lang.use.monkey.wrench.to.toggle"));
        aList.add(LH.Chat.DGRAY + LH.get("gt.lang.use.controlcover.to.toggle"));
        aList.add(LH.Chat.DGRAY + LH.get("gt.lang.use.screwdriver.to.toggle"));
    }

    @Override
    public ITexture getCoverTextureSurface(byte aCoverSide, CoverData aData) {
        return aData.mVisuals[aCoverSide] == 0 ? sTextureOut : sTextureIn;
    }

    @Override
    public ITexture getCoverTextureAttachment(byte aCoverSide, CoverData aData, byte aTextureSide) {
        return aCoverSide == aTextureSide ? BlockTextureMulti.get(BACKGROUND_COVER, aData.mVisuals[aCoverSide] == 0 ? sTextureOut : sTextureIn) : (aCoverSide == CS.OPOS[aTextureSide] ? BlockTextureMulti.get(BACKGROUND_COVER, aData.mVisuals[aCoverSide] != 0 ? sTextureOut : sTextureIn) : BACKGROUND_COVER);
    }

    @Override
    public ITexture getCoverTextureHolder(byte aCoverSide, CoverData aData, byte aTextureSide) {
        return BACKGROUND_COVER;
    }

    @Override
    public boolean needsVisualsSaved(byte aCoverSide, CoverData aData) {
        return true;
    }

    @Override
    public boolean showsConnectorFront(byte aCoverSide, CoverData aData) {
        return false;
    }

    @Override
    public boolean interceptItemInsert(byte aCoverSide, CoverData aData, int aSlot, ItemStack aStack, byte aSide) {
        return aCoverSide == aSide && aData.mVisuals[aSide] == 0;
    }

    @Override
    public boolean interceptItemExtract(byte aCoverSide, CoverData aData, int aSlot, ItemStack aStack, byte aSide) {
        return aCoverSide == aSide && aData.mVisuals[aSide] != 0;
    }
}

