/*
 * Decompiled with CFR 0.152.
 */
package gregapi.cover.covers;

import gregapi.cover.CoverData;
import gregapi.cover.covers.AbstractCoverAttachment;
import gregapi.data.CS;
import gregapi.data.FL;
import gregapi.data.LH;
import gregapi.render.BlockTextureDefault;
import gregapi.render.BlockTextureMulti;
import gregapi.render.ITexture;
import gregapi.tileentity.connectors.MultiTileEntityPipeFluid;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidHandler;

public class CoverPump
extends AbstractCoverAttachment {
    public final int mThroughput;
    public static final ITexture sTextureIn = BlockTextureDefault.get("machines/covers/pump/in");
    public static final ITexture sTextureOut = BlockTextureDefault.get("machines/covers/pump/out");

    @Override
    public boolean interceptCoverPlacement(byte aCoverSide, CoverData aData, Entity aPlayer) {
        return !aData.mTileEntity.canTick() || !(aData.mTileEntity instanceof IFluidHandler);
    }

    public CoverPump(int aThroughput) {
        this.mThroughput = aThroughput;
    }

    @Override
    public void onCoverPlaced(byte aCoverSide, CoverData aData, Entity aPlayer, ItemStack aCover) {
        if (aData.mTileEntity instanceof MultiTileEntityPipeFluid) {
            aData.visual(aCoverSide, (short)1);
        }
        super.onCoverPlaced(aCoverSide, aData, aPlayer, aCover);
    }

    @Override
    public long onToolClick(byte aSide, CoverData aData, String aTool, long aRemainingDurability, long aQuality, Entity aPlayer, List<String> aChatReturn, IInventory aPlayerInventory, boolean aSneaking, ItemStack aStack, byte aSideClicked, float aHitX, float aHitY, float aHitZ) {
        if (aTool.equals("screwdriver")) {
            aData.visual(aSide, (short)(aData.mVisuals[aSide] == 0 || aData.mTileEntity instanceof MultiTileEntityPipeFluid ? 1 : 0));
            return 1000L;
        }
        return 0L;
    }

    @Override
    public void onTickPre(byte aSide, CoverData aData, long aTimer, boolean aIsServerSide, boolean aReceivedBlockUpdate, boolean aReceivedInventoryUpdate) {
        block4: {
            long tThroughput;
            if (!aIsServerSide || aData.mStopped || CS.SERVER_TIME % 20L != 5L || !(aData.mTileEntity instanceof IFluidHandler)) break block4;
            long tMoved = 1L;
            if (aData.mVisuals[aSide] == 0) {
                for (tThroughput = (long)this.mThroughput; tMoved > 0L && tThroughput > 0L; tThroughput -= tMoved) {
                    tMoved = FL.move(aData.delegator(aSide), aData.mTileEntity.getAdjacentTank(aSide), tThroughput);
                }
            } else {
                while (tMoved > 0L && tThroughput > 0L) {
                    tMoved = FL.move(aData.mTileEntity.getAdjacentTank(aSide), aData.delegator(aSide), tThroughput);
                    tThroughput -= tMoved;
                }
            }
        }
    }

    @Override
    public void addToolTips(List<String> aList, ItemStack aStack, boolean aF3_H) {
        super.addToolTips(aList, aStack, aF3_H);
        aList.add(LH.Chat.CYAN + "Transfers " + this.mThroughput + " L/sec");
        aList.add(LH.Chat.ORANGE + "Doesn't do Fluid Blocks! Use Drain for that instead!");
        aList.add(LH.Chat.DGRAY + LH.get("gt.lang.use.controlcover.to.toggle"));
        aList.add(LH.Chat.DGRAY + LH.get("gt.lang.use.screwdriver.to.toggle"));
    }

    @Override
    public ITexture getCoverTextureSurface(byte aSide, CoverData aData) {
        return aData.mVisuals[aSide] == 0 ? sTextureOut : sTextureIn;
    }

    @Override
    public ITexture getCoverTextureAttachment(byte aSide, CoverData aData, byte aTextureSide) {
        return aSide == aTextureSide ? BlockTextureMulti.get(BACKGROUND_COVER, aData.mVisuals[aSide] == 0 ? sTextureOut : sTextureIn) : (aSide == CS.OPOS[aTextureSide] ? BlockTextureMulti.get(BACKGROUND_COVER, aData.mVisuals[aSide] != 0 ? sTextureOut : sTextureIn) : BACKGROUND_COVER);
    }

    @Override
    public ITexture getCoverTextureHolder(byte aSide, CoverData aData, byte aTextureSide) {
        return BACKGROUND_COVER;
    }

    @Override
    public boolean needsVisualsSaved(byte aSide, CoverData aData) {
        return true;
    }

    @Override
    public boolean showsConnectorFront(byte aCoverSide, CoverData aData) {
        return false;
    }

    @Override
    public boolean interceptFluidFill(byte aCoverSide, CoverData aData, byte aSide, FluidStack aFluid) {
        return aCoverSide == aSide && aData.mVisuals[aSide] == 0;
    }

    @Override
    public boolean interceptFluidDrain(byte aCoverSide, CoverData aData, byte aSide, FluidStack aFluid) {
        return aCoverSide == aSide && aData.mVisuals[aSide] != 0;
    }
}

