/*
 * Decompiled with CFR 0.152.
 */
package gregapi.cover.covers;

import gregapi.cover.CoverData;
import gregapi.cover.covers.AbstractCoverAttachmentLogistics;
import gregapi.data.LH;
import gregapi.render.BlockTextureDefault;
import gregapi.render.ITexture;
import gregapi.util.ST;
import gregapi.util.UT;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;

public class CoverLogisticsItemStorage
extends AbstractCoverAttachmentLogistics {
    public static final CoverLogisticsItemStorage INSTANCE = new CoverLogisticsItemStorage();
    public static final ITexture sTexture = BlockTextureDefault.get("machines/covers/logistics/item/storage");

    @Override
    public void addToolTips(List<String> aList, ItemStack aStack, boolean aF3_H) {
        ItemStack tStack = ST.load(aStack.getTagCompound(), "gt.filter.item");
        if (ST.valid(tStack)) {
            aList.add(LH.Chat.CYAN + tStack.getDisplayName());
        }
        aList.add(LH.Chat.ORANGE + "Not NBT sensitive!");
        super.addToolTips(aList, aStack, aF3_H);
        aList.add(LH.Chat.DGRAY + LH.get("gt.lang.use.soft.hammer.to.reset"));
    }

    @Override
    public long onToolClick(byte aCoverSide, CoverData aData, String aTool, long aRemainingDurability, long aQuality, Entity aPlayer, List<String> aChatReturn, IInventory aPlayerInventory, boolean aSneaking, ItemStack aStack, byte aSideClicked, float aHitX, float aHitY, float aHitZ) {
        if (aTool.equals("softhammer")) {
            if (aData.mNBTs[aCoverSide] != null) {
                aData.mNBTs[aCoverSide].removeTag("gt.filter.item");
            }
            return 10000L;
        }
        if (aTool.equals("magnifyingglass")) {
            if (aChatReturn != null) {
                if (aData.mNBTs[aCoverSide] == null) {
                    aChatReturn.add("No Filter Set! (Priority: " + aData.mValues[aCoverSide] + ")");
                    aData.mNBTs[aCoverSide] = null;
                } else {
                    ItemStack tStack = ST.load(aData.mNBTs[aCoverSide], "gt.filter.item");
                    if (ST.invalid(tStack)) {
                        aChatReturn.add("No Filter Set! (Priority: " + aData.mValues[aCoverSide] + ")");
                        aData.mNBTs[aCoverSide] = null;
                    } else {
                        aChatReturn.add("Stores: " + LH.Chat.CYAN + ST.regName(tStack) + LH.Chat.GRAY + " ; " + LH.Chat.CYAN + ST.meta_(tStack) + " (Priority: " + aData.mValues[aCoverSide] + ")");
                    }
                }
            }
            return 1L;
        }
        return super.onToolClick(aCoverSide, aData, aTool, aRemainingDurability, aQuality, aPlayer, aChatReturn, aPlayerInventory, aSneaking, aStack, aSideClicked, aHitX, aHitY, aHitZ);
    }

    @Override
    public boolean onCoverClickedRight(byte aCoverSide, CoverData aData, Entity aPlayer, byte aSideClicked, float aHitX, float aHitY, float aHitZ) {
        ItemStack tStack;
        if (aPlayer instanceof EntityPlayer && aData.mTileEntity.isServerSide() && (aData.mNBTs[aCoverSide] == null || !aData.mNBTs[aCoverSide].hasKey("gt.filter.item")) && ST.valid(tStack = ST.make(((EntityPlayer)aPlayer).getCurrentEquippedItem(), null, null))) {
            aData.mNBTs[aCoverSide] = ST.save("gt.filter.item", tStack);
            UT.Sounds.send("random.click", aData.mTileEntity);
            UT.Entities.sendchat((Object)aPlayer, "Stores: " + LH.Chat.CYAN + ST.regName(tStack) + LH.Chat.GRAY + " ; " + LH.Chat.CYAN + ST.meta_(tStack));
        }
        return true;
    }

    @Override
    public ITexture getCoverTextureSurface(byte aCoverSide, CoverData aData) {
        return sTexture;
    }
}

