/*
 * Decompiled with CFR 0.152.
 */
package gregapi.cover.covers;

import gregapi.cover.CoverData;
import gregapi.cover.ICover;
import gregapi.cover.ITileEntityCoverable;
import gregapi.data.CS;
import gregapi.data.LH;
import gregapi.render.BlockTextureDefault;
import gregapi.render.ITexture;
import gregapi.util.ST;
import gregapi.util.UT;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;

public abstract class AbstractCoverDefault
implements ICover {
    public static final ITexture BACKGROUND_COVER = BlockTextureDefault.get("machines/covers/base");

    @Override
    public boolean interceptCoverPlacement(byte aCoverSide, CoverData aData, Entity aPlayer) {
        return false;
    }

    @Override
    public boolean interceptCoverRemoval(byte aCoverSide, CoverData aData, Entity aPlayer) {
        return false;
    }

    @Override
    public void onCoverLoaded(byte aCoverSide, CoverData aData) {
    }

    @Override
    public void onCoverPlaced(byte aCoverSide, CoverData aData, Entity aPlayer, ItemStack aCover) {
        if (aPlayer != null) {
            UT.Sounds.send(CS.SFX.GT_SCREWDRIVER, aData.mTileEntity);
        }
    }

    @Override
    public void onCoverRemove(byte aCoverSide, CoverData aData, Entity aPlayer) {
    }

    @Override
    public void onTickPre(byte aCoverSide, CoverData aData, long aTimer, boolean aIsServerSide, boolean aReceivedBlockUpdate, boolean aReceivedInventoryUpdate) {
    }

    @Override
    public void onTickPost(byte aCoverSide, CoverData aData, long aTimer, boolean aIsServerSide, boolean aReceivedBlockUpdate, boolean aReceivedInventoryUpdate) {
    }

    @Override
    public boolean onCoverClickedLeft(byte aCoverSide, CoverData aData, Entity aPlayer, byte aSideClicked, float aHitX, float aHitY, float aHitZ) {
        return false;
    }

    @Override
    public boolean interceptClickLeft(byte aCoverSide, CoverData aData, Entity aPlayer, byte aSideClicked, float aHitX, float aHitY, float aHitZ) {
        return true;
    }

    @Override
    public boolean onCoverClickedRight(byte aCoverSide, CoverData aData, Entity aPlayer, byte aSideClicked, float aHitX, float aHitY, float aHitZ) {
        return false;
    }

    @Override
    public boolean interceptClickRight(byte aCoverSide, CoverData aData, Entity aPlayer, byte aSideClicked, float aHitX, float aHitY, float aHitZ) {
        return true;
    }

    @Override
    public long onToolClick(byte aCoverSide, CoverData aData, String aTool, long aRemainingDurability, long aQuality, Entity aPlayer, List<String> aChatReturn, IInventory aPlayerInventory, boolean aSneaking, ItemStack aStack, byte aSideClicked, float aHitX, float aHitY, float aHitZ) {
        return 0L;
    }

    @Override
    public ItemStack getCoverItem(byte aCoverSide, CoverData aData) {
        return ST.make((long)aData.mIDs[aCoverSide], 1L, (long)aData.mMetas[aCoverSide], aData.mNBTs[aCoverSide] == null || aData.mNBTs[aCoverSide].hasNoTags() ? null : aData.mNBTs[aCoverSide]);
    }

    @Override
    public ITexture getCoverTextureSurface(byte aCoverSide, CoverData aData) {
        return null;
    }

    @Override
    public ITexture getCoverTextureAttachment(byte aCoverSide, CoverData aData, byte aTextureSide) {
        return this.getCoverTextureSurface(aCoverSide, aData);
    }

    @Override
    public ITexture getCoverTextureHolder(byte aCoverSide, CoverData aData, byte aTextureSide) {
        return this.getCoverTextureSurface(aCoverSide, aData);
    }

    @Override
    public boolean isSolid(byte aCoverSide, CoverData aData) {
        return true;
    }

    @Override
    public boolean isOpaque(byte aCoverSide, CoverData aData) {
        return true;
    }

    @Override
    public boolean isSealable(byte aCoverSide, CoverData aData) {
        return true;
    }

    @Override
    public boolean isFullTexture(byte aCoverSide, CoverData aData) {
        return true;
    }

    @Override
    public boolean isDecorative(byte aCoverSide, CoverData aData) {
        return false;
    }

    @Override
    public boolean showsConnectorFront(byte aCoverSide, CoverData aData) {
        return true;
    }

    @Override
    public boolean needsVisualsSaved(byte aCoverSide, CoverData aData) {
        return false;
    }

    @Override
    public boolean onWalkOver(byte aCoverSide, CoverData aData, Entity aEntity) {
        return true;
    }

    @Override
    public void onAfterCrowbar(ITileEntityCoverable aTileEntity) {
        UT.Sounds.send("random.break", 1.0f, -1.0f, aTileEntity);
    }

    @Override
    public void onBlockUpdate(byte aCoverSide, CoverData aData) {
    }

    @Override
    public void onStoppedUpdate(byte aCoverSide, CoverData aData, boolean aStopped) {
    }

    @Override
    public void addToolTips(List<String> aList, ItemStack aStack, boolean aF3_H) {
        aList.add(LH.Chat.DGRAY + LH.get("gt.lang.cover.tooltip"));
    }

    @Override
    public byte getRedstoneIn(byte aCoverSide, CoverData aData) {
        return UT.Code.bind4(aData.mTileEntity.getWorld().getIndirectPowerLevelTo(aData.mTileEntity.getOffsetX(aCoverSide), aData.mTileEntity.getOffsetY(aCoverSide), aData.mTileEntity.getOffsetZ(aCoverSide), (int)aCoverSide));
    }

    @Override
    public byte getRedstoneOutWeak(byte aCoverSide, CoverData aData, byte aDefaultRedstone) {
        return aDefaultRedstone;
    }

    @Override
    public byte getRedstoneOutStrong(byte aCoverSide, CoverData aData, byte aDefaultRedstone) {
        return aDefaultRedstone;
    }

    @Override
    public Object getGUIServer(byte aCoverSide, CoverData aData, EntityPlayer aPlayer) {
        return null;
    }

    @Override
    public Object getGUIClient(byte aCoverSide, CoverData aData, EntityPlayer aPlayer) {
        return null;
    }

    @Override
    public float[] getCoverBounds(byte aCoverSide, CoverData aData) {
        return BOXES_COVERS[aCoverSide];
    }

    @Override
    public float[] getHolderBounds(byte aCoverSide, CoverData aData) {
        return BOXES_HOLDERS[aCoverSide];
    }

    @Override
    public void getCollisions(byte aCoverSide, CoverData aData, AxisAlignedBB aAABB, List<AxisAlignedBB> aList, Entity aEntity) {
        aData.box(aAABB, aList, this.getCoverBounds(aCoverSide, aData));
    }

    @Override
    public boolean interceptConnect(byte aCoverSide, CoverData aData) {
        return false;
    }

    @Override
    public boolean interceptDisconnect(byte aCoverSide, CoverData aData) {
        return false;
    }

    @Override
    public boolean interceptItemInsert(byte aCoverSide, CoverData aData, int aSlot, ItemStack aStack, byte aSide) {
        return false;
    }

    @Override
    public boolean interceptItemExtract(byte aCoverSide, CoverData aData, int aSlot, ItemStack aStack, byte aSide) {
        return false;
    }

    @Override
    public boolean getAccessibleSlotsFromSideOverride(byte aCoverSide, CoverData aData, byte aSide) {
        return false;
    }

    @Override
    public boolean canInsertItemOverride(byte aCoverSide, CoverData aData, int aSlot, ItemStack aStack, byte aSide) {
        return false;
    }

    @Override
    public boolean canExtractItemOverride(byte aCoverSide, CoverData aData, int aSlot, ItemStack aStack, byte aSide) {
        return false;
    }

    @Override
    public int[] getAccessibleSlotsFromSide(byte aCoverSide, CoverData aData, byte aSide, int[] aDefault) {
        return aDefault;
    }

    @Override
    public boolean canInsertItem(byte aCoverSide, CoverData aData, int aSlot, ItemStack aStack, byte aSide) {
        return true;
    }

    @Override
    public boolean canExtractItem(byte aCoverSide, CoverData aData, int aSlot, ItemStack aStack, byte aSide) {
        return true;
    }

    @Override
    public boolean interceptFluidFill(byte aCoverSide, CoverData aData, byte aSide, FluidStack aFluidToFill) {
        return false;
    }

    @Override
    public boolean interceptFluidDrain(byte aCoverSide, CoverData aData, byte aSide, FluidStack aFluidToDrain) {
        return false;
    }

    @Override
    public boolean getFluidTankFillableOverride(byte aCoverSide, CoverData aData, byte aSide, FluidStack aFluidToFill) {
        return false;
    }

    @Override
    public boolean getFluidTankDrainableOverride(byte aCoverSide, CoverData aData, byte aSide, FluidStack aFluidToDrain) {
        return false;
    }

    @Override
    public boolean getFluidTanksOverride(byte aCoverSide, CoverData aData, byte aSide) {
        return false;
    }

    @Override
    public IFluidTank getFluidTankFillable(byte aCoverSide, CoverData aData, byte aSide, FluidStack aFluidToFill, IFluidTank aDefault) {
        return aDefault;
    }

    @Override
    public IFluidTank getFluidTankDrainable(byte aCoverSide, CoverData aData, byte aSide, FluidStack aFluidToDrain, IFluidTank aDefault) {
        return aDefault;
    }

    @Override
    public IFluidTank[] getFluidTanks(byte aCoverSide, CoverData aData, byte aSide, IFluidTank[] aDefault) {
        return aDefault;
    }
}

