/*
 * Decompiled with CFR 0.152.
 */
package gregapi.block.tree;

import gregapi.block.BlockBaseMeta;
import gregapi.data.CS;
import gregapi.data.MD;
import gregapi.render.IIconContainer;
import gregapi.util.ST;
import mods.railcraft.common.carts.EntityTunnelBore;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.item.ItemBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public abstract class BlockBaseTree
extends BlockBaseMeta {
    public BlockBaseTree(Class<? extends ItemBlock> aItemClass, String aNameInternal, Material aMaterial, Block.SoundType aSoundType, long aMaxMeta, IIconContainer[] aIcons) {
        super(aItemClass, aNameInternal, aMaterial, aSoundType, aMaxMeta, aIcons);
        if (MD.RC.mLoaded) {
            try {
                EntityTunnelBore.addMineableBlock((Block)this);
            }
            catch (Throwable e) {
                e.printStackTrace(CS.ERR);
            }
        }
        if (CS.COMPAT_FR != null) {
            CS.COMPAT_FR.addToBackpacks("forester", ST.make(this, 1L, 32767L));
        }
    }

    public abstract int getLeavesRangeSide(byte var1);

    public abstract int getLeavesRangeYPos(byte var1);

    public abstract int getLeavesRangeYNeg(byte var1);

    public void breakBlock(World aWorld, int aX, int aY, int aZ, Block aBlock, int aMeta) {
        int tRangeSide = this.getLeavesRangeSide((byte)aMeta) + 1;
        int tRangeYNeg = this.getLeavesRangeYNeg((byte)aMeta) + 1;
        int tRangeYPos = this.getLeavesRangeYPos((byte)aMeta) + 1;
        if (!aWorld.isRemote && aWorld.checkChunksExist(aX - tRangeSide, aY - tRangeYNeg, aZ - tRangeSide, aX + tRangeSide, aY + tRangeYPos, aZ + tRangeSide)) {
            --tRangeYNeg;
            --tRangeYPos;
            for (int i = -(--tRangeSide); i <= tRangeSide; ++i) {
                for (int j = -tRangeYNeg; j <= tRangeYPos; ++j) {
                    for (int k = -tRangeSide; k <= tRangeSide; ++k) {
                        Block tBlock = aWorld.getBlock(aX + i, aY + j, aZ + k);
                        if (!tBlock.isLeaves((IBlockAccess)aWorld, aX + i, aY + j, aZ + k)) continue;
                        tBlock.beginLeavesDecay(aWorld, aX + i, aY + j, aZ + k);
                    }
                }
            }
        }
    }
}

