/*
 * Decompiled with CFR 0.152.
 */
package gregapi.block.tree;

import gregapi.block.tree.BlockBaseTree;
import gregapi.data.CS;
import gregapi.data.MT;
import gregapi.data.OP;
import gregapi.data.RM;
import gregapi.render.IIconContainer;
import gregapi.util.CR;
import gregapi.util.ST;
import gregapi.util.UT;
import gregapi.util.WD;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class BlockBaseLog
extends BlockBaseTree {
    public BlockBaseLog(Class<? extends ItemBlock> aItemClass, String aNameInternal, Material aMaterial, Block.SoundType aSoundType, long aMaxMeta, IIconContainer[] aIcons) {
        super(aItemClass, aNameInternal, aMaterial, aSoundType, Math.min(4L, aMaxMeta), aIcons);
        for (byte tMeta = 0; tMeta < this.maxMeta(); tMeta = (byte)(tMeta + 1)) {
            RM.chisel(aNameInternal + "." + tMeta, ST.make(this, 1L, (long)tMeta), ST.make(this, 1L, (long)(tMeta | 0xC)));
            CR.shapeless(ST.make(this, 4L, (long)(tMeta | 0xC)), CR.DEF_NCC, new Object[]{OP.dust.dat(MT.Bark), ST.make(this, 1L, (long)tMeta), ST.make(this, 1L, (long)tMeta), ST.make(this, 1L, (long)tMeta), ST.make(this, 1L, (long)tMeta)});
            CR.shapeless(ST.make(this, 3L, (long)(tMeta | 0xC)), CR.DEF_NCC, new Object[]{OP.dust.dat(MT.Bark), ST.make(this, 1L, (long)tMeta), ST.make(this, 1L, (long)tMeta), ST.make(this, 1L, (long)tMeta)});
            CR.shapeless(ST.make(this, 2L, (long)(tMeta | 0xC)), CR.DEF_NCC, new Object[]{OP.dust.dat(MT.Bark), ST.make(this, 1L, (long)tMeta), ST.make(this, 1L, (long)tMeta)});
            CR.shapeless(ST.make(this, 1L, (long)(tMeta | 0xC)), CR.DEF_NCC, new Object[]{OP.dust.dat(MT.Bark), ST.make(this, 1L, (long)tMeta)});
            CR.shapeless(ST.make(this, 1L, (long)(tMeta | 0xC)), CR.DEF_NCC, new Object[]{OP.dustSmall.dat(MT.Bark), ST.make(this, 1L, (long)tMeta)});
        }
    }

    @Override
    public String getHarvestTool(int aMeta) {
        return "axe";
    }

    @Override
    public int damageDropped(int aMeta) {
        return aMeta & 3;
    }

    @Override
    public int getDamageValue(World aWorld, int aX, int aY, int aZ) {
        return WD.meta((IBlockAccess)aWorld, aX, aY, aZ) & 3;
    }

    @Override
    public float getBlockHardness(World aWorld, int aX, int aY, int aZ) {
        return Blocks.log.getBlockHardness(aWorld, aX, aY, aZ);
    }

    @Override
    public float getExplosionResistance(byte aMeta) {
        return Blocks.log.getExplosionResistance(null);
    }

    @Override
    public int getItemStackLimit(ItemStack aStack) {
        return UT.Code.bindStack(OP.log.mDefaultStackSize);
    }

    public int getRenderType() {
        return 31;
    }

    @Override
    public boolean doesPistonPush(byte aMeta) {
        return true;
    }

    @Override
    public boolean isSealable(byte aMeta, byte aSide) {
        return false;
    }

    @Override
    public boolean isFireSource(World aWorld, int aX, int aY, int aZ, ForgeDirection aSide) {
        return false;
    }

    @Override
    public int getFlammability(byte aMeta) {
        return 0;
    }

    @Override
    public int getFireSpreadSpeed(byte aMeta) {
        return 0;
    }

    public int onBlockPlaced(World aWorld, int aX, int aY, int aZ, int aSide, float aHitX, float aHitY, float aHitZ, int aMeta) {
        return CS.PILLAR_DATA_SIDE[aMeta][aSide];
    }

    @Override
    public IIcon getIcon(int aSide, int aMeta) {
        return this.mIcons[2 * (aMeta & 3) + (CS.PILLAR_TO_AXIS[aMeta][aSide] ? 0 : 1)].getIcon(0);
    }

    public boolean isWood(IBlockAccess aWorld, int aX, int aY, int aZ) {
        return true;
    }

    @Override
    public void getSubBlocks(Item aItem, CreativeTabs aTab, List aList) {
        for (int i = 0; i < this.maxMeta(); ++i) {
            aList.add(ST.make(aItem, 1L, (long)i));
            aList.add(ST.make(aItem, 1L, (long)(i | 0xC)));
        }
    }
}

