/*
 * Decompiled with CFR 0.152.
 */
package gregapi.block.tree;

import gregapi.block.BlockBaseMeta;
import gregapi.data.CS;
import gregapi.data.MD;
import gregapi.data.OD;
import gregapi.data.OP;
import gregapi.render.IIconContainer;
import gregapi.util.OM;
import gregapi.util.ST;
import gregapi.util.UT;
import gregapi.util.WD;
import mods.railcraft.common.carts.EntityTunnelBore;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class BlockBaseBeam
extends BlockBaseMeta {
    public BlockBaseBeam(Class<? extends ItemBlock> aItemClass, String aNameInternal, Material aMaterial, Block.SoundType aSoundType, long aMaxMeta, IIconContainer[] aIcons) {
        super(aItemClass, aNameInternal, aMaterial, aSoundType, Math.min(4L, aMaxMeta), aIcons);
        for (int i = 0; i < 16; ++i) {
            OM.reg(ST.make(this, 1L, (long)i), (Object)OD.beamWood);
        }
        if (MD.RC.mLoaded) {
            try {
                EntityTunnelBore.addMineableBlock((Block)this);
            }
            catch (Throwable e) {
                e.printStackTrace(CS.ERR);
            }
        }
        if (CS.COMPAT_FR != null) {
            CS.COMPAT_FR.addToBackpacks("forester", ST.make(this, 1L, 32767L));
        }
        if (CS.COMPAT_FR != null) {
            CS.COMPAT_FR.addToBackpacks("builder", ST.make(this, 1L, 32767L));
        }
    }

    @Override
    public String getHarvestTool(int aMeta) {
        return "axe";
    }

    @Override
    public int damageDropped(int aMeta) {
        return aMeta & 3;
    }

    @Override
    public int getDamageValue(World aWorld, int aX, int aY, int aZ) {
        return WD.meta((IBlockAccess)aWorld, aX, aY, aZ) & 3;
    }

    @Override
    public float getBlockHardness(World aWorld, int aX, int aY, int aZ) {
        return Blocks.log.getBlockHardness(aWorld, aX, aY, aZ) / 2.0f;
    }

    @Override
    public float getExplosionResistance(byte aMeta) {
        return Blocks.log.getExplosionResistance(null);
    }

    @Override
    public int getItemStackLimit(ItemStack aStack) {
        return UT.Code.bindStack(OP.log.mDefaultStackSize);
    }

    public int getRenderType() {
        return 31;
    }

    @Override
    public boolean doesPistonPush(byte aMeta) {
        return true;
    }

    @Override
    public boolean isSealable(byte aMeta, byte aSide) {
        return false;
    }

    @Override
    public boolean isFireSource(World aWorld, int aX, int aY, int aZ, ForgeDirection aSide) {
        return false;
    }

    public int onBlockPlaced(World aWorld, int aX, int aY, int aZ, int aSide, float aHitX, float aHitY, float aHitZ, int aMeta) {
        return CS.PILLAR_DATA_SIDE[aMeta][aSide];
    }

    @Override
    public IIcon getIcon(int aSide, int aMeta) {
        return this.mIcons[2 * (aMeta & 3) + (CS.PILLAR_TO_AXIS[aMeta][aSide] ? 0 : 1)].getIcon(0);
    }
}

