/*
 * Decompiled with CFR 0.152.
 */
package gregapi.block.prefixblock;

import gregapi.block.prefixblock.PrefixBlock;
import gregapi.data.CS;
import gregapi.network.INetworkHandler;
import gregapi.network.packets.data.PacketSyncDataName;
import gregapi.network.packets.data.PacketSyncDataShort;
import gregapi.render.IRenderedBlockObject;
import gregapi.render.IRenderedBlockObjectSideCheck;
import gregapi.render.ITexture;
import gregapi.tileentity.ITileEntityScheduledUpdate;
import gregapi.tileentity.ITileEntitySpecificPlacementBehavior;
import gregapi.tileentity.ITileEntitySynchronising;
import gregapi.tileentity.base.TileEntityBase01Root;
import gregapi.util.WD;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.world.IBlockAccess;

public class PrefixBlockTileEntity
extends TileEntityBase01Root
implements IRenderedBlockObject,
IRenderedBlockObjectSideCheck,
ITileEntityScheduledUpdate,
ITileEntitySynchronising,
ITileEntitySpecificPlacementBehavior {
    public short mMetaData = Short.MAX_VALUE;
    public boolean mBlocked = true;
    public NBTTagCompound mItemNBT = null;
    private ITexture mTexture;

    public PrefixBlockTileEntity() {
        super(false);
    }

    @Override
    public String getTileEntityName() {
        return "gt.MetaBlockTileEntity";
    }

    @Override
    public void onScheduledUpdate() {
        this.mBlocked = WD.visOcc(this.worldObj, this.xCoord, this.yCoord, this.zCoord, false, true);
        if (!this.mBlocked) {
            CS.NW_API.sendToAllPlayersInRange(new PacketSyncDataShort(this.getCoords(), this.mMetaData), this.worldObj, this.getCoords());
            if (this.mItemNBT != null && this.mItemNBT.hasKey("display")) {
                CS.NW_API.sendToAllPlayersInRange(new PacketSyncDataName(this.getCoords(), this.mItemNBT.getCompoundTag("display").getString("Name")), this.worldObj, this.getCoords());
            }
        }
    }

    @Override
    public void onAdjacentBlockChange(int aX, int aY, int aZ) {
        if (!this.worldObj.isRemote && this.mBlocked) {
            this.mBlocked = false;
            CS.NW_API.sendToAllPlayersInRange(new PacketSyncDataShort(this.getCoords(), this.mMetaData), this.worldObj, this.getCoords());
            if (this.mItemNBT != null && this.mItemNBT.hasKey("display")) {
                CS.NW_API.sendToAllPlayersInRange(new PacketSyncDataName(this.getCoords(), this.mItemNBT.getCompoundTag("display").getString("Name")), this.worldObj, this.getCoords());
            }
        }
    }

    @Override
    public void sendUpdateToPlayer(EntityPlayerMP aPlayer) {
        this.mBlocked = WD.visOcc(this.worldObj, this.xCoord, this.yCoord, this.zCoord, true, true);
        if (!this.mBlocked) {
            CS.NW_API.sendToPlayer(new PacketSyncDataShort(this.getCoords(), this.mMetaData), aPlayer);
            if (this.mItemNBT != null && this.mItemNBT.hasKey("display")) {
                CS.NW_API.sendToPlayer(new PacketSyncDataName(this.getCoords(), this.mItemNBT.getCompoundTag("display").getString("Name")), aPlayer);
            }
        }
    }

    @Override
    public ITexture getTexture(Block aBlock, int aRenderPass, byte aSide, boolean[] aShouldSideBeRendered) {
        if (!aShouldSideBeRendered[aSide]) {
            return null;
        }
        if (this.mTexture == null) {
            this.mTexture = aBlock instanceof PrefixBlock ? ((PrefixBlock)aBlock).getTexture(this.mMetaData, this.worldObj != null) : null;
        }
        return this.mTexture;
    }

    @Override
    public boolean renderItem(Block aBlock, RenderBlocks aRenderer) {
        return false;
    }

    @Override
    public boolean renderBlock(Block aBlock, RenderBlocks aRenderer, IBlockAccess aWorld, int aX, int aY, int aZ) {
        return false;
    }

    @Override
    public boolean setBlockBounds(Block aBlock, int aRenderPass, boolean[] aShouldSideBeRendered) {
        return false;
    }

    @Override
    public int getRenderPasses(Block aBlock, boolean[] aShouldSideBeRendered) {
        return 1;
    }

    @Override
    public void readFromNBT(NBTTagCompound aNBT) {
        super.readFromNBT(aNBT);
        this.mMetaData = aNBT.getShort("m");
        if (aNBT.hasKey("gt.nbt.drop")) {
            this.mItemNBT = aNBT.getCompoundTag("gt.nbt.drop");
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound aNBT) {
        super.writeToNBT(aNBT);
        aNBT.setShort("m", this.mMetaData);
        if (this.mItemNBT != null && !this.mItemNBT.hasNoTags()) {
            aNBT.setTag("gt.nbt.drop", (NBTBase)this.mItemNBT);
        }
    }

    @Override
    public void processPacket(INetworkHandler aNetworkHandler) {
    }

    public Packet getDescriptionPacket() {
        return null;
    }

    @Override
    public Object getGUIClient(int aGUIID, EntityPlayer aPlayer) {
        return null;
    }

    @Override
    public Object getGUIServer(int aGUIID, EntityPlayer aPlayer) {
        return null;
    }
}

