/*
 * Decompiled with CFR 0.152.
 */
package gregapi.block.metatype;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregapi.block.BlockBaseMeta;
import gregapi.block.metatype.BlockBasePlanks;
import gregapi.block.metatype.ItemBlockMetaType;
import gregapi.data.CS;
import gregapi.data.OP;
import gregapi.data.RM;
import gregapi.oredict.OreDictMaterial;
import gregapi.render.IIconContainer;
import gregapi.util.CR;
import gregapi.util.ST;
import gregapi.util.UT;
import gregapi.util.WD;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockMetaType
extends BlockBaseMeta {
    public final float mHardnessMultiplier;
    public final float mResistanceMultiplier;
    public final int mHarvestLevel;
    public final byte mSide;
    public final byte mOctantcount;
    public final boolean mIsWall;
    public final boolean mIsSlab;
    public final boolean mIsStair;
    public final boolean mIsPrimary;
    public final BlockMetaType mBlock;
    public final BlockMetaType[] mSlabs;

    public BlockMetaType(Class<? extends ItemBlock> aItemClass, Material aVanillaMaterial, Block.SoundType aSoundType, String aNameInternal, String aDefaultLocalised, OreDictMaterial aMaterial, float aResistanceMultiplier, float aHardnessMultiplier, int aHarvestLevel, int aCount, IIconContainer[] aIcons) {
        super(aItemClass == null ? ItemBlockMetaType.class : aItemClass, aNameInternal, aVanillaMaterial, aSoundType, aCount, aIcons);
        if (aItemClass == null) {
            aItemClass = ItemBlockMetaType.class;
        }
        this.onBlockCreation(aItemClass, aVanillaMaterial, aSoundType, aNameInternal, aDefaultLocalised, aMaterial, aResistanceMultiplier, aHardnessMultiplier, aHarvestLevel, aCount, aIcons);
        this.setHardness(aHardnessMultiplier * 1.5f);
        this.setResistance(aResistanceMultiplier * 10.0f);
        this.setCreativeTab(CreativeTabs.tabBlock);
        this.mIsWall = false;
        this.mIsSlab = false;
        this.mIsStair = false;
        this.mIsPrimary = true;
        this.mBlock = this;
        this.mOctantcount = (byte)8;
        this.mSide = (byte)6;
        this.mHarvestLevel = aHarvestLevel;
        this.mHardnessMultiplier = aHardnessMultiplier;
        this.mResistanceMultiplier = aResistanceMultiplier;
        this.mSlabs = new BlockMetaType[]{this.makeSlab(aItemClass, aVanillaMaterial, aSoundType, aNameInternal, aDefaultLocalised, aMaterial, aResistanceMultiplier / 2.0f, aHardnessMultiplier / 2.0f, aHarvestLevel, this.maxMeta(), aIcons, (byte)0, this), this.makeSlab(aItemClass, aVanillaMaterial, aSoundType, aNameInternal, aDefaultLocalised, aMaterial, aResistanceMultiplier / 2.0f, aHardnessMultiplier / 2.0f, aHarvestLevel, this.maxMeta(), aIcons, (byte)1, this), this.makeSlab(aItemClass, aVanillaMaterial, aSoundType, aNameInternal, aDefaultLocalised, aMaterial, aResistanceMultiplier / 2.0f, aHardnessMultiplier / 2.0f, aHarvestLevel, this.maxMeta(), aIcons, (byte)2, this), this.makeSlab(aItemClass, aVanillaMaterial, aSoundType, aNameInternal, aDefaultLocalised, aMaterial, aResistanceMultiplier / 2.0f, aHardnessMultiplier / 2.0f, aHarvestLevel, this.maxMeta(), aIcons, (byte)3, this), this.makeSlab(aItemClass, aVanillaMaterial, aSoundType, aNameInternal, aDefaultLocalised, aMaterial, aResistanceMultiplier / 2.0f, aHardnessMultiplier / 2.0f, aHarvestLevel, this.maxMeta(), aIcons, (byte)4, this), this.makeSlab(aItemClass, aVanillaMaterial, aSoundType, aNameInternal, aDefaultLocalised, aMaterial, aResistanceMultiplier / 2.0f, aHardnessMultiplier / 2.0f, aHarvestLevel, this.maxMeta(), aIcons, (byte)5, this), null};
        this.mSlabs[6] = this.mSlabs[0];
        ST.hide(this.mSlabs[1]);
        ST.hide(this.mSlabs[2]);
        ST.hide(this.mSlabs[3]);
        ST.hide(this.mSlabs[4]);
        ST.hide(this.mSlabs[5]);
        for (int i = 0; i < 16; i = (int)((byte)(i + 1))) {
            CR.shaped(ST.make(this, 1L, (long)i), CR.DEF, "X", "X", 'X', ST.make(this.mSlabs[0], 1L, (long)i));
            if (this instanceof BlockBasePlanks) continue;
            RM.sawing(16L, 16L, false, 5L, ST.make(this, 1L, (long)i), ST.make(this.mSlabs[0], 2L, (long)i));
            CR.shaped(ST.make(this.mSlabs[0], 2L, (long)i), CR.DEF, "sX", 'X', ST.make(this, 1L, (long)i));
        }
        if (CS.COMPAT_FR != null) {
            CS.COMPAT_FR.addToBackpacks("builder", ST.make(this, 1L, 32767L));
        }
    }

    protected BlockMetaType makeSlab(Class<? extends ItemBlock> aItemClass, Material aVanillaMaterial, Block.SoundType aVanillaSoundType, String aName, String aDefaultLocalised, OreDictMaterial aMaterial, float aResistanceMultiplier, float aHardnessMultiplier, int aHarvestLevel, int aCount, IIconContainer[] aIcons, byte aSlabType, BlockMetaType aBlock) {
        return new BlockMetaType(aItemClass, aVanillaMaterial, aVanillaSoundType, aName, aDefaultLocalised, aMaterial, aResistanceMultiplier, aHardnessMultiplier, aHarvestLevel, aCount, aIcons, aSlabType, aBlock);
    }

    protected BlockMetaType(Class<? extends ItemBlock> aItemClass, Material aVanillaMaterial, Block.SoundType aSoundType, String aName, String aDefaultLocalised, OreDictMaterial aMaterial, float aResistanceMultiplier, float aHardnessMultiplier, int aHarvestLevel, int aCount, IIconContainer[] aIcons, byte aSlabType, BlockMetaType aBlock) {
        super(aItemClass == null ? ItemBlockMetaType.class : aItemClass, aName + ".slab." + aSlabType, aVanillaMaterial, aSoundType, aCount, aIcons);
        if (aItemClass == null) {
            aItemClass = ItemBlockMetaType.class;
        }
        this.onSlabCreation(aItemClass, aVanillaMaterial, aSoundType, aName, aDefaultLocalised, aMaterial, aResistanceMultiplier, aHardnessMultiplier, aHarvestLevel, aCount, aIcons, aSlabType, aBlock);
        this.setHardness(aHardnessMultiplier * 1.5f);
        this.setResistance(aResistanceMultiplier * 10.0f);
        this.mIsWall = false;
        this.mIsSlab = true;
        this.mIsStair = false;
        this.mIsPrimary = aSlabType == 0;
        this.mBlock = aBlock;
        this.mOctantcount = (byte)4;
        this.mSide = aSlabType;
        this.mHarvestLevel = aHarvestLevel;
        this.mHardnessMultiplier = aHardnessMultiplier;
        this.mResistanceMultiplier = aResistanceMultiplier;
        this.mSlabs = null;
        this.setBlockBounds(this.mSide == 5 ? 0.5f : 0.0f, this.mSide == 1 ? 0.5f : 0.0f, this.mSide == 3 ? 0.5f : 0.0f, this.mSide == 4 ? 0.5f : 1.0f, this.mSide == 0 ? 0.5f : 1.0f, this.mSide == 2 ? 0.5f : 1.0f);
        if (CS.COMPAT_FR != null) {
            CS.COMPAT_FR.addToBackpacks("builder", ST.make(this, 1L, 32767L));
        }
    }

    public void onBlockCreation(Class<? extends ItemBlock> aItemClass, Material aVanillaMaterial, Block.SoundType aSoundType, String aName, String aDefaultLocalised, OreDictMaterial aMaterial, float aResistanceMultiplier, float aHardnessMultiplier, int aHarvestLevel, int aCount, IIconContainer[] aIcons) {
    }

    public void onSlabCreation(Class<? extends ItemBlock> aItemClass, Material aVanillaMaterial, Block.SoundType aSoundType, String aName, String aDefaultLocalised, OreDictMaterial aMaterial, float aResistanceMultiplier, float aHardnessMultiplier, int aHarvestLevel, int aCount, IIconContainer[] aIcons, byte aSlabType, BlockMetaType aBlock) {
    }

    public boolean onBlockActivated(World aWorld, int aX, int aY, int aZ, EntityPlayer aPlayer, int aSide, float aHitX, float aHitY, float aHitZ) {
        byte aMetaData;
        if (this.mBlock == this || aSide != CS.OPOS[this.mSide] || this.mBlock.getCollisionBoundingBoxFromPool(aWorld, aX, aY, aZ) != null && !aWorld.checkNoEntityCollision(this.mBlock.getCollisionBoundingBoxFromPool(aWorld, aX, aY, aZ))) {
            return false;
        }
        ItemStack aStack = aPlayer.getCurrentEquippedItem();
        if (ST.equal(aStack, (Block)this.mBlock.mSlabs[0], (long)(aMetaData = WD.meta((IBlockAccess)aWorld, aX, aY, aZ)))) {
            aWorld.setBlock(aX, aY, aZ, (Block)this.mBlock, (int)aMetaData, 3);
            aWorld.playSoundEffect((double)((float)aX + 0.5f), (double)((float)aY + 0.5f), (double)((float)aZ + 0.5f), this.mBlock.stepSound.func_150496_b(), (this.mBlock.stepSound.getVolume() + 1.0f) / 2.0f, this.mBlock.stepSound.getPitch() * 0.8f);
            if (!UT.Entities.hasInfiniteItems(aPlayer)) {
                --aStack.stackSize;
            }
            return true;
        }
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean shouldSideBeRendered(IBlockAccess aWorld, int aX, int aY, int aZ, int aSide) {
        Block aBlock;
        if (aSide == CS.OPOS[this.mSide]) {
            return true;
        }
        if (aSide != this.mSide && CS.SIDES_VALID[this.mSide] && (aBlock = aWorld.getBlock(aX, aY, aZ)) instanceof BlockMetaType && ((BlockMetaType)aBlock).mSide == this.mSide) {
            return aBlock.getRenderBlockPass() != 0;
        }
        return super.shouldSideBeRendered(aWorld, aX, aY, aZ, aSide);
    }

    @Override
    public String getHarvestTool(int aMeta) {
        return "pickaxe";
    }

    @Override
    public int getHarvestLevel(int aMeta) {
        return this.mHarvestLevel;
    }

    @Override
    public float getBlockHardness(World aWorld, int aX, int aY, int aZ) {
        return Blocks.stone.getBlockHardness(aWorld, aX, aY, aZ) * this.mHardnessMultiplier;
    }

    @Override
    public float getExplosionResistance(byte aMeta) {
        return Blocks.stone.getExplosionResistance(null) * this.mResistanceMultiplier;
    }

    @Override
    public boolean isSideSolid(int aMeta, byte aSide) {
        return this.mBlock == this || this.mSide == aSide;
    }

    @Override
    public boolean isNormalCube(IBlockAccess aWorld, int aX, int aY, int aZ) {
        return this.mBlock == this;
    }

    public boolean isNormalCube() {
        return this.mBlock == this;
    }

    @Override
    public boolean isOpaqueCube() {
        return this.mBlock == this;
    }

    @Override
    public boolean renderAsNormalBlock() {
        return this.mBlock == this;
    }

    @Override
    public boolean doesPistonPush(byte aMeta) {
        return true;
    }

    @Override
    public int getLightOpacity() {
        return this.mBlock == this ? 255 : 3;
    }

    @Override
    public int getItemStackLimit(ItemStack aStack) {
        return UT.Code.bindStack(OP.stone.mDefaultStackSize * (this.mBlock.mBlock == this.mBlock ? 1 : 2));
    }

    @Override
    public Item getItemDropped(int par1, Random par2Random, int par3) {
        return Item.getItemFromBlock((Block)(this.mIsSlab ? this.mBlock.mSlabs[0] : this.mBlock));
    }

    @Override
    public void getSubBlocks(Item aItem, CreativeTabs aTab, List aList) {
        if (this.mIsPrimary) {
            super.getSubBlocks(aItem, aTab, aList);
        }
    }

    @Override
    public Item getItem(World aWorld, int aX, int aY, int aZ) {
        return Item.getItemFromBlock((Block)(this.mIsSlab ? this.mBlock.mSlabs[0] : this.mBlock));
    }
}

