/*
 * Decompiled with CFR 0.152.
 */
package gregapi.block.fluid;

import gregapi.block.IBlock;
import gregapi.block.IBlockOnHeadInside;
import gregapi.block.MaterialGas;
import gregapi.code.ArrayListNoNulls;
import gregapi.data.CS;
import gregapi.data.FL;
import gregapi.data.LH;
import gregapi.item.IItemGT;
import gregapi.lang.LanguageHandler;
import gregapi.render.RendererBlockFluid;
import gregapi.tileentity.data.ITileEntitySurface;
import gregapi.util.ST;
import gregapi.util.UT;
import gregapi.util.WD;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemBlock;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fluids.BlockFluidFinite;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class BlockBaseFluid
extends BlockFluidFinite
implements IBlock,
IItemGT,
IBlockOnHeadInside {
    public static int FLUID_UPDATE_FLAGS = 2;
    public final String mNameInternal;
    public final int mFlammability;
    public final int mAmountPerQuanta;
    public final int mDensityDir;
    public final Fluid mFluid;
    public final FluidStack mQuanta;
    public boolean mLighterThanWater = false;
    public boolean mActLikeWeb = false;
    public List<int[]> mEffectsBathing = new ArrayListNoNulls<int[]>();
    public List<int[]> mEffectsBreathing = new ArrayListNoNulls<int[]>();

    public BlockBaseFluid(String aNameInternal, FL aFluid, int aFlammability) {
        this(aNameInternal, aFluid.fluid(), aFlammability);
    }

    public BlockBaseFluid(String aNameInternal, FL aFluid, int aFlammability, Material aMaterial) {
        this(aNameInternal, aFluid.fluid(), aFlammability, aMaterial);
    }

    public BlockBaseFluid(String aNameInternal, Fluid aFluid, int aFlammability) {
        this(aNameInternal, aFluid, aFlammability, (Material)(aFluid.isGaseous() ? MaterialGas.instance : (aFluid.getTemperature() > 500 ? Material.lava : Material.water)));
    }

    public BlockBaseFluid(String aNameInternal, Fluid aFluid, int aFlammability, Material aMaterial) {
        this(aNameInternal, aFluid, 125, aFlammability, aMaterial);
    }

    public BlockBaseFluid(String aNameInternal, Fluid aFluid, int aAmountPerQuanta, int aFlammability, Material aMaterial) {
        super(aFluid, aMaterial);
        this.mFluid = aFluid;
        this.mAmountPerQuanta = aAmountPerQuanta;
        this.mQuanta = FL.make(this.mFluid, (long)this.mAmountPerQuanta);
        this.mDensityDir = this.densityDir;
        this.mFlammability = aFlammability;
        this.mNameInternal = aNameInternal;
        this.setBlockName(this.mNameInternal);
        this.setResistance(FL.gas(this.mFluid) ? 1.0f : 30.0f);
        ST.register((Block)this, this.mNameInternal, ItemBlock.class);
        FL.BLOCKS.put(this.mFluid.getName(), (Block)this);
        this.displacements.put(this, false);
        LanguageHandler.set(this.getLocalizedName(), this.getLocalizedName());
        UT.Reflection.setField(Fluid.class, aFluid, "block", this);
    }

    public FluidStack drain(World aWorld, int aX, int aY, int aZ, boolean aDoDrain) {
        FluidStack rFluid = FL.mul(this.mQuanta, WD.meta((IBlockAccess)aWorld, aX, aY, aZ) + 1);
        if (aDoDrain) {
            WD.set(aWorld, aX, aY, aZ, CS.NB, 0L, 3L);
            this.updateFluidBlocks(aWorld, aX, aY, aZ, true);
        }
        return rFluid;
    }

    public void onNeighborBlockChange(World aWorld, int aX, int aY, int aZ, Block aUselessBlock) {
        aWorld.scheduleBlockUpdate(aX, aY, aZ, (Block)this, this.tickRate);
        for (byte tSide : CS.ALL_SIDES_VALID) {
            Block tBlock = WD.block(aWorld, aX, aY, aZ, tSide, false);
            if (tBlock.getMaterial() != this.getMaterial() || !WD.liquid_borken(tBlock) || WD.meta(aWorld, aX, aY, aZ, tSide, false) == 0 || !WD.set(aWorld, aX + CS.OFFX[tSide], aY + CS.OFFY[tSide], aZ + CS.OFFZ[tSide], CS.NB, 0L, 2L)) continue;
            this.updateFluidBlocks(aWorld, aX, aY, aZ, true);
        }
    }

    public void updateFluidBlocks(World aWorld, int aX, int aY, int aZ, boolean aAll) {
        for (int j = this.mDensityDir > 0 ? -1 : 0; j < (this.mDensityDir > 0 ? 1 : 2); ++j) {
            if (!UT.Code.inside(0L, aWorld.getHeight(), aY + j)) continue;
            for (int i = -4; i <= 4; ++i) {
                for (int k = -4; k <= 4; ++k) {
                    if (i == 0 && j == 0 && k == 0 || aWorld.getBlock(aX + i, aY + j, aZ + k) != this || !aAll && aWorld.getBlockMetadata(aX + i, aY + j, aZ + k) <= (j == 0 ? Math.abs(i) : 0)) continue;
                    aWorld.scheduleBlockUpdate(aX + i, aY + j, aZ + k, (Block)this, this.tickRate);
                }
            }
        }
    }

    public void updateTick(World aWorld, int aX, int aY, int aZ, Random aRandom) {
        int tNew;
        boolean tChanged;
        if (this.mFlammability > 0) {
            for (byte tSide : CS.ALL_SIDES_VALID) {
                Block tBlock = WD.block(aWorld, aX, aY, aZ, tSide, false);
                if (tBlock == this || tBlock.getMaterial() != Material.lava && tBlock.getMaterial() != Material.fire) continue;
                WD.burn(aWorld, aX, aY, aZ, true, false);
                WD.burn(aWorld, aX - 4 + aRandom.nextInt(9), aY - 4 + aRandom.nextInt(9), aZ - 4 + aRandom.nextInt(9), false, false);
                WD.burn(aWorld, aX - 4 + aRandom.nextInt(9), aY - 4 + aRandom.nextInt(9), aZ - 4 + aRandom.nextInt(9), false, false);
                WD.burn(aWorld, aX - 4 + aRandom.nextInt(9), aY - 4 + aRandom.nextInt(9), aZ - 4 + aRandom.nextInt(9), false, false);
                return;
            }
        }
        int tRemainingQuanta = WD.meta((IBlockAccess)aWorld, aX, aY, aZ) + 1;
        if (aY <= 0 || aY + 1 >= aWorld.getHeight()) {
            if (WD.set(aWorld, aX, aY, aZ, CS.NB, 0L, FLUID_UPDATE_FLAGS | 1)) {
                CS.GarbageGT.trash(FL.mul(this.mQuanta, tRemainingQuanta));
            }
            return;
        }
        int oRemainingQuanta = tRemainingQuanta;
        if ((tRemainingQuanta = this.tryToFlowVerticallyInto(aWorld, aX, aY, aZ, tRemainingQuanta)) < 1) {
            this.updateFluidBlocks(aWorld, aX, aY, aZ, false);
            return;
        }
        boolean bl = tChanged = tRemainingQuanta != oRemainingQuanta;
        if (tRemainingQuanta == 1) {
            if (tChanged) {
                this.set(aWorld, aX, aY, aZ, tRemainingQuanta - 1, false);
                this.updateFluidBlocks(aWorld, aX, aY, aZ, false);
                return;
            }
            if (!WD.liquid(aWorld, aX, aY + this.mDensityDir, aZ)) {
                for (byte tSide : CS.ALL_SIDES_HORIZONTAL_ORDER[CS.RNGSUS.nextInt(CS.ALL_SIDES_HORIZONTAL_ORDER.length)]) {
                    if (!aWorld.blockExists(aX + CS.OFFX[tSide], aY, aZ + CS.OFFZ[tSide]) || WD.hasCollide(aWorld, aX + CS.OFFX[tSide], aY + this.mDensityDir, aZ + CS.OFFZ[tSide]) || !this.displaceIfPossible(aWorld, aX + CS.OFFX[tSide], aY, aZ + CS.OFFZ[tSide]) || !this.set(aWorld, aX + CS.OFFX[tSide], aY, aZ + CS.OFFZ[tSide], tRemainingQuanta - 1, false)) continue;
                    aWorld.scheduleBlockUpdate(aX + CS.OFFX[tSide], aY, aZ + CS.OFFZ[tSide], (Block)this, this.tickRate);
                    WD.set(aWorld, aX, aY, aZ, CS.NB, 0L, FLUID_UPDATE_FLAGS | 1);
                    this.updateFluidBlocks(aWorld, aX, aY, aZ, true);
                    return;
                }
            }
            return;
        }
        if (aWorld.blockExists(aX, aY, aZ - 1) && this.displaceIfPossible(aWorld, aX, aY, aZ - 1)) {
            WD.setIfDiff(aWorld, aX, aY, aZ - 1, CS.NB, 0, FLUID_UPDATE_FLAGS | 1);
        }
        if (aWorld.blockExists(aX, aY, aZ + 1) && this.displaceIfPossible(aWorld, aX, aY, aZ + 1)) {
            WD.setIfDiff(aWorld, aX, aY, aZ + 1, CS.NB, 0, FLUID_UPDATE_FLAGS | 1);
        }
        if (aWorld.blockExists(aX - 1, aY, aZ) && this.displaceIfPossible(aWorld, aX - 1, aY, aZ)) {
            WD.setIfDiff(aWorld, aX - 1, aY, aZ, CS.NB, 0, FLUID_UPDATE_FLAGS | 1);
        }
        if (aWorld.blockExists(aX + 1, aY, aZ) && this.displaceIfPossible(aWorld, aX + 1, aY, aZ)) {
            WD.setIfDiff(aWorld, aX + 1, aY, aZ, CS.NB, 0, FLUID_UPDATE_FLAGS | 1);
        }
        int tTotal = tRemainingQuanta;
        int tCount = 1;
        int north = this.getQuantaValueBelow((IBlockAccess)aWorld, aX, aY, aZ - 1, tRemainingQuanta - 1);
        int south = this.getQuantaValueBelow((IBlockAccess)aWorld, aX, aY, aZ + 1, tRemainingQuanta - 1);
        int west = this.getQuantaValueBelow((IBlockAccess)aWorld, aX - 1, aY, aZ, tRemainingQuanta - 1);
        int east = this.getQuantaValueBelow((IBlockAccess)aWorld, aX + 1, aY, aZ, tRemainingQuanta - 1);
        if (north >= 0) {
            ++tCount;
            tTotal += north;
        }
        if (south >= 0) {
            ++tCount;
            tTotal += south;
        }
        if (west >= 0) {
            ++tCount;
            tTotal += west;
        }
        if (east >= 0) {
            ++tCount;
            tTotal += east;
        }
        if (tCount == 1) {
            if (tChanged) {
                this.set(aWorld, aX, aY, aZ, tRemainingQuanta - 1, false);
                this.updateFluidBlocks(aWorld, aX, aY, aZ, false);
            }
            return;
        }
        int tSpread = tTotal / tCount;
        int tRemainder = tTotal % tCount;
        if (north >= 0) {
            tNew = tSpread;
            if (tRemainder == tCount || tRemainder > 1 && aRandom.nextInt(tCount - tRemainder) != 0) {
                ++tNew;
                --tRemainder;
            }
            --tCount;
            if (tNew != north) {
                if (tNew > 0) {
                    if (this.set(aWorld, aX, aY, aZ - 1, tNew - 1, false)) {
                        aWorld.scheduleBlockUpdate(aX, aY, aZ - 1, (Block)this, this.tickRate);
                    }
                } else {
                    WD.setIfDiff(aWorld, aX, aY, aZ - 1, CS.NB, 0, FLUID_UPDATE_FLAGS | 1);
                }
            }
        }
        if (south >= 0) {
            tNew = tSpread;
            if (tRemainder == tCount || tRemainder > 1 && aRandom.nextInt(tCount - tRemainder) != 0) {
                ++tNew;
                --tRemainder;
            }
            --tCount;
            if (tNew != south) {
                if (tNew > 0) {
                    if (this.set(aWorld, aX, aY, aZ + 1, tNew - 1, false)) {
                        aWorld.scheduleBlockUpdate(aX, aY, aZ + 1, (Block)this, this.tickRate);
                    }
                } else {
                    WD.setIfDiff(aWorld, aX, aY, aZ + 1, CS.NB, 0, FLUID_UPDATE_FLAGS | 1);
                }
            }
        }
        if (west >= 0) {
            tNew = tSpread;
            if (tRemainder == tCount || tRemainder > 1 && aRandom.nextInt(tCount - tRemainder) != 0) {
                ++tNew;
                --tRemainder;
            }
            --tCount;
            if (tNew != west) {
                if (tNew > 0) {
                    if (this.set(aWorld, aX - 1, aY, aZ, tNew - 1, false)) {
                        aWorld.scheduleBlockUpdate(aX - 1, aY, aZ, (Block)this, this.tickRate);
                    }
                } else {
                    WD.setIfDiff(aWorld, aX - 1, aY, aZ, CS.NB, 0, FLUID_UPDATE_FLAGS | 1);
                }
            }
        }
        if (east >= 0) {
            tNew = tSpread;
            if (tRemainder == tCount || tRemainder > 1 && aRandom.nextInt(tCount - tRemainder) != 0) {
                ++tNew;
                --tRemainder;
            }
            --tCount;
            if (tNew != east) {
                if (tNew > 0) {
                    if (this.set(aWorld, aX + 1, aY, aZ, tNew - 1, false)) {
                        aWorld.scheduleBlockUpdate(aX + 1, aY, aZ, (Block)this, this.tickRate);
                    }
                } else {
                    WD.setIfDiff(aWorld, aX + 1, aY, aZ, CS.NB, 0, FLUID_UPDATE_FLAGS | 1);
                }
            }
        }
        this.set(aWorld, aX, aY, aZ, tRemainder > 0 ? tSpread : tSpread - 1, false);
    }

    public int tryToFlowVerticallyInto(World aWorld, int aX, int aY, int aZ, int aAmount) {
        Block tBlock;
        int tY;
        if (this.mLighterThanWater) {
            tY = aY;
            while (++tY < aWorld.getHeight() && WD.anywater((IBlockAccess)aWorld, aX, tY, aZ)) {
            }
            if (tY - 1 > aY) {
                tBlock = aWorld.getBlock(aX, tY, aZ);
                if (tBlock == this) {
                    int tAmount = 1 + aWorld.getBlockMetadata(aX, tY, aZ) + aAmount;
                    if (tAmount > 16) {
                        this.set(aWorld, aX, tY, aZ, 15, true);
                        aWorld.scheduleBlockUpdate(aX, tY, aZ, (Block)this, this.tickRate);
                        return tAmount - 16;
                    }
                    if (tAmount > 0) {
                        this.set(aWorld, aX, tY, aZ, tAmount - 1, true);
                        WD.set(aWorld, aX, aY, aZ, CS.NB, 0L, FLUID_UPDATE_FLAGS | 1);
                        return 0;
                    }
                    return aAmount;
                }
                if (WD.air(aWorld, aX, tY, aZ, tBlock) || this.displaceIfPossible(aWorld, aX, tY, aZ)) {
                    this.set(aWorld, aX, tY, aZ, aAmount - 1, true);
                    aWorld.scheduleBlockUpdate(aX, tY, aZ, (Block)this, this.tickRate);
                    return 0;
                }
            }
        }
        if (aAmount > 8) {
            tY = aY - this.mDensityDir;
            tBlock = aWorld.getBlock(aX, tY, aZ);
            if (tBlock instanceof BlockFluidFinite) {
                int tMeta = aWorld.getBlockMetadata(aX, tY, aZ);
                if (tMeta > 7) {
                    return aAmount;
                }
                WD.set(aWorld, aX, aY, aZ, tBlock, (long)tMeta, FLUID_UPDATE_FLAGS | 1);
                this.set(aWorld, aX, tY, aZ, aAmount - 1, true);
                aWorld.scheduleBlockUpdate(aX, tY, aZ, (Block)this, this.tickRate);
                return 0;
            }
            if (!this.mLighterThanWater && WD.anywater(tBlock)) {
                WD.set(aWorld, aX, aY, aZ, tBlock, (long)aWorld.getBlockMetadata(aX, tY, aZ), FLUID_UPDATE_FLAGS | 1);
                this.set(aWorld, aX, tY, aZ, aAmount - 1, true);
                aWorld.scheduleBlockUpdate(aX, tY, aZ, (Block)this, this.tickRate);
                return 0;
            }
            if (WD.air(aWorld, aX, tY, aZ, tBlock) || this.displaceIfPossible(aWorld, aX, tY, aZ)) {
                aWorld.scheduleBlockUpdate(aX, aY, aZ, (Block)this, 128 - aAmount * 4);
                this.set(aWorld, aX, tY, aZ, aAmount - 2, true);
                aWorld.scheduleBlockUpdate(aX, tY, aZ, (Block)this, 1);
                this.updateFluidBlocks(aWorld, aX, aY, aZ, true);
                return 1;
            }
        }
        if ((tBlock = aWorld.getBlock(aX, tY = aY + this.mDensityDir, aZ)) == this) {
            int tAmount = 1 + aWorld.getBlockMetadata(aX, tY, aZ) + aAmount;
            if (tAmount > 8) {
                this.set(aWorld, aX, tY, aZ, 7, true);
                aWorld.scheduleBlockUpdate(aX, tY, aZ, (Block)this, this.tickRate);
                return tAmount - 8;
            }
            if (tAmount > 0) {
                this.set(aWorld, aX, tY, aZ, tAmount - 1, true);
                WD.set(aWorld, aX, aY, aZ, CS.NB, 0L, FLUID_UPDATE_FLAGS | 1);
                return 0;
            }
            return aAmount;
        }
        if (tBlock instanceof BlockFluidBase) {
            if (this.mDensityDir > 0 ? BlockBaseFluid.getDensity((IBlockAccess)aWorld, (int)aX, (int)tY, (int)aZ) > this.density : BlockBaseFluid.getDensity((IBlockAccess)aWorld, (int)aX, (int)tY, (int)aZ) < this.density) {
                WD.set(aWorld, aX, aY, aZ, tBlock, (long)aWorld.getBlockMetadata(aX, tY, aZ), FLUID_UPDATE_FLAGS | 1);
                this.set(aWorld, aX, tY, aZ, aAmount - 1, true);
                aWorld.scheduleBlockUpdate(aX, tY, aZ, (Block)this, this.tickRate);
                return 0;
            }
            return aAmount;
        }
        if (WD.air(aWorld, aX, tY, aZ, tBlock) || this.displaceIfPossible(aWorld, aX, tY, aZ)) {
            this.set(aWorld, aX, tY, aZ, aAmount - 1, true);
            WD.set(aWorld, aX, aY, aZ, CS.NB, 0L, FLUID_UPDATE_FLAGS | 1);
            return 0;
        }
        return aAmount;
    }

    public boolean shouldSideBeRendered(IBlockAccess aWorld, int aX, int aY, int aZ, int aSide) {
        Block aBlock = aWorld.getBlock(aX, aY, aZ);
        if (aBlock == CS.NB) {
            return true;
        }
        if (aBlock == this || aBlock.getMaterial() == Material.water || WD.visOpq(aBlock)) {
            return false;
        }
        if (aBlock.isAir(aWorld, aX, aY, aZ)) {
            return true;
        }
        TileEntity tTileEntity = aWorld.getTileEntity(aX, aY, aZ);
        if (tTileEntity instanceof ITileEntitySurface) {
            return !((ITileEntitySurface)tTileEntity).isSurfaceOpaque(CS.OPOS[aSide]);
        }
        return true;
    }

    @Override
    public Block getBlock() {
        return this;
    }

    public final String getUnlocalizedName() {
        return this.mFluid.getUnlocalizedName();
    }

    public String getLocalizedName() {
        return LH.get(this.mFluid.getUnlocalizedName());
    }

    public void registerBlockIcons(IIconRegister aIconRegister) {
    }

    public IIcon getIcon(int aSide, int aMeta) {
        return CS.SIDES_VERTICAL[aSide] ? this.mFluid.getStillIcon() : this.mFluid.getFlowingIcon();
    }

    public int getRenderColor(int aMeta) {
        return this.mFluid.getColor();
    }

    public int colorMultiplier(IBlockAccess aWorld, int aX, int aY, int aZ) {
        return this.mFluid.getColor();
    }

    public int getRenderType() {
        return RendererBlockFluid.RENDER_ID;
    }

    public int getRenderBlockPass() {
        return 1;
    }

    public int getLightOpacity() {
        return 3;
    }

    public int getFireSpreadSpeed(IBlockAccess aWorld, int aX, int aY, int aZ, ForgeDirection aDirection) {
        return this.mFlammability;
    }

    public int getFlammability(IBlockAccess aWorld, int aX, int aY, int aZ, ForgeDirection aDirection) {
        return this.mFlammability;
    }

    public boolean canDisplace(IBlockAccess aWorld, int aX, int aY, int aZ) {
        return !aWorld.getBlock(aX, aY, aZ).getMaterial().isLiquid() && super.canDisplace(aWorld, aX, aY, aZ);
    }

    public boolean displaceIfPossible(World aWorld, int aX, int aY, int aZ) {
        return !aWorld.getBlock(aX, aY, aZ).getMaterial().isLiquid() && super.displaceIfPossible(aWorld, aX, aY, aZ);
    }

    public boolean canCollideCheck(int aMeta, boolean aFullHit) {
        return aFullHit && aMeta >= 7;
    }

    public boolean getBlocksMovement(IBlockAccess aWorld, int aX, int aY, int aZ) {
        return this.mActLikeWeb || !this.mEffectsBathing.isEmpty() || !this.mEffectsBreathing.isEmpty();
    }

    public boolean isNormalCube() {
        return false;
    }

    public boolean isOpaqueCube() {
        return false;
    }

    public boolean func_149730_j() {
        return false;
    }

    public boolean getTickRandomly() {
        return false;
    }

    public boolean renderAsNormalBlock() {
        return false;
    }

    public boolean isAir(IBlockAccess aWorld, int aX, int aY, int aZ) {
        return false;
    }

    public boolean isSideSolid(IBlockAccess aWorld, int aX, int aY, int aZ, ForgeDirection aSide) {
        return false;
    }

    public BlockBaseFluid setLighterThanWater() {
        this.mLighterThanWater = true;
        return this;
    }

    public BlockBaseFluid setWeb() {
        this.mActLikeWeb = true;
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean set(World aWorld, int aX, int aY, int aZ, int aMeta, boolean aBlockUpdate) {
        if (aWorld.getBlock(aX, aY, aZ) != this) {
            return WD.set(aWorld, aX, aY, aZ, (Block)this, (long)aMeta, aBlockUpdate ? 3L : 2L);
        }
        byte tMeta = WD.meta((IBlockAccess)aWorld, aX, aY, aZ);
        if (aMeta == tMeta) return true;
        if (!WD.set(aWorld, aX, aY, aZ, (Block)this, (long)aMeta, aMeta >= 7 && tMeta >= 7 ? (aBlockUpdate ? 5L : 4L) : (aBlockUpdate ? 3L : 2L))) return false;
        return true;
    }

    public void onEntityCollidedWithBlock(World aWorld, int aX, int aY, int aZ, Entity aEntity) {
        if (this.mActLikeWeb) {
            aEntity.setInWeb();
        }
        if (!aWorld.isRemote && !this.mEffectsBathing.isEmpty() && aEntity instanceof EntityLivingBase && !UT.Entities.isWearingFullChemHazmat((EntityLivingBase)aEntity)) {
            for (int[] tEffects : this.mEffectsBathing) {
                UT.Entities.applyPotion(aEntity, tEffects[0], tEffects[1], tEffects[2], false);
            }
        }
    }

    @Override
    public void onHeadInside(EntityLivingBase aEntity, World aWorld, int aX, int aY, int aZ) {
        if (!(aWorld.isRemote || this.mEffectsBreathing.isEmpty() || UT.Entities.isImmuneToBreathingGases(aEntity))) {
            for (int[] tEffects : this.mEffectsBreathing) {
                UT.Entities.applyPotion((Entity)aEntity, tEffects[0], tEffects[1], tEffects[2], false);
            }
            if (this.getMaterial() != Material.water && CS.SERVER_TIME % 20L == 0L) {
                aEntity.attackEntityFrom(DamageSource.drown, 2.0f);
            }
        }
    }

    public BlockBaseFluid addEffectBathing(int aEffectID, int aEffectDuration, int aEffectLevel) {
        this.mEffectsBathing.add(new int[]{aEffectID, aEffectDuration, aEffectLevel});
        return this;
    }

    public BlockBaseFluid addEffectBreathing(int aEffectID, int aEffectDuration, int aEffectLevel) {
        this.mEffectsBreathing.add(new int[]{aEffectID, aEffectDuration, aEffectLevel});
        return this;
    }
}

