/**
 * Copyright (c) 2024 GregTech-6 Team
 *
 * This file is part of GregTech.
 *
 * GregTech is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GregTech is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with GregTech. If not, see <http://www.gnu.org/licenses/>.
 */

package gregtech.loaders.c;

import gregapi.code.ArrayListNoNulls;
import gregapi.data.*;
import gregapi.data.MT.OREMATS;
import gregapi.oredict.OreDictMaterial;
import gregapi.util.OM;
import gregapi.util.ST;
import gregapi.util.UT;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

import static gregapi.data.CS.*;
import static gregapi.data.OP.*;
import static gregapi.data.TD.Atomic.ANTIMATTER;
import static gregapi.data.TD.Processing.*;
import static gregapi.data.TD.Properties.MAGNETIC_ACTIVE;
import static gregapi.data.TD.Properties.MAGNETIC_PASSIVE;

public class Loader_Recipes_Ores implements Runnable {
	@Override public void run() {
		RM.Centrifuge       .addRecipe1(T, 64,  144, OM.dust(MT.DarkAsh, U*2), OM.dust(MT.Ash), IL.TE_Slag.get(1, IL.IE_Slag.get(1, IL.FZ_Sludge.get(1, OM.dust(MT.Ash)))));
		
		for (FluidStack tWater : FL.waters(1000)) {
		RM.Mixer            .addRecipe1(T, 16,   16, OM.dust(MT.SluiceSand, U9), FL.mul(tWater, 1,10, T), FL.Sluice.make(100), ZL_IS);
		RM.Mixer            .addRecipe1(T, 16,   16, OM.dust(MT.SluiceSand    ), FL.mul(tWater, 9,10, T), FL.Sluice.make(900), ZL_IS);
		}
		RM.Drying           .addRecipe0(T, 16,  100, FL.Sluice.make(100), FL.DistW.make(50), OM.dust(MT.SluiceSand,  U9));
		RM.Centrifuge       .addRecipe0(T, 64,   16, new long[] { 9640, 100, 100, 100, 100, 100}, FL.Sluice.make(100), FL.Water.make(50), dustTiny .mat(MT.Stone, 1), dustTiny.mat(MT.Cu, 2), dustTiny.mat(MT.Sn, 1), dustTiny.mat(MT.Zn, 1), dustTiny.mat(MT.Sb, 1), dustTiny.mat(MT.Cr, 1));
		RM.MagneticSeparator.addRecipe1(T, 16,   16, new long[] { 9640,  72,  72,  72,  72,  72}, dustTiny  .mat(MT.SluiceSand      , 1), dustTiny .mat(MT.Stone, 1), dustTiny.mat(MT.Fe, 2), dustTiny.mat(MT.Nd, 1), dustTiny.mat(MT.Ni, 1), dustTiny.mat(MT.Co, 1), dustTiny.mat(MT.Mn, 1));
		RM.MagneticSeparator.addRecipe1(T, 16,   36, new long[] { 9640, 162, 162, 162, 162, 162}, dustSmall .mat(MT.SluiceSand      , 1), dustSmall.mat(MT.Stone, 1), dustTiny.mat(MT.Fe, 2), dustTiny.mat(MT.Nd, 1), dustTiny.mat(MT.Ni, 1), dustTiny.mat(MT.Co, 1), dustTiny.mat(MT.Mn, 1));
		RM.MagneticSeparator.addRecipe1(T, 16,  144, new long[] { 9640, 648, 648, 648, 648, 648}, dust      .mat(MT.SluiceSand      , 1), dust     .mat(MT.Stone, 1), dustTiny.mat(MT.Fe, 2), dustTiny.mat(MT.Nd, 1), dustTiny.mat(MT.Ni, 1), dustTiny.mat(MT.Co, 1), dustTiny.mat(MT.Mn, 1));
		RM.MagneticSeparator.addRecipe1(T, 16, 1296, new long[] { 9640,5832,5832,5832,5832,5832}, blockDust .mat(MT.SluiceSand      , 1), dust     .mat(MT.Stone, 9), dustTiny.mat(MT.Fe, 2), dustTiny.mat(MT.Nd, 1), dustTiny.mat(MT.Ni, 1), dustTiny.mat(MT.Co, 1), dustTiny.mat(MT.Mn, 1));
		
		RM.Centrifuge       .addRecipe1(T,256,  144, new long[] { 7000,3000,3000,3000,3000,3000}, dust      .mat(MT.Bedrock         , 1), dust     .mat(MT.STONES.Deepslate, 1), dustTiny.mat(MT.Adamantite, 1), dustTiny.mat(MT.Draconium, 1), dustTiny.mat(MT.Monazite ,  2), dustTiny.mat(MT.Zircon,  3), dustTiny.mat(MT.Graphite,  3));
		RM.Centrifuge       .addRecipe1(T,256, 1296, new long[] { 7000,3000,3000,3000,3000,3000}, blockDust .mat(MT.Bedrock         , 1), dust     .mat(MT.STONES.Deepslate, 9), dustTiny.mat(MT.Adamantite, 9), dustTiny.mat(MT.Draconium, 9), dustTiny.mat(MT.Monazite , 18), dustTiny.mat(MT.Zircon, 27), dustTiny.mat(MT.Graphite, 27));
		RM.MagneticSeparator.addRecipe1(T, 64,  144, new long[] { 7000,3000,3000,3000,3000,3000}, dust      .mat(MT.Bedrock         , 1), dust     .mat(MT.STONES.Deepslate, 1), dustTiny.mat(MT.Adamantine, 1), dustTiny.mat(MT.Atl      , 1), dustTiny.mat(MT.RareEarth,  2), dustTiny.mat(MT.Nd    ,  3), dustTiny.mat(MT.V2O5    ,  3));
		RM.MagneticSeparator.addRecipe1(T, 64, 1296, new long[] { 7000,3000,3000,3000,3000,3000}, blockDust .mat(MT.Bedrock         , 1), dust     .mat(MT.STONES.Deepslate, 9), dustTiny.mat(MT.Adamantine, 9), dustTiny.mat(MT.Atl      , 9), dustTiny.mat(MT.RareEarth, 18), dustTiny.mat(MT.Nd    , 27), dustTiny.mat(MT.V2O5    , 27));
		
		RM.MagneticSeparator.addRecipe1(T, 16,   16, new long[] { 3000,  12,  12,  12,  12,  12}, dustTiny  .mat(MT.STONES.MoonTurf , 1), dustTiny .mat(MT.STONES.Basalt, 1), dustTiny.mat(MT.MeteoricIron, 9), dustTiny.mat(MT.Nd, 1), dustTiny.mat(MT.Ni, 1), dustTiny.mat(MT.Co, 1), dustTiny.mat(MT.Mn, 1));
		RM.MagneticSeparator.addRecipe1(T, 16,   36, new long[] { 3000,  27,  27,  27,  27,  27}, dustSmall .mat(MT.STONES.MoonTurf , 1), dustSmall.mat(MT.STONES.Basalt, 1), dustTiny.mat(MT.MeteoricIron, 9), dustTiny.mat(MT.Nd, 1), dustTiny.mat(MT.Ni, 1), dustTiny.mat(MT.Co, 1), dustTiny.mat(MT.Mn, 1));
		RM.MagneticSeparator.addRecipe1(T, 16,  144, new long[] { 3000, 108, 108, 108, 108, 108}, dust      .mat(MT.STONES.MoonTurf , 1), dust     .mat(MT.STONES.Basalt, 1), dustTiny.mat(MT.MeteoricIron, 9), dustTiny.mat(MT.Nd, 1), dustTiny.mat(MT.Ni, 1), dustTiny.mat(MT.Co, 1), dustTiny.mat(MT.Mn, 1));
		RM.MagneticSeparator.addRecipe1(T, 16, 1296, new long[] { 3000, 972, 972, 972, 972, 972}, blockDust .mat(MT.STONES.MoonTurf , 1), dust     .mat(MT.STONES.Basalt, 9), dustTiny.mat(MT.MeteoricIron, 9), dustTiny.mat(MT.Nd, 1), dustTiny.mat(MT.Ni, 1), dustTiny.mat(MT.Co, 1), dustTiny.mat(MT.Mn, 1));
		// TODO MARS SAND, SPACE DUST
		
		RM.Drying           .addRecipe1(T, 16, 2592, OP.crushedPurified    .mat(MT.Biotite, 1), NF, MT.Ar.gas(9*U100, T), OP.crushedCentrifuged    .mat(MT.Biotite, 1));
		RM.Drying           .addRecipe1(T, 16,  288, OP.crushedPurifiedTiny.mat(MT.Biotite, 1), NF, MT.Ar.gas(  U100, T), OP.crushedCentrifugedTiny.mat(MT.Biotite, 1));
		
		RM.Centrifuge       .addRecipe1(T, 64,   16, new long[] {   72,  72,  72,  72,  72,  72}, dustTiny              .mat(MT.RareEarth, 1), dustTiny.mat(MT.Nd, 8), dustTiny.mat(MT.Y, 8), dustTiny.mat(MT.La, 8), dustTiny.mat(MT.Ce, 8), dustTiny.mat(MT.Cd, 8), dustTiny.mat(MT.Cs, 8));
		RM.Centrifuge       .addRecipe1(T, 64,   36, new long[] {  162, 162, 162, 162, 162, 162}, dustSmall             .mat(MT.RareEarth, 1), dustTiny.mat(MT.Nd, 8), dustTiny.mat(MT.Y, 8), dustTiny.mat(MT.La, 8), dustTiny.mat(MT.Ce, 8), dustTiny.mat(MT.Cd, 8), dustTiny.mat(MT.Cs, 8));
		RM.Centrifuge       .addRecipe1(T, 64,  144, new long[] {  648, 648, 648, 648, 648, 648}, dust                  .mat(MT.RareEarth, 1), dustTiny.mat(MT.Nd, 8), dustTiny.mat(MT.Y, 8), dustTiny.mat(MT.La, 8), dustTiny.mat(MT.Ce, 8), dustTiny.mat(MT.Cd, 8), dustTiny.mat(MT.Cs, 8));
		RM.Centrifuge       .addRecipe1(T, 64,   16, new long[] {   80,  80,  80,  80,  80,  80}, crushedCentrifugedTiny.mat(MT.RareEarth, 1), dustTiny.mat(MT.Nd, 8), dustTiny.mat(MT.Y, 8), dustTiny.mat(MT.La, 8), dustTiny.mat(MT.Ce, 8), dustTiny.mat(MT.Cd, 8), dustTiny.mat(MT.Cs, 8));
		RM.Centrifuge       .addRecipe1(T, 64,  144, new long[] {  720, 720, 720, 720, 720, 720}, crushedCentrifuged    .mat(MT.RareEarth, 1), dustTiny.mat(MT.Nd, 8), dustTiny.mat(MT.Y, 8), dustTiny.mat(MT.La, 8), dustTiny.mat(MT.Ce, 8), dustTiny.mat(MT.Cd, 8), dustTiny.mat(MT.Cs, 8));
		
		RM.Centrifuge       .addRecipe1(T, 64,   16, new long[] {   72,  72,  72,  72,  72,  72}, dustTiny              .mat(MT.PlatinumGroupSludge, 1), dustTiny.mat(MT.Ru, 8), dustTiny.mat(MT.Rh, 8), dustTiny.mat(MT.Pd, 8), dustTiny.mat(MT.Os, 8), dustTiny.mat(MT.Ir, 8), dustTiny.mat(MT.Pt, 8));
		RM.Centrifuge       .addRecipe1(T, 64,   36, new long[] {  162, 162, 162, 162, 162, 162}, dustSmall             .mat(MT.PlatinumGroupSludge, 1), dustTiny.mat(MT.Ru, 8), dustTiny.mat(MT.Rh, 8), dustTiny.mat(MT.Pd, 8), dustTiny.mat(MT.Os, 8), dustTiny.mat(MT.Ir, 8), dustTiny.mat(MT.Pt, 8));
		RM.Centrifuge       .addRecipe1(T, 64,  144, new long[] {  648, 648, 648, 648, 648, 648}, dust                  .mat(MT.PlatinumGroupSludge, 1), dustTiny.mat(MT.Ru, 8), dustTiny.mat(MT.Rh, 8), dustTiny.mat(MT.Pd, 8), dustTiny.mat(MT.Os, 8), dustTiny.mat(MT.Ir, 8), dustTiny.mat(MT.Pt, 8));
		RM.Centrifuge       .addRecipe1(T, 64,   16, new long[] {   80,  80,  80,  80,  80,  80}, crushedCentrifugedTiny.mat(MT.PlatinumGroupSludge, 1), dustTiny.mat(MT.Ru, 8), dustTiny.mat(MT.Rh, 8), dustTiny.mat(MT.Pd, 8), dustTiny.mat(MT.Os, 8), dustTiny.mat(MT.Ir, 8), dustTiny.mat(MT.Pt, 8));
		RM.Centrifuge       .addRecipe1(T, 64,  144, new long[] {  720, 720, 720, 720, 720, 720}, crushedCentrifuged    .mat(MT.PlatinumGroupSludge, 1), dustTiny.mat(MT.Ru, 8), dustTiny.mat(MT.Rh, 8), dustTiny.mat(MT.Pd, 8), dustTiny.mat(MT.Os, 8), dustTiny.mat(MT.Ir, 8), dustTiny.mat(MT.Pt, 8));
		
		RM.Centrifuge       .addRecipe0(T, 64,  288, new long[] {8000,  250,  250,  250,  250,  250}, FL.Lava                    .make(100), NF, dustTiny.mat(MT.STONES.Basalt, 1), nugget.mat(MT.Cu, 8), nugget.mat(MT.Sn, 4), nugget.mat(MT.Pb, 2), nugget.mat(MT.Au, 1), nugget.mat(MT.Ag, 1));
		RM.Centrifuge       .addRecipe0(T, 64,  144, new long[] {9000,  300,  300,  300,  300,  300}, FL.Lava_Pahoehoe           .make(100), NF, dustTiny.mat(MT.STONES.Basalt, 1), nugget.mat(MT.Cu, 8), nugget.mat(MT.Sn, 4), nugget.mat(MT.Pb, 2), nugget.mat(MT.Au, 1), nugget.mat(MT.Ag, 1));
		if (FL.Lava_Volcanic.exists())
		RM.Centrifuge       .addRecipe0(T, 64,  144, new long[] {9500, 1000, 1000, 1000, 1000, 1000}, FL.Lava_Volcanic           .make(100), NF, dustTiny.mat(MT.STONES.Basalt, 4), nugget.mat(MT.Cu, 8), nugget.mat(MT.Sn, 4), nugget.mat(MT.Pb, 2), nugget.mat(MT.Au, 1), nugget.mat(MT.Ag, 1));
		if (IL.NePl_SoulSoil.exists())
		RM.Centrifuge       .addRecipe1(T, 64,  144, new long[] {8000, 1000, 1000, 1000            }, IL.NePl_SoulSoil             .wild(1), NF, FL.Oil_Soulsand.make(45), dust.mat(MT.Sand, 9), dustTiny.mat(MT.Niter, 9), dustTiny.mat(MT.Coal, 9), dustTiny.mat(MT.Bone, 9));
		if (IL.NeLi_SoulSoil.exists())
		RM.Centrifuge       .addRecipe1(T, 64,  144, new long[] {8000, 1000, 1000, 1000            }, IL.NeLi_SoulSoil             .wild(1), NF, FL.Oil_Soulsand.make(45), dust.mat(MT.Sand, 9), dustTiny.mat(MT.Niter, 9), dustTiny.mat(MT.Coal, 9), dustTiny.mat(MT.Bone, 9));
		RM.Centrifuge       .addRecipe1(T, 64,  144, new long[] {8000, 1000, 1000, 1000            }, ST.make(Blocks.soul_sand      , 1, W), NF, FL.Oil_Soulsand.make(45), dust.mat(MT.Sand, 9), dustTiny.mat(MT.Niter, 9), dustTiny.mat(MT.Coal, 9), dustTiny.mat(MT.Bone, 9));
		RM.Centrifuge       .addRecipe1(T, 64,   16, new long[] {8000, 1000, 1000, 1000            }, dust     .mat(MT.SoulSand        , 1), NF, FL.Oil_Soulsand.make( 5), dust.mat(MT.Sand, 1), dustTiny.mat(MT.Niter, 1), dustTiny.mat(MT.Coal, 1), dustTiny.mat(MT.Bone, 1));
		RM.Centrifuge       .addRecipe1(T, 64,  144, new long[] {8000, 1000,  500,  500,  100      }, blockDust.mat(MT.Netherrack      , 1), dust.mat(MT.Stone, 9), dustTiny.mat(MT.S,18), dustTiny.mat(MT.Redstone, 9), dustTiny.mat(MT.Coal, 9), dustTiny.mat(MT.Au, 9));
		RM.Centrifuge       .addRecipe1(T, 64,   16, new long[] {8000, 1000,  500,  500,  100      }, dust     .mat(MT.Netherrack      , 1), dust.mat(MT.Stone, 1), dustTiny.mat(MT.S, 2), dustTiny.mat(MT.Redstone, 1), dustTiny.mat(MT.Coal, 1), dustTiny.mat(MT.Au, 1));
		RM.Centrifuge       .addRecipe1(T, 64,  144, new long[] {8000,  100,  300,  100,   10      }, blockDust.mat(MT.Endstone        , 1), ZL_FS, FL.array(MT.He.gas(U8 , F), MT.He_3.gas(U500*9, F), MT.NO2.gas(U4 , F), MT.CO2.gas(U4 , F), MT.H.gas(U8 , F), MT.D.gas(U8 , F)), dust.mat(MT.Sand, 9), dustTiny.mat(MT.Pt, 9), dustTiny.mat(MT.WO3, 9), dustTiny.mat(MT.Endium, 9), gem.mat(MT.Sugilite, 9));
		RM.Centrifuge       .addRecipe1(T, 64,   16, new long[] {8000,  100,  300,  100,   10      }, dust     .mat(MT.Endstone        , 1), ZL_FS, FL.array(MT.He.gas(U72, F), MT.He_3.gas(U500  , F), MT.NO2.gas(U36, F), MT.CO2.gas(U36, F), MT.H.gas(U72, F), MT.D.gas(U72, F)), dust.mat(MT.Sand, 1), dustTiny.mat(MT.Pt, 1), dustTiny.mat(MT.WO3, 1), dustTiny.mat(MT.Endium, 1), gem.mat(MT.Sugilite, 1));
		RM.Centrifuge       .addRecipe1(T, 64,  144, new long[] {8000,  100,  300,  100,   10      }, blockDust.mat(MT.EndSandWhite    , 1), ZL_FS, FL.array(MT.He.gas(U8 , F), MT.He_3.gas(U500*9, F), MT.NO2.gas(U4 , F), MT.CO2.gas(U4 , F), MT.H.gas(U8 , F), MT.D.gas(U8 , F)), dust.mat(MT.Sand, 9), dustTiny.mat(MT.Pt, 9), dustTiny.mat(MT.WO3, 9), dustTiny.mat(MT.Endium, 9), gem.mat(MT.Sugilite, 9));
		RM.Centrifuge       .addRecipe1(T, 64,   16, new long[] {8000,  100,  300,  100,   10      }, dust     .mat(MT.EndSandWhite    , 1), ZL_FS, FL.array(MT.He.gas(U72, F), MT.He_3.gas(U500  , F), MT.NO2.gas(U36, F), MT.CO2.gas(U36, F), MT.H.gas(U72, F), MT.D.gas(U72, F)), dust.mat(MT.Sand, 1), dustTiny.mat(MT.Pt, 1), dustTiny.mat(MT.WO3, 1), dustTiny.mat(MT.Endium, 1), gem.mat(MT.Sugilite, 1));
		RM.Centrifuge       .addRecipe1(T, 64,  144, new long[] {8000,  100,  300,  100,   10      }, blockDust.mat(MT.EndSandBlack    , 1), ZL_FS, FL.array(MT.He.gas(U8 , F), MT.He_3.gas(U500*9, F), MT.NO2.gas(U4 , F), MT.CO2.gas(U4 , F), MT.H.gas(U8 , F), MT.D.gas(U8 , F)), dust.mat(MT.Sand, 9), dustTiny.mat(MT.Pt, 9), dustTiny.mat(MT.WO3, 9), dustTiny.mat(MT.Endium, 9), gem.mat(MT.Sugilite, 9));
		RM.Centrifuge       .addRecipe1(T, 64,   16, new long[] {8000,  100,  300,  100,   10      }, dust     .mat(MT.EndSandBlack    , 1), ZL_FS, FL.array(MT.He.gas(U72, F), MT.He_3.gas(U500  , F), MT.NO2.gas(U36, F), MT.CO2.gas(U36, F), MT.H.gas(U72, F), MT.D.gas(U72, F)), dust.mat(MT.Sand, 1), dustTiny.mat(MT.Pt, 1), dustTiny.mat(MT.WO3, 1), dustTiny.mat(MT.Endium, 1), gem.mat(MT.Sugilite, 1));
		RM.Centrifuge       .addRecipe1(T, 64,  144, new long[] {8000,  100,  100                  }, blockDust.mat(MT.STONES.SpaceRock, 1), ZL_FS, FL.array(MT.He.gas(U8 , F), MT.He_3.gas(U500*9, F), MT.NO2.gas(U4 , F), MT.CO2.gas(U4 , F), MT.H.gas(U8 , F), MT.D.gas(U8 , F)), dust.mat(MT.Sand, 9), dustTiny.mat(MT.Pt, 9), dustTiny.mat(MT.MeteoricIron, 9));
		RM.Centrifuge       .addRecipe1(T, 64,   16, new long[] {8000,  100,  100                  }, dust     .mat(MT.STONES.SpaceRock, 1), ZL_FS, FL.array(MT.He.gas(U72, F), MT.He_3.gas(U500  , F), MT.NO2.gas(U36, F), MT.CO2.gas(U36, F), MT.H.gas(U72, F), MT.D.gas(U72, F)), dust.mat(MT.Sand, 1), dustTiny.mat(MT.Pt, 1), dustTiny.mat(MT.MeteoricIron, 1));
		RM.Centrifuge       .addRecipe1(T, 64,  288, new long[] {8000, 1000, 1000, 1000, 1000,  100}, blockDust.mat(MT.STONES.MoonTurf , 1), ZL_FS, FL.array(MT.He.gas(U8 , F), MT.He_3.gas(U500*9, F), MT.NO2.gas(U4 , F), MT.CO2.gas(U4 , F), MT.H.gas(U8 , F), MT.D.gas(U8 , F)), dust.mat(MT.Sand, 9), dustTiny.mat(MT.STONES.Basalt, 9), dustTiny.mat(MT.Al2O3, 9), dustTiny.mat(MT.OREMATS.Ilmenite, 9), dustTiny.mat(MT.MnO2, 9), dustTiny.mat(MT.MeteoricIron, 9));
		RM.Centrifuge       .addRecipe1(T, 64,   32, new long[] {8000, 1000, 1000, 1000, 1000,  100}, dust     .mat(MT.STONES.MoonTurf , 1), ZL_FS, FL.array(MT.He.gas(U72, F), MT.He_3.gas(U500  , F), MT.NO2.gas(U36, F), MT.CO2.gas(U36, F), MT.H.gas(U72, F), MT.D.gas(U72, F)), dust.mat(MT.Sand, 1), dustTiny.mat(MT.STONES.Basalt, 1), dustTiny.mat(MT.Al2O3, 1), dustTiny.mat(MT.OREMATS.Ilmenite, 1), dustTiny.mat(MT.MnO2, 1), dustTiny.mat(MT.MeteoricIron, 1));
		RM.Centrifuge       .addRecipe1(T, 64,  144, new long[] {8000,  500,  400,  300,  100,   50}, blockDust.mat(MT.STONES.MoonRock , 1), dust.mat(MT.STONES.Basalt, 9), dustTiny.mat(MT.SiO2, 9), dustTiny.mat(MT.Al2O3, 9), dustTiny.mat(OREMATS.Ilmenite, 9), dustTiny.mat(MT.RareEarth, 9), dustTiny.mat(MT.Pt, 9));
		RM.Centrifuge       .addRecipe1(T, 64,   16, new long[] {8000,  500,  400,  300,  100,   50}, dust     .mat(MT.STONES.MoonRock , 1), dust.mat(MT.STONES.Basalt, 1), dustTiny.mat(MT.SiO2, 1), dustTiny.mat(MT.Al2O3, 1), dustTiny.mat(OREMATS.Ilmenite, 1), dustTiny.mat(MT.RareEarth, 1), dustTiny.mat(MT.Pt, 1));
		// TODO MARS ROCKS AND SAND => Ice
		
		for (OreDictMaterial tMat : new OreDictMaterial[] {MT.Mg, MT.Pyrope, MT.Olivine, MT.MgCO3}) {
		RM.Bath         .addRecipe1(T,  0,  256, new long[] {10000, 5000, 5000, 5000, 5000, 5000}, crushedPurified    .mat(tMat, 1), FL.array(MT.H2SO4.fluid(7* U2, T)), FL.array(MT.PinkVitriol.fluid(3*U, F), MT.H.gas(U, F)), crushedCentrifuged.mat(tMat, 1), crushedCentrifugedTiny.mat(tMat, 2), crushedCentrifugedTiny.mat(tMat, 2), crushedCentrifugedTiny.mat(tMat, 2), crushedCentrifugedTiny.mat(tMat, 2), crushedCentrifugedTiny.mat(tMat, 2));
		RM.Bath         .addRecipe1(T,  0,  256, new long[] {10000, 5000, 5000, 5000, 5000, 5000}, crushedPurifiedTiny.mat(tMat, 9), FL.array(MT.H2SO4.fluid(7* U2, T)), FL.array(MT.PinkVitriol.fluid(3*U, F), MT.H.gas(U, F)), crushedCentrifuged.mat(tMat, 1), crushedCentrifugedTiny.mat(tMat, 2), crushedCentrifugedTiny.mat(tMat, 2), crushedCentrifugedTiny.mat(tMat, 2), crushedCentrifugedTiny.mat(tMat, 2), crushedCentrifugedTiny.mat(tMat, 2));
		}
		for (OreDictMaterial tMat : new OreDictMaterial[] {MT.Ni, MT.Pt, MT.OREMATS.Cooperite, MT.OREMATS.Garnierite, MT.OREMATS.Pentlandite}) {
		RM.Bath         .addRecipe1(T,  0,  256, new long[] {10000, 5000, 5000, 5000, 5000, 5000}, crushedPurified    .mat(tMat, 1), FL.array(MT.H2SO4.fluid(7* U2, T)), FL.array(MT.CyanVitriol.fluid(3*U, F), MT.H.gas(U, F)), crushedCentrifuged.mat(tMat, 1), crushedCentrifugedTiny.mat(tMat, 2), crushedCentrifugedTiny.mat(tMat, 2), crushedCentrifugedTiny.mat(tMat, 2), crushedCentrifugedTiny.mat(tMat, 2), crushedCentrifugedTiny.mat(tMat, 2));
		RM.Bath         .addRecipe1(T,  0,  256, new long[] {10000, 5000, 5000, 5000, 5000, 5000}, crushedPurifiedTiny.mat(tMat, 9), FL.array(MT.H2SO4.fluid(7* U2, T)), FL.array(MT.CyanVitriol.fluid(3*U, F), MT.H.gas(U, F)), crushedCentrifuged.mat(tMat, 1), crushedCentrifugedTiny.mat(tMat, 2), crushedCentrifugedTiny.mat(tMat, 2), crushedCentrifugedTiny.mat(tMat, 2), crushedCentrifugedTiny.mat(tMat, 2), crushedCentrifugedTiny.mat(tMat, 2));
		}
		for (OreDictMaterial tMat : new OreDictMaterial[] {MT.Mn, MT.Spessartine, MT.MnO2, MT.OREMATS.Huebnerite, MT.OREMATS.Tungstate, MT.OREMATS.Scheelite}) {
		RM.Bath         .addRecipe1(T,  0,  256, new long[] {10000, 5000, 5000, 5000, 5000, 5000}, crushedPurified    .mat(tMat, 1), FL.array(MT.H2SO4.fluid(7* U2, T)), FL.array(MT.GrayVitriol.fluid(3*U, F), MT.H.gas(U, F)), crushedCentrifuged.mat(tMat, 1), crushedCentrifugedTiny.mat(tMat, 2), crushedCentrifugedTiny.mat(tMat, 2), crushedCentrifugedTiny.mat(tMat, 2), crushedCentrifugedTiny.mat(tMat, 2), crushedCentrifugedTiny.mat(tMat, 2));
		RM.Bath         .addRecipe1(T,  0,  256, new long[] {10000, 5000, 5000, 5000, 5000, 5000}, crushedPurifiedTiny.mat(tMat, 9), FL.array(MT.H2SO4.fluid(7* U2, T)), FL.array(MT.GrayVitriol.fluid(3*U, F), MT.H.gas(U, F)), crushedCentrifuged.mat(tMat, 1), crushedCentrifugedTiny.mat(tMat, 2), crushedCentrifugedTiny.mat(tMat, 2), crushedCentrifugedTiny.mat(tMat, 2), crushedCentrifugedTiny.mat(tMat, 2), crushedCentrifugedTiny.mat(tMat, 2));
		}
		for (OreDictMaterial tMat : new OreDictMaterial[] {MT.Desh, MT.Adamantite, MT.Adamantine}) {
		RM.Bath         .addRecipe1(T,  0,  256, new long[] {10000, 5000, 5000, 5000, 5000, 5000}, crushedPurified    .mat(tMat, 1), FL.array(MT.H2SO4.fluid(7* U2, T)), FL.array(MT.MartianVitriol.fluid(3*U, F), MT.H.gas(U, F)), crushedCentrifuged.mat(tMat, 1), crushedCentrifugedTiny.mat(tMat, 2), crushedCentrifugedTiny.mat(tMat, 2), crushedCentrifugedTiny.mat(tMat, 2), crushedCentrifugedTiny.mat(tMat, 2), crushedCentrifugedTiny.mat(tMat, 2));
		RM.Bath         .addRecipe1(T,  0,  256, new long[] {10000, 5000, 5000, 5000, 5000, 5000}, crushedPurifiedTiny.mat(tMat, 9), FL.array(MT.H2SO4.fluid(7* U2, T)), FL.array(MT.MartianVitriol.fluid(3*U, F), MT.H.gas(U, F)), crushedCentrifuged.mat(tMat, 1), crushedCentrifugedTiny.mat(tMat, 2), crushedCentrifugedTiny.mat(tMat, 2), crushedCentrifugedTiny.mat(tMat, 2), crushedCentrifugedTiny.mat(tMat, 2), crushedCentrifugedTiny.mat(tMat, 2));
		}
		for (OreDictMaterial tMat : new OreDictMaterial[] {MT.Fe2O3, MT.Cr, MT.Pyrite, MT.Andradite, MT.PigIron, MT.Steel, MT.DarkIron, MT.DeepIron, MT.ShadowIron, MT.MeteoricIron, MT.OREMATS.Ilmenite, MT.OREMATS.Wolframite, MT.OREMATS.Chromite, MT.OREMATS.Magnetite, MT.OREMATS.BasalticMineralSand, MT.OREMATS.GraniticMineralSand}) {
		RM.Bath         .addRecipe1(T,  0,  256, new long[] {10000, 5000, 5000, 5000, 5000, 5000}, crushedPurified    .mat(tMat, 1), FL.array(MT.H2SO4.fluid(7* U2, T)), FL.array(MT.GreenVitriol.fluid(3*U, F), MT.H.gas(U, F)), crushedCentrifuged.mat(tMat, 1), crushedCentrifugedTiny.mat(tMat, 2), crushedCentrifugedTiny.mat(tMat, 2), crushedCentrifugedTiny.mat(tMat, 2), crushedCentrifugedTiny.mat(tMat, 2), crushedCentrifugedTiny.mat(tMat, 2));
		RM.Bath         .addRecipe1(T,  0,  256, new long[] {10000, 5000, 5000, 5000, 5000, 5000}, crushedPurifiedTiny.mat(tMat, 9), FL.array(MT.H2SO4.fluid(7* U2, T)), FL.array(MT.GreenVitriol.fluid(3*U, F), MT.H.gas(U, F)), crushedCentrifuged.mat(tMat, 1), crushedCentrifugedTiny.mat(tMat, 2), crushedCentrifugedTiny.mat(tMat, 2), crushedCentrifugedTiny.mat(tMat, 2), crushedCentrifugedTiny.mat(tMat, 2), crushedCentrifugedTiny.mat(tMat, 2));
		}
		for (OreDictMaterial tMat : new OreDictMaterial[] {MT.Cu, MT.Au, MT.Nikolite, MT.Azurite, MT.OREMATS.Malachite, MT.OREMATS.Chalcopyrite, MT.OREMATS.Tetrahedrite, MT.OREMATS.Kesterite, MT.OREMATS.Stannite}) {
		RM.Bath         .addRecipe1(T,  0,  256, new long[] {10000, 5000, 5000, 5000, 5000, 5000}, crushedPurified    .mat(tMat, 1), FL.array(MT.H2SO4.fluid(7* U2, T)), FL.array(MT.BlueVitriol.fluid(3*U, F), MT.H.gas(U, F)), crushedCentrifuged.mat(tMat, 1), crushedCentrifugedTiny.mat(tMat, 2), crushedCentrifugedTiny.mat(tMat, 2), crushedCentrifugedTiny.mat(tMat, 2), crushedCentrifugedTiny.mat(tMat, 2), crushedCentrifugedTiny.mat(tMat, 2));
		RM.Bath         .addRecipe1(T,  0,  256, new long[] {10000, 5000, 5000, 5000, 5000, 5000}, crushedPurifiedTiny.mat(tMat, 9), FL.array(MT.H2SO4.fluid(7* U2, T)), FL.array(MT.BlueVitriol.fluid(3*U, F), MT.H.gas(U, F)), crushedCentrifuged.mat(tMat, 1), crushedCentrifugedTiny.mat(tMat, 2), crushedCentrifugedTiny.mat(tMat, 2), crushedCentrifugedTiny.mat(tMat, 2), crushedCentrifugedTiny.mat(tMat, 2), crushedCentrifugedTiny.mat(tMat, 2));
		}
		for (OreDictMaterial tMat : new OreDictMaterial[] {MT.Co, MT.Co_60, MT.OREMATS.Cobaltite}) {
		RM.Bath         .addRecipe1(T,  0,  256, new long[] {10000, 5000, 5000, 5000, 5000, 5000}, crushedPurified    .mat(tMat, 1), FL.array(MT.H2SO4.fluid(7* U2, T)), FL.array(MT.RedVitriol.fluid(3*U, F), MT.H.gas(U, F)), crushedCentrifuged.mat(tMat, 1), crushedCentrifugedTiny.mat(tMat, 2), crushedCentrifugedTiny.mat(tMat, 2), crushedCentrifugedTiny.mat(tMat, 2), crushedCentrifugedTiny.mat(tMat, 2), crushedCentrifugedTiny.mat(tMat, 2));
		RM.Bath         .addRecipe1(T,  0,  256, new long[] {10000, 5000, 5000, 5000, 5000, 5000}, crushedPurifiedTiny.mat(tMat, 9), FL.array(MT.H2SO4.fluid(7* U2, T)), FL.array(MT.RedVitriol.fluid(3*U, F), MT.H.gas(U, F)), crushedCentrifuged.mat(tMat, 1), crushedCentrifugedTiny.mat(tMat, 2), crushedCentrifugedTiny.mat(tMat, 2), crushedCentrifugedTiny.mat(tMat, 2), crushedCentrifugedTiny.mat(tMat, 2), crushedCentrifugedTiny.mat(tMat, 2));
		}
		for (OreDictMaterial tMat : new OreDictMaterial[] {MT.Zn, MT.Sn, MT.Sb, MT.OREMATS.Sphalerite, MT.OREMATS.Smithsonite}) {
		RM.Bath         .addRecipe1(T,  0,  256, new long[] {10000, 5000, 5000, 5000, 5000, 5000}, crushedPurified    .mat(tMat, 1), FL.array(MT.H2SO4.fluid(7* U2, T)), FL.array(MT.WhiteVitriol.fluid(3*U, F), MT.H.gas(U, F)), crushedCentrifuged.mat(tMat, 1), crushedCentrifugedTiny.mat(tMat, 2), crushedCentrifugedTiny.mat(tMat, 2), crushedCentrifugedTiny.mat(tMat, 2), crushedCentrifugedTiny.mat(tMat, 2), crushedCentrifugedTiny.mat(tMat, 2));
		RM.Bath         .addRecipe1(T,  0,  256, new long[] {10000, 5000, 5000, 5000, 5000, 5000}, crushedPurifiedTiny.mat(tMat, 9), FL.array(MT.H2SO4.fluid(7* U2, T)), FL.array(MT.WhiteVitriol.fluid(3*U, F), MT.H.gas(U, F)), crushedCentrifuged.mat(tMat, 1), crushedCentrifugedTiny.mat(tMat, 2), crushedCentrifugedTiny.mat(tMat, 2), crushedCentrifugedTiny.mat(tMat, 2), crushedCentrifugedTiny.mat(tMat, 2), crushedCentrifugedTiny.mat(tMat, 2));
		}
		for (OreDictMaterial tMat : new OreDictMaterial[] {MT.Almandine, MT.OREMATS.Bauxite}) {
		RM.Bath         .addRecipe1(T,  0,  256, new long[] {10000, 5000, 5000, 5000, 5000, 5000}, crushedPurified    .mat(tMat, 1), FL.array(MT.H2SO4.fluid(21*U2, T)), FL.array(MT.VitriolOfClay.fluid(17*U2, F), MT.H.gas(3*U, F)), crushedCentrifuged.mat(tMat, 1), crushedCentrifugedTiny.mat(tMat, 2), crushedCentrifugedTiny.mat(tMat, 2), crushedCentrifugedTiny.mat(tMat, 2), crushedCentrifugedTiny.mat(tMat, 2), crushedCentrifugedTiny.mat(tMat, 2));
		RM.Bath         .addRecipe1(T,  0,  256, new long[] {10000, 5000, 5000, 5000, 5000, 5000}, crushedPurifiedTiny.mat(tMat, 9), FL.array(MT.H2SO4.fluid(21*U2, T)), FL.array(MT.VitriolOfClay.fluid(17*U2, F), MT.H.gas(3*U, F)), crushedCentrifuged.mat(tMat, 1), crushedCentrifugedTiny.mat(tMat, 2), crushedCentrifugedTiny.mat(tMat, 2), crushedCentrifugedTiny.mat(tMat, 2), crushedCentrifugedTiny.mat(tMat, 2), crushedCentrifugedTiny.mat(tMat, 2));
		}
		for (OreDictMaterial tMat : new OreDictMaterial[] {MT.Ru, MT.Rh, MT.Pd, MT.Os, MT.Ir, MT.Pt, MT.Ni, MT.Mithril, MT.MeteoricIron, MT.OREMATS.Cooperite, MT.OREMATS.Sperrylite}) {
		RM.Bath         .addRecipe1(T,  0,  256, new long[] {10000, 5000, 5000, 5000, 5000, 5000}, crushedPurified    .mat(tMat, 1), FL.array(MT.AquaRegia.fluid(78*U8, T)), FL.array(MT.ChloroplatinicAcid.fluid(36*U8, F), MT.NO.gas(12*U8, F), FL.Water.make(4125)/*, MT.O.gas(U8, F)*/), crushedCentrifuged.mat(tMat, 1), crushedCentrifugedTiny.mat(MT.PlatinumGroupSludge, 8), crushedCentrifugedTiny.mat(MT.PlatinumGroupSludge, 8), crushedCentrifugedTiny.mat(MT.PlatinumGroupSludge, 8), crushedCentrifugedTiny.mat(MT.PlatinumGroupSludge, 8), crushedCentrifugedTiny.mat(MT.PlatinumGroupSludge, 8));
		RM.Bath         .addRecipe1(T,  0,  256, new long[] {10000, 5000, 5000, 5000, 5000, 5000}, crushedPurifiedTiny.mat(tMat, 9), FL.array(MT.AquaRegia.fluid(78*U8, T)), FL.array(MT.ChloroplatinicAcid.fluid(36*U8, F), MT.NO.gas(12*U8, F), FL.Water.make(4125)/*, MT.O.gas(U8, F)*/), crushedCentrifuged.mat(tMat, 1), crushedCentrifugedTiny.mat(MT.PlatinumGroupSludge, 8), crushedCentrifugedTiny.mat(MT.PlatinumGroupSludge, 8), crushedCentrifugedTiny.mat(MT.PlatinumGroupSludge, 8), crushedCentrifugedTiny.mat(MT.PlatinumGroupSludge, 8), crushedCentrifugedTiny.mat(MT.PlatinumGroupSludge, 8));
		}
		for (OreDictMaterial tMat : new OreDictMaterial[] {MT.V, MT.V2O5, MT.Nb2O5, MT.Ta2O5, MT.OREMATS.Ferrovanadium, MT.OREMATS.Columbite, MT.OREMATS.Tantalite, MT.OREMATS.Coltan}) {
		RM.Bath         .addRecipe1(T,  0,  256, new long[] {10000, 5000, 5000, 5000, 5000, 5000}, crushedPurified    .mat(tMat, 1), FL.array(MT.HF.gas(U2, T)), ZL_FS, crushedCentrifuged.mat(tMat, 1), crushedCentrifugedTiny.mat(tMat, 2), crushedCentrifugedTiny.mat(tMat, 2), crushedCentrifugedTiny.mat(tMat, 2), crushedCentrifugedTiny.mat(tMat, 2), crushedCentrifugedTiny.mat(tMat, 2));
		RM.Bath         .addRecipe1(T,  0,  256, new long[] {10000, 5000, 5000, 5000, 5000, 5000}, crushedPurifiedTiny.mat(tMat, 9), FL.array(MT.HF.gas(U2, T)), ZL_FS, crushedCentrifuged.mat(tMat, 1), crushedCentrifugedTiny.mat(tMat, 2), crushedCentrifugedTiny.mat(tMat, 2), crushedCentrifugedTiny.mat(tMat, 2), crushedCentrifugedTiny.mat(tMat, 2), crushedCentrifugedTiny.mat(tMat, 2));
		}
		for (OreDictMaterial tMat : new OreDictMaterial[] {MT.Graphite, MT.Coal, MT.Anthracite, MT.Lignite, MT.Prismane, MT.Lonsdaleite}) {
		RM.Bath         .addRecipe1(T,  0,  256, new long[] {10000, 5000, 5000, 5000, 5000, 5000}, crushedPurified    .mat(tMat, 1), FL.array(MT.HF.gas(U2, T)), ZL_FS, crushedCentrifuged.mat(tMat, 1), crushedCentrifugedTiny.mat(MT.Graphite, 2), crushedCentrifugedTiny.mat(MT.Graphite, 2), crushedCentrifugedTiny.mat(MT.Graphite, 2), crushedCentrifugedTiny.mat(MT.Graphite, 2), crushedCentrifugedTiny.mat(MT.Graphite, 2));
		RM.Bath         .addRecipe1(T,  0,  256, new long[] {10000, 5000, 5000, 5000, 5000, 5000}, crushedPurifiedTiny.mat(tMat, 9), FL.array(MT.HF.gas(U2, T)), ZL_FS, crushedCentrifuged.mat(tMat, 1), crushedCentrifugedTiny.mat(MT.Graphite, 2), crushedCentrifugedTiny.mat(MT.Graphite, 2), crushedCentrifugedTiny.mat(MT.Graphite, 2), crushedCentrifugedTiny.mat(MT.Graphite, 2), crushedCentrifugedTiny.mat(MT.Graphite, 2));
		}
		for (OreDictMaterial tMat : OreDictMaterial.MATERIAL_ARRAY) if (tMat != null && !tMat.contains(ANTIMATTER) && tMat.mByProducts.contains(MT.MnO2)) {
		RM.Bath         .addRecipe1(T,  0,  256, crushedPurified    .mat(tMat, 1), FL.array(MT.HCl.gas(U * 4, T)), FL.array(MT.H2O.fluid(U * 3, F), MT.Cl.gas(U, F)), crushedCentrifuged.mat(tMat, 1), OM.dust(MT.MnCl2, U2*3));
		RM.Bath         .addRecipe1(T,  0,  256, crushedPurifiedTiny.mat(tMat, 9), FL.array(MT.HCl.gas(U * 4, T)), FL.array(MT.H2O.fluid(U * 3, F), MT.Cl.gas(U, F)), crushedCentrifuged.mat(tMat, 1), OM.dust(MT.MnCl2, U2*3));
		}
		
		RM.Bath         .addRecipe1(T,  0,  256, new long[] {10000, 5000, 5000, 5000, 5000, 5000}, crushedPurified    .mat(MT.Au                 , 1), FL.array(MT.AquaRegia.fluid(13*U2, T)), FL.array(MT.ChloroauricAcid.fluid( 3*U , F), MT.NO.gas(U, F), FL.Water.make(3000)), crushedCentrifuged.mat(MT.Au      , 1), crushedCentrifugedTiny.mat(MT.Cu, 2), crushedCentrifugedTiny.mat(MT.Cu, 2), crushedCentrifugedTiny.mat(MT.Cu, 2), crushedCentrifugedTiny.mat(MT.Cu, 2), crushedCentrifugedTiny.mat(MT.Cu, 2));
		RM.Bath         .addRecipe1(T,  0,  256, new long[] {10000, 5000, 5000, 5000, 5000, 5000}, crushedPurifiedTiny.mat(MT.Au                 , 9), FL.array(MT.AquaRegia.fluid(13*U2, T)), FL.array(MT.ChloroauricAcid.fluid( 3*U , F), MT.NO.gas(U, F), FL.Water.make(3000)), crushedCentrifuged.mat(MT.Au      , 1), crushedCentrifugedTiny.mat(MT.Cu, 2), crushedCentrifugedTiny.mat(MT.Cu, 2), crushedCentrifugedTiny.mat(MT.Cu, 2), crushedCentrifugedTiny.mat(MT.Cu, 2), crushedCentrifugedTiny.mat(MT.Cu, 2));
		RM.Bath         .addRecipe1(T,  0,  256, new long[] {10000, 5000, 5000, 5000, 5000, 5000}, crushedPurified    .mat(MT.Cu                 , 1), FL.array(MT.AquaRegia.fluid(13*U2, T)), FL.array(MT.ChloroauricAcid.fluid( 3*U , F), MT.NO.gas(U, F), FL.Water.make(3000)), crushedCentrifuged.mat(MT.Cu      , 1), crushedCentrifugedTiny.mat(MT.Co, 2), crushedCentrifugedTiny.mat(MT.Co, 2), crushedCentrifugedTiny.mat(MT.Co, 2), crushedCentrifugedTiny.mat(MT.Co, 2), crushedCentrifugedTiny.mat(MT.Co, 2));
		RM.Bath         .addRecipe1(T,  0,  256, new long[] {10000, 5000, 5000, 5000, 5000, 5000}, crushedPurifiedTiny.mat(MT.Cu                 , 9), FL.array(MT.AquaRegia.fluid(13*U2, T)), FL.array(MT.ChloroauricAcid.fluid( 3*U , F), MT.NO.gas(U, F), FL.Water.make(3000)), crushedCentrifuged.mat(MT.Cu      , 1), crushedCentrifugedTiny.mat(MT.Co, 2), crushedCentrifugedTiny.mat(MT.Co, 2), crushedCentrifugedTiny.mat(MT.Co, 2), crushedCentrifugedTiny.mat(MT.Co, 2), crushedCentrifugedTiny.mat(MT.Co, 2));
		RM.Bath         .addRecipe1(T,  0,  256, new long[] {10000, 5000, 5000, 5000, 5000, 5000}, crushedPurified    .mat(MT.Midasium           , 1), FL.array(MT.AquaRegia.fluid(13*U2, T)), FL.array(MT.ChloroauricAcid.fluid( 3*U , F), MT.NO.gas(U, F), FL.Water.make(3000)), crushedCentrifuged.mat(MT.Midasium, 1), crushedCentrifugedTiny.mat(MT.Co, 2), crushedCentrifugedTiny.mat(MT.Co, 2), crushedCentrifugedTiny.mat(MT.Co, 2), crushedCentrifugedTiny.mat(MT.Co, 2), crushedCentrifugedTiny.mat(MT.Co, 2));
		RM.Bath         .addRecipe1(T,  0,  256, new long[] {10000, 5000, 5000, 5000, 5000, 5000}, crushedPurifiedTiny.mat(MT.Midasium           , 9), FL.array(MT.AquaRegia.fluid(13*U2, T)), FL.array(MT.ChloroauricAcid.fluid( 3*U , F), MT.NO.gas(U, F), FL.Water.make(3000)), crushedCentrifuged.mat(MT.Midasium, 1), crushedCentrifugedTiny.mat(MT.Co, 2), crushedCentrifugedTiny.mat(MT.Co, 2), crushedCentrifugedTiny.mat(MT.Co, 2), crushedCentrifugedTiny.mat(MT.Co, 2), crushedCentrifugedTiny.mat(MT.Co, 2));
		
		RM.Bath         .addRecipe1(T,  0,  256, new long[] {10000, 5000, 5000, 5000, 5000, 5000}, crushedPurified    .mat(MT.Sn                 , 1), FL.array(MT.AquaRegia.fluid(13*U , T)), FL.array(MT.StannicChloride.fluid( 5*U2, F), MT.HCl.gas(4*U, F), MT.NO2.gas(3*U, F)/*, MT.NO2.gas(3* U2, F), MT.NO.gas(U, F), FL.Water.make(4500)*/), crushedCentrifuged.mat(MT.Sn                 , 1), crushedCentrifugedTiny.mat(MT.Zn, 2), crushedCentrifugedTiny.mat(MT.Zn, 2), crushedCentrifugedTiny.mat(MT.Zn, 2), crushedCentrifugedTiny.mat(MT.Zn, 2), crushedCentrifugedTiny.mat(MT.Zn, 2));
		RM.Bath         .addRecipe1(T,  0,  256, new long[] {10000, 5000, 5000, 5000, 5000, 5000}, crushedPurifiedTiny.mat(MT.Sn                 , 9), FL.array(MT.AquaRegia.fluid(13*U , T)), FL.array(MT.StannicChloride.fluid( 5*U2, F), MT.HCl.gas(4*U, F), MT.NO2.gas(3*U, F)/*, MT.NO2.gas(3* U2, F), MT.NO.gas(U, F), FL.Water.make(4500)*/), crushedCentrifuged.mat(MT.Sn                 , 1), crushedCentrifugedTiny.mat(MT.Zn, 2), crushedCentrifugedTiny.mat(MT.Zn, 2), crushedCentrifugedTiny.mat(MT.Zn, 2), crushedCentrifugedTiny.mat(MT.Zn, 2), crushedCentrifugedTiny.mat(MT.Zn, 2));
		RM.Bath         .addRecipe1(T,  0,  256, new long[] {10000, 5000, 5000, 5000, 5000, 5000}, crushedPurified    .mat(MT.OREMATS.Cassiterite, 1), FL.array(MT.AquaRegia.fluid(13*U , T)), FL.array(MT.StannicChloride.fluid( 5*U2, F), MT.HCl.gas(4*U, F), MT.NO2.gas(3*U, F)/*, MT.NO2.gas(3* U2, F), MT.NO.gas(U, F), FL.Water.make(4500)*/), crushedCentrifuged.mat(MT.OREMATS.Cassiterite, 1), crushedCentrifugedTiny.mat(MT.Zn, 2), crushedCentrifugedTiny.mat(MT.Zn, 2), crushedCentrifugedTiny.mat(MT.Zn, 2), crushedCentrifugedTiny.mat(MT.Zn, 2), crushedCentrifugedTiny.mat(MT.Zn, 2));
		RM.Bath         .addRecipe1(T,  0,  256, new long[] {10000, 5000, 5000, 5000, 5000, 5000}, crushedPurifiedTiny.mat(MT.OREMATS.Cassiterite, 9), FL.array(MT.AquaRegia.fluid(13*U , T)), FL.array(MT.StannicChloride.fluid( 5*U2, F), MT.HCl.gas(4*U, F), MT.NO2.gas(3*U, F)/*, MT.NO2.gas(3* U2, F), MT.NO.gas(U, F), FL.Water.make(4500)*/), crushedCentrifuged.mat(MT.OREMATS.Cassiterite, 1), crushedCentrifugedTiny.mat(MT.Zn, 2), crushedCentrifugedTiny.mat(MT.Zn, 2), crushedCentrifugedTiny.mat(MT.Zn, 2), crushedCentrifugedTiny.mat(MT.Zn, 2), crushedCentrifugedTiny.mat(MT.Zn, 2));
		
		RM.Bath         .addRecipe1(T,  0,  256, OP.crushed    .mat(MT.OREMATS.Cinnabar, 1), MT.Cryotheum.liquid(U2, T), NF, OP.gemFlawless.mat(MT.OREMATS.Cinnabar, 1));
		RM.Bath         .addRecipe1(T,  0,  256, OP.crushedTiny.mat(MT.OREMATS.Cinnabar, 9), MT.Cryotheum.liquid(U2, T), NF, OP.gemFlawless.mat(MT.OREMATS.Cinnabar, 1));
		
		ItemStack tStack;
		FluidStack tPyrotheum = MT.Pyrotheum.liquid(U2, T);
		RM.Bath         .addRecipe1(T,  0,   64, new long[] {10000,  3000}, OP.crushed.mat(MT.Au           , 1), tPyrotheum, NF, tStack = OP.chunkGt.mat(MT.Au           , 1), tStack, tStack, tStack, tStack, IL.TE_Slag_Rich.get(1, IL.IE_Slag.get(1)));
		RM.Bath         .addRecipe1(T,  0,   64, new long[] {10000,  2250}, OP.crushed.mat(MT.Ni           , 1), tPyrotheum, NF, tStack = OP.chunkGt.mat(MT.Ni           , 1), tStack, tStack, tStack, tStack, IL.TE_Slag_Rich.get(1, IL.IE_Slag.get(1)));
		RM.Bath         .addRecipe1(T,  0,   64, new long[] {10000,  1500}, OP.crushed.mat(MT.Co           , 1), tPyrotheum, NF, tStack = OP.chunkGt.mat(MT.Co           , 1), tStack, tStack, tStack, tStack, IL.TE_Slag_Rich.get(1, IL.IE_Slag.get(1)));
		RM.Bath         .addRecipe1(T,  0,   64, new long[] {10000,   750}, OP.crushed.mat(MT.Pb           , 1), tPyrotheum, NF, tStack = OP.chunkGt.mat(MT.Pb           , 1), tStack, tStack, tStack, tStack, IL.TE_Slag_Rich.get(1, IL.IE_Slag.get(1)));
		RM.Bath         .addRecipe1(T,  0,   64, new long[] {10000,   750}, OP.crushed.mat(MT.Sn           , 1), tPyrotheum, NF, tStack = OP.chunkGt.mat(MT.Sn           , 1), tStack, tStack, tStack, tStack, IL.TE_Slag_Rich.get(1, IL.IE_Slag.get(1)));
		RM.Bath         .addRecipe1(T,  0,   64, new long[] {10000,   750}, OP.crushed.mat(MT.Cu           , 1), tPyrotheum, NF, tStack = OP.chunkGt.mat(MT.Cu           , 1), tStack, tStack, tStack, tStack, IL.TE_Slag_Rich.get(1, IL.IE_Slag.get(1)));
		RM.Bath         .addRecipe1(T,  0,   64, new long[] {10000,   750}, OP.crushed.mat(MT.Pt           , 1), tPyrotheum, NF, tStack = OP.chunkGt.mat(MT.Pt           , 1), tStack, tStack, tStack, tStack, IL.TE_Slag_Rich.get(1, IL.IE_Slag.get(1)));
		RM.Bath         .addRecipe1(T,  0,   64, new long[] {10000,   750}, OP.crushed.mat(MT.Ir           , 1), tPyrotheum, NF, tStack = OP.chunkGt.mat(MT.Ir           , 1), tStack, tStack, tStack, tStack, IL.TE_Slag_Rich.get(1, IL.IE_Slag.get(1)));
		RM.Bath         .addRecipe1(T,  0,   64, new long[] {10000,   750}, OP.crushed.mat(MT.Os           , 1), tPyrotheum, NF, tStack = OP.chunkGt.mat(MT.Os           , 1), tStack, tStack, tStack, tStack, IL.TE_Slag_Rich.get(1, IL.IE_Slag.get(1)));
		RM.Bath         .addRecipe1(T,  0,   64, new long[] {10000,   750}, OP.crushed.mat(MT.Hg           , 1), tPyrotheum, NF, tStack = OP.chunkGt.mat(MT.Hg           , 1), tStack, tStack, tStack, tStack, IL.TE_Slag_Rich.get(1, IL.IE_Slag.get(1)));
		RM.Bath         .addRecipe1(T,  0,   64, new long[] {10000,   750}, OP.crushed.mat(MT.Cr           , 1), tPyrotheum, NF, tStack = OP.chunkGt.mat(MT.Cr           , 1), tStack, tStack, tStack, tStack, IL.TE_Slag_Rich.get(1, IL.IE_Slag.get(1)));
		RM.Bath         .addRecipe1(T,  0,   64, new long[] {10000,   750}, OP.crushed.mat(MT.Mn           , 1), tPyrotheum, NF, tStack = OP.chunkGt.mat(MT.Mn           , 1), tStack, tStack, tStack, tStack, IL.TE_Slag_Rich.get(1, IL.IE_Slag.get(1)));
		RM.Bath         .addRecipe1(T,  0,   64, new long[] {10000,   750}, OP.crushed.mat(MT.Mo           , 1), tPyrotheum, NF, tStack = OP.chunkGt.mat(MT.Mo           , 1), tStack, tStack, tStack, tStack, IL.TE_Slag_Rich.get(1, IL.IE_Slag.get(1)));
		RM.Bath         .addRecipe1(T,  0,   64, new long[] {10000,   750}, OP.crushed.mat(MT.Nd           , 1), tPyrotheum, NF, tStack = OP.chunkGt.mat(MT.Nd           , 1), tStack, tStack, tStack, tStack, IL.TE_Slag_Rich.get(1, IL.IE_Slag.get(1)));
		RM.Bath         .addRecipe1(T,  0,   64, new long[] {10000,   750}, OP.crushed.mat(MT.Ag           , 1), tPyrotheum, NF, tStack = OP.chunkGt.mat(MT.Ag           , 1), tStack, tStack, tStack, tStack, IL.TE_Slag_Rich.get(1, IL.IE_Slag.get(1)));
		RM.Bath         .addRecipe1(T,  0,   64, new long[] {10000,   750}, OP.crushed.mat(MT.Bi           , 1), tPyrotheum, NF, tStack = OP.chunkGt.mat(MT.Bi           , 1), tStack, tStack, tStack, tStack, IL.TE_Slag_Rich.get(1, IL.IE_Slag.get(1)));
		RM.Bath         .addRecipe1(T,  0,   64, new long[] {10000,   750}, OP.crushed.mat(MT.Zn           , 1), tPyrotheum, NF, tStack = OP.chunkGt.mat(MT.Zn           , 1), tStack, tStack, tStack, tStack, IL.TE_Slag_Rich.get(1, IL.IE_Slag.get(1)));
		RM.Bath         .addRecipe1(T,  0,   64, new long[] {10000,   750}, OP.crushed.mat(MT.Cd           , 1), tPyrotheum, NF, tStack = OP.chunkGt.mat(MT.Cd           , 1), tStack, tStack, tStack, tStack, IL.TE_Slag_Rich.get(1, IL.IE_Slag.get(1)));
		RM.Bath         .addRecipe1(T,  0,   64, new long[] {10000,   750}, OP.crushed.mat(MT.Pd           , 1), tPyrotheum, NF, tStack = OP.chunkGt.mat(MT.Pd           , 1), tStack, tStack, tStack, tStack, IL.TE_Slag_Rich.get(1, IL.IE_Slag.get(1)));
		RM.Bath         .addRecipe1(T,  0,   64, new long[] {10000,   750}, OP.crushed.mat(MT.In           , 1), tPyrotheum, NF, tStack = OP.chunkGt.mat(MT.In           , 1), tStack, tStack, tStack, tStack, IL.TE_Slag_Rich.get(1, IL.IE_Slag.get(1)));
		RM.Bath         .addRecipe1(T,  0,   64, new long[] {10000,   750}, OP.crushed.mat(MT.Ge           , 1), tPyrotheum, NF, tStack = OP.chunkGt.mat(MT.Ge           , 1), tStack, tStack, tStack, tStack, IL.TE_Slag_Rich.get(1, IL.IE_Slag.get(1)));
		RM.Bath         .addRecipe1(T,  0,   64, new long[] {10000,   750}, OP.crushed.mat(MT.AncientDebris, 1), tPyrotheum, NF, tStack = OP.chunkGt.mat(MT.AncientDebris, 1), tStack, tStack, tStack, tStack, IL.TE_Slag_Rich.get(1, IL.IE_Slag.get(1)));
		RM.Bath         .addRecipe1(T,  0,   64, new long[] {10000,   750}, OP.crushed.mat(MT.Electrum     , 1), tPyrotheum, NF, tStack = OP.chunkGt.mat(MT.Electrum     , 1), tStack, tStack, tStack, tStack, IL.TE_Slag_Rich.get(1, IL.IE_Slag.get(1)));
		RM.Bath         .addRecipe1(T,  0,   64, new long[] {10000,   750}, OP.crushed.mat(MT.AstralSilver , 1), tPyrotheum, NF, tStack = OP.chunkGt.mat(MT.AstralSilver , 1), tStack, tStack, tStack, tStack, IL.TE_Slag_Rich.get(1, IL.IE_Slag.get(1)));
		RM.Bath         .addRecipe1(T,  0,   64, new long[] {10000,   750}, OP.crushed.mat(MT.Midasium     , 1), tPyrotheum, NF, tStack = OP.chunkGt.mat(MT.Midasium     , 1), tStack, tStack, tStack, tStack, IL.TE_Slag_Rich.get(1, IL.IE_Slag.get(1)));
		RM.Bath         .addRecipe1(T,  0,   64, new long[] {10000,   750}, OP.crushed.mat(MT.Mithril      , 1), tPyrotheum, NF, tStack = OP.chunkGt.mat(MT.Mithril      , 1), tStack, tStack, tStack, tStack, IL.TE_Slag_Rich.get(1, IL.IE_Slag.get(1)));
		RM.Bath         .addRecipe1(T,  0,   64, new long[] {10000,   750}, OP.crushed.mat(MT.Cheese       , 1), tPyrotheum, NF, tStack = OP.chunkGt.mat(MT.Cheese       , 1), tStack, tStack, tStack, tStack, IL.TE_Slag_Rich.get(1, IL.IE_Slag.get(1)));
		RM.Bath         .addRecipe1(T,  0,   64, new long[] {10000,   750}, OP.crushed.mat(MT.Ardite       , 1), tPyrotheum, NF, tStack = OP.chunkGt.mat(MT.Ardite       , 1), tStack, tStack, tStack, tStack, IL.TE_Slag_Rich.get(1, IL.IE_Slag.get(1)));
		RM.Bath         .addRecipe1(T,  0,   64, new long[] {10000,   750}, OP.crushed.mat(MT.Desh         , 1), tPyrotheum, NF, tStack = OP.chunkGt.mat(MT.Desh         , 1), tStack, tStack, tStack, tStack, IL.TE_Slag_Rich.get(1, IL.IE_Slag.get(1)));
		
		if (IL.BoP_Grass_Smoldering .exists())  RM.Sifting.addRecipe1(T, 16, 144, new long[] { 8000,  2000                                                                      }, IL.BoP_Grass_Smoldering      .get( 1)/*|*/, ST.make(Blocks.dirt  , 1, 1), OM.dust(MT.Ash, U4));
		/* Grass                            */  RM.Sifting.addRecipe1(T, 16, 144, new long[] { 8000,  2000,  1000,  1000,  1000,  1000,   500,   500,   500                     }, ST.make(Blocks.grass         ,  1, W)/*|*/, ST.make(Blocks.dirt  , 1, 1), ST.make(Items.wheat_seeds, 1, 0), ST.make(Items.melon_seeds, 1, 0), ST.make(Items.pumpkin_seeds, 1, 0), IL.BoP_Turnip_Seeds.get(1), IL.EtFu_Beet_Seeds.get(1, IL.GaSu_Beet_Seeds.get(1)), IL.MaCu_Bait_Worm.get(2), IL.MaCu_Bait_Grasshopper.get(1), IL.MaCu_Bait_Ant.get(1));
		/* Grass                            */  RM.Sifting.addRecipe1(T, 16, 144, new long[] { 8000,  2000,  1000,  1000,  1000,  1000,   500,   500,   500                     }, ST.make(BlocksGT.Grass       ,  1, W)/*|*/, ST.make(Blocks.dirt  , 1, 1), ST.make(Items.wheat_seeds, 1, 0), ST.make(Items.melon_seeds, 1, 0), ST.make(Items.pumpkin_seeds, 1, 0), IL.BoP_Turnip_Seeds.get(1), IL.EtFu_Beet_Seeds.get(1, IL.GaSu_Beet_Seeds.get(1)), IL.MaCu_Bait_Worm.get(2), IL.MaCu_Bait_Grasshopper.get(1), IL.MaCu_Bait_Ant.get(1));
		if (IL.BoP_Grass_Origin     .exists())  RM.Sifting.addRecipe1(T, 16, 144, new long[] { 8000,  3000,  1500,  1500,  1500,  1500,   750,   750,   750                     }, IL.BoP_Grass_Origin          .get( 1)/*|*/, ST.make(Blocks.dirt  , 1, 1), ST.make(Items.wheat_seeds, 1, 0), ST.make(Items.melon_seeds, 1, 0), ST.make(Items.pumpkin_seeds, 1, 0), IL.BoP_Turnip_Seeds.get(1), IL.EtFu_Beet_Seeds.get(1, IL.GaSu_Beet_Seeds.get(1)), IL.MaCu_Bait_Worm.get(2), IL.MaCu_Bait_Grasshopper.get(1), IL.MaCu_Bait_Ant.get(1));
		if (IL.BoP_Grass_Long       .exists())  RM.Sifting.addRecipe1(T, 16, 144, new long[] { 8000,  4000,  2000,  2000,  2000,  2000,  1000,  1000,  1000                     }, IL.BoP_Grass_Long            .get( 1)/*|*/, ST.make(Blocks.dirt  , 1, 1), ST.make(Items.wheat_seeds, 1, 0), ST.make(Items.melon_seeds, 1, 0), ST.make(Items.pumpkin_seeds, 1, 0), IL.BoP_Turnip_Seeds.get(1), IL.EtFu_Beet_Seeds.get(1, IL.GaSu_Beet_Seeds.get(1)), IL.MaCu_Bait_Worm.get(2), IL.MaCu_Bait_Grasshopper.get(1), IL.MaCu_Bait_Ant.get(1));
		if (IL.BoP_Grass_Loamy      .exists())  RM.Sifting.addRecipe1(T, 16, 144, new long[] { 8000,  2000,  1000,  1000,  1000,  1000,   500,   500,   500                     }, IL.BoP_Grass_Loamy           .get( 1)/*|*/, IL.BoP_Coarse_Loamy  .get(1), ST.make(Items.wheat_seeds, 1, 0), ST.make(Items.melon_seeds, 1, 0), ST.make(Items.pumpkin_seeds, 1, 0), IL.BoP_Turnip_Seeds.get(1), IL.EtFu_Beet_Seeds.get(1, IL.GaSu_Beet_Seeds.get(1)), IL.MaCu_Bait_Worm.get(2), IL.MaCu_Bait_Grasshopper.get(1), IL.MaCu_Bait_Ant.get(1));
		if (IL.BoP_Grass_Silty      .exists())  RM.Sifting.addRecipe1(T, 16, 144, new long[] { 8000,  2000,  1000,  1000,  1000,  1000,   500,   500,   500                     }, IL.BoP_Grass_Silty           .get( 1)/*|*/, IL.BoP_Coarse_Silty  .get(1), ST.make(Items.wheat_seeds, 1, 0), ST.make(Items.melon_seeds, 1, 0), ST.make(Items.pumpkin_seeds, 1, 0), IL.BoP_Turnip_Seeds.get(1), IL.EtFu_Beet_Seeds.get(1, IL.GaSu_Beet_Seeds.get(1)), IL.MaCu_Bait_Worm.get(2), IL.MaCu_Bait_Grasshopper.get(1), IL.MaCu_Bait_Ant.get(1));
		if (IL.BoP_Grass_Sandy      .exists())  RM.Sifting.addRecipe1(T, 16, 144, new long[] { 8000,  2000,  1000,  1000,  1000,  1000,   500,   500,   500                     }, IL.BoP_Grass_Sandy           .get( 1)/*|*/, IL.BoP_Coarse_Sandy  .get(1), ST.make(Items.wheat_seeds, 1, 0), ST.make(Items.melon_seeds, 1, 0), ST.make(Items.pumpkin_seeds, 1, 0), IL.BoP_Turnip_Seeds.get(1), IL.EtFu_Beet_Seeds.get(1, IL.GaSu_Beet_Seeds.get(1)), IL.MaCu_Bait_Worm.get(2), IL.MaCu_Bait_Grasshopper.get(1), IL.MaCu_Bait_Ant.get(1));
		if (IL.EB_Grass_Alfisol     .exists())  RM.Sifting.addRecipe1(T, 16, 144, new long[] { 8000,  2000,  1000,  1000,  1000,  1000,   500,   500,   500                     }, IL.EB_Grass_Alfisol          .get( 1)/*|*/, ST.make(Blocks.dirt  , 1, 1), ST.make(Items.wheat_seeds, 1, 0), ST.make(Items.melon_seeds, 1, 0), ST.make(Items.pumpkin_seeds, 1, 0), IL.BoP_Turnip_Seeds.get(1), IL.EtFu_Beet_Seeds.get(1, IL.GaSu_Beet_Seeds.get(1)), IL.MaCu_Bait_Worm.get(2), IL.MaCu_Bait_Grasshopper.get(1), IL.MaCu_Bait_Ant.get(1));
		if (IL.EB_Grass_Andisol     .exists())  RM.Sifting.addRecipe1(T, 16, 144, new long[] { 8000,  2000,  1000,  1000,  1000,  1000,   500,   500,   500                     }, IL.EB_Grass_Andisol          .get( 1)/*|*/, ST.make(Blocks.dirt  , 1, 1), ST.make(Items.wheat_seeds, 1, 0), ST.make(Items.melon_seeds, 1, 0), ST.make(Items.pumpkin_seeds, 1, 0), IL.BoP_Turnip_Seeds.get(1), IL.EtFu_Beet_Seeds.get(1, IL.GaSu_Beet_Seeds.get(1)), IL.MaCu_Bait_Worm.get(2), IL.MaCu_Bait_Grasshopper.get(1), IL.MaCu_Bait_Ant.get(1));
		if (IL.EB_Grass_Gelisol     .exists())  RM.Sifting.addRecipe1(T, 16, 144, new long[] { 8000,  2000,  1000,  1000,  1000,  1000,   500,   500,   500                     }, IL.EB_Grass_Gelisol          .get( 1)/*|*/, ST.make(Blocks.dirt  , 1, 1), ST.make(Items.wheat_seeds, 1, 0), ST.make(Items.melon_seeds, 1, 0), ST.make(Items.pumpkin_seeds, 1, 0), IL.BoP_Turnip_Seeds.get(1), IL.EtFu_Beet_Seeds.get(1, IL.GaSu_Beet_Seeds.get(1)), IL.MaCu_Bait_Worm.get(2), IL.MaCu_Bait_Grasshopper.get(1), IL.MaCu_Bait_Ant.get(1));
		if (IL.EB_Grass_Histosol    .exists())  RM.Sifting.addRecipe1(T, 16, 144, new long[] { 8000,  2000,  1000,  1000,  1000,  1000,   500,   500,   500                     }, IL.EB_Grass_Histosol         .get( 1)/*|*/, ST.make(Blocks.dirt  , 1, 1), ST.make(Items.wheat_seeds, 1, 0), ST.make(Items.melon_seeds, 1, 0), ST.make(Items.pumpkin_seeds, 1, 0), IL.BoP_Turnip_Seeds.get(1), IL.EtFu_Beet_Seeds.get(1, IL.GaSu_Beet_Seeds.get(1)), IL.MaCu_Bait_Worm.get(2), IL.MaCu_Bait_Grasshopper.get(1), IL.MaCu_Bait_Ant.get(1));
		if (IL.EB_Grass_Inceptisol  .exists())  RM.Sifting.addRecipe1(T, 16, 144, new long[] { 8000,  2000,  1000,  1000,  1000,  1000,   500,   500,   500                     }, IL.EB_Grass_Inceptisol       .get( 1)/*|*/, ST.make(Blocks.dirt  , 1, 1), ST.make(Items.wheat_seeds, 1, 0), ST.make(Items.melon_seeds, 1, 0), ST.make(Items.pumpkin_seeds, 1, 0), IL.BoP_Turnip_Seeds.get(1), IL.EtFu_Beet_Seeds.get(1, IL.GaSu_Beet_Seeds.get(1)), IL.MaCu_Bait_Worm.get(2), IL.MaCu_Bait_Grasshopper.get(1), IL.MaCu_Bait_Ant.get(1));
		if (IL.EB_Grass_Mollisol    .exists())  RM.Sifting.addRecipe1(T, 16, 144, new long[] { 8000,  2000,  1000,  1000,  1000,  1000,   500,   500,   500                     }, IL.EB_Grass_Mollisol         .get( 1)/*|*/, ST.make(Blocks.dirt  , 1, 1), ST.make(Items.wheat_seeds, 1, 0), ST.make(Items.melon_seeds, 1, 0), ST.make(Items.pumpkin_seeds, 1, 0), IL.BoP_Turnip_Seeds.get(1), IL.EtFu_Beet_Seeds.get(1, IL.GaSu_Beet_Seeds.get(1)), IL.MaCu_Bait_Worm.get(2), IL.MaCu_Bait_Grasshopper.get(1), IL.MaCu_Bait_Ant.get(1));
		if (IL.EB_Grass_Oxisol      .exists())  RM.Sifting.addRecipe1(T, 16, 144, new long[] { 8000,  2000,  1000,  1000,  1000,  1000,   500,   500,   500                     }, IL.EB_Grass_Oxisol           .get( 1)/*|*/, ST.make(Blocks.dirt  , 1, 1), ST.make(Items.wheat_seeds, 1, 0), ST.make(Items.melon_seeds, 1, 0), ST.make(Items.pumpkin_seeds, 1, 0), IL.BoP_Turnip_Seeds.get(1), IL.EtFu_Beet_Seeds.get(1, IL.GaSu_Beet_Seeds.get(1)), IL.MaCu_Bait_Worm.get(2), IL.MaCu_Bait_Grasshopper.get(1), IL.MaCu_Bait_Ant.get(1));
		if (IL.Salt_Grass           .exists())  RM.Sifting.addRecipe1(T, 16, 144, new long[] { 8000,  2000,  1000,  1000,  1000,  1000,   500,   500,   500                     }, IL.Salt_Grass                 .get(1)/*|*/, IL.Salt_Dirt_1       .get(1), ST.make(Items.wheat_seeds, 1, 0), ST.make(Items.melon_seeds, 1, 0), ST.make(Items.pumpkin_seeds, 1, 0), IL.BoP_Turnip_Seeds.get(1), IL.EtFu_Beet_Seeds.get(1, IL.GaSu_Beet_Seeds.get(1)), IL.MaCu_Bait_Worm.get(2), IL.MaCu_Bait_Grasshopper.get(1), IL.MaCu_Bait_Ant.get(1));
		/* Dirt                             */  RM.Sifting.addRecipe1(T, 16, 144, new long[] { 8000,   500,   250,   250,   250,   250,   500                                   }, ST.make(Blocks.dirt          ,  1, 0)/*|*/, ST.make(Blocks.dirt  , 1, 1), ST.make(Items.wheat_seeds, 1, 0), ST.make(Items.melon_seeds, 1, 0), ST.make(Items.pumpkin_seeds, 1, 0), IL.BoP_Turnip_Seeds.get(1), IL.EtFu_Beet_Seeds.get(1, IL.GaSu_Beet_Seeds.get(1)), IL.MaCu_Bait_Worm.get(1));
		if (IL.BoP_Dirt_Loamy       .exists())  RM.Sifting.addRecipe1(T, 16, 144, new long[] { 8000,   500,   250,   250,   250,   250,   500                                   }, IL.BoP_Dirt_Loamy            .get( 1)/*|*/, IL.BoP_Coarse_Loamy  .get(1), ST.make(Items.wheat_seeds, 1, 0), ST.make(Items.melon_seeds, 1, 0), ST.make(Items.pumpkin_seeds, 1, 0), IL.BoP_Turnip_Seeds.get(1), IL.EtFu_Beet_Seeds.get(1, IL.GaSu_Beet_Seeds.get(1)), IL.MaCu_Bait_Worm.get(1));
		if (IL.BoP_Dirt_Silty       .exists())  RM.Sifting.addRecipe1(T, 16, 144, new long[] { 8000,   500,   250,   250,   250,   250,   500                                   }, IL.BoP_Dirt_Silty            .get( 1)/*|*/, IL.BoP_Coarse_Silty  .get(1), ST.make(Items.wheat_seeds, 1, 0), ST.make(Items.melon_seeds, 1, 0), ST.make(Items.pumpkin_seeds, 1, 0), IL.BoP_Turnip_Seeds.get(1), IL.EtFu_Beet_Seeds.get(1, IL.GaSu_Beet_Seeds.get(1)), IL.MaCu_Bait_Worm.get(1));
		if (IL.BoP_Dirt_Sandy       .exists())  RM.Sifting.addRecipe1(T, 16, 144, new long[] { 8000,   500,   250,   250,   250,   250,   500                                   }, IL.BoP_Dirt_Sandy            .get( 1)/*|*/, IL.BoP_Coarse_Sandy  .get(1), ST.make(Items.wheat_seeds, 1, 0), ST.make(Items.melon_seeds, 1, 0), ST.make(Items.pumpkin_seeds, 1, 0), IL.BoP_Turnip_Seeds.get(1), IL.EtFu_Beet_Seeds.get(1, IL.GaSu_Beet_Seeds.get(1)), IL.MaCu_Bait_Worm.get(1));
		if (IL.EB_Dirt_Alfisol      .exists())  RM.Sifting.addRecipe1(T, 16, 144, new long[] { 8000,   500,   250,   250,   250,   250,   500,  1000                            }, IL.EB_Dirt_Alfisol           .get( 1)/*|*/, ST.make(Blocks.dirt  , 1, 1), ST.make(Items.wheat_seeds, 1, 0), ST.make(Items.melon_seeds, 1, 0), ST.make(Items.pumpkin_seeds, 1, 0), IL.BoP_Turnip_Seeds.get(1), IL.EtFu_Beet_Seeds.get(1, IL.GaSu_Beet_Seeds.get(1)), IL.MaCu_Bait_Worm.get(1), OM.dust(MT.Palygorskite, U4));
		if (IL.EB_Dirt_Andisol      .exists())  RM.Sifting.addRecipe1(T, 16, 144, new long[] { 8000,   500,   250,   250,   250,   250,   500,  1000                            }, IL.EB_Dirt_Andisol           .get( 1)/*|*/, ST.make(Blocks.dirt  , 1, 1), ST.make(Items.wheat_seeds, 1, 0), ST.make(Items.melon_seeds, 1, 0), ST.make(Items.pumpkin_seeds, 1, 0), IL.BoP_Turnip_Seeds.get(1), IL.EtFu_Beet_Seeds.get(1, IL.GaSu_Beet_Seeds.get(1)), IL.MaCu_Bait_Worm.get(1), OM.dust(MT.VolcanicAsh, U4));
		if (IL.EB_Dirt_Gelisol      .exists())  RM.Sifting.addRecipe1(T, 16, 144, new long[] { 8000,   500,   250,   250,   250,   250,   500,  1000                            }, IL.EB_Dirt_Gelisol           .get( 1)/*|*/, ST.make(Blocks.dirt  , 1, 1), ST.make(Items.wheat_seeds, 1, 0), ST.make(Items.melon_seeds, 1, 0), ST.make(Items.pumpkin_seeds, 1, 0), IL.BoP_Turnip_Seeds.get(1), IL.EtFu_Beet_Seeds.get(1, IL.GaSu_Beet_Seeds.get(1)), IL.MaCu_Bait_Worm.get(1), OM.dust(MT.Ice, U4));
		if (IL.EB_Dirt_Histosol     .exists())  RM.Sifting.addRecipe1(T, 16, 144, new long[] { 8000,   500,   250,   250,   250,   250,   500,  1000                            }, IL.EB_Dirt_Histosol          .get( 1)/*|*/, ST.make(Blocks.dirt  , 1, 1), ST.make(Items.wheat_seeds, 1, 0), ST.make(Items.melon_seeds, 1, 0), ST.make(Items.pumpkin_seeds, 1, 0), IL.BoP_Turnip_Seeds.get(1), IL.EtFu_Beet_Seeds.get(1, IL.GaSu_Beet_Seeds.get(1)), IL.MaCu_Bait_Worm.get(1), OM.ingot(MT.Peat, U));
		if (IL.EB_Dirt_Inceptisol   .exists())  RM.Sifting.addRecipe1(T, 16, 144, new long[] { 8000,   500,   250,   250,   250,   250,   500                                   }, IL.EB_Dirt_Inceptisol        .get( 1)/*|*/, ST.make(Blocks.dirt  , 1, 1), ST.make(Items.wheat_seeds, 1, 0), ST.make(Items.melon_seeds, 1, 0), ST.make(Items.pumpkin_seeds, 1, 0), IL.BoP_Turnip_Seeds.get(1), IL.EtFu_Beet_Seeds.get(1, IL.GaSu_Beet_Seeds.get(1)), IL.MaCu_Bait_Worm.get(1));
		if (IL.EB_Dirt_Mollisol     .exists())  RM.Sifting.addRecipe1(T, 16, 144, new long[] { 8000,   500,   250,   250,   250,   250,   500                                   }, IL.EB_Dirt_Mollisol          .get( 1)/*|*/, ST.make(Blocks.dirt  , 1, 1), ST.make(Items.wheat_seeds, 2, 0), ST.make(Items.melon_seeds, 2, 0), ST.make(Items.pumpkin_seeds, 2, 0), IL.BoP_Turnip_Seeds.get(2), IL.EtFu_Beet_Seeds.get(2, IL.GaSu_Beet_Seeds.get(2)), IL.MaCu_Bait_Worm.get(2));
		if (IL.EB_Dirt_Oxisol       .exists())  RM.Sifting.addRecipe1(T, 16, 144, new long[] { 8000,   500,   250,   250,   250,   250,   500,  1000                            }, IL.EB_Dirt_Oxisol            .get( 1)/*|*/, ST.make(Blocks.dirt  , 1, 1), ST.make(Items.wheat_seeds, 1, 0), ST.make(Items.melon_seeds, 1, 0), ST.make(Items.pumpkin_seeds, 1, 0), IL.BoP_Turnip_Seeds.get(1), IL.EtFu_Beet_Seeds.get(1, IL.GaSu_Beet_Seeds.get(1)), IL.MaCu_Bait_Worm.get(1), OM.dust(MT.Al2O3, U4));
		/* Coarse Dirt                      */  RM.Sifting.addRecipe1(T, 16, 144, new long[] { 4500,  3000,   250,   100                                                        }, ST.make(Blocks.dirt          ,  1, 1)/*|*/, OM.dust(MT.Sand      , U   ), OM.dust(MT.Stone            ), OM.dust(MT.ClayBrown   ), IL.Clay_Ball_Brown .get(1));
		if (IL.EtFu_Dirt            .exists())  RM.Sifting.addRecipe1(T, 16, 144, new long[] { 4500,  3000,   250,   100                                                        }, IL.EtFu_Dirt                 .wild(1)/*|*/, OM.dust(MT.Sand      , U   ), OM.dust(MT.Stone            ), OM.dust(MT.ClayBrown   ), IL.Clay_Ball_Brown .get(1));
		if (IL.Salt_Dirt_1          .exists())  RM.Sifting.addRecipe1(T, 16, 144, new long[] { 4500,  3000,   250,   100,  4500                                                 }, IL.Salt_Dirt_1                .get(1)/*|*/, OM.dust(MT.Sand      , U   ), OM.dust(MT.Stone            ), OM.dust(MT.ClayBrown   ), IL.Clay_Ball_Brown .get(1), OP.dust.mat(MT.NaCl, 1));
		if (IL.Salt_Dirt_2          .exists())  RM.Sifting.addRecipe1(T, 16, 144, new long[] { 4500,  3000,   250,   100,  9000                                                 }, IL.Salt_Dirt_2                .get(1)/*|*/, OM.dust(MT.Sand      , U   ), OM.dust(MT.Stone            ), OM.dust(MT.ClayBrown   ), IL.Clay_Ball_Brown .get(1), OP.dust.mat(MT.NaCl, 1));
		if (IL.Salt_Dirt_3          .exists())  RM.Sifting.addRecipe1(T, 16, 144, new long[] { 4500,  3000,   250,   100,  9000                                                 }, IL.Salt_Dirt_3                .get(1)/*|*/, OM.dust(MT.Sand      , U   ), OM.dust(MT.Stone            ), OM.dust(MT.ClayBrown   ), IL.Clay_Ball_Brown .get(1), OP.dust.mat(MT.NaCl, 2));
		if (IL.BoP_Coarse_Loamy     .exists())  RM.Sifting.addRecipe1(T, 16, 144, new long[] { 4500,  3000,  1000,   400                                                        }, IL.BoP_Coarse_Loamy          .get( 1)/*|*/, OM.dust(MT.Sand      , U   ), OM.dust(MT.Stone            ), OM.dust(MT.Palygorskite), IL.Clay_Ball_Blue  .get(1));
		if (IL.BoP_Coarse_Silty     .exists())  RM.Sifting.addRecipe1(T, 16, 144, new long[] { 4500,  6000,   250,   100                                                        }, IL.BoP_Coarse_Silty          .get( 1)/*|*/, OM.dust(MT.Sand      , U   ), OM.dust(MT.STONES.Siltstone ), OM.dust(MT.Kaolinite   ), IL.Clay_Ball_White .get(1));
		if (IL.BoP_Coarse_Sandy     .exists())  RM.Sifting.addRecipe1(T, 16, 144, new long[] { 9000,  3000,   250,   100                                                        }, IL.BoP_Coarse_Sandy          .get( 1)/*|*/, OM.dust(MT.Sand      , U *2), OM.dust(MT.Stone            ), OM.dust(MT.Bentonite   ), IL.Clay_Ball_Yellow.get(1));
		if (IL.BoP_Dirt_Dried       .exists())  RM.Sifting.addRecipe1(T, 16, 144, new long[] { 9000,  2500,   250,   100                                                        }, IL.BoP_Dirt_Dried            .get( 1)/*|*/, OM.dust(MT.Sand      , U   ), OM.dust(MT.Stone            ), OM.dust(MT.Bentonite   ), IL.Clay_Ball_Yellow.get(1));
		if (IL.BoP_Dirt_Hard        .exists())  RM.Sifting.addRecipe1(T, 16, 144, new long[] { 9000,  2500,   250,   100                                                        }, IL.BoP_Dirt_Hard             .get( 1)/*|*/, OM.dust(MT.Sand      , U   ), OM.dust(MT.Stone            ), OM.dust(MT.Bentonite   ), IL.Clay_Ball_Yellow.get(1));
		/* Gravel                           */  RM.Sifting.addRecipe1(T, 16, 144, new long[] { 9000,  5000,  2500,   500,   200,  5000,   500,   100                            }, ST.make(Blocks.gravel        ,  1, W)/*|*/, OM.dust(MT.Sand      , U   ), OM.dust(MT.STONES.Deepslate ), rockGt.mat(MT.Stone            , 1), OM.dust(MT.Clay   ), ST.make(Items.clay_ball, 1, 0), ST.make(Items.flint, 1, 0), OM.dust(MT.MilkyQuartz , U4), OM.gem(MT.MilkyQuartz , U));
		if (IL.EtFu_Gravel          .exists())  RM.Sifting.addRecipe1(T, 16, 144, new long[] { 9000,  5000,  2500,   500,   200,  5000,   500,   100                            }, IL.EtFu_Gravel               .wild(1)/*|*/, OM.dust(MT.Sand      , U   ), OM.dust(MT.STONES.Deepslate ), rockGt.mat(MT.Stone            , 1), OM.dust(MT.Clay   ), ST.make(Items.clay_ball, 1, 0), ST.make(Items.flint, 1, 0), OM.dust(MT.MilkyQuartz , U4), OM.gem(MT.MilkyQuartz , U));
		if (IL.NeLi_Gravel          .exists())  RM.Sifting.addRecipe1(T, 16, 144, new long[] { 1000,  5000,  2500,   500,   200,  5000,   500,   100                            }, IL.NeLi_Gravel               .wild(1)/*|*/, OM.dust(MT.RedSand   , U   ), OM.dust(MT.STONES.Blackstone), rockGt.mat(MT.STONES.Blackstone, 1), OM.dust(MT.ClayRed), IL.Clay_Ball_Red       .get(1), ST.make(Items.flint, 1, 0), OM.dust(MT.NetherQuartz, U4), OM.gem(MT.NetherQuartz, U));
		/* Mud                              */  RM.Sifting.addRecipe1(T, 16, 144, new long[] { 9000,  2000                                                                      }, ST.make(BlocksGT.Diggables   ,  1, 0)/*|*/, ST.make(Blocks.dirt  , 1, 0), IL.MaCu_Bait_Worm.get(2));
		if (IL.BoP_Mud              .exists())  RM.Sifting.addRecipe1(T, 16, 144, new long[] { 9000,  2000                                                                      }, IL.BoP_Mud                    .get(1)/*|*/, ST.make(Blocks.dirt  , 1, 0), IL.MaCu_Bait_Worm.get(2));
		if (IL.ERE_Mud              .exists())  RM.Sifting.addRecipe1(T, 16, 144, new long[] { 9000,  2000                                                                      }, IL.ERE_Mud                    .get(1)/*|*/, ST.make(Blocks.dirt  , 1, 0), IL.MaCu_Bait_Worm.get(2));
		if (IL.BTL_Mud              .exists())  RM.Sifting.addRecipe1(T, 16, 144, new long[] { 9000,  2000                                                                      }, IL.BTL_Mud                    .get(1)/*|*/, ST.make(Blocks.dirt  , 1, 0), IL.MaCu_Bait_Worm.get(2));
		/* Misc                             */  RM.Sifting.addRecipe1(T, 16, 144, new long[] { 8000,  1000,   500,   500,   500                                                 }, ST.make(Blocks.dirt          ,  1, 2)/*|*/, ST.make(Blocks.dirt  , 1, 1), OM.dust(MT.Ash, U4), IL.MaCu_Bait_Ant.get(2), IL.MaCu_Bait_Maggot.get(1), IL.MaCu_Bait_Worm.get(1));
												RM.Sifting.addRecipe1(T, 16, 144, new long[] { 8000,  1000,  1000                                                               }, ST.make(Blocks.mycelium      ,  1, W)/*|*/, ST.make(Blocks.dirt  , 1, 1), ST.make(Blocks.brown_mushroom, 1, 0), ST.make(Blocks.red_mushroom, 1, 0));
												RM.Sifting.addRecipe1(T, 16, 144, new long[] { 1000,   500,    50,    50,    25,   250,   500,    50,    25                     }, OM.dust(MT.SoulSand                 )/*|*/, OM.dust(MT.Netherrack, U   ), rockGt.mat(MT.Netherrack, 1), OM.dust(MT.ClayRed, U   ), IL.Clay_Ball_Red.get(1), OM.dust(MT.Niter, U4  ), OM.dust(MT.NetherQuartz, U4  ), OP.gem.mat(MT.NetherQuartz, 1), ST.make(Items.bone, 1, 0), ST.make(Items.nether_wart, 1, 0));
												RM.Sifting.addRecipe1(T, 16, 144, new long[] { 1000,   500,    50,    50,    25,   250,   500,    50,    25                     }, ST.make(Blocks.soul_sand     ,  1, W)/*|*/, OM.dust(MT.Netherrack, U *9), rockGt.mat(MT.Netherrack, 9), OM.dust(MT.ClayRed, U *9), IL.Clay_Ball_Red.get(9), OM.dust(MT.Niter, U4*9), OM.dust(MT.NetherQuartz, U4*9), OP.gem.mat(MT.NetherQuartz, 9), ST.make(Items.bone, 9, 0), ST.make(Items.nether_wart, 9, 0));
		if (IL.NePl_SoulSoil        .exists())  RM.Sifting.addRecipe1(T, 16, 144, new long[] { 1000,   500,    50,    50,    25,   250,   500,    50,    25                     }, IL.NePl_SoulSoil             .wild(1)/*|*/, OM.dust(MT.Netherrack, U *9), rockGt.mat(MT.Netherrack, 9), OM.dust(MT.ClayRed, U *9), IL.Clay_Ball_Red.get(9), OM.dust(MT.Niter, U4*9), OM.dust(MT.NetherQuartz, U4*9), OP.gem.mat(MT.NetherQuartz, 9), ST.make(Items.bone, 9, 0), ST.make(Items.nether_wart, 9, 0));
		if (IL.NeLi_SoulSoil        .exists())  RM.Sifting.addRecipe1(T, 16, 144, new long[] { 1000,   500,    50,    50,    25,   250,   500,    50,    25                     }, IL.NeLi_SoulSoil             .wild(1)/*|*/, OM.dust(MT.Netherrack, U *9), rockGt.mat(MT.Netherrack, 9), OM.dust(MT.ClayRed, U *9), IL.Clay_Ball_Red.get(9), OM.dust(MT.Niter, U4*9), OM.dust(MT.NetherQuartz, U4*9), OP.gem.mat(MT.NetherQuartz, 9), ST.make(Items.bone, 9, 0), ST.make(Items.nether_wart, 9, 0));
		if (IL.AETHER_Sand          .exists())  RM.Sifting.addRecipe1(T, 16, 144, new long[] { 9000,  2000                                                                      }, IL.AETHER_Sand                .get(1)/*|*/, OM.dust(MT.Sand      , U *9), IL.MaCu_Bait_Ant.get(1));
		if (IL.BoP_Quicksand        .exists())  RM.Sifting.addRecipe1(T, 16, 144, new long[] { 9000,  2000                                                                      }, IL.BoP_Quicksand              .get(1)/*|*/, OM.dust(MT.Sand      , U *9), IL.MaCu_Bait_Ant.get(1));
		if (IL.BoP_Sand_Hard        .exists())  RM.Sifting.addRecipe1(T, 16, 144, new long[] {10000                                                                             }, IL.BoP_Sand_Hard              .get(1)/*|*/, OM.dust(MT.Sand      , U *9));
		
		
		
		
		RM.Sifting      .addRecipe1(T, 16,  144, new long[] {10000, 90, 360, 1350, 1800, 3600, 4500}, crushedPurified    .mat(MT.Asbestos           , 1), crushedCentrifugedTiny.mat(MT.Asbestos           , 9), gemExquisite.mat(MT.Jade  , 1), gemFlawless.mat(MT.Jade  , 1), gem.mat(MT.Jade  , 1), gemFlawed.mat(MT.Jade  , 2), gemChipped.mat(MT.Jade  , 4), dust.mat(MT.Jade  , 1));
		RM.Sifting      .addRecipe1(T, 16,   16, new long[] {10000, 10,  40,  150,  200,  400,  500}, crushedPurifiedTiny.mat(MT.Asbestos           , 1), crushedCentrifugedTiny.mat(MT.Asbestos           , 1), gemExquisite.mat(MT.Jade  , 1), gemFlawless.mat(MT.Jade  , 1), gem.mat(MT.Jade  , 1), gemFlawed.mat(MT.Jade  , 2), gemChipped.mat(MT.Jade  , 4), dust.mat(MT.Jade  , 1));
		RM.Sifting      .addRecipe1(T, 16,  144, new long[] {10000, 90, 360, 1350, 1800, 3600, 4500}, crushedPurified    .mat(MT.Sn                 , 1), crushedCentrifugedTiny.mat(MT.Sn                 , 9), gemExquisite.mat(MT.Zircon, 1), gemFlawless.mat(MT.Zircon, 1), gem.mat(MT.Zircon, 1), gemFlawed.mat(MT.Zircon, 2), gemChipped.mat(MT.Zircon, 4), dust.mat(MT.Zircon, 1));
		RM.Sifting      .addRecipe1(T, 16,   16, new long[] {10000, 10,  40,  150,  200,  400,  500}, crushedPurifiedTiny.mat(MT.Sn                 , 1), crushedCentrifugedTiny.mat(MT.Sn                 , 1), gemExquisite.mat(MT.Zircon, 1), gemFlawless.mat(MT.Zircon, 1), gem.mat(MT.Zircon, 1), gemFlawed.mat(MT.Zircon, 2), gemChipped.mat(MT.Zircon, 4), dust.mat(MT.Zircon, 1));
		RM.Sifting      .addRecipe1(T, 16,  144, new long[] {10000, 90, 360, 1350, 1800, 3600, 4500}, crushedPurified    .mat(MT.OREMATS.Cassiterite, 1), crushedCentrifugedTiny.mat(MT.OREMATS.Cassiterite, 9), gemExquisite.mat(MT.Zircon, 1), gemFlawless.mat(MT.Zircon, 1), gem.mat(MT.Zircon, 1), gemFlawed.mat(MT.Zircon, 2), gemChipped.mat(MT.Zircon, 4), dust.mat(MT.Zircon, 1));
		RM.Sifting      .addRecipe1(T, 16,   16, new long[] {10000, 10,  40,  150,  200,  400,  500}, crushedPurifiedTiny.mat(MT.OREMATS.Cassiterite, 1), crushedCentrifugedTiny.mat(MT.OREMATS.Cassiterite, 1), gemExquisite.mat(MT.Zircon, 1), gemFlawless.mat(MT.Zircon, 1), gem.mat(MT.Zircon, 1), gemFlawed.mat(MT.Zircon, 2), gemChipped.mat(MT.Zircon, 4), dust.mat(MT.Zircon, 1));
		
		
		RM.Sifting      .addRecipe1(T, 16,  144, new long[] {10000, 360, 3600, 3600, 3600, 3600, 3600, 3600, 3600, 3600, 3600, 3600}, crushedPurified    .mat(MT.Bone    , 1), crushedCentrifugedTiny.mat(MT.Bone    , 9), ST.make(Items.skull, 1, 0), ST.make(Items.bone, 1, 0), OP.dust.mat(MT.Bone, 1), ST.make(MD.UB, "fossilPiece", 1, 0, OP.dust.mat(MT.Bone, 1)), ST.make(MD.UB, "fossilPiece", 1, 1, OP.dust.mat(MT.Bone, 1)), ST.make(MD.UB, "fossilPiece", 1, 2, OP.dust.mat(MT.Bone, 1)), ST.make(MD.UB, "fossilPiece", 1, 3, OP.dust.mat(MT.Bone, 1)), ST.make(MD.UB, "fossilPiece", 1, 4, OP.dust.mat(MT.Bone, 1)), ST.make(MD.UB, "fossilPiece", 1, 5, OP.dust.mat(MT.Bone, 1)), ST.make(MD.UB, "fossilPiece", 1, 6, OP.dust.mat(MT.Bone, 1)), ST.make(MD.UB, "fossilPiece", 1, 7, OP.dust.mat(MT.Bone, 1)));
		RM.Sifting      .addRecipe1(T, 16,   16, new long[] {10000,  40,  400,  400,  400,  400,  400,  400,  400,  400,  400,  400}, crushedPurifiedTiny.mat(MT.Bone    , 1), crushedCentrifugedTiny.mat(MT.Bone    , 1), ST.make(Items.skull, 1, 0), ST.make(Items.bone, 1, 0), OP.dust.mat(MT.Bone, 1), ST.make(MD.UB, "fossilPiece", 1, 0, OP.dust.mat(MT.Bone, 1)), ST.make(MD.UB, "fossilPiece", 1, 1, OP.dust.mat(MT.Bone, 1)), ST.make(MD.UB, "fossilPiece", 1, 2, OP.dust.mat(MT.Bone, 1)), ST.make(MD.UB, "fossilPiece", 1, 3, OP.dust.mat(MT.Bone, 1)), ST.make(MD.UB, "fossilPiece", 1, 4, OP.dust.mat(MT.Bone, 1)), ST.make(MD.UB, "fossilPiece", 1, 5, OP.dust.mat(MT.Bone, 1)), ST.make(MD.UB, "fossilPiece", 1, 6, OP.dust.mat(MT.Bone, 1)), ST.make(MD.UB, "fossilPiece", 1, 7, OP.dust.mat(MT.Bone, 1)));
		RM.Sifting      .addRecipe1(T, 16,  144, new long[] {10000, 360, 3600, 3600, 3600, 3600, 3600, 3600, 3600, 3600, 3600, 3600}, crushedPurified    .mat(MT.Dolomite, 1), crushedCentrifugedTiny.mat(MT.Dolomite, 9), ST.make(Items.skull, 1, 0), ST.make(Items.bone, 1, 0), OP.dust.mat(MT.Bone, 1), ST.make(MD.UB, "fossilPiece", 1, 0, OP.dust.mat(MT.Bone, 1)), ST.make(MD.UB, "fossilPiece", 1, 1, OP.dust.mat(MT.Bone, 1)), ST.make(MD.UB, "fossilPiece", 1, 2, OP.dust.mat(MT.Bone, 1)), ST.make(MD.UB, "fossilPiece", 1, 3, OP.dust.mat(MT.Bone, 1)), ST.make(MD.UB, "fossilPiece", 1, 4, OP.dust.mat(MT.Bone, 1)), ST.make(MD.UB, "fossilPiece", 1, 5, OP.dust.mat(MT.Bone, 1)), ST.make(MD.UB, "fossilPiece", 1, 6, OP.dust.mat(MT.Bone, 1)), ST.make(MD.UB, "fossilPiece", 1, 7, OP.dust.mat(MT.Bone, 1)));
		RM.Sifting      .addRecipe1(T, 16,   16, new long[] {10000,  40,  400,  400,  400,  400,  400,  400,  400,  400,  400,  400}, crushedPurifiedTiny.mat(MT.Dolomite, 1), crushedCentrifugedTiny.mat(MT.Dolomite, 1), ST.make(Items.skull, 1, 0), ST.make(Items.bone, 1, 0), OP.dust.mat(MT.Bone, 1), ST.make(MD.UB, "fossilPiece", 1, 0, OP.dust.mat(MT.Bone, 1)), ST.make(MD.UB, "fossilPiece", 1, 1, OP.dust.mat(MT.Bone, 1)), ST.make(MD.UB, "fossilPiece", 1, 2, OP.dust.mat(MT.Bone, 1)), ST.make(MD.UB, "fossilPiece", 1, 3, OP.dust.mat(MT.Bone, 1)), ST.make(MD.UB, "fossilPiece", 1, 4, OP.dust.mat(MT.Bone, 1)), ST.make(MD.UB, "fossilPiece", 1, 5, OP.dust.mat(MT.Bone, 1)), ST.make(MD.UB, "fossilPiece", 1, 6, OP.dust.mat(MT.Bone, 1)), ST.make(MD.UB, "fossilPiece", 1, 7, OP.dust.mat(MT.Bone, 1)));
		
		
		RM.Sifting      .addRecipe1(T, 16,  144, new long[] {7200,  900, 5000, 5000, 5000, 5000, 5000, 5000, 5000, 5000, 5000}, crushedPurified    .mat(MT.ChargedCertusQuartz, 1), gem.mat(MT.ChargedCertusQuartz, 1), gem.mat(MT.CertusQuartz, 1), dustTiny.mat(MT.CertusQuartz, 1), dustTiny.mat(MT.CertusQuartz, 1), dustTiny.mat(MT.CertusQuartz, 1), dustTiny.mat(MT.CertusQuartz, 1), dustTiny.mat(MT.CertusQuartz, 1), dustTiny.mat(MT.CertusQuartz, 1), dustTiny.mat(MT.CertusQuartz, 1), dustTiny.mat(MT.CertusQuartz, 1), dustTiny.mat(MT.CertusQuartz, 1));
		RM.Sifting      .addRecipe1(T, 16,   16, new long[] { 800,  100, 5000, 5000, 5000, 5000, 5000, 5000, 5000, 5000, 5000}, crushedPurifiedTiny.mat(MT.ChargedCertusQuartz, 1), gem.mat(MT.ChargedCertusQuartz, 1), gem.mat(MT.CertusQuartz, 1), dustTiny.mat(MT.CertusQuartz, 1)                                                                                                                                                                                                                                                                                );
		RM.Sifting      .addRecipe1(T, 16,  144, new long[] { 900, 7200, 5000, 5000, 5000, 5000, 5000, 5000, 5000, 5000, 5000}, crushedPurified    .mat(MT.CertusQuartz       , 1), gem.mat(MT.ChargedCertusQuartz, 1), gem.mat(MT.CertusQuartz, 1), dustTiny.mat(MT.CertusQuartz, 1), dustTiny.mat(MT.CertusQuartz, 1), dustTiny.mat(MT.CertusQuartz, 1), dustTiny.mat(MT.CertusQuartz, 1), dustTiny.mat(MT.CertusQuartz, 1), dustTiny.mat(MT.CertusQuartz, 1), dustTiny.mat(MT.CertusQuartz, 1), dustTiny.mat(MT.CertusQuartz, 1), dustTiny.mat(MT.CertusQuartz, 1));
		RM.Sifting      .addRecipe1(T, 16,   16, new long[] { 100,  800, 5000, 5000, 5000, 5000, 5000, 5000, 5000, 5000, 5000}, crushedPurifiedTiny.mat(MT.CertusQuartz       , 1), gem.mat(MT.ChargedCertusQuartz, 1), gem.mat(MT.CertusQuartz, 1), dustTiny.mat(MT.CertusQuartz, 1)                                                                                                                                                                                                                                                                                );
		RM.Sifting      .addRecipe1(T, 16,  144, new long[] {      7200, 5000, 5000, 5000, 5000, 5000, 5000, 5000, 5000, 5000}, crushedPurified    .mat(MT.NetherQuartz       , 1), gem.mat(MT.NetherQuartz       , 1)                             , dustTiny.mat(MT.NetherQuartz, 1), dustTiny.mat(MT.NetherQuartz, 1), dustTiny.mat(MT.NetherQuartz, 1), dustTiny.mat(MT.NetherQuartz, 1), dustTiny.mat(MT.NetherQuartz, 1), dustTiny.mat(MT.NetherQuartz, 1), dustTiny.mat(MT.NetherQuartz, 1), dustTiny.mat(MT.NetherQuartz, 1), dustTiny.mat(MT.NetherQuartz, 1));
		RM.Sifting      .addRecipe1(T, 16,   16, new long[] {       800, 5000, 5000, 5000, 5000, 5000, 5000, 5000, 5000, 5000}, crushedPurifiedTiny.mat(MT.NetherQuartz       , 1), gem.mat(MT.NetherQuartz       , 1)                             , dustTiny.mat(MT.NetherQuartz, 1)                                                                                                                                                                                                                                                                                );
		RM.Sifting      .addRecipe1(T, 16,  144, new long[] {      7200, 5000, 5000, 5000, 5000, 5000, 5000, 5000, 5000, 5000}, crushedPurified    .mat(MT.VoidQuartz         , 1), gem.mat(MT.VoidQuartz         , 1)                             , dustTiny.mat(MT.VoidQuartz  , 1), dustTiny.mat(MT.VoidQuartz  , 1), dustTiny.mat(MT.VoidQuartz  , 1), dustTiny.mat(MT.VoidQuartz  , 1), dustTiny.mat(MT.VoidQuartz  , 1), dustTiny.mat(MT.VoidQuartz  , 1), dustTiny.mat(MT.VoidQuartz  , 1), dustTiny.mat(MT.VoidQuartz  , 1), dustTiny.mat(MT.VoidQuartz  , 1));
		RM.Sifting      .addRecipe1(T, 16,   16, new long[] {       800, 5000, 5000, 5000, 5000, 5000, 5000, 5000, 5000, 5000}, crushedPurifiedTiny.mat(MT.VoidQuartz         , 1), gem.mat(MT.VoidQuartz         , 1)                             , dustTiny.mat(MT.VoidQuartz  , 1)                                                                                                                                                                                                                                                                                );
		RM.Sifting      .addRecipe1(T, 16,  144, new long[] {      7200, 5000, 5000, 5000, 5000, 5000, 5000, 5000, 5000, 5000}, crushedPurified    .mat(MT.MilkyQuartz        , 1), gem.mat(MT.MilkyQuartz        , 1)                             , dustTiny.mat(MT.MilkyQuartz , 1), dustTiny.mat(MT.MilkyQuartz , 1), dustTiny.mat(MT.MilkyQuartz , 1), dustTiny.mat(MT.MilkyQuartz , 1), dustTiny.mat(MT.MilkyQuartz , 1), dustTiny.mat(MT.MilkyQuartz , 1), dustTiny.mat(MT.MilkyQuartz , 1), dustTiny.mat(MT.MilkyQuartz , 1), dustTiny.mat(MT.MilkyQuartz , 1));
		RM.Sifting      .addRecipe1(T, 16,   16, new long[] {       800, 5000, 5000, 5000, 5000, 5000, 5000, 5000, 5000, 5000}, crushedPurifiedTiny.mat(MT.MilkyQuartz        , 1), gem.mat(MT.MilkyQuartz        , 1)                             , dustTiny.mat(MT.MilkyQuartz , 1)                                                                                                                                                                                                                                                                                );
		RM.Sifting      .addRecipe1(T, 16,  144, new long[] {      7200, 5000, 5000, 5000, 5000, 5000, 5000, 5000, 5000, 5000}, crushedPurified    .mat(MT.Fluix              , 1), gem.mat(MT.Fluix              , 1)                             , dustTiny.mat(MT.Fluix       , 1), dustTiny.mat(MT.Fluix       , 1), dustTiny.mat(MT.Fluix       , 1), dustTiny.mat(MT.Fluix       , 1), dustTiny.mat(MT.Fluix       , 1), dustTiny.mat(MT.Fluix       , 1), dustTiny.mat(MT.Fluix       , 1), dustTiny.mat(MT.Fluix       , 1), dustTiny.mat(MT.Fluix       , 1));
		RM.Sifting      .addRecipe1(T, 16,   16, new long[] {       800, 5000, 5000, 5000, 5000, 5000, 5000, 5000, 5000, 5000}, crushedPurifiedTiny.mat(MT.Fluix              , 1), gem.mat(MT.Fluix              , 1)                             , dustTiny.mat(MT.Fluix       , 1)                                                                                                                                                                                                                                                                                );
		
		
		RM.Sifting          .addRecipe1(T, 16,  144, new long[] {7500, 5000, 2500, 2500, 2500}, ST.make(BlocksGT.Sands  , 1, 0), dust.mat(MT.STONES.Deepslate   , 3), dust.mat(MT.RedSand, 3), nugget  .mat(MT.Mn  , 6), nugget  .mat(MT.Sn,12), nugget  .mat(MT.Zn, 3));
		RM.MagneticSeparator.addRecipe1(T, 16,  144, new long[] {7500, 5000, 2500, 2500, 2500}, ST.make(BlocksGT.Sands  , 1, 0), dust.mat(MT.STONES.Deepslate   , 3), dust.mat(MT.RedSand, 6), dustTiny.mat(MT.Mn  ,12), dustTiny.mat(MT.Sn, 6), dustTiny.mat(MT.Zn, 6));
		RM.Centrifuge       .addRecipe1(T, 16,  288, new long[] {7500, 5000, 2500, 2500, 2500}, ST.make(BlocksGT.Sands  , 1, 0), dust.mat(MT.STONES.Deepslate   , 6), dust.mat(MT.RedSand, 3), dustTiny.mat(MT.V2O5,12), dustTiny.mat(MT.Sn, 6), dustTiny.mat(MT.Zn, 3));
		RM.Sifting          .addRecipe1(T, 16,  144, new long[] {7500, 5000, 2500, 2500, 2500}, ST.make(BlocksGT.Sands  , 1, 1), dust.mat(MT.STONES.Gabbro      , 3), dust.mat(MT.RedSand, 3), nugget  .mat(MT.Au  , 6), nugget  .mat(MT.Cu,12), nugget  .mat(MT.Ni, 3));
		RM.MagneticSeparator.addRecipe1(T, 16,  144, new long[] {7500, 5000, 2500, 2500, 2500}, ST.make(BlocksGT.Sands  , 1, 1), dust.mat(MT.STONES.Gabbro      , 3), dust.mat(MT.RedSand, 6), dustTiny.mat(MT.Au  ,12), dustTiny.mat(MT.Cu, 6), dustTiny.mat(MT.Ni, 6));
		RM.Centrifuge       .addRecipe1(T, 16,  288, new long[] {7500, 5000, 2500, 2500, 2500}, ST.make(BlocksGT.Sands  , 1, 1), dust.mat(MT.STONES.Gabbro      , 6), dust.mat(MT.RedSand, 3), dustTiny.mat(MT.V2O5,12), dustTiny.mat(MT.Cu, 6), dustTiny.mat(MT.Ni, 3));
		RM.Sifting          .addRecipe1(T, 16,  144, new long[] {7500, 5000, 2500, 2500, 2500}, ST.make(BlocksGT.Sands  , 1, 2), dust.mat(MT.STONES.GraniteBlack, 3), dust.mat(MT.RedSand, 3), nugget  .mat(MT.Ag  , 6), nugget  .mat(MT.Pb,12), nugget  .mat(MT.Co, 3));
		RM.MagneticSeparator.addRecipe1(T, 16,  144, new long[] {7500, 5000, 2500, 2500, 2500}, ST.make(BlocksGT.Sands  , 1, 2), dust.mat(MT.STONES.GraniteBlack, 3), dust.mat(MT.RedSand, 6), dustTiny.mat(MT.Ag  ,12), dustTiny.mat(MT.Pb, 6), dustTiny.mat(MT.Co, 6));
		RM.Centrifuge       .addRecipe1(T, 16,  288, new long[] {7500, 5000, 2500, 2500, 2500}, ST.make(BlocksGT.Sands  , 1, 2), dust.mat(MT.STONES.GraniteBlack, 6), dust.mat(MT.RedSand, 3), dustTiny.mat(MT.V2O5,12), dustTiny.mat(MT.Pb, 6), dustTiny.mat(MT.Co, 3));
		if (IL.PFAA_Sands.exists()) {
		RM.Sifting          .addRecipe1(T, 16,  144, new long[] {7500, 5000, 2500, 2500, 2500}, IL.PFAA_Sands.getWithMeta(1, 0), dust.mat(MT.STONES.Basalt      , 4), dust.mat(MT.RedSand, 4), nugget  .mat(MT.Au  , 8), nugget  .mat(MT.Cu,16), nugget  .mat(MT.Ni, 4));
		RM.MagneticSeparator.addRecipe1(T, 16,  144, new long[] {7500, 5000, 2500, 2500, 2500}, IL.PFAA_Sands.getWithMeta(1, 0), dust.mat(MT.STONES.Basalt      , 4), dust.mat(MT.RedSand, 8), dustTiny.mat(MT.Au  ,16), dustTiny.mat(MT.Cu, 8), dustTiny.mat(MT.Ni, 8));
		RM.Centrifuge       .addRecipe1(T, 16,  288, new long[] {7500, 5000, 2500, 2500, 2500}, IL.PFAA_Sands.getWithMeta(1, 0), dust.mat(MT.STONES.Basalt      , 8), dust.mat(MT.RedSand, 4), dustTiny.mat(MT.V2O5,16), dustTiny.mat(MT.Cu, 8), dustTiny.mat(MT.Ni, 4));
		RM.Sifting          .addRecipe1(T, 16,  144, new long[] {7500, 5000, 2500, 2500, 2500}, IL.PFAA_Sands.getWithMeta(1, 3), dust.mat(MT.STONES.Granite     , 4), dust.mat(MT.RedSand, 4), nugget  .mat(MT.Ag  , 8), nugget  .mat(MT.Pb,16), nugget  .mat(MT.Co, 4));
		RM.MagneticSeparator.addRecipe1(T, 16,  144, new long[] {7500, 5000, 2500, 2500, 2500}, IL.PFAA_Sands.getWithMeta(1, 3), dust.mat(MT.STONES.Granite     , 4), dust.mat(MT.RedSand, 8), dustTiny.mat(MT.Ag  ,16), dustTiny.mat(MT.Pb, 8), dustTiny.mat(MT.Co, 8));
		RM.Centrifuge       .addRecipe1(T, 16,  288, new long[] {7500, 5000, 2500, 2500, 2500}, IL.PFAA_Sands.getWithMeta(1, 3), dust.mat(MT.STONES.Granite     , 8), dust.mat(MT.RedSand, 4), dustTiny.mat(MT.V2O5,16), dustTiny.mat(MT.Pb, 8), dustTiny.mat(MT.Co, 4));
		} if (IL.TROPIC_Sand_Black.exists()) {
		RM.Sifting          .addRecipe1(T, 16,  144, new long[] {7500, 5000, 2500, 2500, 2500}, IL.TROPIC_Sand_Black    .get(1), dust.mat(MT.STONES.Basalt      , 3), dust.mat(MT.RedSand, 3), nugget  .mat(MT.Au  , 6), nugget  .mat(MT.Cu,12), nugget  .mat(MT.Ni, 3));
		RM.MagneticSeparator.addRecipe1(T, 16,  144, new long[] {7500, 5000, 2500, 2500, 2500}, IL.TROPIC_Sand_Black    .get(1), dust.mat(MT.STONES.Basalt      , 3), dust.mat(MT.RedSand, 6), dustTiny.mat(MT.Au  ,12), dustTiny.mat(MT.Cu, 6), dustTiny.mat(MT.Ni, 6));
		RM.Centrifuge       .addRecipe1(T, 16,  288, new long[] {7500, 5000, 2500, 2500, 2500}, IL.TROPIC_Sand_Black    .get(1), dust.mat(MT.STONES.Basalt      , 6), dust.mat(MT.RedSand, 3), dustTiny.mat(MT.V2O5,12), dustTiny.mat(MT.Cu, 6), dustTiny.mat(MT.Ni, 3));
		}
		
		RM.Smelter      .addRecipe1(T, 64, 1440, 5000, OM.dust(MT.Monazite     ), NF, MT.He.gas(U2 , F), OM.dust(MT.RareEarth     ));
		RM.Smelter      .addRecipe1(T, 64,  360, 5000, OM.dust(MT.Monazite,  U4), NF, MT.He.gas(U8 , F), OM.dust(MT.RareEarth,  U4));
		RM.Smelter      .addRecipe1(T, 64,  160, 5000, OM.dust(MT.Monazite,  U9), NF, MT.He.gas(U18, F), OM.dust(MT.RareEarth,  U9));
		
		
		RM.Lightning    .addRecipe2(T,512, 2304, new long[] {8000}, ST.tag(1), crushedPurified       .mat(MT.Dolamide , 1), crushedCentrifugedTiny.mat(MT.Dolamide ,18));
		RM.Lightning    .addRecipe2(T,512,  256, new long[] {8000}, ST.tag(1), crushedPurifiedTiny   .mat(MT.Dolamide , 1), crushedCentrifugedTiny.mat(MT.Dolamide , 2));
		RM.Nanofab      .addRecipe2(T, 64, 2048                   , ST.tag(0), crushedCentrifuged    .mat(MT.Dolamide , 1), gem.mat(MT.Dilithium, 2));
		RM.Nanofab      .addRecipe2(T, 64, 2048                   , ST.tag(0), crushedCentrifugedTiny.mat(MT.Dolamide , 9), gem.mat(MT.Dilithium, 2));
		RM.Nanofab      .addRecipe2(T,512, 2048                   , ST.tag(0), dust                  .mat(MT.Dolamide , 2), gem.mat(MT.Dilithium, 1)); // Maybe don't just turn everything you see into Dust ;)
		RM.Nanofab      .addRecipe2(T,512, 4096                   , ST.tag(0), dust                  .mat(MT.Dilithium, 2), gem.mat(MT.Dilithium, 1)); // Maybe don't just turn everything you see into Dust ;)
		
		
		RM.Mixer        .addRecipe2(T, 16,  256, crushedPurified    .mat(MT.Yellorite, 1), dust.mat(MT.Al, 1), crushedCentrifuged.mat(MT.Yellorium, 1));
		RM.Mixer        .addRecipe2(T, 16,  256, crushedPurifiedTiny.mat(MT.Yellorite, 9), dust.mat(MT.Al, 1), crushedCentrifuged.mat(MT.Yellorium, 1));
		RM.Mixer        .addRecipe2(T, 16,  256, crushedPurified    .mat(MT.Yellorite, 1), dust.mat(MT.Mg, 1), crushedCentrifuged.mat(MT.Yellorium, 1));
		RM.Mixer        .addRecipe2(T, 16,  256, crushedPurifiedTiny.mat(MT.Yellorite, 9), dust.mat(MT.Mg, 1), crushedCentrifuged.mat(MT.Yellorium, 1));
		RM.Mixer        .addRecipe2(T, 16,  256, crushedPurified    .mat(MT.U_238    , 1), dust.mat(MT.Al, 1), crushedCentrifugedTiny.mat(MT.U_238, 12));
		RM.Mixer        .addRecipe2(T, 16,  256, crushedPurifiedTiny.mat(MT.U_238    , 9), dust.mat(MT.Al, 1), crushedCentrifugedTiny.mat(MT.U_238, 12));
		RM.Mixer        .addRecipe2(T, 16,  256, crushedPurified    .mat(MT.U_238    , 1), dust.mat(MT.Mg, 1), crushedCentrifugedTiny.mat(MT.U_238, 12));
		RM.Mixer        .addRecipe2(T, 16,  256, crushedPurifiedTiny.mat(MT.U_238    , 9), dust.mat(MT.Mg, 1), crushedCentrifugedTiny.mat(MT.U_238, 12));
		RM.Mixer        .addRecipe2(T, 16,  256, crushedPurified    .mat(MT.U_235    , 1), dust.mat(MT.Al, 1), crushedCentrifugedTiny.mat(MT.U_235, 12));
		RM.Mixer        .addRecipe2(T, 16,  256, crushedPurifiedTiny.mat(MT.U_235    , 9), dust.mat(MT.Al, 1), crushedCentrifugedTiny.mat(MT.U_235, 12));
		RM.Mixer        .addRecipe2(T, 16,  256, crushedPurified    .mat(MT.U_235    , 1), dust.mat(MT.Mg, 1), crushedCentrifugedTiny.mat(MT.U_235, 12));
		RM.Mixer        .addRecipe2(T, 16,  256, crushedPurifiedTiny.mat(MT.U_235    , 9), dust.mat(MT.Mg, 1), crushedCentrifugedTiny.mat(MT.U_235, 12));
		
		
		RM.Centrifuge   .addRecipe1(T, 256, 256, new long[] {10000,  150,  150}, crushedCentrifugedTiny.mat(MT.Be       , 1), dustTiny.mat(MT.Be       , 1), dustTiny.mat(MT.Be_7     , 8), dustTiny.mat(MT.Be_8, 8));
		RM.Centrifuge   .addRecipe1(T, 256,2304, new long[] {10000, 1350, 1350}, crushedCentrifuged    .mat(MT.Be       , 1), dust    .mat(MT.Be       , 1), dustTiny.mat(MT.Be_7     , 8), dustTiny.mat(MT.Be_8, 8));
		RM.Centrifuge   .addRecipe1(T, 256, 256, new long[] {10000,  300      }, crushedCentrifugedTiny.mat(MT.Li       , 1), dustTiny.mat(MT.Li       , 1), dustTiny.mat(MT.Li_6     , 8));
		RM.Centrifuge   .addRecipe1(T, 256,2304, new long[] {10000, 2700      }, crushedCentrifuged    .mat(MT.Li       , 1), dust    .mat(MT.Li       , 1), dustTiny.mat(MT.Li_6     , 8));
		RM.Centrifuge   .addRecipe1(T, 256, 256, new long[] {10000,  300      }, crushedCentrifugedTiny.mat(MT.B        , 1), dustTiny.mat(MT.B        , 1), dustTiny.mat(MT.B_11     , 8));
		RM.Centrifuge   .addRecipe1(T, 256,2304, new long[] {10000, 2700      }, crushedCentrifuged    .mat(MT.B        , 1), dust    .mat(MT.B        , 1), dustTiny.mat(MT.B_11     , 8));
		RM.Centrifuge   .addRecipe1(T, 256, 256, new long[] {10000,  150,  150}, crushedCentrifugedTiny.mat(MT.C        , 1), dustTiny.mat(MT.C        , 1), dustTiny.mat(MT.C_13     , 8), dustTiny.mat(MT.C_14, 8));
		RM.Centrifuge   .addRecipe1(T, 256,2304, new long[] {10000, 1350, 1350}, crushedCentrifuged    .mat(MT.C        , 1), dust    .mat(MT.C        , 1), dustTiny.mat(MT.C_13     , 8), dustTiny.mat(MT.C_14, 8));
		RM.Centrifuge   .addRecipe1(T, 512, 256, new long[] {10000,  300      }, crushedCentrifugedTiny.mat(MT.Co       , 1), dustTiny.mat(MT.Co       , 1), dustTiny.mat(MT.Co_60    , 8));
		RM.Centrifuge   .addRecipe1(T, 512,2304, new long[] {10000, 2700      }, crushedCentrifuged    .mat(MT.Co       , 1), dust    .mat(MT.Co       , 1), dustTiny.mat(MT.Co_60    , 8));
		if (ConfigsGT.GREGTECH.get("general", "EasyU235Extraction", F)) {
		RM.Centrifuge   .addRecipe1(T,1024, 256, new long[] {10000,  200,  100}, crushedCentrifugedTiny.mat(MT.U_238    , 1), dustTiny.mat(MT.U_238    , 1), dustTiny.mat(MT.U_235    , 8), dustTiny.mat(MT.U_233, 8));
		RM.Centrifuge   .addRecipe1(T,1024,2304, new long[] {10000, 1800,  900}, crushedCentrifuged    .mat(MT.U_238    , 1), dust    .mat(MT.U_238    , 1), dustTiny.mat(MT.U_235    , 8), dustTiny.mat(MT.U_233, 8));
		}
		RM.Centrifuge   .addRecipe1(T,1024, 256, new long[] {10000,  150,  150}, crushedCentrifugedTiny.mat(MT.Pu       , 1), dustTiny.mat(MT.Pu       , 1), dustTiny.mat(MT.Pu_241   , 8), dustTiny.mat(MT.Pu_243, 8));
		RM.Centrifuge   .addRecipe1(T,1024,2304, new long[] {10000, 1350, 1350}, crushedCentrifuged    .mat(MT.Pu       , 1), dust    .mat(MT.Pu       , 1), dustTiny.mat(MT.Pu_241   , 8), dustTiny.mat(MT.Pu_243, 8));
		RM.Centrifuge   .addRecipe1(T,1024, 256, new long[] {10000,  300      }, crushedCentrifugedTiny.mat(MT.Am       , 1), dustTiny.mat(MT.Am       , 1), dustTiny.mat(MT.Am_241   , 8));
		RM.Centrifuge   .addRecipe1(T,1024,2304, new long[] {10000, 2700      }, crushedCentrifuged    .mat(MT.Am       , 1), dust    .mat(MT.Am       , 1), dustTiny.mat(MT.Am_241   , 8));
		RM.Centrifuge   .addRecipe1(T,1536, 256, new long[] {10000,  300      }, crushedCentrifugedTiny.mat(MT.Fl       , 1), dustTiny.mat(MT.Fl       , 1), dustTiny.mat(MT.Fl_298   , 8));
		RM.Centrifuge   .addRecipe1(T,1536,2304, new long[] {10000, 2700      }, crushedCentrifuged    .mat(MT.Fl       , 1), dust    .mat(MT.Fl       , 1), dustTiny.mat(MT.Fl_298   , 8));
		
		
		final long[] tSluice = {10000, 300, 300, 300, 300, 300, 300, 300, 300}, tMagnet = {10000, 600, 600, 600, 600, 600}, tCentrifuge = {10000, 1000, 1000, 1000};
		
		for (OreDictMaterial aMat : OreDictMaterial.MATERIAL_ARRAY) if (aMat != null && !aMat.contains(ANTIMATTER) && aMat != MT.Bedrock) {
			ItemStack tDust = dust.mat(aMat, 1);
			if (ST.invalid(tDust)) continue;
			
			ArrayListNoNulls<OreDictMaterial> tMagnetList = new ArrayListNoNulls<>();
			if (aMat.containsAny(MAGNETIC_PASSIVE, MAGNETIC_ACTIVE)) {
				for (OreDictMaterial tMaterial : aMat.mByProducts) if (!tMaterial.containsAny(MAGNETIC_PASSIVE, MAGNETIC_ACTIVE)) tMagnetList.add(tMaterial);
			} else {
				for (OreDictMaterial tMaterial : aMat.mByProducts) if ( tMaterial.containsAny(MAGNETIC_PASSIVE, MAGNETIC_ACTIVE)) tMagnetList.add(tMaterial);
			}
			
			ItemStack tCrushed = crushed.mat(aMat, 1), tCrushedTiny = crushedTiny.mat(aMat, 1);
			if (ST.valid(tCrushed) && ST.valid(tCrushedTiny)) {
				ItemStack tByProductMercury = null, tByproductPersulfate = null, tByproductFirestone = null;
				for (OreDictMaterial tByProduct : aMat.mByProducts) if (tByProduct.contains(WASHING_MERCURY   ) && ST.valid(tByProductMercury    = OM.crushedPurifiedTiny(tByProduct, 1))) break;
				if (ST.invalid(tByProductMercury)                          && aMat.contains(WASHING_MERCURY   ))            tByProductMercury    = OM.crushedPurifiedTiny(aMat      , 1);
				for (OreDictMaterial tByProduct : aMat.mByProducts) if (tByProduct.contains(WASHING_PERSULFATE) && ST.valid(tByproductPersulfate = OM.crushedPurifiedTiny(tByProduct, 1))) break;
				if (ST.invalid(tByproductPersulfate)                       && aMat.contains(WASHING_PERSULFATE))            tByproductPersulfate = OM.crushedPurifiedTiny(aMat      , 1);
				for (OreDictMaterial tByProduct : aMat.mByProducts) if (tByProduct.contains(WASHING_FIRESTONE ) && ST.valid(tByproductFirestone  = OM.crushedPurifiedTiny(tByProduct, 1))) break;
				if (ST.invalid(tByproductFirestone)                        && aMat.contains(WASHING_FIRESTONE ))            tByproductFirestone  = OM.crushedPurifiedTiny(aMat      , 1);
				
				if (ENABLE_ADDING_IC2_OREWASHER_RECIPES) {
				RM.ic2_orewasher(tCrushed                  , 1000                                         , OM.crushedPurified(aMat, 1), OM.crushedPurifiedTiny(UT.Code.select(0, aMat, aMat.mByProducts), 2), dust.mat(MT.Stone, 1));
				RM.ic2_orewasher(ST.amount(9,tCrushedTiny) , 1000                                         , OM.crushedPurified(aMat, 1), OM.crushedPurifiedTiny(UT.Code.select(0, aMat, aMat.mByProducts), 2), dust.mat(MT.Stone, 1));
				}
				if (ENABLE_ADDING_IC2_CENTRIFUGE_RECIPES) {
				RM.ic2_centrifuge(tCrushed                 , Math.min(5000, Math.abs(aMat.getMass() * 20)), OM.crushedCentrifuged(aMat, 1), OM.crushedCentrifugedTiny(UT.Code.select(1, aMat, aMat.mByProducts), 1), dust.mat(MT.Stone, 1));
				RM.ic2_centrifuge(ST.amount(9,tCrushedTiny), Math.min(5000, Math.abs(aMat.getMass() * 20)), OM.crushedCentrifuged(aMat, 1), OM.crushedCentrifugedTiny(UT.Code.select(1, aMat, aMat.mByProducts), 1), dust.mat(MT.Stone, 1));
				}
				
				OreDictMaterial[] tSluiceProducts = new OreDictMaterial[8];
				for (int i = 0; i < tSluiceProducts.length; i++) tSluiceProducts[i] = (i < aMat.mByProducts.size() ? aMat.mByProducts.get(i) : aMat);
				for (FluidStack tWater : FL.waters(900))
				RM.Sluice.addRecipe1(T, T, F, F, T, 16, 144, tSluice, tCrushed     , tWater, FL.Sluice.make(900), OM.crushedPurified    (aMat, 1), OM.crushedPurifiedTiny(tSluiceProducts[0], 9), OM.crushedPurifiedTiny(tSluiceProducts[1], 9), OM.crushedPurifiedTiny(tSluiceProducts[2], 9), OM.crushedPurifiedTiny(tSluiceProducts[3], 9), OM.crushedPurifiedTiny(tSluiceProducts[4], 9), OM.crushedPurifiedTiny(tSluiceProducts[5], 9), OM.crushedPurifiedTiny(tSluiceProducts[6], 9), OM.crushedPurifiedTiny(tSluiceProducts[7], 9));
				for (FluidStack tWater : FL.waters(100))
				RM.Sluice.addRecipe1(T, T, F, F, T, 16,  16, tSluice, tCrushedTiny , tWater, FL.Sluice.make(100), OM.crushedPurifiedTiny(aMat, 1), OM.crushedPurifiedTiny(tSluiceProducts[0], 1), OM.crushedPurifiedTiny(tSluiceProducts[1], 1), OM.crushedPurifiedTiny(tSluiceProducts[2], 1), OM.crushedPurifiedTiny(tSluiceProducts[3], 1), OM.crushedPurifiedTiny(tSluiceProducts[4], 1), OM.crushedPurifiedTiny(tSluiceProducts[5], 1), OM.crushedPurifiedTiny(tSluiceProducts[6], 1), OM.crushedPurifiedTiny(tSluiceProducts[7], 1));
				
				if (tByProductMercury != null) {
				RM.Bath.addRecipe1(T, 0, 144, tCrushed    , MT.Hg.liquid(U , T), NF, OM.crushedPurified    (aMat, 1), ST.mul_(2, tByProductMercury), ST.mul_(2, tByProductMercury), ST.mul_(2, tByProductMercury), ST.mul_(2, tByProductMercury), tByProductMercury);
				RM.Bath.addRecipe1(T, 0,  16, tCrushedTiny, MT.Hg.liquid(U9, T), NF, OM.crushedPurifiedTiny(aMat, 1), tByProductMercury);
				}
				
				if (tByproductPersulfate != null) for (OreDictMaterial tPersulfate : new OreDictMaterial[] {MT.NaSO4, MT.KSO4}) {
				for (FluidStack tWater : FL.waters(900)) {
				RM.Bath.addRecipe2(T, T, F, F, T, 0, 144, tCrushed                 , OP.dust    .mat(tPersulfate, 1), tWater, NF, OM.crushedPurified    (aMat, 1), ST.mul_(2, tByproductPersulfate), ST.mul_(2, tByproductPersulfate), ST.mul_(2, tByproductPersulfate), ST.mul_(2, tByproductPersulfate), tByproductPersulfate);
				RM.Bath.addRecipe2(T, T, F, F, T, 0, 144, ST.amount(9,tCrushedTiny), OP.dust    .mat(tPersulfate, 1), tWater, NF, OM.crushedPurified    (aMat, 1), ST.mul_(2, tByproductPersulfate), ST.mul_(2, tByproductPersulfate), ST.mul_(2, tByproductPersulfate), ST.mul_(2, tByproductPersulfate), tByproductPersulfate);
				RM.Bath.addRecipe2(T, T, F, F, T, 0, 144, tCrushed                 , OP.dustTiny.mat(tPersulfate, 9), tWater, NF, OM.crushedPurified    (aMat, 1), ST.mul_(2, tByproductPersulfate), ST.mul_(2, tByproductPersulfate), ST.mul_(2, tByproductPersulfate), ST.mul_(2, tByproductPersulfate), tByproductPersulfate);
				}
				for (FluidStack tWater : FL.waters(100))
				RM.Bath.addRecipe2(T, T, F, F, T, 0,  16, tCrushedTiny             , OP.dustTiny.mat(tPersulfate, 1), tWater, NF, OM.crushedPurifiedTiny(aMat, 1), tByproductPersulfate);
				}
				
				if (tByproductFirestone != null) for (OreDictMaterial tFirestone : new OreDictMaterial[] {MT.Firestone, MT.Pyrotheum, MT.Octine}) {
				for (FluidStack tWater : FL.waters(900)) {
				RM.Bath.addRecipe2(T, T, F, F, T, 0, 144, tCrushed                 , OP.dust    .mat(tFirestone , 1), tWater, FL.Steam.make(900*STEAM_PER_WATER), OM.crushedPurified    (aMat, 1), ST.mul_(2, tByproductFirestone), ST.mul_(2, tByproductFirestone), ST.mul_(2, tByproductFirestone), ST.mul_(2, tByproductFirestone), tByproductFirestone);
				RM.Bath.addRecipe2(T, T, F, F, T, 0, 144, ST.amount(9,tCrushedTiny), OP.dust    .mat(tFirestone , 1), tWater, FL.Steam.make(900*STEAM_PER_WATER), OM.crushedPurified    (aMat, 1), ST.mul_(2, tByproductFirestone), ST.mul_(2, tByproductFirestone), ST.mul_(2, tByproductFirestone), ST.mul_(2, tByproductFirestone), tByproductFirestone);
				RM.Bath.addRecipe2(T, T, F, F, T, 0, 144, tCrushed                 , OP.dustTiny.mat(tFirestone , 9), tWater, FL.Steam.make(900*STEAM_PER_WATER), OM.crushedPurified    (aMat, 1), ST.mul_(2, tByproductFirestone), ST.mul_(2, tByproductFirestone), ST.mul_(2, tByproductFirestone), ST.mul_(2, tByproductFirestone), tByproductFirestone);
				}
				for (FluidStack tWater : FL.waters(100))
				RM.Bath.addRecipe2(T, T, F, F, T, 0,  16, tCrushedTiny             , OP.dustTiny.mat(tFirestone , 1), tWater, FL.Steam.make(100*STEAM_PER_WATER), OM.crushedPurifiedTiny(aMat, 1), tByproductFirestone);
				}
			}
			
			ItemStack tPurified = crushedPurified.mat(aMat, 1), tPurifiedTiny = crushedPurifiedTiny.mat(aMat, 1);
			if (ST.valid(tPurified) && ST.valid(tPurifiedTiny)) {
				if (ENABLE_ADDING_IC2_CENTRIFUGE_RECIPES) {
				RM.ic2_centrifuge(tPurified                 , (int)Math.min(5000, Math.abs(aMat.getMass() * 20)), OM.crushedCentrifuged(aMat, 1), OM.crushedCentrifugedTiny(UT.Code.select(1, aMat, aMat.mByProducts), 1));
				RM.ic2_centrifuge(ST.amount(9,tPurifiedTiny), (int)Math.min(5000, Math.abs(aMat.getMass() * 20)), OM.crushedCentrifuged(aMat, 1), OM.crushedCentrifugedTiny(UT.Code.select(1, aMat, aMat.mByProducts), 1));
				}
				if (!tMagnetList.isEmpty()) {
				RM.MagneticSeparator.addRecipe1(T, 16, 144, tMagnet, tPurified    , OM.crushedCentrifuged    (aMat, 1), OM.crushedCentrifugedTiny(UT.Code.select(0, aMat, tMagnetList),18), OM.crushedCentrifugedTiny(UT.Code.select(1, aMat, tMagnetList),18), OM.crushedCentrifugedTiny(UT.Code.select(2, aMat, tMagnetList),18), OM.crushedCentrifugedTiny(UT.Code.select(3, aMat, tMagnetList),18), OM.crushedCentrifugedTiny(UT.Code.select(4, aMat, tMagnetList),18));
				RM.MagneticSeparator.addRecipe1(T, 16,  16, tMagnet, tPurifiedTiny, OM.crushedCentrifugedTiny(aMat, 1), OM.crushedCentrifugedTiny(UT.Code.select(0, aMat, tMagnetList), 2), OM.crushedCentrifugedTiny(UT.Code.select(1, aMat, tMagnetList), 2), OM.crushedCentrifugedTiny(UT.Code.select(2, aMat, tMagnetList), 2), OM.crushedCentrifugedTiny(UT.Code.select(3, aMat, tMagnetList), 2), OM.crushedCentrifugedTiny(UT.Code.select(4, aMat, tMagnetList), 2));
				}
				ItemStack tGem = gem.mat(aMat, 1);
				if (tGem != null) {
				RM.Sifting.addRecipe1(T, 16, 144, new long[] {9, 90, 360, 1350, 1800, 3600, 4500}, tPurified    , gemLegendary.mat(aMat, ST.amount(8, tGem), 1), gemExquisite.mat(aMat, ST.amount(4, tGem), 1), gemFlawless.mat(aMat, ST.amount(2, tGem), 1), tGem, gemFlawed.mat(aMat, tGem, 2), gemChipped.mat(aMat, tGem, 4), tDust);
				RM.Sifting.addRecipe1(T, 16,  16, new long[] {1, 10,  40,  150,  200,  400,  500}, tPurifiedTiny, gemLegendary.mat(aMat, ST.amount(8, tGem), 1), gemExquisite.mat(aMat, ST.amount(4, tGem), 1), gemFlawless.mat(aMat, ST.amount(2, tGem), 1), tGem, gemFlawed.mat(aMat, tGem, 2), gemChipped.mat(aMat, tGem, 4), tDust);
				}
				
				OreDictMaterial tMat1 = UT.Code.select(0, aMat, aMat.mByProducts), tMat2 = UT.Code.select(1, aMat, aMat.mByProducts), tMat3 = UT.Code.select(2, aMat, aMat.mByProducts);
				FluidStack tFluid1 = tMat1.fluid(DEF_ENV_TEMP, U72, T), tFluid2 = tMat2.fluid(DEF_ENV_TEMP, U72, T), tFluid3 = tMat3.fluid(DEF_ENV_TEMP, U72, T);
				if (FL.zero(tFluid1)) tFluid1 = null;
				if (FL.zero(tFluid2)) tFluid2 = null;
				if (FL.zero(tFluid3)) tFluid3 = null;
				RM.Centrifuge.addRecipe1(T, 16, 144 + 144 * aMat.mToolQuality, tCentrifuge, tPurified    , ZL_FS, FL.array(FL.mul(tFluid1, 9), FL.mul(tFluid2, 9), FL.mul(tFluid3, 9)), OM.crushedCentrifugedTiny(aMat, 9), tFluid1==null?OM.crushedCentrifugedTiny(tMat1, 9):null, tFluid2==null?OM.crushedCentrifugedTiny(tMat2, 9):null, tFluid3==null?OM.crushedCentrifugedTiny(tMat3, 9):null);
				RM.Centrifuge.addRecipe1(T, 16,  16 +  16 * aMat.mToolQuality, tCentrifuge, tPurifiedTiny, ZL_FS, FL.array(       tFluid1    ,        tFluid2    ,        tFluid3    ), OM.crushedCentrifugedTiny(aMat, 1), tFluid1==null?OM.crushedCentrifugedTiny(tMat1, 1):null, tFluid2==null?OM.crushedCentrifugedTiny(tMat2, 1):null, tFluid3==null?OM.crushedCentrifugedTiny(tMat3, 1):null);
			}
		}
	}
}
