/**
 * Copyright (c) 2024 GregTech-6 Team
 *
 * This file is part of GregTech.
 *
 * GregTech is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GregTech is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with GregTech. If not, see <http://www.gnu.org/licenses/>.
 */

package gregtech.loaders.b;

import gregapi.block.MaterialMachines;
import gregapi.block.MaterialScoopable;
import gregapi.block.multitileentity.MultiTileEntityBlock;
import gregapi.block.multitileentity.MultiTileEntityRegistry;
import gregapi.block.multitileentity.example.MultiTileEntityChest;
import gregapi.cover.CoverRegistry;
import gregapi.cover.covers.CoverAsphalt;
import gregapi.cover.covers.CoverTextureSimple;
import gregapi.data.*;
import gregapi.old.Textures;
import gregapi.oredict.OreDictItemData;
import gregapi.oredict.OreDictManager;
import gregapi.oredict.OreDictMaterial;
import gregapi.render.BlockTextureCopied;
import gregapi.render.BlockTextureDefault;
import gregapi.tileentity.connectors.*;
import gregapi.tileentity.inventories.MultiTileEntityBookShelf;
import gregapi.tileentity.machines.MultiTileEntityBasicMachine;
import gregapi.tileentity.machines.MultiTileEntityBasicMachineElectric;
import gregapi.tileentity.multiblocks.MultiTileEntityMultiBlockPart;
import gregapi.tileentity.tools.MultiTileEntityAdvancedCraftingTable;
import gregapi.tileentity.tools.MultiTileEntityChargingCraftingTable;
import gregapi.util.CR;
import gregapi.util.OM;
import gregapi.util.ST;
import gregapi.util.UT;
import gregtech.tileentity.autotools.MultiTileEntityAutoToolHammer;
import gregtech.tileentity.autotools.MultiTileEntityAutoToolIgniter;
import gregtech.tileentity.batteries.eu.*;
import gregtech.tileentity.batteries.lu.*;
import gregtech.tileentity.batteries.qu.MultiTileEntityZPM;
import gregtech.tileentity.computer.MultiTileEntityHDDSwitch;
import gregtech.tileentity.computer.MultiTileEntityUSBSwitch;
import gregtech.tileentity.energy.converters.*;
import gregtech.tileentity.energy.generators.*;
import gregtech.tileentity.energy.reactors.*;
import gregtech.tileentity.energy.storage.*;
import gregtech.tileentity.energy.transformers.MultiTileEntityGearBox;
import gregtech.tileentity.energy.transformers.MultiTileEntityLongDistanceTransformer;
import gregtech.tileentity.energy.transformers.MultiTileEntityTransformerElectric;
import gregtech.tileentity.energy.transformers.MultiTileEntityTransformerRotation;
import gregtech.tileentity.extenders.*;
import gregtech.tileentity.food.MultiTileEntitySandwich;
import gregtech.tileentity.inventories.*;
import gregtech.tileentity.misc.*;
import gregtech.tileentity.multiblocks.*;
import gregtech.tileentity.panels.MultiTileEntityPanelAsphalt;
import gregtech.tileentity.panels.MultiTileEntityPanelCFoam;
import gregtech.tileentity.panels.MultiTileEntityPanelConcrete;
import gregtech.tileentity.panels.MultiTileEntityPanelWood;
import gregtech.tileentity.placeables.*;
import gregtech.tileentity.plants.MultiTileEntityBush;
import gregtech.tileentity.plants.MultiTileEntityResinHoleRubber;
import gregtech.tileentity.plants.MultiTileEntitySapHoleMaple;
import gregtech.tileentity.plants.MultiTileEntitySapHoleRainbowood;
import gregtech.tileentity.portals.*;
import gregtech.tileentity.redstone.MultiTileEntityButtonAdvanced;
import gregtech.tileentity.sensors.*;
import gregtech.tileentity.tanks.*;
import gregtech.tileentity.tools.*;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fluids.FluidStack;

import static gregapi.data.CS.*;

public class Loader_MultiTileEntities implements Runnable {
	@Override
	public void run() {
		MultiTileEntityRegistry aRegistry = MultiTileEntityRegistry.getRegistry("gt.multitileentity");
		
		MultiTileEntityBlock
		  aMetal      = MultiTileEntityBlock.getOrCreate(MD.GT.mID, "iron"         , Material.iron             , Block.soundTypeMetal, TOOL_pickaxe, 0, 0, 15, F, F)
		, aMetalChips = MultiTileEntityBlock.getOrCreate(MD.GT.mID, "iron"         , Material.iron             , Block.soundTypeMetal, TOOL_shovel , 0, 0, 15, F, F)
		, aMetalWires = MultiTileEntityBlock.getOrCreate(MD.GT.mID, "machine"      , MaterialMachines.instance , Block.soundTypeMetal, TOOL_cutter , 0, 0, 15, F, F)
		, aMachine    = MultiTileEntityBlock.getOrCreate(MD.GT.mID, "machine"      , MaterialMachines.instance , Block.soundTypeMetal, TOOL_wrench , 0, 0, 15, F, F)
		, aWooden     = MultiTileEntityBlock.getOrCreate(MD.GT.mID, "wood"         , Material.wood             , Block.soundTypeWood , TOOL_axe    , 0, 0, 15, F, F)
		, aBush       = MultiTileEntityBlock.getOrCreate(MD.GT.mID, "leaves"       , Material.leaves           , Block.soundTypeGrass, TOOL_axe    , 0, 0, 15, F, F)
		, aStone      = MultiTileEntityBlock.getOrCreate(MD.GT.mID, "rock"         , Material.rock             , Block.soundTypeStone, TOOL_pickaxe, 0, 0, 15, F, F)
		, aWool       = MultiTileEntityBlock.getOrCreate(MD.GT.mID, "cloth"        , Material.cloth            , Block.soundTypeCloth, TOOL_shears , 0, 0, 15, F, F)
		, aTNT        = MultiTileEntityBlock.getOrCreate(MD.GT.mID, "tnt"          , Material.tnt              , Block.soundTypeGrass, TOOL_pickaxe, 0, 0, 15, F, F)
		, aUtilMetal  = MultiTileEntityBlock.getOrCreate(MD.GT.mID, "redstoneLight", Material.redstoneLight    , Block.soundTypeMetal, TOOL_pickaxe, 0, 0, 15, F, F)
		, aUtilStone  = MultiTileEntityBlock.getOrCreate(MD.GT.mID, "redstoneLight", Material.redstoneLight    , Block.soundTypeStone, TOOL_pickaxe, 0, 0, 15, F, F)
		, aUtilWood   = MultiTileEntityBlock.getOrCreate(MD.GT.mID, "redstoneLight", Material.redstoneLight    , Block.soundTypeWood , TOOL_axe    , 0, 0, 15, F, F)
		, aUtilWool   = MultiTileEntityBlock.getOrCreate(MD.GT.mID, "redstoneLight", Material.redstoneLight    , Block.soundTypeCloth, TOOL_shears , 0, 0, 15, F, F)
		, aHive       = MultiTileEntityBlock.getOrCreate(MD.GT.mID, "rock"         , MaterialScoopable.instance, Block.soundTypeWood , TOOL_scoop  , 0, 0, 15, F, F)
		;
		
		storages   (aRegistry, aMetal, aMetalChips, aMetalWires, aMachine, aWooden, aBush, aStone, aWool, aTNT, aHive, aUtilMetal, aUtilStone, aUtilWood, aUtilWool, MT.NULL, null);
		crucible   (aRegistry, aMetal, aMetalChips, aMetalWires, aMachine, aWooden, aBush, aStone, aWool, aTNT, aHive, aUtilMetal, aUtilStone, aUtilWood, aUtilWool, MT.NULL, null);
		unsorted1  (aRegistry, aMetal, aMetalChips, aMetalWires, aMachine, aWooden, aBush, aStone, aWool, aTNT, aHive, aUtilMetal, aUtilStone, aUtilWood, aUtilWool, MT.NULL, null);
		unsorted2  (aRegistry, aMetal, aMetalChips, aMetalWires, aMachine, aWooden, aBush, aStone, aWool, aTNT, aHive, aUtilMetal, aUtilStone, aUtilWood, aUtilWool, MT.NULL, null);
		computer   (aRegistry, aMetal, aMetalChips, aMetalWires, aMachine, aWooden, aBush, aStone, aWool, aTNT, aHive, aUtilMetal, aUtilStone, aUtilWood, aUtilWool, MT.NULL, null);
		multiblocks(aRegistry, aMetal, aMetalChips, aMetalWires, aMachine, aWooden, aBush, aStone, aWool, aTNT, aHive, aUtilMetal, aUtilStone, aUtilWood, aUtilWool, MT.NULL, null);
		machines1  (aRegistry, aMetal, aMetalChips, aMetalWires, aMachine, aWooden, aBush, aStone, aWool, aTNT, aHive, aUtilMetal, aUtilStone, aUtilWood, aUtilWool, MT.NULL, null);
		machines2  (aRegistry, aMetal, aMetalChips, aMetalWires, aMachine, aWooden, aBush, aStone, aWool, aTNT, aHive, aUtilMetal, aUtilStone, aUtilWood, aUtilWool, MT.NULL, null);
		machines3  (aRegistry, aMetal, aMetalChips, aMetalWires, aMachine, aWooden, aBush, aStone, aWool, aTNT, aHive, aUtilMetal, aUtilStone, aUtilWood, aUtilWool, MT.NULL, null);
		machines4  (aRegistry, aMetal, aMetalChips, aMetalWires, aMachine, aWooden, aBush, aStone, aWool, aTNT, aHive, aUtilMetal, aUtilStone, aUtilWood, aUtilWool, MT.NULL, null);
		kinetic    (aRegistry, aMetal, aMetalChips, aMetalWires, aMachine, aWooden, aBush, aStone, aWool, aTNT, aHive, aUtilMetal, aUtilStone, aUtilWood, aUtilWool, MT.NULL, null);
		connectors (aRegistry, aMetal, aMetalChips, aMetalWires, aMachine, aWooden, aBush, aStone, aWool, aTNT, aHive, aUtilMetal, aUtilStone, aUtilWood, aUtilWool, MT.NULL, null);
		extenders  (aRegistry, aMetal, aMetalChips, aMetalWires, aMachine, aWooden, aBush, aStone, aWool, aTNT, aHive, aUtilMetal, aUtilStone, aUtilWood, aUtilWool, MT.NULL, null);
		sensors    (aRegistry, aMetal, aMetalChips, aMetalWires, aMachine, aWooden, aBush, aStone, aWool, aTNT, aHive, aUtilMetal, aUtilStone, aUtilWood, aUtilWool, MT.NULL, null);
		misc       (aRegistry, aMetal, aMetalChips, aMetalWires, aMachine, aWooden, aBush, aStone, aWool, aTNT, aHive, aUtilMetal, aUtilStone, aUtilWood, aUtilWool, MT.NULL, null);
	}
	
	private static void metalset(MultiTileEntityRegistry aRegistry, MultiTileEntityBlock aMetal, MultiTileEntityBlock aUtilMetal, MultiTileEntityBlock aMachine, MultiTileEntityBlock aWooden, OreDictMaterial aMat, int aID, float aHardness, float aResistance, int aHopperSize) {
		aRegistry.add(aMat.getLocal()+" Chest"                           , "Chests"         ,      aID, 32745, MultiTileEntityChest.class                , 0                , 16, aMetal    , UT.NBT.make(NBT_MATERIAL, aMat    , NBT_HARDNESS, aHardness  , NBT_RESISTANCE, aResistance  , NBT_INV_SIZE, 54, NBT_TEXTURE, "metalchest"                                                                ), "sPw", "RSR", "PPP", 'P', OP.plate.dat(aMat), 'R', OP.ring.dat(aMat), 'S', OP.stick.dat(aMat));
		aRegistry.add(aMat.getLocal()+" reinforced wooden Chest"         , "Chests"         ,  500+aID, 32745, MultiTileEntityChest.class                , 0                , 16, aWooden   , UT.NBT.make(NBT_MATERIAL, aMat    , NBT_HARDNESS, aHardness/2, NBT_RESISTANCE, aResistance/2, NBT_INV_SIZE, 54, NBT_TEXTURE, "woodchest", NBT_FLAMMABILITY, aMat.contains(TD.Properties.UNBURNABLE)?0:100), "sSw", "RCR", "SSS", 'C', OD.craftingChest, 'R', OP.ring.dat(aMat), 'S', OP.stick.dat(aMat));
		aRegistry.add("Mechanical "+aMat.getLocal()+" Safe"              , "Safes"          , 2000+aID,  2010, MultiTileEntitySafeMechanical.class       , aMat.mToolQuality, 16, aMachine  , UT.NBT.make(NBT_MATERIAL, aMat    , NBT_HARDNESS, aHardness*2, NBT_RESISTANCE, aResistance*2, NBT_INV_SIZE, 15                                                                                           ), "PGP", "GOS", "PGP", 'P', OP.plateQuintuple.dat(aMat), 'G', OP.gearGtSmall.dat(aMat), 'O', OP.gearGt.dat(aMat), 'S', OP.stick.dat(aMat));
		aRegistry.add("Key Locked "+aMat.getLocal()+" Safe"              , "Safes"          , 3000+aID,  2010, MultiTileEntitySafeKeyLocked.class        , aMat.mToolQuality, 16, aMachine  , UT.NBT.make(NBT_MATERIAL, aMat    , NBT_HARDNESS, aHardness*2, NBT_RESISTANCE, aResistance*2, NBT_INV_SIZE, 15                                                                                           ), "PGP", "OGS", "PGP", 'P', OP.plateQuintuple.dat(aMat), 'G', OP.gearGtSmall.dat(aMat), 'O', OP.gearGt.dat(aMat), 'S', OP.stick.dat(aMat));
		aRegistry.add("Advanced Crafting Table ("    +aMat.getLocal()+")", "Crafting Tables", 5000+aID,  5010, MultiTileEntityAdvancedCraftingTable.class, aMat.mToolQuality, 16, aMachine  , UT.NBT.make(NBT_MATERIAL, aMat    , NBT_HARDNESS, aHardness  , NBT_RESISTANCE, aResistance                                                                                                               ), "PdP", "TWT", "PCP", 'T', OP.screw.dat(aMat), 'P', OP.plate.dat(aMat), 'W', OD.craftingWorkBench, 'C', OD.craftingChest);
		aRegistry.add("Charging Crafting Table ("    +aMat.getLocal()+")", "Crafting Tables", 5500+aID,  5010, MultiTileEntityChargingCraftingTable.class, aMat.mToolQuality, 16, aMachine  , UT.NBT.make(NBT_MATERIAL, aMat    , NBT_HARDNESS, aHardness  , NBT_RESISTANCE, aResistance  , NBT_GUI, RES_PATH_GUI + "machines/AdvancedCraftingTableCharging.png"                                       ), "WTW", "dMx", "WTW", 'T', OP.screw.dat(aMat), 'M', aRegistry.getItem(5000+aID), 'W', MT.DATA.CABLES_04[3]);
		aRegistry.add("Locker ("                     +aMat.getLocal()+")", "Storage"        , 7300+aID, 32751, MultiTileEntityLocker.class               , aMat.mToolQuality, 16, aMachine  , UT.NBT.make(NBT_MATERIAL, aMat    , NBT_HARDNESS, aHardness  , NBT_RESISTANCE, aResistance                                                                                                               ), "SdS", "LCL", "TMT", 'T', OP.screw.dat(aMat), 'C', aRegistry.getItem(aID), 'M', OP.casingMachine.dat(aMat), 'S', OP.stick.dat(aMat), 'L', OD.craftingLeather);
		aRegistry.add("Charging Locker ("            +aMat.getLocal()+")", "Storage"        , 7500+aID, 32751, MultiTileEntityLockerCharging.class       , aMat.mToolQuality, 16, aMachine  , UT.NBT.make(NBT_MATERIAL, aMat    , NBT_HARDNESS, aHardness  , NBT_RESISTANCE, aResistance                                                                                                               ), "WCW", "WMW", "WCW", 'M', aRegistry.getItem(7300+aID), 'W', MT.DATA.CABLES_01[3], 'C', OD_CIRCUITS[3]);
		aRegistry.add("Compartment Drawer ("         +aMat.getLocal()+")", "Storage"        , 4000+aID, 32751, MultiTileEntityDrawerQuad.class           , aMat.mToolQuality, 16, aMachine  , UT.NBT.make(NBT_MATERIAL, aMat    , NBT_HARDNESS, aHardness  , NBT_RESISTANCE, aResistance                                                                                                               ), "CTC", "TdT", "CTC", 'T', OP.screw.dat(aMat), 'C', aRegistry.getItem(aID));
		aRegistry.add("Mass Storage ("               +aMat.getLocal()+")", "Storage"        , 6000+aID, 32751, MultiTileEntityMassStorageStandard.class  , aMat.mToolQuality, 16, aMachine  , UT.NBT.make(NBT_MATERIAL, aMat    , NBT_HARDNESS, aHardness  , NBT_RESISTANCE, aResistance                                                                                                               ), "TCT", "wMd", "TCT", 'T', OP.screw.dat(aMat), 'C', aRegistry.getItem(aID), 'M', OP.casingMachine.dat(aMat));
		aRegistry.add("Logistics Mass Storage ("     +aMat.getLocal()+")", "Logistics"      , 6200+aID, 17997, MultiTileEntityMassStorageLogistics.class , aMat.mToolQuality, 16, aMachine  , UT.NBT.make(NBT_MATERIAL, MT.Black, NBT_HARDNESS, aHardness  , NBT_RESISTANCE, aResistance                                                                                                               ), "TQT", "wCd", "TMT", 'T', OP.screw.dat(aMat), 'M', aRegistry.getItem(6000+aID), 'Q', IL.Cover_Logistics_Generic_Storage, 'C', OD_CIRCUITS[4]);
		aRegistry.add("Bookshelf ("                  +aMat.getLocal()+")", "Storage"        , 7100+aID, 32751, MultiTileEntityBookShelf.class            , aMat.mToolQuality, 16, aMachine  , UT.NBT.make(NBT_MATERIAL, aMat    , NBT_HARDNESS, aHardness  , NBT_RESISTANCE, aResistance                                                                                                               ), "PTP", "sdh", "PTP", 'T', OP.screw.dat(aMat), 'P', OP.plate.dat(aMat));
		aRegistry.add("Bottlecrate ("                +aMat.getLocal()+")", "Storage"        , 8600+aID, 32751, MultiTileEntityBottleCrate.class          , 0                , 16, aUtilMetal, UT.NBT.make(NBT_MATERIAL, aMat    , NBT_HARDNESS, 0.5F       , NBT_RESISTANCE, aResistance                                                                                                               ), "CdC", "TCT"       , 'T', OP.screw.dat(aMat), 'C', OP.casingSmall.dat(aMat));
		aRegistry.add(aMat.getLocal()+" Hopper"                          , "Hoppers"        , 8000+aID,  8010, MultiTileEntityHopper.class               , 0                , 16, aMachine  , UT.NBT.make(NBT_MATERIAL, aMat    , NBT_HARDNESS, aHardness  , NBT_RESISTANCE, aResistance  , NBT_INV_SIZE, Math.max(1, aHopperSize)                                                                     ), "PwP", "XCX", " Xh", 'P', OP.plate.dat(aMat), 'X', OP.plateCurved.dat(aMat), 'C', OD.craftingChest);
		aRegistry.add(aMat.getLocal()+" Queue Hopper"                    , "Hoppers"        , 8200+aID,  8010, MultiTileEntityQueueHopper.class          , 0                , 16, aMachine  , UT.NBT.make(NBT_MATERIAL, aMat    , NBT_HARDNESS, aHardness  , NBT_RESISTANCE, aResistance  , NBT_INV_SIZE, Math.max(2, aHopperSize)                                                                     ), "PCP", "XCX", "wXh", 'P', OP.plate.dat(aMat), 'X', OP.plateCurved.dat(aMat), 'C', OD.craftingChest);
		aRegistry.add(aMat.getLocal()+" Scaffold"                        , "Scaffolds"      , 8400+aID,  8410, MultiTileEntityScaffold.class             , 0                , 64, aMachine  , UT.NBT.make(NBT_MATERIAL, aMat    , NBT_HARDNESS, 5.0F       , NBT_RESISTANCE, aResistance                                                                                                               ), "TPT", "SdS"       , 'T', OP.screw.dat(aMat), 'P', OP.plate.dat(aMat), 'S', OP.stick.dat(aMat));
	}
	
	private static void storages(MultiTileEntityRegistry aRegistry, MultiTileEntityBlock aMetal, MultiTileEntityBlock aMetalChips, MultiTileEntityBlock aMetalWires, MultiTileEntityBlock aMachine, MultiTileEntityBlock aWooden, MultiTileEntityBlock aBush, MultiTileEntityBlock aStone, MultiTileEntityBlock aWool, MultiTileEntityBlock aTNT, MultiTileEntityBlock aHive, MultiTileEntityBlock aUtilMetal, MultiTileEntityBlock aUtilStone, MultiTileEntityBlock aUtilWood, MultiTileEntityBlock aUtilWool, OreDictMaterial aMat, Class<?> aClass) {
		OM.data(aRegistry.add("Mossy Stone Chest", "Chests", 32745, 32745, MultiTileEntityChest.class, 0, 16, aStone, UT.NBT.make(NBT_MATERIAL, MT.Stone, NBT_HARDNESS, 5.0F, NBT_RESISTANCE, 14.0F, NBT_INV_SIZE, 54, NBT_TEXTURE, "lootchest")), MT.Stone, U*8);
		
		aMat = ANY.Steel;           aRegistry.add("Storage Inserter"          , "Storage", 32751, 32751, MultiTileEntityStorageInserter.class  , aMat.mToolQuality, 16, aMachine , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS, 6.0F, NBT_RESISTANCE, 6.0F), "PhP", "SDE", "PwP", 'P', OP.pipeQuadruple.dat(aMat), 'S', OP.gem.dat(ANY.Sapphire), 'E', OP.gem.dat(ANY.Emerald), 'D', OP.gem.dat(ANY.Diamond));
		
		aMat = ANY.Wood;            aRegistry.add("Wooden Item Barrel (Cheap)", "Storage",  6998, 32751, MultiTileEntityMassStorageBarrel.class, aMat.mToolQuality, 16, aUtilWood, UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS, 3.0F, NBT_RESISTANCE, 3.0F, NBT_CAPACITY,  5000, NBT_FLAMMABILITY,  100), "rCs", "PSP", "PSP", 'C', OD.craftingChest, 'P', OD.plankAnyWood   , 'S', OP.stickLong.dat(MT .Pb       ));
		aMat = ANY.Wood;            aRegistry.add("Wooden Item Barrel (Cheap)", "Storage",  6992, 32751, MultiTileEntityMassStorageBarrel.class, aMat.mToolQuality, 16, aUtilWood, UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS, 3.0F, NBT_RESISTANCE, 3.0F, NBT_CAPACITY,  5000, NBT_FLAMMABILITY,  100), "rCs", "PSP", "PSP", 'C', OD.craftingChest, 'P', OD.plankAnyWood   , 'S', OP.stickLong.dat(MT .Bi       ));
		aMat = ANY.Wood;            aRegistry.add("Wooden Item Barrel (Cheap)", "Storage",  6991, 32751, MultiTileEntityMassStorageBarrel.class, aMat.mToolQuality, 16, aUtilWood, UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS, 3.0F, NBT_RESISTANCE, 3.0F, NBT_CAPACITY,  5000, NBT_FLAMMABILITY,  100), "rCs", "PSP", "PSP", 'C', OD.craftingChest, 'P', OD.plankAnyWood   , 'S', OP.stickLong.dat(MT .Bronze   ));
		aMat = ANY.Wood;            aRegistry.add("Wooden Item Barrel (Cheap)", "Storage",  6990, 32751, MultiTileEntityMassStorageBarrel.class, aMat.mToolQuality, 16, aUtilWood, UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS, 3.0F, NBT_RESISTANCE, 3.0F, NBT_CAPACITY,  5000, NBT_FLAMMABILITY,  100), "rCs", "PSP", "PSP", 'C', OD.craftingChest, 'P', OD.plankAnyWood   , 'S', OP.stickLong.dat(MT .Brass    ));
		aMat = MT.WoodTreated;      aRegistry.add("Wooden Item Barrel"        , "Storage",  6999, 32751, MultiTileEntityMassStorageBarrel.class, aMat.mToolQuality, 16, aUtilWood, UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS, 3.0F, NBT_RESISTANCE, 3.0F, NBT_CAPACITY, 10000, NBT_FLAMMABILITY,  100), "rCs", "PSP", "PSP", 'C', OD.craftingChest, 'P', OP.plate.dat(aMat), 'S', OP.stickLong.dat(ANY.Iron     ));
		aMat = MT.Skyroot;          aRegistry.add("Skyroot Item Barrel"       , "Storage",  6983, 32751, MultiTileEntityMassStorageBarrel.class, aMat.mToolQuality, 16, aUtilWood, UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS, 4.0F, NBT_RESISTANCE, 4.0F, NBT_CAPACITY, 10000, NBT_FLAMMABILITY,  100), "rCs", "PSP", "PSP", 'C', OD.craftingChest, 'P', OD.plankSkyroot   , 'S', OP.stickLong.dat(ANY.Iron     ));
		aMat = MT.Weedwood;         aRegistry.add("Weedwood Item Barrel"      , "Storage",  6989, 32751, MultiTileEntityMassStorageBarrel.class, aMat.mToolQuality, 16, aUtilWood, UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS, 4.0F, NBT_RESISTANCE, 4.0F, NBT_CAPACITY,  5000                        ), "rCs", "PSP", "PSP", 'C', OD.craftingChest, 'P', OD.plankWeedwood  , 'S', OP.stickLong.dat(MT .Syrmorite));
		aMat = MT.Livingwood;       aRegistry.add("Livingwood Item Barrel"    , "Storage",  6988, 32751, MultiTileEntityMassStorageBarrel.class, aMat.mToolQuality, 16, aUtilWood, UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS, 3.0F, NBT_RESISTANCE, 3.0F, NBT_CAPACITY, 10000, NBT_FLAMMABILITY,  100), "rCs", "PSP", "PSP", 'C', OD.craftingChest, 'P', OP.plate.dat(aMat), 'S', OP.stickLong.dat(ANY.Iron     ));
		aMat = MT.Dreamwood;        aRegistry.add("Dreamwood Item Barrel"     , "Storage",  6987, 32751, MultiTileEntityMassStorageBarrel.class, aMat.mToolQuality, 16, aUtilWood, UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS, 5.0F, NBT_RESISTANCE, 5.0F, NBT_CAPACITY, 10000                        ), "rCs", "PSP", "PSP", 'C', OD.craftingChest, 'P', OP.plate.dat(aMat), 'S', OP.stickLong.dat(ANY.MagicIron));
		aMat = MT.Shimmerwood;      aRegistry.add("Shimmerwood Item Barrel"   , "Storage",  6986, 32751, MultiTileEntityMassStorageBarrel.class, aMat.mToolQuality, 16, aUtilWood, UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS, 5.0F, NBT_RESISTANCE, 5.0F, NBT_CAPACITY, 10000                        ), "rCs", "PSP", "PSP", 'C', OD.craftingChest, 'P', OP.plate.dat(aMat), 'S', OP.stickLong.dat(ANY.MagicIron));
		aMat = MT.IronWood;         aRegistry.add("Ironwood Item Barrel"      , "Storage",  6997, 32751, MultiTileEntityMassStorageBarrel.class, aMat.mToolQuality, 16, aUtilWood, UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS, 4.0F, NBT_RESISTANCE, 4.0F, NBT_CAPACITY, 10000                        ), "rCs", "PSP", "PSP", 'C', OD.craftingChest, 'P', OP.plate.dat(aMat), 'S', OP.stickLong.dat(ANY.Iron     ));
		aMat = MT.Greatwood;        aRegistry.add("Greatwood Item Barrel"     , "Storage",  6985, 32751, MultiTileEntityMassStorageBarrel.class, aMat.mToolQuality, 16, aUtilWood, UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS, 3.0F, NBT_RESISTANCE, 3.0F, NBT_CAPACITY, 10000, NBT_FLAMMABILITY,  100), "rCs", "PSP", "PSP", 'C', OD.craftingChest, 'P', OP.plate.dat(aMat), 'S', OP.stickLong.dat(ANY.Iron     ));
		aMat = MT.Silverwood;       aRegistry.add("Silverwood Item Barrel"    , "Storage",  6984, 32751, MultiTileEntityMassStorageBarrel.class, aMat.mToolQuality, 16, aUtilWood, UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS, 5.0F, NBT_RESISTANCE, 5.0F, NBT_CAPACITY, 10000                        ), "rCs", "PSP", "PSP", 'C', OD.craftingChest, 'P', OP.plate.dat(aMat), 'S', OP.stickLong.dat(ANY.MagicIron));
		
		aMat = MT.Plastic;          aRegistry.add("Plastic Storage Box (1024)", "Storage",  6996, 32751, MultiTileEntityMassStorageBox.class   , aMat.mToolQuality, 16, aUtilWood, UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS, 4.0F, NBT_RESISTANCE, 4.0F, NBT_CAPACITY,  1024                        ), "dPT", "PCP", "TPT", 'C', OD.craftingChest, 'P', OP.plate.dat(aMat), 'T', OP.screw.dat(aMat));
		aMat = MT.Plastic;          aRegistry.add("Plastic Storage Box (512)" , "Storage",  6995, 32751, MultiTileEntityMassStorageBox.class   , aMat.mToolQuality, 16, aUtilWood, UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS, 4.0F, NBT_RESISTANCE, 4.0F, NBT_CAPACITY,   512                        ), "TPd", "PCP", "TPT", 'C', OD.craftingChest, 'P', OP.plate.dat(aMat), 'T', OP.screw.dat(aMat));
		aMat = MT.Plastic;          aRegistry.add("Plastic Storage Box (256)" , "Storage",  6994, 32751, MultiTileEntityMassStorageBox.class   , aMat.mToolQuality, 16, aUtilWood, UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS, 4.0F, NBT_RESISTANCE, 4.0F, NBT_CAPACITY,   256                        ), "TPT", "PCP", "dPT", 'C', OD.craftingChest, 'P', OP.plate.dat(aMat), 'T', OP.screw.dat(aMat));
		aMat = MT.Plastic;          aRegistry.add("Plastic Storage Box (128)" , "Storage",  6993, 32751, MultiTileEntityMassStorageBox.class   , aMat.mToolQuality, 16, aUtilWood, UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS, 4.0F, NBT_RESISTANCE, 4.0F, NBT_CAPACITY,   128                        ), "TPT", "PCP", "TPd", 'C', OD.craftingChest, 'P', OP.plate.dat(aMat), 'T', OP.screw.dat(aMat));
		
		// 6982 and lower are next
		
		CR.shapeless(aRegistry.getItem(6996), CR.DEF_NCC, new Object[] {aRegistry.getItem(6995)});
		CR.shapeless(aRegistry.getItem(6995), CR.DEF_NCC, new Object[] {aRegistry.getItem(6994)});
		CR.shapeless(aRegistry.getItem(6994), CR.DEF_NCC, new Object[] {aRegistry.getItem(6993)});
		CR.shapeless(aRegistry.getItem(6993), CR.DEF_NCC, new Object[] {aRegistry.getItem(6996)});
		
		for (int i = 0; i < 100; i++) aRegistry.add("Wooden Bookshelf"        , "Storage",i+7000, 32751, MultiTileEntityBookShelf  .class, 0, 16, aWooden  , UT.NBT.make(NBT_HARDNESS, 2.0F, NBT_RESISTANCE, 2.0F, NBT_FLAMMABILITY, 150, NBT_TEXTURE, i    , NBT_HIDDEN, ST.invalid(PlankData.PLANKS[i    ])), ST.invalid(PlankData.PLANKS[i    ]) ? ZL : new Object[] {"PPP", "sfr", "PPP", 'P', PlankData.PLANKS[i    ]});
		for (int i = 0; i < 100; i++) aRegistry.add("Wooden Bookshelf"        , "Storage",i+7900, 32751, MultiTileEntityBookShelf  .class, 0, 16, aWooden  , UT.NBT.make(NBT_HARDNESS, 2.0F, NBT_RESISTANCE, 2.0F, NBT_FLAMMABILITY, 150, NBT_TEXTURE, i+100, NBT_HIDDEN, ST.invalid(PlankData.PLANKS[i+100])), ST.invalid(PlankData.PLANKS[i+100]) ? ZL : new Object[] {"PPP", "sfr", "PPP", 'P', PlankData.PLANKS[i+100]});
		for (int i = 0; i < 100; i++) aRegistry.add("Wooden Bookshelf"        , "Storage",i+7800, 32751, MultiTileEntityBookShelf  .class, 0, 16, aWooden  , UT.NBT.make(NBT_HARDNESS, 2.0F, NBT_RESISTANCE, 2.0F, NBT_FLAMMABILITY, 150, NBT_TEXTURE, i+200, NBT_HIDDEN, ST.invalid(PlankData.PLANKS[i+200])), ST.invalid(PlankData.PLANKS[i+200]) ? ZL : new Object[] {"PPP", "sfr", "PPP", 'P', PlankData.PLANKS[i+200]});
		for (int i = 0; i < 300; i++) aRegistry.add("Wooden Bottlecrate"      , "Storage",i+8700, 32751, MultiTileEntityBottleCrate.class, 0, 16, aUtilWood, UT.NBT.make(NBT_HARDNESS, 0.5F, NBT_RESISTANCE, 2.0F, NBT_FLAMMABILITY, 150, NBT_TEXTURE, i    , NBT_HIDDEN, ST.invalid(PlankData.PLANKS[i    ])), ST.invalid(PlankData.PLANKS[i    ]) ? ZL : new Object[] {"sfr", "PGP", "BPB", 'P', PlankData.PLANKS[i    ], 'B', OP.bolt.dat(ANY.Wood), 'G', OD.itemGlue});
		
		metalset(aRegistry, aMetal, aUtilMetal, aMachine, aWooden, MT.Pb                    ,    0,   4.0F,   4.0F,  1);
		metalset(aRegistry, aMetal, aUtilMetal, aMachine, aWooden, MT.Bi                    ,   16,   4.0F,   4.0F,  2);
		metalset(aRegistry, aMetal, aUtilMetal, aMachine, aWooden, MT.Sb                    ,   47,   4.0F,   4.0F,  2);
		metalset(aRegistry, aMetal, aUtilMetal, aMachine, aWooden, MT.Ni                    ,   22,   4.0F,   4.0F,  3);
		metalset(aRegistry, aMetal, aUtilMetal, aMachine, aWooden, MT.Constantan            ,   37,   4.0F,   4.0F,  3);
		metalset(aRegistry, aMetal, aUtilMetal, aMachine, aWooden, MT.Bronze                ,    9,   7.0F,   7.0F,  3);
		metalset(aRegistry, aMetal, aUtilMetal, aMachine, aWooden, MT.ArsenicCopper         ,   57,   7.5F,   7.5F,  4);
		metalset(aRegistry, aMetal, aUtilMetal, aMachine, aWooden, MT.Al                    ,    1,   2.0F,   2.0F,  4);
		metalset(aRegistry, aMetal, aUtilMetal, aMachine, aWooden, MT.Brass                 ,    8,   2.5F,   2.5F,  4);
		metalset(aRegistry, aMetal, aUtilMetal, aMachine, aWooden, MT.TinAlloy              ,    5,   3.0F,   3.0F,  4);
		metalset(aRegistry, aMetal, aUtilMetal, aMachine, aWooden, MT.Co                    ,   21,   4.0F,   4.0F,  4);
		metalset(aRegistry, aMetal, aUtilMetal, aMachine, aWooden, MT.Ardite                ,   38,   2.0F,   2.0F,  4);
		metalset(aRegistry, aMetal, aUtilMetal, aMachine, aWooden, MT.ArsenicBronze         ,   58,   8.0F,   8.0F,  5);
		metalset(aRegistry, aMetal, aUtilMetal, aMachine, aWooden, MT.BismuthBronze         ,   56,   8.0F,   8.0F,  5);
		metalset(aRegistry, aMetal, aUtilMetal, aMachine, aWooden, MT.Ge                    ,   23,   4.0F,   4.0F,  5);
		metalset(aRegistry, aMetal, aUtilMetal, aMachine, aWooden, MT.Invar                 ,    6,   4.0F,   4.0F,  5);
		metalset(aRegistry, aMetal, aUtilMetal, aMachine, aWooden, MT.Steel                 ,   10,   6.0F,   6.0F,  5);
		metalset(aRegistry, aMetal, aUtilMetal, aMachine, aWooden, MT.HSLA                  ,   18,   6.0F,   6.0F,  6);
		metalset(aRegistry, aMetal, aUtilMetal, aMachine, aWooden, MT.Au                    ,    2,   3.0F,   3.0F,  6);
		metalset(aRegistry, aMetal, aUtilMetal, aMachine, aWooden, MT.Ag                    ,    3,   3.0F,   3.0F,  6);
		metalset(aRegistry, aMetal, aUtilMetal, aMachine, aWooden, MT.Mn                    ,   46,   6.0F,   6.0F,  6);
		metalset(aRegistry, aMetal, aUtilMetal, aMachine, aWooden, MT.Manyullyn             ,   39,   4.0F,   4.0F,  6);
		metalset(aRegistry, aMetal, aUtilMetal, aMachine, aWooden, MT.Lumium                ,   54,   2.0F,   2.0F,  6);
		metalset(aRegistry, aMetal, aUtilMetal, aMachine, aWooden, MT.Knightmetal           ,   25,   7.0F,   7.0F,  7);
		metalset(aRegistry, aMetal, aUtilMetal, aMachine, aWooden, MT.SteelGalvanized       ,   19,   6.0F,   6.0F,  7);
		metalset(aRegistry, aMetal, aUtilMetal, aMachine, aWooden, MT.Meteorite             ,   43,   7.0F,   7.0F,  7);
		metalset(aRegistry, aMetal, aUtilMetal, aMachine, aWooden, MT.MeteoricSteel         ,   24,   8.0F,   8.0F,  8);
		metalset(aRegistry, aMetal, aUtilMetal, aMachine, aWooden, MT.GildedIron            ,   20,   6.0F,   6.0F,  8);
		metalset(aRegistry, aMetal, aUtilMetal, aMachine, aWooden, MT.Mo                    ,   49,   6.0F,   6.0F,  8);
		metalset(aRegistry, aMetal, aUtilMetal, aMachine, aWooden, MT.Syrmorite             ,   44,   4.0F,   4.0F,  9);
		metalset(aRegistry, aMetal, aUtilMetal, aMachine, aWooden, MT.Electrum              ,    7,   3.0F,   3.0F,  9);
		metalset(aRegistry, aMetal, aUtilMetal, aMachine, aWooden, MT.StainlessSteel        ,   11,   5.0F,   5.0F,  9);
		metalset(aRegistry, aMetal, aUtilMetal, aMachine, aWooden, MT.Thaumium              ,   27,   9.0F,   9.0F,  9);
		metalset(aRegistry, aMetal, aUtilMetal, aMachine, aWooden, MT.Manasteel             ,   40,   9.0F,   9.0F,  9);
		metalset(aRegistry, aMetal, aUtilMetal, aMachine, aWooden, MT.Efrine                ,   53,   8.0F,   8.0F,  9);
		metalset(aRegistry, aMetal, aUtilMetal, aMachine, aWooden, MT.TungstenAlloy         ,   52,   8.0F,   8.0F, 12);
		metalset(aRegistry, aMetal, aUtilMetal, aMachine, aWooden, MT.Ti                    ,   12,   9.0F,   9.0F, 12);
		metalset(aRegistry, aMetal, aUtilMetal, aMachine, aWooden, MT.Netherite             ,   51,  10.0F,  10.0F, 12);
		metalset(aRegistry, aMetal, aUtilMetal, aMachine, aWooden, MT.Cr                    ,   13,   4.0F,   4.0F, 14);
		metalset(aRegistry, aMetal, aUtilMetal, aMachine, aWooden, MT.Pt                    ,    4,   2.0F,   2.0F, 18);
		metalset(aRegistry, aMetal, aUtilMetal, aMachine, aWooden, MT.Octine                ,   45,   8.0F,   8.0F, 18);
		metalset(aRegistry, aMetal, aUtilMetal, aMachine, aWooden, MT.Desh                  ,   30,  15.0F,  15.0F, 18);
		metalset(aRegistry, aMetal, aUtilMetal, aMachine, aWooden, MT.Terrasteel            ,   42,  15.0F,  15.0F, 18);
		metalset(aRegistry, aMetal, aUtilMetal, aMachine, aWooden, MT.TungstenSteel         ,   14,  12.5F,  12.5F, 27);
		metalset(aRegistry, aMetal, aUtilMetal, aMachine, aWooden, MT.TungstenCarbide       ,   17,  12.5F,  12.5F, 27);
		metalset(aRegistry, aMetal, aUtilMetal, aMachine, aWooden, MT.DuraniumAlloy         ,   31,  20.0F,  20.0F, 27);
		metalset(aRegistry, aMetal, aUtilMetal, aMachine, aWooden, MT.Draconium             ,   35,  50.0F,  50.0F, 27);
		metalset(aRegistry, aMetal, aUtilMetal, aMachine, aWooden, MT.Ultimet               ,   48,  12.5F,  12.5F, 27);
		metalset(aRegistry, aMetal, aUtilMetal, aMachine, aWooden, MT.DeshAlloy             ,   55,  15.0F,  15.0F, 27);
		metalset(aRegistry, aMetal, aUtilMetal, aMachine, aWooden, ANY.W                    ,   26,  10.0F,  10.0F, 36);
		metalset(aRegistry, aMetal, aUtilMetal, aMachine, aWooden, MT.Pd                    ,   59,  15.0F,  15.0F, 36);
		metalset(aRegistry, aMetal, aUtilMetal, aMachine, aWooden, MT.Ir                    ,   15,  15.0F,  15.0F, 36);
		metalset(aRegistry, aMetal, aUtilMetal, aMachine, aWooden, MT.Os                    ,   29,   9.0F,   9.0F, 36);
		metalset(aRegistry, aMetal, aUtilMetal, aMachine, aWooden, MT.VoidMetal             ,   28,  30.0F,  30.0F, 36);
		metalset(aRegistry, aMetal, aUtilMetal, aMachine, aWooden, MT.ElvenElementium       ,   41,  30.0F,  30.0F, 36);
		metalset(aRegistry, aMetal, aUtilMetal, aMachine, aWooden, MT.TritaniumAlloy        ,   32,  30.0F,  30.0F, 36);
		metalset(aRegistry, aMetal, aUtilMetal, aMachine, aWooden, MT.Ad                    ,   33, 100.0F, 100.0F, 36);
		metalset(aRegistry, aMetal, aUtilMetal, aMachine, aWooden, MT.Bedrock_HSLA_Alloy    ,   34, 100.0F, 100.0F, 36);
		metalset(aRegistry, aMetal, aUtilMetal, aMachine, aWooden, MT.DraconiumAwakened     ,   36, 100.0F, 100.0F, 36);
		metalset(aRegistry, aMetal, aUtilMetal, aMachine, aWooden, MT.Infinity              ,   50, 100.0F, 100.0F, 36); // 60 is next
	}
	
	private static void crucible(MultiTileEntityRegistry aRegistry, MultiTileEntityBlock aMetal, MultiTileEntityBlock aMetalChips, MultiTileEntityBlock aMetalWires, MultiTileEntityBlock aMachine, MultiTileEntityBlock aWooden, MultiTileEntityBlock aBush, MultiTileEntityBlock aStone, MultiTileEntityBlock aWool, MultiTileEntityBlock aTNT, MultiTileEntityBlock aHive, MultiTileEntityBlock aUtilMetal, MultiTileEntityBlock aUtilStone, MultiTileEntityBlock aUtilWood, MultiTileEntityBlock aUtilWool, OreDictMaterial aMat, Class<? extends TileEntity> aClass) {
		// Crucibles
		aClass = MultiTileEntitySmeltery.class;
		aMat = MT.Stone;                aRegistry.add("Smelting Crucible ("             +aMat.getLocal()+")", "Smelting Crucibles"                  ,  1000,  1022, aClass, aMat.mToolQuality, 16, aStone           , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   5.0F, NBT_RESISTANCE,   5.0F, NBT_RECIPEMAP, RM.CrucibleAlloying , NBT_ENERGY_ACCEPTED, TD.Energy.HU, NBT_ACIDPROOF, F, NBT_HIDDEN, F                 ), "BhB", "ByB", "BBB", 'B', Blocks.stone);
		aMat = MT.STONES.Basalt;        aRegistry.add("Smelting Crucible ("             +aMat.getLocal()+")", "Smelting Crucibles"                  ,  1001,  1022, aClass, aMat.mToolQuality, 16, aStone           , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,  15.0F, NBT_RESISTANCE,  15.0F, NBT_RECIPEMAP, RM.CrucibleAlloying , NBT_ENERGY_ACCEPTED, TD.Energy.HU, NBT_ACIDPROOF, F, NBT_HIDDEN, T                 ), "BhB", "ByB", "BBB", 'B', OP.stone.dat(aMat));
		aMat = MT.STONES.GraniteBlack;  aRegistry.add("Smelting Crucible ("             +aMat.getLocal()+")", "Smelting Crucibles"                  ,  1002,  1022, aClass, aMat.mToolQuality, 16, aStone           , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,  15.0F, NBT_RESISTANCE,  15.0F, NBT_RECIPEMAP, RM.CrucibleAlloying , NBT_ENERGY_ACCEPTED, TD.Energy.HU, NBT_ACIDPROOF, F, NBT_HIDDEN, T                 ), "BhB", "ByB", "BBB", 'B', OP.stone.dat(aMat));
		aMat = MT.STONES.GraniteRed;    aRegistry.add("Smelting Crucible ("             +aMat.getLocal()+")", "Smelting Crucibles"                  ,  1003,  1022, aClass, aMat.mToolQuality, 16, aStone           , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,  15.0F, NBT_RESISTANCE,  15.0F, NBT_RECIPEMAP, RM.CrucibleAlloying , NBT_ENERGY_ACCEPTED, TD.Energy.HU, NBT_ACIDPROOF, F, NBT_HIDDEN, T                 ), "BhB", "ByB", "BBB", 'B', OP.stone.dat(aMat));
		aMat = MT.NetherBrick;          aRegistry.add("Smelting Crucible ("             +aMat.getLocal()+")", "Smelting Crucibles"                  ,  1004,  1022, aClass, aMat.mToolQuality, 16, aStone           , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   5.0F, NBT_RESISTANCE,   5.0F, NBT_RECIPEMAP, RM.CrucibleAlloying , NBT_ENERGY_ACCEPTED, TD.Energy.HU, NBT_ACIDPROOF, F, NBT_HIDDEN, T                 ), "BhB", "ByB", "BBB", 'B', OP.stone.dat(aMat));
		aMat = MT.Ceramic;              aRegistry.add("Smelting Crucible ("             +aMat.getLocal()+")", "Smelting Crucibles"                  ,  1005,  1022, aClass, aMat.mToolQuality, 16, aStone           , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   5.0F, NBT_RESISTANCE,   5.0F, NBT_RECIPEMAP, RM.CrucibleAlloying , NBT_ENERGY_ACCEPTED, TD.Energy.HU, NBT_ACIDPROOF, F, NBT_HIDDEN, F                 )); IL.Ceramic_Crucible.set(aRegistry.getItem(), new OreDictItemData(MT.Ceramic, U*7)); RM.add_smelting(IL.Ceramic_Crucible_Raw.get(1), IL.Ceramic_Crucible.get(1), F, F, T);
		aMat = MT.STONES.Umber;         aRegistry.add("Smelting Crucible ("             +aMat.getLocal()+")", "Smelting Crucibles"                  ,  1006,  1022, aClass, aMat.mToolQuality, 16, aStone           , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   5.0F, NBT_RESISTANCE,   5.0F, NBT_RECIPEMAP, RM.CrucibleAlloying , NBT_ENERGY_ACCEPTED, TD.Energy.HU, NBT_ACIDPROOF, F, NBT_HIDDEN, !MD.ERE   .mLoaded), "BhB", "ByB", "BBB", 'B', OP.stone.dat(aMat));
		aMat = MT.STONES.Livingrock;    aRegistry.add("Smelting Crucible ("             +aMat.getLocal()+")", "Smelting Crucibles"                  ,  1007,  1022, aClass, aMat.mToolQuality, 16, aStone           , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   5.0F, NBT_RESISTANCE,   5.0F, NBT_RECIPEMAP, RM.CrucibleAlloying , NBT_ENERGY_ACCEPTED, TD.Energy.HU, NBT_ACIDPROOF, F, NBT_HIDDEN, !MD.BOTA  .mLoaded), "BhB", "ByB", "BBB", 'B', OP.stone.dat(aMat));
		aMat = MT.STONES.Holystone;     aRegistry.add("Smelting Crucible ("             +aMat.getLocal()+")", "Smelting Crucibles"                  ,  1008,  1022, aClass, aMat.mToolQuality, 16, aStone           , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   5.0F, NBT_RESISTANCE,   5.0F, NBT_RECIPEMAP, RM.CrucibleAlloying , NBT_ENERGY_ACCEPTED, TD.Energy.HU, NBT_ACIDPROOF, F, NBT_HIDDEN, !MD.AETHER.mLoaded), "BhB", "ByB", "BBB", 'B', OP.stone.dat(aMat));
		aMat = MT.STONES.Betweenstone;  aRegistry.add("Smelting Crucible ("             +aMat.getLocal()+")", "Smelting Crucibles"                  ,  1009,  1022, aClass, aMat.mToolQuality, 16, aStone           , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   5.0F, NBT_RESISTANCE,   5.0F, NBT_RECIPEMAP, RM.CrucibleAlloying , NBT_ENERGY_ACCEPTED, TD.Energy.HU, NBT_ACIDPROOF, F, NBT_HIDDEN, !MD.BTL   .mLoaded), "BhB", "ByB", "BBB", 'B', OP.stone.dat(aMat));
		
		aMat = ANY.Quartz;              aRegistry.add("Smelting Crucible ("             +aMat.getLocal()+")", "Smelting Crucibles"                  ,  1018,  1022, aClass, aMat.mToolQuality, 16, aStone           , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   5.0F, NBT_RESISTANCE,   5.0F, NBT_RECIPEMAP, RM.CrucibleAlloying , NBT_ENERGY_ACCEPTED, TD.Energy.HU, NBT_ACIDPROOF, F), "BhB", "ByB", "BBB", 'B', OP.gem.dat(ANY.Quartz));
		aMat = MT.C;                    aRegistry.add("Smelting Crucible ("             +aMat.getLocal()+")", "Smelting Crucibles"                  ,  1019,  1022, aClass, aMat.mToolQuality, 16, aStone           , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,  10.0F, NBT_RESISTANCE,  10.0F, NBT_RECIPEMAP, RM.CrucibleAlloying , NBT_ENERGY_ACCEPTED, TD.Energy.HU, NBT_ACIDPROOF, F), "ChC", "CyC", "CCC", 'C', OP.plate.dat(MT.Graphene));
		
		aMat = MT.Bronze;               aRegistry.add("Smelting Crucible ("             +aMat.getLocal()+")", "Smelting Crucibles"                  ,  1020,  1022, aClass, aMat.mToolQuality, 16, aMetal           , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   7.0F, NBT_RESISTANCE,   7.0F, NBT_RECIPEMAP, RM.CrucibleAlloying , NBT_ENERGY_ACCEPTED, TD.Energy.HU, NBT_ACIDPROOF, F), "PhP", "PwP", "PPP", 'P', OP.plate.dat(aMat));
		aMat = MT.Invar;                aRegistry.add("Smelting Crucible ("             +aMat.getLocal()+")", "Smelting Crucibles"                  ,  1021,  1022, aClass, aMat.mToolQuality, 16, aMetal           , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_RECIPEMAP, RM.CrucibleAlloying , NBT_ENERGY_ACCEPTED, TD.Energy.HU, NBT_ACIDPROOF, F), "PhP", "PwP", "PPP", 'P', OP.plate.dat(aMat));
		aMat = MT.Steel;                aRegistry.add("Smelting Crucible ("             +aMat.getLocal()+")", "Smelting Crucibles"                  ,  1022,  1022, aClass, aMat.mToolQuality, 16, aMetal           , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   6.0F, NBT_RESISTANCE,   6.0F, NBT_RECIPEMAP, RM.CrucibleAlloying , NBT_ENERGY_ACCEPTED, TD.Energy.HU, NBT_ACIDPROOF, F), "PhP", "PwP", "PPP", 'P', OP.plate.dat(aMat));
		aMat = MT.HSLA;                 aRegistry.add("Smelting Crucible ("             +aMat.getLocal()+")", "Smelting Crucibles"                  ,  1041,  1022, aClass, aMat.mToolQuality, 16, aMetal           , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   6.0F, NBT_RESISTANCE,   6.0F, NBT_RECIPEMAP, RM.CrucibleAlloying , NBT_ENERGY_ACCEPTED, TD.Energy.HU, NBT_ACIDPROOF, F), "PhP", "PwP", "PPP", 'P', OP.plate.dat(aMat));
		aMat = MT.StainlessSteel;       aRegistry.add("Smelting Crucible ("             +aMat.getLocal()+")", "Smelting Crucibles"                  ,  1025,  1022, aClass, aMat.mToolQuality, 16, aMetal           , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   6.0F, NBT_RESISTANCE,   6.0F, NBT_RECIPEMAP, RM.CrucibleAlloying , NBT_ENERGY_ACCEPTED, TD.Energy.HU, NBT_ACIDPROOF, T), "PhP", "PwP", "PPP", 'P', OP.plate.dat(aMat));
		aMat = MT.DarkIron;             aRegistry.add("Smelting Crucible ("             +aMat.getLocal()+")", "Smelting Crucibles"                  ,  1026,  1022, aClass, aMat.mToolQuality, 16, aMetal           , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   6.0F, NBT_RESISTANCE,   6.0F, NBT_RECIPEMAP, RM.CrucibleAlloying , NBT_ENERGY_ACCEPTED, TD.Energy.HU, NBT_ACIDPROOF, F), "PhP", "PwP", "PPP", 'P', OP.plate.dat(aMat));
		aMat = MT.MeteoricIron;         aRegistry.add("Smelting Crucible ("             +aMat.getLocal()+")", "Smelting Crucibles"                  ,  1031,  1022, aClass, aMat.mToolQuality, 16, aMetal           , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   6.0F, NBT_RESISTANCE,   6.0F, NBT_RECIPEMAP, RM.CrucibleAlloying , NBT_ENERGY_ACCEPTED, TD.Energy.HU, NBT_ACIDPROOF, F), "PhP", "PwP", "PPP", 'P', OP.plate.dat(aMat));
		aMat = MT.MeteoricSteel;        aRegistry.add("Smelting Crucible ("             +aMat.getLocal()+")", "Smelting Crucibles"                  ,  1032,  1022, aClass, aMat.mToolQuality, 16, aMetal           , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   6.0F, NBT_RESISTANCE,   6.0F, NBT_RECIPEMAP, RM.CrucibleAlloying , NBT_ENERGY_ACCEPTED, TD.Energy.HU, NBT_ACIDPROOF, F), "PhP", "PwP", "PPP", 'P', OP.plate.dat(aMat));
		aMat = MT.Netherite;            aRegistry.add("Smelting Crucible ("             +aMat.getLocal()+")", "Smelting Crucibles"                  ,  1044,  1022, aClass, aMat.mToolQuality, 16, aMetal           , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   6.0F, NBT_RESISTANCE,   6.0F, NBT_RECIPEMAP, RM.CrucibleAlloying , NBT_ENERGY_ACCEPTED, TD.Energy.HU, NBT_ACIDPROOF, T), "PhP", "PwP", "PPP", 'P', OP.plate.dat(aMat));
		aMat = MT.Knightmetal;          aRegistry.add("Smelting Crucible ("             +aMat.getLocal()+")", "Smelting Crucibles"                  ,  1027,  1022, aClass, aMat.mToolQuality, 16, aMetal           , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   6.0F, NBT_RESISTANCE,   6.0F, NBT_RECIPEMAP, RM.CrucibleAlloying , NBT_ENERGY_ACCEPTED, TD.Energy.HU, NBT_ACIDPROOF, F), "PhP", "PwP", "PPP", 'P', OP.plate.dat(aMat));
		aMat = MT.FierySteel;           aRegistry.add("Smelting Crucible ("             +aMat.getLocal()+")", "Smelting Crucibles"                  ,  1028,  1022, aClass, aMat.mToolQuality, 16, aMetal           , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   6.0F, NBT_RESISTANCE,   6.0F, NBT_RECIPEMAP, RM.CrucibleAlloying , NBT_ENERGY_ACCEPTED, TD.Energy.HU, NBT_ACIDPROOF, F), "PhP", "PwP", "PPP", 'P', OP.plate.dat(aMat));
		aMat = MT.Octine;               aRegistry.add("Smelting Crucible ("             +aMat.getLocal()+")", "Smelting Crucibles"                  ,  1042,  1022, aClass, aMat.mToolQuality, 16, aMetal           , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   6.0F, NBT_RESISTANCE,   6.0F, NBT_RECIPEMAP, RM.CrucibleAlloying , NBT_ENERGY_ACCEPTED, TD.Energy.HU, NBT_ACIDPROOF, F), "PhP", "PwP", "PPP", 'P', OP.plate.dat(aMat));
		aMat = MT.Thaumium;             aRegistry.add("Smelting Crucible ("             +aMat.getLocal()+")", "Smelting Crucibles"                  ,  1029,  1022, aClass, aMat.mToolQuality, 16, aMetal           , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   6.0F, NBT_RESISTANCE,   6.0F, NBT_RECIPEMAP, RM.CrucibleAlloying , NBT_ENERGY_ACCEPTED, TD.Energy.HU, NBT_ACIDPROOF, T), "PhP", "PwP", "PPP", 'P', OP.plate.dat(aMat));
		aMat = MT.Ti;                   aRegistry.add("Smelting Crucible ("             +aMat.getLocal()+")", "Smelting Crucibles"                  ,  1023,  1022, aClass, aMat.mToolQuality, 16, aMetal           , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   9.0F, NBT_RESISTANCE,   9.0F, NBT_RECIPEMAP, RM.CrucibleAlloying , NBT_ENERGY_ACCEPTED, TD.Energy.HU, NBT_ACIDPROOF, F), "PhP", "PwP", "PPP", 'P', OP.plate.dat(aMat));
		aMat = MT.Cr;                   aRegistry.add("Smelting Crucible ("             +aMat.getLocal()+")", "Smelting Crucibles"                  ,  1033,  1022, aClass, aMat.mToolQuality, 16, aMetal           , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   9.0F, NBT_RESISTANCE,   9.0F, NBT_RECIPEMAP, RM.CrucibleAlloying , NBT_ENERGY_ACCEPTED, TD.Energy.HU, NBT_ACIDPROOF, T), "PhP", "PwP", "PPP", 'P', OP.plate.dat(aMat));
		aMat = MT.Mo;                   aRegistry.add("Smelting Crucible ("             +aMat.getLocal()+")", "Smelting Crucibles"                  ,  1034,  1022, aClass, aMat.mToolQuality, 16, aMetal           , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   9.0F, NBT_RESISTANCE,   9.0F, NBT_RECIPEMAP, RM.CrucibleAlloying , NBT_ENERGY_ACCEPTED, TD.Energy.HU, NBT_ACIDPROOF, F), "PhP", "PwP", "PPP", 'P', OP.plate.dat(aMat));
		aMat = MT.Nb;                   aRegistry.add("Smelting Crucible ("             +aMat.getLocal()+")", "Smelting Crucibles"                  ,  1035,  1022, aClass, aMat.mToolQuality, 16, aMetal           , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   9.0F, NBT_RESISTANCE,   9.0F, NBT_RECIPEMAP, RM.CrucibleAlloying , NBT_ENERGY_ACCEPTED, TD.Energy.HU, NBT_ACIDPROOF, F), "PhP", "PwP", "PPP", 'P', OP.plate.dat(aMat));
		aMat = MT.Ta;                   aRegistry.add("Smelting Crucible ("             +aMat.getLocal()+")", "Smelting Crucibles"                  ,  1036,  1022, aClass, aMat.mToolQuality, 16, aMetal           , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   9.0F, NBT_RESISTANCE,   9.0F, NBT_RECIPEMAP, RM.CrucibleAlloying , NBT_ENERGY_ACCEPTED, TD.Energy.HU, NBT_ACIDPROOF, F), "PhP", "PwP", "PPP", 'P', OP.plate.dat(aMat));
		aMat = MT.Os;                   aRegistry.add("Smelting Crucible ("             +aMat.getLocal()+")", "Smelting Crucibles"                  ,  1037,  1022, aClass, aMat.mToolQuality, 16, aMetal           , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   9.0F, NBT_RESISTANCE,   9.0F, NBT_RECIPEMAP, RM.CrucibleAlloying , NBT_ENERGY_ACCEPTED, TD.Energy.HU, NBT_ACIDPROOF, F), "PhP", "PwP", "PPP", 'P', OP.plate.dat(aMat));
		aMat = MT.Ir;                   aRegistry.add("Smelting Crucible ("             +aMat.getLocal()+")", "Smelting Crucibles"                  ,  1039,  1022, aClass, aMat.mToolQuality, 16, aMetal           , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   9.0F, NBT_RESISTANCE,   9.0F, NBT_RECIPEMAP, RM.CrucibleAlloying , NBT_ENERGY_ACCEPTED, TD.Energy.HU, NBT_ACIDPROOF, T), "PhP", "PwP", "PPP", 'P', OP.plate.dat(aMat));
		aMat = MT.NiobiumTitanium;      aRegistry.add("Smelting Crucible ("             +aMat.getLocal()+")", "Smelting Crucibles"                  ,  1040,  1022, aClass, aMat.mToolQuality, 16, aMetal           , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   9.0F, NBT_RESISTANCE,   9.0F, NBT_RECIPEMAP, RM.CrucibleAlloying , NBT_ENERGY_ACCEPTED, TD.Energy.HU, NBT_ACIDPROOF, F), "PhP", "PwP", "PPP", 'P', OP.plate.dat(aMat));
		aMat = MT.V;                    aRegistry.add("Smelting Crucible ("             +aMat.getLocal()+")", "Smelting Crucibles"                  ,  1038,  1022, aClass, aMat.mToolQuality, 16, aMetal           , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   9.0F, NBT_RESISTANCE,   9.0F, NBT_RECIPEMAP, RM.CrucibleAlloying , NBT_ENERGY_ACCEPTED, TD.Energy.HU, NBT_ACIDPROOF, F), "PhP", "PwP", "PPP", 'P', OP.plate.dat(aMat));
		aMat = ANY.W;                   aRegistry.add("Smelting Crucible ("             +aMat.getLocal()+")", "Smelting Crucibles"                  ,  1024,  1022, aClass, aMat.mToolQuality, 16, aMetal           , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,  10.0F, NBT_RESISTANCE,  10.0F, NBT_RECIPEMAP, RM.CrucibleAlloying , NBT_ENERGY_ACCEPTED, TD.Energy.HU, NBT_ACIDPROOF, T), "PhP", "PwP", "PPP", 'P', OP.plate.dat(aMat));
		aMat = MT.Ta4HfC5;              aRegistry.add("Smelting Crucible ("             +aMat.getLocal()+")", "Smelting Crucibles"                  ,  1043,  1022, aClass, aMat.mToolQuality, 16, aMetal           , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   9.0F, NBT_RESISTANCE,   9.0F, NBT_RECIPEMAP, RM.CrucibleAlloying , NBT_ENERGY_ACCEPTED, TD.Energy.HU, NBT_ACIDPROOF, F), "PhP", "PwP", "PPP", 'P', OP.plate.dat(aMat));
		aMat = MT.VoidMetal;            aRegistry.add("Smelting Crucible ("             +aMat.getLocal()+")", "Smelting Crucibles"                  ,  1030,  1022, aClass, aMat.mToolQuality, 16, aMetal           , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,  10.0F, NBT_RESISTANCE,  10.0F, NBT_RECIPEMAP, RM.CrucibleAlloying , NBT_ENERGY_ACCEPTED, TD.Energy.HU, NBT_ACIDPROOF, T), "PhP", "PwP", "PPP", 'P', OP.plate.dat(aMat));
		
		aMat = MT.Bedrock_HSLA_Alloy;   aRegistry.add("Smelting Crucible ("             +aMat.getLocal()+")", "Smelting Crucibles"                  ,  1048,  1022, aClass, aMat.mToolQuality, 16, aMetal           , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS, 100.0F, NBT_RESISTANCE, 100.0F, NBT_RECIPEMAP, RM.CrucibleAlloying , NBT_ENERGY_ACCEPTED, TD.Energy.HU, NBT_ACIDPROOF, F), "PhP", "PwP", "PPP", 'P', OP.plate.dat(aMat));
		aMat = MT.Ad;                   aRegistry.add("Smelting Crucible ("             +aMat.getLocal()+")", "Smelting Crucibles"                  ,  1049,  1022, aClass, aMat.mToolQuality, 16, aMetal           , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS, 100.0F, NBT_RESISTANCE, 100.0F, NBT_RECIPEMAP, RM.CrucibleAlloying , NBT_ENERGY_ACCEPTED, TD.Energy.HU, NBT_ACIDPROOF, T), "PhP", "PwP", "PPP", 'P', OP.plate.dat(aMat));
		
		RM.CrucibleSmelting.mRecipeMachineList.addAll(RM.CrucibleAlloying.mRecipeMachineList);
		
		
		
		// Drains
		aClass = MultiTileEntityFaucet.class;
		aMat = MT.Stone;                aRegistry.add("Crucible Faucet ("               +aMat.getLocal()+")", "Crucibles Faucets"                   ,  1700,  1722, aClass, aMat.mToolQuality, 16, aUtilStone       , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   1.0F, NBT_RESISTANCE,   5.0F, NBT_ACIDPROOF, F, NBT_HIDDEN, F                 ), "h y", "B B", " B ", 'B', Blocks.stone);
		aMat = MT.STONES.Basalt;        aRegistry.add("Crucible Faucet ("               +aMat.getLocal()+")", "Crucibles Faucets"                   ,  1701,  1722, aClass, aMat.mToolQuality, 16, aUtilStone       , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   1.0F, NBT_RESISTANCE,   5.0F, NBT_ACIDPROOF, F, NBT_HIDDEN, T                 ), "h y", "B B", " B ", 'B', OP.stone.dat(aMat));
		aMat = MT.STONES.GraniteBlack;  aRegistry.add("Crucible Faucet ("               +aMat.getLocal()+")", "Crucibles Faucets"                   ,  1702,  1722, aClass, aMat.mToolQuality, 16, aUtilStone       , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   1.0F, NBT_RESISTANCE,   5.0F, NBT_ACIDPROOF, F, NBT_HIDDEN, T                 ), "h y", "B B", " B ", 'B', OP.stone.dat(aMat));
		aMat = MT.STONES.GraniteRed;    aRegistry.add("Crucible Faucet ("               +aMat.getLocal()+")", "Crucibles Faucets"                   ,  1703,  1722, aClass, aMat.mToolQuality, 16, aUtilStone       , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   1.0F, NBT_RESISTANCE,   5.0F, NBT_ACIDPROOF, F, NBT_HIDDEN, T                 ), "h y", "B B", " B ", 'B', OP.stone.dat(aMat));
		aMat = MT.NetherBrick;          aRegistry.add("Crucible Faucet ("               +aMat.getLocal()+")", "Crucibles Faucets"                   ,  1704,  1722, aClass, aMat.mToolQuality, 16, aUtilStone       , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   1.0F, NBT_RESISTANCE,   5.0F, NBT_ACIDPROOF, F, NBT_HIDDEN, T                 ), "h y", "B B", " B ", 'B', OP.stone.dat(aMat));
		aMat = MT.Ceramic;              aRegistry.add("Crucible Faucet ("               +aMat.getLocal()+")", "Crucibles Faucets"                   ,  1705,  1722, aClass, aMat.mToolQuality, 16, aUtilStone       , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   1.0F, NBT_RESISTANCE,   5.0F, NBT_ACIDPROOF, F, NBT_HIDDEN, F                 )); IL.Ceramic_Faucet.set(aRegistry.getItem(), new OreDictItemData(MT.Ceramic, U*3)); RM.add_smelting(IL.Ceramic_Faucet_Raw.get(1), IL.Ceramic_Faucet.get(1), F, F, T);
		aMat = MT.STONES.Umber;         aRegistry.add("Crucible Faucet ("               +aMat.getLocal()+")", "Crucibles Faucets"                   ,  1706,  1722, aClass, aMat.mToolQuality, 16, aUtilStone       , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   1.0F, NBT_RESISTANCE,   5.0F, NBT_ACIDPROOF, F, NBT_HIDDEN, !MD.ERE   .mLoaded), "h y", "B B", " B ", 'B', OP.stone.dat(aMat));
		aMat = MT.STONES.Livingrock;    aRegistry.add("Crucible Faucet ("               +aMat.getLocal()+")", "Crucibles Faucets"                   ,  1707,  1722, aClass, aMat.mToolQuality, 16, aUtilStone       , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   1.0F, NBT_RESISTANCE,   5.0F, NBT_ACIDPROOF, F, NBT_HIDDEN, !MD.BOTA  .mLoaded), "h y", "B B", " B ", 'B', OP.stone.dat(aMat));
		aMat = MT.STONES.Holystone;     aRegistry.add("Crucible Faucet ("               +aMat.getLocal()+")", "Crucibles Faucets"                   ,  1708,  1722, aClass, aMat.mToolQuality, 16, aUtilStone       , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   1.0F, NBT_RESISTANCE,   5.0F, NBT_ACIDPROOF, F, NBT_HIDDEN, !MD.AETHER.mLoaded), "h y", "B B", " B ", 'B', OP.stone.dat(aMat));
		aMat = MT.STONES.Betweenstone;  aRegistry.add("Crucible Faucet ("               +aMat.getLocal()+")", "Crucibles Faucets"                   ,  1709,  1722, aClass, aMat.mToolQuality, 16, aUtilStone       , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   1.0F, NBT_RESISTANCE,   5.0F, NBT_ACIDPROOF, F, NBT_HIDDEN, !MD.BTL   .mLoaded), "h y", "B B", " B ", 'B', OP.stone.dat(aMat));
		
		aMat = ANY.Quartz;              aRegistry.add("Crucible Faucet ("               +aMat.getLocal()+")", "Crucibles Faucets"                   ,  1718,  1722, aClass, aMat.mToolQuality, 16, aUtilStone       , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   1.0F, NBT_RESISTANCE,   5.0F, NBT_ACIDPROOF, F), "h y", "B B", " B ", 'B', OP.gem.dat(ANY.Quartz));
		aMat = MT.C;                    aRegistry.add("Crucible Faucet ("               +aMat.getLocal()+")", "Crucibles Faucets"                   ,  1719,  1722, aClass, aMat.mToolQuality, 16, aUtilStone       , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   1.0F, NBT_RESISTANCE,   6.0F, NBT_ACIDPROOF, F), "h y", "C C", " C ", 'C', OP.plate.dat(MT.Graphene));
		
		aMat = MT.Bronze;               aRegistry.add("Crucible Faucet ("               +aMat.getLocal()+")", "Crucibles Faucets"                   ,  1720,  1722, aClass, aMat.mToolQuality, 16, aUtilMetal       , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   1.0F, NBT_RESISTANCE,   6.0F, NBT_ACIDPROOF, F), "h y", "P P", " P ", 'P', OP.plate.dat(aMat));
		aMat = MT.Invar;                aRegistry.add("Crucible Faucet ("               +aMat.getLocal()+")", "Crucibles Faucets"                   ,  1721,  1722, aClass, aMat.mToolQuality, 16, aUtilMetal       , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   1.0F, NBT_RESISTANCE,   6.0F, NBT_ACIDPROOF, F), "h y", "P P", " P ", 'P', OP.plate.dat(aMat));
		aMat = MT.Steel;                aRegistry.add("Crucible Faucet ("               +aMat.getLocal()+")", "Crucibles Faucets"                   ,  1722,  1722, aClass, aMat.mToolQuality, 16, aUtilMetal       , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   1.0F, NBT_RESISTANCE,   6.0F, NBT_ACIDPROOF, F), "h y", "P P", " P ", 'P', OP.plate.dat(aMat));
		aMat = MT.HSLA;                 aRegistry.add("Crucible Faucet ("               +aMat.getLocal()+")", "Crucibles Faucets"                   ,  1741,  1722, aClass, aMat.mToolQuality, 16, aUtilMetal       , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   1.0F, NBT_RESISTANCE,   6.0F, NBT_ACIDPROOF, F), "h y", "P P", " P ", 'P', OP.plate.dat(aMat));
		aMat = MT.StainlessSteel;       aRegistry.add("Crucible Faucet ("               +aMat.getLocal()+")", "Crucibles Faucets"                   ,  1725,  1722, aClass, aMat.mToolQuality, 16, aUtilMetal       , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   1.0F, NBT_RESISTANCE,   6.0F, NBT_ACIDPROOF, T), "h y", "P P", " P ", 'P', OP.plate.dat(aMat));
		aMat = MT.DarkIron;             aRegistry.add("Crucible Faucet ("               +aMat.getLocal()+")", "Crucibles Faucets"                   ,  1726,  1722, aClass, aMat.mToolQuality, 16, aUtilMetal       , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   1.0F, NBT_RESISTANCE,   6.0F, NBT_ACIDPROOF, F), "h y", "P P", " P ", 'P', OP.plate.dat(aMat));
		aMat = MT.MeteoricIron;         aRegistry.add("Crucible Faucet ("               +aMat.getLocal()+")", "Crucibles Faucets"                   ,  1731,  1722, aClass, aMat.mToolQuality, 16, aUtilMetal       , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   1.0F, NBT_RESISTANCE,   6.0F, NBT_ACIDPROOF, F), "h y", "P P", " P ", 'P', OP.plate.dat(aMat));
		aMat = MT.MeteoricSteel;        aRegistry.add("Crucible Faucet ("               +aMat.getLocal()+")", "Crucibles Faucets"                   ,  1732,  1722, aClass, aMat.mToolQuality, 16, aUtilMetal       , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   1.0F, NBT_RESISTANCE,   6.0F, NBT_ACIDPROOF, F), "h y", "P P", " P ", 'P', OP.plate.dat(aMat));
		aMat = MT.Netherite;            aRegistry.add("Crucible Faucet ("               +aMat.getLocal()+")", "Crucibles Faucets"                   ,  1744,  1722, aClass, aMat.mToolQuality, 16, aUtilMetal       , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   1.0F, NBT_RESISTANCE,   6.0F, NBT_ACIDPROOF, T), "h y", "P P", " P ", 'P', OP.plate.dat(aMat));
		aMat = MT.Knightmetal;          aRegistry.add("Crucible Faucet ("               +aMat.getLocal()+")", "Crucibles Faucets"                   ,  1727,  1722, aClass, aMat.mToolQuality, 16, aUtilMetal       , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   1.0F, NBT_RESISTANCE,   6.0F, NBT_ACIDPROOF, F), "h y", "P P", " P ", 'P', OP.plate.dat(aMat));
		aMat = MT.FierySteel;           aRegistry.add("Crucible Faucet ("               +aMat.getLocal()+")", "Crucibles Faucets"                   ,  1728,  1722, aClass, aMat.mToolQuality, 16, aUtilMetal       , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   1.0F, NBT_RESISTANCE,   6.0F, NBT_ACIDPROOF, F), "h y", "P P", " P ", 'P', OP.plate.dat(aMat));
		aMat = MT.Octine;               aRegistry.add("Crucible Faucet ("               +aMat.getLocal()+")", "Crucibles Faucets"                   ,  1742,  1722, aClass, aMat.mToolQuality, 16, aUtilMetal       , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   1.0F, NBT_RESISTANCE,   6.0F, NBT_ACIDPROOF, F), "h y", "P P", " P ", 'P', OP.plate.dat(aMat));
		aMat = MT.Thaumium;             aRegistry.add("Crucible Faucet ("               +aMat.getLocal()+")", "Crucibles Faucets"                   ,  1729,  1722, aClass, aMat.mToolQuality, 16, aUtilMetal       , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   1.0F, NBT_RESISTANCE,   6.0F, NBT_ACIDPROOF, T), "h y", "P P", " P ", 'P', OP.plate.dat(aMat));
		aMat = MT.Ti;                   aRegistry.add("Crucible Faucet ("               +aMat.getLocal()+")", "Crucibles Faucets"                   ,  1723,  1722, aClass, aMat.mToolQuality, 16, aUtilMetal       , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   1.0F, NBT_RESISTANCE,   6.0F, NBT_ACIDPROOF, F), "h y", "P P", " P ", 'P', OP.plate.dat(aMat));
		aMat = MT.Cr;                   aRegistry.add("Crucible Faucet ("               +aMat.getLocal()+")", "Crucibles Faucets"                   ,  1733,  1722, aClass, aMat.mToolQuality, 16, aUtilMetal       , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   1.0F, NBT_RESISTANCE,   6.0F, NBT_ACIDPROOF, T), "h y", "P P", " P ", 'P', OP.plate.dat(aMat));
		aMat = MT.Mo;                   aRegistry.add("Crucible Faucet ("               +aMat.getLocal()+")", "Crucibles Faucets"                   ,  1734,  1722, aClass, aMat.mToolQuality, 16, aUtilMetal       , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   1.0F, NBT_RESISTANCE,   6.0F, NBT_ACIDPROOF, F), "h y", "P P", " P ", 'P', OP.plate.dat(aMat));
		aMat = MT.Nb;                   aRegistry.add("Crucible Faucet ("               +aMat.getLocal()+")", "Crucibles Faucets"                   ,  1735,  1722, aClass, aMat.mToolQuality, 16, aUtilMetal       , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   1.0F, NBT_RESISTANCE,   6.0F, NBT_ACIDPROOF, F), "h y", "P P", " P ", 'P', OP.plate.dat(aMat));
		aMat = MT.Ta;                   aRegistry.add("Crucible Faucet ("               +aMat.getLocal()+")", "Crucibles Faucets"                   ,  1736,  1722, aClass, aMat.mToolQuality, 16, aUtilMetal       , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   1.0F, NBT_RESISTANCE,   6.0F, NBT_ACIDPROOF, F), "h y", "P P", " P ", 'P', OP.plate.dat(aMat));
		aMat = MT.Os;                   aRegistry.add("Crucible Faucet ("               +aMat.getLocal()+")", "Crucibles Faucets"                   ,  1737,  1722, aClass, aMat.mToolQuality, 16, aUtilMetal       , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   1.0F, NBT_RESISTANCE,   6.0F, NBT_ACIDPROOF, F), "h y", "P P", " P ", 'P', OP.plate.dat(aMat));
		aMat = MT.Ir;                   aRegistry.add("Crucible Faucet ("               +aMat.getLocal()+")", "Crucibles Faucets"                   ,  1739,  1722, aClass, aMat.mToolQuality, 16, aUtilMetal       , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   1.0F, NBT_RESISTANCE,   6.0F, NBT_ACIDPROOF, T), "h y", "P P", " P ", 'P', OP.plate.dat(aMat));
		aMat = MT.NiobiumTitanium;      aRegistry.add("Crucible Faucet ("               +aMat.getLocal()+")", "Crucibles Faucets"                   ,  1740,  1722, aClass, aMat.mToolQuality, 16, aUtilMetal       , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   1.0F, NBT_RESISTANCE,   6.0F, NBT_ACIDPROOF, F), "h y", "P P", " P ", 'P', OP.plate.dat(aMat));
		aMat = MT.V;                    aRegistry.add("Crucible Faucet ("               +aMat.getLocal()+")", "Crucibles Faucets"                   ,  1738,  1722, aClass, aMat.mToolQuality, 16, aUtilMetal       , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   1.0F, NBT_RESISTANCE,   6.0F, NBT_ACIDPROOF, F), "h y", "P P", " P ", 'P', OP.plate.dat(aMat));
		aMat = ANY.W;                   aRegistry.add("Crucible Faucet ("               +aMat.getLocal()+")", "Crucibles Faucets"                   ,  1724,  1722, aClass, aMat.mToolQuality, 16, aUtilMetal       , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   1.0F, NBT_RESISTANCE,   6.0F, NBT_ACIDPROOF, T), "h y", "P P", " P ", 'P', OP.plate.dat(aMat));
		aMat = MT.Ta4HfC5;              aRegistry.add("Crucible Faucet ("               +aMat.getLocal()+")", "Crucibles Faucets"                   ,  1743,  1722, aClass, aMat.mToolQuality, 16, aUtilMetal       , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   1.0F, NBT_RESISTANCE,   6.0F, NBT_ACIDPROOF, F), "h y", "P P", " P ", 'P', OP.plate.dat(aMat));
		aMat = MT.VoidMetal;            aRegistry.add("Crucible Faucet ("               +aMat.getLocal()+")", "Crucibles Faucets"                   ,  1730,  1722, aClass, aMat.mToolQuality, 16, aUtilMetal       , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   1.0F, NBT_RESISTANCE,   6.0F, NBT_ACIDPROOF, T), "h y", "P P", " P ", 'P', OP.plate.dat(aMat));
		
		aMat = MT.Bedrock_HSLA_Alloy;   aRegistry.add("Crucible Faucet ("               +aMat.getLocal()+")", "Crucibles Faucets"                   ,  1748,  1722, aClass, aMat.mToolQuality, 16, aUtilMetal       , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   1.0F, NBT_RESISTANCE,   6.0F, NBT_ACIDPROOF, F), "h y", "P P", " P ", 'P', OP.plate.dat(aMat));
		aMat = MT.Ad;                   aRegistry.add("Crucible Faucet ("               +aMat.getLocal()+")", "Crucibles Faucets"                   ,  1749,  1722, aClass, aMat.mToolQuality, 16, aUtilMetal       , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   1.0F, NBT_RESISTANCE,   6.0F, NBT_ACIDPROOF, T), "h y", "P P", " P ", 'P', OP.plate.dat(aMat));
		
		
		
		// Molds
		aClass = MultiTileEntityMold.class;
		aMat = MT.Stone;                aRegistry.add("Mold ("                          +aMat.getLocal()+")", "Molds"                               ,  1050,  1072, aClass, aMat.mToolQuality, 16, aUtilStone       , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   1.0F, NBT_RESISTANCE,   5.0F, NBT_ACIDPROOF, F, NBT_HIDDEN, F                 ), "h y", "B B", "BBB", 'B', Blocks.stone);
		aMat = MT.STONES.Basalt;        aRegistry.add("Mold ("                          +aMat.getLocal()+")", "Molds"                               ,  1051,  1072, aClass, aMat.mToolQuality, 16, aUtilStone       , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   1.0F, NBT_RESISTANCE,   5.0F, NBT_ACIDPROOF, F, NBT_HIDDEN, T                 ), "h y", "B B", "BBB", 'B', OP.stone.dat(aMat));
		aMat = MT.STONES.GraniteBlack;  aRegistry.add("Mold ("                          +aMat.getLocal()+")", "Molds"                               ,  1052,  1072, aClass, aMat.mToolQuality, 16, aUtilStone       , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   1.0F, NBT_RESISTANCE,   5.0F, NBT_ACIDPROOF, F, NBT_HIDDEN, T                 ), "h y", "B B", "BBB", 'B', OP.stone.dat(aMat));
		aMat = MT.STONES.GraniteRed;    aRegistry.add("Mold ("                          +aMat.getLocal()+")", "Molds"                               ,  1053,  1072, aClass, aMat.mToolQuality, 16, aUtilStone       , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   1.0F, NBT_RESISTANCE,   5.0F, NBT_ACIDPROOF, F, NBT_HIDDEN, T                 ), "h y", "B B", "BBB", 'B', OP.stone.dat(aMat));
		aMat = MT.NetherBrick;          aRegistry.add("Mold ("                          +aMat.getLocal()+")", "Molds"                               ,  1054,  1072, aClass, aMat.mToolQuality, 16, aUtilStone       , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   1.0F, NBT_RESISTANCE,   5.0F, NBT_ACIDPROOF, F, NBT_HIDDEN, T                 ), "h y", "B B", "BBB", 'B', OP.stone.dat(aMat));
		aMat = MT.Ceramic;              aRegistry.add("Mold ("                          +aMat.getLocal()+")", "Molds"                               ,  1055,  1072, aClass, aMat.mToolQuality, 16, aUtilStone       , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   1.0F, NBT_RESISTANCE,   5.0F, NBT_ACIDPROOF, F, NBT_HIDDEN, F                 )); IL.Ceramic_Mold.set(aRegistry.getItem(), new OreDictItemData(MT.Ceramic, U*5)); RM.add_smelting(IL.Ceramic_Mold_Raw.get(1), IL.Ceramic_Mold.get(1), F, F, T);
		aMat = MT.STONES.Umber;         aRegistry.add("Mold ("                          +aMat.getLocal()+")", "Molds"                               ,  1056,  1072, aClass, aMat.mToolQuality, 16, aUtilStone       , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   1.0F, NBT_RESISTANCE,   5.0F, NBT_ACIDPROOF, F, NBT_HIDDEN, !MD.ERE   .mLoaded), "h y", "B B", "BBB", 'B', OP.stone.dat(aMat));
		aMat = MT.STONES.Livingrock;    aRegistry.add("Mold ("                          +aMat.getLocal()+")", "Molds"                               ,  1057,  1072, aClass, aMat.mToolQuality, 16, aUtilStone       , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   1.0F, NBT_RESISTANCE,   5.0F, NBT_ACIDPROOF, F, NBT_HIDDEN, !MD.BOTA  .mLoaded), "h y", "B B", "BBB", 'B', OP.stone.dat(aMat));
		aMat = MT.STONES.Holystone;     aRegistry.add("Mold ("                          +aMat.getLocal()+")", "Molds"                               ,  1058,  1072, aClass, aMat.mToolQuality, 16, aUtilStone       , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   1.0F, NBT_RESISTANCE,   5.0F, NBT_ACIDPROOF, F, NBT_HIDDEN, !MD.AETHER.mLoaded), "h y", "B B", "BBB", 'B', OP.stone.dat(aMat));
		aMat = MT.STONES.Betweenstone;  aRegistry.add("Mold ("                          +aMat.getLocal()+")", "Molds"                               ,  1059,  1072, aClass, aMat.mToolQuality, 16, aUtilStone       , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   1.0F, NBT_RESISTANCE,   5.0F, NBT_ACIDPROOF, F, NBT_HIDDEN, !MD.BTL   .mLoaded), "h y", "B B", "BBB", 'B', OP.stone.dat(aMat));
		
		aMat = ANY.Quartz;              aRegistry.add("Mold ("                          +aMat.getLocal()+")", "Molds"                               ,  1068,  1072, aClass, aMat.mToolQuality, 16, aUtilStone       , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   1.0F, NBT_RESISTANCE,   5.0F, NBT_ACIDPROOF, F), "h y", "B B", "BBB", 'B', OP.gem.dat(ANY.Quartz));
		aMat = MT.C;                    aRegistry.add("Mold ("                          +aMat.getLocal()+")", "Molds"                               ,  1069,  1072, aClass, aMat.mToolQuality, 16, aUtilStone       , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   1.0F, NBT_RESISTANCE,   6.0F, NBT_ACIDPROOF, F), "h y", "C C", "CCC", 'C', OP.plate.dat(MT.Graphene));
		
		aMat = MT.Bronze;               aRegistry.add("Mold ("                          +aMat.getLocal()+")", "Molds"                               ,  1070,  1072, aClass, aMat.mToolQuality, 16, aUtilMetal       , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   1.0F, NBT_RESISTANCE,   6.0F, NBT_ACIDPROOF, F), "h y", "P P", "PPP", 'P', OP.plate.dat(aMat));
		aMat = MT.Invar;                aRegistry.add("Mold ("                          +aMat.getLocal()+")", "Molds"                               ,  1071,  1072, aClass, aMat.mToolQuality, 16, aUtilMetal       , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   1.0F, NBT_RESISTANCE,   6.0F, NBT_ACIDPROOF, F), "h y", "P P", "PPP", 'P', OP.plate.dat(aMat));
		aMat = MT.Steel;                aRegistry.add("Mold ("                          +aMat.getLocal()+")", "Molds"                               ,  1072,  1072, aClass, aMat.mToolQuality, 16, aUtilMetal       , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   1.0F, NBT_RESISTANCE,   6.0F, NBT_ACIDPROOF, F), "h y", "P P", "PPP", 'P', OP.plate.dat(aMat));
		aMat = MT.HSLA;                 aRegistry.add("Mold ("                          +aMat.getLocal()+")", "Molds"                               ,  1091,  1072, aClass, aMat.mToolQuality, 16, aUtilMetal       , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   1.0F, NBT_RESISTANCE,   6.0F, NBT_ACIDPROOF, F), "h y", "P P", "PPP", 'P', OP.plate.dat(aMat));
		aMat = MT.StainlessSteel;       aRegistry.add("Mold ("                          +aMat.getLocal()+")", "Molds"                               ,  1075,  1072, aClass, aMat.mToolQuality, 16, aUtilMetal       , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   1.0F, NBT_RESISTANCE,   6.0F, NBT_ACIDPROOF, T), "h y", "P P", "PPP", 'P', OP.plate.dat(aMat));
		aMat = MT.DarkIron;             aRegistry.add("Mold ("                          +aMat.getLocal()+")", "Molds"                               ,  1076,  1072, aClass, aMat.mToolQuality, 16, aUtilMetal       , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   1.0F, NBT_RESISTANCE,   6.0F, NBT_ACIDPROOF, F), "h y", "P P", "PPP", 'P', OP.plate.dat(aMat));
		aMat = MT.MeteoricIron;         aRegistry.add("Mold ("                          +aMat.getLocal()+")", "Molds"                               ,  1081,  1072, aClass, aMat.mToolQuality, 16, aUtilMetal       , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   1.0F, NBT_RESISTANCE,   6.0F, NBT_ACIDPROOF, F), "h y", "P P", "PPP", 'P', OP.plate.dat(aMat));
		aMat = MT.MeteoricSteel;        aRegistry.add("Mold ("                          +aMat.getLocal()+")", "Molds"                               ,  1082,  1072, aClass, aMat.mToolQuality, 16, aUtilMetal       , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   1.0F, NBT_RESISTANCE,   6.0F, NBT_ACIDPROOF, F), "h y", "P P", "PPP", 'P', OP.plate.dat(aMat));
		aMat = MT.Netherite;            aRegistry.add("Mold ("                          +aMat.getLocal()+")", "Molds"                               ,  1094,  1072, aClass, aMat.mToolQuality, 16, aUtilMetal       , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   1.0F, NBT_RESISTANCE,   6.0F, NBT_ACIDPROOF, T), "h y", "P P", "PPP", 'P', OP.plate.dat(aMat));
		aMat = MT.Knightmetal;          aRegistry.add("Mold ("                          +aMat.getLocal()+")", "Molds"                               ,  1077,  1072, aClass, aMat.mToolQuality, 16, aUtilMetal       , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   1.0F, NBT_RESISTANCE,   6.0F, NBT_ACIDPROOF, F), "h y", "P P", "PPP", 'P', OP.plate.dat(aMat));
		aMat = MT.FierySteel;           aRegistry.add("Mold ("                          +aMat.getLocal()+")", "Molds"                               ,  1078,  1072, aClass, aMat.mToolQuality, 16, aUtilMetal       , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   1.0F, NBT_RESISTANCE,   6.0F, NBT_ACIDPROOF, F), "h y", "P P", "PPP", 'P', OP.plate.dat(aMat));
		aMat = MT.Octine;               aRegistry.add("Mold ("                          +aMat.getLocal()+")", "Molds"                               ,  1092,  1072, aClass, aMat.mToolQuality, 16, aUtilMetal       , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   1.0F, NBT_RESISTANCE,   6.0F, NBT_ACIDPROOF, F), "h y", "P P", "PPP", 'P', OP.plate.dat(aMat));
		aMat = MT.Thaumium;             aRegistry.add("Mold ("                          +aMat.getLocal()+")", "Molds"                               ,  1079,  1072, aClass, aMat.mToolQuality, 16, aUtilMetal       , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   1.0F, NBT_RESISTANCE,   6.0F, NBT_ACIDPROOF, T), "h y", "P P", "PPP", 'P', OP.plate.dat(aMat));
		aMat = MT.Ti;                   aRegistry.add("Mold ("                          +aMat.getLocal()+")", "Molds"                               ,  1073,  1072, aClass, aMat.mToolQuality, 16, aUtilMetal       , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   1.0F, NBT_RESISTANCE,   6.0F, NBT_ACIDPROOF, F), "h y", "P P", "PPP", 'P', OP.plate.dat(aMat));
		aMat = MT.Cr;                   aRegistry.add("Mold ("                          +aMat.getLocal()+")", "Molds"                               ,  1083,  1072, aClass, aMat.mToolQuality, 16, aUtilMetal       , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   1.0F, NBT_RESISTANCE,   6.0F, NBT_ACIDPROOF, T), "h y", "P P", "PPP", 'P', OP.plate.dat(aMat));
		aMat = MT.Mo;                   aRegistry.add("Mold ("                          +aMat.getLocal()+")", "Molds"                               ,  1084,  1072, aClass, aMat.mToolQuality, 16, aUtilMetal       , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   1.0F, NBT_RESISTANCE,   6.0F, NBT_ACIDPROOF, F), "h y", "P P", "PPP", 'P', OP.plate.dat(aMat));
		aMat = MT.Nb;                   aRegistry.add("Mold ("                          +aMat.getLocal()+")", "Molds"                               ,  1085,  1072, aClass, aMat.mToolQuality, 16, aUtilMetal       , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   1.0F, NBT_RESISTANCE,   6.0F, NBT_ACIDPROOF, F), "h y", "P P", "PPP", 'P', OP.plate.dat(aMat));
		aMat = MT.Ta;                   aRegistry.add("Mold ("                          +aMat.getLocal()+")", "Molds"                               ,  1086,  1072, aClass, aMat.mToolQuality, 16, aUtilMetal       , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   1.0F, NBT_RESISTANCE,   6.0F, NBT_ACIDPROOF, F), "h y", "P P", "PPP", 'P', OP.plate.dat(aMat));
		aMat = MT.Os;                   aRegistry.add("Mold ("                          +aMat.getLocal()+")", "Molds"                               ,  1087,  1072, aClass, aMat.mToolQuality, 16, aUtilMetal       , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   1.0F, NBT_RESISTANCE,   6.0F, NBT_ACIDPROOF, F), "h y", "P P", "PPP", 'P', OP.plate.dat(aMat));
		aMat = MT.Ir;                   aRegistry.add("Mold ("                          +aMat.getLocal()+")", "Molds"                               ,  1089,  1072, aClass, aMat.mToolQuality, 16, aUtilMetal       , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   1.0F, NBT_RESISTANCE,   6.0F, NBT_ACIDPROOF, T), "h y", "P P", "PPP", 'P', OP.plate.dat(aMat));
		aMat = MT.NiobiumTitanium;      aRegistry.add("Mold ("                          +aMat.getLocal()+")", "Molds"                               ,  1090,  1072, aClass, aMat.mToolQuality, 16, aUtilMetal       , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   1.0F, NBT_RESISTANCE,   6.0F, NBT_ACIDPROOF, F), "h y", "P P", "PPP", 'P', OP.plate.dat(aMat));
		aMat = MT.V;                    aRegistry.add("Mold ("                          +aMat.getLocal()+")", "Molds"                               ,  1088,  1072, aClass, aMat.mToolQuality, 16, aUtilMetal       , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   1.0F, NBT_RESISTANCE,   6.0F, NBT_ACIDPROOF, F), "h y", "P P", "PPP", 'P', OP.plate.dat(aMat));
		aMat = ANY.W;                   aRegistry.add("Mold ("                          +aMat.getLocal()+")", "Molds"                               ,  1074,  1072, aClass, aMat.mToolQuality, 16, aUtilMetal       , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   1.0F, NBT_RESISTANCE,   6.0F, NBT_ACIDPROOF, T), "h y", "P P", "PPP", 'P', OP.plate.dat(aMat));
		aMat = MT.Ta4HfC5;              aRegistry.add("Mold ("                          +aMat.getLocal()+")", "Molds"                               ,  1093,  1072, aClass, aMat.mToolQuality, 16, aUtilMetal       , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   1.0F, NBT_RESISTANCE,   6.0F, NBT_ACIDPROOF, F), "h y", "P P", "PPP", 'P', OP.plate.dat(aMat));
		aMat = MT.VoidMetal;            aRegistry.add("Mold ("                          +aMat.getLocal()+")", "Molds"                               ,  1080,  1072, aClass, aMat.mToolQuality, 16, aUtilMetal       , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   1.0F, NBT_RESISTANCE,   6.0F, NBT_ACIDPROOF, T), "h y", "P P", "PPP", 'P', OP.plate.dat(aMat));
		
		aMat = MT.Bedrock_HSLA_Alloy;   aRegistry.add("Mold ("                          +aMat.getLocal()+")", "Molds"                               ,  1098,  1072, aClass, aMat.mToolQuality, 16, aUtilMetal       , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   1.0F, NBT_RESISTANCE,   6.0F, NBT_ACIDPROOF, F), "h y", "P P", "PPP", 'P', OP.plate.dat(aMat));
		aMat = MT.Ad;                   aRegistry.add("Mold ("                          +aMat.getLocal()+")", "Molds"                               ,  1099,  1072, aClass, aMat.mToolQuality, 16, aUtilMetal       , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   1.0F, NBT_RESISTANCE,   6.0F, NBT_ACIDPROOF, T), "h y", "P P", "PPP", 'P', OP.plate.dat(aMat));
		
		
		RM.add_smelting(IL.Ceramic_Ingot_Mold_Raw          .get(1), IL.Ceramic_Mold.getWithNBT(1, UT.NBT.make("gt.mold", 0b0_01110_01110_01110_01110_01110)), F, F, T);
		RM.add_smelting(IL.Ceramic_Billet_Mold_Raw         .get(1), IL.Ceramic_Mold.getWithNBT(1, UT.NBT.make("gt.mold", 0b0_01100_11110_11110_01100_00000)), F, F, T);
		RM.add_smelting(IL.Ceramic_Chunk_Mold_Raw          .get(1), IL.Ceramic_Mold.getWithNBT(1, UT.NBT.make("gt.mold", 0b0_11000_11000_00000_00000_00000)), F, F, T);
		RM.add_smelting(IL.Ceramic_Plate_Mold_Raw          .get(1), IL.Ceramic_Mold.getWithNBT(1, UT.NBT.make("gt.mold", 0b0_11111_11111_11111_11111_11111)), F, F, T);
		RM.add_smelting(IL.Ceramic_Tiny_Plate_Mold_Raw     .get(1), IL.Ceramic_Mold.getWithNBT(1, UT.NBT.make("gt.mold", 0b0_00000_01110_01110_01110_00000)), F, F, T);
		RM.add_smelting(IL.Ceramic_Bolt_Mold_Raw           .get(1), IL.Ceramic_Mold.getWithNBT(1, UT.NBT.make("gt.mold", 0b0_00000_00000_00100_00100_00000)), F, F, T);
		RM.add_smelting(IL.Ceramic_Rod_Mold_Raw            .get(1), IL.Ceramic_Mold.getWithNBT(1, UT.NBT.make("gt.mold", 0b0_00000_00000_11111_00000_00000)), F, F, T);
		RM.add_smelting(IL.Ceramic_Long_Rod_Mold_Raw       .get(1), IL.Ceramic_Mold.getWithNBT(1, UT.NBT.make("gt.mold", 0b0_10000_01000_00100_00010_00001)), F, F, T);
		RM.add_smelting(IL.Ceramic_Item_Casing_Mold_Raw    .get(1), IL.Ceramic_Mold.getWithNBT(1, UT.NBT.make("gt.mold", 0b0_11101_11101_11101_00001_11100)), F, F, T);
		RM.add_smelting(IL.Ceramic_Ring_Mold_Raw           .get(1), IL.Ceramic_Mold.getWithNBT(1, UT.NBT.make("gt.mold", 0b0_00000_01110_01010_01110_00000)), F, F, T);
		RM.add_smelting(IL.Ceramic_Gear_Mold_Raw           .get(1), IL.Ceramic_Mold.getWithNBT(1, UT.NBT.make("gt.mold", 0b0_10101_01110_11011_01110_10101)), F, F, T);
		RM.add_smelting(IL.Ceramic_Small_Gear_Mold_Raw     .get(1), IL.Ceramic_Mold.getWithNBT(1, UT.NBT.make("gt.mold", 0b0_01010_11111_01010_11111_01010)), F, F, T);
		RM.add_smelting(IL.Ceramic_Sword_Mold_Raw          .get(1), IL.Ceramic_Mold.getWithNBT(1, UT.NBT.make("gt.mold", 0b0_00100_01110_01110_01110_01110)), F, F, T);
		RM.add_smelting(IL.Ceramic_Pickaxe_Mold_Raw        .get(1), IL.Ceramic_Mold.getWithNBT(1, UT.NBT.make("gt.mold", 0b0_00000_01110_10001_00000_00000)), F, F, T);
		RM.add_smelting(IL.Ceramic_Spade_Mold_Raw          .get(1), IL.Ceramic_Mold.getWithNBT(1, UT.NBT.make("gt.mold", 0b0_01110_01110_01110_01010_00000)), F, F, T);
		RM.add_smelting(IL.Ceramic_Shovel_Mold_Raw         .get(1), IL.Ceramic_Mold.getWithNBT(1, UT.NBT.make("gt.mold", 0b0_00100_01110_01110_01110_00000)), F, F, T);
		RM.add_smelting(IL.Ceramic_Universal_Spade_Mold_Raw.get(1), IL.Ceramic_Mold.getWithNBT(1, UT.NBT.make("gt.mold", 0b0_00100_01110_01100_01110_00000)), F, F, T);
		RM.add_smelting(IL.Ceramic_Axe_Mold_Raw            .get(1), IL.Ceramic_Mold.getWithNBT(1, UT.NBT.make("gt.mold", 0b0_00000_01110_01110_01000_00000)), F, F, T);
		RM.add_smelting(IL.Ceramic_Double_Axe_Mold_Raw     .get(1), IL.Ceramic_Mold.getWithNBT(1, UT.NBT.make("gt.mold", 0b0_00000_11111_11111_10001_00000)), F, F, T);
		RM.add_smelting(IL.Ceramic_Saw_Mold_Raw            .get(1), IL.Ceramic_Mold.getWithNBT(1, UT.NBT.make("gt.mold", 0b0_00000_11111_11111_00000_00000)), F, F, T);
		RM.add_smelting(IL.Ceramic_Hammer_Mold_Raw         .get(1), IL.Ceramic_Mold.getWithNBT(1, UT.NBT.make("gt.mold", 0b0_01110_01110_01010_01110_01110)), F, F, T);
		RM.add_smelting(IL.Ceramic_File_Mold_Raw           .get(1), IL.Ceramic_Mold.getWithNBT(1, UT.NBT.make("gt.mold", 0b0_01110_01110_01110_00100_00100)), F, F, T);
		RM.add_smelting(IL.Ceramic_Screwdriver_Mold_Raw    .get(1), IL.Ceramic_Mold.getWithNBT(1, UT.NBT.make("gt.mold", 0b0_00000_00100_00100_00100_00100)), F, F, T);
		RM.add_smelting(IL.Ceramic_Chisel_Mold_Raw         .get(1), IL.Ceramic_Mold.getWithNBT(1, UT.NBT.make("gt.mold", 0b0_01110_00100_00100_00100_00100)), F, F, T);
		RM.add_smelting(IL.Ceramic_Arrow_Mold_Raw          .get(1), IL.Ceramic_Mold.getWithNBT(1, UT.NBT.make("gt.mold", 0b0_00000_00100_00100_01110_00000)), F, F, T);
		RM.add_smelting(IL.Ceramic_Hoe_Mold_Raw            .get(1), IL.Ceramic_Mold.getWithNBT(1, UT.NBT.make("gt.mold", 0b0_00000_00110_01110_00000_00000)), F, F, T);
		RM.add_smelting(IL.Ceramic_Sense_Mold_Raw          .get(1), IL.Ceramic_Mold.getWithNBT(1, UT.NBT.make("gt.mold", 0b0_00000_01111_11111_00000_00000)), F, F, T);
		RM.add_smelting(IL.Ceramic_Plow_Mold_Raw           .get(1), IL.Ceramic_Mold.getWithNBT(1, UT.NBT.make("gt.mold", 0b0_11111_11111_11111_11111_00100)), F, F, T);
		RM.add_smelting(IL.Ceramic_Builderwand_Mold_Raw    .get(1), IL.Ceramic_Mold.getWithNBT(1, UT.NBT.make("gt.mold", 0b0_00000_00100_11111_01110_01010)), F, F, T);
		RM.add_smelting(IL.Ceramic_Nugget_Mold_Raw         .get(1), IL.Ceramic_Mold.getWithNBT(1, UT.NBT.make("gt.mold", 0b0_00000_00000_00100_00000_00000)), F, F, T);
		
		
		// Basins
		aClass = MultiTileEntityBasin.class;
		aMat = MT.Stone;                aRegistry.add("Basin ("                         +aMat.getLocal()+")", "Molds"                               ,  1750,  1072, aClass, aMat.mToolQuality, 16, aStone           , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   5.0F, NBT_RESISTANCE,   5.0F, NBT_ACIDPROOF, F, NBT_HIDDEN, F                 ), "BhB", "ByB", " B ", 'B', Blocks.stone);
		aMat = MT.STONES.Basalt;        aRegistry.add("Basin ("                         +aMat.getLocal()+")", "Molds"                               ,  1751,  1072, aClass, aMat.mToolQuality, 16, aStone           , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,  15.0F, NBT_RESISTANCE,  15.0F, NBT_ACIDPROOF, F, NBT_HIDDEN, T                 ), "BhB", "ByB", " B ", 'B', OP.stone.dat(aMat));
		aMat = MT.STONES.GraniteBlack;  aRegistry.add("Basin ("                         +aMat.getLocal()+")", "Molds"                               ,  1752,  1072, aClass, aMat.mToolQuality, 16, aStone           , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,  15.0F, NBT_RESISTANCE,  15.0F, NBT_ACIDPROOF, F, NBT_HIDDEN, T                 ), "BhB", "ByB", " B ", 'B', OP.stone.dat(aMat));
		aMat = MT.STONES.GraniteRed;    aRegistry.add("Basin ("                         +aMat.getLocal()+")", "Molds"                               ,  1753,  1072, aClass, aMat.mToolQuality, 16, aStone           , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,  15.0F, NBT_RESISTANCE,  15.0F, NBT_ACIDPROOF, F, NBT_HIDDEN, T                 ), "BhB", "ByB", " B ", 'B', OP.stone.dat(aMat));
		aMat = MT.NetherBrick;          aRegistry.add("Basin ("                         +aMat.getLocal()+")", "Molds"                               ,  1754,  1072, aClass, aMat.mToolQuality, 16, aStone           , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   5.0F, NBT_RESISTANCE,   5.0F, NBT_ACIDPROOF, F, NBT_HIDDEN, T                 ), "BhB", "ByB", " B ", 'B', OP.stone.dat(aMat));
		aMat = MT.Ceramic;              aRegistry.add("Basin ("                         +aMat.getLocal()+")", "Molds"                               ,  1755,  1072, aClass, aMat.mToolQuality, 16, aStone           , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   5.0F, NBT_RESISTANCE,   5.0F, NBT_ACIDPROOF, F, NBT_HIDDEN, F                 )); IL.Ceramic_Basin.set(aRegistry.getItem(), new OreDictItemData(MT.Ceramic, U*5)); RM.add_smelting(IL.Ceramic_Basin_Raw.get(1), IL.Ceramic_Basin.get(1), F, F, T);
		aMat = MT.STONES.Umber;         aRegistry.add("Basin ("                         +aMat.getLocal()+")", "Molds"                               ,  1756,  1072, aClass, aMat.mToolQuality, 16, aStone           , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   5.0F, NBT_RESISTANCE,   5.0F, NBT_ACIDPROOF, F, NBT_HIDDEN, !MD.ERE   .mLoaded), "BhB", "ByB", " B ", 'B', OP.stone.dat(aMat));
		aMat = MT.STONES.Livingrock;    aRegistry.add("Basin ("                         +aMat.getLocal()+")", "Molds"                               ,  1757,  1072, aClass, aMat.mToolQuality, 16, aStone           , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   5.0F, NBT_RESISTANCE,   5.0F, NBT_ACIDPROOF, F, NBT_HIDDEN, !MD.BOTA  .mLoaded), "BhB", "ByB", " B ", 'B', OP.stone.dat(aMat));
		aMat = MT.STONES.Holystone;     aRegistry.add("Basin ("                         +aMat.getLocal()+")", "Molds"                               ,  1758,  1072, aClass, aMat.mToolQuality, 16, aStone           , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   5.0F, NBT_RESISTANCE,   5.0F, NBT_ACIDPROOF, F, NBT_HIDDEN, !MD.AETHER.mLoaded), "BhB", "ByB", " B ", 'B', OP.stone.dat(aMat));
		aMat = MT.STONES.Betweenstone;  aRegistry.add("Basin ("                         +aMat.getLocal()+")", "Molds"                               ,  1759,  1072, aClass, aMat.mToolQuality, 16, aStone           , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   5.0F, NBT_RESISTANCE,   5.0F, NBT_ACIDPROOF, F, NBT_HIDDEN, !MD.BTL   .mLoaded), "BhB", "ByB", " B ", 'B', OP.stone.dat(aMat));
		
		aMat = ANY.Quartz;              aRegistry.add("Basin ("                         +aMat.getLocal()+")", "Molds"                               ,  1768,  1072, aClass, aMat.mToolQuality, 16, aStone           , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   5.0F, NBT_RESISTANCE,   5.0F, NBT_ACIDPROOF, F), "BhB", "ByB", " B ", 'B', OP.gem.dat(ANY.Quartz));
		aMat = MT.C;                    aRegistry.add("Basin ("                         +aMat.getLocal()+")", "Molds"                               ,  1769,  1072, aClass, aMat.mToolQuality, 16, aStone           , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,  10.0F, NBT_RESISTANCE,  10.0F, NBT_ACIDPROOF, F), "ChC", "CyC", " C ", 'C', OP.plate.dat(MT.Graphene));
		
		aMat = MT.Bronze;               aRegistry.add("Basin ("                         +aMat.getLocal()+")", "Molds"                               ,  1770,  1072, aClass, aMat.mToolQuality, 16, aMetal           , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   7.0F, NBT_RESISTANCE,   7.0F, NBT_ACIDPROOF, F), "PhP", "PyP", " P ", 'P', OP.plate.dat(aMat));
		aMat = MT.Invar;                aRegistry.add("Basin ("                         +aMat.getLocal()+")", "Molds"                               ,  1771,  1072, aClass, aMat.mToolQuality, 16, aMetal           , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_ACIDPROOF, F), "PhP", "PyP", " P ", 'P', OP.plate.dat(aMat));
		aMat = MT.Steel;                aRegistry.add("Basin ("                         +aMat.getLocal()+")", "Molds"                               ,  1772,  1072, aClass, aMat.mToolQuality, 16, aMetal           , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   6.0F, NBT_RESISTANCE,   6.0F, NBT_ACIDPROOF, F), "PhP", "PyP", " P ", 'P', OP.plate.dat(aMat));
		aMat = MT.HSLA;                 aRegistry.add("Basin ("                         +aMat.getLocal()+")", "Molds"                               ,  1791,  1072, aClass, aMat.mToolQuality, 16, aMetal           , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   6.0F, NBT_RESISTANCE,   6.0F, NBT_ACIDPROOF, F), "PhP", "PyP", " P ", 'P', OP.plate.dat(aMat));
		aMat = MT.StainlessSteel;       aRegistry.add("Basin ("                         +aMat.getLocal()+")", "Molds"                               ,  1775,  1072, aClass, aMat.mToolQuality, 16, aMetal           , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   6.0F, NBT_RESISTANCE,   6.0F, NBT_ACIDPROOF, T), "PhP", "PyP", " P ", 'P', OP.plate.dat(aMat));
		aMat = MT.DarkIron;             aRegistry.add("Basin ("                         +aMat.getLocal()+")", "Molds"                               ,  1776,  1072, aClass, aMat.mToolQuality, 16, aMetal           , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   6.0F, NBT_RESISTANCE,   6.0F, NBT_ACIDPROOF, F), "PhP", "PyP", " P ", 'P', OP.plate.dat(aMat));
		aMat = MT.MeteoricIron;         aRegistry.add("Basin ("                         +aMat.getLocal()+")", "Molds"                               ,  1781,  1072, aClass, aMat.mToolQuality, 16, aMetal           , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   6.0F, NBT_RESISTANCE,   6.0F, NBT_ACIDPROOF, F), "PhP", "PyP", " P ", 'P', OP.plate.dat(aMat));
		aMat = MT.MeteoricSteel;        aRegistry.add("Basin ("                         +aMat.getLocal()+")", "Molds"                               ,  1782,  1072, aClass, aMat.mToolQuality, 16, aMetal           , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   6.0F, NBT_RESISTANCE,   6.0F, NBT_ACIDPROOF, F), "PhP", "PyP", " P ", 'P', OP.plate.dat(aMat));
		aMat = MT.Netherite;            aRegistry.add("Basin ("                         +aMat.getLocal()+")", "Molds"                               ,  1794,  1072, aClass, aMat.mToolQuality, 16, aMetal           , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   6.0F, NBT_RESISTANCE,   6.0F, NBT_ACIDPROOF, T), "PhP", "PyP", " P ", 'P', OP.plate.dat(aMat));
		aMat = MT.Knightmetal;          aRegistry.add("Basin ("                         +aMat.getLocal()+")", "Molds"                               ,  1777,  1072, aClass, aMat.mToolQuality, 16, aMetal           , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   6.0F, NBT_RESISTANCE,   6.0F, NBT_ACIDPROOF, F), "PhP", "PyP", " P ", 'P', OP.plate.dat(aMat));
		aMat = MT.FierySteel;           aRegistry.add("Basin ("                         +aMat.getLocal()+")", "Molds"                               ,  1778,  1072, aClass, aMat.mToolQuality, 16, aMetal           , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   6.0F, NBT_RESISTANCE,   6.0F, NBT_ACIDPROOF, F), "PhP", "PyP", " P ", 'P', OP.plate.dat(aMat));
		aMat = MT.Octine;               aRegistry.add("Basin ("                         +aMat.getLocal()+")", "Molds"                               ,  1792,  1072, aClass, aMat.mToolQuality, 16, aMetal           , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   6.0F, NBT_RESISTANCE,   6.0F, NBT_ACIDPROOF, F), "PhP", "PyP", " P ", 'P', OP.plate.dat(aMat));
		aMat = MT.Thaumium;             aRegistry.add("Basin ("                         +aMat.getLocal()+")", "Molds"                               ,  1779,  1072, aClass, aMat.mToolQuality, 16, aMetal           , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   6.0F, NBT_RESISTANCE,   6.0F, NBT_ACIDPROOF, T), "PhP", "PyP", " P ", 'P', OP.plate.dat(aMat));
		aMat = MT.Ti;                   aRegistry.add("Basin ("                         +aMat.getLocal()+")", "Molds"                               ,  1773,  1072, aClass, aMat.mToolQuality, 16, aMetal           , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   9.0F, NBT_RESISTANCE,   9.0F, NBT_ACIDPROOF, F), "PhP", "PyP", " P ", 'P', OP.plate.dat(aMat));
		aMat = MT.Cr;                   aRegistry.add("Basin ("                         +aMat.getLocal()+")", "Molds"                               ,  1783,  1072, aClass, aMat.mToolQuality, 16, aMetal           , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   9.0F, NBT_RESISTANCE,   9.0F, NBT_ACIDPROOF, T), "PhP", "PyP", " P ", 'P', OP.plate.dat(aMat));
		aMat = MT.Mo;                   aRegistry.add("Basin ("                         +aMat.getLocal()+")", "Molds"                               ,  1784,  1072, aClass, aMat.mToolQuality, 16, aMetal           , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   9.0F, NBT_RESISTANCE,   9.0F, NBT_ACIDPROOF, F), "PhP", "PyP", " P ", 'P', OP.plate.dat(aMat));
		aMat = MT.Nb;                   aRegistry.add("Basin ("                         +aMat.getLocal()+")", "Molds"                               ,  1785,  1072, aClass, aMat.mToolQuality, 16, aMetal           , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   9.0F, NBT_RESISTANCE,   9.0F, NBT_ACIDPROOF, F), "PhP", "PyP", " P ", 'P', OP.plate.dat(aMat));
		aMat = MT.Ta;                   aRegistry.add("Basin ("                         +aMat.getLocal()+")", "Molds"                               ,  1786,  1072, aClass, aMat.mToolQuality, 16, aMetal           , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   9.0F, NBT_RESISTANCE,   9.0F, NBT_ACIDPROOF, F), "PhP", "PyP", " P ", 'P', OP.plate.dat(aMat));
		aMat = MT.Os;                   aRegistry.add("Basin ("                         +aMat.getLocal()+")", "Molds"                               ,  1787,  1072, aClass, aMat.mToolQuality, 16, aMetal           , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   9.0F, NBT_RESISTANCE,   9.0F, NBT_ACIDPROOF, F), "PhP", "PyP", " P ", 'P', OP.plate.dat(aMat));
		aMat = MT.Ir;                   aRegistry.add("Basin ("                         +aMat.getLocal()+")", "Molds"                               ,  1789,  1072, aClass, aMat.mToolQuality, 16, aMetal           , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   9.0F, NBT_RESISTANCE,   9.0F, NBT_ACIDPROOF, T), "PhP", "PyP", " P ", 'P', OP.plate.dat(aMat));
		aMat = MT.NiobiumTitanium;      aRegistry.add("Basin ("                         +aMat.getLocal()+")", "Molds"                               ,  1790,  1072, aClass, aMat.mToolQuality, 16, aMetal           , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   9.0F, NBT_RESISTANCE,   9.0F, NBT_ACIDPROOF, F), "PhP", "PyP", " P ", 'P', OP.plate.dat(aMat));
		aMat = MT.V;                    aRegistry.add("Basin ("                         +aMat.getLocal()+")", "Molds"                               ,  1788,  1072, aClass, aMat.mToolQuality, 16, aMetal           , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   9.0F, NBT_RESISTANCE,   9.0F, NBT_ACIDPROOF, F), "PhP", "PyP", " P ", 'P', OP.plate.dat(aMat));
		aMat = ANY.W;                   aRegistry.add("Basin ("                         +aMat.getLocal()+")", "Molds"                               ,  1774,  1072, aClass, aMat.mToolQuality, 16, aMetal           , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,  10.0F, NBT_RESISTANCE,  10.0F, NBT_ACIDPROOF, T), "PhP", "PyP", " P ", 'P', OP.plate.dat(aMat));
		aMat = MT.Ta4HfC5;              aRegistry.add("Basin ("                         +aMat.getLocal()+")", "Molds"                               ,  1793,  1072, aClass, aMat.mToolQuality, 16, aMetal           , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   9.0F, NBT_RESISTANCE,   9.0F, NBT_ACIDPROOF, F), "PhP", "PyP", " P ", 'P', OP.plate.dat(aMat));
		aMat = MT.VoidMetal;            aRegistry.add("Basin ("                         +aMat.getLocal()+")", "Molds"                               ,  1780,  1072, aClass, aMat.mToolQuality, 16, aMetal           , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,  10.0F, NBT_RESISTANCE,  10.0F, NBT_ACIDPROOF, T), "PhP", "PyP", " P ", 'P', OP.plate.dat(aMat));
		
		aMat = MT.Bedrock_HSLA_Alloy;   aRegistry.add("Basin ("                         +aMat.getLocal()+")", "Molds"                               ,  1798,  1072, aClass, aMat.mToolQuality, 16, aMetal           , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS, 100.0F, NBT_RESISTANCE, 100.0F, NBT_ACIDPROOF, F), "PhP", "PyP", " P ", 'P', OP.plate.dat(aMat));
		aMat = MT.Ad;                   aRegistry.add("Basin ("                         +aMat.getLocal()+")", "Molds"                               ,  1799,  1072, aClass, aMat.mToolQuality, 16, aMetal           , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS, 100.0F, NBT_RESISTANCE, 100.0F, NBT_ACIDPROOF, T), "PhP", "PyP", " P ", 'P', OP.plate.dat(aMat));
		
		
		
		// Crossings
		aClass = MultiTileEntityCrossing.class;
		aMat = MT.Stone;                aRegistry.add("Crucible Crossing ("             +aMat.getLocal()+")", "Molds"                               ,  1850,  1072, aClass, aMat.mToolQuality, 16, aStone           , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   5.0F, NBT_RESISTANCE,   5.0F, NBT_ACIDPROOF, F, NBT_HIDDEN, F                 ), "hBy", "BBB", " B ", 'B', Blocks.stone);
		aMat = MT.STONES.Basalt;        aRegistry.add("Crucible Crossing ("             +aMat.getLocal()+")", "Molds"                               ,  1851,  1072, aClass, aMat.mToolQuality, 16, aStone           , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,  15.0F, NBT_RESISTANCE,  15.0F, NBT_ACIDPROOF, F, NBT_HIDDEN, T                 ), "hBy", "BBB", " B ", 'B', OP.stone.dat(aMat));
		aMat = MT.STONES.GraniteBlack;  aRegistry.add("Crucible Crossing ("             +aMat.getLocal()+")", "Molds"                               ,  1852,  1072, aClass, aMat.mToolQuality, 16, aStone           , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,  15.0F, NBT_RESISTANCE,  15.0F, NBT_ACIDPROOF, F, NBT_HIDDEN, T                 ), "hBy", "BBB", " B ", 'B', OP.stone.dat(aMat));
		aMat = MT.STONES.GraniteRed;    aRegistry.add("Crucible Crossing ("             +aMat.getLocal()+")", "Molds"                               ,  1853,  1072, aClass, aMat.mToolQuality, 16, aStone           , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,  15.0F, NBT_RESISTANCE,  15.0F, NBT_ACIDPROOF, F, NBT_HIDDEN, T                 ), "hBy", "BBB", " B ", 'B', OP.stone.dat(aMat));
		aMat = MT.NetherBrick;          aRegistry.add("Crucible Crossing ("             +aMat.getLocal()+")", "Molds"                               ,  1854,  1072, aClass, aMat.mToolQuality, 16, aStone           , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   5.0F, NBT_RESISTANCE,   5.0F, NBT_ACIDPROOF, F, NBT_HIDDEN, T                 ), "hBy", "BBB", " B ", 'B', OP.stone.dat(aMat));
		aMat = MT.Ceramic;              aRegistry.add("Crucible Crossing ("             +aMat.getLocal()+")", "Molds"                               ,  1855,  1072, aClass, aMat.mToolQuality, 16, aStone           , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   5.0F, NBT_RESISTANCE,   5.0F, NBT_ACIDPROOF, F, NBT_HIDDEN, F                 )); IL.Ceramic_Crossing.set(aRegistry.getItem(), new OreDictItemData(MT.Ceramic, U*5)); RM.add_smelting(IL.Ceramic_Crossing_Raw.get(1), IL.Ceramic_Crossing.get(1), F, F, T);
		aMat = MT.STONES.Umber;         aRegistry.add("Crucible Crossing ("             +aMat.getLocal()+")", "Molds"                               ,  1856,  1072, aClass, aMat.mToolQuality, 16, aStone           , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   5.0F, NBT_RESISTANCE,   5.0F, NBT_ACIDPROOF, F, NBT_HIDDEN, !MD.ERE   .mLoaded), "hBy", "BBB", " B ", 'B', OP.stone.dat(aMat));
		aMat = MT.STONES.Livingrock;    aRegistry.add("Crucible Crossing ("             +aMat.getLocal()+")", "Molds"                               ,  1857,  1072, aClass, aMat.mToolQuality, 16, aStone           , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   5.0F, NBT_RESISTANCE,   5.0F, NBT_ACIDPROOF, F, NBT_HIDDEN, !MD.BOTA  .mLoaded), "hBy", "BBB", " B ", 'B', OP.stone.dat(aMat));
		aMat = MT.STONES.Holystone;     aRegistry.add("Crucible Crossing ("             +aMat.getLocal()+")", "Molds"                               ,  1858,  1072, aClass, aMat.mToolQuality, 16, aStone           , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   5.0F, NBT_RESISTANCE,   5.0F, NBT_ACIDPROOF, F, NBT_HIDDEN, !MD.AETHER.mLoaded), "hBy", "BBB", " B ", 'B', OP.stone.dat(aMat));
		aMat = MT.STONES.Betweenstone;  aRegistry.add("Crucible Crossing ("             +aMat.getLocal()+")", "Molds"                               ,  1859,  1072, aClass, aMat.mToolQuality, 16, aStone           , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   5.0F, NBT_RESISTANCE,   5.0F, NBT_ACIDPROOF, F, NBT_HIDDEN, !MD.BTL   .mLoaded), "hBy", "BBB", " B ", 'B', OP.stone.dat(aMat));
		
		aMat = ANY.Quartz;              aRegistry.add("Crucible Crossing ("             +aMat.getLocal()+")", "Molds"                               ,  1868,  1072, aClass, aMat.mToolQuality, 16, aStone           , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   5.0F, NBT_RESISTANCE,   5.0F, NBT_ACIDPROOF, F), "hBy", "BBB", " B ", 'B', OP.gem.dat(ANY.Quartz));
		aMat = MT.C;                    aRegistry.add("Crucible Crossing ("             +aMat.getLocal()+")", "Molds"                               ,  1869,  1072, aClass, aMat.mToolQuality, 16, aStone           , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,  10.0F, NBT_RESISTANCE,  10.0F, NBT_ACIDPROOF, F), "hCy", "CCC", " C ", 'C', OP.plate.dat(MT.Graphene));
		
		aMat = MT.Bronze;               aRegistry.add("Crucible Crossing ("             +aMat.getLocal()+")", "Molds"                               ,  1870,  1072, aClass, aMat.mToolQuality, 16, aMetal           , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   7.0F, NBT_RESISTANCE,   7.0F, NBT_ACIDPROOF, F), "hPy", "PPP", " P ", 'P', OP.plate.dat(aMat));
		aMat = MT.Invar;                aRegistry.add("Crucible Crossing ("             +aMat.getLocal()+")", "Molds"                               ,  1871,  1072, aClass, aMat.mToolQuality, 16, aMetal           , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_ACIDPROOF, F), "hPy", "PPP", " P ", 'P', OP.plate.dat(aMat));
		aMat = MT.Steel;                aRegistry.add("Crucible Crossing ("             +aMat.getLocal()+")", "Molds"                               ,  1872,  1072, aClass, aMat.mToolQuality, 16, aMetal           , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   6.0F, NBT_RESISTANCE,   6.0F, NBT_ACIDPROOF, F), "hPy", "PPP", " P ", 'P', OP.plate.dat(aMat));
		aMat = MT.HSLA;                 aRegistry.add("Crucible Crossing ("             +aMat.getLocal()+")", "Molds"                               ,  1891,  1072, aClass, aMat.mToolQuality, 16, aMetal           , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   6.0F, NBT_RESISTANCE,   6.0F, NBT_ACIDPROOF, F), "hPy", "PPP", " P ", 'P', OP.plate.dat(aMat));
		aMat = MT.StainlessSteel;       aRegistry.add("Crucible Crossing ("             +aMat.getLocal()+")", "Molds"                               ,  1875,  1072, aClass, aMat.mToolQuality, 16, aMetal           , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   6.0F, NBT_RESISTANCE,   6.0F, NBT_ACIDPROOF, T), "hPy", "PPP", " P ", 'P', OP.plate.dat(aMat));
		aMat = MT.DarkIron;             aRegistry.add("Crucible Crossing ("             +aMat.getLocal()+")", "Molds"                               ,  1876,  1072, aClass, aMat.mToolQuality, 16, aMetal           , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   6.0F, NBT_RESISTANCE,   6.0F, NBT_ACIDPROOF, F), "hPy", "PPP", " P ", 'P', OP.plate.dat(aMat));
		aMat = MT.MeteoricIron;         aRegistry.add("Crucible Crossing ("             +aMat.getLocal()+")", "Molds"                               ,  1881,  1072, aClass, aMat.mToolQuality, 16, aMetal           , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   6.0F, NBT_RESISTANCE,   6.0F, NBT_ACIDPROOF, F), "hPy", "PPP", " P ", 'P', OP.plate.dat(aMat));
		aMat = MT.MeteoricSteel;        aRegistry.add("Crucible Crossing ("             +aMat.getLocal()+")", "Molds"                               ,  1882,  1072, aClass, aMat.mToolQuality, 16, aMetal           , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   6.0F, NBT_RESISTANCE,   6.0F, NBT_ACIDPROOF, F), "hPy", "PPP", " P ", 'P', OP.plate.dat(aMat));
		aMat = MT.Netherite;            aRegistry.add("Crucible Crossing ("             +aMat.getLocal()+")", "Molds"                               ,  1894,  1072, aClass, aMat.mToolQuality, 16, aMetal           , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   6.0F, NBT_RESISTANCE,   6.0F, NBT_ACIDPROOF, T), "hPy", "PPP", " P ", 'P', OP.plate.dat(aMat));
		aMat = MT.Knightmetal;          aRegistry.add("Crucible Crossing ("             +aMat.getLocal()+")", "Molds"                               ,  1877,  1072, aClass, aMat.mToolQuality, 16, aMetal           , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   6.0F, NBT_RESISTANCE,   6.0F, NBT_ACIDPROOF, F), "hPy", "PPP", " P ", 'P', OP.plate.dat(aMat));
		aMat = MT.FierySteel;           aRegistry.add("Crucible Crossing ("             +aMat.getLocal()+")", "Molds"                               ,  1878,  1072, aClass, aMat.mToolQuality, 16, aMetal           , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   6.0F, NBT_RESISTANCE,   6.0F, NBT_ACIDPROOF, F), "hPy", "PPP", " P ", 'P', OP.plate.dat(aMat));
		aMat = MT.Octine;               aRegistry.add("Crucible Crossing ("             +aMat.getLocal()+")", "Molds"                               ,  1892,  1072, aClass, aMat.mToolQuality, 16, aMetal           , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   6.0F, NBT_RESISTANCE,   6.0F, NBT_ACIDPROOF, F), "hPy", "PPP", " P ", 'P', OP.plate.dat(aMat));
		aMat = MT.Thaumium;             aRegistry.add("Crucible Crossing ("             +aMat.getLocal()+")", "Molds"                               ,  1879,  1072, aClass, aMat.mToolQuality, 16, aMetal           , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   6.0F, NBT_RESISTANCE,   6.0F, NBT_ACIDPROOF, T), "hPy", "PPP", " P ", 'P', OP.plate.dat(aMat));
		aMat = MT.Ti;                   aRegistry.add("Crucible Crossing ("             +aMat.getLocal()+")", "Molds"                               ,  1873,  1072, aClass, aMat.mToolQuality, 16, aMetal           , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   9.0F, NBT_RESISTANCE,   9.0F, NBT_ACIDPROOF, F), "hPy", "PPP", " P ", 'P', OP.plate.dat(aMat));
		aMat = MT.Cr;                   aRegistry.add("Crucible Crossing ("             +aMat.getLocal()+")", "Molds"                               ,  1883,  1072, aClass, aMat.mToolQuality, 16, aMetal           , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   9.0F, NBT_RESISTANCE,   9.0F, NBT_ACIDPROOF, T), "hPy", "PPP", " P ", 'P', OP.plate.dat(aMat));
		aMat = MT.Mo;                   aRegistry.add("Crucible Crossing ("             +aMat.getLocal()+")", "Molds"                               ,  1884,  1072, aClass, aMat.mToolQuality, 16, aMetal           , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   9.0F, NBT_RESISTANCE,   9.0F, NBT_ACIDPROOF, F), "hPy", "PPP", " P ", 'P', OP.plate.dat(aMat));
		aMat = MT.Nb;                   aRegistry.add("Crucible Crossing ("             +aMat.getLocal()+")", "Molds"                               ,  1885,  1072, aClass, aMat.mToolQuality, 16, aMetal           , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   9.0F, NBT_RESISTANCE,   9.0F, NBT_ACIDPROOF, F), "hPy", "PPP", " P ", 'P', OP.plate.dat(aMat));
		aMat = MT.Ta;                   aRegistry.add("Crucible Crossing ("             +aMat.getLocal()+")", "Molds"                               ,  1886,  1072, aClass, aMat.mToolQuality, 16, aMetal           , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   9.0F, NBT_RESISTANCE,   9.0F, NBT_ACIDPROOF, F), "hPy", "PPP", " P ", 'P', OP.plate.dat(aMat));
		aMat = MT.Os;                   aRegistry.add("Crucible Crossing ("             +aMat.getLocal()+")", "Molds"                               ,  1887,  1072, aClass, aMat.mToolQuality, 16, aMetal           , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   9.0F, NBT_RESISTANCE,   9.0F, NBT_ACIDPROOF, F), "hPy", "PPP", " P ", 'P', OP.plate.dat(aMat));
		aMat = MT.Ir;                   aRegistry.add("Crucible Crossing ("             +aMat.getLocal()+")", "Molds"                               ,  1889,  1072, aClass, aMat.mToolQuality, 16, aMetal           , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   9.0F, NBT_RESISTANCE,   9.0F, NBT_ACIDPROOF, T), "hPy", "PPP", " P ", 'P', OP.plate.dat(aMat));
		aMat = MT.NiobiumTitanium;      aRegistry.add("Crucible Crossing ("             +aMat.getLocal()+")", "Molds"                               ,  1890,  1072, aClass, aMat.mToolQuality, 16, aMetal           , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   9.0F, NBT_RESISTANCE,   9.0F, NBT_ACIDPROOF, F), "hPy", "PPP", " P ", 'P', OP.plate.dat(aMat));
		aMat = MT.V;                    aRegistry.add("Crucible Crossing ("             +aMat.getLocal()+")", "Molds"                               ,  1888,  1072, aClass, aMat.mToolQuality, 16, aMetal           , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   9.0F, NBT_RESISTANCE,   9.0F, NBT_ACIDPROOF, F), "hPy", "PPP", " P ", 'P', OP.plate.dat(aMat));
		aMat = ANY.W;                   aRegistry.add("Crucible Crossing ("             +aMat.getLocal()+")", "Molds"                               ,  1874,  1072, aClass, aMat.mToolQuality, 16, aMetal           , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,  10.0F, NBT_RESISTANCE,  10.0F, NBT_ACIDPROOF, T), "hPy", "PPP", " P ", 'P', OP.plate.dat(aMat));
		aMat = MT.Ta4HfC5;              aRegistry.add("Crucible Crossing ("             +aMat.getLocal()+")", "Molds"                               ,  1893,  1072, aClass, aMat.mToolQuality, 16, aMetal           , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   9.0F, NBT_RESISTANCE,   9.0F, NBT_ACIDPROOF, F), "hPy", "PPP", " P ", 'P', OP.plate.dat(aMat));
		aMat = MT.VoidMetal;            aRegistry.add("Crucible Crossing ("             +aMat.getLocal()+")", "Molds"                               ,  1880,  1072, aClass, aMat.mToolQuality, 16, aMetal           , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,  10.0F, NBT_RESISTANCE,  10.0F, NBT_ACIDPROOF, T), "hPy", "PPP", " P ", 'P', OP.plate.dat(aMat));
		
		aMat = MT.Bedrock_HSLA_Alloy;   aRegistry.add("Crucible Crossing ("             +aMat.getLocal()+")", "Molds"                               ,  1898,  1072, aClass, aMat.mToolQuality, 16, aMetal           , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS, 100.0F, NBT_RESISTANCE, 100.0F, NBT_ACIDPROOF, F), "hPy", "PPP", " P ", 'P', OP.plate.dat(aMat));
		aMat = MT.Ad;                   aRegistry.add("Crucible Crossing ("             +aMat.getLocal()+")", "Molds"                               ,  1899,  1072, aClass, aMat.mToolQuality, 16, aMetal           , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS, 100.0F, NBT_RESISTANCE, 100.0F, NBT_ACIDPROOF, T), "hPy", "PPP", " P ", 'P', OP.plate.dat(aMat));
	}
	
	private static void unsorted1(MultiTileEntityRegistry aRegistry, MultiTileEntityBlock aMetal, MultiTileEntityBlock aMetalChips, MultiTileEntityBlock aMetalWires, MultiTileEntityBlock aMachine, MultiTileEntityBlock aWooden, MultiTileEntityBlock aBush, MultiTileEntityBlock aStone, MultiTileEntityBlock aWool, MultiTileEntityBlock aTNT, MultiTileEntityBlock aHive, MultiTileEntityBlock aUtilMetal, MultiTileEntityBlock aUtilStone, MultiTileEntityBlock aUtilWood, MultiTileEntityBlock aUtilWool, OreDictMaterial aMat, Class<? extends TileEntity> aClass) {
		// Burning Boxes
		aClass = MultiTileEntityGeneratorBrick.class;
		aMat = MT.Brick;                aRegistry.add("Brick Burning Box (Solid)"                           , "Burning Boxes"                       ,  1199,  1104, aClass, aMat.mToolQuality, 16, aStone       , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   6.0F, NBT_RESISTANCE,   6.0F, NBT_FUELMAP, FM.Furnace, NBT_EFFICIENCY,  2500, NBT_OUTPUT,  16, NBT_ENERGY_EMITTED, TD.Energy.HU), "BBB", "BBB", "BFB", 'B', OP.ingot.dat(MT.Brick), 'F', OD.craftingFirestarter);
		
		aClass = MultiTileEntityGeneratorMetal.class;
		aMat = MT.Pb;                   aRegistry.add("Burning Box (Solid, "            +aMat.getLocal()+")", "Burning Boxes"                       ,  1100,  1104, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_FUELMAP, FM.Furnace, NBT_EFFICIENCY,  5000, NBT_OUTPUT,  16, NBT_ENERGY_EMITTED, TD.Energy.HU), "PCP", "PwP", "BBB", 'B', Blocks.brick_block, 'P', OP.plate.dat(aMat), 'C', OP.plateDouble.dat(ANY.Cu));
		aMat = MT.Bi;                   aRegistry.add("Burning Box (Solid, "            +aMat.getLocal()+")", "Burning Boxes"                       ,  1101,  1104, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_FUELMAP, FM.Furnace, NBT_EFFICIENCY,  4500, NBT_OUTPUT,  20, NBT_ENERGY_EMITTED, TD.Energy.HU), "PCP", "PwP", "BBB", 'B', Blocks.brick_block, 'P', OP.plate.dat(aMat), 'C', OP.plateDouble.dat(ANY.Cu));
		aMat = MT.Bronze;               aRegistry.add("Burning Box (Solid, "            +aMat.getLocal()+")", "Burning Boxes"                       ,  1102,  1104, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   7.0F, NBT_RESISTANCE,   7.0F, NBT_FUELMAP, FM.Furnace, NBT_EFFICIENCY,  7500, NBT_OUTPUT,  24, NBT_ENERGY_EMITTED, TD.Energy.HU), "PCP", "PwP", "BBB", 'B', Blocks.brick_block, 'P', OP.plate.dat(aMat), 'C', OP.plateDouble.dat(ANY.Cu));
		aMat = MT.ArsenicCopper;        aRegistry.add("Burning Box (Solid, "            +aMat.getLocal()+")", "Burning Boxes"                       ,  1111,  1104, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   7.0F, NBT_RESISTANCE,   7.0F, NBT_FUELMAP, FM.Furnace, NBT_EFFICIENCY,  8000, NBT_OUTPUT,  24, NBT_ENERGY_EMITTED, TD.Energy.HU), "PCP", "PwP", "BBB", 'B', Blocks.brick_block, 'P', OP.plate.dat(aMat), 'C', OP.plateDouble.dat(ANY.Cu));
		aMat = MT.ArsenicBronze;        aRegistry.add("Burning Box (Solid, "            +aMat.getLocal()+")", "Burning Boxes"                       ,  1112,  1104, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   7.0F, NBT_RESISTANCE,   7.0F, NBT_FUELMAP, FM.Furnace, NBT_EFFICIENCY,  9000, NBT_OUTPUT,  28, NBT_ENERGY_EMITTED, TD.Energy.HU), "PCP", "PwP", "BBB", 'B', Blocks.brick_block, 'P', OP.plate.dat(aMat), 'C', OP.plateDouble.dat(ANY.Cu));
		aMat = MT.Invar;                aRegistry.add("Burning Box (Solid, "            +aMat.getLocal()+")", "Burning Boxes"                       ,  1103,  1104, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_FUELMAP, FM.Furnace, NBT_EFFICIENCY, 10000, NBT_OUTPUT,  16, NBT_ENERGY_EMITTED, TD.Energy.HU), "PCP", "PwP", "BBB", 'B', Blocks.brick_block, 'P', OP.plate.dat(aMat), 'C', OP.plateDouble.dat(ANY.Cu));
		aMat = ANY.Steel;               aRegistry.add("Burning Box (Solid, "            +aMat.getLocal()+")", "Burning Boxes"                       ,  1104,  1104, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   6.0F, NBT_RESISTANCE,   6.0F, NBT_FUELMAP, FM.Furnace, NBT_EFFICIENCY,  7000, NBT_OUTPUT,  32, NBT_ENERGY_EMITTED, TD.Energy.HU), "PCP", "PwP", "BBB", 'B', Blocks.brick_block, 'P', OP.plate.dat(aMat), 'C', OP.plateDouble.dat(ANY.Cu));
		aMat = MT.Cr;                   aRegistry.add("Burning Box (Solid, "            +aMat.getLocal()+")", "Burning Boxes"                       ,  1105,  1104, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_FUELMAP, FM.Furnace, NBT_EFFICIENCY,  8500, NBT_OUTPUT, 112, NBT_ENERGY_EMITTED, TD.Energy.HU), "PCP", "PwP", "BBB", 'B', Blocks.brick_block, 'P', OP.plate.dat(aMat), 'C', OP.plateDouble.dat(ANY.Cu));
		aMat = MT.Ti;                   aRegistry.add("Burning Box (Solid, "            +aMat.getLocal()+")", "Burning Boxes"                       ,  1106,  1104, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   9.0F, NBT_RESISTANCE,   9.0F, NBT_FUELMAP, FM.Furnace, NBT_EFFICIENCY,  8500, NBT_OUTPUT,  96, NBT_ENERGY_EMITTED, TD.Energy.HU), "PCP", "PwP", "BBB", 'B', Blocks.brick_block, 'P', OP.plate.dat(aMat), 'C', OP.plateDouble.dat(ANY.Cu));
		aMat = MT.Netherite;            aRegistry.add("Burning Box (Solid, "            +aMat.getLocal()+")", "Burning Boxes"                       ,  1110,  1104, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   9.0F, NBT_RESISTANCE,   9.0F, NBT_FUELMAP, FM.Furnace, NBT_EFFICIENCY,  9000, NBT_OUTPUT,  96, NBT_ENERGY_EMITTED, TD.Energy.HU), "PCP", "PwP", "BBB", 'B', Blocks.brick_block, 'P', OP.plate.dat(aMat), 'C', OP.plateDouble.dat(ANY.Cu));
		aMat = ANY.W;                   aRegistry.add("Burning Box (Solid, "            +aMat.getLocal()+")", "Burning Boxes"                       ,  1107,  1104, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,  10.0F, NBT_RESISTANCE,  10.0F, NBT_FUELMAP, FM.Furnace, NBT_EFFICIENCY, 10000, NBT_OUTPUT, 128, NBT_ENERGY_EMITTED, TD.Energy.HU), "PCP", "PwP", "BBB", 'B', Blocks.brick_block, 'P', OP.plate.dat(aMat), 'C', OP.plateDouble.dat(ANY.Cu));
		aMat = MT.TungstenSteel;        aRegistry.add("Burning Box (Solid, "            +aMat.getLocal()+")", "Burning Boxes"                       ,  1108,  1104, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,  12.5F, NBT_RESISTANCE,  12.5F, NBT_FUELMAP, FM.Furnace, NBT_EFFICIENCY,  9000, NBT_OUTPUT, 128, NBT_ENERGY_EMITTED, TD.Energy.HU), "PCP", "PwP", "BBB", 'B', Blocks.brick_block, 'P', OP.plate.dat(aMat), 'C', OP.plateDouble.dat(ANY.Cu));
		aMat = MT.Ta4HfC5;              aRegistry.add("Burning Box (Solid, "            +aMat.getLocal()+")", "Burning Boxes"                       ,  1109,  1104, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,  12.5F, NBT_RESISTANCE,  12.5F, NBT_FUELMAP, FM.Furnace, NBT_EFFICIENCY, 10000, NBT_OUTPUT, 256, NBT_ENERGY_EMITTED, TD.Energy.HU), "PCP", "PwP", "BBB", 'B', Blocks.brick_block, 'P', OP.plate.dat(aMat), 'C', OP.plateDouble.dat(ANY.Cu));
		
		aMat = MT.Pb;                   aRegistry.add("Dense Burning Box (Solid, "      +aMat.getLocal()+")", "Burning Boxes"                       ,  1150,  1104, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_FUELMAP, FM.Furnace, NBT_EFFICIENCY,  5000, NBT_OUTPUT,  64, NBT_ENERGY_EMITTED, TD.Energy.HU), "PCP", "PwP", "BBB", 'B', Blocks.brick_block, 'P', OP.plateQuintuple.dat(aMat), 'C', OP.plateDense.dat(ANY.Cu));
		aMat = MT.Bi;                   aRegistry.add("Dense Burning Box (Solid, "      +aMat.getLocal()+")", "Burning Boxes"                       ,  1151,  1104, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_FUELMAP, FM.Furnace, NBT_EFFICIENCY,  4500, NBT_OUTPUT,  80, NBT_ENERGY_EMITTED, TD.Energy.HU), "PCP", "PwP", "BBB", 'B', Blocks.brick_block, 'P', OP.plateQuintuple.dat(aMat), 'C', OP.plateDense.dat(ANY.Cu));
		aMat = MT.Bronze;               aRegistry.add("Dense Burning Box (Solid, "      +aMat.getLocal()+")", "Burning Boxes"                       ,  1152,  1104, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   7.0F, NBT_RESISTANCE,   7.0F, NBT_FUELMAP, FM.Furnace, NBT_EFFICIENCY,  7500, NBT_OUTPUT,  96, NBT_ENERGY_EMITTED, TD.Energy.HU), "PCP", "PwP", "BBB", 'B', Blocks.brick_block, 'P', OP.plateQuintuple.dat(aMat), 'C', OP.plateDense.dat(ANY.Cu));
		aMat = MT.ArsenicCopper;        aRegistry.add("Dense Burning Box (Solid, "      +aMat.getLocal()+")", "Burning Boxes"                       ,  1161,  1104, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   7.0F, NBT_RESISTANCE,   7.0F, NBT_FUELMAP, FM.Furnace, NBT_EFFICIENCY,  8000, NBT_OUTPUT,  96, NBT_ENERGY_EMITTED, TD.Energy.HU), "PCP", "PwP", "BBB", 'B', Blocks.brick_block, 'P', OP.plateQuintuple.dat(aMat), 'C', OP.plateDense.dat(ANY.Cu));
		aMat = MT.ArsenicBronze;        aRegistry.add("Dense Burning Box (Solid, "      +aMat.getLocal()+")", "Burning Boxes"                       ,  1162,  1104, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   7.0F, NBT_RESISTANCE,   7.0F, NBT_FUELMAP, FM.Furnace, NBT_EFFICIENCY,  9000, NBT_OUTPUT, 112, NBT_ENERGY_EMITTED, TD.Energy.HU), "PCP", "PwP", "BBB", 'B', Blocks.brick_block, 'P', OP.plateQuintuple.dat(aMat), 'C', OP.plateDense.dat(ANY.Cu));
		aMat = MT.Invar;                aRegistry.add("Dense Burning Box (Solid, "      +aMat.getLocal()+")", "Burning Boxes"                       ,  1153,  1104, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_FUELMAP, FM.Furnace, NBT_EFFICIENCY, 10000, NBT_OUTPUT,  64, NBT_ENERGY_EMITTED, TD.Energy.HU), "PCP", "PwP", "BBB", 'B', Blocks.brick_block, 'P', OP.plateQuintuple.dat(aMat), 'C', OP.plateDense.dat(ANY.Cu));
		aMat = ANY.Steel;               aRegistry.add("Dense Burning Box (Solid, "      +aMat.getLocal()+")", "Burning Boxes"                       ,  1154,  1104, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   6.0F, NBT_RESISTANCE,   6.0F, NBT_FUELMAP, FM.Furnace, NBT_EFFICIENCY,  7000, NBT_OUTPUT, 128, NBT_ENERGY_EMITTED, TD.Energy.HU), "PCP", "PwP", "BBB", 'B', Blocks.brick_block, 'P', OP.plateQuintuple.dat(aMat), 'C', OP.plateDense.dat(ANY.Cu));
		aMat = MT.Cr;                   aRegistry.add("Dense Burning Box (Solid, "      +aMat.getLocal()+")", "Burning Boxes"                       ,  1155,  1104, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_FUELMAP, FM.Furnace, NBT_EFFICIENCY,  8500, NBT_OUTPUT, 448, NBT_ENERGY_EMITTED, TD.Energy.HU), "PCP", "PwP", "BBB", 'B', Blocks.brick_block, 'P', OP.plateQuintuple.dat(aMat), 'C', OP.plateDense.dat(ANY.Cu));
		aMat = MT.Ti;                   aRegistry.add("Dense Burning Box (Solid, "      +aMat.getLocal()+")", "Burning Boxes"                       ,  1156,  1104, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   9.0F, NBT_RESISTANCE,   9.0F, NBT_FUELMAP, FM.Furnace, NBT_EFFICIENCY,  8500, NBT_OUTPUT, 384, NBT_ENERGY_EMITTED, TD.Energy.HU), "PCP", "PwP", "BBB", 'B', Blocks.brick_block, 'P', OP.plateQuintuple.dat(aMat), 'C', OP.plateDense.dat(ANY.Cu));
		aMat = MT.Netherite;            aRegistry.add("Dense Burning Box (Solid, "      +aMat.getLocal()+")", "Burning Boxes"                       ,  1160,  1104, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   9.0F, NBT_RESISTANCE,   9.0F, NBT_FUELMAP, FM.Furnace, NBT_EFFICIENCY,  9000, NBT_OUTPUT, 384, NBT_ENERGY_EMITTED, TD.Energy.HU), "PCP", "PwP", "BBB", 'B', Blocks.brick_block, 'P', OP.plateQuintuple.dat(aMat), 'C', OP.plateDense.dat(ANY.Cu));
		aMat = ANY.W;                   aRegistry.add("Dense Burning Box (Solid, "      +aMat.getLocal()+")", "Burning Boxes"                       ,  1157,  1104, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,  10.0F, NBT_RESISTANCE,  10.0F, NBT_FUELMAP, FM.Furnace, NBT_EFFICIENCY, 10000, NBT_OUTPUT, 512, NBT_ENERGY_EMITTED, TD.Energy.HU), "PCP", "PwP", "BBB", 'B', Blocks.brick_block, 'P', OP.plateQuintuple.dat(aMat), 'C', OP.plateDense.dat(ANY.Cu));
		aMat = MT.TungstenSteel;        aRegistry.add("Dense Burning Box (Solid, "      +aMat.getLocal()+")", "Burning Boxes"                       ,  1158,  1104, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,  12.5F, NBT_RESISTANCE,  12.5F, NBT_FUELMAP, FM.Furnace, NBT_EFFICIENCY,  9000, NBT_OUTPUT, 512, NBT_ENERGY_EMITTED, TD.Energy.HU), "PCP", "PwP", "BBB", 'B', Blocks.brick_block, 'P', OP.plateQuintuple.dat(aMat), 'C', OP.plateDense.dat(ANY.Cu));
		aMat = MT.Ta4HfC5;              aRegistry.add("Dense Burning Box (Solid, "      +aMat.getLocal()+")", "Burning Boxes"                       ,  1159,  1104, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,  12.5F, NBT_RESISTANCE,  12.5F, NBT_FUELMAP, FM.Furnace, NBT_EFFICIENCY, 10000, NBT_OUTPUT,1024, NBT_ENERGY_EMITTED, TD.Energy.HU), "PCP", "PwP", "BBB", 'B', Blocks.brick_block, 'P', OP.plateQuintuple.dat(aMat), 'C', OP.plateDense.dat(ANY.Cu));
		
		
		// Steam Boilers
		aClass = MultiTileEntityBoilerTank.class;
		aMat = MT.Pb;                   aRegistry.add("Steam Boiler Tank ("             +aMat.getLocal()+")", "Steam Boilers"                       ,  1200,  1204, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_CAPACITY,  160000, NBT_CAPACITY_SU,  160000, NBT_OUTPUT_SU,  16*STEAM_PER_EU, NBT_ENERGY_ACCEPTED, TD.Energy.HU), " P ", "PwP", "PhP", 'P', OP.plateDouble.dat(aMat));
		aMat = MT.Bi;                   aRegistry.add("Steam Boiler Tank ("             +aMat.getLocal()+")", "Steam Boilers"                       ,  1201,  1204, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_CAPACITY,  200000, NBT_CAPACITY_SU,  200000, NBT_OUTPUT_SU,  20*STEAM_PER_EU, NBT_ENERGY_ACCEPTED, TD.Energy.HU), " P ", "PwP", "PhP", 'P', OP.plateDouble.dat(aMat));
		aMat = MT.Bronze;               aRegistry.add("Steam Boiler Tank ("             +aMat.getLocal()+")", "Steam Boilers"                       ,  1202,  1204, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   7.0F, NBT_RESISTANCE,   7.0F, NBT_CAPACITY,  240000, NBT_CAPACITY_SU,  240000, NBT_OUTPUT_SU,  24*STEAM_PER_EU, NBT_ENERGY_ACCEPTED, TD.Energy.HU), " P ", "PwP", "PhP", 'P', OP.plateDouble.dat(aMat));
		aMat = MT.ArsenicCopper;        aRegistry.add("Steam Boiler Tank ("             +aMat.getLocal()+")", "Steam Boilers"                       ,  1210,  1204, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   7.0F, NBT_RESISTANCE,   7.0F, NBT_CAPACITY,  240000, NBT_CAPACITY_SU,  240000, NBT_OUTPUT_SU,  24*STEAM_PER_EU, NBT_ENERGY_ACCEPTED, TD.Energy.HU), " P ", "PwP", "PhP", 'P', OP.plateDouble.dat(aMat));
		aMat = MT.ArsenicBronze;        aRegistry.add("Steam Boiler Tank ("             +aMat.getLocal()+")", "Steam Boilers"                       ,  1211,  1204, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   7.0F, NBT_RESISTANCE,   7.0F, NBT_CAPACITY,  240000, NBT_CAPACITY_SU,  280000, NBT_OUTPUT_SU,  28*STEAM_PER_EU, NBT_ENERGY_ACCEPTED, TD.Energy.HU), " P ", "PwP", "PhP", 'P', OP.plateDouble.dat(aMat));
		aMat = MT.Invar;                aRegistry.add("Steam Boiler Tank ("             +aMat.getLocal()+")", "Steam Boilers"                       ,  1203,  1204, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_CAPACITY,  160000, NBT_CAPACITY_SU,  160000, NBT_OUTPUT_SU,  16*STEAM_PER_EU, NBT_ENERGY_ACCEPTED, TD.Energy.HU), " P ", "PwP", "PhP", 'P', OP.plateDouble.dat(aMat));
		aMat = ANY.Steel;               aRegistry.add("Steam Boiler Tank ("             +aMat.getLocal()+")", "Steam Boilers"                       ,  1204,  1204, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   6.0F, NBT_RESISTANCE,   6.0F, NBT_CAPACITY,  320000, NBT_CAPACITY_SU,  320000, NBT_OUTPUT_SU,  32*STEAM_PER_EU, NBT_ENERGY_ACCEPTED, TD.Energy.HU), " P ", "PwP", "PhP", 'P', OP.plateDouble.dat(aMat));
		aMat = MT.Cr;                   aRegistry.add("Steam Boiler Tank ("             +aMat.getLocal()+")", "Steam Boilers"                       ,  1205,  1204, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_CAPACITY,  960000, NBT_CAPACITY_SU,  960000, NBT_OUTPUT_SU,  96*STEAM_PER_EU, NBT_ENERGY_ACCEPTED, TD.Energy.HU), " P ", "PwP", "PhP", 'P', OP.plateDouble.dat(aMat));
		aMat = MT.Ti;                   aRegistry.add("Steam Boiler Tank ("             +aMat.getLocal()+")", "Steam Boilers"                       ,  1206,  1204, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   9.0F, NBT_RESISTANCE,   9.0F, NBT_CAPACITY, 1120000, NBT_CAPACITY_SU, 1120000, NBT_OUTPUT_SU, 112*STEAM_PER_EU, NBT_ENERGY_ACCEPTED, TD.Energy.HU), " P ", "PwP", "PhP", 'P', OP.plateDouble.dat(aMat));
		aMat = MT.Netherite;            aRegistry.add("Steam Boiler Tank ("             +aMat.getLocal()+")", "Steam Boilers"                       ,  1209,  1204, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   9.0F, NBT_RESISTANCE,   9.0F, NBT_CAPACITY, 1120000, NBT_CAPACITY_SU, 1120000, NBT_OUTPUT_SU, 112*STEAM_PER_EU, NBT_ENERGY_ACCEPTED, TD.Energy.HU), " P ", "PwP", "PhP", 'P', OP.plateDouble.dat(aMat));
		aMat = ANY.W;                   aRegistry.add("Steam Boiler Tank ("             +aMat.getLocal()+")", "Steam Boilers"                       ,  1207,  1204, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,  10.0F, NBT_RESISTANCE,  10.0F, NBT_CAPACITY, 1280000, NBT_CAPACITY_SU, 1280000, NBT_OUTPUT_SU, 128*STEAM_PER_EU, NBT_ENERGY_ACCEPTED, TD.Energy.HU), " P ", "PwP", "PhP", 'P', OP.plateDouble.dat(aMat));
		aMat = MT.TungstenSteel;        aRegistry.add("Steam Boiler Tank ("             +aMat.getLocal()+")", "Steam Boilers"                       ,  1208,  1204, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,  12.5F, NBT_RESISTANCE,  12.5F, NBT_CAPACITY, 1280000, NBT_CAPACITY_SU, 1280000, NBT_OUTPUT_SU, 128*STEAM_PER_EU, NBT_ENERGY_ACCEPTED, TD.Energy.HU), " P ", "PwP", "PhP", 'P', OP.plateDouble.dat(aMat));
		
		aMat = MT.Pb;                   aRegistry.add("Strong Steam Boiler Tank ("      +aMat.getLocal()+")", "Steam Boilers"                       ,  1250,  1204, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_CAPACITY,  640000, NBT_CAPACITY_SU,  640000, NBT_OUTPUT_SU,  64*STEAM_PER_EU, NBT_ENERGY_ACCEPTED, TD.Energy.HU), " P ", "PwP", "PhP", 'P', MD.HBM.mLoaded ? OP.plateDense.mat(aMat, 1) : OP.plateDense.dat(aMat));
		aMat = MT.Bi;                   aRegistry.add("Strong Steam Boiler Tank ("      +aMat.getLocal()+")", "Steam Boilers"                       ,  1251,  1204, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_CAPACITY,  800000, NBT_CAPACITY_SU,  800000, NBT_OUTPUT_SU,  80*STEAM_PER_EU, NBT_ENERGY_ACCEPTED, TD.Energy.HU), " P ", "PwP", "PhP", 'P', OP.plateDense.dat(aMat));
		aMat = MT.Bronze;               aRegistry.add("Strong Steam Boiler Tank ("      +aMat.getLocal()+")", "Steam Boilers"                       ,  1252,  1204, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   7.0F, NBT_RESISTANCE,   7.0F, NBT_CAPACITY,  960000, NBT_CAPACITY_SU,  960000, NBT_OUTPUT_SU,  96*STEAM_PER_EU, NBT_ENERGY_ACCEPTED, TD.Energy.HU), " P ", "PwP", "PhP", 'P', OP.plateDense.dat(aMat));
		aMat = MT.ArsenicCopper;        aRegistry.add("Strong Steam Boiler Tank ("      +aMat.getLocal()+")", "Steam Boilers"                       ,  1260,  1204, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   7.0F, NBT_RESISTANCE,   7.0F, NBT_CAPACITY,  960000, NBT_CAPACITY_SU,  960000, NBT_OUTPUT_SU,  96*STEAM_PER_EU, NBT_ENERGY_ACCEPTED, TD.Energy.HU), " P ", "PwP", "PhP", 'P', OP.plateDense.dat(aMat));
		aMat = MT.ArsenicBronze;        aRegistry.add("Strong Steam Boiler Tank ("      +aMat.getLocal()+")", "Steam Boilers"                       ,  1261,  1204, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   7.0F, NBT_RESISTANCE,   7.0F, NBT_CAPACITY,  960000, NBT_CAPACITY_SU, 1120000, NBT_OUTPUT_SU, 112*STEAM_PER_EU, NBT_ENERGY_ACCEPTED, TD.Energy.HU), " P ", "PwP", "PhP", 'P', OP.plateDense.dat(aMat));
		aMat = MT.Invar;                aRegistry.add("Strong Steam Boiler Tank ("      +aMat.getLocal()+")", "Steam Boilers"                       ,  1253,  1204, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_CAPACITY,  640000, NBT_CAPACITY_SU,  640000, NBT_OUTPUT_SU,  64*STEAM_PER_EU, NBT_ENERGY_ACCEPTED, TD.Energy.HU), " P ", "PwP", "PhP", 'P', OP.plateDense.dat(aMat));
		aMat = ANY.Steel;               aRegistry.add("Strong Steam Boiler Tank ("      +aMat.getLocal()+")", "Steam Boilers"                       ,  1254,  1204, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   6.0F, NBT_RESISTANCE,   6.0F, NBT_CAPACITY, 1280000, NBT_CAPACITY_SU, 1280000, NBT_OUTPUT_SU, 128*STEAM_PER_EU, NBT_ENERGY_ACCEPTED, TD.Energy.HU), " P ", "PwP", "PhP", 'P', OP.plateDense.dat(aMat));
		aMat = MT.Cr;                   aRegistry.add("Strong Steam Boiler Tank ("      +aMat.getLocal()+")", "Steam Boilers"                       ,  1255,  1204, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_CAPACITY, 3840000, NBT_CAPACITY_SU, 3840000, NBT_OUTPUT_SU, 384*STEAM_PER_EU, NBT_ENERGY_ACCEPTED, TD.Energy.HU), " P ", "PwP", "PhP", 'P', OP.plateDense.dat(aMat));
		aMat = MT.Ti;                   aRegistry.add("Strong Steam Boiler Tank ("      +aMat.getLocal()+")", "Steam Boilers"                       ,  1256,  1204, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   9.0F, NBT_RESISTANCE,   9.0F, NBT_CAPACITY, 4480000, NBT_CAPACITY_SU, 4480000, NBT_OUTPUT_SU, 448*STEAM_PER_EU, NBT_ENERGY_ACCEPTED, TD.Energy.HU), " P ", "PwP", "PhP", 'P', OP.plateDense.dat(aMat));
		aMat = MT.Netherite;            aRegistry.add("Strong Steam Boiler Tank ("      +aMat.getLocal()+")", "Steam Boilers"                       ,  1259,  1204, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   9.0F, NBT_RESISTANCE,   9.0F, NBT_CAPACITY, 4480000, NBT_CAPACITY_SU, 4480000, NBT_OUTPUT_SU, 448*STEAM_PER_EU, NBT_ENERGY_ACCEPTED, TD.Energy.HU), " P ", "PwP", "PhP", 'P', OP.plateDense.dat(aMat));
		aMat = ANY.W;                   aRegistry.add("Strong Steam Boiler Tank ("      +aMat.getLocal()+")", "Steam Boilers"                       ,  1257,  1204, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,  10.0F, NBT_RESISTANCE,  10.0F, NBT_CAPACITY, 5120000, NBT_CAPACITY_SU, 5120000, NBT_OUTPUT_SU, 512*STEAM_PER_EU, NBT_ENERGY_ACCEPTED, TD.Energy.HU), " P ", "PwP", "PhP", 'P', OP.plateDense.dat(aMat));
		aMat = MT.TungstenSteel;        aRegistry.add("Strong Steam Boiler Tank ("      +aMat.getLocal()+")", "Steam Boilers"                       ,  1258,  1204, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,  12.5F, NBT_RESISTANCE,  12.5F, NBT_CAPACITY, 5120000, NBT_CAPACITY_SU, 5120000, NBT_OUTPUT_SU, 512*STEAM_PER_EU, NBT_ENERGY_ACCEPTED, TD.Energy.HU), " P ", "PwP", "PhP", 'P', OP.plateDense.dat(aMat));
		
		
		// Steam Engines
		aClass = MultiTileEntityEngineSteam.class;
		aMat = MT.Pb;                   aRegistry.add("Steam Engine ("                  +aMat.getLocal()+")", "Engines"                             ,  1300,  1304, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_EFFICIENCY, 3000, NBT_CAPACITY,  16000, NBT_OUTPUT,  16/STEAM_PER_EU, NBT_ENERGY_EMITTED, TD.Energy.KU), "PhP", "SIS", "PwP", 'S', OP.stick.dat(aMat), 'P', OP.plateDouble.dat(aMat), 'I', OP.springSmall.dat(aMat));
		aMat = MT.TinAlloy;             aRegistry.add("Steam Engine ("                  +aMat.getLocal()+")", "Engines"                             ,  1301,  1304, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_EFFICIENCY, 4000, NBT_CAPACITY,  20000, NBT_OUTPUT,  20/STEAM_PER_EU, NBT_ENERGY_EMITTED, TD.Energy.KU), "PhP", "SIS", "PwP", 'S', OP.stick.dat(aMat), 'P', OP.plateDouble.dat(aMat), 'I', OP.springSmall.dat(aMat));
		aMat = MT.Bronze;               aRegistry.add("Steam Engine ("                  +aMat.getLocal()+")", "Engines"                             ,  1302,  1304, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   7.0F, NBT_RESISTANCE,   7.0F, NBT_EFFICIENCY, 5000, NBT_CAPACITY,  24000, NBT_OUTPUT,  24/STEAM_PER_EU, NBT_ENERGY_EMITTED, TD.Energy.KU), "PhP", "SIS", "PwP", 'S', OP.stick.dat(aMat), 'P', OP.plateDouble.dat(aMat), 'I', OP.springSmall.dat(aMat));
		aMat = MT.ArsenicCopper;        aRegistry.add("Steam Engine ("                  +aMat.getLocal()+")", "Engines"                             ,  1312,  1304, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   7.0F, NBT_RESISTANCE,   7.0F, NBT_EFFICIENCY, 5000, NBT_CAPACITY,  24000, NBT_OUTPUT,  24/STEAM_PER_EU, NBT_ENERGY_EMITTED, TD.Energy.KU), "PhP", "SIS", "PwP", 'S', OP.stick.dat(aMat), 'P', OP.plateDouble.dat(aMat), 'I', OP.springSmall.dat(aMat));
		aMat = MT.ArsenicBronze;        aRegistry.add("Steam Engine ("                  +aMat.getLocal()+")", "Engines"                             ,  1313,  1304, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   7.0F, NBT_RESISTANCE,   7.0F, NBT_EFFICIENCY, 5000, NBT_CAPACITY,  28000, NBT_OUTPUT,  28/STEAM_PER_EU, NBT_ENERGY_EMITTED, TD.Energy.KU), "PhP", "SIS", "PwP", 'S', OP.stick.dat(aMat), 'P', OP.plateDouble.dat(aMat), 'I', OP.springSmall.dat(aMat));
		aMat = MT.Brass;                aRegistry.add("Steam Engine ("                  +aMat.getLocal()+")", "Engines"                             ,  1309,  1304, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   7.0F, NBT_RESISTANCE,   7.0F, NBT_EFFICIENCY, 5000, NBT_CAPACITY,  24000, NBT_OUTPUT,  24/STEAM_PER_EU, NBT_ENERGY_EMITTED, TD.Energy.KU), "PhP", "SIS", "PwP", 'S', OP.stick.dat(aMat), 'P', OP.plateDouble.dat(aMat), 'I', OP.springSmall.dat(aMat));
		aMat = MT.Invar;                aRegistry.add("Steam Engine ("                  +aMat.getLocal()+")", "Engines"                             ,  1303,  1304, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_EFFICIENCY, 6400, NBT_CAPACITY,  16000, NBT_OUTPUT,  16/STEAM_PER_EU, NBT_ENERGY_EMITTED, TD.Energy.KU), "PhP", "SIS", "PwP", 'S', OP.stick.dat(aMat), 'P', OP.plateDouble.dat(aMat), 'I', OP.springSmall.dat(aMat));
		aMat = MT.IronWood;             aRegistry.add("Steam Engine ("                  +aMat.getLocal()+")", "Engines"                             ,  1310,  1304, aClass, aMat.mToolQuality, 16, aWooden      , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_EFFICIENCY, 6450, NBT_CAPACITY,  16000, NBT_OUTPUT,  16/STEAM_PER_EU, NBT_ENERGY_EMITTED, TD.Energy.KU), "PhP", "SIS", "PwP", 'S', OP.stick.dat(aMat), 'P', OP.plateDouble.dat(aMat), 'I', OP.springSmall.dat(aMat));
		aMat = ANY.Steel;               aRegistry.add("Steam Engine ("                  +aMat.getLocal()+")", "Engines"                             ,  1304,  1304, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   6.0F, NBT_RESISTANCE,   6.0F, NBT_EFFICIENCY, 5000, NBT_CAPACITY,  32000, NBT_OUTPUT,  32/STEAM_PER_EU, NBT_ENERGY_EMITTED, TD.Energy.KU), "PhP", "SIS", "PwP", 'S', OP.stick.dat(aMat), 'P', OP.plateDouble.dat(aMat), 'I', OP.springSmall.dat(aMat));
		aMat = MT.FierySteel;           aRegistry.add("Steam Engine ("                  +aMat.getLocal()+")", "Engines"                             ,  1311,  1304, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   7.0F, NBT_RESISTANCE,   7.0F, NBT_EFFICIENCY, 6200, NBT_CAPACITY,  64000, NBT_OUTPUT,  64/STEAM_PER_EU, NBT_ENERGY_EMITTED, TD.Energy.KU), "PhP", "SIS", "PwP", 'S', OP.stick.dat(aMat), 'P', OP.plateDouble.dat(aMat), 'I', OP.springSmall.dat(aMat));
		aMat = MT.Cr;                   aRegistry.add("Steam Engine ("                  +aMat.getLocal()+")", "Engines"                             ,  1305,  1304, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_EFFICIENCY, 6300, NBT_CAPACITY,  96000, NBT_OUTPUT,  96/STEAM_PER_EU, NBT_ENERGY_EMITTED, TD.Energy.KU), "PhP", "SIS", "PwP", 'S', OP.stick.dat(aMat), 'P', OP.plateDouble.dat(aMat), 'I', OP.springSmall.dat(aMat));
		aMat = MT.Ti;                   aRegistry.add("Steam Engine ("                  +aMat.getLocal()+")", "Engines"                             ,  1306,  1304, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   9.0F, NBT_RESISTANCE,   9.0F, NBT_EFFICIENCY, 5800, NBT_CAPACITY, 112000, NBT_OUTPUT, 112/STEAM_PER_EU, NBT_ENERGY_EMITTED, TD.Energy.KU), "PhP", "SIS", "PwP", 'S', OP.stick.dat(aMat), 'P', OP.plateDouble.dat(aMat), 'I', OP.springSmall.dat(aMat));
		aMat = ANY.W;                   aRegistry.add("Steam Engine ("                  +aMat.getLocal()+")", "Engines"                             ,  1307,  1304, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,  10.0F, NBT_RESISTANCE,  10.0F, NBT_EFFICIENCY, 5800, NBT_CAPACITY, 128000, NBT_OUTPUT, 128/STEAM_PER_EU, NBT_ENERGY_EMITTED, TD.Energy.KU), "PhP", "SIS", "PwP", 'S', OP.stick.dat(aMat), 'P', OP.plateDouble.dat(aMat), 'I', OP.springSmall.dat(aMat));
		aMat = MT.TungstenSteel;        aRegistry.add("Steam Engine ("                  +aMat.getLocal()+")", "Engines"                             ,  1308,  1304, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,  12.5F, NBT_RESISTANCE,  12.5F, NBT_EFFICIENCY, 6000, NBT_CAPACITY, 128000, NBT_OUTPUT, 128/STEAM_PER_EU, NBT_ENERGY_EMITTED, TD.Energy.KU), "PhP", "SIS", "PwP", 'S', OP.stick.dat(aMat), 'P', OP.plateDouble.dat(aMat), 'I', OP.springSmall.dat(aMat));
		
		aMat = MT.Pb;                   aRegistry.add("Strong Steam Engine ("           +aMat.getLocal()+")", "Engines"                             ,  1350,  1304, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_EFFICIENCY, 3000, NBT_CAPACITY,  64000, NBT_OUTPUT,  64/STEAM_PER_EU, NBT_ENERGY_EMITTED, TD.Energy.KU), "PhP", "SIS", "PwP", 'S', OP.stick.dat(aMat), 'P', MD.HBM.mLoaded ? OP.plateDense.mat(aMat, 1) : OP.plateDense.dat(aMat), 'I', OP.spring.dat(aMat));
		aMat = MT.TinAlloy;             aRegistry.add("Strong Steam Engine ("           +aMat.getLocal()+")", "Engines"                             ,  1351,  1304, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_EFFICIENCY, 4000, NBT_CAPACITY,  80000, NBT_OUTPUT,  80/STEAM_PER_EU, NBT_ENERGY_EMITTED, TD.Energy.KU), "PhP", "SIS", "PwP", 'S', OP.stick.dat(aMat), 'P', OP.plateDense.dat(aMat), 'I', OP.spring.dat(aMat));
		aMat = MT.Bronze;               aRegistry.add("Strong Steam Engine ("           +aMat.getLocal()+")", "Engines"                             ,  1352,  1304, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   7.0F, NBT_RESISTANCE,   7.0F, NBT_EFFICIENCY, 5000, NBT_CAPACITY,  96000, NBT_OUTPUT,  96/STEAM_PER_EU, NBT_ENERGY_EMITTED, TD.Energy.KU), "PhP", "SIS", "PwP", 'S', OP.stick.dat(aMat), 'P', OP.plateDense.dat(aMat), 'I', OP.spring.dat(aMat));
		aMat = MT.ArsenicCopper;        aRegistry.add("Strong Steam Engine ("           +aMat.getLocal()+")", "Engines"                             ,  1362,  1304, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   7.0F, NBT_RESISTANCE,   7.0F, NBT_EFFICIENCY, 5000, NBT_CAPACITY,  96000, NBT_OUTPUT,  96/STEAM_PER_EU, NBT_ENERGY_EMITTED, TD.Energy.KU), "PhP", "SIS", "PwP", 'S', OP.stick.dat(aMat), 'P', OP.plateDense.dat(aMat), 'I', OP.spring.dat(aMat));
		aMat = MT.ArsenicBronze;        aRegistry.add("Strong Steam Engine ("           +aMat.getLocal()+")", "Engines"                             ,  1363,  1304, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   7.0F, NBT_RESISTANCE,   7.0F, NBT_EFFICIENCY, 5000, NBT_CAPACITY, 112000, NBT_OUTPUT, 112/STEAM_PER_EU, NBT_ENERGY_EMITTED, TD.Energy.KU), "PhP", "SIS", "PwP", 'S', OP.stick.dat(aMat), 'P', OP.plateDense.dat(aMat), 'I', OP.spring.dat(aMat));
		aMat = MT.Brass;                aRegistry.add("Strong Steam Engine ("           +aMat.getLocal()+")", "Engines"                             ,  1359,  1304, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   7.0F, NBT_RESISTANCE,   7.0F, NBT_EFFICIENCY, 5000, NBT_CAPACITY,  96000, NBT_OUTPUT,  96/STEAM_PER_EU, NBT_ENERGY_EMITTED, TD.Energy.KU), "PhP", "SIS", "PwP", 'S', OP.stick.dat(aMat), 'P', OP.plateDense.dat(aMat), 'I', OP.spring.dat(aMat));
		aMat = MT.Invar;                aRegistry.add("Strong Steam Engine ("           +aMat.getLocal()+")", "Engines"                             ,  1353,  1304, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_EFFICIENCY, 6400, NBT_CAPACITY,  64000, NBT_OUTPUT,  64/STEAM_PER_EU, NBT_ENERGY_EMITTED, TD.Energy.KU), "PhP", "SIS", "PwP", 'S', OP.stick.dat(aMat), 'P', OP.plateDense.dat(aMat), 'I', OP.spring.dat(aMat));
		aMat = MT.IronWood;             aRegistry.add("Strong Steam Engine ("           +aMat.getLocal()+")", "Engines"                             ,  1360,  1304, aClass, aMat.mToolQuality, 16, aWooden      , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_EFFICIENCY, 6450, NBT_CAPACITY,  64000, NBT_OUTPUT,  64/STEAM_PER_EU, NBT_ENERGY_EMITTED, TD.Energy.KU), "PhP", "SIS", "PwP", 'S', OP.stick.dat(aMat), 'P', OP.plateDense.dat(aMat), 'I', OP.spring.dat(aMat));
		aMat = ANY.Steel;               aRegistry.add("Strong Steam Engine ("           +aMat.getLocal()+")", "Engines"                             ,  1354,  1304, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   6.0F, NBT_RESISTANCE,   6.0F, NBT_EFFICIENCY, 5000, NBT_CAPACITY, 128000, NBT_OUTPUT, 128/STEAM_PER_EU, NBT_ENERGY_EMITTED, TD.Energy.KU), "PhP", "SIS", "PwP", 'S', OP.stick.dat(aMat), 'P', OP.plateDense.dat(aMat), 'I', OP.spring.dat(aMat));
		aMat = MT.FierySteel;           aRegistry.add("Strong Steam Engine ("           +aMat.getLocal()+")", "Engines"                             ,  1361,  1304, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   7.0F, NBT_RESISTANCE,   7.0F, NBT_EFFICIENCY, 6200, NBT_CAPACITY, 256000, NBT_OUTPUT, 256/STEAM_PER_EU, NBT_ENERGY_EMITTED, TD.Energy.KU), "PhP", "SIS", "PwP", 'S', OP.stick.dat(aMat), 'P', OP.plateDense.dat(aMat), 'I', OP.spring.dat(aMat));
		aMat = MT.Cr;                   aRegistry.add("Strong Steam Engine ("           +aMat.getLocal()+")", "Engines"                             ,  1355,  1304, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_EFFICIENCY, 6300, NBT_CAPACITY, 384000, NBT_OUTPUT, 384/STEAM_PER_EU, NBT_ENERGY_EMITTED, TD.Energy.KU), "PhP", "SIS", "PwP", 'S', OP.stick.dat(aMat), 'P', OP.plateDense.dat(aMat), 'I', OP.spring.dat(aMat));
		aMat = MT.Ti;                   aRegistry.add("Strong Steam Engine ("           +aMat.getLocal()+")", "Engines"                             ,  1356,  1304, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   9.0F, NBT_RESISTANCE,   9.0F, NBT_EFFICIENCY, 5800, NBT_CAPACITY, 448000, NBT_OUTPUT, 448/STEAM_PER_EU, NBT_ENERGY_EMITTED, TD.Energy.KU), "PhP", "SIS", "PwP", 'S', OP.stick.dat(aMat), 'P', OP.plateDense.dat(aMat), 'I', OP.spring.dat(aMat));
		aMat = ANY.W;                   aRegistry.add("Strong Steam Engine ("           +aMat.getLocal()+")", "Engines"                             ,  1357,  1304, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,  10.0F, NBT_RESISTANCE,  10.0F, NBT_EFFICIENCY, 5800, NBT_CAPACITY, 512000, NBT_OUTPUT, 512/STEAM_PER_EU, NBT_ENERGY_EMITTED, TD.Energy.KU), "PhP", "SIS", "PwP", 'S', OP.stick.dat(aMat), 'P', OP.plateDense.dat(aMat), 'I', OP.spring.dat(aMat));
		aMat = MT.TungstenSteel;        aRegistry.add("Strong Steam Engine ("           +aMat.getLocal()+")", "Engines"                             ,  1358,  1304, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,  12.5F, NBT_RESISTANCE,  12.5F, NBT_EFFICIENCY, 6000, NBT_CAPACITY, 512000, NBT_OUTPUT, 512/STEAM_PER_EU, NBT_ENERGY_EMITTED, TD.Energy.KU), "PhP", "SIS", "PwP", 'S', OP.stick.dat(aMat), 'P', OP.plateDense.dat(aMat), 'I', OP.spring.dat(aMat));
		
		
		// Liquid Burning Boxes
		aClass = MultiTileEntityGeneratorLiquid.class;
//      aMat = MT.Pb;                   aRegistry.add("Burning Box (Liquid, "           +aMat.getLocal()+")", "Burning Boxes"                       ,  1400,  1104, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_FUELMAP, FM.Burn, NBT_EFFICIENCY,  5000, NBT_OUTPUT,  16, NBT_ENERGY_EMITTED, TD.Energy.HU), "PCP", "IwI", "BBB", 'B', Blocks.brick_block, 'P', OP.plate.dat(aMat), 'I', OP.plateCurved.dat(aMat), 'C', OP.plateDouble.dat(ANY.Cu));
//      aMat = MT.Bi;                   aRegistry.add("Burning Box (Liquid, "           +aMat.getLocal()+")", "Burning Boxes"                       ,  1401,  1104, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_FUELMAP, FM.Burn, NBT_EFFICIENCY,  4500, NBT_OUTPUT,  20, NBT_ENERGY_EMITTED, TD.Energy.HU), "PCP", "IwI", "BBB", 'B', Blocks.brick_block, 'P', OP.plate.dat(aMat), 'I', OP.plateCurved.dat(aMat), 'C', OP.plateDouble.dat(ANY.Cu));
		aMat = MT.Bronze;               aRegistry.add("Burning Box (Liquid, "           +aMat.getLocal()+")", "Burning Boxes"                       ,  1402,  1104, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   7.0F, NBT_RESISTANCE,   7.0F, NBT_FUELMAP, FM.Burn, NBT_EFFICIENCY,  7500, NBT_OUTPUT,  24, NBT_ENERGY_EMITTED, TD.Energy.HU), "PCP", "IwI", "BBB", 'B', Blocks.brick_block, 'P', OP.plate.dat(aMat), 'I', OP.plateCurved.dat(aMat), 'C', OP.plateDouble.dat(ANY.Cu));
		aMat = MT.ArsenicCopper;        aRegistry.add("Burning Box (Liquid, "           +aMat.getLocal()+")", "Burning Boxes"                       ,  1411,  1104, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   7.0F, NBT_RESISTANCE,   7.0F, NBT_FUELMAP, FM.Burn, NBT_EFFICIENCY,  8000, NBT_OUTPUT,  24, NBT_ENERGY_EMITTED, TD.Energy.HU), "PCP", "IwI", "BBB", 'B', Blocks.brick_block, 'P', OP.plate.dat(aMat), 'I', OP.plateCurved.dat(aMat), 'C', OP.plateDouble.dat(ANY.Cu));
		aMat = MT.ArsenicBronze;        aRegistry.add("Burning Box (Liquid, "           +aMat.getLocal()+")", "Burning Boxes"                       ,  1412,  1104, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   7.0F, NBT_RESISTANCE,   7.0F, NBT_FUELMAP, FM.Burn, NBT_EFFICIENCY,  9000, NBT_OUTPUT,  28, NBT_ENERGY_EMITTED, TD.Energy.HU), "PCP", "IwI", "BBB", 'B', Blocks.brick_block, 'P', OP.plate.dat(aMat), 'I', OP.plateCurved.dat(aMat), 'C', OP.plateDouble.dat(ANY.Cu));
		aMat = MT.Invar;                aRegistry.add("Burning Box (Liquid, "           +aMat.getLocal()+")", "Burning Boxes"                       ,  1403,  1104, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_FUELMAP, FM.Burn, NBT_EFFICIENCY, 10000, NBT_OUTPUT,  16, NBT_ENERGY_EMITTED, TD.Energy.HU), "PCP", "IwI", "BBB", 'B', Blocks.brick_block, 'P', OP.plate.dat(aMat), 'I', OP.plateCurved.dat(aMat), 'C', OP.plateDouble.dat(ANY.Cu));
		aMat = ANY.Steel;               aRegistry.add("Burning Box (Liquid, "           +aMat.getLocal()+")", "Burning Boxes"                       ,  1404,  1104, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   6.0F, NBT_RESISTANCE,   6.0F, NBT_FUELMAP, FM.Burn, NBT_EFFICIENCY,  7000, NBT_OUTPUT,  32, NBT_ENERGY_EMITTED, TD.Energy.HU), "PCP", "IwI", "BBB", 'B', Blocks.brick_block, 'P', OP.plate.dat(aMat), 'I', OP.plateCurved.dat(aMat), 'C', OP.plateDouble.dat(ANY.Cu));
		aMat = MT.Cr;                   aRegistry.add("Burning Box (Liquid, "           +aMat.getLocal()+")", "Burning Boxes"                       ,  1405,  1104, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_FUELMAP, FM.Burn, NBT_EFFICIENCY,  8500, NBT_OUTPUT, 112, NBT_ENERGY_EMITTED, TD.Energy.HU), "PCP", "IwI", "BBB", 'B', Blocks.brick_block, 'P', OP.plate.dat(aMat), 'I', OP.plateCurved.dat(aMat), 'C', OP.plateDouble.dat(ANY.Cu));
		aMat = MT.Ti;                   aRegistry.add("Burning Box (Liquid, "           +aMat.getLocal()+")", "Burning Boxes"                       ,  1406,  1104, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   9.0F, NBT_RESISTANCE,   9.0F, NBT_FUELMAP, FM.Burn, NBT_EFFICIENCY,  8500, NBT_OUTPUT,  96, NBT_ENERGY_EMITTED, TD.Energy.HU), "PCP", "IwI", "BBB", 'B', Blocks.brick_block, 'P', OP.plate.dat(aMat), 'I', OP.plateCurved.dat(aMat), 'C', OP.plateDouble.dat(ANY.Cu));
		aMat = MT.Netherite;            aRegistry.add("Burning Box (Liquid, "           +aMat.getLocal()+")", "Burning Boxes"                       ,  1410,  1104, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   9.0F, NBT_RESISTANCE,   9.0F, NBT_FUELMAP, FM.Burn, NBT_EFFICIENCY,  9000, NBT_OUTPUT,  96, NBT_ENERGY_EMITTED, TD.Energy.HU), "PCP", "IwI", "BBB", 'B', Blocks.brick_block, 'P', OP.plate.dat(aMat), 'I', OP.plateCurved.dat(aMat), 'C', OP.plateDouble.dat(ANY.Cu));
		aMat = ANY.W;                   aRegistry.add("Burning Box (Liquid, "           +aMat.getLocal()+")", "Burning Boxes"                       ,  1407,  1104, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,  10.0F, NBT_RESISTANCE,  10.0F, NBT_FUELMAP, FM.Burn, NBT_EFFICIENCY, 10000, NBT_OUTPUT, 128, NBT_ENERGY_EMITTED, TD.Energy.HU), "PCP", "IwI", "BBB", 'B', Blocks.brick_block, 'P', OP.plate.dat(aMat), 'I', OP.plateCurved.dat(aMat), 'C', OP.plateDouble.dat(ANY.Cu));
		aMat = MT.TungstenSteel;        aRegistry.add("Burning Box (Liquid, "           +aMat.getLocal()+")", "Burning Boxes"                       ,  1408,  1104, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,  12.5F, NBT_RESISTANCE,  12.5F, NBT_FUELMAP, FM.Burn, NBT_EFFICIENCY,  9000, NBT_OUTPUT, 128, NBT_ENERGY_EMITTED, TD.Energy.HU), "PCP", "IwI", "BBB", 'B', Blocks.brick_block, 'P', OP.plate.dat(aMat), 'I', OP.plateCurved.dat(aMat), 'C', OP.plateDouble.dat(ANY.Cu));
		aMat = MT.Ta4HfC5;              aRegistry.add("Burning Box (Liquid, "           +aMat.getLocal()+")", "Burning Boxes"                       ,  1409,  1104, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,  12.5F, NBT_RESISTANCE,  12.5F, NBT_FUELMAP, FM.Burn, NBT_EFFICIENCY, 10000, NBT_OUTPUT, 256, NBT_ENERGY_EMITTED, TD.Energy.HU), "PCP", "IwI", "BBB", 'B', Blocks.brick_block, 'P', OP.plate.dat(aMat), 'I', OP.plateCurved.dat(aMat), 'C', OP.plateDouble.dat(ANY.Cu));
		
//      aMat = MT.Pb;                   aRegistry.add("Dense Burning Box (Liquid, "     +aMat.getLocal()+")", "Burning Boxes"                       ,  1450,  1104, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_FUELMAP, FM.Burn, NBT_EFFICIENCY,  5000, NBT_OUTPUT,  64, NBT_ENERGY_EMITTED, TD.Energy.HU), "PCP", "IwI", "BBB", 'B', Blocks.brick_block, 'P', OP.plateQuintuple.dat(aMat), 'I', OP.pipeLarge.dat(aMat), 'C', OP.plateDense.dat(ANY.Cu));
//      aMat = MT.Bi;                   aRegistry.add("Dense Burning Box (Liquid, "     +aMat.getLocal()+")", "Burning Boxes"                       ,  1451,  1104, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_FUELMAP, FM.Burn, NBT_EFFICIENCY,  4500, NBT_OUTPUT,  80, NBT_ENERGY_EMITTED, TD.Energy.HU), "PCP", "IwI", "BBB", 'B', Blocks.brick_block, 'P', OP.plateQuintuple.dat(aMat), 'I', OP.pipeLarge.dat(aMat), 'C', OP.plateDense.dat(ANY.Cu));
		aMat = MT.Bronze;               aRegistry.add("Dense Burning Box (Liquid, "     +aMat.getLocal()+")", "Burning Boxes"                       ,  1452,  1104, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   7.0F, NBT_RESISTANCE,   7.0F, NBT_FUELMAP, FM.Burn, NBT_EFFICIENCY,  7500, NBT_OUTPUT,  96, NBT_ENERGY_EMITTED, TD.Energy.HU), "PCP", "IwI", "BBB", 'B', Blocks.brick_block, 'P', OP.plateQuintuple.dat(aMat), 'I', OP.pipeLarge.dat(aMat), 'C', OP.plateDense.dat(ANY.Cu));
		aMat = MT.ArsenicCopper;        aRegistry.add("Dense Burning Box (Liquid, "     +aMat.getLocal()+")", "Burning Boxes"                       ,  1461,  1104, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   7.0F, NBT_RESISTANCE,   7.0F, NBT_FUELMAP, FM.Burn, NBT_EFFICIENCY,  8000, NBT_OUTPUT,  96, NBT_ENERGY_EMITTED, TD.Energy.HU), "PCP", "IwI", "BBB", 'B', Blocks.brick_block, 'P', OP.plateQuintuple.dat(aMat), 'I', OP.pipeLarge.dat(aMat), 'C', OP.plateDense.dat(ANY.Cu));
		aMat = MT.ArsenicBronze;        aRegistry.add("Dense Burning Box (Liquid, "     +aMat.getLocal()+")", "Burning Boxes"                       ,  1462,  1104, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   7.0F, NBT_RESISTANCE,   7.0F, NBT_FUELMAP, FM.Burn, NBT_EFFICIENCY,  9000, NBT_OUTPUT, 112, NBT_ENERGY_EMITTED, TD.Energy.HU), "PCP", "IwI", "BBB", 'B', Blocks.brick_block, 'P', OP.plateQuintuple.dat(aMat), 'I', OP.pipeLarge.dat(aMat), 'C', OP.plateDense.dat(ANY.Cu));
		aMat = MT.Invar;                aRegistry.add("Dense Burning Box (Liquid, "     +aMat.getLocal()+")", "Burning Boxes"                       ,  1453,  1104, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_FUELMAP, FM.Burn, NBT_EFFICIENCY, 10000, NBT_OUTPUT,  64, NBT_ENERGY_EMITTED, TD.Energy.HU), "PCP", "IwI", "BBB", 'B', Blocks.brick_block, 'P', OP.plateQuintuple.dat(aMat), 'I', OP.pipeLarge.dat(aMat), 'C', OP.plateDense.dat(ANY.Cu));
		aMat = ANY.Steel;               aRegistry.add("Dense Burning Box (Liquid, "     +aMat.getLocal()+")", "Burning Boxes"                       ,  1454,  1104, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   6.0F, NBT_RESISTANCE,   6.0F, NBT_FUELMAP, FM.Burn, NBT_EFFICIENCY,  7000, NBT_OUTPUT, 128, NBT_ENERGY_EMITTED, TD.Energy.HU), "PCP", "IwI", "BBB", 'B', Blocks.brick_block, 'P', OP.plateQuintuple.dat(aMat), 'I', OP.pipeLarge.dat(aMat), 'C', OP.plateDense.dat(ANY.Cu));
		aMat = MT.Cr;                   aRegistry.add("Dense Burning Box (Liquid, "     +aMat.getLocal()+")", "Burning Boxes"                       ,  1455,  1104, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_FUELMAP, FM.Burn, NBT_EFFICIENCY,  8500, NBT_OUTPUT, 448, NBT_ENERGY_EMITTED, TD.Energy.HU), "PCP", "IwI", "BBB", 'B', Blocks.brick_block, 'P', OP.plateQuintuple.dat(aMat), 'I', OP.pipeLarge.dat(aMat), 'C', OP.plateDense.dat(ANY.Cu));
		aMat = MT.Ti;                   aRegistry.add("Dense Burning Box (Liquid, "     +aMat.getLocal()+")", "Burning Boxes"                       ,  1456,  1104, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   9.0F, NBT_RESISTANCE,   9.0F, NBT_FUELMAP, FM.Burn, NBT_EFFICIENCY,  8500, NBT_OUTPUT, 384, NBT_ENERGY_EMITTED, TD.Energy.HU), "PCP", "IwI", "BBB", 'B', Blocks.brick_block, 'P', OP.plateQuintuple.dat(aMat), 'I', OP.pipeLarge.dat(aMat), 'C', OP.plateDense.dat(ANY.Cu));
		aMat = MT.Netherite;            aRegistry.add("Dense Burning Box (Liquid, "     +aMat.getLocal()+")", "Burning Boxes"                       ,  1460,  1104, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   9.0F, NBT_RESISTANCE,   9.0F, NBT_FUELMAP, FM.Burn, NBT_EFFICIENCY,  9000, NBT_OUTPUT, 384, NBT_ENERGY_EMITTED, TD.Energy.HU), "PCP", "IwI", "BBB", 'B', Blocks.brick_block, 'P', OP.plateQuintuple.dat(aMat), 'I', OP.pipeLarge.dat(aMat), 'C', OP.plateDense.dat(ANY.Cu));
		aMat = ANY.W;                   aRegistry.add("Dense Burning Box (Liquid, "     +aMat.getLocal()+")", "Burning Boxes"                       ,  1457,  1104, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,  10.0F, NBT_RESISTANCE,  10.0F, NBT_FUELMAP, FM.Burn, NBT_EFFICIENCY, 10000, NBT_OUTPUT, 512, NBT_ENERGY_EMITTED, TD.Energy.HU), "PCP", "IwI", "BBB", 'B', Blocks.brick_block, 'P', OP.plateQuintuple.dat(aMat), 'I', OP.pipeLarge.dat(aMat), 'C', OP.plateDense.dat(ANY.Cu));
		aMat = MT.TungstenSteel;        aRegistry.add("Dense Burning Box (Liquid, "     +aMat.getLocal()+")", "Burning Boxes"                       ,  1458,  1104, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,  12.5F, NBT_RESISTANCE,  12.5F, NBT_FUELMAP, FM.Burn, NBT_EFFICIENCY,  9000, NBT_OUTPUT, 512, NBT_ENERGY_EMITTED, TD.Energy.HU), "PCP", "IwI", "BBB", 'B', Blocks.brick_block, 'P', OP.plateQuintuple.dat(aMat), 'I', OP.pipeLarge.dat(aMat), 'C', OP.plateDense.dat(ANY.Cu));
		aMat = MT.Ta4HfC5;              aRegistry.add("Dense Burning Box (Liquid, "     +aMat.getLocal()+")", "Burning Boxes"                       ,  1459,  1104, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,  12.5F, NBT_RESISTANCE,  12.5F, NBT_FUELMAP, FM.Burn, NBT_EFFICIENCY, 10000, NBT_OUTPUT,1024, NBT_ENERGY_EMITTED, TD.Energy.HU), "PCP", "IwI", "BBB", 'B', Blocks.brick_block, 'P', OP.plateQuintuple.dat(aMat), 'I', OP.pipeLarge.dat(aMat), 'C', OP.plateDense.dat(ANY.Cu));
		
		// Gas Burning Boxes
		aClass = MultiTileEntityGeneratorGas.class;
//      aMat = MT.Pb;                   aRegistry.add("Burning Box (Gas, "              +aMat.getLocal()+")", "Burning Boxes"                       ,  1600,  1104, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_FUELMAP, FM.Burn, NBT_EFFICIENCY,  5000, NBT_OUTPUT,  16, NBT_ENERGY_EMITTED, TD.Energy.HU), "PCP", "BwB", "BIB", 'B', Blocks.brick_block, 'P', OP.plate.dat(aMat), 'I', OP.plateCurved.dat(aMat), 'C', OP.plateDouble.dat(ANY.Cu));
//      aMat = MT.Bi;                   aRegistry.add("Burning Box (Gas, "              +aMat.getLocal()+")", "Burning Boxes"                       ,  1601,  1104, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_FUELMAP, FM.Burn, NBT_EFFICIENCY,  4500, NBT_OUTPUT,  20, NBT_ENERGY_EMITTED, TD.Energy.HU), "PCP", "BwB", "BIB", 'B', Blocks.brick_block, 'P', OP.plate.dat(aMat), 'I', OP.plateCurved.dat(aMat), 'C', OP.plateDouble.dat(ANY.Cu));
		aMat = MT.Bronze;               aRegistry.add("Burning Box (Gas, "              +aMat.getLocal()+")", "Burning Boxes"                       ,  1602,  1104, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   7.0F, NBT_RESISTANCE,   7.0F, NBT_FUELMAP, FM.Burn, NBT_EFFICIENCY,  7500, NBT_OUTPUT,  24, NBT_ENERGY_EMITTED, TD.Energy.HU), "PCP", "BwB", "BIB", 'B', Blocks.brick_block, 'P', OP.plate.dat(aMat), 'I', OP.plateCurved.dat(aMat), 'C', OP.plateDouble.dat(ANY.Cu));
		aMat = MT.ArsenicCopper;        aRegistry.add("Burning Box (Gas, "              +aMat.getLocal()+")", "Burning Boxes"                       ,  1611,  1104, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   7.0F, NBT_RESISTANCE,   7.0F, NBT_FUELMAP, FM.Burn, NBT_EFFICIENCY,  8000, NBT_OUTPUT,  24, NBT_ENERGY_EMITTED, TD.Energy.HU), "PCP", "BwB", "BIB", 'B', Blocks.brick_block, 'P', OP.plate.dat(aMat), 'I', OP.plateCurved.dat(aMat), 'C', OP.plateDouble.dat(ANY.Cu));
		aMat = MT.ArsenicBronze;        aRegistry.add("Burning Box (Gas, "              +aMat.getLocal()+")", "Burning Boxes"                       ,  1612,  1104, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   7.0F, NBT_RESISTANCE,   7.0F, NBT_FUELMAP, FM.Burn, NBT_EFFICIENCY,  9000, NBT_OUTPUT,  28, NBT_ENERGY_EMITTED, TD.Energy.HU), "PCP", "BwB", "BIB", 'B', Blocks.brick_block, 'P', OP.plate.dat(aMat), 'I', OP.plateCurved.dat(aMat), 'C', OP.plateDouble.dat(ANY.Cu));
		aMat = MT.Invar;                aRegistry.add("Burning Box (Gas, "              +aMat.getLocal()+")", "Burning Boxes"                       ,  1603,  1104, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_FUELMAP, FM.Burn, NBT_EFFICIENCY, 10000, NBT_OUTPUT,  16, NBT_ENERGY_EMITTED, TD.Energy.HU), "PCP", "BwB", "BIB", 'B', Blocks.brick_block, 'P', OP.plate.dat(aMat), 'I', OP.plateCurved.dat(aMat), 'C', OP.plateDouble.dat(ANY.Cu));
		aMat = ANY.Steel;               aRegistry.add("Burning Box (Gas, "              +aMat.getLocal()+")", "Burning Boxes"                       ,  1604,  1104, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   6.0F, NBT_RESISTANCE,   6.0F, NBT_FUELMAP, FM.Burn, NBT_EFFICIENCY,  7000, NBT_OUTPUT,  32, NBT_ENERGY_EMITTED, TD.Energy.HU), "PCP", "BwB", "BIB", 'B', Blocks.brick_block, 'P', OP.plate.dat(aMat), 'I', OP.plateCurved.dat(aMat), 'C', OP.plateDouble.dat(ANY.Cu));
		aMat = MT.Cr;                   aRegistry.add("Burning Box (Gas, "              +aMat.getLocal()+")", "Burning Boxes"                       ,  1605,  1104, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_FUELMAP, FM.Burn, NBT_EFFICIENCY,  8500, NBT_OUTPUT, 112, NBT_ENERGY_EMITTED, TD.Energy.HU), "PCP", "BwB", "BIB", 'B', Blocks.brick_block, 'P', OP.plate.dat(aMat), 'I', OP.plateCurved.dat(aMat), 'C', OP.plateDouble.dat(ANY.Cu));
		aMat = MT.Ti;                   aRegistry.add("Burning Box (Gas, "              +aMat.getLocal()+")", "Burning Boxes"                       ,  1606,  1104, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   9.0F, NBT_RESISTANCE,   9.0F, NBT_FUELMAP, FM.Burn, NBT_EFFICIENCY,  8500, NBT_OUTPUT,  96, NBT_ENERGY_EMITTED, TD.Energy.HU), "PCP", "BwB", "BIB", 'B', Blocks.brick_block, 'P', OP.plate.dat(aMat), 'I', OP.plateCurved.dat(aMat), 'C', OP.plateDouble.dat(ANY.Cu));
		aMat = MT.Netherite;            aRegistry.add("Burning Box (Gas, "              +aMat.getLocal()+")", "Burning Boxes"                       ,  1610,  1104, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   9.0F, NBT_RESISTANCE,   9.0F, NBT_FUELMAP, FM.Burn, NBT_EFFICIENCY,  9000, NBT_OUTPUT,  96, NBT_ENERGY_EMITTED, TD.Energy.HU), "PCP", "BwB", "BIB", 'B', Blocks.brick_block, 'P', OP.plate.dat(aMat), 'I', OP.plateCurved.dat(aMat), 'C', OP.plateDouble.dat(ANY.Cu));
		aMat = ANY.W;                   aRegistry.add("Burning Box (Gas, "              +aMat.getLocal()+")", "Burning Boxes"                       ,  1607,  1104, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,  10.0F, NBT_RESISTANCE,  10.0F, NBT_FUELMAP, FM.Burn, NBT_EFFICIENCY, 10000, NBT_OUTPUT, 128, NBT_ENERGY_EMITTED, TD.Energy.HU), "PCP", "BwB", "BIB", 'B', Blocks.brick_block, 'P', OP.plate.dat(aMat), 'I', OP.plateCurved.dat(aMat), 'C', OP.plateDouble.dat(ANY.Cu));
		aMat = MT.TungstenSteel;        aRegistry.add("Burning Box (Gas, "              +aMat.getLocal()+")", "Burning Boxes"                       ,  1608,  1104, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,  12.5F, NBT_RESISTANCE,  12.5F, NBT_FUELMAP, FM.Burn, NBT_EFFICIENCY,  9000, NBT_OUTPUT, 128, NBT_ENERGY_EMITTED, TD.Energy.HU), "PCP", "BwB", "BIB", 'B', Blocks.brick_block, 'P', OP.plate.dat(aMat), 'I', OP.plateCurved.dat(aMat), 'C', OP.plateDouble.dat(ANY.Cu));
		aMat = MT.Ta4HfC5;              aRegistry.add("Burning Box (Gas, "              +aMat.getLocal()+")", "Burning Boxes"                       ,  1609,  1104, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,  12.5F, NBT_RESISTANCE,  12.5F, NBT_FUELMAP, FM.Burn, NBT_EFFICIENCY, 10000, NBT_OUTPUT, 256, NBT_ENERGY_EMITTED, TD.Energy.HU), "PCP", "BwB", "BIB", 'B', Blocks.brick_block, 'P', OP.plate.dat(aMat), 'I', OP.plateCurved.dat(aMat), 'C', OP.plateDouble.dat(ANY.Cu));
		
//      aMat = MT.Pb;                   aRegistry.add("Dense Burning Box (Gas, "        +aMat.getLocal()+")", "Burning Boxes"                       ,  1650,  1104, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_FUELMAP, FM.Burn, NBT_EFFICIENCY,  5000, NBT_OUTPUT,  64, NBT_ENERGY_EMITTED, TD.Energy.HU), "PCP", "BwB", "BIB", 'B', Blocks.brick_block, 'P', OP.plateQuintuple.dat(aMat), 'I', OP.pipeLarge.dat(aMat), 'C', OP.plateDense.dat(ANY.Cu));
//      aMat = MT.Bi;                   aRegistry.add("Dense Burning Box (Gas, "        +aMat.getLocal()+")", "Burning Boxes"                       ,  1651,  1104, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_FUELMAP, FM.Burn, NBT_EFFICIENCY,  4500, NBT_OUTPUT,  80, NBT_ENERGY_EMITTED, TD.Energy.HU), "PCP", "BwB", "BIB", 'B', Blocks.brick_block, 'P', OP.plateQuintuple.dat(aMat), 'I', OP.pipeLarge.dat(aMat), 'C', OP.plateDense.dat(ANY.Cu));
		aMat = MT.Bronze;               aRegistry.add("Dense Burning Box (Gas, "        +aMat.getLocal()+")", "Burning Boxes"                       ,  1652,  1104, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   7.0F, NBT_RESISTANCE,   7.0F, NBT_FUELMAP, FM.Burn, NBT_EFFICIENCY,  7500, NBT_OUTPUT,  96, NBT_ENERGY_EMITTED, TD.Energy.HU), "PCP", "BwB", "BIB", 'B', Blocks.brick_block, 'P', OP.plateQuintuple.dat(aMat), 'I', OP.pipeLarge.dat(aMat), 'C', OP.plateDense.dat(ANY.Cu));
		aMat = MT.ArsenicCopper;        aRegistry.add("Dense Burning Box (Gas, "        +aMat.getLocal()+")", "Burning Boxes"                       ,  1661,  1104, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   7.0F, NBT_RESISTANCE,   7.0F, NBT_FUELMAP, FM.Burn, NBT_EFFICIENCY,  8000, NBT_OUTPUT,  96, NBT_ENERGY_EMITTED, TD.Energy.HU), "PCP", "BwB", "BIB", 'B', Blocks.brick_block, 'P', OP.plateQuintuple.dat(aMat), 'I', OP.pipeLarge.dat(aMat), 'C', OP.plateDense.dat(ANY.Cu));
		aMat = MT.ArsenicBronze;        aRegistry.add("Dense Burning Box (Gas, "        +aMat.getLocal()+")", "Burning Boxes"                       ,  1662,  1104, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   7.0F, NBT_RESISTANCE,   7.0F, NBT_FUELMAP, FM.Burn, NBT_EFFICIENCY,  9000, NBT_OUTPUT, 112, NBT_ENERGY_EMITTED, TD.Energy.HU), "PCP", "BwB", "BIB", 'B', Blocks.brick_block, 'P', OP.plateQuintuple.dat(aMat), 'I', OP.pipeLarge.dat(aMat), 'C', OP.plateDense.dat(ANY.Cu));
		aMat = MT.Invar;                aRegistry.add("Dense Burning Box (Gas, "        +aMat.getLocal()+")", "Burning Boxes"                       ,  1653,  1104, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_FUELMAP, FM.Burn, NBT_EFFICIENCY, 10000, NBT_OUTPUT,  64, NBT_ENERGY_EMITTED, TD.Energy.HU), "PCP", "BwB", "BIB", 'B', Blocks.brick_block, 'P', OP.plateQuintuple.dat(aMat), 'I', OP.pipeLarge.dat(aMat), 'C', OP.plateDense.dat(ANY.Cu));
		aMat = ANY.Steel;               aRegistry.add("Dense Burning Box (Gas, "        +aMat.getLocal()+")", "Burning Boxes"                       ,  1654,  1104, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   6.0F, NBT_RESISTANCE,   6.0F, NBT_FUELMAP, FM.Burn, NBT_EFFICIENCY,  7000, NBT_OUTPUT, 128, NBT_ENERGY_EMITTED, TD.Energy.HU), "PCP", "BwB", "BIB", 'B', Blocks.brick_block, 'P', OP.plateQuintuple.dat(aMat), 'I', OP.pipeLarge.dat(aMat), 'C', OP.plateDense.dat(ANY.Cu));
		aMat = MT.Cr;                   aRegistry.add("Dense Burning Box (Gas, "        +aMat.getLocal()+")", "Burning Boxes"                       ,  1655,  1104, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_FUELMAP, FM.Burn, NBT_EFFICIENCY,  8500, NBT_OUTPUT, 448, NBT_ENERGY_EMITTED, TD.Energy.HU), "PCP", "BwB", "BIB", 'B', Blocks.brick_block, 'P', OP.plateQuintuple.dat(aMat), 'I', OP.pipeLarge.dat(aMat), 'C', OP.plateDense.dat(ANY.Cu));
		aMat = MT.Ti;                   aRegistry.add("Dense Burning Box (Gas, "        +aMat.getLocal()+")", "Burning Boxes"                       ,  1656,  1104, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   9.0F, NBT_RESISTANCE,   9.0F, NBT_FUELMAP, FM.Burn, NBT_EFFICIENCY,  8500, NBT_OUTPUT, 384, NBT_ENERGY_EMITTED, TD.Energy.HU), "PCP", "BwB", "BIB", 'B', Blocks.brick_block, 'P', OP.plateQuintuple.dat(aMat), 'I', OP.pipeLarge.dat(aMat), 'C', OP.plateDense.dat(ANY.Cu));
		aMat = MT.Netherite;            aRegistry.add("Dense Burning Box (Gas, "        +aMat.getLocal()+")", "Burning Boxes"                       ,  1660,  1104, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   9.0F, NBT_RESISTANCE,   9.0F, NBT_FUELMAP, FM.Burn, NBT_EFFICIENCY,  9000, NBT_OUTPUT, 384, NBT_ENERGY_EMITTED, TD.Energy.HU), "PCP", "BwB", "BIB", 'B', Blocks.brick_block, 'P', OP.plateQuintuple.dat(aMat), 'I', OP.pipeLarge.dat(aMat), 'C', OP.plateDense.dat(ANY.Cu));
		aMat = ANY.W;                   aRegistry.add("Dense Burning Box (Gas, "        +aMat.getLocal()+")", "Burning Boxes"                       ,  1657,  1104, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,  10.0F, NBT_RESISTANCE,  10.0F, NBT_FUELMAP, FM.Burn, NBT_EFFICIENCY, 10000, NBT_OUTPUT, 512, NBT_ENERGY_EMITTED, TD.Energy.HU), "PCP", "BwB", "BIB", 'B', Blocks.brick_block, 'P', OP.plateQuintuple.dat(aMat), 'I', OP.pipeLarge.dat(aMat), 'C', OP.plateDense.dat(ANY.Cu));
		aMat = MT.TungstenSteel;        aRegistry.add("Dense Burning Box (Gas, "        +aMat.getLocal()+")", "Burning Boxes"                       ,  1658,  1104, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,  12.5F, NBT_RESISTANCE,  12.5F, NBT_FUELMAP, FM.Burn, NBT_EFFICIENCY,  9000, NBT_OUTPUT, 512, NBT_ENERGY_EMITTED, TD.Energy.HU), "PCP", "BwB", "BIB", 'B', Blocks.brick_block, 'P', OP.plateQuintuple.dat(aMat), 'I', OP.pipeLarge.dat(aMat), 'C', OP.plateDense.dat(ANY.Cu));
		aMat = MT.Ta4HfC5;              aRegistry.add("Dense Burning Box (Gas, "        +aMat.getLocal()+")", "Burning Boxes"                       ,  1659,  1104, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,  12.5F, NBT_RESISTANCE,  12.5F, NBT_FUELMAP, FM.Burn, NBT_EFFICIENCY, 10000, NBT_OUTPUT,1024, NBT_ENERGY_EMITTED, TD.Energy.HU), "PCP", "BwB", "BIB", 'B', Blocks.brick_block, 'P', OP.plateQuintuple.dat(aMat), 'I', OP.pipeLarge.dat(aMat), 'C', OP.plateDense.dat(ANY.Cu));
		
		
		// Fluidized Burning Boxes
		aClass = MultiTileEntityGeneratorFluidBed.class;
		aMat = MT.Pb;                   aRegistry.add("Fluidized Bed Burning Box ("          +aMat.getLocal()+")", "Burning Boxes"                  ,  9000,  1104, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_FUELMAP, FM.FluidBed, NBT_EFFICIENCY,  5000, NBT_OUTPUT,  64, NBT_ENERGY_EMITTED, TD.Energy.HU), "PCP", "UwU", "BXB", 'B', Blocks.brick_block, 'U', OP.plateCurved.dat(aMat), 'X', OP.rotor.dat(aMat), 'P', OP.plate.dat(aMat), 'C', OP.plateDouble.dat(ANY.Cu));
		aMat = MT.Bi;                   aRegistry.add("Fluidized Bed Burning Box ("          +aMat.getLocal()+")", "Burning Boxes"                  ,  9001,  1104, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_FUELMAP, FM.FluidBed, NBT_EFFICIENCY,  4500, NBT_OUTPUT,  80, NBT_ENERGY_EMITTED, TD.Energy.HU), "PCP", "UwU", "BXB", 'B', Blocks.brick_block, 'U', OP.plateCurved.dat(aMat), 'X', OP.rotor.dat(aMat), 'P', OP.plate.dat(aMat), 'C', OP.plateDouble.dat(ANY.Cu));
		aMat = MT.Bronze;               aRegistry.add("Fluidized Bed Burning Box ("          +aMat.getLocal()+")", "Burning Boxes"                  ,  9002,  1104, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   7.0F, NBT_RESISTANCE,   7.0F, NBT_FUELMAP, FM.FluidBed, NBT_EFFICIENCY,  7500, NBT_OUTPUT,  96, NBT_ENERGY_EMITTED, TD.Energy.HU), "PCP", "UwU", "BXB", 'B', Blocks.brick_block, 'U', OP.plateCurved.dat(aMat), 'X', OP.rotor.dat(aMat), 'P', OP.plate.dat(aMat), 'C', OP.plateDouble.dat(ANY.Cu));
		aMat = MT.ArsenicCopper;        aRegistry.add("Fluidized Bed Burning Box ("          +aMat.getLocal()+")", "Burning Boxes"                  ,  9011,  1104, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   7.0F, NBT_RESISTANCE,   7.0F, NBT_FUELMAP, FM.FluidBed, NBT_EFFICIENCY,  8000, NBT_OUTPUT,  96, NBT_ENERGY_EMITTED, TD.Energy.HU), "PCP", "UwU", "BXB", 'B', Blocks.brick_block, 'U', OP.plateCurved.dat(aMat), 'X', OP.rotor.dat(aMat), 'P', OP.plate.dat(aMat), 'C', OP.plateDouble.dat(ANY.Cu));
		aMat = MT.ArsenicBronze;        aRegistry.add("Fluidized Bed Burning Box ("          +aMat.getLocal()+")", "Burning Boxes"                  ,  9012,  1104, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   7.0F, NBT_RESISTANCE,   7.0F, NBT_FUELMAP, FM.FluidBed, NBT_EFFICIENCY,  9000, NBT_OUTPUT, 112, NBT_ENERGY_EMITTED, TD.Energy.HU), "PCP", "UwU", "BXB", 'B', Blocks.brick_block, 'U', OP.plateCurved.dat(aMat), 'X', OP.rotor.dat(aMat), 'P', OP.plate.dat(aMat), 'C', OP.plateDouble.dat(ANY.Cu));
		aMat = MT.Invar;                aRegistry.add("Fluidized Bed Burning Box ("          +aMat.getLocal()+")", "Burning Boxes"                  ,  9003,  1104, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_FUELMAP, FM.FluidBed, NBT_EFFICIENCY, 10000, NBT_OUTPUT,  64, NBT_ENERGY_EMITTED, TD.Energy.HU), "PCP", "UwU", "BXB", 'B', Blocks.brick_block, 'U', OP.plateCurved.dat(aMat), 'X', OP.rotor.dat(aMat), 'P', OP.plate.dat(aMat), 'C', OP.plateDouble.dat(ANY.Cu));
		aMat = ANY.Steel;               aRegistry.add("Fluidized Bed Burning Box ("          +aMat.getLocal()+")", "Burning Boxes"                  ,  9004,  1104, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   6.0F, NBT_RESISTANCE,   6.0F, NBT_FUELMAP, FM.FluidBed, NBT_EFFICIENCY,  7000, NBT_OUTPUT, 128, NBT_ENERGY_EMITTED, TD.Energy.HU), "PCP", "UwU", "BXB", 'B', Blocks.brick_block, 'U', OP.plateCurved.dat(aMat), 'X', OP.rotor.dat(aMat), 'P', OP.plate.dat(aMat), 'C', OP.plateDouble.dat(ANY.Cu));
		aMat = MT.Cr;                   aRegistry.add("Fluidized Bed Burning Box ("          +aMat.getLocal()+")", "Burning Boxes"                  ,  9005,  1104, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_FUELMAP, FM.FluidBed, NBT_EFFICIENCY,  8500, NBT_OUTPUT, 448, NBT_ENERGY_EMITTED, TD.Energy.HU), "PCP", "UwU", "BXB", 'B', Blocks.brick_block, 'U', OP.plateCurved.dat(aMat), 'X', OP.rotor.dat(aMat), 'P', OP.plate.dat(aMat), 'C', OP.plateDouble.dat(ANY.Cu));
		aMat = MT.Ti;                   aRegistry.add("Fluidized Bed Burning Box ("          +aMat.getLocal()+")", "Burning Boxes"                  ,  9006,  1104, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   9.0F, NBT_RESISTANCE,   9.0F, NBT_FUELMAP, FM.FluidBed, NBT_EFFICIENCY,  8500, NBT_OUTPUT, 384, NBT_ENERGY_EMITTED, TD.Energy.HU), "PCP", "UwU", "BXB", 'B', Blocks.brick_block, 'U', OP.plateCurved.dat(aMat), 'X', OP.rotor.dat(aMat), 'P', OP.plate.dat(aMat), 'C', OP.plateDouble.dat(ANY.Cu));
		aMat = MT.Netherite;            aRegistry.add("Fluidized Bed Burning Box ("          +aMat.getLocal()+")", "Burning Boxes"                  ,  9010,  1104, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   9.0F, NBT_RESISTANCE,   9.0F, NBT_FUELMAP, FM.FluidBed, NBT_EFFICIENCY,  9000, NBT_OUTPUT, 384, NBT_ENERGY_EMITTED, TD.Energy.HU), "PCP", "UwU", "BXB", 'B', Blocks.brick_block, 'U', OP.plateCurved.dat(aMat), 'X', OP.rotor.dat(aMat), 'P', OP.plate.dat(aMat), 'C', OP.plateDouble.dat(ANY.Cu));
		aMat = ANY.W;                   aRegistry.add("Fluidized Bed Burning Box ("          +aMat.getLocal()+")", "Burning Boxes"                  ,  9007,  1104, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,  10.0F, NBT_RESISTANCE,  10.0F, NBT_FUELMAP, FM.FluidBed, NBT_EFFICIENCY, 10000, NBT_OUTPUT, 512, NBT_ENERGY_EMITTED, TD.Energy.HU), "PCP", "UwU", "BXB", 'B', Blocks.brick_block, 'U', OP.plateCurved.dat(aMat), 'X', OP.rotor.dat(aMat), 'P', OP.plate.dat(aMat), 'C', OP.plateDouble.dat(ANY.Cu));
		aMat = MT.TungstenSteel;        aRegistry.add("Fluidized Bed Burning Box ("          +aMat.getLocal()+")", "Burning Boxes"                  ,  9008,  1104, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,  12.5F, NBT_RESISTANCE,  12.5F, NBT_FUELMAP, FM.FluidBed, NBT_EFFICIENCY,  9000, NBT_OUTPUT, 512, NBT_ENERGY_EMITTED, TD.Energy.HU), "PCP", "UwU", "BXB", 'B', Blocks.brick_block, 'U', OP.plateCurved.dat(aMat), 'X', OP.rotor.dat(aMat), 'P', OP.plate.dat(aMat), 'C', OP.plateDouble.dat(ANY.Cu));
		aMat = MT.Ta4HfC5;              aRegistry.add("Fluidized Bed Burning Box ("          +aMat.getLocal()+")", "Burning Boxes"                  ,  9009,  1104, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,  12.5F, NBT_RESISTANCE,  12.5F, NBT_FUELMAP, FM.FluidBed, NBT_EFFICIENCY, 10000, NBT_OUTPUT,1024, NBT_ENERGY_EMITTED, TD.Energy.HU), "PCP", "UwU", "BXB", 'B', Blocks.brick_block, 'U', OP.plateCurved.dat(aMat), 'X', OP.rotor.dat(aMat), 'P', OP.plate.dat(aMat), 'C', OP.plateDouble.dat(ANY.Cu));
		
		aMat = MT.Pb;                   aRegistry.add("Dense Fluidized Bed Burning Box ("    +aMat.getLocal()+")", "Burning Boxes"                  ,  9050,  1104, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_FUELMAP, FM.FluidBed, NBT_EFFICIENCY,  5000, NBT_OUTPUT, 256, NBT_ENERGY_EMITTED, TD.Energy.HU), "PCP", "UwU", "BXB", 'B', Blocks.brick_block, 'U', OP.plateCurved.dat(aMat), 'X', OP.rotor.dat(aMat), 'P', OP.plateQuintuple.dat(aMat), 'C', OP.plateDense.dat(ANY.Cu));
		aMat = MT.Bi;                   aRegistry.add("Dense Fluidized Bed Burning Box ("    +aMat.getLocal()+")", "Burning Boxes"                  ,  9051,  1104, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_FUELMAP, FM.FluidBed, NBT_EFFICIENCY,  4500, NBT_OUTPUT, 320, NBT_ENERGY_EMITTED, TD.Energy.HU), "PCP", "UwU", "BXB", 'B', Blocks.brick_block, 'U', OP.plateCurved.dat(aMat), 'X', OP.rotor.dat(aMat), 'P', OP.plateQuintuple.dat(aMat), 'C', OP.plateDense.dat(ANY.Cu));
		aMat = MT.Bronze;               aRegistry.add("Dense Fluidized Bed Burning Box ("    +aMat.getLocal()+")", "Burning Boxes"                  ,  9052,  1104, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   7.0F, NBT_RESISTANCE,   7.0F, NBT_FUELMAP, FM.FluidBed, NBT_EFFICIENCY,  7500, NBT_OUTPUT, 384, NBT_ENERGY_EMITTED, TD.Energy.HU), "PCP", "UwU", "BXB", 'B', Blocks.brick_block, 'U', OP.plateCurved.dat(aMat), 'X', OP.rotor.dat(aMat), 'P', OP.plateQuintuple.dat(aMat), 'C', OP.plateDense.dat(ANY.Cu));
		aMat = MT.ArsenicCopper;        aRegistry.add("Dense Fluidized Bed Burning Box ("    +aMat.getLocal()+")", "Burning Boxes"                  ,  9061,  1104, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   7.0F, NBT_RESISTANCE,   7.0F, NBT_FUELMAP, FM.FluidBed, NBT_EFFICIENCY,  8000, NBT_OUTPUT, 384, NBT_ENERGY_EMITTED, TD.Energy.HU), "PCP", "UwU", "BXB", 'B', Blocks.brick_block, 'U', OP.plateCurved.dat(aMat), 'X', OP.rotor.dat(aMat), 'P', OP.plateQuintuple.dat(aMat), 'C', OP.plateDense.dat(ANY.Cu));
		aMat = MT.ArsenicBronze;        aRegistry.add("Dense Fluidized Bed Burning Box ("    +aMat.getLocal()+")", "Burning Boxes"                  ,  9062,  1104, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   7.0F, NBT_RESISTANCE,   7.0F, NBT_FUELMAP, FM.FluidBed, NBT_EFFICIENCY,  9000, NBT_OUTPUT, 448, NBT_ENERGY_EMITTED, TD.Energy.HU), "PCP", "UwU", "BXB", 'B', Blocks.brick_block, 'U', OP.plateCurved.dat(aMat), 'X', OP.rotor.dat(aMat), 'P', OP.plateQuintuple.dat(aMat), 'C', OP.plateDense.dat(ANY.Cu));
		aMat = MT.Invar;                aRegistry.add("Dense Fluidized Bed Burning Box ("    +aMat.getLocal()+")", "Burning Boxes"                  ,  9053,  1104, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_FUELMAP, FM.FluidBed, NBT_EFFICIENCY, 10000, NBT_OUTPUT, 256, NBT_ENERGY_EMITTED, TD.Energy.HU), "PCP", "UwU", "BXB", 'B', Blocks.brick_block, 'U', OP.plateCurved.dat(aMat), 'X', OP.rotor.dat(aMat), 'P', OP.plateQuintuple.dat(aMat), 'C', OP.plateDense.dat(ANY.Cu));
		aMat = ANY.Steel;               aRegistry.add("Dense Fluidized Bed Burning Box ("    +aMat.getLocal()+")", "Burning Boxes"                  ,  9054,  1104, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   6.0F, NBT_RESISTANCE,   6.0F, NBT_FUELMAP, FM.FluidBed, NBT_EFFICIENCY,  7000, NBT_OUTPUT, 512, NBT_ENERGY_EMITTED, TD.Energy.HU), "PCP", "UwU", "BXB", 'B', Blocks.brick_block, 'U', OP.plateCurved.dat(aMat), 'X', OP.rotor.dat(aMat), 'P', OP.plateQuintuple.dat(aMat), 'C', OP.plateDense.dat(ANY.Cu));
		aMat = MT.Cr;                   aRegistry.add("Dense Fluidized Bed Burning Box ("    +aMat.getLocal()+")", "Burning Boxes"                  ,  9055,  1104, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_FUELMAP, FM.FluidBed, NBT_EFFICIENCY,  8500, NBT_OUTPUT,1792, NBT_ENERGY_EMITTED, TD.Energy.HU), "PCP", "UwU", "BXB", 'B', Blocks.brick_block, 'U', OP.plateCurved.dat(aMat), 'X', OP.rotor.dat(aMat), 'P', OP.plateQuintuple.dat(aMat), 'C', OP.plateDense.dat(ANY.Cu));
		aMat = MT.Ti;                   aRegistry.add("Dense Fluidized Bed Burning Box ("    +aMat.getLocal()+")", "Burning Boxes"                  ,  9056,  1104, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   9.0F, NBT_RESISTANCE,   9.0F, NBT_FUELMAP, FM.FluidBed, NBT_EFFICIENCY,  8500, NBT_OUTPUT,1536, NBT_ENERGY_EMITTED, TD.Energy.HU), "PCP", "UwU", "BXB", 'B', Blocks.brick_block, 'U', OP.plateCurved.dat(aMat), 'X', OP.rotor.dat(aMat), 'P', OP.plateQuintuple.dat(aMat), 'C', OP.plateDense.dat(ANY.Cu));
		aMat = MT.Netherite;            aRegistry.add("Dense Fluidized Bed Burning Box ("    +aMat.getLocal()+")", "Burning Boxes"                  ,  9060,  1104, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   9.0F, NBT_RESISTANCE,   9.0F, NBT_FUELMAP, FM.FluidBed, NBT_EFFICIENCY,  9000, NBT_OUTPUT,1536, NBT_ENERGY_EMITTED, TD.Energy.HU), "PCP", "UwU", "BXB", 'B', Blocks.brick_block, 'U', OP.plateCurved.dat(aMat), 'X', OP.rotor.dat(aMat), 'P', OP.plateQuintuple.dat(aMat), 'C', OP.plateDense.dat(ANY.Cu));
		aMat = ANY.W;                   aRegistry.add("Dense Fluidized Bed Burning Box ("    +aMat.getLocal()+")", "Burning Boxes"                  ,  9057,  1104, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,  10.0F, NBT_RESISTANCE,  10.0F, NBT_FUELMAP, FM.FluidBed, NBT_EFFICIENCY, 10000, NBT_OUTPUT,2048, NBT_ENERGY_EMITTED, TD.Energy.HU), "PCP", "UwU", "BXB", 'B', Blocks.brick_block, 'U', OP.plateCurved.dat(aMat), 'X', OP.rotor.dat(aMat), 'P', OP.plateQuintuple.dat(aMat), 'C', OP.plateDense.dat(ANY.Cu));
		aMat = MT.TungstenSteel;        aRegistry.add("Dense Fluidized Bed Burning Box ("    +aMat.getLocal()+")", "Burning Boxes"                  ,  9058,  1104, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,  12.5F, NBT_RESISTANCE,  12.5F, NBT_FUELMAP, FM.FluidBed, NBT_EFFICIENCY,  9000, NBT_OUTPUT,2048, NBT_ENERGY_EMITTED, TD.Energy.HU), "PCP", "UwU", "BXB", 'B', Blocks.brick_block, 'U', OP.plateCurved.dat(aMat), 'X', OP.rotor.dat(aMat), 'P', OP.plateQuintuple.dat(aMat), 'C', OP.plateDense.dat(ANY.Cu));
		aMat = MT.Ta4HfC5;              aRegistry.add("Dense Fluidized Bed Burning Box ("    +aMat.getLocal()+")", "Burning Boxes"                  ,  9059,  1104, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,  12.5F, NBT_RESISTANCE,  12.5F, NBT_FUELMAP, FM.FluidBed, NBT_EFFICIENCY, 10000, NBT_OUTPUT,4096, NBT_ENERGY_EMITTED, TD.Energy.HU), "PCP", "UwU", "BXB", 'B', Blocks.brick_block, 'U', OP.plateCurved.dat(aMat), 'X', OP.rotor.dat(aMat), 'P', OP.plateQuintuple.dat(aMat), 'C', OP.plateDense.dat(ANY.Cu));
		
		
		// Heat Exchangers
		aClass = MultiTileEntityGeneratorHotFluid.class;
		aMat = MT.Invar;                aRegistry.add("Heat Exchanger ("                +aMat.getLocal()+")", "Heat Exchangers"                     ,  9103,  9103, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_FUELMAP, FM.Hot, NBT_EFFICIENCY, 10000, NBT_OUTPUT,  16, NBT_ENERGY_EMITTED, TD.Energy.HU), "PCP", "OwO", "PMP", 'M', OP.casingMachine.dat(aMat), 'O', OP.pipeSmall.dat(ANY.Cu), 'P', OP.plate.dat(MT.Pb), 'C', OP.plateDouble.dat(ANY.Cu           ));
		aMat = ANY.W;                   aRegistry.add("Heat Exchanger ("                +aMat.getLocal()+")", "Heat Exchangers"                     ,  9107,  9103, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,  10.0F, NBT_RESISTANCE,  10.0F, NBT_FUELMAP, FM.Hot, NBT_EFFICIENCY, 10000, NBT_OUTPUT, 128, NBT_ENERGY_EMITTED, TD.Energy.HU), "PCP", "OwO", "PMP", 'M', OP.casingMachine.dat(aMat), 'O', OP.pipeSmall.dat(ANY.Cu), 'P', OP.plate.dat(MT.Pb), 'C', OP.plateDouble.dat(MT.AnnealedCopper));
		aMat = MT.TungstenSteel;        aRegistry.add("Heat Exchanger ("                +aMat.getLocal()+")", "Heat Exchangers"                     ,  9108,  9103, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,  12.5F, NBT_RESISTANCE,  12.5F, NBT_FUELMAP, FM.Hot, NBT_EFFICIENCY,  9000, NBT_OUTPUT, 128, NBT_ENERGY_EMITTED, TD.Energy.HU), "PCP", "OwO", "PMP", 'M', OP.casingMachine.dat(aMat), 'O', OP.pipeSmall.dat(ANY.Cu), 'P', OP.plate.dat(MT.Pb), 'C', OP.plateDouble.dat(MT.AnnealedCopper));
		aMat = MT.Ta4HfC5;              aRegistry.add("Heat Exchanger ("                +aMat.getLocal()+")", "Heat Exchangers"                     ,  9109,  9103, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,  12.5F, NBT_RESISTANCE,  12.5F, NBT_FUELMAP, FM.Hot, NBT_EFFICIENCY, 10000, NBT_OUTPUT, 256, NBT_ENERGY_EMITTED, TD.Energy.HU), "PCP", "OwO", "PMP", 'M', OP.casingMachine.dat(aMat), 'O', OP.pipeSmall.dat(ANY.Cu), 'P', OP.plate.dat(MT.Pb), 'C', OP.plateDouble.dat(MT.AnnealedCopper));
		
		aMat = MT.Invar;                aRegistry.add("Dense Heat Exchanger ("          +aMat.getLocal()+")", "Heat Exchangers"                     ,  9153,  9103, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_FUELMAP, FM.Hot, NBT_EFFICIENCY, 10000, NBT_OUTPUT,  64, NBT_ENERGY_EMITTED, TD.Energy.HU), "PCP", "OwO", "PMP", 'M', OP.casingMachineQuadruple.dat(aMat), 'O', OP.pipeLarge.dat(ANY.Cu), 'P', OP.plateQuadruple.dat(MT.Pb), 'C', OP.plateDense.dat(ANY.Cu           ));
		aMat = ANY.W;                   aRegistry.add("Dense Heat Exchanger ("          +aMat.getLocal()+")", "Heat Exchangers"                     ,  9157,  9103, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,  10.0F, NBT_RESISTANCE,  10.0F, NBT_FUELMAP, FM.Hot, NBT_EFFICIENCY, 10000, NBT_OUTPUT, 512, NBT_ENERGY_EMITTED, TD.Energy.HU), "PCP", "OwO", "PMP", 'M', OP.casingMachineQuadruple.dat(aMat), 'O', OP.pipeLarge.dat(ANY.Cu), 'P', OP.plateQuadruple.dat(MT.Pb), 'C', OP.plateDense.dat(MT.AnnealedCopper));
		aMat = MT.TungstenSteel;        aRegistry.add("Dense Heat Exchanger ("          +aMat.getLocal()+")", "Heat Exchangers"                     ,  9158,  9103, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,  12.5F, NBT_RESISTANCE,  12.5F, NBT_FUELMAP, FM.Hot, NBT_EFFICIENCY,  9000, NBT_OUTPUT, 512, NBT_ENERGY_EMITTED, TD.Energy.HU), "PCP", "OwO", "PMP", 'M', OP.casingMachineQuadruple.dat(aMat), 'O', OP.pipeLarge.dat(ANY.Cu), 'P', OP.plateQuadruple.dat(MT.Pb), 'C', OP.plateDense.dat(MT.AnnealedCopper));
		aMat = MT.Ta4HfC5;              aRegistry.add("Dense Heat Exchanger ("          +aMat.getLocal()+")", "Heat Exchangers"                     ,  9159,  9103, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,  12.5F, NBT_RESISTANCE,  12.5F, NBT_FUELMAP, FM.Hot, NBT_EFFICIENCY, 10000, NBT_OUTPUT,1024, NBT_ENERGY_EMITTED, TD.Energy.HU), "PCP", "OwO", "PMP", 'M', OP.casingMachineQuadruple.dat(aMat), 'O', OP.pipeLarge.dat(ANY.Cu), 'P', OP.plateQuadruple.dat(MT.Pb), 'C', OP.plateDense.dat(MT.AnnealedCopper));
		
		
		// Diesel Engines
		aClass = MultiTileEntityMotorLiquid.class;
		aMat = MT.Bronze;               aRegistry.add("Diesel Engine ("                 +aMat.getLocal()+")", "Engines"                             ,  9147,  1304, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   6.0F, NBT_RESISTANCE,   6.0F, NBT_FUELMAP, FM.Engine, NBT_EFFICIENCY, 10000, NBT_OUTPUT,   16, NBT_ENERGY_EMITTED, TD.Energy.RU), "PLP", "SMS", "GPC", 'M', OP.casingMachineDouble.dat(aMat), 'P', OP.plateCurved.dat(aMat), 'S', OP.stick.dat(aMat), 'G', OP.gearGt.dat(aMat), 'C', OP.gearGtSmall.dat(aMat), 'L', OD.itemLubricant);
		aMat = MT.ArsenicCopper;        aRegistry.add("Diesel Engine ("                 +aMat.getLocal()+")", "Engines"                             ,  9146,  1304, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   6.0F, NBT_RESISTANCE,   6.0F, NBT_FUELMAP, FM.Engine, NBT_EFFICIENCY, 10000, NBT_OUTPUT,   16, NBT_ENERGY_EMITTED, TD.Energy.RU), "PLP", "SMS", "GPC", 'M', OP.casingMachineDouble.dat(aMat), 'P', OP.plateCurved.dat(aMat), 'S', OP.stick.dat(aMat), 'G', OP.gearGt.dat(aMat), 'C', OP.gearGtSmall.dat(aMat), 'L', OD.itemLubricant);
		aMat = MT.ArsenicBronze;        aRegistry.add("Diesel Engine ("                 +aMat.getLocal()+")", "Engines"                             ,  9145,  1304, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   6.0F, NBT_RESISTANCE,   6.0F, NBT_FUELMAP, FM.Engine, NBT_EFFICIENCY, 10000, NBT_OUTPUT,   24, NBT_ENERGY_EMITTED, TD.Energy.RU), "PLP", "SMS", "GPC", 'M', OP.casingMachineDouble.dat(aMat), 'P', OP.plateCurved.dat(aMat), 'S', OP.stick.dat(aMat), 'G', OP.gearGt.dat(aMat), 'C', OP.gearGtSmall.dat(aMat), 'L', OD.itemLubricant);
		aMat = ANY.Steel;               aRegistry.add("Diesel Engine ("                 +aMat.getLocal()+")", "Engines"                             ,  9148,  1304, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   6.0F, NBT_RESISTANCE,   6.0F, NBT_FUELMAP, FM.Engine, NBT_EFFICIENCY, 10000, NBT_OUTPUT,   32, NBT_ENERGY_EMITTED, TD.Energy.RU), "PLP", "SMS", "GPC", 'M', OP.casingMachineDouble.dat(aMat), 'P', OP.plateCurved.dat(aMat), 'S', OP.stick.dat(aMat), 'G', OP.gearGt.dat(aMat), 'C', OP.gearGtSmall.dat(aMat), 'L', OD.itemLubricant);
		aMat = MT.Invar;                aRegistry.add("Diesel Engine ("                 +aMat.getLocal()+")", "Engines"                             ,  9149,  1304, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   6.0F, NBT_RESISTANCE,   6.0F, NBT_FUELMAP, FM.Engine, NBT_EFFICIENCY, 10000, NBT_OUTPUT,   64, NBT_ENERGY_EMITTED, TD.Energy.RU), "PLP", "SMS", "GPC", 'M', OP.casingMachineDouble.dat(aMat), 'P', OP.plateCurved.dat(aMat), 'S', OP.stick.dat(aMat), 'G', OP.gearGt.dat(aMat), 'C', OP.gearGtSmall.dat(aMat), 'L', OD.itemLubricant);
		aMat = MT.Ti;                   aRegistry.add("Diesel Engine ("                 +aMat.getLocal()+")", "Engines"                             ,  9197,  1304, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   6.0F, NBT_RESISTANCE,   6.0F, NBT_FUELMAP, FM.Engine, NBT_EFFICIENCY, 10000, NBT_OUTPUT,  128, NBT_ENERGY_EMITTED, TD.Energy.RU), "PLP", "SMS", "GPC", 'M', OP.casingMachineDouble.dat(aMat), 'P', OP.plateCurved.dat(aMat), 'S', OP.stick.dat(aMat), 'G', OP.gearGt.dat(aMat), 'C', OP.gearGtSmall.dat(aMat), 'L', OD.itemLubricant);
		aMat = MT.TungstenSteel;        aRegistry.add("Diesel Engine ("                 +aMat.getLocal()+")", "Engines"                             ,  9198,  1304, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   6.0F, NBT_RESISTANCE,   6.0F, NBT_FUELMAP, FM.Engine, NBT_EFFICIENCY, 10000, NBT_OUTPUT,  256, NBT_ENERGY_EMITTED, TD.Energy.RU), "PLP", "SMS", "GPC", 'M', OP.casingMachineDouble.dat(aMat), 'P', OP.plateCurved.dat(aMat), 'S', OP.stick.dat(aMat), 'G', OP.gearGt.dat(aMat), 'C', OP.gearGtSmall.dat(aMat), 'L', OD.itemLubricant);
		aMat = MT.Ir;                   aRegistry.add("Diesel Engine ("                 +aMat.getLocal()+")", "Engines"                             ,  9199,  1304, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   6.0F, NBT_RESISTANCE,   6.0F, NBT_FUELMAP, FM.Engine, NBT_EFFICIENCY, 10000, NBT_OUTPUT,  512, NBT_ENERGY_EMITTED, TD.Energy.RU), "PLP", "SMS", "GPC", 'M', OP.casingMachineDouble.dat(aMat), 'P', OP.plateCurved.dat(aMat), 'S', OP.stick.dat(aMat), 'G', OP.gearGt.dat(aMat), 'C', OP.gearGtSmall.dat(aMat), 'L', OD.itemLubricant);
		
		
		// Reactor Stuffs
		if (ConfigsGT.GREGTECH.get("general", "Enable1x1ReactorCore", F)) {
			aMat = MT.Pb;               aRegistry.add("Nuclear Reactor Core (1x1)"                    , "Reactors",  9300,  9200, MultiTileEntityReactorCore1x1.class     , aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,  10.0F, NBT_RESISTANCE,  10.0F), "CP" , "wM"        , 'M', OP.casingMachineDense.dat(aMat), 'C', OD_CIRCUITS[5], 'P', IL.PISTONS[4]); ItemsGT.addNEIRedirects(aRegistry.getItem(), FL.Coolant_IC2.display(), FL.Coolant_IC2_Hot.display());
		} else {
			aMat = MT.Pb;               aRegistry.add("Nuclear Reactor Core (1x1)"                    , "Reactors",  9300,  9200, MultiTileEntityReactorCore1x1.class     , aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,  10.0F, NBT_RESISTANCE,  10.0F));
		}
		aMat = MT.Pb;                   aRegistry.add("Nuclear Reactor Core (2x2)"                    , "Reactors",  9200,  9200, MultiTileEntityReactorCore2x2.class     , aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,  10.0F, NBT_RESISTANCE,  10.0F), "PCP", "CMC", "PCP", 'M', OP.casingMachineDense.dat(aMat), 'C', OD_CIRCUITS[5], 'P', IL.PISTONS[4]); ItemsGT.addNEIRedirects(aRegistry.getItem(), FL.Coolant_IC2.display(), FL.Coolant_IC2_Hot.display());
		
		
		aMat = MT.Zr;                   aRegistry.add("Empty Reactor Rod"                             , "Reactors",  9201,  9200, MultiTileEntityReactorRodBase.class     , aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,  10.0F, NBT_RESISTANCE,  10.0F)); IL.Reactor_Rod_Empty.set(aRegistry.getItem(), new OreDictItemData(MT.Zr, U));
		aMat = MT.Cd_In_Ag_Alloy;       aRegistry.add("Neutron Absorber Rod"                          , "Reactors",  9202,  9200, MultiTileEntityReactorRodAbsorber.class , aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,  10.0F, NBT_RESISTANCE,  10.0F)); RM.Canner.addRecipe2(F, 16, 16, OP.stick.mat(aMat, 1), IL.Reactor_Rod_Empty.get(1), aRegistry.getItem()); OM.data(aRegistry.getItem(), aMat, OP.stick.mAmount, MT.Zr, U);
		aMat = MT.Be;                   aRegistry.add("Neutron Reflector Rod"                         , "Reactors",  9203,  9200, MultiTileEntityReactorRodReflector.class, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,  10.0F, NBT_RESISTANCE,  10.0F)); RM.Canner.addRecipe2(F, 16, 16, OP.stick.mat(aMat, 1), IL.Reactor_Rod_Empty.get(1), aRegistry.getItem()); OM.data(aRegistry.getItem(), aMat, OP.stick.mAmount, MT.Zr, U);
		aMat = MT.Graphite;             aRegistry.add("Neutron Moderator Rod"                         , "Reactors",  9204,  9200, MultiTileEntityReactorRodModerator.class, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,  10.0F, NBT_RESISTANCE,  10.0F)); RM.Canner.addRecipe2(F, 16, 16, OP.stick.mat(aMat, 1), IL.Reactor_Rod_Empty.get(1), aRegistry.getItem()); OM.data(aRegistry.getItem(), aMat, OP.stick.mAmount, MT.Zr, U);
		
		aMat = MT.Th;                   aRegistry.add("Thorium-232 Fuel Rod"                          , "Reactors",  9210,  9200, MultiTileEntityReactorRodNuclear.class  , aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,  10.0F, NBT_RESISTANCE,  10.0F, NBT_MAXDURABILITY, 12000000000L, NBT_NUCLEAR_SELF,   2, NBT_NUCLEAR_OTHER,   2, NBT_NUCLEAR_DIV, 32, NBT_NUCLEAR_MAX,      128, NBT_VALUE, 9310)); RM.Canner.addRecipe2(F, 16, 16, OP.stick.mat(aMat, 1), IL.Reactor_Rod_Empty.get(1), aRegistry.getItem());
		aMat = MT.Cyanite;              aRegistry.add("Cyanite Fuel Rod"                              , "Reactors",  9219,  9200, MultiTileEntityReactorRodNuclear.class  , aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,  10.0F, NBT_RESISTANCE,  10.0F, NBT_MAXDURABILITY, 12000000000L, NBT_NUCLEAR_SELF,   2, NBT_NUCLEAR_OTHER,   2, NBT_NUCLEAR_DIV, 32, NBT_NUCLEAR_MAX,       64, NBT_VALUE, 9319)); RM.Canner.addRecipe2(F, 16, 16, OP.stick.mat(aMat, 1), IL.Reactor_Rod_Empty.get(1), aRegistry.getItem());
		aMat = MT.U_238;                aRegistry.add("Uranium-238 Fuel Rod"                          , "Reactors",  9220,  9200, MultiTileEntityReactorRodNuclear.class  , aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,  10.0F, NBT_RESISTANCE,  10.0F, NBT_MAXDURABILITY,  6000000000L, NBT_NUCLEAR_SELF,   4, NBT_NUCLEAR_OTHER,   4, NBT_NUCLEAR_DIV, 16, NBT_NUCLEAR_MAX,      512, NBT_VALUE, 9320)); RM.Canner.addRecipe2(F, 16, 16, OP.stick.mat(aMat, 1), IL.Reactor_Rod_Empty.get(1), aRegistry.getItem());
		aMat = MT.U_235;                aRegistry.add("Uranium-235 Fuel Rod"                          , "Reactors",  9221,  9200, MultiTileEntityReactorRodNuclear.class  , aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,  10.0F, NBT_RESISTANCE,  10.0F, NBT_MAXDURABILITY,  1200000000L, NBT_NUCLEAR_SELF,  32, NBT_NUCLEAR_OTHER,  32, NBT_NUCLEAR_DIV,  4, NBT_NUCLEAR_MAX,     2048, NBT_VALUE, 9321)); RM.Canner.addRecipe2(F, 16, 16, OP.stick.mat(aMat, 1), IL.Reactor_Rod_Empty.get(1), aRegistry.getItem());
		aMat = MT.U_233;                aRegistry.add("Uranium-233 Fuel Rod"                          , "Reactors",  9222,  9200, MultiTileEntityReactorRodNuclear.class  , aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,  10.0F, NBT_RESISTANCE,  10.0F, NBT_MAXDURABILITY,  6000000000L, NBT_NUCLEAR_SELF,  32, NBT_NUCLEAR_OTHER,  32, NBT_NUCLEAR_DIV,  4, NBT_NUCLEAR_MAX,     2048, NBT_VALUE, 9322)); RM.Canner.addRecipe2(F, 16, 16, OP.stick.mat(aMat, 1), IL.Reactor_Rod_Empty.get(1), aRegistry.getItem());
		aMat = MT.Yellorium;            aRegistry.add("Yellorium Fuel Rod"                            , "Reactors",  9229,  9200, MultiTileEntityReactorRodNuclear.class  , aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,  10.0F, NBT_RESISTANCE,  10.0F, NBT_MAXDURABILITY,  6000000000L, NBT_NUCLEAR_SELF,   4, NBT_NUCLEAR_OTHER,   4, NBT_NUCLEAR_DIV, 16, NBT_NUCLEAR_MAX,      256, NBT_VALUE, 9329)); RM.Canner.addRecipe2(F, 16, 16, OP.stick.mat(aMat, 1), IL.Reactor_Rod_Empty.get(1), aRegistry.getItem());
		aMat = MT.Pu;                   aRegistry.add("Plutonium-244 Fuel Rod"                        , "Reactors",  9230,  9200, MultiTileEntityReactorRodNuclear.class  , aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,  10.0F, NBT_RESISTANCE,  10.0F, NBT_MAXDURABILITY,  1200000000L, NBT_NUCLEAR_SELF,  64, NBT_NUCLEAR_OTHER,  64, NBT_NUCLEAR_DIV,  4, NBT_NUCLEAR_MAX,     2048, NBT_VALUE, 9330)); RM.Canner.addRecipe2(F, 16, 16, OP.stick.mat(aMat, 1), IL.Reactor_Rod_Empty.get(1), aRegistry.getItem());
		aMat = MT.Pu_241;               aRegistry.add("Plutonium-241 Fuel Rod"                        , "Reactors",  9231,  9200, MultiTileEntityReactorRodNuclear.class  , aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,  10.0F, NBT_RESISTANCE,  10.0F, NBT_MAXDURABILITY,  1200000000L, NBT_NUCLEAR_SELF, 128, NBT_NUCLEAR_OTHER, 128, NBT_NUCLEAR_DIV,  3, NBT_NUCLEAR_MAX,     3072, NBT_VALUE, 9331)); RM.Canner.addRecipe2(F, 16, 16, OP.stick.mat(aMat, 1), IL.Reactor_Rod_Empty.get(1), aRegistry.getItem());
		aMat = MT.Pu_243;               aRegistry.add("Plutonium-243 Fuel Rod"                        , "Reactors",  9232,  9200, MultiTileEntityReactorRodNuclear.class  , aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,  10.0F, NBT_RESISTANCE,  10.0F, NBT_MAXDURABILITY,  1200000000L, NBT_NUCLEAR_SELF, 128, NBT_NUCLEAR_OTHER, 128, NBT_NUCLEAR_DIV,  3, NBT_NUCLEAR_MAX,     4096, NBT_VALUE, 9332)); RM.Canner.addRecipe2(F, 16, 16, OP.stick.mat(aMat, 1), IL.Reactor_Rod_Empty.get(1), aRegistry.getItem());
		aMat = MT.Pu_239;               aRegistry.add("Plutonium-239 Fuel Rod"                        , "Reactors",  9233,  9200, MultiTileEntityReactorRodNuclear.class  , aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,  10.0F, NBT_RESISTANCE,  10.0F, NBT_MAXDURABILITY,  2400000000L, NBT_NUCLEAR_SELF, 128, NBT_NUCLEAR_OTHER, 128, NBT_NUCLEAR_DIV,  3, NBT_NUCLEAR_MAX,     4096, NBT_VALUE, 9333)); RM.Canner.addRecipe2(F, 16, 16, OP.stick.mat(aMat, 1), IL.Reactor_Rod_Empty.get(1), aRegistry.getItem());
		aMat = MT.Blutonium;            aRegistry.add("Blutonium Fuel Rod"                            , "Reactors",  9239,  9200, MultiTileEntityReactorRodNuclear.class  , aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,  10.0F, NBT_RESISTANCE,  10.0F, NBT_MAXDURABILITY,  1200000000L, NBT_NUCLEAR_SELF,  64, NBT_NUCLEAR_OTHER,  64, NBT_NUCLEAR_DIV,  4, NBT_NUCLEAR_MAX,     1024, NBT_VALUE, 9339)); RM.Canner.addRecipe2(F, 16, 16, OP.stick.mat(aMat, 1), IL.Reactor_Rod_Empty.get(1), aRegistry.getItem());
		aMat = MT.Am;                   aRegistry.add("Americium-245 Fuel Rod"                        , "Reactors",  9240,  9200, MultiTileEntityReactorRodNuclear.class  , aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,  10.0F, NBT_RESISTANCE,  10.0F, NBT_MAXDURABILITY,  1200000000L, NBT_NUCLEAR_SELF,  64, NBT_NUCLEAR_OTHER,  64, NBT_NUCLEAR_DIV,  4, NBT_NUCLEAR_MAX,     4096, NBT_VALUE, 9340)); RM.Canner.addRecipe2(F, 16, 16, OP.stick.mat(aMat, 1), IL.Reactor_Rod_Empty.get(1), aRegistry.getItem());
		aMat = MT.Am_241;               aRegistry.add("Americium-241 Fuel Rod"                        , "Reactors",  9241,  9200, MultiTileEntityReactorRodNuclear.class  , aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,  10.0F, NBT_RESISTANCE,  10.0F, NBT_MAXDURABILITY,  1200000000L, NBT_NUCLEAR_SELF, 128, NBT_NUCLEAR_OTHER, 128, NBT_NUCLEAR_DIV,  3, NBT_NUCLEAR_MAX,     4096, NBT_VALUE, 9341)); RM.Canner.addRecipe2(F, 16, 16, OP.stick.mat(aMat, 1), IL.Reactor_Rod_Empty.get(1), aRegistry.getItem());
		aMat = MT.Ludicrite;            aRegistry.add("Ludicrite Fuel Rod"                            , "Reactors",  9249,  9200, MultiTileEntityReactorRodNuclear.class  , aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,  10.0F, NBT_RESISTANCE,  10.0F, NBT_MAXDURABILITY,  1200000000L, NBT_NUCLEAR_SELF, 128, NBT_NUCLEAR_OTHER, 128, NBT_NUCLEAR_DIV,  3, NBT_NUCLEAR_MAX,     3072, NBT_VALUE, 9349)); RM.Canner.addRecipe2(F, 16, 16, OP.stick.mat(aMat, 1), IL.Reactor_Rod_Empty.get(1), aRegistry.getItem());
		aMat = MT.Co_60;                aRegistry.add("Cobalt-60 Fuel Rod"                            , "Reactors",  9250,  9200, MultiTileEntityReactorRodNuclear.class  , aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,  10.0F, NBT_RESISTANCE,  10.0F, NBT_MAXDURABILITY,   120000000L, NBT_NUCLEAR_SELF,   8, NBT_NUCLEAR_OTHER,   0, NBT_NUCLEAR_DIV, 16, NBT_NUCLEAR_MAX,      256, NBT_VALUE, 9350)); RM.Canner.addRecipe2(F, 16, 16, OP.stick.mat(aMat, 1), IL.Reactor_Rod_Empty.get(1), aRegistry.getItem());
		aMat = MT.Nq_528;               aRegistry.add("Enriched Naquadah Fuel Rod"                    , "Reactors",  9260,  9200, MultiTileEntityReactorRodNuclear.class  , aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,  10.0F, NBT_RESISTANCE,  10.0F, NBT_MAXDURABILITY, 12000000000L, NBT_NUCLEAR_SELF, 128, NBT_NUCLEAR_OTHER, 128, NBT_NUCLEAR_DIV,  4, NBT_NUCLEAR_MAX,     8192, NBT_VALUE, 9360)); RM.Canner.addRecipe2(F, 16, 16, OP.stick.mat(aMat, 1), IL.Reactor_Rod_Empty.get(1), aRegistry.getItem());
		aMat = MT.Nq_522;               aRegistry.add("Naquadria Fuel Rod"                            , "Reactors",  9261,  9200, MultiTileEntityReactorRodNuclear.class  , aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,  10.0F, NBT_RESISTANCE,  10.0F, NBT_MAXDURABILITY, 12000000000L, NBT_NUCLEAR_SELF, 512, NBT_NUCLEAR_OTHER, 512, NBT_NUCLEAR_DIV,  3, NBT_NUCLEAR_MAX,    16384, NBT_VALUE, 9361)); RM.Canner.addRecipe2(F, 16, 16, OP.stick.mat(aMat, 1), IL.Reactor_Rod_Empty.get(1), aRegistry.getItem());

		aMat = MT.Th;                   aRegistry.add("Depleted Thorium-232 Fuel Rod"                 , "Reactors",  9310,  9200, MultiTileEntityReactorRodDepleted.class , aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,  10.0F, NBT_RESISTANCE,  10.0F)); RM.Centrifuge.addRecipe1(F, 64, 256, aRegistry.getItem(), ZL_FS, ZL_FS, OP.scrapGt.mat(MT.Zr, 9), OP.dustTiny.mat(aMat, 1), OP.dustDiv72.mat(MT.U_238    , 6));
		aMat = MT.Cyanite;              aRegistry.add("Depleted Cyanite Fuel Rod"                     , "Reactors",  9319,  9200, MultiTileEntityReactorRodDepleted.class , aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,  10.0F, NBT_RESISTANCE,  10.0F)); RM.Centrifuge.addRecipe1(F, 64, 256, aRegistry.getItem(), ZL_FS, ZL_FS, OP.scrapGt.mat(MT.Zr, 9), OP.dustTiny.mat(aMat, 1), OP.dustDiv72.mat(MT.Blutonium, 6));
		aMat = MT.U_238;                aRegistry.add("Depleted Uranium-238 Fuel Rod"                 , "Reactors",  9320,  9200, MultiTileEntityReactorRodDepleted.class , aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,  10.0F, NBT_RESISTANCE,  10.0F)); RM.Centrifuge.addRecipe1(F, 64, 256, aRegistry.getItem(), ZL_FS, ZL_FS, OP.scrapGt.mat(MT.Zr, 9), OP.dustTiny.mat(aMat, 1), OP.dustDiv72.mat(MT.U_235    , 6));
		aMat = MT.U_235;                aRegistry.add("Depleted Uranium-235 Fuel Rod"                 , "Reactors",  9321,  9200, MultiTileEntityReactorRodDepleted.class , aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,  10.0F, NBT_RESISTANCE,  10.0F)); RM.Centrifuge.addRecipe1(F, 64, 256, aRegistry.getItem(), ZL_FS, ZL_FS, OP.scrapGt.mat(MT.Zr, 9), OP.dustTiny.mat(aMat, 1), OP.dustDiv72.mat(MT.Pu       , 6));
		aMat = MT.U_233;                aRegistry.add("Depleted Uranium-233 Fuel Rod"                 , "Reactors",  9322,  9200, MultiTileEntityReactorRodDepleted.class , aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,  10.0F, NBT_RESISTANCE,  10.0F)); RM.Centrifuge.addRecipe1(F, 64, 256, aRegistry.getItem(), ZL_FS, ZL_FS, OP.scrapGt.mat(MT.Zr, 9), OP.dustTiny.mat(aMat, 1), OP.dustDiv72.mat(MT.Pu_243   , 6));
		aMat = MT.Yellorium;            aRegistry.add("Depleted Yellorium Fuel Rod"                   , "Reactors",  9329,  9200, MultiTileEntityReactorRodDepleted.class , aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,  10.0F, NBT_RESISTANCE,  10.0F)); RM.Centrifuge.addRecipe1(F, 64, 256, aRegistry.getItem(), ZL_FS, ZL_FS, OP.scrapGt.mat(MT.Zr, 9), OP.dustTiny.mat(aMat, 1), OP.dustDiv72.mat(MT.Cyanite  , 6));
		aMat = MT.Pu;                   aRegistry.add("Depleted Plutonium-244 Fuel Rod"               , "Reactors",  9330,  9200, MultiTileEntityReactorRodDepleted.class , aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,  10.0F, NBT_RESISTANCE,  10.0F)); RM.Centrifuge.addRecipe1(F, 64, 256, aRegistry.getItem(), ZL_FS, ZL_FS, OP.scrapGt.mat(MT.Zr, 9), OP.dustTiny.mat(aMat, 1), OP.dustDiv72.mat(MT.Pu_241   , 6));
		aMat = MT.Pu_241;               aRegistry.add("Depleted Plutonium-241 Fuel Rod"               , "Reactors",  9331,  9200, MultiTileEntityReactorRodDepleted.class , aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,  10.0F, NBT_RESISTANCE,  10.0F)); RM.Centrifuge.addRecipe1(F, 64, 256, aRegistry.getItem(), ZL_FS, ZL_FS, OP.scrapGt.mat(MT.Zr, 9), OP.dustTiny.mat(aMat, 1), OP.dustDiv72.mat(MT.Pu_243   , 6));
		aMat = MT.Pu_243;               aRegistry.add("Depleted Plutonium-243 Fuel Rod"               , "Reactors",  9332,  9200, MultiTileEntityReactorRodDepleted.class , aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,  10.0F, NBT_RESISTANCE,  10.0F)); RM.Centrifuge.addRecipe1(F, 64, 256, aRegistry.getItem(), ZL_FS, ZL_FS, OP.scrapGt.mat(MT.Zr, 9), OP.dustTiny.mat(aMat, 1), OP.dustDiv72.mat(MT.Am       , 6));
		aMat = MT.Pu_239;               aRegistry.add("Depleted Plutonium-239 Fuel Rod"               , "Reactors",  9333,  9200, MultiTileEntityReactorRodDepleted.class , aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,  10.0F, NBT_RESISTANCE,  10.0F)); RM.Centrifuge.addRecipe1(F, 64, 256, aRegistry.getItem(), ZL_FS, ZL_FS, OP.scrapGt.mat(MT.Zr, 9), OP.dustTiny.mat(aMat, 1), OP.dustDiv72.mat(MT.Am_241   , 6));
		aMat = MT.Blutonium;            aRegistry.add("Depleted Blutonium Fuel Rod"                   , "Reactors",  9339,  9200, MultiTileEntityReactorRodDepleted.class , aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,  10.0F, NBT_RESISTANCE,  10.0F)); RM.Centrifuge.addRecipe1(F, 64, 256, aRegistry.getItem(), ZL_FS, ZL_FS, OP.scrapGt.mat(MT.Zr, 9), OP.dustTiny.mat(aMat, 1), OP.dustDiv72.mat(MT.Ludicrite, 6));
		aMat = MT.Am;                   aRegistry.add("Depleted Americium-245 Fuel Rod"               , "Reactors",  9340,  9200, MultiTileEntityReactorRodDepleted.class , aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,  10.0F, NBT_RESISTANCE,  10.0F)); RM.Centrifuge.addRecipe1(F, 64, 256, aRegistry.getItem(), ZL_FS, ZL_FS, OP.scrapGt.mat(MT.Zr, 9), OP.dustTiny.mat(aMat, 1), OP.dustDiv72.mat(MT.Am_241   , 6));
		aMat = MT.Am_241;               aRegistry.add("Depleted Americium-241 Fuel Rod"               , "Reactors",  9341,  9200, MultiTileEntityReactorRodDepleted.class , aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,  10.0F, NBT_RESISTANCE,  10.0F)); RM.Centrifuge.addRecipe1(F, 64, 256, aRegistry.getItem(), ZL_FS, ZL_FS, OP.scrapGt.mat(MT.Zr, 9), OP.dustTiny.mat(aMat, 1), OP.dustDiv72.mat(MT.Nq_528   , 6));
		aMat = MT.Ludicrite;            aRegistry.add("Depleted Ludicrite Fuel Rod"                   , "Reactors",  9349,  9200, MultiTileEntityReactorRodDepleted.class , aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,  10.0F, NBT_RESISTANCE,  10.0F)); RM.Centrifuge.addRecipe1(F, 64, 256, aRegistry.getItem(), ZL_FS, ZL_FS, OP.scrapGt.mat(MT.Zr, 9), OP.dustTiny.mat(aMat, 1), OP.dustDiv72.mat(MT.Yellorium, 6));
		aMat = MT.Co_60;                aRegistry.add("Depleted Cobalt-60 Fuel Rod"                   , "Reactors",  9350,  9200, MultiTileEntityReactorRodDepleted.class , aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,  10.0F, NBT_RESISTANCE,  10.0F)); RM.Centrifuge.addRecipe1(F, 64, 256, aRegistry.getItem(), ZL_FS, ZL_FS, OP.scrapGt.mat(MT.Zr, 9), OP.dustTiny.mat(aMat, 1), OP.dustDiv72.mat(MT.Th       , 6));
		aMat = MT.Nq_528;               aRegistry.add("Depleted Enriched Naquadah Fuel Rod"           , "Reactors",  9360,  9200, MultiTileEntityReactorRodDepleted.class , aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,  10.0F, NBT_RESISTANCE,  10.0F)); RM.Centrifuge.addRecipe1(F, 64, 256, aRegistry.getItem(), ZL_FS, ZL_FS, OP.scrapGt.mat(MT.Zr, 9), OP.dustTiny.mat(aMat, 1), OP.dustDiv72.mat(MT.Nq_522   , 6));
		aMat = MT.Nq_522;               aRegistry.add("Depleted Naquadria Fuel Rod"                   , "Reactors",  9361,  9200, MultiTileEntityReactorRodDepleted.class , aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,  10.0F, NBT_RESISTANCE,  10.0F)); RM.Centrifuge.addRecipe1(F, 64, 256, aRegistry.getItem(), ZL_FS, ZL_FS, OP.scrapGt.mat(MT.Zr, 9), OP.dustTiny.mat(aMat, 1), OP.dustDiv72.mat(MT.Co_60    , 6));

		aMat = MT.Th;                   aRegistry.add("Thorium-232 Breeder Rod"                       , "Reactors",  9410,  9200, MultiTileEntityReactorRodBreeder.class  , aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,  10.0F, NBT_RESISTANCE,  10.0F, NBT_MAXDURABILITY,   64000000L, NBT_NUCLEAR_LOSS,  1000, NBT_VALUE, 9411)); RM.Canner.addRecipe2(F, 16, 16, OP.bolt.mat(aMat, 4), IL.Reactor_Rod_Empty.get(1), aRegistry.getItem());
		aMat = MT.U_238;                aRegistry.add("Uranium-238 Breeder Rod"                       , "Reactors",  9420,  9200, MultiTileEntityReactorRodBreeder.class  , aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,  10.0F, NBT_RESISTANCE,  10.0F, NBT_MAXDURABILITY,  256000000L, NBT_NUCLEAR_LOSS,  2500, NBT_VALUE, 9421)); RM.Canner.addRecipe2(F, 16, 16, OP.bolt.mat(aMat, 4), IL.Reactor_Rod_Empty.get(1), aRegistry.getItem());
		aMat = MT.Li;                   aRegistry.add("Lithium Breeder Rod"                           , "Reactors",  9430,  9200, MultiTileEntityReactorRodBreeder.class  , aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,  10.0F, NBT_RESISTANCE,  10.0F, NBT_MAXDURABILITY,     640000L, NBT_NUCLEAR_LOSS,   250, NBT_VALUE, 9431)); RM.Canner.addRecipe2(F, 16, 16, OP.bolt.mat(aMat, 4), IL.Reactor_Rod_Empty.get(1), aRegistry.getItem());
		aMat = MT.Nq;                   aRegistry.add("Naquadah Breeder Rod"                          , "Reactors",  9440,  9200, MultiTileEntityReactorRodBreeder.class  , aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,  10.0F, NBT_RESISTANCE,  10.0F, NBT_MAXDURABILITY, 4096000000L, NBT_NUCLEAR_LOSS, 10000, NBT_VALUE, 9441)); RM.Canner.addRecipe2(F, 16, 16, OP.bolt.mat(aMat, 4), IL.Reactor_Rod_Empty.get(1), aRegistry.getItem());

		aMat = MT.U_233;                aRegistry.add("Uranium-233 Enriched Rod"                      , "Reactors",  9411,  9200, MultiTileEntityReactorRodProduct.class  , aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,  10.0F, NBT_RESISTANCE,  10.0F, NBT_VALUE, 9410)); RM.Centrifuge.addRecipe1(F, 64, 256, aRegistry.getItem(), ZL_FS, ZL_FS, OP.scrapGt.mat(MT.Zr, 9), OP.dustTiny.mat(aMat, 4), OP.dustDiv72.mat(MT.Th, 4));
		aMat = MT.Pu_239;               aRegistry.add("Plutonium-239 Enriched Rod"                    , "Reactors",  9421,  9200, MultiTileEntityReactorRodProduct.class  , aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,  10.0F, NBT_RESISTANCE,  10.0F, NBT_VALUE, 9420)); RM.Centrifuge.addRecipe1(F, 64, 256, aRegistry.getItem(), ZL_FS, ZL_FS, OP.scrapGt.mat(MT.Zr, 9), OP.dustTiny.mat(aMat, 4), OP.dustDiv72.mat(MT.U_238, 4));
		aMat = MT.T;                    aRegistry.add("Tritium Enriched Rod"                          , "Reactors",  9431,  9200, MultiTileEntityReactorRodProduct.class  , aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,  10.0F, NBT_RESISTANCE,  10.0F, NBT_VALUE, 9430)); RM.Canner.addRecipe1(F, 16, 16, aRegistry.getItem(), new FluidStack[] {}, FL.amount(aMat.mGas, 500L), IL.Reactor_Rod_Empty.get(1));
		aMat = MT.Nq_528;               aRegistry.add("Enriched Naquadah Enriched Rod"                , "Reactors",  9441,  9200, MultiTileEntityReactorRodProduct.class  , aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,  10.0F, NBT_RESISTANCE,  10.0F, NBT_VALUE, 9440)); RM.Centrifuge.addRecipe1(F, 512, 256, aRegistry.getItem(), ZL_FS, ZL_FS, OP.scrapGt.mat(MT.Zr, 9), OP.dustTiny.mat(aMat, 4), OP.dustDiv72.mat(MT.Nq, 4));

		// Steam Turbines
		aClass = MultiTileEntityTurbineSteam.class;
		aMat = MT.DATA.Kinetic_T[1];    aRegistry.add("Steam Turbine ("+MT.Bronze       .getLocal()+")" , "Turbines"                            ,  1512,  1538, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT,   24*STEAM_PER_EU, NBT_OUTPUT,   16, NBT_WASTE_ENERGY, T, NBT_ENERGY_ACCEPTED, TD.Energy.STEAM, NBT_ENERGY_EMITTED, TD.Energy.RU), "TwT", "GSG", "TMT", 'S', OP.stickLong.dat(aMat), 'M', OP.casingMachineDouble.dat(aMat), 'G', OP.gearGt.dat(aMat), 'T', OP.rotor.dat(MT.Bronze           ));
		aMat = MT.DATA.Kinetic_T[1];    aRegistry.add("Steam Turbine ("+MT.Brass        .getLocal()+")" , "Turbines"                            ,  1515,  1538, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT,   36*STEAM_PER_EU, NBT_OUTPUT,   24, NBT_WASTE_ENERGY, T, NBT_ENERGY_ACCEPTED, TD.Energy.STEAM, NBT_ENERGY_EMITTED, TD.Energy.RU), "TwT", "GSG", "TMT", 'S', OP.stickLong.dat(aMat), 'M', OP.casingMachineDouble.dat(aMat), 'G', OP.gearGt.dat(aMat), 'T', OP.rotor.dat(MT.Brass            ));
		aMat = MT.DATA.Kinetic_T[1];    aRegistry.add("Steam Turbine ("+MT.Invar        .getLocal()+")" , "Turbines"                            ,  1518,  1538, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT,   48*STEAM_PER_EU, NBT_OUTPUT,   32, NBT_WASTE_ENERGY, T, NBT_ENERGY_ACCEPTED, TD.Energy.STEAM, NBT_ENERGY_EMITTED, TD.Energy.RU), "TwT", "GSG", "TMT", 'S', OP.stickLong.dat(aMat), 'M', OP.casingMachineDouble.dat(aMat), 'G', OP.gearGt.dat(aMat), 'T', OP.rotor.dat(MT.Invar            ));
		
		aMat = MT.DATA.Kinetic_T[2];    aRegistry.add("Steam Turbine ("+ANY.Steel       .getLocal()+")" , "Turbines"                            ,  1522,  1538, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT,   96*STEAM_PER_EU, NBT_OUTPUT,   64, NBT_WASTE_ENERGY, T, NBT_ENERGY_ACCEPTED, TD.Energy.STEAM, NBT_ENERGY_EMITTED, TD.Energy.RU), "TwT", "GSG", "TMT", 'S', OP.stickLong.dat(aMat), 'M', OP.casingMachineDouble.dat(aMat), 'G', OP.gearGt.dat(aMat), 'T', OP.rotor.dat(ANY.Steel           ));
		aMat = MT.DATA.Kinetic_T[2];    aRegistry.add("Steam Turbine ("+MT.Cr           .getLocal()+")" , "Turbines"                            ,  1525,  1538, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT,  144*STEAM_PER_EU, NBT_OUTPUT,   96, NBT_WASTE_ENERGY, T, NBT_ENERGY_ACCEPTED, TD.Energy.STEAM, NBT_ENERGY_EMITTED, TD.Energy.RU), "TwT", "GSG", "TMT", 'S', OP.stickLong.dat(aMat), 'M', OP.casingMachineDouble.dat(aMat), 'G', OP.gearGt.dat(aMat), 'T', OP.rotor.dat(MT.Cr               ));
		aMat = MT.DATA.Kinetic_T[2];    aRegistry.add("Steam Turbine ("+MT.IronWood     .getLocal()+")" , "Turbines"                            ,  1527,  1538, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT,  192*STEAM_PER_EU, NBT_OUTPUT,  128, NBT_WASTE_ENERGY, T, NBT_ENERGY_ACCEPTED, TD.Energy.STEAM, NBT_ENERGY_EMITTED, TD.Energy.RU), "TwT", "GSG", "TMT", 'S', OP.stickLong.dat(aMat), 'M', OP.casingMachineDouble.dat(aMat), 'G', OP.gearGt.dat(aMat), 'T', OP.rotor.dat(MT.IronWood         ));
		aMat = MT.DATA.Kinetic_T[2];    aRegistry.add("Steam Turbine ("+MT.Steeleaf     .getLocal()+")" , "Turbines"                            ,  1528,  1538, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT,  192*STEAM_PER_EU, NBT_OUTPUT,  128, NBT_WASTE_ENERGY, T, NBT_ENERGY_ACCEPTED, TD.Energy.STEAM, NBT_ENERGY_EMITTED, TD.Energy.RU), "TwT", "GSG", "TMT", 'S', OP.stickLong.dat(aMat), 'M', OP.casingMachineDouble.dat(aMat), 'G', OP.gearGt.dat(aMat), 'T', OP.rotor.dat(MT.Steeleaf         ));
		aMat = MT.DATA.Kinetic_T[2];    aRegistry.add("Steam Turbine ("+MT.Thaumium     .getLocal()+")" , "Turbines"                            ,  1529,  1538, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT,  192*STEAM_PER_EU, NBT_OUTPUT,  128, NBT_WASTE_ENERGY, T, NBT_ENERGY_ACCEPTED, TD.Energy.STEAM, NBT_ENERGY_EMITTED, TD.Energy.RU), "TwT", "GSG", "TMT", 'S', OP.stickLong.dat(aMat), 'M', OP.casingMachineDouble.dat(aMat), 'G', OP.gearGt.dat(aMat), 'T', OP.rotor.dat(MT.Thaumium         ));
		
		aMat = MT.DATA.Kinetic_T[3];    aRegistry.add("Steam Turbine ("+MT.Ti           .getLocal()+")" , "Turbines"                            ,  1530,  1538, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT,  384*STEAM_PER_EU, NBT_OUTPUT,  256, NBT_WASTE_ENERGY, T, NBT_ENERGY_ACCEPTED, TD.Energy.STEAM, NBT_ENERGY_EMITTED, TD.Energy.RU), "TwT", "GSG", "TMT", 'S', OP.stickLong.dat(aMat), 'M', OP.casingMachineDouble.dat(aMat), 'G', OP.gearGt.dat(aMat), 'T', OP.rotor.dat(MT.Ti               ));
		aMat = MT.DATA.Kinetic_T[3];    aRegistry.add("Steam Turbine ("+MT.FierySteel   .getLocal()+")" , "Turbines"                            ,  1531,  1538, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT,  384*STEAM_PER_EU, NBT_OUTPUT,  256, NBT_WASTE_ENERGY, T, NBT_ENERGY_ACCEPTED, TD.Energy.STEAM, NBT_ENERGY_EMITTED, TD.Energy.RU), "TwT", "GSG", "TMT", 'S', OP.stickLong.dat(aMat), 'M', OP.casingMachineDouble.dat(aMat), 'G', OP.gearGt.dat(aMat), 'T', OP.rotor.dat(MT.FierySteel       ));
		aMat = MT.DATA.Kinetic_T[3];    aRegistry.add("Steam Turbine ("+MT.Al           .getLocal()+")" , "Turbines"                            ,  1535,  1538, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT,  576*STEAM_PER_EU, NBT_OUTPUT,  384, NBT_WASTE_ENERGY, T, NBT_ENERGY_ACCEPTED, TD.Energy.STEAM, NBT_ENERGY_EMITTED, TD.Energy.RU), "TwT", "GSG", "TMT", 'S', OP.stickLong.dat(aMat), 'M', OP.casingMachineDouble.dat(aMat), 'G', OP.gearGt.dat(aMat), 'T', OP.rotor.dat(MT.Al               ));
		aMat = MT.DATA.Kinetic_T[3];    aRegistry.add("Steam Turbine ("+MT.Magnalium    .getLocal()+")" , "Turbines"                            ,  1538,  1538, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT,  768*STEAM_PER_EU, NBT_OUTPUT,  512, NBT_WASTE_ENERGY, T, NBT_ENERGY_ACCEPTED, TD.Energy.STEAM, NBT_ENERGY_EMITTED, TD.Energy.RU), "TwT", "GSG", "TMT", 'S', OP.stickLong.dat(aMat), 'M', OP.casingMachineDouble.dat(aMat), 'G', OP.gearGt.dat(aMat), 'T', OP.rotor.dat(MT.Magnalium        ));
		
		aMat = MT.DATA.Kinetic_T[4];    aRegistry.add("Steam Turbine ("+MT.VoidMetal    .getLocal()+")" , "Turbines"                            ,  1540,  1538, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT, 1152*STEAM_PER_EU, NBT_OUTPUT,  768, NBT_WASTE_ENERGY, T, NBT_ENERGY_ACCEPTED, TD.Energy.STEAM, NBT_ENERGY_EMITTED, TD.Energy.RU), "TwT", "GSG", "TMT", 'S', OP.stickLong.dat(aMat), 'M', OP.casingMachineDouble.dat(aMat), 'G', OP.gearGt.dat(aMat), 'T', OP.rotor.dat(MT.VoidMetal        ));
		aMat = MT.DATA.Kinetic_T[4];    aRegistry.add("Steam Turbine ("+MT.Trinitanium  .getLocal()+")" , "Turbines"                            ,  1545,  1538, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT, 1536*STEAM_PER_EU, NBT_OUTPUT, 1024, NBT_WASTE_ENERGY, T, NBT_ENERGY_ACCEPTED, TD.Energy.STEAM, NBT_ENERGY_EMITTED, TD.Energy.RU), "TwT", "GSG", "TMT", 'S', OP.stickLong.dat(aMat), 'M', OP.casingMachineDouble.dat(aMat), 'G', OP.gearGt.dat(aMat), 'T', OP.rotor.dat(MT.Trinitanium      ));
		aMat = MT.DATA.Kinetic_T[4];    aRegistry.add("Steam Turbine ("+MT.Graphene     .getLocal()+")" , "Turbines"                            ,  1548,  1538, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT, 3072*STEAM_PER_EU, NBT_OUTPUT, 2048, NBT_WASTE_ENERGY, T, NBT_ENERGY_ACCEPTED, TD.Energy.STEAM, NBT_ENERGY_EMITTED, TD.Energy.RU), "TwT", "GSG", "TMT", 'S', OP.stickLong.dat(aMat), 'M', OP.casingMachineDouble.dat(aMat), 'G', OP.gearGt.dat(aMat), 'T', OP.rotor.dat(MT.Graphene         ));
	}
	
	private static void unsorted2(MultiTileEntityRegistry aRegistry, MultiTileEntityBlock aMetal, MultiTileEntityBlock aMetalChips, MultiTileEntityBlock aMetalWires, MultiTileEntityBlock aMachine, MultiTileEntityBlock aWooden, MultiTileEntityBlock aBush, MultiTileEntityBlock aStone, MultiTileEntityBlock aWool, MultiTileEntityBlock aTNT, MultiTileEntityBlock aHive, MultiTileEntityBlock aUtilMetal, MultiTileEntityBlock aUtilStone, MultiTileEntityBlock aUtilWood, MultiTileEntityBlock aUtilWool, OreDictMaterial aMat, Class<? extends TileEntity> aClass) {
		// Heaters
		aClass = MultiTileEntityHeaterElectric.class;
		aMat = MT.DATA.Electric_T[1];   aRegistry.add("Electric Heater ("                         +VN[1]+")", "Heaters"                             , 10001, 10001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT,   32, NBT_OUTPUT,   16, NBT_WASTE_ENERGY, T, NBT_ENERGY_ACCEPTED, TD.Energy.EU, NBT_ENERGY_EMITTED, TD.Energy.HU), "TCT", "CMC", "TCd", 'M', OP.casingMachineDouble.dat(aMat), 'T', OP.screw.dat(aMat), 'C', OP.wireGt01.dat(ANY.Cu       ));
		aMat = MT.DATA.Electric_T[2];   aRegistry.add("Electric Heater ("                         +VN[2]+")", "Heaters"                             , 10002, 10001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT,  128, NBT_OUTPUT,   64, NBT_WASTE_ENERGY, T, NBT_ENERGY_ACCEPTED, TD.Energy.EU, NBT_ENERGY_EMITTED, TD.Energy.HU), "TCT", "CMC", "TCd", 'M', OP.casingMachineDouble.dat(aMat), 'T', OP.screw.dat(aMat), 'C', OP.wireGt02.dat(MT.Constantan));
		aMat = MT.DATA.Electric_T[3];   aRegistry.add("Electric Heater ("                         +VN[3]+")", "Heaters"                             , 10003, 10001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT,  512, NBT_OUTPUT,  256, NBT_WASTE_ENERGY, T, NBT_ENERGY_ACCEPTED, TD.Energy.EU, NBT_ENERGY_EMITTED, TD.Energy.HU), "TCT", "CMC", "TCd", 'M', OP.casingMachineDouble.dat(aMat), 'T', OP.screw.dat(aMat), 'C', OP.wireGt04.dat(MT.Kanthal   ));
		aMat = MT.DATA.Electric_T[4];   aRegistry.add("Electric Heater ("                         +VN[4]+")", "Heaters"                             , 10004, 10001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT, 2048, NBT_OUTPUT, 1024, NBT_WASTE_ENERGY, T, NBT_ENERGY_ACCEPTED, TD.Energy.EU, NBT_ENERGY_EMITTED, TD.Energy.HU), "TCT", "CMC", "TCd", 'M', OP.casingMachineDouble.dat(aMat), 'T', OP.screw.dat(aMat), 'C', OP.wireGt08.dat(MT.Nichrome  ));
		aMat = MT.DATA.Electric_T[5];   aRegistry.add("Electric Heater ("                         +VN[5]+")", "Heaters"                             , 10005, 10001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT, 8192, NBT_OUTPUT, 4096, NBT_WASTE_ENERGY, T, NBT_ENERGY_ACCEPTED, TD.Energy.EU, NBT_ENERGY_EMITTED, TD.Energy.HU), "TCT", "CMC", "TCd", 'M', OP.casingMachineDouble.dat(aMat), 'T', OP.screw.dat(aMat), 'C', OP.wireGt16.dat(MT.SiC       ));
		
		aClass = MultiTileEntityHeaterFlux.class;
		aMat = MT.DATA.Flux_T[1];       aRegistry.add("Flux Heater ("                   +aMat.getLocal()+")", "Heaters"                             , 11001, 10001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT,  128, NBT_OUTPUT,   16, NBT_WASTE_ENERGY, T, NBT_ENERGY_ACCEPTED, TD.Energy.RF, NBT_ENERGY_EMITTED, TD.Energy.HU), "SSS", "SMS", "SSS", 'M', aRegistry.getItem(10001), 'S', OP.stickLong.dat(aMat));
		aMat = MT.DATA.Flux_T[2];       aRegistry.add("Flux Heater ("                   +aMat.getLocal()+")", "Heaters"                             , 11002, 10001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT,  512, NBT_OUTPUT,   64, NBT_WASTE_ENERGY, T, NBT_ENERGY_ACCEPTED, TD.Energy.RF, NBT_ENERGY_EMITTED, TD.Energy.HU), "SSS", "SMS", "SSS", 'M', aRegistry.getItem(10002), 'S', OP.stickLong.dat(aMat));
		aMat = MT.DATA.Flux_T[3];       aRegistry.add("Flux Heater ("                   +aMat.getLocal()+")", "Heaters"                             , 11003, 10001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT, 2048, NBT_OUTPUT,  256, NBT_WASTE_ENERGY, T, NBT_ENERGY_ACCEPTED, TD.Energy.RF, NBT_ENERGY_EMITTED, TD.Energy.HU), "SSS", "SMS", "SSS", 'M', aRegistry.getItem(10003), 'S', OP.stickLong.dat(aMat));
		aMat = MT.DATA.Flux_T[4];       aRegistry.add("Flux Heater ("                   +aMat.getLocal()+")", "Heaters"                             , 11004, 10001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT, 8192, NBT_OUTPUT, 1024, NBT_WASTE_ENERGY, T, NBT_ENERGY_ACCEPTED, TD.Energy.RF, NBT_ENERGY_EMITTED, TD.Energy.HU), "SSS", "SMS", "SSS", 'M', aRegistry.getItem(10004), 'S', OP.stickLong.dat(aMat));
		aMat = MT.DATA.Flux_T[5];       aRegistry.add("Flux Heater ("                   +aMat.getLocal()+")", "Heaters"                             , 11005, 10001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT,32768, NBT_OUTPUT, 4096, NBT_WASTE_ENERGY, T, NBT_ENERGY_ACCEPTED, TD.Energy.RF, NBT_ENERGY_EMITTED, TD.Energy.HU), "SSS", "SMS", "SSS", 'M', aRegistry.getItem(10005), 'S', OP.stickLong.dat(aMat));
		
		
		// Engines
		aClass = MultiTileEntityEngineElectric.class;
		aMat = MT.DATA.Electric_T[1];   aRegistry.add("Electric Engine ("                         +VN[1]+")", "Engines"                             , 10011,  1304, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT,   32, NBT_OUTPUT,   16, NBT_WASTE_ENERGY, T, NBT_ENERGY_ACCEPTED, TD.Energy.EU, NBT_ENERGY_EMITTED, TD.Energy.KU), "PhP", "CIC", "PwP", 'P', OP.plateTriple.dat(aMat), 'I', OP.stickLong.dat(MT.IronMagnetic        ), 'C', OP.wireGt01.dat(ANY.Cu)); // TODO: Temp Recipes
		aMat = MT.DATA.Electric_T[2];   aRegistry.add("Electric Engine ("                         +VN[2]+")", "Engines"                             , 10012,  1304, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT,  128, NBT_OUTPUT,   64, NBT_WASTE_ENERGY, T, NBT_ENERGY_ACCEPTED, TD.Energy.EU, NBT_ENERGY_EMITTED, TD.Energy.KU), "PhP", "CIC", "PwP", 'P', OP.plateTriple.dat(aMat), 'I', OP.stickLong.dat(MT.SteelMagnetic       ), 'C', OP.wireGt02.dat(ANY.Cu));
		aMat = MT.DATA.Electric_T[3];   aRegistry.add("Electric Engine ("                         +VN[3]+")", "Engines"                             , 10013,  1304, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT,  512, NBT_OUTPUT,  256, NBT_WASTE_ENERGY, T, NBT_ENERGY_ACCEPTED, TD.Energy.EU, NBT_ENERGY_EMITTED, TD.Energy.KU), "PhP", "CIC", "PwP", 'P', OP.plateTriple.dat(aMat), 'I', OP.stickLong.dat(MT.SteelMagnetic       ), 'C', OP.wireGt04.dat(MT.AnnealedCopper));
		aMat = MT.DATA.Electric_T[4];   aRegistry.add("Electric Engine ("                         +VN[4]+")", "Engines"                             , 10014,  1304, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT, 2048, NBT_OUTPUT, 1024, NBT_WASTE_ENERGY, T, NBT_ENERGY_ACCEPTED, TD.Energy.EU, NBT_ENERGY_EMITTED, TD.Energy.KU), "PhP", "CIC", "PwP", 'P', OP.plateTriple.dat(aMat), 'I', OP.stickLong.dat(MT.NeodymiumMagnetic   ), 'C', OP.wireGt08.dat(MT.AnnealedCopper));
		aMat = MT.DATA.Electric_T[5];   aRegistry.add("Electric Engine ("                         +VN[5]+")", "Engines"                             , 10015,  1304, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT, 8192, NBT_OUTPUT, 4096, NBT_WASTE_ENERGY, T, NBT_ENERGY_ACCEPTED, TD.Energy.EU, NBT_ENERGY_EMITTED, TD.Energy.KU), "PhP", "CIC", "PwP", 'P', OP.plateTriple.dat(aMat), 'I', OP.stickLong.dat(MT.NeodymiumMagnetic   ), 'C', OP.wireGt16.dat(MT.AnnealedCopper));
		
		aClass = MultiTileEntityEngineFlux.class;
		aMat = MT.DATA.Flux_T[1];       aRegistry.add("Flux Engine ("                   +aMat.getLocal()+")", "Engines"                             , 11011,  1304, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT,  128, NBT_OUTPUT,   16, NBT_WASTE_ENERGY, T, NBT_ENERGY_ACCEPTED, TD.Energy.RF, NBT_ENERGY_EMITTED, TD.Energy.KU), "G", "M", "G", 'M', aRegistry.getItem(10011), 'G', OP.gearGt.dat(aMat));
		aMat = MT.DATA.Flux_T[2];       aRegistry.add("Flux Engine ("                   +aMat.getLocal()+")", "Engines"                             , 11012,  1304, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT,  512, NBT_OUTPUT,   64, NBT_WASTE_ENERGY, T, NBT_ENERGY_ACCEPTED, TD.Energy.RF, NBT_ENERGY_EMITTED, TD.Energy.KU), "G", "M", "G", 'M', aRegistry.getItem(10012), 'G', OP.gearGt.dat(aMat));
		aMat = MT.DATA.Flux_T[3];       aRegistry.add("Flux Engine ("                   +aMat.getLocal()+")", "Engines"                             , 11013,  1304, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT, 2048, NBT_OUTPUT,  256, NBT_WASTE_ENERGY, T, NBT_ENERGY_ACCEPTED, TD.Energy.RF, NBT_ENERGY_EMITTED, TD.Energy.KU), "G", "M", "G", 'M', aRegistry.getItem(10013), 'G', OP.gearGt.dat(aMat));
		aMat = MT.DATA.Flux_T[4];       aRegistry.add("Flux Engine ("                   +aMat.getLocal()+")", "Engines"                             , 11014,  1304, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT, 8192, NBT_OUTPUT, 1024, NBT_WASTE_ENERGY, T, NBT_ENERGY_ACCEPTED, TD.Energy.RF, NBT_ENERGY_EMITTED, TD.Energy.KU), "G", "M", "G", 'M', aRegistry.getItem(10014), 'G', OP.gearGt.dat(aMat));
		aMat = MT.DATA.Flux_T[5];       aRegistry.add("Flux Engine ("                   +aMat.getLocal()+")", "Engines"                             , 11015,  1304, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT,32768, NBT_OUTPUT, 4096, NBT_WASTE_ENERGY, T, NBT_ENERGY_ACCEPTED, TD.Energy.RF, NBT_ENERGY_EMITTED, TD.Energy.KU), "G", "M", "G", 'M', aRegistry.getItem(10015), 'G', OP.gearGt.dat(aMat));
		
		
		// Motors
		aClass = MultiTileEntityMotorElectric.class;
		aMat = MT.DATA.Electric_T[1];   aRegistry.add("Electric Motor ("                          +VN[1]+")", "Motors"                              , 10021, 10021, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT,   32, NBT_OUTPUT,   16, NBT_WASTE_ENERGY, T, NBT_ENERGY_ACCEPTED, TD.Energy.EU, NBT_ENERGY_EMITTED, TD.Energy.RU), "TIT", "CMC", "TGd", 'M', OP.casingMachineDouble.dat(aMat), 'G', OP.gearGt.dat(aMat), 'T', OP.screw.dat(aMat), 'I', OP.stickLong.dat(MT.IronMagnetic         ), 'C', OP.wireGt01.dat(ANY.Cu)); // TODO: Temp Recipes
		aMat = MT.DATA.Electric_T[2];   aRegistry.add("Electric Motor ("                          +VN[2]+")", "Motors"                              , 10022, 10021, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT,  128, NBT_OUTPUT,   64, NBT_WASTE_ENERGY, T, NBT_ENERGY_ACCEPTED, TD.Energy.EU, NBT_ENERGY_EMITTED, TD.Energy.RU), "TIT", "CMC", "TGd", 'M', OP.casingMachineDouble.dat(aMat), 'G', OP.gearGt.dat(aMat), 'T', OP.screw.dat(aMat), 'I', OP.stickLong.dat(MT.SteelMagnetic        ), 'C', OP.wireGt02.dat(ANY.Cu));
		aMat = MT.DATA.Electric_T[3];   aRegistry.add("Electric Motor ("                          +VN[3]+")", "Motors"                              , 10023, 10021, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT,  512, NBT_OUTPUT,  256, NBT_WASTE_ENERGY, T, NBT_ENERGY_ACCEPTED, TD.Energy.EU, NBT_ENERGY_EMITTED, TD.Energy.RU), "TIT", "CMC", "TGd", 'M', OP.casingMachineDouble.dat(aMat), 'G', OP.gearGt.dat(aMat), 'T', OP.screw.dat(aMat), 'I', OP.stickLong.dat(MT.SteelMagnetic        ), 'C', OP.wireGt04.dat(MT.AnnealedCopper));
		aMat = MT.DATA.Electric_T[4];   aRegistry.add("Electric Motor ("                          +VN[4]+")", "Motors"                              , 10024, 10021, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT, 2048, NBT_OUTPUT, 1024, NBT_WASTE_ENERGY, T, NBT_ENERGY_ACCEPTED, TD.Energy.EU, NBT_ENERGY_EMITTED, TD.Energy.RU), "TIT", "CMC", "TGd", 'M', OP.casingMachineDouble.dat(aMat), 'G', OP.gearGt.dat(aMat), 'T', OP.screw.dat(aMat), 'I', OP.stickLong.dat(MT.NeodymiumMagnetic    ), 'C', OP.wireGt08.dat(MT.AnnealedCopper));
		aMat = MT.DATA.Electric_T[5];   aRegistry.add("Electric Motor ("                          +VN[5]+")", "Motors"                              , 10025, 10021, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT, 8192, NBT_OUTPUT, 4096, NBT_WASTE_ENERGY, T, NBT_ENERGY_ACCEPTED, TD.Energy.EU, NBT_ENERGY_EMITTED, TD.Energy.RU), "TIT", "CMC", "TGd", 'M', OP.casingMachineDouble.dat(aMat), 'G', OP.gearGt.dat(aMat), 'T', OP.screw.dat(aMat), 'I', OP.stickLong.dat(MT.NeodymiumMagnetic    ), 'C', OP.wireGt16.dat(MT.AnnealedCopper));
		
		aClass = MultiTileEntityMotorFlux.class;
		aMat = MT.DATA.Flux_T[1];       aRegistry.add("Flux Motor ("                    +aMat.getLocal()+")", "Motors"                              , 11021, 10021, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT,  128, NBT_OUTPUT,   16, NBT_WASTE_ENERGY, T, NBT_ENERGY_ACCEPTED, TD.Energy.RF, NBT_ENERGY_EMITTED, TD.Energy.RU), "GMG", 'M', aRegistry.getItem(10021), 'G', OP.gearGt.dat(aMat));
		aMat = MT.DATA.Flux_T[2];       aRegistry.add("Flux Motor ("                    +aMat.getLocal()+")", "Motors"                              , 11022, 10021, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT,  512, NBT_OUTPUT,   64, NBT_WASTE_ENERGY, T, NBT_ENERGY_ACCEPTED, TD.Energy.RF, NBT_ENERGY_EMITTED, TD.Energy.RU), "GMG", 'M', aRegistry.getItem(10022), 'G', OP.gearGt.dat(aMat));
		aMat = MT.DATA.Flux_T[3];       aRegistry.add("Flux Motor ("                    +aMat.getLocal()+")", "Motors"                              , 11023, 10021, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT, 2048, NBT_OUTPUT,  256, NBT_WASTE_ENERGY, T, NBT_ENERGY_ACCEPTED, TD.Energy.RF, NBT_ENERGY_EMITTED, TD.Energy.RU), "GMG", 'M', aRegistry.getItem(10023), 'G', OP.gearGt.dat(aMat));
		aMat = MT.DATA.Flux_T[4];       aRegistry.add("Flux Motor ("                    +aMat.getLocal()+")", "Motors"                              , 11024, 10021, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT, 8192, NBT_OUTPUT, 1024, NBT_WASTE_ENERGY, T, NBT_ENERGY_ACCEPTED, TD.Energy.RF, NBT_ENERGY_EMITTED, TD.Energy.RU), "GMG", 'M', aRegistry.getItem(10024), 'G', OP.gearGt.dat(aMat));
		aMat = MT.DATA.Flux_T[5];       aRegistry.add("Flux Motor ("                    +aMat.getLocal()+")", "Motors"                              , 11025, 10021, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT,32768, NBT_OUTPUT, 4096, NBT_WASTE_ENERGY, T, NBT_ENERGY_ACCEPTED, TD.Energy.RF, NBT_ENERGY_EMITTED, TD.Energy.RU), "GMG", 'M', aRegistry.getItem(10025), 'G', OP.gearGt.dat(aMat));
		
		
		// Magnets
		aClass = MultiTileEntityMagnetElectric.class;
		aMat = MT.DATA.Electric_T[1];   aRegistry.add("Electromagnet ("                           +VN[1]+")", "Magnets"                             , 10031, 10031, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT,   32, NBT_OUTPUT,   16, NBT_WASTE_ENERGY, T, NBT_ENERGY_ACCEPTED, TD.Energy.EU, NBT_ENERGY_EMITTED, TD.Energy.MU), "CxC", "CMC", "CwC", 'M', OP.casingMachine.dat(aMat), 'C', OP.wireGt01.dat(ANY.Cu));
		aMat = MT.DATA.Electric_T[2];   aRegistry.add("Electromagnet ("                           +VN[2]+")", "Magnets"                             , 10032, 10031, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT,  128, NBT_OUTPUT,   64, NBT_WASTE_ENERGY, T, NBT_ENERGY_ACCEPTED, TD.Energy.EU, NBT_ENERGY_EMITTED, TD.Energy.MU), "CxC", "CMC", "CwC", 'M', OP.casingMachine.dat(aMat), 'C', OP.wireGt02.dat(ANY.Cu));
		aMat = MT.DATA.Electric_T[3];   aRegistry.add("Electromagnet ("                           +VN[3]+")", "Magnets"                             , 10033, 10031, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT,  512, NBT_OUTPUT,  256, NBT_WASTE_ENERGY, T, NBT_ENERGY_ACCEPTED, TD.Energy.EU, NBT_ENERGY_EMITTED, TD.Energy.MU), "CxC", "CMC", "CwC", 'M', OP.casingMachine.dat(aMat), 'C', OP.wireGt04.dat(MT.AnnealedCopper));
		aMat = MT.DATA.Electric_T[4];   aRegistry.add("Electromagnet ("                           +VN[4]+")", "Magnets"                             , 10034, 10031, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT, 2048, NBT_OUTPUT, 1024, NBT_WASTE_ENERGY, T, NBT_ENERGY_ACCEPTED, TD.Energy.EU, NBT_ENERGY_EMITTED, TD.Energy.MU), "CxC", "CMC", "CwC", 'M', OP.casingMachine.dat(aMat), 'C', OP.wireGt08.dat(MT.AnnealedCopper));
		aMat = MT.DATA.Electric_T[5];   aRegistry.add("Electromagnet ("                           +VN[5]+")", "Magnets"                             , 10035, 10031, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT, 8192, NBT_OUTPUT, 4096, NBT_WASTE_ENERGY, T, NBT_ENERGY_ACCEPTED, TD.Energy.EU, NBT_ENERGY_EMITTED, TD.Energy.MU), "CxC", "CMC", "CwC", 'M', OP.casingMachine.dat(aMat), 'C', OP.wireGt16.dat(MT.AnnealedCopper));
		
		aClass = MultiTileEntityMagnetFlux.class;
		aMat = MT.DATA.Flux_T[1];       aRegistry.add("Flux Magnet ("                   +aMat.getLocal()+")", "Magnets"                             , 11031, 10031, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT,  128, NBT_OUTPUT,   16, NBT_WASTE_ENERGY, T, NBT_ENERGY_ACCEPTED, TD.Energy.RF, NBT_ENERGY_EMITTED, TD.Energy.MU), "SSS", "SMS", "SSS", 'M', aRegistry.getItem(10031), 'S', OP.stickLong.dat(aMat));
		aMat = MT.DATA.Flux_T[2];       aRegistry.add("Flux Magnet ("                   +aMat.getLocal()+")", "Magnets"                             , 11032, 10031, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT,  512, NBT_OUTPUT,   64, NBT_WASTE_ENERGY, T, NBT_ENERGY_ACCEPTED, TD.Energy.RF, NBT_ENERGY_EMITTED, TD.Energy.MU), "SSS", "SMS", "SSS", 'M', aRegistry.getItem(10032), 'S', OP.stickLong.dat(aMat));
		aMat = MT.DATA.Flux_T[3];       aRegistry.add("Flux Magnet ("                   +aMat.getLocal()+")", "Magnets"                             , 11033, 10031, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT, 2048, NBT_OUTPUT,  256, NBT_WASTE_ENERGY, T, NBT_ENERGY_ACCEPTED, TD.Energy.RF, NBT_ENERGY_EMITTED, TD.Energy.MU), "SSS", "SMS", "SSS", 'M', aRegistry.getItem(10033), 'S', OP.stickLong.dat(aMat));
		aMat = MT.DATA.Flux_T[4];       aRegistry.add("Flux Magnet ("                   +aMat.getLocal()+")", "Magnets"                             , 11034, 10031, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT, 8192, NBT_OUTPUT, 1024, NBT_WASTE_ENERGY, T, NBT_ENERGY_ACCEPTED, TD.Energy.RF, NBT_ENERGY_EMITTED, TD.Energy.MU), "SSS", "SMS", "SSS", 'M', aRegistry.getItem(10034), 'S', OP.stickLong.dat(aMat));
		aMat = MT.DATA.Flux_T[5];       aRegistry.add("Flux Magnet ("                   +aMat.getLocal()+")", "Magnets"                             , 11035, 10031, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT,32768, NBT_OUTPUT, 4096, NBT_WASTE_ENERGY, T, NBT_ENERGY_ACCEPTED, TD.Energy.RF, NBT_ENERGY_EMITTED, TD.Energy.MU), "SSS", "SMS", "SSS", 'M', aRegistry.getItem(10035), 'S', OP.stickLong.dat(aMat));
																																																																																																																																							 
		
		// Transformers
		aClass = MultiTileEntityTransformerElectric.class;
		aMat = MT.DATA.Electric_T[0];   aRegistry.add("Transformer ("+VN[0]+"-"                   +VN[1]+")", "Transformers"                        , 10040, 10041, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT, V[1], NBT_OUTPUT, V[0], NBT_MULTIPLIER, V[1]/V[0], NBT_WASTE_ENERGY, F, NBT_ENERGY_ACCEPTED, TD.Energy.EU, NBT_ENERGY_EMITTED, TD.Energy.EU), "WIW", "XMx", "WIW", 'M', OP.casingMachine.dat(aMat), 'W', OP.wireGt01.dat(ANY.Cu), 'X', OP.wireGt04.dat(ANY.Cu), 'I', OP.plateDouble.dat(ANY.Iron));
		aMat = MT.DATA.Electric_T[1];   aRegistry.add("Transformer ("+VN[1]+"-"                   +VN[2]+")", "Transformers"                        , 10041, 10041, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT, V[2], NBT_OUTPUT, V[1], NBT_MULTIPLIER, V[2]/V[1], NBT_WASTE_ENERGY, F, NBT_ENERGY_ACCEPTED, TD.Energy.EU, NBT_ENERGY_EMITTED, TD.Energy.EU), "WIW", "XMx", "WIW", 'M', OP.casingMachine.dat(aMat), 'W', OP.wireGt01.dat(ANY.Cu), 'X', OP.wireGt04.dat(ANY.Cu), 'I', OP.plateDouble.dat(ANY.Iron));
		aMat = MT.DATA.Electric_T[2];   aRegistry.add("Transformer ("+VN[2]+"-"                   +VN[3]+")", "Transformers"                        , 10042, 10041, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT, V[3], NBT_OUTPUT, V[2], NBT_MULTIPLIER, V[3]/V[2], NBT_WASTE_ENERGY, F, NBT_ENERGY_ACCEPTED, TD.Energy.EU, NBT_ENERGY_EMITTED, TD.Energy.EU), "WIW", "XMx", "WIW", 'M', OP.casingMachine.dat(aMat), 'W', OP.wireGt01.dat(ANY.Cu), 'X', OP.wireGt04.dat(ANY.Cu), 'I', OP.plateDouble.dat(ANY.Iron));
		aMat = MT.DATA.Electric_T[3];   aRegistry.add("Transformer ("+VN[3]+"-"                   +VN[4]+")", "Transformers"                        , 10043, 10041, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT, V[4], NBT_OUTPUT, V[3], NBT_MULTIPLIER, V[4]/V[3], NBT_WASTE_ENERGY, F, NBT_ENERGY_ACCEPTED, TD.Energy.EU, NBT_ENERGY_EMITTED, TD.Energy.EU), "WIW", "XMx", "WIW", 'M', OP.casingMachine.dat(aMat), 'W', OP.wireGt01.dat(MT.AnnealedCopper), 'X', OP.wireGt04.dat(MT.AnnealedCopper), 'I', OP.plateDouble.dat(ANY.Iron));
		aMat = MT.DATA.Electric_T[4];   aRegistry.add("Transformer ("+VN[4]+"-"                   +VN[5]+")", "Transformers"                        , 10044, 10041, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT, V[5], NBT_OUTPUT, V[4], NBT_MULTIPLIER, V[5]/V[4], NBT_WASTE_ENERGY, F, NBT_ENERGY_ACCEPTED, TD.Energy.EU, NBT_ENERGY_EMITTED, TD.Energy.EU), "WIW", "XMx", "WIW", 'M', OP.casingMachine.dat(aMat), 'W', OP.wireGt01.dat(MT.AnnealedCopper), 'X', OP.wireGt04.dat(MT.AnnealedCopper), 'I', OP.plateDouble.dat(ANY.Iron));
		aMat = MT.DATA.Electric_T[5];   aRegistry.add("Transformer ("+VN[5]+"-"+VN[6]+")"                   , "Transformers"                        , 10045, 10041, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT, V[6], NBT_OUTPUT, V[5], NBT_MULTIPLIER, V[6]/V[5], NBT_WASTE_ENERGY, F, NBT_ENERGY_ACCEPTED, TD.Energy.EU, NBT_ENERGY_EMITTED, TD.Energy.EU), "WIW", "XMx", "WIW", 'M', OP.casingMachine.dat(aMat), 'W', OP.wireGt01.dat(MT.AnnealedCopper), 'X', OP.wireGt04.dat(MT.AnnealedCopper), 'I', OP.plateDouble.dat(ANY.Iron));
		aMat = MT.DATA.Electric_T[6];   aRegistry.add("Transformer ("+VN[6]+"-"+VN[7]+")"                   , "Transformers"                        , 10046, 10041, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT, V[7], NBT_OUTPUT, V[6], NBT_MULTIPLIER, V[7]/V[6], NBT_WASTE_ENERGY, F, NBT_ENERGY_ACCEPTED, TD.Energy.EU, NBT_ENERGY_EMITTED, TD.Energy.EU), "WIW", "XMx", "WIW", 'M', OP.casingMachine.dat(aMat), 'W', OP.wireGt01.dat(MT.AnnealedCopper), 'X', OP.wireGt04.dat(MT.AnnealedCopper), 'I', OP.plateDouble.dat(ANY.Iron));
		aMat = MT.DATA.Electric_T[7];   aRegistry.add("Transformer ("+VN[7]+"-"+VN[8]+")"                   , "Transformers"                        , 10047, 10041, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT, V[8], NBT_OUTPUT, V[7], NBT_MULTIPLIER, V[8]/V[7], NBT_WASTE_ENERGY, F, NBT_ENERGY_ACCEPTED, TD.Energy.EU, NBT_ENERGY_EMITTED, TD.Energy.EU), "WIW", "XMx", "WIW", 'M', OP.casingMachine.dat(aMat), 'W', OP.wireGt01.dat(MT.AnnealedCopper), 'X', OP.wireGt04.dat(MT.AnnealedCopper), 'I', OP.plateDouble.dat(ANY.Iron));
		aMat = MT.DATA.Electric_T[8];   aRegistry.add("Transformer ("+VN[8]+"-"+VN[9]+")"                   , "Transformers"                        , 10048, 10041, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT, V[9], NBT_OUTPUT, V[8], NBT_MULTIPLIER, V[9]/V[8], NBT_WASTE_ENERGY, F, NBT_ENERGY_ACCEPTED, TD.Energy.EU, NBT_ENERGY_EMITTED, TD.Energy.EU), "WIW", "XMx", "WIW", 'M', OP.casingMachine.dat(aMat), 'W', OP.wireGt01.dat(MT.AnnealedCopper), 'X', OP.wireGt04.dat(MT.AnnealedCopper), 'I', OP.plateDouble.dat(ANY.Iron));
		
		
		// Battery Boxes
		for (int i = 0; i < 10; i++) {
			aRegistry.add("Battery Box ("       +VN[i]+")", "Battery Boxes", 10080+i, 10081, MultiTileEntityBatteryBox      .class, MT.DATA.Electric_T[i].mToolQuality, 16, aMachine, UT.NBT.make(NBT_MATERIAL, MT.DATA.Electric_T[i], NBT_HARDNESS, 4.0F, NBT_RESISTANCE, 4.0F, NBT_INPUT, V[i], NBT_OUTPUT, V[i], NBT_ENERGY_EMITTED, TD.Energy.EU, NBT_INV_SIZE,  4), "WCW", "WCW", "XMX", 'C', MT.DATA.CABLES_01[i], 'X', OD_CIRCUITS[i], 'W', MT.DATA.WIRES_01[i], 'M', OP.casingMachine.dat(MT.DATA.Electric_T[i]));
			aRegistry.add("Large Battery Box (" +VN[i]+")", "Battery Boxes", 10090+i, 10081, MultiTileEntityBatteryBoxLarge .class, MT.DATA.Electric_T[i].mToolQuality, 16, aMachine, UT.NBT.make(NBT_MATERIAL, MT.DATA.Electric_T[i], NBT_HARDNESS, 4.0F, NBT_RESISTANCE, 4.0F, NBT_INPUT, V[i], NBT_OUTPUT, V[i], NBT_ENERGY_EMITTED, TD.Energy.EU, NBT_INV_SIZE, 16), "WCW", "WCW", "XMX", 'C', MT.DATA.CABLES_04[i], 'X', OD_CIRCUITS[i], 'W', MT.DATA.WIRES_04[i], 'M', aRegistry.getItem(10040+i));
		}
		
		
		// Solar Panels
		aClass = MultiTileEntitySolarPanelElectric.class;
		aMat = MT.DATA.Electric_T[0];   aRegistry.add("Solar Panel (Silicon)"                               , "Solar Panels"                        , 10050, 10050, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_OUTPUT,  8, NBT_ENERGY_EMITTED, TD.Energy.EU), "SWS", "CMC", "SWS", 'M', OP.casingMachine.dat(aMat), 'W', OP.cableGt01.dat(ANY.Cu           ), 'C', OD_CIRCUITS[1], 'S', OP.plateGem.dat(ANY.Si));
		aMat = MT.DATA.Electric_T[2];   aRegistry.add("Solar Panel (Germanium)"                             , "Solar Panels"                        , 10051, 10050, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_OUTPUT, 16, NBT_ENERGY_EMITTED, TD.Energy.EU), "SWS", "CMC", "SWS", 'M', OP.casingMachine.dat(aMat), 'W', OP.cableGt01.dat(MT.AnnealedCopper), 'C', OD_CIRCUITS[6], 'S', OP.plateGem.dat(MT.Ge));
		
		
		// Long Distance Transfer
		aMat = MT.Pt;                   aRegistry.add("Long Distance Item Pipeline Endpoint"                , "Long Distance Transport"             , 10060, 10060, MultiTileEntityLongDistancePipelineItem.class, aMat.mToolQuality, 16, aMachine      , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,  16.0F, NBT_RESISTANCE,  16.0F), "ZPZ", "PMP", "ZPZ", 'M', OP.casingMachine.dat(aMat), 'P', OP.pipeMedium.dat(aMat), 'Z', OP.plate.dat(ANY.Plastic));
		aMat = ANY.W;                   aRegistry.add("Long Distance Fluid Pipeline Endpoint"               , "Long Distance Transport"             , 10061, 10060, MultiTileEntityLongDistancePipelineFluid.class, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,  16.0F, NBT_RESISTANCE,  16.0F), "ZPZ", "PMP", "ZPZ", 'M', OP.casingMachine.dat(aMat), 'P', OP.pipeMedium.dat(aMat), 'Z', OP.plate.dat(ANY.Plastic));
		aClass = MultiTileEntityLongDistanceTransformer.class;
		aMat = MT.DATA.Electric_T[4];   aRegistry.add("Long Distance Transformer Endpoint ("      +VN[4]+")", "Long Distance Transport"             , 10064, 10060, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT, V[4], NBT_OUTPUT, V[4], NBT_WASTE_ENERGY, F, NBT_ENERGY_ACCEPTED, TD.Energy.EU, NBT_ENERGY_EMITTED, TD.Energy.EU), "WMW", "MxM", "WMW", 'M', aRegistry.getItem(10044), 'W', OP.cableGt04.dat(MT.AnnealedCopper));
		aMat = MT.DATA.Electric_T[5];   aRegistry.add("Long Distance Transformer Endpoint ("      +VN[5]+")", "Long Distance Transport"             , 10065, 10060, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT, V[5], NBT_OUTPUT, V[5], NBT_WASTE_ENERGY, F, NBT_ENERGY_ACCEPTED, TD.Energy.EU, NBT_ENERGY_EMITTED, TD.Energy.EU), "WMW", "MxM", "WMW", 'M', aRegistry.getItem(10045), 'W', OP.cableGt04.dat(MT.AnnealedCopper));
		aMat = MT.DATA.Electric_T[6];   aRegistry.add("Long Distance Transformer Endpoint ("+VN[6]+")"      , "Long Distance Transport"             , 10066, 10060, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT, V[6], NBT_OUTPUT, V[6], NBT_WASTE_ENERGY, F, NBT_ENERGY_ACCEPTED, TD.Energy.EU, NBT_ENERGY_EMITTED, TD.Energy.EU), "WMW", "MxM", "WMW", 'M', aRegistry.getItem(10046), 'W', OP.cableGt04.dat(MT.AnnealedCopper));
		aMat = MT.DATA.Electric_T[7];   aRegistry.add("Long Distance Transformer Endpoint ("+VN[7]+")"      , "Long Distance Transport"             , 10067, 10060, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT, V[7], NBT_OUTPUT, V[7], NBT_WASTE_ENERGY, F, NBT_ENERGY_ACCEPTED, TD.Energy.EU, NBT_ENERGY_EMITTED, TD.Energy.EU), "WMW", "MxM", "WMW", 'M', aRegistry.getItem(10047), 'W', OP.cableGt04.dat(MT.AnnealedCopper));
		aMat = MT.DATA.Electric_T[8];   aRegistry.add("Long Distance Transformer Endpoint ("+VN[8]+")"      , "Long Distance Transport"             , 10068, 10060, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT, V[8], NBT_OUTPUT, V[8], NBT_WASTE_ENERGY, F, NBT_ENERGY_ACCEPTED, TD.Energy.EU, NBT_ENERGY_EMITTED, TD.Energy.EU), "WMW", "MxM", "WMW", 'M', aRegistry.getItem(10048), 'W', OP.cableGt04.dat(MT.AnnealedCopper));
		
		BlocksGT.LongDistPipe01.setCreativeTab(aRegistry.mCreativeTabs.get((short)10060));
		BlocksGT.LongDistWire01.setCreativeTab(aRegistry.mCreativeTabs.get((short)10060));
		
		
		// BC Lasers
		aClass = MultiTileEntityLaserBuildcraft.class;
		aMat = MT.DATA.Electric_T[1];   aRegistry.add("Buildcraft Assembly Laser ("               +VN[1]+")", "Lasers"                              , 10071, 10071, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT, V[1], NBT_OUTPUT, V[1]*RF_PER_EU, NBT_WASTE_ENERGY, F, NBT_ENERGY_ACCEPTED, TD.Energy.EU, NBT_ENERGY_EMITTED, TD.Energy.RF), "CWC", "PDP", "wfh", 'P', OP.plateTriple.dat(aMat), 'C', OD_CIRCUITS[1], 'W', MT.DATA.CABLES_04[1], 'D', OP.gemFlawless.dat(ANY.Diamond));
		aMat = MT.DATA.Electric_T[2];   aRegistry.add("Buildcraft Assembly Laser ("               +VN[2]+")", "Lasers"                              , 10072, 10071, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT, V[2], NBT_OUTPUT, V[2]*RF_PER_EU, NBT_WASTE_ENERGY, F, NBT_ENERGY_ACCEPTED, TD.Energy.EU, NBT_ENERGY_EMITTED, TD.Energy.RF), "CWC", "PDP", "wfh", 'P', OP.plateTriple.dat(aMat), 'C', OD_CIRCUITS[2], 'W', MT.DATA.CABLES_04[2], 'D', OP.gemFlawless.dat(ANY.Diamond));
		aMat = MT.DATA.Electric_T[3];   aRegistry.add("Buildcraft Assembly Laser ("               +VN[3]+")", "Lasers"                              , 10073, 10071, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT, V[3], NBT_OUTPUT, V[3]*RF_PER_EU, NBT_WASTE_ENERGY, F, NBT_ENERGY_ACCEPTED, TD.Energy.EU, NBT_ENERGY_EMITTED, TD.Energy.RF), "CWC", "PDP", "wfh", 'P', OP.plateTriple.dat(aMat), 'C', OD_CIRCUITS[3], 'W', MT.DATA.CABLES_04[3], 'D', OP.gemExquisite.dat(ANY.Diamond));
		aMat = MT.DATA.Electric_T[4];   aRegistry.add("Buildcraft Assembly Laser ("               +VN[4]+")", "Lasers"                              , 10074, 10071, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT, V[4], NBT_OUTPUT, V[4]*RF_PER_EU, NBT_WASTE_ENERGY, F, NBT_ENERGY_ACCEPTED, TD.Energy.EU, NBT_ENERGY_EMITTED, TD.Energy.RF), "CWC", "PDP", "wfh", 'P', OP.plateTriple.dat(aMat), 'C', OD_CIRCUITS[4], 'W', MT.DATA.CABLES_04[4], 'D', OP.gemExquisite.dat(ANY.Diamond));
		aMat = MT.DATA.Electric_T[5];   aRegistry.add("Buildcraft Assembly Laser ("               +VN[5]+")", "Lasers"                              , 10075, 10071, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT, V[5], NBT_OUTPUT, V[5]*RF_PER_EU, NBT_WASTE_ENERGY, F, NBT_ENERGY_ACCEPTED, TD.Energy.EU, NBT_ENERGY_EMITTED, TD.Energy.RF), "CWC", "PDP", "wfh", 'P', OP.plateTriple.dat(aMat), 'C', OD_CIRCUITS[5], 'W', MT.DATA.CABLES_04[5], 'D', OP.gemLegendary.dat(ANY.Diamond));
		
		
		// Lasers
		aClass = MultiTileEntityLaserElectric.class;
		aMat = MT.DATA.Electric_T[1];   aRegistry.add("Electric CO2 Laser ("                      +VN[1]+")", "Lasers"                              , 10101, 10071, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT,   32, NBT_OUTPUT,   16, NBT_WASTE_ENERGY, T, NBT_ENERGY_ACCEPTED, TD.Energy.EU, NBT_ENERGY_EMITTED, TD.Energy.LU), " L ", " W ", "CMC", 'M', OP.casingMachine.dat(aMat), 'L', IL.Comp_Laser_Gas_CO2, 'C', OD_CIRCUITS[1], 'W', MT.DATA.CABLES_01[1]);
		aMat = MT.DATA.Electric_T[2];   aRegistry.add("Electric CO2 Laser ("                      +VN[2]+")", "Lasers"                              , 10102, 10071, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT,  128, NBT_OUTPUT,   64, NBT_WASTE_ENERGY, T, NBT_ENERGY_ACCEPTED, TD.Energy.EU, NBT_ENERGY_EMITTED, TD.Energy.LU), "L L", "W W", "CMC", 'M', OP.casingMachine.dat(aMat), 'L', IL.Comp_Laser_Gas_CO2, 'C', OD_CIRCUITS[2], 'W', MT.DATA.CABLES_01[2]);
		aMat = MT.DATA.Electric_T[3];   aRegistry.add("Electric CO2 Laser ("                      +VN[3]+")", "Lasers"                              , 10103, 10071, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT,  512, NBT_OUTPUT,  256, NBT_WASTE_ENERGY, T, NBT_ENERGY_ACCEPTED, TD.Energy.EU, NBT_ENERGY_EMITTED, TD.Energy.LU), "LLL", "WWW", "CMC", 'M', OP.casingMachine.dat(aMat), 'L', IL.Comp_Laser_Gas_CO2, 'C', OD_CIRCUITS[3], 'W', MT.DATA.CABLES_01[3]);
		aMat = MT.DATA.Electric_T[4];   aRegistry.add("Electric CO2 Laser ("                      +VN[4]+")", "Lasers"                              , 10104, 10071, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT, 2048, NBT_OUTPUT, 1024, NBT_WASTE_ENERGY, T, NBT_ENERGY_ACCEPTED, TD.Energy.EU, NBT_ENERGY_EMITTED, TD.Energy.LU), "L L", "LWL", "CMC", 'M', OP.casingMachine.dat(aMat), 'L', IL.Comp_Laser_Gas_CO2, 'C', OD_CIRCUITS[4], 'W', MT.DATA.CABLES_04[4]);
		aMat = MT.DATA.Electric_T[5];   aRegistry.add("Electric CO2 Laser ("                      +VN[5]+")", "Lasers"                              , 10105, 10071, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT, 8192, NBT_OUTPUT, 4096, NBT_WASTE_ENERGY, T, NBT_ENERGY_ACCEPTED, TD.Energy.EU, NBT_ENERGY_EMITTED, TD.Energy.LU), "LLL", "LWL", "CMC", 'M', OP.casingMachine.dat(aMat), 'L', IL.Comp_Laser_Gas_CO2, 'C', OD_CIRCUITS[5], 'W', MT.DATA.CABLES_04[5]);
		
		aClass = MultiTileEntityLaserFlux.class;
		aMat = MT.DATA.Flux_T[1];       aRegistry.add("Flux Laser ("                    +aMat.getLocal()+")", "Lasers"                              , 11101, 10071, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT,  128, NBT_OUTPUT,   16, NBT_WASTE_ENERGY, T, NBT_ENERGY_ACCEPTED, TD.Energy.RF, NBT_ENERGY_EMITTED, TD.Energy.LU), "PPP", "PMP", "PPP", 'M', aRegistry.getItem(10101), 'P', OP.plate.dat(aMat));
		aMat = MT.DATA.Flux_T[2];       aRegistry.add("Flux Laser ("                    +aMat.getLocal()+")", "Lasers"                              , 11102, 10071, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT,  512, NBT_OUTPUT,   64, NBT_WASTE_ENERGY, T, NBT_ENERGY_ACCEPTED, TD.Energy.RF, NBT_ENERGY_EMITTED, TD.Energy.LU), "PPP", "PMP", "PPP", 'M', aRegistry.getItem(10102), 'P', OP.plate.dat(aMat));
		aMat = MT.DATA.Flux_T[3];       aRegistry.add("Flux Laser ("                    +aMat.getLocal()+")", "Lasers"                              , 11103, 10071, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT, 2048, NBT_OUTPUT,  256, NBT_WASTE_ENERGY, T, NBT_ENERGY_ACCEPTED, TD.Energy.RF, NBT_ENERGY_EMITTED, TD.Energy.LU), "PPP", "PMP", "PPP", 'M', aRegistry.getItem(10103), 'P', OP.plate.dat(aMat));
		aMat = MT.DATA.Flux_T[4];       aRegistry.add("Flux Laser ("                    +aMat.getLocal()+")", "Lasers"                              , 11104, 10071, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT, 8192, NBT_OUTPUT, 1024, NBT_WASTE_ENERGY, T, NBT_ENERGY_ACCEPTED, TD.Energy.RF, NBT_ENERGY_EMITTED, TD.Energy.LU), "PPP", "PMP", "PPP", 'M', aRegistry.getItem(10104), 'P', OP.plate.dat(aMat));
		aMat = MT.DATA.Flux_T[5];       aRegistry.add("Flux Laser ("                    +aMat.getLocal()+")", "Lasers"                              , 11105, 10071, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT,32768, NBT_OUTPUT, 4096, NBT_WASTE_ENERGY, T, NBT_ENERGY_ACCEPTED, TD.Energy.RF, NBT_ENERGY_EMITTED, TD.Energy.LU), "PPP", "PMP", "PPP", 'M', aRegistry.getItem(10105), 'P', OP.plate.dat(aMat));
		
		
		// Dynamos
		aClass = MultiTileEntityDynamoElectric.class;
		aMat = MT.DATA.Electric_T[1];   aRegistry.add("Electric Dynamo ("                         +VN[1]+")", "Dynamos"                             , 10111, 10111, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT,   32, NBT_OUTPUT,   22, NBT_WASTE_ENERGY, T, NBT_ENERGY_ACCEPTED, TD.Energy.RU, NBT_ENERGY_EMITTED, TD.Energy.EU), "TGT", "CMC", "TId", 'M', OP.casingMachineDouble.dat(aMat), 'T', OP.screw.dat(aMat), 'G', OP.gearGt.dat(aMat), 'I', OP.stickLong.dat(MT.IronMagnetic     ), 'C', OP.wireGt01.dat(ANY.Cu));
		aMat = MT.DATA.Electric_T[2];   aRegistry.add("Electric Dynamo ("                         +VN[2]+")", "Dynamos"                             , 10112, 10111, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT,  128, NBT_OUTPUT,   88, NBT_WASTE_ENERGY, T, NBT_ENERGY_ACCEPTED, TD.Energy.RU, NBT_ENERGY_EMITTED, TD.Energy.EU), "TGT", "CMC", "TId", 'M', OP.casingMachineDouble.dat(aMat), 'T', OP.screw.dat(aMat), 'G', OP.gearGt.dat(aMat), 'I', OP.stickLong.dat(MT.SteelMagnetic    ), 'C', OP.wireGt02.dat(ANY.Cu));
		aMat = MT.DATA.Electric_T[3];   aRegistry.add("Electric Dynamo ("                         +VN[3]+")", "Dynamos"                             , 10113, 10111, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT,  512, NBT_OUTPUT,  352, NBT_WASTE_ENERGY, T, NBT_ENERGY_ACCEPTED, TD.Energy.RU, NBT_ENERGY_EMITTED, TD.Energy.EU), "TGT", "CMC", "TId", 'M', OP.casingMachineDouble.dat(aMat), 'T', OP.screw.dat(aMat), 'G', OP.gearGt.dat(aMat), 'I', OP.stickLong.dat(MT.SteelMagnetic    ), 'C', OP.wireGt04.dat(MT.AnnealedCopper));
		aMat = MT.DATA.Electric_T[4];   aRegistry.add("Electric Dynamo ("                         +VN[4]+")", "Dynamos"                             , 10114, 10111, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT, 2048, NBT_OUTPUT, 1408, NBT_WASTE_ENERGY, T, NBT_ENERGY_ACCEPTED, TD.Energy.RU, NBT_ENERGY_EMITTED, TD.Energy.EU), "TGT", "CMC", "TId", 'M', OP.casingMachineDouble.dat(aMat), 'T', OP.screw.dat(aMat), 'G', OP.gearGt.dat(aMat), 'I', OP.stickLong.dat(MT.NeodymiumMagnetic), 'C', OP.wireGt08.dat(MT.AnnealedCopper));
		aMat = MT.DATA.Electric_T[5];   aRegistry.add("Electric Dynamo ("                         +VN[5]+")", "Dynamos"                             , 10115, 10111, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT, 8192, NBT_OUTPUT, 5632, NBT_WASTE_ENERGY, T, NBT_ENERGY_ACCEPTED, TD.Energy.RU, NBT_ENERGY_EMITTED, TD.Energy.EU), "TGT", "CMC", "TId", 'M', OP.casingMachineDouble.dat(aMat), 'T', OP.screw.dat(aMat), 'G', OP.gearGt.dat(aMat), 'I', OP.stickLong.dat(MT.NeodymiumMagnetic), 'C', OP.wireGt16.dat(MT.AnnealedCopper));
		
		aClass = MultiTileEntityDynamoFlux.class;
		aMat = MT.DATA.Flux_T[1];       aRegistry.add("Flux Dynamo ("                   +aMat.getLocal()+")", "Dynamos"                             , 11111, 10111, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT,   32, NBT_OUTPUT,   88, NBT_WASTE_ENERGY, T, NBT_ENERGY_ACCEPTED, TD.Energy.RU, NBT_ENERGY_EMITTED, TD.Energy.RF), "SMS", "SGS", 'M', aRegistry.getItem(10111), 'G', OP.gearGt.dat(aMat), 'S', OP.stickLong.dat(aMat));
		aMat = MT.DATA.Flux_T[2];       aRegistry.add("Flux Dynamo ("                   +aMat.getLocal()+")", "Dynamos"                             , 11112, 10111, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT,  128, NBT_OUTPUT,  352, NBT_WASTE_ENERGY, T, NBT_ENERGY_ACCEPTED, TD.Energy.RU, NBT_ENERGY_EMITTED, TD.Energy.RF), "SMS", "SGS", 'M', aRegistry.getItem(10112), 'G', OP.gearGt.dat(aMat), 'S', OP.stickLong.dat(aMat));
		aMat = MT.DATA.Flux_T[3];       aRegistry.add("Flux Dynamo ("                   +aMat.getLocal()+")", "Dynamos"                             , 11113, 10111, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT,  512, NBT_OUTPUT, 1408, NBT_WASTE_ENERGY, T, NBT_ENERGY_ACCEPTED, TD.Energy.RU, NBT_ENERGY_EMITTED, TD.Energy.RF), "SMS", "SGS", 'M', aRegistry.getItem(10113), 'G', OP.gearGt.dat(aMat), 'S', OP.stickLong.dat(aMat));
		aMat = MT.DATA.Flux_T[4];       aRegistry.add("Flux Dynamo ("                   +aMat.getLocal()+")", "Dynamos"                             , 11114, 10111, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT, 2048, NBT_OUTPUT, 5632, NBT_WASTE_ENERGY, T, NBT_ENERGY_ACCEPTED, TD.Energy.RU, NBT_ENERGY_EMITTED, TD.Energy.RF), "SMS", "SGS", 'M', aRegistry.getItem(10114), 'G', OP.gearGt.dat(aMat), 'S', OP.stickLong.dat(aMat));
		aMat = MT.DATA.Flux_T[5];       aRegistry.add("Flux Dynamo ("                   +aMat.getLocal()+")", "Dynamos"                             , 11115, 10111, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT, 8192, NBT_OUTPUT,22528, NBT_WASTE_ENERGY, T, NBT_ENERGY_ACCEPTED, TD.Energy.RU, NBT_ENERGY_EMITTED, TD.Energy.RF), "SMS", "SGS", 'M', aRegistry.getItem(10115), 'G', OP.gearGt.dat(aMat), 'S', OP.stickLong.dat(aMat));
		
		
		// Quantum Energizers
		aClass = MultiTileEntityQuantumEnergizerLaser.class;
		aMat = MT.Osmiridium;           aRegistry.add("Quantum Energizer (T1)"                              , "Quantum Energizers"                  , 10121, 10121, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,  16.0F, NBT_RESISTANCE,  16.0F, NBT_INPUT,   32, NBT_OUTPUT,   16, NBT_WASTE_ENERGY, T, NBT_ENERGY_ACCEPTED, TD.Energy.LU, NBT_ENERGY_EMITTED, TD.Energy.QU), "CFC", "SME", "CFC", 'M', OP.casingMachine.dat(aMat), 'F', IL.FIELD_GENERATORS[1], 'S', IL.SENSORS[1], 'E', IL.EMITTERS[1], 'C', IL.Processor_Crystal_Sapphire);
		aMat = MT.Osmiridium;           aRegistry.add("Quantum Energizer (T2)"                              , "Quantum Energizers"                  , 10122, 10121, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,  16.0F, NBT_RESISTANCE,  16.0F, NBT_INPUT,  128, NBT_OUTPUT,   64, NBT_WASTE_ENERGY, T, NBT_ENERGY_ACCEPTED, TD.Energy.LU, NBT_ENERGY_EMITTED, TD.Energy.QU), "CFC", "SME", "CFC", 'M', OP.casingMachine.dat(aMat), 'F', IL.FIELD_GENERATORS[2], 'S', IL.SENSORS[2], 'E', IL.EMITTERS[2], 'C', IL.Processor_Crystal_Sapphire);
		aMat = MT.Osmiridium;           aRegistry.add("Quantum Energizer (T3)"                              , "Quantum Energizers"                  , 10123, 10121, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,  16.0F, NBT_RESISTANCE,  16.0F, NBT_INPUT,  512, NBT_OUTPUT,  256, NBT_WASTE_ENERGY, T, NBT_ENERGY_ACCEPTED, TD.Energy.LU, NBT_ENERGY_EMITTED, TD.Energy.QU), "CFC", "SME", "CFC", 'M', OP.casingMachine.dat(aMat), 'F', IL.FIELD_GENERATORS[3], 'S', IL.SENSORS[3], 'E', IL.EMITTERS[3], 'C', IL.Processor_Crystal_Sapphire);
		aMat = MT.Osmiridium;           aRegistry.add("Quantum Energizer (T4)"                              , "Quantum Energizers"                  , 10124, 10121, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,  16.0F, NBT_RESISTANCE,  16.0F, NBT_INPUT, 2048, NBT_OUTPUT, 1024, NBT_WASTE_ENERGY, T, NBT_ENERGY_ACCEPTED, TD.Energy.LU, NBT_ENERGY_EMITTED, TD.Energy.QU), "CFC", "SME", "CFC", 'M', OP.casingMachine.dat(aMat), 'F', IL.FIELD_GENERATORS[4], 'S', IL.SENSORS[4], 'E', IL.EMITTERS[4], 'C', IL.Processor_Crystal_Sapphire);
		aMat = MT.Osmiridium;           aRegistry.add("Quantum Energizer (T5)"                              , "Quantum Energizers"                  , 10125, 10121, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,  16.0F, NBT_RESISTANCE,  16.0F, NBT_INPUT, 8192, NBT_OUTPUT, 4096, NBT_WASTE_ENERGY, T, NBT_ENERGY_ACCEPTED, TD.Energy.LU, NBT_ENERGY_EMITTED, TD.Energy.QU), "CFC", "SME", "CFC", 'M', OP.casingMachine.dat(aMat), 'F', IL.FIELD_GENERATORS[5], 'S', IL.SENSORS[5], 'E', IL.EMITTERS[5], 'C', IL.Processor_Crystal_Sapphire);
		
		// Crystal Chargers
		for (int i = 0; i < 10; i++) {
			aRegistry.add("Crystal Charger (T"      +i+")", "Crystal Chargers", 10130+i, 10131, MultiTileEntityCrystalCharger     .class, MT.DATA.Electric_T[i].mToolQuality, 16, aMachine, UT.NBT.make(NBT_MATERIAL, MT.DATA.Electric_T[i], NBT_HARDNESS, 4.0F, NBT_RESISTANCE, 4.0F, NBT_INPUT, V[i], NBT_OUTPUT, V[i], NBT_ENERGY_EMITTED, TD.Energy.LU, NBT_INV_SIZE,  4), "FCF", "FCF", "PMP", 'C', OD_CIRCUITS[i], 'P', IL.Processor_Crystal_Emerald, 'F', IL.FIELD_GENERATORS[i], 'M', OP.casingMachine.dat(MT.DATA.Electric_T[i]));
			aRegistry.add("Large Crystal Charger (T"+i+")", "Crystal Chargers", 10140+i, 10131, MultiTileEntityCrystalChargerLarge.class, MT.DATA.Electric_T[i].mToolQuality, 16, aMachine, UT.NBT.make(NBT_MATERIAL, MT.DATA.Electric_T[i], NBT_HARDNESS, 4.0F, NBT_RESISTANCE, 4.0F, NBT_INPUT, V[i], NBT_OUTPUT, V[i], NBT_ENERGY_EMITTED, TD.Energy.LU, NBT_INV_SIZE, 16), "FCF", "FCF", "PMP", 'C', OD_CIRCUITS[i], 'P', IL.Processor_Crystal_Emerald, 'F', IL.FIELD_GENERATORS[i], 'M', aRegistry.getItem(10130+i));
		}
		
		// Laser Absorbers
		aClass = MultiTileEntityLaserAbsorberElectric.class;
		aMat = MT.DATA.Electric_T[1];   aRegistry.add("Laser Absorber ("                          +VN[1]+")", "Laser Absorbers"                     , 10151, 10151, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT,   32, NBT_OUTPUT,   16, NBT_WASTE_ENERGY, T, NBT_ENERGY_ACCEPTED, TD.Energy.LU, NBT_ENERGY_EMITTED, TD.Energy.EU), "SCW", "SMP", "SCW", 'M', OP.casingMachine.dat(aMat), 'S', OP.plateGem.dat(ANY.Si), 'W', MT.DATA.CABLES_01[1], 'C', OD_CIRCUITS[2], 'P', IL.Processor_Crystal_Sapphire);
		aMat = MT.DATA.Electric_T[2];   aRegistry.add("Laser Absorber ("                          +VN[2]+")", "Laser Absorbers"                     , 10152, 10151, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT,  128, NBT_OUTPUT,   64, NBT_WASTE_ENERGY, T, NBT_ENERGY_ACCEPTED, TD.Energy.LU, NBT_ENERGY_EMITTED, TD.Energy.EU), "SCW", "SMP", "SCW", 'M', OP.casingMachine.dat(aMat), 'S', OP.plateGem.dat(ANY.Si), 'W', MT.DATA.CABLES_01[2], 'C', OD_CIRCUITS[3], 'P', IL.Processor_Crystal_Sapphire);
		aMat = MT.DATA.Electric_T[3];   aRegistry.add("Laser Absorber ("                          +VN[3]+")", "Laser Absorbers"                     , 10153, 10151, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT,  512, NBT_OUTPUT,  256, NBT_WASTE_ENERGY, T, NBT_ENERGY_ACCEPTED, TD.Energy.LU, NBT_ENERGY_EMITTED, TD.Energy.EU), "SCW", "SMP", "SCW", 'M', OP.casingMachine.dat(aMat), 'S', OP.plateGem.dat(ANY.Si), 'W', MT.DATA.CABLES_01[3], 'C', OD_CIRCUITS[4], 'P', IL.Processor_Crystal_Sapphire);
		aMat = MT.DATA.Electric_T[4];   aRegistry.add("Laser Absorber ("                          +VN[4]+")", "Laser Absorbers"                     , 10154, 10151, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT, 2048, NBT_OUTPUT, 1024, NBT_WASTE_ENERGY, T, NBT_ENERGY_ACCEPTED, TD.Energy.LU, NBT_ENERGY_EMITTED, TD.Energy.EU), "SCW", "SMP", "SCW", 'M', OP.casingMachine.dat(aMat), 'S', OP.plateGem.dat(ANY.Si), 'W', MT.DATA.CABLES_01[4], 'C', OD_CIRCUITS[5], 'P', IL.Processor_Crystal_Sapphire);
		aMat = MT.DATA.Electric_T[5];   aRegistry.add("Laser Absorber ("                          +VN[5]+")", "Laser Absorbers"                     , 10155, 10151, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT, 8192, NBT_OUTPUT, 4096, NBT_WASTE_ENERGY, T, NBT_ENERGY_ACCEPTED, TD.Energy.LU, NBT_ENERGY_EMITTED, TD.Energy.EU), "SCW", "SMP", "SCW", 'M', OP.casingMachine.dat(aMat), 'S', OP.plateGem.dat(ANY.Si), 'W', MT.DATA.CABLES_01[5], 'C', OD_CIRCUITS[6], 'P', IL.Processor_Crystal_Sapphire);
		
		
		// Coolers
		aClass = MultiTileEntityCoolerElectric.class;
		aMat = MT.DATA.Electric_T[1];   aRegistry.add("Thermoelectric Cooler ("                   +VN[1]+")", "Coolers"                             , 10161, 10161, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT,   32, NBT_OUTPUT,    8, NBT_WASTE_ENERGY, T, NBT_ENERGY_ACCEPTED, TD.Energy.EU, NBT_ENERGY_EMITTED, TD.Energy.CU, NBT_ENERGY_EMITTED_2, TD.Energy.HU), "WPw", "CMC", "xPW", 'M', OP.casingMachine.dat(aMat), 'W', MT.DATA.CABLES_01[1], 'P', OP.plate           .dat(MT.Si), 'C', OP.plate          .dat(ANY.Cu));
		aMat = MT.DATA.Electric_T[2];   aRegistry.add("Thermoelectric Cooler ("                   +VN[2]+")", "Coolers"                             , 10162, 10161, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT,  128, NBT_OUTPUT,   32, NBT_WASTE_ENERGY, T, NBT_ENERGY_ACCEPTED, TD.Energy.EU, NBT_ENERGY_EMITTED, TD.Energy.CU, NBT_ENERGY_EMITTED_2, TD.Energy.HU), "WPw", "CMC", "xPW", 'M', OP.casingMachine.dat(aMat), 'W', MT.DATA.CABLES_01[2], 'P', OP.plateDouble     .dat(MT.Si), 'C', OP.plateDouble    .dat(ANY.Cu));
		aMat = MT.DATA.Electric_T[3];   aRegistry.add("Thermoelectric Cooler ("                   +VN[3]+")", "Coolers"                             , 10163, 10161, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT,  512, NBT_OUTPUT,  128, NBT_WASTE_ENERGY, T, NBT_ENERGY_ACCEPTED, TD.Energy.EU, NBT_ENERGY_EMITTED, TD.Energy.CU, NBT_ENERGY_EMITTED_2, TD.Energy.HU), "WPw", "CMC", "xPW", 'M', OP.casingMachine.dat(aMat), 'W', MT.DATA.CABLES_01[3], 'P', OP.plateTriple     .dat(MT.Si), 'C', OP.plateTriple    .dat(ANY.Cu));
		aMat = MT.DATA.Electric_T[4];   aRegistry.add("Thermoelectric Cooler ("                   +VN[4]+")", "Coolers"                             , 10164, 10161, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT, 2048, NBT_OUTPUT,  512, NBT_WASTE_ENERGY, T, NBT_ENERGY_ACCEPTED, TD.Energy.EU, NBT_ENERGY_EMITTED, TD.Energy.CU, NBT_ENERGY_EMITTED_2, TD.Energy.HU), "WPw", "CMC", "xPW", 'M', OP.casingMachine.dat(aMat), 'W', MT.DATA.CABLES_01[4], 'P', OP.plateQuadruple  .dat(MT.Si), 'C', OP.plateQuadruple .dat(ANY.Cu));
		aMat = MT.DATA.Electric_T[5];   aRegistry.add("Thermoelectric Cooler ("                   +VN[5]+")", "Coolers"                             , 10165, 10161, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT, 8192, NBT_OUTPUT, 2048, NBT_WASTE_ENERGY, T, NBT_ENERGY_ACCEPTED, TD.Energy.EU, NBT_ENERGY_EMITTED, TD.Energy.CU, NBT_ENERGY_EMITTED_2, TD.Energy.HU), "WPw", "CMC", "xPW", 'M', OP.casingMachine.dat(aMat), 'W', MT.DATA.CABLES_01[5], 'P', OP.plateQuintuple  .dat(MT.Si), 'C', OP.plateQuintuple .dat(ANY.Cu));
		
		aClass = MultiTileEntityCoolerFlux.class;
		aMat = MT.DATA.Flux_T[1];       aRegistry.add("Thermofluxic Cooler ("           +aMat.getLocal()+")", "Coolers"                             , 11161, 10161, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT,  128, NBT_OUTPUT,    8, NBT_WASTE_ENERGY, T, NBT_ENERGY_ACCEPTED, TD.Energy.RF, NBT_ENERGY_EMITTED, TD.Energy.CU, NBT_ENERGY_EMITTED_2, TD.Energy.HU), "PSP", "PMP", "PSP", 'M', aRegistry.getItem(10161), 'P', OP.plate.dat(aMat), 'S', OP.stickLong.dat(aMat));
		aMat = MT.DATA.Flux_T[2];       aRegistry.add("Thermofluxic Cooler ("           +aMat.getLocal()+")", "Coolers"                             , 11162, 10161, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT,  512, NBT_OUTPUT,   32, NBT_WASTE_ENERGY, T, NBT_ENERGY_ACCEPTED, TD.Energy.RF, NBT_ENERGY_EMITTED, TD.Energy.CU, NBT_ENERGY_EMITTED_2, TD.Energy.HU), "PSP", "PMP", "PSP", 'M', aRegistry.getItem(10162), 'P', OP.plate.dat(aMat), 'S', OP.stickLong.dat(aMat));
		aMat = MT.DATA.Flux_T[3];       aRegistry.add("Thermofluxic Cooler ("           +aMat.getLocal()+")", "Coolers"                             , 11163, 10161, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT, 2048, NBT_OUTPUT,  128, NBT_WASTE_ENERGY, T, NBT_ENERGY_ACCEPTED, TD.Energy.RF, NBT_ENERGY_EMITTED, TD.Energy.CU, NBT_ENERGY_EMITTED_2, TD.Energy.HU), "PSP", "PMP", "PSP", 'M', aRegistry.getItem(10163), 'P', OP.plate.dat(aMat), 'S', OP.stickLong.dat(aMat));
		aMat = MT.DATA.Flux_T[4];       aRegistry.add("Thermofluxic Cooler ("           +aMat.getLocal()+")", "Coolers"                             , 11164, 10161, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT, 8192, NBT_OUTPUT,  512, NBT_WASTE_ENERGY, T, NBT_ENERGY_ACCEPTED, TD.Energy.RF, NBT_ENERGY_EMITTED, TD.Energy.CU, NBT_ENERGY_EMITTED_2, TD.Energy.HU), "PSP", "PMP", "PSP", 'M', aRegistry.getItem(10164), 'P', OP.plate.dat(aMat), 'S', OP.stickLong.dat(aMat));
		aMat = MT.DATA.Flux_T[5];       aRegistry.add("Thermofluxic Cooler ("           +aMat.getLocal()+")", "Coolers"                             , 11165, 10161, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT,32768, NBT_OUTPUT, 2048, NBT_WASTE_ENERGY, T, NBT_ENERGY_ACCEPTED, TD.Energy.RF, NBT_ENERGY_EMITTED, TD.Energy.CU, NBT_ENERGY_EMITTED_2, TD.Energy.HU), "PSP", "PMP", "PSP", 'M', aRegistry.getItem(10165), 'P', OP.plate.dat(aMat), 'S', OP.stickLong.dat(aMat));
		
		
		// ZPM Dechargers
		aMat = MT.Osmiridium;           aRegistry.add("ZPM Decharger (Quantum)"                             , "ZPM"                                 , 11170, 14999, MultiTileEntityZPMDechargerQU.class, aMat.mToolQuality, 16, aMachine, UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS, 4.0F, NBT_RESISTANCE, 50.0F, NBT_INPUT, V[7], NBT_OUTPUT, V[7], NBT_ENERGY_ACCEPTED, TD.Energy.QU, NBT_ENERGY_EMITTED, TD.Energy.QU, NBT_INV_SIZE, 1), "PCP", "CMC", "FCF", 'C', OD_CIRCUITS[6], 'P', IL.Processor_Crystal_Ruby    , 'F', IL.FIELD_GENERATORS[6], 'M', OP.casingMachineDense.dat(aMat));
		aMat = MT.Osmiridium;           aRegistry.add("ZPM Decharger (Electric)"                            , "ZPM"                                 , 11171, 14999, MultiTileEntityZPMDechargerEU.class, aMat.mToolQuality, 16, aMachine, UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS, 4.0F, NBT_RESISTANCE, 50.0F, NBT_INPUT, V[7], NBT_OUTPUT, V[7], NBT_ENERGY_ACCEPTED, TD.Energy.QU, NBT_ENERGY_EMITTED, TD.Energy.EU, NBT_INV_SIZE, 1), "PCP", "CMC", "FCF", 'C', OD_CIRCUITS[6], 'P', IL.Processor_Crystal_Sapphire, 'F', IL.FIELD_GENERATORS[6], 'M', OP.casingMachineDense.dat(aMat));
		
		
		// Magical Energy Production Stuffs
		aMat = MT.Pd;                   aRegistry.add("Magic Field Absorber"                                , "Magical Energy Production"           , 10180, 10180, MultiTileEntityMagicFieldAbsorber.class, aMat.mToolQuality, 16, aMachine, UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS, 4.0F, NBT_RESISTANCE, 4.0F), "GOG", "LBL", "CMC", 'M', OP.casingMachine.dat(aMat), 'C', IL.Circuit_Magic, 'G', OP.wireFine.dat(MT.Au), 'O', OP.plate.dat(MT.Obsidian), 'L', OP.gem.dat(MT.Lapis), 'B', Blocks.beacon);
		
		
		// Batteries
		IL.Battery_Lead_Acid_ULV        .set(aRegistry.add("Lead-Acid Battery ("+VN[0]+")"                  , "Batteries"                           , 14000, 14013, MultiTileEntityBatteryEU8    .class, 0, 16, aUtilMetal , UT.NBT.make(NBT_HARDNESS,   0.5F, NBT_RESISTANCE,   3.0F, NBT_COLOR, DYES_INT[DYE_INDEX_Orange]                     , NBT_INPUT, V[0], NBT_CAPACITY, V[0] *   2000, NBT_ENERGY_ACCEPTED, TD.Energy.EU), "Wx" , "B " , "P " , 'P', OP.plate.dat(MT.BatteryAlloy), 'B', IL.Battery_Lead_Acid_Cell_Filled, 'W', MT.DATA.CABLES_01[0]), null, "gt:re-battery0");
		IL.Battery_Lead_Acid_LV         .set(aRegistry.add("Lead-Acid Battery ("                  +VN[1]+")", "Batteries"                           , 14001, 14013, MultiTileEntityBatteryEU32   .class, 0, 16, aUtilMetal , UT.NBT.make(NBT_HARDNESS,   0.5F, NBT_RESISTANCE,   3.0F, NBT_COLOR, DYES_INT[DYE_INDEX_Orange]                     , NBT_INPUT, V[1], NBT_CAPACITY, V[1] *   2000, NBT_ENERGY_ACCEPTED, TD.Energy.EU), " Wx", "PBP", " B ", 'P', OP.plate.dat(MT.BatteryAlloy), 'B', IL.Battery_Lead_Acid_Cell_Filled, 'W', MT.DATA.CABLES_01[1]), null, "gt:re-battery1");
		IL.Battery_Lead_Acid_MV         .set(aRegistry.add("Lead-Acid Battery ("                  +VN[2]+")", "Batteries"                           , 14002, 14013, MultiTileEntityBatteryEU128  .class, 0, 16, aUtilMetal , UT.NBT.make(NBT_HARDNESS,   0.5F, NBT_RESISTANCE,   3.0F, NBT_COLOR, DYES_INT[DYE_INDEX_Orange]                     , NBT_INPUT, V[2], NBT_CAPACITY, V[2] *   2000, NBT_ENERGY_ACCEPTED, TD.Energy.EU), "WxW", "BCB", "PBP", 'P', OP.plate.dat(MT.BatteryAlloy), 'B', IL.Battery_Lead_Acid_Cell_Filled, 'W', MT.DATA.CABLES_01[2], 'C', OD_CIRCUITS[2]), null, "gt:re-battery2");
		IL.Battery_Lead_Acid_HV         .set(aRegistry.add("Lead-Acid Battery ("                  +VN[3]+")", "Batteries"                           , 14003, 14013, MultiTileEntityBatteryEU512  .class, 0, 16, aUtilMetal , UT.NBT.make(NBT_HARDNESS,   0.5F, NBT_RESISTANCE,   3.0F, NBT_COLOR, DYES_INT[DYE_INDEX_Orange]                     , NBT_INPUT, V[3], NBT_CAPACITY, V[3] *   2000, NBT_ENERGY_ACCEPTED, TD.Energy.EU), "WxW", "BCB", "BPB", 'P', OP.plate.dat(MT.BatteryAlloy), 'B', IL.Battery_Lead_Acid_Cell_Filled, 'W', MT.DATA.CABLES_01[3], 'C', OD_CIRCUITS[3]), null, "gt:re-battery3");
		IL.Battery_Lead_Acid_EV         .set(aRegistry.add("Lead-Acid Battery ("                  +VN[4]+")", "Batteries"                           , 14004, 14013, MultiTileEntityBatteryEU2048 .class, 0, 16, aUtilMetal , UT.NBT.make(NBT_HARDNESS,   0.5F, NBT_RESISTANCE,   3.0F, NBT_COLOR, DYES_INT[DYE_INDEX_Orange]                     , NBT_INPUT, V[4], NBT_CAPACITY, V[4] *   2000, NBT_ENERGY_ACCEPTED, TD.Energy.EU), "WPW", "BCB", "BBB", 'P', OP.plate.dat(MT.BatteryAlloy), 'B', IL.Battery_Lead_Acid_Cell_Filled, 'W', MT.DATA.CABLES_01[4], 'C', OD_CIRCUITS[4]), null, "gt:re-battery4");
		
		IL.Battery_SU_LV_SulfuricAcid.set(IL.Battery_Lead_Acid_LV.get(1));
		IL.Battery_SU_MV_SulfuricAcid.set(IL.Battery_Lead_Acid_MV.get(1));
		IL.Battery_SU_HV_SulfuricAcid.set(IL.Battery_Lead_Acid_HV.get(1));
		
		// Just to populate those Fields with something for Compat with outdated Addons.
		IL.Battery_RE_LV_Redstone.set(IL.Battery_Lead_Acid_LV.get(1));
		IL.Battery_RE_MV_Redstone.set(IL.Battery_Lead_Acid_MV.get(1));
		IL.Battery_RE_HV_Redstone.set(IL.Battery_Lead_Acid_HV.get(1));
		IL.Battery_RE_LV_Nikolite.set(IL.Battery_Lead_Acid_LV.get(1));
		IL.Battery_RE_MV_Nikolite.set(IL.Battery_Lead_Acid_MV.get(1));
		IL.Battery_RE_HV_Nikolite.set(IL.Battery_Lead_Acid_HV.get(1));
		IL.Battery_RE_LV_Teslatite.set(IL.Battery_Lead_Acid_LV.get(1));
		IL.Battery_RE_MV_Teslatite.set(IL.Battery_Lead_Acid_MV.get(1));
		IL.Battery_RE_HV_Teslatite.set(IL.Battery_Lead_Acid_HV.get(1));
		IL.Battery_RE_LV_Electrotine.set(IL.Battery_Lead_Acid_LV.get(1));
		IL.Battery_RE_MV_Electrotine.set(IL.Battery_Lead_Acid_MV.get(1));
		IL.Battery_RE_HV_Electrotine.set(IL.Battery_Lead_Acid_HV.get(1));
		
		IL.Battery_Alkaline_ULV         .set(aRegistry.add("Alkaline Battery ("+VN[0]+")"                   , "Batteries"                           , 14010, 14013, MultiTileEntityBatteryEU8   .class      , 0, 16, aUtilMetal , UT.NBT.make(NBT_HARDNESS,   0.5F, NBT_RESISTANCE,   3.0F, NBT_COLOR, DYES_INT[DYE_INDEX_Blue]                       , NBT_INPUT, V[0], NBT_CAPACITY, V[0] *   4000, NBT_ENERGY_ACCEPTED, TD.Energy.EU), "Wx" , "B " , "P " , 'P', OP.plate.dat(MT.BatteryAlloy), 'B', IL.Battery_Alkaline_Cell_Filled, 'W', MT.DATA.CABLES_01[0]), null, "gt:re-battery0");
		IL.Battery_Alkaline_LV          .set(aRegistry.add("Alkaline Battery ("                   +VN[1]+")", "Batteries"                           , 14011, 14013, MultiTileEntityBatteryEU32  .class      , 0, 16, aUtilMetal , UT.NBT.make(NBT_HARDNESS,   0.5F, NBT_RESISTANCE,   3.0F, NBT_COLOR, DYES_INT[DYE_INDEX_Blue]                       , NBT_INPUT, V[1], NBT_CAPACITY, V[1] *   4000, NBT_ENERGY_ACCEPTED, TD.Energy.EU), " Wx", "PBP", " B ", 'P', OP.plate.dat(MT.BatteryAlloy), 'B', IL.Battery_Alkaline_Cell_Filled, 'W', MT.DATA.CABLES_01[1]), null, "gt:re-battery1");
		IL.Battery_Alkaline_MV          .set(aRegistry.add("Alkaline Battery ("                   +VN[2]+")", "Batteries"                           , 14012, 14013, MultiTileEntityBatteryEU128 .class      , 0, 16, aUtilMetal , UT.NBT.make(NBT_HARDNESS,   0.5F, NBT_RESISTANCE,   3.0F, NBT_COLOR, DYES_INT[DYE_INDEX_Blue]                       , NBT_INPUT, V[2], NBT_CAPACITY, V[2] *   4000, NBT_ENERGY_ACCEPTED, TD.Energy.EU), "WxW", "BCB", "PBP", 'P', OP.plate.dat(MT.BatteryAlloy), 'B', IL.Battery_Alkaline_Cell_Filled, 'W', MT.DATA.CABLES_01[2], 'C', OD_CIRCUITS[2]), null, "gt:re-battery2");
		IL.Battery_Alkaline_HV          .set(aRegistry.add("Alkaline Battery ("                   +VN[3]+")", "Batteries"                           , 14013, 14013, MultiTileEntityBatteryEU512 .class      , 0, 16, aUtilMetal , UT.NBT.make(NBT_HARDNESS,   0.5F, NBT_RESISTANCE,   3.0F, NBT_COLOR, DYES_INT[DYE_INDEX_Blue]                       , NBT_INPUT, V[3], NBT_CAPACITY, V[3] *   4000, NBT_ENERGY_ACCEPTED, TD.Energy.EU), "WxW", "BCB", "BPB", 'P', OP.plate.dat(MT.BatteryAlloy), 'B', IL.Battery_Alkaline_Cell_Filled, 'W', MT.DATA.CABLES_01[3], 'C', OD_CIRCUITS[3]), null, "gt:re-battery3");
		IL.Battery_Alkaline_EV          .set(aRegistry.add("Alkaline Battery ("                   +VN[4]+")", "Batteries"                           , 14014, 14013, MultiTileEntityBatteryEU2048.class      , 0, 16, aUtilMetal , UT.NBT.make(NBT_HARDNESS,   0.5F, NBT_RESISTANCE,   3.0F, NBT_COLOR, DYES_INT[DYE_INDEX_Blue]                       , NBT_INPUT, V[4], NBT_CAPACITY, V[4] *   4000, NBT_ENERGY_ACCEPTED, TD.Energy.EU), "WPW", "BCB", "BBB", 'P', OP.plate.dat(MT.BatteryAlloy), 'B', IL.Battery_Alkaline_Cell_Filled, 'W', MT.DATA.CABLES_01[4], 'C', OD_CIRCUITS[4]), null, "gt:re-battery4");
		
		// Just to populate those Fields with something for Compat with outdated Addons.
		IL.Battery_SU_LV_Mercury.set(IL.Battery_Alkaline_LV.get(1));
		IL.Battery_SU_MV_Mercury.set(IL.Battery_Alkaline_MV.get(1));
		IL.Battery_SU_HV_Mercury.set(IL.Battery_Alkaline_HV.get(1));
		
		IL.Battery_NiCd_ULV             .set(aRegistry.add("Nickel-Cadmium Battery ("+VN[0]+")"             , "Batteries"                           , 14020, 14013, MultiTileEntityBatteryEU8   .class      , 0, 16, aUtilMetal , UT.NBT.make(NBT_HARDNESS,   0.5F, NBT_RESISTANCE,   3.0F, NBT_COLOR, DYES_INT[DYE_INDEX_Lime]                       , NBT_INPUT, V[0], NBT_CAPACITY, V[0] *   4000, NBT_ENERGY_ACCEPTED, TD.Energy.EU), "Wx" , "B " , "P " , 'P', OP.plate.dat(MT.BatteryAlloy), 'B', IL.Battery_NiCd_Cell_Filled, 'W', MT.DATA.CABLES_01[0]), null, "gt:re-battery0");
		IL.Battery_NiCd_LV              .set(aRegistry.add("Nickel-Cadmium Battery ("             +VN[1]+")", "Batteries"                           , 14021, 14013, MultiTileEntityBatteryEU32  .class      , 0, 16, aUtilMetal , UT.NBT.make(NBT_HARDNESS,   0.5F, NBT_RESISTANCE,   3.0F, NBT_COLOR, DYES_INT[DYE_INDEX_Lime]                       , NBT_INPUT, V[1], NBT_CAPACITY, V[1] *   4000, NBT_ENERGY_ACCEPTED, TD.Energy.EU), " Wx", "PBP", " B ", 'P', OP.plate.dat(MT.BatteryAlloy), 'B', IL.Battery_NiCd_Cell_Filled, 'W', MT.DATA.CABLES_01[1]), null, "gt:re-battery1");
		IL.Battery_NiCd_MV              .set(aRegistry.add("Nickel-Cadmium Battery ("             +VN[2]+")", "Batteries"                           , 14022, 14013, MultiTileEntityBatteryEU128 .class      , 0, 16, aUtilMetal , UT.NBT.make(NBT_HARDNESS,   0.5F, NBT_RESISTANCE,   3.0F, NBT_COLOR, DYES_INT[DYE_INDEX_Lime]                       , NBT_INPUT, V[2], NBT_CAPACITY, V[2] *   4000, NBT_ENERGY_ACCEPTED, TD.Energy.EU), "WxW", "BCB", "PBP", 'P', OP.plate.dat(MT.BatteryAlloy), 'B', IL.Battery_NiCd_Cell_Filled, 'W', MT.DATA.CABLES_01[2], 'C', OD_CIRCUITS[2]), null, "gt:re-battery2");
		IL.Battery_NiCd_HV              .set(aRegistry.add("Nickel-Cadmium Battery ("             +VN[3]+")", "Batteries"                           , 14023, 14013, MultiTileEntityBatteryEU512 .class      , 0, 16, aUtilMetal , UT.NBT.make(NBT_HARDNESS,   0.5F, NBT_RESISTANCE,   3.0F, NBT_COLOR, DYES_INT[DYE_INDEX_Lime]                       , NBT_INPUT, V[3], NBT_CAPACITY, V[3] *   4000, NBT_ENERGY_ACCEPTED, TD.Energy.EU), "WxW", "BCB", "BPB", 'P', OP.plate.dat(MT.BatteryAlloy), 'B', IL.Battery_NiCd_Cell_Filled, 'W', MT.DATA.CABLES_01[3], 'C', OD_CIRCUITS[3]), null, "gt:re-battery3");
		IL.Battery_NiCd_EV              .set(aRegistry.add("Nickel-Cadmium Battery ("             +VN[4]+")", "Batteries"                           , 14024, 14013, MultiTileEntityBatteryEU2048.class      , 0, 16, aUtilMetal , UT.NBT.make(NBT_HARDNESS,   0.5F, NBT_RESISTANCE,   3.0F, NBT_COLOR, DYES_INT[DYE_INDEX_Lime]                       , NBT_INPUT, V[4], NBT_CAPACITY, V[4] *   4000, NBT_ENERGY_ACCEPTED, TD.Energy.EU), "WPW", "BCB", "BBB", 'P', OP.plate.dat(MT.BatteryAlloy), 'B', IL.Battery_NiCd_Cell_Filled, 'W', MT.DATA.CABLES_01[4], 'C', OD_CIRCUITS[4]), null, "gt:re-battery4");
		
		IL.Battery_RE_LV_Cadmium.set(IL.Battery_NiCd_LV.get(1));
		IL.Battery_RE_MV_Cadmium.set(IL.Battery_NiCd_MV.get(1));
		IL.Battery_RE_HV_Cadmium.set(IL.Battery_NiCd_HV.get(1));
		
		IL.Battery_LiCoO2_ULV           .set(aRegistry.add("Lithium-Cobalt Battery ("+VN[0]+")"             , "Batteries"                           , 14030, 14013, MultiTileEntityBatteryAdvEU8   .class   , 0, 16, aUtilMetal , UT.NBT.make(NBT_HARDNESS,   0.5F, NBT_RESISTANCE,   3.0F, NBT_COLOR, DYES_INT[DYE_INDEX_Blue]                       , NBT_INPUT, V[0], NBT_CAPACITY, V[0] *  64000, NBT_ENERGY_ACCEPTED, TD.Energy.EU), "Wx" , "BC" , "P " , 'P', OP.plate.dat(MT.BatteryAlloy), 'B', IL.Battery_LiCoO2_Cell_Filled, 'W', MT.DATA.CABLES_01[0], 'C', OD_CIRCUITS[2]), null, "gt:re-battery0");
		IL.Battery_LiCoO2_LV            .set(aRegistry.add("Lithium-Cobalt Battery ("             +VN[1]+")", "Batteries"                           , 14031, 14013, MultiTileEntityBatteryAdvEU32  .class   , 0, 16, aUtilMetal , UT.NBT.make(NBT_HARDNESS,   0.5F, NBT_RESISTANCE,   3.0F, NBT_COLOR, DYES_INT[DYE_INDEX_Blue]                       , NBT_INPUT, V[1], NBT_CAPACITY, V[1] *  64000, NBT_ENERGY_ACCEPTED, TD.Energy.EU), "CWx", "PBP", " B ", 'P', OP.plate.dat(MT.BatteryAlloy), 'B', IL.Battery_LiCoO2_Cell_Filled, 'W', MT.DATA.CABLES_01[1], 'C', OD_CIRCUITS[3]), null, "gt:re-battery1");
		IL.Battery_LiCoO2_MV            .set(aRegistry.add("Lithium-Cobalt Battery ("             +VN[2]+")", "Batteries"                           , 14032, 14013, MultiTileEntityBatteryAdvEU128 .class   , 0, 16, aUtilMetal , UT.NBT.make(NBT_HARDNESS,   0.5F, NBT_RESISTANCE,   3.0F, NBT_COLOR, DYES_INT[DYE_INDEX_Blue]                       , NBT_INPUT, V[2], NBT_CAPACITY, V[2] *  64000, NBT_ENERGY_ACCEPTED, TD.Energy.EU), "WxW", "BCB", "PBP", 'P', OP.plate.dat(MT.BatteryAlloy), 'B', IL.Battery_LiCoO2_Cell_Filled, 'W', MT.DATA.CABLES_01[2], 'C', OD_CIRCUITS[4]), null, "gt:re-battery2");
		IL.Battery_LiCoO2_HV            .set(aRegistry.add("Lithium-Cobalt Battery ("             +VN[3]+")", "Batteries"                           , 14033, 14013, MultiTileEntityBatteryAdvEU512 .class   , 0, 16, aUtilMetal , UT.NBT.make(NBT_HARDNESS,   0.5F, NBT_RESISTANCE,   3.0F, NBT_COLOR, DYES_INT[DYE_INDEX_Blue]                       , NBT_INPUT, V[3], NBT_CAPACITY, V[3] *  64000, NBT_ENERGY_ACCEPTED, TD.Energy.EU), "WxW", "BCB", "BPB", 'P', OP.plate.dat(MT.BatteryAlloy), 'B', IL.Battery_LiCoO2_Cell_Filled, 'W', MT.DATA.CABLES_01[3], 'C', OD_CIRCUITS[5]), null, "gt:re-battery3");
		IL.Battery_LiCoO2_EV            .set(aRegistry.add("Lithium-Cobalt Battery ("             +VN[4]+")", "Batteries"                           , 14034, 14013, MultiTileEntityBatteryAdvEU2048.class   , 0, 16, aUtilMetal , UT.NBT.make(NBT_HARDNESS,   0.5F, NBT_RESISTANCE,   3.0F, NBT_COLOR, DYES_INT[DYE_INDEX_Blue]                       , NBT_INPUT, V[4], NBT_CAPACITY, V[4] *  64000, NBT_ENERGY_ACCEPTED, TD.Energy.EU), "WPW", "BCB", "BBB", 'P', OP.plate.dat(MT.BatteryAlloy), 'B', IL.Battery_LiCoO2_Cell_Filled, 'W', MT.DATA.CABLES_01[4], 'C', OD_CIRCUITS[6]), null, "gt:re-battery4");
		
		IL.Battery_RE_LV_Lithium.set(IL.Battery_LiCoO2_LV.get(1));
		IL.Battery_RE_MV_Lithium.set(IL.Battery_LiCoO2_MV.get(1));
		IL.Battery_RE_HV_Lithium.set(IL.Battery_LiCoO2_HV.get(1));
		
		IL.Battery_LiMn_ULV             .set(aRegistry.add("Lithium-Manganese Battery ("+VN[0]+")"          , "Batteries"                           , 14040, 14013, MultiTileEntityBatteryAdvEU8   .class   , 0, 16, aUtilMetal , UT.NBT.make(NBT_HARDNESS,   0.5F, NBT_RESISTANCE,   3.0F, NBT_COLOR, DYES_INT[DYE_INDEX_Green]                      , NBT_INPUT, V[0], NBT_CAPACITY, V[0] * 128000, NBT_ENERGY_ACCEPTED, TD.Energy.EU), "Wx" , "BC" , "P " , 'P', OP.plate.dat(MT.BatteryAlloy), 'B', IL.Battery_LiMn_Cell_Filled, 'W', MT.DATA.CABLES_01[0], 'C', OD_CIRCUITS[2]), null, "gt:re-battery0");
		IL.Battery_LiMn_LV              .set(aRegistry.add("Lithium-Manganese Battery ("          +VN[1]+")", "Batteries"                           , 14041, 14013, MultiTileEntityBatteryAdvEU32  .class   , 0, 16, aUtilMetal , UT.NBT.make(NBT_HARDNESS,   0.5F, NBT_RESISTANCE,   3.0F, NBT_COLOR, DYES_INT[DYE_INDEX_Green]                      , NBT_INPUT, V[1], NBT_CAPACITY, V[1] * 128000, NBT_ENERGY_ACCEPTED, TD.Energy.EU), "CWx", "PBP", " B ", 'P', OP.plate.dat(MT.BatteryAlloy), 'B', IL.Battery_LiMn_Cell_Filled, 'W', MT.DATA.CABLES_01[1], 'C', OD_CIRCUITS[3]), null, "gt:re-battery1");
		IL.Battery_LiMn_MV              .set(aRegistry.add("Lithium-Manganese Battery ("          +VN[2]+")", "Batteries"                           , 14042, 14013, MultiTileEntityBatteryAdvEU128 .class   , 0, 16, aUtilMetal , UT.NBT.make(NBT_HARDNESS,   0.5F, NBT_RESISTANCE,   3.0F, NBT_COLOR, DYES_INT[DYE_INDEX_Green]                      , NBT_INPUT, V[2], NBT_CAPACITY, V[2] * 128000, NBT_ENERGY_ACCEPTED, TD.Energy.EU), "WxW", "BCB", "PBP", 'P', OP.plate.dat(MT.BatteryAlloy), 'B', IL.Battery_LiMn_Cell_Filled, 'W', MT.DATA.CABLES_01[2], 'C', OD_CIRCUITS[4]), null, "gt:re-battery2");
		IL.Battery_LiMn_HV              .set(aRegistry.add("Lithium-Manganese Battery ("          +VN[3]+")", "Batteries"                           , 14043, 14013, MultiTileEntityBatteryAdvEU512 .class   , 0, 16, aUtilMetal , UT.NBT.make(NBT_HARDNESS,   0.5F, NBT_RESISTANCE,   3.0F, NBT_COLOR, DYES_INT[DYE_INDEX_Green]                      , NBT_INPUT, V[3], NBT_CAPACITY, V[3] * 128000, NBT_ENERGY_ACCEPTED, TD.Energy.EU), "WxW", "BCB", "BPB", 'P', OP.plate.dat(MT.BatteryAlloy), 'B', IL.Battery_LiMn_Cell_Filled, 'W', MT.DATA.CABLES_01[3], 'C', OD_CIRCUITS[5]), null, "gt:re-battery3");
		IL.Battery_LiMn_EV              .set(aRegistry.add("Lithium-Manganese Battery ("          +VN[4]+")", "Batteries"                           , 14044, 14013, MultiTileEntityBatteryAdvEU2048.class   , 0, 16, aUtilMetal , UT.NBT.make(NBT_HARDNESS,   0.5F, NBT_RESISTANCE,   3.0F, NBT_COLOR, DYES_INT[DYE_INDEX_Green]                      , NBT_INPUT, V[4], NBT_CAPACITY, V[4] * 128000, NBT_ENERGY_ACCEPTED, TD.Energy.EU), "WPW", "BCB", "BBB", 'P', OP.plate.dat(MT.BatteryAlloy), 'B', IL.Battery_LiMn_Cell_Filled, 'W', MT.DATA.CABLES_01[4], 'C', OD_CIRCUITS[6]), null, "gt:re-battery4");
		
		// Just to populate those Fields with something for Compat with outdated Addons.
		IL.Battery_RE_LV_Sodium.set(IL.Battery_LiMn_LV.get(1));
		IL.Battery_RE_MV_Sodium.set(IL.Battery_LiMn_MV.get(1));
		IL.Battery_RE_HV_Sodium.set(IL.Battery_LiMn_HV.get(1));
		
		CR.shaped(IL.Tool_Scanner       .get(1), CR.DEF_REV, "EXR", "CPU", "BXB", 'B', IL.Battery_Alkaline_HV, 'X', OP.plate.dat(MT.Cr), 'U', OD_USB_STICKS[3], 'C', OD_USB_CABLES[3], 'E', IL.EMITTERS[4], 'R', IL.SENSORS[4], 'P', IL.Processor_Crystal_Sapphire);
		CR.shaped(IL.Tool_Cropnalyzer   .get(1), CR.DEF_REV, "EXR", "CPU", "BXB", 'B', IL.Battery_Alkaline_MV, 'X', OP.plate.dat(MT.Al), 'U', OD_USB_STICKS[1], 'C', OD_USB_CABLES[1], 'E', IL.EMITTERS[2], 'R', IL.SENSORS[2], 'P', OD_CIRCUITS[6]);
		
		aMat = MT.EnergiumRed;
		IL.Crystal_Energium_Red_ULV     .set(aRegistry.add("Red Energium Crystal (T0)"                      , "Batteries"                           , 14500, 14013, MultiTileEntityBatteryLU8   .class      , 0, 16, aUtilMetal , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   0.5F, NBT_RESISTANCE,   3.0F, NBT_INPUT, V[0], NBT_CAPACITY, V[0] * 400000, NBT_ENERGY_ACCEPTED, TD.Energy.LU)), null, "gt:re-crystal0"); OreDictManager.INSTANCE.setTarget(OP.gemChipped  , aMat, aRegistry.getItem());
		IL.Crystal_Energium_Red_LV      .set(aRegistry.add("Red Energium Crystal (T1)"                      , "Batteries"                           , 14501, 14013, MultiTileEntityBatteryLU32  .class      , 0, 16, aUtilMetal , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   0.5F, NBT_RESISTANCE,   3.0F, NBT_INPUT, V[1], NBT_CAPACITY, V[1] * 400000, NBT_ENERGY_ACCEPTED, TD.Energy.LU)), null, "gt:re-crystal1"); OreDictManager.INSTANCE.setTarget(OP.gemFlawed   , aMat, aRegistry.getItem()); IL.EnergyCrystal_RE_LV_Energium.set(aRegistry.getItem());
		IL.Crystal_Energium_Red_MV      .set(aRegistry.add("Red Energium Crystal (T2)"                      , "Batteries"                           , 14502, 14013, MultiTileEntityBatteryLU128 .class      , 0, 16, aUtilMetal , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   0.5F, NBT_RESISTANCE,   3.0F, NBT_INPUT, V[2], NBT_CAPACITY, V[2] * 400000, NBT_ENERGY_ACCEPTED, TD.Energy.LU)), null, "gt:re-crystal2"); OreDictManager.INSTANCE.setTarget(OP.gem         , aMat, aRegistry.getItem()); IL.EnergyCrystal_RE_MV_Energium.set(aRegistry.getItem());
		IL.Crystal_Energium_Red_HV      .set(aRegistry.add("Red Energium Crystal (T3)"                      , "Batteries"                           , 14503, 14013, MultiTileEntityBatteryLU512 .class      , 0, 16, aUtilMetal , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   0.5F, NBT_RESISTANCE,   3.0F, NBT_INPUT, V[3], NBT_CAPACITY, V[3] * 400000, NBT_ENERGY_ACCEPTED, TD.Energy.LU)), null, "gt:re-crystal3"); OreDictManager.INSTANCE.setTarget(OP.gemFlawless , aMat, aRegistry.getItem()); IL.EnergyCrystal_RE_HV_Energium.set(aRegistry.getItem());
		IL.Crystal_Energium_Red_EV      .set(aRegistry.add("Red Energium Crystal (T4)"                      , "Batteries"                           , 14504, 14013, MultiTileEntityBatteryLU2048.class      , 0, 16, aUtilMetal , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   0.5F, NBT_RESISTANCE,   3.0F, NBT_INPUT, V[4], NBT_CAPACITY, V[4] * 400000, NBT_ENERGY_ACCEPTED, TD.Energy.LU)), null, "gt:re-crystal4"); OreDictManager.INSTANCE.setTarget(OP.gemExquisite, aMat, aRegistry.getItem()); IL.EnergyCrystal_RE_EV_Energium.set(aRegistry.getItem());
		IL.Crystal_Energium_Red_IV      .set(aRegistry.add("Red Energium Crystal (T5)"                      , "Batteries"                           , 14505, 14013, MultiTileEntityBatteryLU8192.class      , 0, 16, aUtilMetal , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   0.5F, NBT_RESISTANCE,   3.0F, NBT_INPUT, V[5], NBT_CAPACITY, V[5] * 400000, NBT_ENERGY_ACCEPTED, TD.Energy.LU)), null, "gt:re-crystal5"); OreDictManager.INSTANCE.setTarget(OP.gemLegendary, aMat, aRegistry.getItem()); IL.EnergyCrystal_RE_IV_Energium.set(aRegistry.getItem());
		
		aMat = MT.EnergiumCyan;
		IL.Crystal_Energium_Cyan_ULV    .set(aRegistry.add("Cyan Energium Crystal (T0)"                     , "Batteries"                           , 14510, 14013, MultiTileEntityBatteryLU8   .class      , 0, 16, aUtilMetal , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   0.5F, NBT_RESISTANCE,   3.0F, NBT_INPUT, V[0], NBT_CAPACITY, V[0] * 800000, NBT_ENERGY_ACCEPTED, TD.Energy.LU)), null, "gt:re-crystal0"); OreDictManager.INSTANCE.setTarget(OP.gemChipped  , aMat, aRegistry.getItem());
		IL.Crystal_Energium_Cyan_LV     .set(aRegistry.add("Cyan Energium Crystal (T1)"                     , "Batteries"                           , 14511, 14013, MultiTileEntityBatteryLU32  .class      , 0, 16, aUtilMetal , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   0.5F, NBT_RESISTANCE,   3.0F, NBT_INPUT, V[1], NBT_CAPACITY, V[1] * 800000, NBT_ENERGY_ACCEPTED, TD.Energy.LU)), null, "gt:re-crystal1"); OreDictManager.INSTANCE.setTarget(OP.gemFlawed   , aMat, aRegistry.getItem());
		IL.Crystal_Energium_Cyan_MV     .set(aRegistry.add("Cyan Energium Crystal (T2)"                     , "Batteries"                           , 14512, 14013, MultiTileEntityBatteryLU128 .class      , 0, 16, aUtilMetal , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   0.5F, NBT_RESISTANCE,   3.0F, NBT_INPUT, V[2], NBT_CAPACITY, V[2] * 800000, NBT_ENERGY_ACCEPTED, TD.Energy.LU)), null, "gt:re-crystal2"); OreDictManager.INSTANCE.setTarget(OP.gem         , aMat, aRegistry.getItem());
		IL.Crystal_Energium_Cyan_HV     .set(aRegistry.add("Cyan Energium Crystal (T3)"                     , "Batteries"                           , 14513, 14013, MultiTileEntityBatteryLU512 .class      , 0, 16, aUtilMetal , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   0.5F, NBT_RESISTANCE,   3.0F, NBT_INPUT, V[3], NBT_CAPACITY, V[3] * 800000, NBT_ENERGY_ACCEPTED, TD.Energy.LU)), null, "gt:re-crystal3"); OreDictManager.INSTANCE.setTarget(OP.gemFlawless , aMat, aRegistry.getItem());
		IL.Crystal_Energium_Cyan_EV     .set(aRegistry.add("Cyan Energium Crystal (T4)"                     , "Batteries"                           , 14514, 14013, MultiTileEntityBatteryLU2048.class      , 0, 16, aUtilMetal , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   0.5F, NBT_RESISTANCE,   3.0F, NBT_INPUT, V[4], NBT_CAPACITY, V[4] * 800000, NBT_ENERGY_ACCEPTED, TD.Energy.LU)), null, "gt:re-crystal4"); OreDictManager.INSTANCE.setTarget(OP.gemExquisite, aMat, aRegistry.getItem());
		IL.Crystal_Energium_Cyan_IV     .set(aRegistry.add("Cyan Energium Crystal (T5)"                     , "Batteries"                           , 14515, 14013, MultiTileEntityBatteryLU8192.class      , 0, 16, aUtilMetal , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   0.5F, NBT_RESISTANCE,   3.0F, NBT_INPUT, V[5], NBT_CAPACITY, V[5] * 800000, NBT_ENERGY_ACCEPTED, TD.Energy.LU)), null, "gt:re-crystal5"); OreDictManager.INSTANCE.setTarget(OP.gemLegendary, aMat, aRegistry.getItem());
		
		
		IL.Power_Cell_Empty             .set(aRegistry.add("Power Cell (Empty)"                             , "Portable Power Cells"                , 14700, 14700, MultiTileEntityPowerCell       .class, 0, 16, aUtilMetal, UT.NBT.make(NBT_HARDNESS, 0.5F, NBT_RESISTANCE, 1.0F, NBT_ENERGY_ACCEPTED, TD.Energy.EU                                                                                                                                            ), "ACA", "FPF", "ACA", 'C', OD_CIRCUITS[4], 'P', OP.foil.dat(MT.Pt), 'F', OP.foil.dat(ANY.Plastic), 'A', OP.casingSmall.dat(MT.Al)));
		IL.Power_Cell_H                 .set(aRegistry.add("Power Cell (Hydrogen)"                          , "Portable Power Cells"                , 14701, 14700, MultiTileEntityPowerCell       .class, 0, 16, aUtilMetal, UT.NBT.make(NBT_HARDNESS, 0.5F, NBT_RESISTANCE, 1.0F, NBT_ENERGY_ACCEPTED, TD.Energy.EU, NBT_COLOR, UT.Code.getRGBInt(MT.H  .fRGBaGas), NBT_INPUT_MIN, 1, NBT_INPUT, V[3], NBT_INPUT_MAX, V   [3], NBT_CAPACITY,         3_200_000L))); RM.Canner.addRecipe1(F, 16, 256, IL.Power_Cell_Empty       .get(1), MT.H   .gas(U*200, T), NF, aRegistry.getItem(UT.NBT.make(NBT_ACTIVE_ENERGY, T))); RM.Canner.addRecipe1(F, 16, 256, aRegistry.getItem(), NF, NF, IL.Power_Cell_Empty.get(1));
		
		
		IL.Aneutronic_Fusion_Empty      .set(aRegistry.add("Aneutronic Fusion Power Cell (Empty)"           , "Portable Power Cells"                , 14600, 14700, MultiTileEntityAneutronicFusion.class, 0, 16, aUtilMetal, UT.NBT.make(NBT_HARDNESS, 0.5F, NBT_RESISTANCE, 1.0F, NBT_ENERGY_ACCEPTED, TD.Energy.EU                                                                                                                                            ), "VPV", "GFG", "VGV", 'P', IL.Processor_Crystal_Ruby, 'V', OP.plateGemTiny.dat(MT.Vb), 'F', IL.FIELD_GENERATORS[5], 'G', OP.foil.dat(MT.Graphene)));
		IL.Aneutronic_Fusion_He3        .set(aRegistry.add("Aneutronic Fusion Power Cell (Helium-3)"        , "Portable Power Cells"                , 14601, 14700, MultiTileEntityAneutronicFusion.class, 0, 16, aUtilMetal, UT.NBT.make(NBT_HARDNESS, 0.5F, NBT_RESISTANCE, 1.0F, NBT_ENERGY_ACCEPTED, TD.Energy.EU                                               , NBT_INPUT_MIN, 1, NBT_INPUT, V[5], NBT_INPUT_MAX, V   [5], NBT_CAPACITY,     1_024_000_000L))); RM.Canner.addRecipe1(F, 16, 256, IL.Aneutronic_Fusion_Empty.get(1), MT.He_3.gas(U*200, T), NF, aRegistry.getItem(UT.NBT.make(NBT_ACTIVE_ENERGY, T))); RM.Canner.addRecipe1(F, 16, 256, aRegistry.getItem(), NF, NF, IL.Aneutronic_Fusion_Empty.get(1));
		
		
		IL.ZPM                          .set(aRegistry.add("Zero-Point-Module (ZPM)"                        , "ZPM"                                 , 14999, 14999, MultiTileEntityZPM             .class, 0, 16, aUtilMetal, UT.NBT.make(NBT_HARDNESS, 0.5F, NBT_RESISTANCE, 1.0F, NBT_ENERGY_ACCEPTED, TD.Energy.QU, NBT_COLOR,                           0xffdd00, NBT_INPUT_MIN, 1, NBT_INPUT, V[7], NBT_INPUT_MAX, VMAX[7], NBT_CAPACITY, 2_000_000_000_000L)), null, "gt:zpm"); if (COMPAT_TC != null) COMPAT_TC.registerThaumcraftAspectsToItem(aRegistry.getItem(), F, TC.stack(TC.ALIENIS, 10), TC.stack(TC.MACHINA, 10), TC.stack(TC.VACUOS, 10), TC.stack(TC.POTENTIA, 10), TC.stack(TC.LUX, 10), TC.stack(TC.LUCRUM, 10));
		
		
		// Auto-Tools
		aClass = MultiTileEntityAutoToolHammer.class;
		aMat = MT.DATA.Kinetic_T[1];    aRegistry.add("Automatic Hammer ("              +aMat.getLocal()+")", "Automatic Tools"                     , 15001, 15002, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   7.0F, NBT_RESISTANCE,   7.0F, NBT_INPUT,    8, NBT_QUALITY, 1, NBT_ENERGY_ACCEPTED, TD.Energy.KU), "wR", "MS", "hH", 'M', OP.casingMachineDouble.dat(aMat), 'H', OP.toolHeadHammer.dat(aMat), 'R', OP.stickLong.dat(aMat), 'S', OP.spring.dat(aMat));
		aMat = MT.DATA.Kinetic_T[2];    aRegistry.add("Automatic Hammer ("              +aMat.getLocal()+")", "Automatic Tools"                     , 15002, 15002, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   6.0F, NBT_RESISTANCE,   6.0F, NBT_INPUT,   32, NBT_QUALITY, 2, NBT_ENERGY_ACCEPTED, TD.Energy.KU), "wR", "MS", "hH", 'M', OP.casingMachineDouble.dat(aMat), 'H', OP.toolHeadHammer.dat(aMat), 'R', OP.stickLong.dat(aMat), 'S', OP.spring.dat(aMat));
		aMat = MT.DATA.Kinetic_T[3];    aRegistry.add("Automatic Hammer ("              +aMat.getLocal()+")", "Automatic Tools"                     , 15003, 15002, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   9.0F, NBT_RESISTANCE,   9.0F, NBT_INPUT,  128, NBT_QUALITY, 3, NBT_ENERGY_ACCEPTED, TD.Energy.KU), "wR", "MS", "hH", 'M', OP.casingMachineDouble.dat(aMat), 'H', OP.toolHeadHammer.dat(aMat), 'R', OP.stickLong.dat(aMat), 'S', OP.spring.dat(aMat));
		aMat = MT.DATA.Kinetic_T[4];    aRegistry.add("Automatic Hammer ("              +aMat.getLocal()+")", "Automatic Tools"                     , 15004, 15002, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,  12.5F, NBT_RESISTANCE,  12.5F, NBT_INPUT,  512, NBT_QUALITY, 4, NBT_ENERGY_ACCEPTED, TD.Energy.KU), "wR", "MS", "hH", 'M', OP.casingMachineDouble.dat(aMat), 'H', OP.toolHeadHammer.dat(aMat), 'R', OP.stickLong.dat(aMat), 'S', OP.spring.dat(aMat));
		
		aClass = MultiTileEntityAutoToolIgniter.class;
		aMat = MT.DATA.Electric_T[0];   aRegistry.add("Automatic Igniter ("+VN[0]+")"                       , "Automatic Tools"                     , 15010, 15002, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT,    8, NBT_QUALITY, 0, NBT_ENERGY_ACCEPTED, TD.Energy.EU), "BwB", "CMC", 'M', OP.casingMachine.dat(aMat), 'B', OP.bolt.dat(ANY.Steel), 'C', MT.DATA.CABLES_01[0]);
		aMat = MT.DATA.Electric_T[1];   aRegistry.add("Automatic Igniter ("                       +VN[1]+")", "Automatic Tools"                     , 15011, 15002, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT,   32, NBT_QUALITY, 1, NBT_ENERGY_ACCEPTED, TD.Energy.EU), "BwB", "CMC", 'M', OP.casingMachine.dat(aMat), 'B', OP.bolt.dat(ANY.Steel), 'C', MT.DATA.CABLES_01[1]);
		aMat = MT.DATA.Electric_T[2];   aRegistry.add("Automatic Igniter ("                       +VN[2]+")", "Automatic Tools"                     , 15012, 15002, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT,  128, NBT_QUALITY, 2, NBT_ENERGY_ACCEPTED, TD.Energy.EU), "BwB", "CMC", 'M', OP.casingMachine.dat(aMat), 'B', OP.bolt.dat(ANY.Steel), 'C', MT.DATA.CABLES_01[2]);
		aMat = MT.DATA.Electric_T[3];   aRegistry.add("Automatic Igniter ("                       +VN[3]+")", "Automatic Tools"                     , 15013, 15002, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT,  512, NBT_QUALITY, 3, NBT_ENERGY_ACCEPTED, TD.Energy.EU), "BwB", "CMC", 'M', OP.casingMachine.dat(aMat), 'B', OP.bolt.dat(ANY.Steel), 'C', MT.DATA.CABLES_01[3]);
		aMat = MT.DATA.Electric_T[4];   aRegistry.add("Automatic Igniter ("                       +VN[4]+")", "Automatic Tools"                     , 15014, 15002, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT, 2048, NBT_QUALITY, 4, NBT_ENERGY_ACCEPTED, TD.Energy.EU), "BwB", "CMC", 'M', OP.casingMachine.dat(aMat), 'B', OP.bolt.dat(ANY.Steel), 'C', MT.DATA.CABLES_01[4]);
		aMat = MT.DATA.Electric_T[5];   aRegistry.add("Automatic Igniter ("                       +VN[5]+")", "Automatic Tools"                     , 15015, 15002, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT, 8192, NBT_QUALITY, 5, NBT_ENERGY_ACCEPTED, TD.Energy.EU), "BwB", "CMC", 'M', OP.casingMachine.dat(aMat), 'B', OP.bolt.dat(ANY.Steel), 'C', MT.DATA.CABLES_01[5]);
		
		
		
		// Pumps
		aClass = MultiTileEntityPump.class;
		aMat = MT.DATA.Kinetic_T[1];    aRegistry.add("Rotational Pump ("               +aMat.getLocal()+")", "Pumps"                               , 16001, 16002, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   7.0F, NBT_RESISTANCE,   7.0F, NBT_INPUT,   32, NBT_ENERGY_ACCEPTED, TD.Energy.RU), "GwG", "PMP", "RPR", 'M', OP.casingMachineDouble.dat(aMat), 'G', OP.gearGt.dat(aMat), 'R', OP.rotor.dat(MT.StainlessSteel), 'P', OP.pipeSmall .dat(MT.StainlessSteel));
		aMat = MT.DATA.Kinetic_T[2];    aRegistry.add("Rotational Pump ("               +aMat.getLocal()+")", "Pumps"                               , 16002, 16002, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   6.0F, NBT_RESISTANCE,   6.0F, NBT_INPUT,  128, NBT_ENERGY_ACCEPTED, TD.Energy.RU), "GwG", "PMP", "RPR", 'M', OP.casingMachineDouble.dat(aMat), 'G', OP.gearGt.dat(aMat), 'R', OP.rotor.dat(MT.StainlessSteel), 'P', OP.pipeMedium.dat(MT.StainlessSteel));
		aMat = MT.DATA.Kinetic_T[3];    aRegistry.add("Rotational Pump ("               +aMat.getLocal()+")", "Pumps"                               , 16003, 16002, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   9.0F, NBT_RESISTANCE,   9.0F, NBT_INPUT,  512, NBT_ENERGY_ACCEPTED, TD.Energy.RU), "GwG", "PMP", "RPR", 'M', OP.casingMachineDouble.dat(aMat), 'G', OP.gearGt.dat(aMat), 'R', OP.rotor.dat(MT.StainlessSteel), 'P', OP.pipeLarge .dat(MT.StainlessSteel));
		aMat = MT.DATA.Kinetic_T[4];    aRegistry.add("Rotational Pump ("               +aMat.getLocal()+")", "Pumps"                               , 16004, 16002, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,  12.5F, NBT_RESISTANCE,  12.5F, NBT_INPUT, 2048, NBT_ENERGY_ACCEPTED, TD.Energy.RU), "GwG", "PMP", "RPR", 'M', OP.casingMachineDouble.dat(aMat), 'G', OP.gearGt.dat(aMat), 'R', OP.rotor.dat(MT.StainlessSteel), 'P', OP.pipeHuge  .dat(MT.StainlessSteel));
	}
	
	private static void computer(MultiTileEntityRegistry aRegistry, MultiTileEntityBlock aMetal, MultiTileEntityBlock aMetalChips, MultiTileEntityBlock aMetalWires, MultiTileEntityBlock aMachine, MultiTileEntityBlock aWooden, MultiTileEntityBlock aBush, MultiTileEntityBlock aStone, MultiTileEntityBlock aWool, MultiTileEntityBlock aTNT, MultiTileEntityBlock aHive, MultiTileEntityBlock aUtilMetal, MultiTileEntityBlock aUtilStone, MultiTileEntityBlock aUtilWood, MultiTileEntityBlock aUtilWool, OreDictMaterial aMat, Class<? extends TileEntity> aClass) {
		aMat = MT.SteelGalvanized;      aRegistry.add("USB Switch"                                          , "Computing", 19000, 19000, MultiTileEntityUSBSwitch.class, aMat.mToolQuality, 16, aMachine, UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS, 6.0F, NBT_RESISTANCE, 6.0F), "UPU", "TMT", "UdU", 'M', OP.casingMachine.dat(aMat), 'T', OP.screw.dat(aMat), 'U', IL.USB_Cable_3, 'P', IL.Processor_Crystal_Emerald);
		aMat = MT.SteelGalvanized;      aRegistry.add("HDD Switch"                                          , "Computing", 19001, 19000, MultiTileEntityHDDSwitch.class, aMat.mToolQuality, 16, aMachine, UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS, 6.0F, NBT_RESISTANCE, 6.0F), "CPC", "TMT", "UdU", 'M', OP.casingMachine.dat(aMat), 'T', OP.screw.dat(aMat), 'U', IL.USB_Cable_3, 'P', IL.Processor_Crystal_Emerald, 'C', OD_CIRCUITS[3]);
	}
	
	private static void multiblocks(MultiTileEntityRegistry aRegistry, MultiTileEntityBlock aMetal, MultiTileEntityBlock aMetalChips, MultiTileEntityBlock aMetalWires, MultiTileEntityBlock aMachine, MultiTileEntityBlock aWooden, MultiTileEntityBlock aBush, MultiTileEntityBlock aStone, MultiTileEntityBlock aWool, MultiTileEntityBlock aTNT, MultiTileEntityBlock aHive, MultiTileEntityBlock aUtilMetal, MultiTileEntityBlock aUtilStone, MultiTileEntityBlock aUtilWood, MultiTileEntityBlock aUtilWool, OreDictMaterial aMat, Class<? extends TileEntity> aClass) {
		aClass = MultiTileEntityMultiBlockPart.class;
		aMat = MT.Ceramic;              aRegistry.add("Fire Bricks"                                         , "Multiblock Machines", 18000, 17101, aClass                                   , aMat.mToolQuality, 64, aStone     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   5.0F, NBT_RESISTANCE,   5.0F, NBT_TEXTURE, "firebricks"              , NBT_DESIGNS, 0                        ), "CBC", "BWB", "CBC", 'B', OP.ingot.dat(MT.Brick), 'C', OP.dust.dat(ANY.Clay), 'W', OD.container1000water);
		aMat = MT.WoodTreated;          aRegistry.add("Wood Wall"                                           , "Multiblock Machines", 18001, 17101, aClass                                   , aMat.mToolQuality, 64, aWooden    , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   5.0F, NBT_RESISTANCE,   5.0F, NBT_TEXTURE, "woodwall"                , NBT_DESIGNS, 0, NBT_FLAMMABILITY,  150), "W W", "sPh", "W W", 'W', OP.plate.dat(aMat), 'P', OP.plate.dat(MT.Pb));
		// 18020
		// 18021
		
		aMat = MT.Pb;                   aRegistry.add("Lead Wall"                                           , "Multiblock Machines", 18011, 17101, aClass                                   , aMat.mToolQuality, 64, aMachine   , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   6.0F, NBT_RESISTANCE,   6.0F, NBT_TEXTURE, "metalwall"               , NBT_DESIGNS, 7), "wPP", "hPP"       , 'P', OP.plate.dat(aMat)); RM.Welder.addRecipe2(F, 16, 256, OP.plate.mat(aMat, 4), ST.tag(10), aRegistry.getItem());
		aMat = MT.Bronze;               aRegistry.add("Bronze Wall"                                         , "Multiblock Machines", 18010, 17101, aClass                                   , aMat.mToolQuality, 64, aMachine   , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   6.0F, NBT_RESISTANCE,   6.0F, NBT_TEXTURE, "metalwall"               , NBT_DESIGNS, 7), "wPP", "hPP"       , 'P', OP.plate.dat(aMat)); RM.Welder.addRecipe2(F, 16, 256, OP.plate.mat(aMat, 4), ST.tag(10), aRegistry.getItem());
		aMat = ANY.Steel;               aRegistry.add("Steel Wall"                                          , "Multiblock Machines", 18009, 17101, aClass                                   , aMat.mToolQuality, 64, aMachine   , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   6.0F, NBT_RESISTANCE,   6.0F, NBT_TEXTURE, "metalwall"               , NBT_DESIGNS, 7), "wPP", "hPP"       , 'P', OP.plate.dat(aMat)); RM.Welder.addRecipe2(F, 16, 256, OP.plate.mat(aMat, 4), ST.tag(10), aRegistry.getItem());
		aMat = MT.SteelGalvanized;      aRegistry.add("Galvanized Steel Wall"                               , "Multiblock Machines", 18008, 17101, aClass                                   , aMat.mToolQuality, 64, aMachine   , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   6.0F, NBT_RESISTANCE,   6.0F, NBT_TEXTURE, "metalwall"               , NBT_DESIGNS, 7), "wPP", "hPP"       , 'P', OP.plate.dat(aMat)); RM.Welder.addRecipe2(F, 16, 256, OP.plate.mat(aMat, 4), ST.tag(10), aRegistry.getItem());
		aMat = MT.StainlessSteel;       aRegistry.add("Stainless Steel Wall"                                , "Multiblock Machines", 18002, 17101, aClass                                   , aMat.mToolQuality, 64, aMachine   , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   6.0F, NBT_RESISTANCE,   6.0F, NBT_TEXTURE, "metalwall"               , NBT_DESIGNS, 7), "wPP", "hPP"       , 'P', OP.plate.dat(aMat)); RM.Welder.addRecipe2(F, 16, 256, OP.plate.mat(aMat, 4), ST.tag(10), aRegistry.getItem());
		aMat = MT.Invar;                aRegistry.add("Invar Wall"                                          , "Multiblock Machines", 18007, 17101, aClass                                   , aMat.mToolQuality, 64, aMachine   , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   6.0F, NBT_RESISTANCE,   6.0F, NBT_TEXTURE, "metalwall"               , NBT_DESIGNS, 7), "wPP", "hPP"       , 'P', OP.plate.dat(aMat)); RM.Welder.addRecipe2(F, 16, 256, OP.plate.mat(aMat, 4), ST.tag(10), aRegistry.getItem());
		aMat = MT.Ti;                   aRegistry.add("Titanium Wall"                                       , "Multiblock Machines", 18006, 17101, aClass                                   , aMat.mToolQuality, 64, aMachine   , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   9.0F, NBT_RESISTANCE,   9.0F, NBT_TEXTURE, "metalwall"               , NBT_DESIGNS, 7), "wPP", "hPP"       , 'P', OP.plate.dat(aMat)); RM.Welder.addRecipe2(F, 16, 256, OP.plate.mat(aMat, 4), ST.tag(10), aRegistry.getItem());
		aMat = MT.TungstenSteel;        aRegistry.add("Tungstensteel Wall"                                  , "Multiblock Machines", 18003, 17101, aClass                                   , aMat.mToolQuality, 64, aMachine   , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,  12.5F, NBT_RESISTANCE,  12.5F, NBT_TEXTURE, "metalwall"               , NBT_DESIGNS, 7), "wPP", "hPP"       , 'P', OP.plate.dat(aMat)); RM.Welder.addRecipe2(F, 16, 256, OP.plate.mat(aMat, 4), ST.tag(10), aRegistry.getItem());
		aMat = ANY.W;                   aRegistry.add("Tungsten Wall"                                       , "Multiblock Machines", 18004, 17101, aClass                                   , aMat.mToolQuality, 64, aMachine   , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,  10.0F, NBT_RESISTANCE,  10.0F, NBT_TEXTURE, "metalwall"               , NBT_DESIGNS, 7), "wPP", "hPP"       , 'P', OP.plate.dat(aMat)); RM.Welder.addRecipe2(F, 16, 256, OP.plate.mat(aMat, 4), ST.tag(10), aRegistry.getItem());
		aMat = MT.Ta4HfC5;              aRegistry.add("Tantalum Hafnium Carbide Wall"                       , "Multiblock Machines", 18012, 17101, aClass                                   , aMat.mToolQuality, 64, aMachine   , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,  12.5F, NBT_RESISTANCE,  12.5F, NBT_TEXTURE, "metalwall"               , NBT_DESIGNS, 7), "wPP", "hPP"       , 'P', OP.plate.dat(aMat)); RM.Welder.addRecipe2(F, 16, 256, OP.plate.mat(aMat, 4), ST.tag(10), aRegistry.getItem());
		aMat = MT.Ad;                   aRegistry.add("Adamantium Wall"                                     , "Multiblock Machines", 18005, 17101, aClass                                   , aMat.mToolQuality, 64, aMachine   , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS, 100.0F, NBT_RESISTANCE, 100.0F, NBT_TEXTURE, "metalwall"               , NBT_DESIGNS, 7), "wPP", "hPP"       , 'P', OP.plate.dat(aMat)); RM.Welder.addRecipe2(F, 16, 256, OP.plate.mat(aMat, 4), ST.tag(10), aRegistry.getItem());
		
		aMat = MT.Pb;                   aRegistry.add("Dense Lead Wall"                                     , "Multiblock Machines", 18031, 17101, aClass                                   , aMat.mToolQuality, 64, aMachine   , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   6.0F, NBT_RESISTANCE,   6.0F, NBT_TEXTURE, "metalwalldense"          , NBT_DESIGNS, 7)); OM.data(aRegistry.getItem(), aMat, U*36); RM.Welder.addRecipe2(F, 64, 512, OP.plateDense.mat(aMat, 4), ST.tag(10), aRegistry.getItem());
		aMat = MT.Bronze;               aRegistry.add("Dense Bronze Wall"                                   , "Multiblock Machines", 18030, 17101, aClass                                   , aMat.mToolQuality, 64, aMachine   , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   6.0F, NBT_RESISTANCE,   6.0F, NBT_TEXTURE, "metalwalldense"          , NBT_DESIGNS, 7)); OM.data(aRegistry.getItem(), aMat, U*36); RM.Welder.addRecipe2(F, 64, 512, OP.plateDense.mat(aMat, 4), ST.tag(10), aRegistry.getItem());
		aMat = ANY.Steel;               aRegistry.add("Dense Steel Wall"                                    , "Multiblock Machines", 18029, 17101, aClass                                   , aMat.mToolQuality, 64, aMachine   , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   6.0F, NBT_RESISTANCE,   6.0F, NBT_TEXTURE, "metalwalldense"          , NBT_DESIGNS, 7)); OM.data(aRegistry.getItem(), aMat, U*36); RM.Welder.addRecipe2(F, 64, 512, OP.plateDense.mat(aMat, 4), ST.tag(10), aRegistry.getItem());
		aMat = MT.SteelGalvanized;      aRegistry.add("Dense Galvanized Steel Wall"                         , "Multiblock Machines", 18028, 17101, aClass                                   , aMat.mToolQuality, 64, aMachine   , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   6.0F, NBT_RESISTANCE,   6.0F, NBT_TEXTURE, "metalwalldense"          , NBT_DESIGNS, 7)); OM.data(aRegistry.getItem(), aMat, U*36); RM.Welder.addRecipe2(F, 64, 512, OP.plateDense.mat(aMat, 4), ST.tag(10), aRegistry.getItem());
		aMat = MT.StainlessSteel;       aRegistry.add("Dense Stainless Steel Wall"                          , "Multiblock Machines", 18022, 17101, aClass                                   , aMat.mToolQuality, 64, aMachine   , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   6.0F, NBT_RESISTANCE,   6.0F, NBT_TEXTURE, "metalwalldense"          , NBT_DESIGNS, 7)); OM.data(aRegistry.getItem(), aMat, U*36); RM.Welder.addRecipe2(F, 64, 512, OP.plateDense.mat(aMat, 4), ST.tag(10), aRegistry.getItem());
		aMat = MT.Invar;                aRegistry.add("Dense Invar Wall"                                    , "Multiblock Machines", 18027, 17101, aClass                                   , aMat.mToolQuality, 64, aMachine   , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   6.0F, NBT_RESISTANCE,   6.0F, NBT_TEXTURE, "metalwalldense"          , NBT_DESIGNS, 7)); OM.data(aRegistry.getItem(), aMat, U*36); RM.Welder.addRecipe2(F, 64, 512, OP.plateDense.mat(aMat, 4), ST.tag(10), aRegistry.getItem());
		aMat = MT.Ti;                   aRegistry.add("Dense Titanium Wall"                                 , "Multiblock Machines", 18026, 17101, aClass                                   , aMat.mToolQuality, 64, aMachine   , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   9.0F, NBT_RESISTANCE,   9.0F, NBT_TEXTURE, "metalwalldense"          , NBT_DESIGNS, 7)); OM.data(aRegistry.getItem(), aMat, U*36); RM.Welder.addRecipe2(F, 64, 512, OP.plateDense.mat(aMat, 4), ST.tag(10), aRegistry.getItem());
		aMat = MT.TungstenSteel;        aRegistry.add("Dense Tungstensteel Wall"                            , "Multiblock Machines", 18023, 17101, aClass                                   , aMat.mToolQuality, 64, aMachine   , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,  12.5F, NBT_RESISTANCE,  12.5F, NBT_TEXTURE, "metalwalldense"          , NBT_DESIGNS, 7)); OM.data(aRegistry.getItem(), aMat, U*36); RM.Welder.addRecipe2(F, 64, 512, OP.plateDense.mat(aMat, 4), ST.tag(10), aRegistry.getItem());
		aMat = ANY.W;                   aRegistry.add("Dense Tungsten Wall"                                 , "Multiblock Machines", 18024, 17101, aClass                                   , aMat.mToolQuality, 64, aMachine   , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,  10.0F, NBT_RESISTANCE,  10.0F, NBT_TEXTURE, "metalwalldense"          , NBT_DESIGNS, 7)); OM.data(aRegistry.getItem(), aMat, U*36); RM.Welder.addRecipe2(F, 64, 512, OP.plateDense.mat(aMat, 4), ST.tag(10), aRegistry.getItem());
		aMat = MT.Ta4HfC5;              aRegistry.add("Dense Tantalum Hafnium Carbide Wall"                 , "Multiblock Machines", 18032, 17101, aClass                                   , aMat.mToolQuality, 64, aMachine   , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,  12.5F, NBT_RESISTANCE,  12.5F, NBT_TEXTURE, "metalwalldense"          , NBT_DESIGNS, 7)); OM.data(aRegistry.getItem(), aMat, U*36); RM.Welder.addRecipe2(F, 64, 512, OP.plateDense.mat(aMat, 4), ST.tag(10), aRegistry.getItem());
		aMat = MT.Ad;                   aRegistry.add("Dense Adamantium Wall"                               , "Multiblock Machines", 18025, 17101, aClass                                   , aMat.mToolQuality, 64, aMachine   , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS, 100.0F, NBT_RESISTANCE, 100.0F, NBT_TEXTURE, "metalwalldense"          , NBT_DESIGNS, 7)); OM.data(aRegistry.getItem(), aMat, U*36); RM.Welder.addRecipe2(F, 64, 512, OP.plateDense.mat(aMat, 4), ST.tag(10), aRegistry.getItem());
		
		aMat = MT.AnnealedCopper;       aRegistry.add("Large Copper Coil"                                   , "Multiblock Machines", 18040, 17101, aClass                                   , aMat.mToolQuality, 64, aMachine   , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   6.0F, NBT_RESISTANCE,   6.0F, NBT_TEXTURE, "coil"                    , NBT_DESIGNS, 1), "WWW", "WxW", "WWW", 'W', OP.wireGt04.dat(aMat));
		aMat = MT.NiobiumTitanium;      aRegistry.add("Large Niobium-Titanium Coil"                         , "Multiblock Machines", 18041, 17101, aClass                                   , aMat.mToolQuality, 64, aMachine   , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   6.0F, NBT_RESISTANCE,   6.0F, NBT_TEXTURE, "coil"                    , NBT_DESIGNS, 1), "WWW", "WxW", "WWW", 'W', OP.wireGt04.dat(aMat));
		aMat = MT.Nichrome;             aRegistry.add("Large Nichrome Coil"                                 , "Multiblock Machines", 18042, 17101, aClass                                   , aMat.mToolQuality, 64, aMachine   , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   6.0F, NBT_RESISTANCE,   6.0F, NBT_TEXTURE, "coil"                    , NBT_DESIGNS, 1), "WWW", "WxW", "WWW", 'W', OP.wireGt04.dat(aMat));
		aMat = MT.SiC;                  aRegistry.add("Large Carborundum Coil"                              , "Multiblock Machines", 18043, 17101, aClass                                   , aMat.mToolQuality, 64, aMachine   , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   6.0F, NBT_RESISTANCE,   6.0F, NBT_TEXTURE, "coil"                    , NBT_DESIGNS, 1), "WWW", "WxW", "WWW", 'W', OP.wireGt04.dat(aMat));
		aMat = MT.Os;                   aRegistry.add("Large Osmium Coil"                                   , "Multiblock Machines", 18044, 17101, aClass                                   , aMat.mToolQuality, 64, aMachine   , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   6.0F, NBT_RESISTANCE,   6.0F, NBT_TEXTURE, "coil"                    , NBT_DESIGNS, 1), "WWW", "WxW", "WWW", 'W', OP.wireGt04.dat(aMat));
		aMat = MT.Ir;                   aRegistry.add("Large Iridium Coil"                                  , "Multiblock Machines", 18045, 17101, aClass                                   , aMat.mToolQuality, 64, aMachine   , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   6.0F, NBT_RESISTANCE,   6.0F, NBT_TEXTURE, "coil"                    , NBT_DESIGNS, 1), "WWW", "WxW", "WWW", 'W', OP.wireGt04.dat(aMat));
		
		aMat = MT.TungstenSteel;        aRegistry.add("Centrifuge Part"                                     , "Multiblock Machines", 18100, 17101, aClass                                   , aMat.mToolQuality, 64, aMachine   , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,  12.5F, NBT_RESISTANCE,  12.5F, NBT_TEXTURE, "centrifugeparts"         , NBT_DESIGNS, 8), "TwT", "GMG", "TdT", 'M', OP.casingMachine.dat(aMat), 'G', OP.gearGt.dat(aMat), 'T', OP.screw.dat(aMat));
		aMat = MT.StainlessSteel;       aRegistry.add("Electrolyzer Part"                                   , "Multiblock Machines", 18105, 17101, aClass                                   , aMat.mToolQuality, 64, aMachine   , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,  12.5F, NBT_RESISTANCE,  12.5F, NBT_TEXTURE, "electrolyzerparts"       , NBT_DESIGNS, 7), "WwW", "WMW", "CCC", 'M', OP.casingMachine.dat(aMat), 'W', OP.wireGt01.dat(MT.Pt), 'C', OD_CIRCUITS[6]);
		aMat = MT.Invar;                aRegistry.add("Heat Transmitter"                                    , "Multiblock Machines", 18101, 17101, aClass                                   , aMat.mToolQuality, 64, aMachine   , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,  10.0F, NBT_RESISTANCE,  10.0F, NBT_TEXTURE, "heatacceptor"            , NBT_DESIGNS, 0), "MPM", "hRw", "MPM", 'M', OP.plate.dat(aMat), 'P', OP.plateTriple.dat(ANY.Cu), 'R', OP.stickLong.dat(ANY.Cu));
		aMat = MT.StainlessSteel;       aRegistry.add("Distillation Tower Part"                             , "Multiblock Machines", 18102, 17101, aClass                                   , aMat.mToolQuality, 64, aMachine   , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   6.0F, NBT_RESISTANCE,   6.0F, NBT_TEXTURE, "distillationtowerparts"  , NBT_DESIGNS, 1), "TMT", "hPd", "TMT", 'M', OP.plate.dat(aMat), 'P', OP.pipeSmall.dat(aMat), 'T', OP.screw.dat(aMat));
		aMat = MT.TungstenSteel;        aRegistry.add("Bedrock Mining Drill Head"                           , "Multiblock Machines", 18103, 17101, aClass                                   , aMat.mToolQuality, 64, aMachine   , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,  12.5F, NBT_RESISTANCE,  12.5F, NBT_TEXTURE, "bedrockdrill"            , NBT_DESIGNS, 0), "DID", "GMG", "DID", 'M', OP.casingMachineDense.dat(aMat), 'G', OP.gearGt.dat(aMat), 'I', OP.toolHeadDrill.dat(aMat), 'D', OP.gem.dat(ANY.Diamond));
		aMat = MT.SteelGalvanized;      aRegistry.add("Lightning Rod"                                       , "Multiblock Machines", 18104, 17101, aClass                                   , aMat.mToolQuality, 64, aMachine   , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   8.0F, NBT_RESISTANCE,   8.0F, NBT_TEXTURE, "lightningrod"            , NBT_DESIGNS, 0), "MWM", "WRW", "MWM", 'M', OP.plate.dat(aMat), 'R', OP.stick.dat(MT.Ir), 'W', OP.wireGt01.dat(MT.NiobiumTitanium));
		aMat = MT.Ti;                   aRegistry.add("Sluice Part"                                         , "Multiblock Machines", 18106, 17101, aClass                                   , aMat.mToolQuality, 64, aMachine   , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   9.0F, NBT_RESISTANCE,   9.0F, NBT_TEXTURE, "sluiceparts"             , NBT_DESIGNS, 7), "GGG", "PMP", "PwP", 'M', OP.casingMachine.dat(aMat), 'G', OP.gearGt.dat(aMat), 'P', OP.pipeMedium.dat(aMat));
		aMat = MT.TungstenSteel;        aRegistry.add("Crusher Wheels"                                      , "Multiblock Machines", 18107, 17101, aClass                                   , aMat.mToolQuality, 64, aMachine   , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   9.0F, NBT_RESISTANCE,   9.0F, NBT_TEXTURE, "crusherwheels"           , NBT_DESIGNS, 3), "DDD", "GDG", "GMG", 'M', OP.casingMachineDouble.dat(aMat), 'G', OP.gearGt.dat(aMat), 'D', OP.gem.dat(ANY.Diamond));
		aMat = MT.TungstenSteel;        aRegistry.add("Shredder Blades"                                     , "Multiblock Machines", 18108, 17101, aClass                                   , aMat.mToolQuality, 64, aMachine   , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   9.0F, NBT_RESISTANCE,   9.0F, NBT_TEXTURE, "shredderblades"          , NBT_DESIGNS, 3), "DGD", "GwG", "GMG", 'M', OP.casingMachineDouble.dat(aMat), 'G', OP.gearGt.dat(aMat), 'D', OP.plateGem.dat(ANY.Diamond));
		
		aMat = MT.SteelGalvanized;      aRegistry.add("Ventilation Unit"                                    , "Multiblock Machines", 18299, 17101, aClass                                   , aMat.mToolQuality, 64, aMachine   , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   6.0F, NBT_RESISTANCE,   6.0F, NBT_TEXTURE, "ventilationunit"         , NBT_DESIGNS, 0), "FwF", "CMC", "EdE", 'M', OP.casingMachine.dat(aMat), 'C', OD_CIRCUITS[3], 'F', IL.Cover_Vent, 'E', IL.MOTORS[1]);
		aMat = MT.SteelGalvanized;      aRegistry.add("Versatile Quadcore Processor Unit"                   , "Multiblock Machines", 18200, 17101, aClass                                   , aMat.mToolQuality, 64, aMachine   , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   6.0F, NBT_RESISTANCE,   6.0F, NBT_TEXTURE, "processorversatile"      , NBT_DESIGNS, 0), "DCS", "CMC", "RCE", 'M', OP.casingMachine.dat(aMat), 'C', OD_CIRCUITS[6], 'S', IL.Processor_Crystal_Sapphire, 'D', IL.Processor_Crystal_Diamond, 'R', IL.Processor_Crystal_Ruby, 'E', IL.Processor_Crystal_Emerald);
		aMat = MT.SteelGalvanized;      aRegistry.add("Logic Quadcore Processor Unit"                       , "Multiblock Machines", 18201, 17101, aClass                                   , aMat.mToolQuality, 64, aMachine   , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   6.0F, NBT_RESISTANCE,   6.0F, NBT_TEXTURE, "processorlogic"          , NBT_DESIGNS, 0), "PCP", "CMC", "PCP", 'M', OP.casingMachine.dat(aMat), 'C', OD_CIRCUITS[6], 'P', IL.Processor_Crystal_Diamond );
		aMat = MT.SteelGalvanized;      aRegistry.add("Control Quadcore Processor Unit"                     , "Multiblock Machines", 18202, 17101, aClass                                   , aMat.mToolQuality, 64, aMachine   , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   6.0F, NBT_RESISTANCE,   6.0F, NBT_TEXTURE, "processorcontrol"        , NBT_DESIGNS, 0), "PCP", "CMC", "PCP", 'M', OP.casingMachine.dat(aMat), 'C', OD_CIRCUITS[6], 'P', IL.Processor_Crystal_Ruby    );
		aMat = MT.SteelGalvanized;      aRegistry.add("Storage Quadcore Processor Unit"                     , "Multiblock Machines", 18203, 17101, aClass                                   , aMat.mToolQuality, 64, aMachine   , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   6.0F, NBT_RESISTANCE,   6.0F, NBT_TEXTURE, "processorstorage"        , NBT_DESIGNS, 0), "PCP", "CMC", "PCP", 'M', OP.casingMachine.dat(aMat), 'C', OD_CIRCUITS[6], 'P', IL.Processor_Crystal_Emerald );
		aMat = MT.SteelGalvanized;      aRegistry.add("Conversion Quadcore Processor Unit"                  , "Multiblock Machines", 18204, 17101, aClass                                   , aMat.mToolQuality, 64, aMachine   , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   6.0F, NBT_RESISTANCE,   6.0F, NBT_TEXTURE, "processorconversion"     , NBT_DESIGNS, 0), "PCP", "CMC", "PCP", 'M', OP.casingMachine.dat(aMat), 'C', OD_CIRCUITS[6], 'P', IL.Processor_Crystal_Sapphire);
		
		
		
		aMat = MT.Ceramic;              aRegistry.add("Coke Oven"                                           , "Multiblock Machines", 17000, 17101, MultiTileEntityCokeOven.class            , aMat.mToolQuality, 16, aStone     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   5.0F, NBT_RESISTANCE,   5.0F, NBT_TEXTURE, "cokeoven"                , NBT_PARALLEL, 16, NBT_ENERGY_ACCEPTED, TD.Energy.TU, NBT_NO_CONSTANT_POWER, T, NBT_RECIPEMAP, RM.CokeOven, NBT_INV_SIDE_IN, SBIT_U, NBT_INV_SIDE_OUT, SBIT_D, NBT_TANK_SIDE_OUT, 61, NBT_TANK_SIDE_AUTO_OUT, SIDE_BOTTOM, NBT_ENERGY_ACCEPTED_SIDES, 63, NBT_INPUT,  1, NBT_INPUT_MIN, 1, NBT_INPUT_MAX, 16, NBT_NEEDS_IGNITION, T), "hRT", "PMR", "dRT", 'M', aRegistry.getItem(18000), 'R', OP.stick.dat(ANY.Iron), 'P', OP.plate.dat(ANY.Iron), 'T', OP.screw.dat(ANY.Iron));
		
		aMat = MT.WoodTreated;          aRegistry.add("Wood Tank Main Valve"                                , "Multiblock Machines", 17001, 17101, MultiTileEntityTank3x3x3Wood.class       , aMat.mToolQuality, 16, aWooden    , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   5.0F, NBT_RESISTANCE,   5.0F, NBT_TEXTURE, "tankwood"                , NBT_TANK_CAPACITY,     432000, NBT_DESIGN, 18001, NBT_GASPROOF, F, NBT_ACIDPROOF, F, NBT_PLASMAPROOF, F, NBT_MAGICPROOF, F, NBT_FLAMMABILITY,  150), " R ", "rMs", " R ", 'M', aRegistry.getItem(18001), 'R', OP.ring.dat(MT.Pb));
		aMat = MT.StainlessSteel;       aRegistry.add("Small Stainless Steel Tank Main Valve"               , "Multiblock Machines", 17002, 17101, MultiTileEntityTank3x3x3Metal.class      , aMat.mToolQuality, 16, aMachine   , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   6.0F, NBT_RESISTANCE,   6.0F, NBT_TEXTURE, "tankmetal"               , NBT_TANK_CAPACITY,    1728000, NBT_DESIGN, 18002, NBT_GASPROOF, T, NBT_ACIDPROOF, T, NBT_PLASMAPROOF, F, NBT_MAGICPROOF, F                        ), " R ", "hMs", " R ", 'M', aRegistry.getItem(18002), 'R', OP.ring.dat(aMat));
		aMat = MT.Invar;                aRegistry.add("Small Invar Tank Main Valve"                         , "Multiblock Machines", 17007, 17101, MultiTileEntityTank3x3x3Metal.class      , aMat.mToolQuality, 16, aMachine   , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   6.0F, NBT_RESISTANCE,   6.0F, NBT_TEXTURE, "tankmetal"               , NBT_TANK_CAPACITY,    1728000, NBT_DESIGN, 18007, NBT_GASPROOF, T, NBT_ACIDPROOF, F, NBT_PLASMAPROOF, F, NBT_MAGICPROOF, F                        ), " R ", "hMs", " R ", 'M', aRegistry.getItem(18007), 'R', OP.ring.dat(aMat));
		aMat = MT.Ti;                   aRegistry.add("Small Titanium Tank Main Valve"                      , "Multiblock Machines", 17006, 17101, MultiTileEntityTank3x3x3Metal.class      , aMat.mToolQuality, 16, aMachine   , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   9.0F, NBT_RESISTANCE,   9.0F, NBT_TEXTURE, "tankmetal"               , NBT_TANK_CAPACITY,    3456000, NBT_DESIGN, 18006, NBT_GASPROOF, T, NBT_ACIDPROOF, F, NBT_PLASMAPROOF, F, NBT_MAGICPROOF, F                        ), " R ", "hMs", " R ", 'M', aRegistry.getItem(18006), 'R', OP.ring.dat(aMat));
		aMat = MT.TungstenSteel;        aRegistry.add("Small Tungstensteel Tank Main Valve"                 , "Multiblock Machines", 17003, 17101, MultiTileEntityTank3x3x3Metal.class      , aMat.mToolQuality, 16, aMachine   , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,  12.5F, NBT_RESISTANCE,  12.5F, NBT_TEXTURE, "tankmetal"               , NBT_TANK_CAPACITY,    6912000, NBT_DESIGN, 18003, NBT_GASPROOF, T, NBT_ACIDPROOF, F, NBT_PLASMAPROOF, F, NBT_MAGICPROOF, T                        ), " R ", "hMs", " R ", 'M', aRegistry.getItem(18003), 'R', OP.ring.dat(aMat));
		aMat = ANY.W;                   aRegistry.add("Small Tungsten Tank Main Valve"                      , "Multiblock Machines", 17004, 17101, MultiTileEntityTank3x3x3Metal.class      , aMat.mToolQuality, 16, aMachine   , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,  10.0F, NBT_RESISTANCE,  10.0F, NBT_TEXTURE, "tankmetal"               , NBT_TANK_CAPACITY,    6912000, NBT_DESIGN, 18004, NBT_GASPROOF, T, NBT_ACIDPROOF, T, NBT_PLASMAPROOF, F, NBT_MAGICPROOF, T                        ), " R ", "hMs", " R ", 'M', aRegistry.getItem(18004), 'R', OP.ring.dat(aMat));
		aMat = MT.Ad;                   aRegistry.add("Small Adamantium Tank Main Valve"                    , "Multiblock Machines", 17005, 17101, MultiTileEntityTank3x3x3Metal.class      , aMat.mToolQuality, 16, aMachine   , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS, 100.0F, NBT_RESISTANCE, 100.0F, NBT_TEXTURE, "tankmetal"               , NBT_TANK_CAPACITY,  110592000, NBT_DESIGN, 18005, NBT_GASPROOF, T, NBT_ACIDPROOF, T, NBT_PLASMAPROOF, T, NBT_MAGICPROOF, T                        ), " R ", "hMs", " R ", 'M', aRegistry.getItem(18005), 'R', OP.ring.dat(aMat));
		
		aMat = MT.StainlessSteel;       aRegistry.add("Small Dense Stainless Steel Tank Main Valve"         , "Multiblock Machines", 17022, 17101, MultiTileEntityTank3x3x3Metal.class      , aMat.mToolQuality, 16, aMachine   , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   6.0F, NBT_RESISTANCE,   6.0F, NBT_TEXTURE, "tankmetal"               , NBT_TANK_CAPACITY,    6912000, NBT_DESIGN, 18022, NBT_GASPROOF, T, NBT_ACIDPROOF, T, NBT_PLASMAPROOF, F, NBT_MAGICPROOF, F                        ), " R ", "hMs", " R ", 'M', aRegistry.getItem(18022), 'R', OP.ring.dat(aMat));
		aMat = MT.Invar;                aRegistry.add("Small Dense Invar Tank Main Valve"                   , "Multiblock Machines", 17027, 17101, MultiTileEntityTank3x3x3Metal.class      , aMat.mToolQuality, 16, aMachine   , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   6.0F, NBT_RESISTANCE,   6.0F, NBT_TEXTURE, "tankmetal"               , NBT_TANK_CAPACITY,    6912000, NBT_DESIGN, 18027, NBT_GASPROOF, T, NBT_ACIDPROOF, F, NBT_PLASMAPROOF, F, NBT_MAGICPROOF, F                        ), " R ", "hMs", " R ", 'M', aRegistry.getItem(18027), 'R', OP.ring.dat(aMat));
		aMat = MT.Ti;                   aRegistry.add("Small Dense Titanium Tank Main Valve"                , "Multiblock Machines", 17026, 17101, MultiTileEntityTank3x3x3Metal.class      , aMat.mToolQuality, 16, aMachine   , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   9.0F, NBT_RESISTANCE,   9.0F, NBT_TEXTURE, "tankmetal"               , NBT_TANK_CAPACITY,   13824000, NBT_DESIGN, 18026, NBT_GASPROOF, T, NBT_ACIDPROOF, F, NBT_PLASMAPROOF, F, NBT_MAGICPROOF, F                        ), " R ", "hMs", " R ", 'M', aRegistry.getItem(18026), 'R', OP.ring.dat(aMat));
		aMat = MT.TungstenSteel;        aRegistry.add("Small Dense Tungstensteel Tank Main Valve"           , "Multiblock Machines", 17023, 17101, MultiTileEntityTank3x3x3Metal.class      , aMat.mToolQuality, 16, aMachine   , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,  12.5F, NBT_RESISTANCE,  12.5F, NBT_TEXTURE, "tankmetal"               , NBT_TANK_CAPACITY,   27648000, NBT_DESIGN, 18023, NBT_GASPROOF, T, NBT_ACIDPROOF, F, NBT_PLASMAPROOF, F, NBT_MAGICPROOF, T                        ), " R ", "hMs", " R ", 'M', aRegistry.getItem(18023), 'R', OP.ring.dat(aMat));
		aMat = ANY.W;                   aRegistry.add("Small Dense Tungsten Tank Main Valve"                , "Multiblock Machines", 17024, 17101, MultiTileEntityTank3x3x3Metal.class      , aMat.mToolQuality, 16, aMachine   , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,  10.0F, NBT_RESISTANCE,  10.0F, NBT_TEXTURE, "tankmetal"               , NBT_TANK_CAPACITY,   27648000, NBT_DESIGN, 18024, NBT_GASPROOF, T, NBT_ACIDPROOF, T, NBT_PLASMAPROOF, F, NBT_MAGICPROOF, T                        ), " R ", "hMs", " R ", 'M', aRegistry.getItem(18024), 'R', OP.ring.dat(aMat));
		aMat = MT.Ad;                   aRegistry.add("Small Dense Adamantium Tank Main Valve"              , "Multiblock Machines", 17025, 17101, MultiTileEntityTank3x3x3Metal.class      , aMat.mToolQuality, 16, aMachine   , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS, 100.0F, NBT_RESISTANCE, 100.0F, NBT_TEXTURE, "tankmetal"               , NBT_TANK_CAPACITY,  442368000, NBT_DESIGN, 18025, NBT_GASPROOF, T, NBT_ACIDPROOF, T, NBT_PLASMAPROOF, T, NBT_MAGICPROOF, T                        ), " R ", "hMs", " R ", 'M', aRegistry.getItem(18025), 'R', OP.ring.dat(aMat));
		
		aMat = MT.StainlessSteel;       aRegistry.add("Large Stainless Steel Tank Main Valve"               , "Multiblock Machines", 17042, 17101, MultiTileEntityTank5x5x5Metal.class      , aMat.mToolQuality, 16, aMachine   , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   6.0F, NBT_RESISTANCE,   6.0F, NBT_TEXTURE, "tankmetal"               , NBT_TANK_CAPACITY,    8000000, NBT_DESIGN, 18002, NBT_GASPROOF, T, NBT_ACIDPROOF, T, NBT_PLASMAPROOF, F, NBT_MAGICPROOF, F                        ), "PPP", "hMs", "PPP", 'M', aRegistry.getItem(17002), 'P', OP.plate.dat(aMat));
		aMat = MT.Invar;                aRegistry.add("Large Invar Tank Main Valve"                         , "Multiblock Machines", 17047, 17101, MultiTileEntityTank5x5x5Metal.class      , aMat.mToolQuality, 16, aMachine   , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   6.0F, NBT_RESISTANCE,   6.0F, NBT_TEXTURE, "tankmetal"               , NBT_TANK_CAPACITY,    8000000, NBT_DESIGN, 18007, NBT_GASPROOF, T, NBT_ACIDPROOF, F, NBT_PLASMAPROOF, F, NBT_MAGICPROOF, F                        ), "PPP", "hMs", "PPP", 'M', aRegistry.getItem(17007), 'P', OP.plate.dat(aMat));
		aMat = MT.Ti;                   aRegistry.add("Large Titanium Tank Main Valve"                      , "Multiblock Machines", 17046, 17101, MultiTileEntityTank5x5x5Metal.class      , aMat.mToolQuality, 16, aMachine   , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   9.0F, NBT_RESISTANCE,   9.0F, NBT_TEXTURE, "tankmetal"               , NBT_TANK_CAPACITY,   16000000, NBT_DESIGN, 18006, NBT_GASPROOF, T, NBT_ACIDPROOF, F, NBT_PLASMAPROOF, F, NBT_MAGICPROOF, F                        ), "PPP", "hMs", "PPP", 'M', aRegistry.getItem(17006), 'P', OP.plate.dat(aMat));
		aMat = MT.TungstenSteel;        aRegistry.add("Large Tungstensteel Tank Main Valve"                 , "Multiblock Machines", 17043, 17101, MultiTileEntityTank5x5x5Metal.class      , aMat.mToolQuality, 16, aMachine   , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,  12.5F, NBT_RESISTANCE,  12.5F, NBT_TEXTURE, "tankmetal"               , NBT_TANK_CAPACITY,   32000000, NBT_DESIGN, 18003, NBT_GASPROOF, T, NBT_ACIDPROOF, F, NBT_PLASMAPROOF, F, NBT_MAGICPROOF, T                        ), "PPP", "hMs", "PPP", 'M', aRegistry.getItem(17003), 'P', OP.plate.dat(aMat));
		aMat = ANY.W;                   aRegistry.add("Large Tungsten Tank Main Valve"                      , "Multiblock Machines", 17044, 17101, MultiTileEntityTank5x5x5Metal.class      , aMat.mToolQuality, 16, aMachine   , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,  10.0F, NBT_RESISTANCE,  10.0F, NBT_TEXTURE, "tankmetal"               , NBT_TANK_CAPACITY,   32000000, NBT_DESIGN, 18004, NBT_GASPROOF, T, NBT_ACIDPROOF, T, NBT_PLASMAPROOF, F, NBT_MAGICPROOF, T                        ), "PPP", "hMs", "PPP", 'M', aRegistry.getItem(17004), 'P', OP.plate.dat(aMat));
		aMat = MT.Ad;                   aRegistry.add("Large Adamantium Tank Main Valve"                    , "Multiblock Machines", 17045, 17101, MultiTileEntityTank5x5x5Metal.class      , aMat.mToolQuality, 16, aMachine   , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS, 100.0F, NBT_RESISTANCE, 100.0F, NBT_TEXTURE, "tankmetal"               , NBT_TANK_CAPACITY,  512000000, NBT_DESIGN, 18005, NBT_GASPROOF, T, NBT_ACIDPROOF, T, NBT_PLASMAPROOF, T, NBT_MAGICPROOF, T                        ), "PPP", "hMs", "PPP", 'M', aRegistry.getItem(17005), 'P', OP.plate.dat(aMat));
		
		aMat = MT.StainlessSteel;       aRegistry.add("Large Dense Stainless Steel Tank Main Valve"         , "Multiblock Machines", 17062, 17101, MultiTileEntityTank5x5x5Metal.class      , aMat.mToolQuality, 16, aMachine   , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   6.0F, NBT_RESISTANCE,   6.0F, NBT_TEXTURE, "tankmetal"               , NBT_TANK_CAPACITY,   32000000, NBT_DESIGN, 18022, NBT_GASPROOF, T, NBT_ACIDPROOF, T, NBT_PLASMAPROOF, F, NBT_MAGICPROOF, F                        ), "PPP", "hMs", "PPP", 'M', aRegistry.getItem(17022), 'P', OP.plateDense.dat(aMat));
		aMat = MT.Invar;                aRegistry.add("Large Dense Invar Tank Main Valve"                   , "Multiblock Machines", 17067, 17101, MultiTileEntityTank5x5x5Metal.class      , aMat.mToolQuality, 16, aMachine   , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   6.0F, NBT_RESISTANCE,   6.0F, NBT_TEXTURE, "tankmetal"               , NBT_TANK_CAPACITY,   32000000, NBT_DESIGN, 18027, NBT_GASPROOF, T, NBT_ACIDPROOF, F, NBT_PLASMAPROOF, F, NBT_MAGICPROOF, F                        ), "PPP", "hMs", "PPP", 'M', aRegistry.getItem(17027), 'P', OP.plateDense.dat(aMat));
		aMat = MT.Ti;                   aRegistry.add("Large Dense Titanium Tank Main Valve"                , "Multiblock Machines", 17066, 17101, MultiTileEntityTank5x5x5Metal.class      , aMat.mToolQuality, 16, aMachine   , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   9.0F, NBT_RESISTANCE,   9.0F, NBT_TEXTURE, "tankmetal"               , NBT_TANK_CAPACITY,   64000000, NBT_DESIGN, 18026, NBT_GASPROOF, T, NBT_ACIDPROOF, F, NBT_PLASMAPROOF, F, NBT_MAGICPROOF, F                        ), "PPP", "hMs", "PPP", 'M', aRegistry.getItem(17026), 'P', OP.plateDense.dat(aMat));
		aMat = MT.TungstenSteel;        aRegistry.add("Large Dense Tungstensteel Tank Main Valve"           , "Multiblock Machines", 17063, 17101, MultiTileEntityTank5x5x5Metal.class      , aMat.mToolQuality, 16, aMachine   , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,  12.5F, NBT_RESISTANCE,  12.5F, NBT_TEXTURE, "tankmetal"               , NBT_TANK_CAPACITY,  128000000, NBT_DESIGN, 18023, NBT_GASPROOF, T, NBT_ACIDPROOF, F, NBT_PLASMAPROOF, F, NBT_MAGICPROOF, T                        ), "PPP", "hMs", "PPP", 'M', aRegistry.getItem(17023), 'P', OP.plateDense.dat(aMat));
		aMat = ANY.W;                   aRegistry.add("Large Dense Tungsten Tank Main Valve"                , "Multiblock Machines", 17064, 17101, MultiTileEntityTank5x5x5Metal.class      , aMat.mToolQuality, 16, aMachine   , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,  10.0F, NBT_RESISTANCE,  10.0F, NBT_TEXTURE, "tankmetal"               , NBT_TANK_CAPACITY,  128000000, NBT_DESIGN, 18024, NBT_GASPROOF, T, NBT_ACIDPROOF, T, NBT_PLASMAPROOF, F, NBT_MAGICPROOF, T                        ), "PPP", "hMs", "PPP", 'M', aRegistry.getItem(17024), 'P', OP.plateDense.dat(aMat));
		aMat = MT.Ad;                   aRegistry.add("Large Dense Adamantium Tank Main Valve"              , "Multiblock Machines", 17065, 17101, MultiTileEntityTank5x5x5Metal.class      , aMat.mToolQuality, 16, aMachine   , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS, 100.0F, NBT_RESISTANCE, 100.0F, NBT_TEXTURE, "tankmetal"               , NBT_TANK_CAPACITY, 2048000000, NBT_DESIGN, 18025, NBT_GASPROOF, T, NBT_ACIDPROOF, T, NBT_PLASMAPROOF, T, NBT_MAGICPROOF, T                        ), "PPP", "hMs", "PPP", 'M', aRegistry.getItem(17025), 'P', OP.plateDense.dat(aMat));
		
		
		
		aMat = MT.StainlessSteel;       aRegistry.add("Distillation Tower"                                  , "Multiblock Machines", 17101, 17101, MultiTileEntityDistillationTower.class   , aMat.mToolQuality, 16, aMachine   , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   6.0F, NBT_RESISTANCE,   6.0F, NBT_TEXTURE, "distillationtower"       , NBT_INPUT,  512, NBT_INPUT_MIN,    1, NBT_INPUT_MAX,     1024                       , NBT_ENERGY_ACCEPTED, TD.Energy.HU, NBT_RECIPEMAP, RM.DistillationTower    , NBT_INV_SIDE_AUTO_OUT, SIDE_BACK  , NBT_TANK_SIDE_AUTO_OUT, SIDE_BACK  , NBT_CHEAP_OVERCLOCKING, T                                                                       ), "PPP", "PMP", "PPP", 'M', aRegistry.getItem(18102), 'P', OP.pipeNonuple.dat(aMat));
		aMat = MT.StainlessSteel;       aRegistry.add("Cryo Distillation Tower"                             , "Multiblock Machines", 17111, 17101, MultiTileEntityCryoDistillationTower.class,aMat.mToolQuality, 16, aMachine   , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   6.0F, NBT_RESISTANCE,   6.0F, NBT_TEXTURE, "cryodistillationtower"   , NBT_INPUT,  512, NBT_INPUT_MIN,    1, NBT_INPUT_MAX,     1024                       , NBT_ENERGY_ACCEPTED, TD.Energy.CU, NBT_RECIPEMAP, RM.CryoDistillationTower, NBT_INV_SIDE_AUTO_OUT, SIDE_BACK  , NBT_TANK_SIDE_AUTO_OUT, SIDE_BACK  , NBT_CHEAP_OVERCLOCKING, T                                                                       ), "PPP", "PMP", "PPP", 'M', aRegistry.getItem(18102), 'P', OP.pipeNonuple.dat(ANY.Cu));
		aMat = MT.TungstenSteel;        aRegistry.add("Implosion Compressor"                                , "Multiblock Machines", 17110, 17101, MultiTileEntityImplosionCompressor.class , aMat.mToolQuality, 16, aMachine   , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,  12.5F, NBT_RESISTANCE,  12.5F, NBT_TEXTURE, "implosioncompressor"     , NBT_INPUT,    1, NBT_INPUT_MIN,    1, NBT_INPUT_MAX,       16                       , NBT_ENERGY_ACCEPTED, TD.Energy.TU, NBT_RECIPEMAP, RM.ImplosionCompressor  , NBT_INV_SIDE_AUTO_OUT, SIDE_BOTTOM, NBT_TANK_SIDE_AUTO_OUT, SIDE_BOTTOM                           , NBT_PARALLEL,  64                          , NBT_NO_CONSTANT_POWER, T), "CPC", "PAP", "RMR", 'M', aRegistry.getItem(18023), 'R', IL.Processor_Crystal_Ruby, 'C', OD_CIRCUITS[6], 'P', OP.plateDense.dat(aMat), 'A', IL.ROBOT_ARMS[2]);
		aMat = MT.TungstenSteel;        aRegistry.add("Large Centrifuge"                                    , "Multiblock Machines", 17100, 17101, MultiTileEntityCentrifuge.class          , aMat.mToolQuality, 16, aMachine   , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,  12.5F, NBT_RESISTANCE,  12.5F, NBT_TEXTURE, "largecentrifuge"         , NBT_INPUT,  512, NBT_INPUT_MIN,  512, NBT_INPUT_MAX,     4096, NBT_EFFICIENCY,  5000, NBT_ENERGY_ACCEPTED, TD.Energy.RU, NBT_RECIPEMAP, RM.Centrifuge           , NBT_INV_SIDE_AUTO_OUT, SIDE_BOTTOM, NBT_TANK_SIDE_AUTO_OUT, SIDE_BOTTOM, NBT_CHEAP_OVERCLOCKING, T, NBT_PARALLEL,  16, NBT_PARALLEL_DURATION, T                          ), "CMC", "RCR"       , 'M', aRegistry.getItem(18100), 'R', IL.Processor_Crystal_Ruby, 'C', OD_CIRCUITS[6]);
		aMat = MT.StainlessSteel;       aRegistry.add("Large Electrolyzer"                                  , "Multiblock Machines", 17103, 17101, MultiTileEntityElectrolyzer.class        , aMat.mToolQuality, 16, aMachine   , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   6.0F, NBT_RESISTANCE,   6.0F, NBT_TEXTURE, "largeelectrolyzer"       , NBT_INPUT,  512, NBT_INPUT_MIN,  512, NBT_INPUT_MAX,     4096, NBT_EFFICIENCY,  5000, NBT_ENERGY_ACCEPTED, TD.Energy.EU, NBT_RECIPEMAP, RM.Electrolyzer         , NBT_INV_SIDE_AUTO_OUT, SIDE_BOTTOM, NBT_TANK_SIDE_AUTO_OUT, SIDE_BOTTOM, NBT_CHEAP_OVERCLOCKING, T, NBT_PARALLEL,  16, NBT_PARALLEL_DURATION, T                          ), "CMC", "RCR"       , 'M', aRegistry.getItem(18105), 'R', IL.Processor_Crystal_Ruby, 'C', OD_CIRCUITS[6]);
		aMat = MT.StainlessSteel;       aRegistry.add("Large Coagulator Array"                              , "Multiblock Machines", 17105, 17101, MultiTileEntityCoagulator.class          , aMat.mToolQuality, 16, aMachine   , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   6.0F, NBT_RESISTANCE,   6.0F, NBT_TEXTURE, "largecoagulator"         , NBT_INPUT,    1, NBT_INPUT_MIN,    1, NBT_INPUT_MAX,       16                       , NBT_ENERGY_ACCEPTED, TD.Energy.TU, NBT_RECIPEMAP, RM.Coagulator           , NBT_INV_SIDE_AUTO_OUT, SIDE_BOTTOM, NBT_TANK_SIDE_AUTO_OUT, SIDE_BOTTOM                           , NBT_PARALLEL,  64                          , NBT_NO_CONSTANT_POWER, T), "CRC", "PMP", "PPP", 'M', aRegistry.getItem(18002), 'R', IL.Processor_Crystal_Ruby, 'C', OD_CIRCUITS[6], 'P', OP.plateDense.dat(aMat));
		aMat = MT.StainlessSteel;       aRegistry.add("Large Autoclave"                                     , "Multiblock Machines", 17112, 17101, MultiTileEntityAutoclave.class           , aMat.mToolQuality, 16, aMachine   , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   6.0F, NBT_RESISTANCE,   6.0F, NBT_TEXTURE, "largeautoclave"          , NBT_INPUT,    1, NBT_INPUT_MIN,    1, NBT_INPUT_MAX,       16                       , NBT_ENERGY_ACCEPTED, TD.Energy.TU, NBT_RECIPEMAP, RM.Autoclave            , NBT_INV_SIDE_AUTO_OUT, SIDE_BOTTOM, NBT_TANK_SIDE_AUTO_OUT, SIDE_BOTTOM                           , NBT_PARALLEL,  16                          , NBT_NO_CONSTANT_POWER, T), "CRC", "PMP", "PPP", 'M', aRegistry.getItem(18022), 'R', IL.Processor_Crystal_Ruby, 'C', OD_CIRCUITS[6], 'P', OP.plateDense.dat(aMat));
		aMat = MT.StainlessSteel;       aRegistry.add("Large Bathing Vat"                                   , "Multiblock Machines", 17104, 17101, MultiTileEntityBath.class                , aMat.mToolQuality, 16, aMachine   , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   6.0F, NBT_RESISTANCE,   6.0F, NBT_TEXTURE, "largebath"               , NBT_INPUT,    1, NBT_INPUT_MIN,    1, NBT_INPUT_MAX,       16                       , NBT_ENERGY_ACCEPTED, TD.Energy.TU, NBT_RECIPEMAP, RM.Bath                 , NBT_INV_SIDE_AUTO_OUT, SIDE_BOTTOM, NBT_TANK_SIDE_AUTO_OUT, SIDE_BOTTOM                           , NBT_PARALLEL,  64                          , NBT_NO_CONSTANT_POWER, T), "CRC", "PMP", "APA", 'M', aRegistry.getItem(18002), 'R', IL.Processor_Crystal_Ruby, 'C', OD_CIRCUITS[6], 'P', OP.plateDense.dat(aMat), 'A', IL.ROBOT_ARMS[2]);
		aMat = MT.StainlessSteel;       aRegistry.add("Large Batch Mixer"                                   , "Multiblock Machines", 17102, 17101, MultiTileEntityMixer.class               , aMat.mToolQuality, 16, aMachine   , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   6.0F, NBT_RESISTANCE,   6.0F, NBT_TEXTURE, "largemixer"              , NBT_INPUT,  512, NBT_INPUT_MIN,  512, NBT_INPUT_MAX,     4096                       , NBT_ENERGY_ACCEPTED, TD.Energy.RU, NBT_RECIPEMAP, RM.Mixer                , NBT_INV_SIDE_AUTO_OUT, SIDE_BOTTOM, NBT_TANK_SIDE_AUTO_OUT, SIDE_BOTTOM, NBT_CHEAP_OVERCLOCKING, T, NBT_PARALLEL, 256, NBT_PARALLEL_DURATION, T                          ), "PSP", "PSP", "RMC", 'M', aRegistry.getItem(18002), 'R', IL.Processor_Crystal_Ruby, 'C', OD_CIRCUITS[6], 'P', OP.plateDense.dat(aMat), 'S', OP.stickLong.dat(aMat));
		aMat = MT.StainlessSteel;       aRegistry.add("Large Fermenter"                                     , "Multiblock Machines", 17113, 17101, MultiTileEntityFermenter.class           , aMat.mToolQuality, 16, aMachine   , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   6.0F, NBT_RESISTANCE,   6.0F, NBT_TEXTURE, "largefermenter"          , NBT_INPUT,  512, NBT_INPUT_MIN,    1, NBT_INPUT_MAX,     4096                       , NBT_ENERGY_ACCEPTED, TD.Energy.HU, NBT_RECIPEMAP, RM.Fermenter            , NBT_INV_SIDE_AUTO_OUT, SIDE_BACK  , NBT_TANK_SIDE_AUTO_OUT, SIDE_BACK  , NBT_CHEAP_OVERCLOCKING, T, NBT_PARALLEL, 256, NBT_PARALLEL_DURATION, T                          ), "PPP", "CRC", "PMP", 'M', aRegistry.getItem(18002), 'R', IL.Processor_Crystal_Ruby, 'C', OD_CIRCUITS[6], 'P', OP.plateDense.dat(aMat));
		aMat = MT.Invar;                aRegistry.add("Large Electric Oven"                                 , "Multiblock Machines", 17106, 17101, MultiTileEntityOven.class                , aMat.mToolQuality, 16, aMachine   , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   6.0F, NBT_RESISTANCE,   6.0F, NBT_TEXTURE, "largeoven"               , NBT_INPUT,  512, NBT_INPUT_MIN,  512, NBT_INPUT_MAX,     4096, NBT_EFFICIENCY,  2500, NBT_ENERGY_ACCEPTED, TD.Energy.EU, NBT_RECIPEMAP, RM.Furnace              , NBT_INV_SIDE_AUTO_OUT, SIDE_BOTTOM, NBT_TANK_SIDE_AUTO_OUT, SIDE_BOTTOM, NBT_CHEAP_OVERCLOCKING, T, NBT_PARALLEL,  64, NBT_PARALLEL_DURATION, T                          ), "PPP", "PwP", "RMC", 'M', aRegistry.getItem(18007), 'R', IL.Processor_Crystal_Ruby, 'C', OD_CIRCUITS[6], 'P', OP.plateDense.dat(aMat));
		aMat = MT.Ti;                   aRegistry.add("Large Sluice"                                        , "Multiblock Machines", 17107, 17101, MultiTileEntitySluice.class              , aMat.mToolQuality, 16, aMachine   , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   9.0F, NBT_RESISTANCE,   9.0F, NBT_TEXTURE, "largesluice"             , NBT_INPUT,  512, NBT_INPUT_MIN,  512, NBT_INPUT_MAX,     4096, NBT_EFFICIENCY,  5000, NBT_ENERGY_ACCEPTED, TD.Energy.RU, NBT_RECIPEMAP, RM.Sluice               , NBT_INV_SIDE_AUTO_OUT, SIDE_BOTTOM, NBT_TANK_SIDE_AUTO_OUT, SIDE_BOTTOM, NBT_CHEAP_OVERCLOCKING, T, NBT_PARALLEL,  64, NBT_PARALLEL_DURATION, T                          ), "GGG", "SwS", "RMC", 'M', aRegistry.getItem(18006), 'R', IL.Processor_Crystal_Ruby, 'C', OD_CIRCUITS[6], 'G', OP.gearGt.dat(aMat), 'S', OP.stick.dat(aMat));
		aMat = MT.TungstenSteel;        aRegistry.add("Large Crusher"                                       , "Multiblock Machines", 17108, 17101, MultiTileEntityCrusher.class             , aMat.mToolQuality, 16, aMachine   , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,  12.5F, NBT_RESISTANCE,  12.5F, NBT_TEXTURE, "largecrusher"            , NBT_INPUT,  512, NBT_INPUT_MIN,  512, NBT_INPUT_MAX,     4096, NBT_EFFICIENCY,  5000, NBT_ENERGY_ACCEPTED, TD.Energy.RU, NBT_RECIPEMAP, RM.Crusher              , NBT_INV_SIDE_AUTO_OUT, SIDE_BOTTOM, NBT_TANK_SIDE_AUTO_OUT, SIDE_BOTTOM, NBT_CHEAP_OVERCLOCKING, T, NBT_PARALLEL,  64, NBT_PARALLEL_DURATION, T, NBT_NO_CONSTANT_POWER, T), "GSG", "SGS", "RMC", 'M', aRegistry.getItem(18003), 'R', IL.Processor_Crystal_Ruby, 'C', OD_CIRCUITS[6], 'G', OP.gearGt.dat(aMat), 'S', OP.gearGtSmall.dat(aMat));
		aMat = MT.TungstenSteel;        aRegistry.add("Large Shredder"                                      , "Multiblock Machines", 17109, 17101, MultiTileEntityShredder.class            , aMat.mToolQuality, 16, aMachine   , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,  12.5F, NBT_RESISTANCE,  12.5F, NBT_TEXTURE, "largeshredder"           , NBT_INPUT,  512, NBT_INPUT_MIN,  512, NBT_INPUT_MAX,     4096, NBT_EFFICIENCY,  5000, NBT_ENERGY_ACCEPTED, TD.Energy.RU, NBT_RECIPEMAP, RM.Shredder             , NBT_INV_SIDE_AUTO_OUT, SIDE_BOTTOM, NBT_TANK_SIDE_AUTO_OUT, SIDE_BOTTOM, NBT_CHEAP_OVERCLOCKING, T, NBT_PARALLEL,  64, NBT_PARALLEL_DURATION, T, NBT_NO_CONSTANT_POWER, T), "SGS", "GSG", "RMC", 'M', aRegistry.getItem(18003), 'R', IL.Processor_Crystal_Ruby, 'C', OD_CIRCUITS[6], 'G', OP.gearGt.dat(aMat), 'S', OP.gearGtSmall.dat(aMat));
		aMat = ANY.Steel;               aRegistry.add("Large Squeezer"                                      , "Multiblock Machines", 17114, 17101, MultiTileEntitySqueezer.class            , aMat.mToolQuality, 16, aMachine   , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   6.0F, NBT_RESISTANCE,   6.0F, NBT_TEXTURE, "largesqueezer"           , NBT_INPUT,  512, NBT_INPUT_MIN,  512, NBT_INPUT_MAX,     4096, NBT_EFFICIENCY,  5000, NBT_ENERGY_ACCEPTED, TD.Energy.RU, NBT_RECIPEMAP, RM.Squeezer             , NBT_INV_SIDE_AUTO_OUT, SIDE_BOTTOM, NBT_TANK_SIDE_AUTO_OUT, SIDE_BOTTOM, NBT_CHEAP_OVERCLOCKING, T, NBT_PARALLEL,  64, NBT_PARALLEL_DURATION, T, NBT_NO_CONSTANT_POWER, T), "GSG", "GSG", "RMC", 'M', aRegistry.getItem(18009), 'R', IL.Processor_Crystal_Ruby, 'C', OD_CIRCUITS[6], 'G', OP.gearGt.dat(aMat), 'S', OP.gearGtSmall.dat(aMat));
		aMat = MT.Pb;                   aRegistry.add("Large Matter Fabricator"                             , "Multiblock Machines", 17199, 17101, MultiTileEntityMatterFabricator.class    , aMat.mToolQuality, 16, aMachine   , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   6.0F, NBT_RESISTANCE,   6.0F, NBT_TEXTURE, "largemassfab"            , NBT_INPUT,    1, NBT_INPUT_MIN,    1, NBT_INPUT_MAX,  2097152                       , NBT_ENERGY_ACCEPTED, TD.Energy.QU, NBT_RECIPEMAP, RM.Massfab              , NBT_INV_SIDE_AUTO_OUT, SIDE_BOTTOM, NBT_TANK_SIDE_AUTO_OUT, SIDE_BOTTOM, NBT_CHEAP_OVERCLOCKING, T, NBT_PARALLEL,  64, NBT_PARALLEL_DURATION, T, NBT_NO_CONSTANT_POWER, T), "FFF", "FMF", "FFF", 'M', aRegistry.getItem(18031), 'F', IL.FIELD_GENERATORS[5]);
		aMat = MT.SteelGalvanized;      aRegistry.add("Fusion Reactor"                                      , "Multiblock Machines", 17198, 17101, MultiTileEntityFusionReactor.class       , aMat.mToolQuality, 16, aMachine   , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,  12.5F, NBT_RESISTANCE,  12.5F, NBT_TEXTURE, "fusionreactor"           , NBT_INPUT, 8192, NBT_INPUT_MIN,    1, NBT_INPUT_MAX,    16384                       , NBT_ENERGY_ACCEPTED, TD.Energy.TU, NBT_RECIPEMAP, RM.Fusion               , NBT_ENERGY_ACCEPTED_2, TD.Energy.LU, NBT_ENERGY_EMITTED, TD.Energy.EU, NBT_SPECIAL_IS_START_ENERGY, T, NBT_NO_CONSTANT_POWER, T), "FFF", "FMF", "FFF", 'M', aRegistry.getItem(18003), 'F', IL.FIELD_GENERATORS[5]);
		
		
		aMat = ANY.W;                   aRegistry.add("Large Heat Exchanger"                                , "Multiblock Machines", 17197, 17101, MultiTileEntityLargeHeatExchanger.class  , aMat.mToolQuality, 16, aMachine   , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   6.0F, NBT_RESISTANCE,   6.0F, NBT_TEXTURE, "largeheatexchanger"      , NBT_OUTPUT, 16384, NBT_FUELMAP, FM.Hot, NBT_ENERGY_EMITTED, TD.Energy.HU), "DDD", "PMP", "DDD", 'M', aRegistry.getItem(18024), 'D', OP.plateDense.dat(MT.AnnealedCopper), 'P', OP.pipeHuge.dat(ANY.Cu));
		
		
		aMat = MT.StainlessSteel;       aRegistry.add("Stainless Steel Boiler Main Barometer"               , "Multiblock Machines", 17201, 17101, MultiTileEntityLargeBoiler.class         , aMat.mToolQuality, 16, aMachine   , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   6.0F, NBT_RESISTANCE,   6.0F, NBT_TEXTURE, "largeboiler"             , NBT_DESIGN, 18022, NBT_CAPACITY,  40960000, NBT_CAPACITY_SU,  40960000, NBT_OUTPUT_SU,  4096*STEAM_PER_EU), "PPh", "PMP", "wPP", 'M', aRegistry.getItem(18022), 'P', OP.plateDense.dat(aMat));
		aMat = MT.Invar;                aRegistry.add("Invar Boiler Main Barometer"                         , "Multiblock Machines", 17205, 17101, MultiTileEntityLargeBoiler.class         , aMat.mToolQuality, 16, aMachine   , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   6.0F, NBT_RESISTANCE,   6.0F, NBT_TEXTURE, "largeboiler"             , NBT_DESIGN, 18027, NBT_CAPACITY,  40960000, NBT_CAPACITY_SU,  40960000, NBT_OUTPUT_SU,  4096*STEAM_PER_EU), "PPh", "PMP", "wPP", 'M', aRegistry.getItem(18027), 'P', OP.plateDense.dat(aMat));
		aMat = MT.Ti;                   aRegistry.add("Titanium Boiler Main Barometer"                      , "Multiblock Machines", 17202, 17101, MultiTileEntityLargeBoiler.class         , aMat.mToolQuality, 16, aMachine   , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   9.0F, NBT_RESISTANCE,   9.0F, NBT_TEXTURE, "largeboiler"             , NBT_DESIGN, 18026, NBT_CAPACITY,  81920000, NBT_CAPACITY_SU,  81920000, NBT_OUTPUT_SU,  8192*STEAM_PER_EU), "PPh", "PMP", "wPP", 'M', aRegistry.getItem(18026), 'P', OP.plateDense.dat(aMat));
		aMat = MT.TungstenSteel;        aRegistry.add("Tungstensteel Boiler Main Barometer"                 , "Multiblock Machines", 17203, 17101, MultiTileEntityLargeBoiler.class         , aMat.mToolQuality, 16, aMachine   , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,  12.5F, NBT_RESISTANCE,  12.5F, NBT_TEXTURE, "largeboiler"             , NBT_DESIGN, 18023, NBT_CAPACITY, 163840000, NBT_CAPACITY_SU, 163840000, NBT_OUTPUT_SU, 16384*STEAM_PER_EU), "PPh", "PMP", "wPP", 'M', aRegistry.getItem(18023), 'P', OP.plateDense.dat(aMat));
		aMat = MT.Ad;                   aRegistry.add("Adamantium Boiler Main Barometer"                    , "Multiblock Machines", 17204, 17101, MultiTileEntityLargeBoiler.class         , aMat.mToolQuality, 16, aMachine   , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS, 100.0F, NBT_RESISTANCE, 100.0F, NBT_TEXTURE, "largeboiler"             , NBT_DESIGN, 18025, NBT_CAPACITY,1310720000, NBT_CAPACITY_SU,1310720000, NBT_OUTPUT_SU,131072*STEAM_PER_EU), "PPh", "PMP", "wPP", 'M', aRegistry.getItem(18025), 'P', OP.plateDense.dat(aMat));
		
		aMat = MT.StainlessSteel;       aRegistry.add("Magnalium Steam Turbine Main Housing"                , "Multiblock Machines", 17211, 17101, MultiTileEntityLargeTurbineSteam.class   , aMat.mToolQuality, 16, aMachine   , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   6.0F, NBT_RESISTANCE,   6.0F, NBT_TEXTURE, "largeturbine"            , NBT_DESIGN, 18022, NBT_INPUT,   6144*STEAM_PER_EU, NBT_OUTPUT,   4096, NBT_WASTE_ENERGY, T, NBT_ENERGY_ACCEPTED, TD.Energy.STEAM, NBT_ENERGY_EMITTED, TD.Energy.RU), "PPP", "PMP", "PPP", 'M', aRegistry.getItem(18022), 'P', OP.blockPlate.dat(MT.Magnalium));
		aMat = MT.Ti;                   aRegistry.add("Trinitanium Steam Turbine Main Housing"              , "Multiblock Machines", 17212, 17101, MultiTileEntityLargeTurbineSteam.class   , aMat.mToolQuality, 16, aMachine   , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   9.0F, NBT_RESISTANCE,   9.0F, NBT_TEXTURE, "largeturbine"            , NBT_DESIGN, 18026, NBT_INPUT,  12288*STEAM_PER_EU, NBT_OUTPUT,   8192, NBT_WASTE_ENERGY, T, NBT_ENERGY_ACCEPTED, TD.Energy.STEAM, NBT_ENERGY_EMITTED, TD.Energy.RU), "PPP", "PMP", "PPP", 'M', aRegistry.getItem(18026), 'P', OP.blockPlate.dat(MT.Trinitanium));
		aMat = MT.TungstenSteel;        aRegistry.add("Graphene Steam Turbine Main Housing"                 , "Multiblock Machines", 17213, 17101, MultiTileEntityLargeTurbineSteam.class   , aMat.mToolQuality, 16, aMachine   , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,  12.5F, NBT_RESISTANCE,  12.5F, NBT_TEXTURE, "largeturbine"            , NBT_DESIGN, 18023, NBT_INPUT,  24576*STEAM_PER_EU, NBT_OUTPUT,  16384, NBT_WASTE_ENERGY, T, NBT_ENERGY_ACCEPTED, TD.Energy.STEAM, NBT_ENERGY_EMITTED, TD.Energy.RU), "PPP", "PMP", "PPP", 'M', aRegistry.getItem(18023), 'P', OP.blockPlate.dat(MT.Graphene));
		aMat = MT.Ad;                   aRegistry.add("Vibramantium Steam Turbine Main Housing"             , "Multiblock Machines", 17214, 17101, MultiTileEntityLargeTurbineSteam.class   , aMat.mToolQuality, 16, aMachine   , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS, 100.0F, NBT_RESISTANCE, 100.0F, NBT_TEXTURE, "largeturbine"            , NBT_DESIGN, 18025, NBT_INPUT, 196608*STEAM_PER_EU, NBT_OUTPUT, 131072, NBT_WASTE_ENERGY, T, NBT_ENERGY_ACCEPTED, TD.Energy.STEAM, NBT_ENERGY_EMITTED, TD.Energy.RU), "PPP", "PMP", "PPP", 'M', aRegistry.getItem(18025), 'P', OP.blockPlate.dat(MT.Vibramantium));
		
		aMat = MT.StainlessSteel;       aRegistry.add("Stainless Steel Dynamo Main Housing"                 , "Multiblock Machines", 17221, 17101, MultiTileEntityLargeDynamo.class         , aMat.mToolQuality, 16, aMachine   , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   6.0F, NBT_RESISTANCE,   6.0F, NBT_TEXTURE, "largedynamo"             , NBT_DESIGN, 18022, NBT_INPUT,   4096, NBT_OUTPUT,   3072, NBT_WASTE_ENERGY, T, NBT_ENERGY_ACCEPTED, TD.Energy.RU, NBT_ENERGY_EMITTED, TD.Energy.EU), "SwS", "CMC", "SBS", 'M', aRegistry.getItem(18022), 'S', OP.stickLong.dat(aMat), 'C', OD_CIRCUITS[6], 'B', "gt:re-battery1");
		aMat = MT.Ti;                   aRegistry.add("Titanium Dynamo Main Housing"                        , "Multiblock Machines", 17222, 17101, MultiTileEntityLargeDynamo.class         , aMat.mToolQuality, 16, aMachine   , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   9.0F, NBT_RESISTANCE,   9.0F, NBT_TEXTURE, "largedynamo"             , NBT_DESIGN, 18026, NBT_INPUT,   8192, NBT_OUTPUT,   6144, NBT_WASTE_ENERGY, T, NBT_ENERGY_ACCEPTED, TD.Energy.RU, NBT_ENERGY_EMITTED, TD.Energy.EU), "SwS", "CMC", "SBS", 'M', aRegistry.getItem(18026), 'S', OP.stickLong.dat(aMat), 'C', OD_CIRCUITS[6], 'B', "gt:re-battery1");
		aMat = MT.TungstenSteel;        aRegistry.add("Tungstensteel Dynamo Main Housing"                   , "Multiblock Machines", 17223, 17101, MultiTileEntityLargeDynamo.class         , aMat.mToolQuality, 16, aMachine   , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,  12.5F, NBT_RESISTANCE,  12.5F, NBT_TEXTURE, "largedynamo"             , NBT_DESIGN, 18023, NBT_INPUT,  16384, NBT_OUTPUT,  12288, NBT_WASTE_ENERGY, T, NBT_ENERGY_ACCEPTED, TD.Energy.RU, NBT_ENERGY_EMITTED, TD.Energy.EU), "SwS", "CMC", "SBS", 'M', aRegistry.getItem(18023), 'S', OP.stickLong.dat(aMat), 'C', OD_CIRCUITS[6], 'B', "gt:re-battery1");
		aMat = MT.Ad;                   aRegistry.add("Adamantium Dynamo Main Housing"                      , "Multiblock Machines", 17224, 17101, MultiTileEntityLargeDynamo.class         , aMat.mToolQuality, 16, aMachine   , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS, 100.0F, NBT_RESISTANCE, 100.0F, NBT_TEXTURE, "largedynamo"             , NBT_DESIGN, 18025, NBT_INPUT, 131072, NBT_OUTPUT,  98304, NBT_WASTE_ENERGY, T, NBT_ENERGY_ACCEPTED, TD.Energy.RU, NBT_ENERGY_EMITTED, TD.Energy.EU), "SwS", "CMC", "SBS", 'M', aRegistry.getItem(18025), 'S', OP.stickLong.dat(aMat), 'C', OD_CIRCUITS[6], 'B', "gt:re-battery1");
		
		aMat = MT.StainlessSteel;       aRegistry.add("Magnalium Gas Turbine Main Housing"                  , "Multiblock Machines", 17231, 17101, MultiTileEntityLargeTurbineGas.class     , aMat.mToolQuality, 16, aMachine   , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   6.0F, NBT_RESISTANCE,   6.0F, NBT_TEXTURE, "gasturbine"              , NBT_DESIGN, 18022, NBT_INPUT,   6144, NBT_OUTPUT,   4096, NBT_WASTE_ENERGY, F, NBT_LIMIT_CONSUMPTION, T, NBT_ENERGY_ACCEPTED, TD.Energy.HU, NBT_ENERGY_EMITTED, TD.Energy.RU, NBT_FUELMAP, FM.Gas), "PwP", "BMC", "PEP", 'M', aRegistry.getItem(17211), 'B', "gt:re-battery1", 'C', OD_CIRCUITS[6], 'E', IL.MOTORS[1], 'P', OP.plateDense.dat(MT.Invar));
		aMat = MT.Ti;                   aRegistry.add("Trinitanium Gas Turbine Main Housing"                , "Multiblock Machines", 17232, 17101, MultiTileEntityLargeTurbineGas.class     , aMat.mToolQuality, 16, aMachine   , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   9.0F, NBT_RESISTANCE,   9.0F, NBT_TEXTURE, "gasturbine"              , NBT_DESIGN, 18026, NBT_INPUT,  12288, NBT_OUTPUT,   8192, NBT_WASTE_ENERGY, F, NBT_LIMIT_CONSUMPTION, T, NBT_ENERGY_ACCEPTED, TD.Energy.HU, NBT_ENERGY_EMITTED, TD.Energy.RU, NBT_FUELMAP, FM.Gas), "PwP", "BMC", "PEP", 'M', aRegistry.getItem(17212), 'B', "gt:re-battery2", 'C', OD_CIRCUITS[6], 'E', IL.MOTORS[2], 'P', OP.plateDense.dat(MT.TungstenSteel));
		aMat = MT.TungstenSteel;        aRegistry.add("Graphene Gas Turbine Main Housing"                   , "Multiblock Machines", 17233, 17101, MultiTileEntityLargeTurbineGas.class     , aMat.mToolQuality, 16, aMachine   , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,  12.5F, NBT_RESISTANCE,  12.5F, NBT_TEXTURE, "gasturbine"              , NBT_DESIGN, 18023, NBT_INPUT,  24576, NBT_OUTPUT,  16384, NBT_WASTE_ENERGY, F, NBT_LIMIT_CONSUMPTION, T, NBT_ENERGY_ACCEPTED, TD.Energy.HU, NBT_ENERGY_EMITTED, TD.Energy.RU, NBT_FUELMAP, FM.Gas), "PwP", "BMC", "PEP", 'M', aRegistry.getItem(17213), 'B', "gt:re-battery3", 'C', OD_CIRCUITS[6], 'E', IL.MOTORS[3], 'P', OP.plateDense.dat(MT.W));
		aMat = MT.Ad;                   aRegistry.add("Vibramantium Gas Turbine Main Housing"               , "Multiblock Machines", 17234, 17101, MultiTileEntityLargeTurbineGas.class     , aMat.mToolQuality, 16, aMachine   , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS, 100.0F, NBT_RESISTANCE, 100.0F, NBT_TEXTURE, "gasturbine"              , NBT_DESIGN, 18025, NBT_INPUT, 196608, NBT_OUTPUT, 131072, NBT_WASTE_ENERGY, F, NBT_LIMIT_CONSUMPTION, T, NBT_ENERGY_ACCEPTED, TD.Energy.HU, NBT_ENERGY_EMITTED, TD.Energy.RU, NBT_FUELMAP, FM.Gas), "PwP", "BMC", "PEP", 'M', aRegistry.getItem(17214), 'B', "gt:re-battery4", 'C', OD_CIRCUITS[6], 'E', IL.MOTORS[4], 'P', OP.plateDense.dat(MT.Ad));
		
		
		aMat = MT.Steel;                aRegistry.add("Large Steel Crucible"                                , "Multiblock Machines", 17309, 17101, MultiTileEntityCrucible.class            , aMat.mToolQuality, 16, aMachine   , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   6.0F, NBT_RESISTANCE,   6.0F, NBT_TEXTURE, "crucible"                , NBT_DESIGN, 18009, NBT_ACIDPROOF, F), "hMy", 'M', aRegistry.getItem(18009));
		aMat = MT.StainlessSteel;       aRegistry.add("Large Stainless Steel Crucible"                      , "Multiblock Machines", 17302, 17101, MultiTileEntityCrucible.class            , aMat.mToolQuality, 16, aMachine   , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   6.0F, NBT_RESISTANCE,   6.0F, NBT_TEXTURE, "crucible"                , NBT_DESIGN, 18002, NBT_ACIDPROOF, T), "hMy", 'M', aRegistry.getItem(18002));
		aMat = MT.Invar;                aRegistry.add("Large Invar Crucible"                                , "Multiblock Machines", 17307, 17101, MultiTileEntityCrucible.class            , aMat.mToolQuality, 16, aMachine   , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   6.0F, NBT_RESISTANCE,   6.0F, NBT_TEXTURE, "crucible"                , NBT_DESIGN, 18007, NBT_ACIDPROOF, F), "hMy", 'M', aRegistry.getItem(18007));
		aMat = MT.Ti;                   aRegistry.add("Large Titanium Crucible"                             , "Multiblock Machines", 17306, 17101, MultiTileEntityCrucible.class            , aMat.mToolQuality, 16, aMachine   , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   9.0F, NBT_RESISTANCE,   9.0F, NBT_TEXTURE, "crucible"                , NBT_DESIGN, 18006, NBT_ACIDPROOF, F), "hMy", 'M', aRegistry.getItem(18006));
		aMat = MT.TungstenSteel;        aRegistry.add("Large Tungstensteel Crucible"                        , "Multiblock Machines", 17303, 17101, MultiTileEntityCrucible.class            , aMat.mToolQuality, 16, aMachine   , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,  12.5F, NBT_RESISTANCE,  12.5F, NBT_TEXTURE, "crucible"                , NBT_DESIGN, 18003, NBT_ACIDPROOF, F), "hMy", 'M', aRegistry.getItem(18003));
		aMat = ANY.W;                   aRegistry.add("Large Tungsten Crucible"                             , "Multiblock Machines", 17304, 17101, MultiTileEntityCrucible.class            , aMat.mToolQuality, 16, aMachine   , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,  10.0F, NBT_RESISTANCE,  10.0F, NBT_TEXTURE, "crucible"                , NBT_DESIGN, 18004, NBT_ACIDPROOF, T), "hMy", 'M', aRegistry.getItem(18004));
		aMat = MT.Ta4HfC5;              aRegistry.add("Large Tantalum Hafnium Carbide Crucible"             , "Multiblock Machines", 17312, 17101, MultiTileEntityCrucible.class            , aMat.mToolQuality, 16, aMachine   , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,  12.5F, NBT_RESISTANCE,  12.5F, NBT_TEXTURE, "crucible"                , NBT_DESIGN, 18012, NBT_ACIDPROOF, F), "hMy", 'M', aRegistry.getItem(18012));
		aMat = MT.Ad;                   aRegistry.add("Large Adamantium Crucible"                           , "Multiblock Machines", 17305, 17101, MultiTileEntityCrucible.class            , aMat.mToolQuality, 16, aMachine   , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS, 100.0F, NBT_RESISTANCE, 100.0F, NBT_TEXTURE, "crucible"                , NBT_DESIGN, 18005, NBT_ACIDPROOF, T), "hMy", 'M', aRegistry.getItem(18005));
		
		
		aMat = MT.SteelGalvanized;      aRegistry.add("Logistics Core"                                      , "Logistics"          , 17997, 17997, MultiTileEntityLogisticsCore.class       , aMat.mToolQuality, 16, aMachine   , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   6.0F, NBT_RESISTANCE,   6.0F, NBT_TEXTURE, "logisticscore"           , NBT_ENERGY_ACCEPTED, TD.Energy.EU), "CCC", "PMP", "CCC", 'M', OP.casingMachine.dat(aMat), 'P', IL.Processor_Crystal_Emerald, 'C', OD_CIRCUITS[6]);
		aMat = ANY.W;                   aRegistry.add("Lightning Rod Electric Output"                       , "Multiblock Machines", 17998, 17101, MultiTileEntityLightningRod.class        , aMat.mToolQuality, 16, aMachine   , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,  10.0F, NBT_RESISTANCE,  10.0F, NBT_TEXTURE, "lightningrod"            , NBT_ENERGY_EMITTED, TD.Energy.EU, NBT_CAPACITY, 18000 * VREC[6]), "CWC", "PMP", "CWC", 'M', OP.casingMachine.dat(aMat), 'W', OP.wireGt16.dat(MT.NiobiumTitanium), 'P', IL.Processor_Crystal_Sapphire, 'C', OD_CIRCUITS[6]);
		aMat = MT.Ti;                   aRegistry.add("Bedrock Mining Drill Controller"                     , "Multiblock Machines", 17999, 17101, MultiTileEntityBedrockDrill.class        , aMat.mToolQuality, 16, aMachine   , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   9.0F, NBT_RESISTANCE,   9.0F, NBT_TEXTURE, "bedrockdrill"            , NBT_RECIPEMAP, RM.BedrockOreList, NBT_ENERGY_ACCEPTED, TD.Energy.RU), "PYP", "CMC", "GIG", 'M', OP.casingMachineDense.dat(aMat), 'G', OP.gearGt.dat(MT.TungstenSteel), 'I', OP.toolHeadDrill.dat(MT.TungstenSteel), 'P', IL.Processor_Crystal_Ruby, 'Y', IL.CONVEYERS[5], 'C', OD_CIRCUITS[6]);
	}
	
	private static void machines1(MultiTileEntityRegistry aRegistry, MultiTileEntityBlock aMetal, MultiTileEntityBlock aMetalChips, MultiTileEntityBlock aMetalWires, MultiTileEntityBlock aMachine, MultiTileEntityBlock aWooden, MultiTileEntityBlock aBush, MultiTileEntityBlock aStone, MultiTileEntityBlock aWool, MultiTileEntityBlock aTNT, MultiTileEntityBlock aHive, MultiTileEntityBlock aUtilMetal, MultiTileEntityBlock aUtilStone, MultiTileEntityBlock aUtilWood, MultiTileEntityBlock aUtilWool, OreDictMaterial aMat, Class<? extends TileEntity> aClass) {
		aClass = MultiTileEntityBasicMachine.class;
		aMat = MT.DATA.Heat_T[1];       aRegistry.add("Oven ("                          +aMat.getLocal()+")", "Basic Machines"                      , 20001, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   6.0F, NBT_RESISTANCE,   6.0F, NBT_INPUT,   32, NBT_TEXTURE, "oven", NBT_ENERGY_ACCEPTED, TD.Energy.HU, NBT_RECIPEMAP, RM.Furnace, NBT_INV_SIDE_IN, SBIT_L, NBT_INV_SIDE_AUTO_IN, SIDE_LEFT, NBT_INV_SIDE_OUT, SBIT_R, NBT_INV_SIDE_AUTO_OUT, SIDE_RIGHT, NBT_TANK_SIDE_OUT, 63, NBT_ENERGY_ACCEPTED_SIDES, SBIT_D), "wMh", "BCB", 'M', OP.casingMachine.dat(aMat), 'C', OP.plateDouble.dat(ANY.Cu), 'B', Blocks.brick_block);
		aMat = MT.DATA.Heat_T[2];       aRegistry.add("Oven ("                          +aMat.getLocal()+")", "Basic Machines"                      , 20002, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT,  128, NBT_TEXTURE, "oven", NBT_ENERGY_ACCEPTED, TD.Energy.HU, NBT_RECIPEMAP, RM.Furnace, NBT_INV_SIDE_IN, SBIT_L, NBT_INV_SIDE_AUTO_IN, SIDE_LEFT, NBT_INV_SIDE_OUT, SBIT_R, NBT_INV_SIDE_AUTO_OUT, SIDE_RIGHT, NBT_TANK_SIDE_OUT, 63, NBT_ENERGY_ACCEPTED_SIDES, SBIT_D), "wMh", "BCB", 'M', OP.casingMachine.dat(aMat), 'C', OP.plateDouble.dat(ANY.Cu), 'B', Blocks.brick_block);
		aMat = MT.DATA.Heat_T[3];       aRegistry.add("Oven ("                          +aMat.getLocal()+")", "Basic Machines"                      , 20003, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   9.0F, NBT_RESISTANCE,   9.0F, NBT_INPUT,  512, NBT_TEXTURE, "oven", NBT_ENERGY_ACCEPTED, TD.Energy.HU, NBT_RECIPEMAP, RM.Furnace, NBT_INV_SIDE_IN, SBIT_L, NBT_INV_SIDE_AUTO_IN, SIDE_LEFT, NBT_INV_SIDE_OUT, SBIT_R, NBT_INV_SIDE_AUTO_OUT, SIDE_RIGHT, NBT_TANK_SIDE_OUT, 63, NBT_ENERGY_ACCEPTED_SIDES, SBIT_D), "wMh", "BCB", 'M', OP.casingMachine.dat(aMat), 'C', OP.plateDouble.dat(ANY.Cu), 'B', Blocks.brick_block);
		aMat = MT.DATA.Heat_T[4];       aRegistry.add("Oven ("                          +aMat.getLocal()+")", "Basic Machines"                      , 20004, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,  12.5F, NBT_RESISTANCE,  12.5F, NBT_INPUT, 2048, NBT_TEXTURE, "oven", NBT_ENERGY_ACCEPTED, TD.Energy.HU, NBT_RECIPEMAP, RM.Furnace, NBT_INV_SIDE_IN, SBIT_L, NBT_INV_SIDE_AUTO_IN, SIDE_LEFT, NBT_INV_SIDE_OUT, SBIT_R, NBT_INV_SIDE_AUTO_OUT, SIDE_RIGHT, NBT_TANK_SIDE_OUT, 63, NBT_ENERGY_ACCEPTED_SIDES, SBIT_D), "wMh", "BCB", 'M', OP.casingMachine.dat(aMat), 'C', OP.plateDouble.dat(ANY.Cu), 'B', Blocks.brick_block);
		
		aClass = MultiTileEntityBasicMachine.class;
		aMat = MT.DATA.Kinetic_T[1];    aRegistry.add("Shredder ("                      +aMat.getLocal()+")", "Basic Machines"                      , 20011, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   7.0F, NBT_RESISTANCE,   7.0F, NBT_INPUT,   32, NBT_TEXTURE, "shredder", NBT_ENERGY_ACCEPTED, TD.Energy.RU, NBT_RECIPEMAP, RM.Shredder, NBT_INV_SIDE_IN, SBIT_U, NBT_INV_SIDE_AUTO_IN, SIDE_TOP, NBT_INV_SIDE_OUT, SBIT_D, NBT_INV_SIDE_AUTO_OUT, SIDE_BOTTOM, NBT_ENERGY_ACCEPTED_SIDES, SBIT_L|SBIT_R), "GDG", "hMw", 'M', OP.casingMachineDouble.dat(aMat), 'G', OP.gearGt.dat(aMat), 'D', OP.plateGem.dat(ANY.Diamond));
		aMat = MT.DATA.Kinetic_T[2];    aRegistry.add("Shredder ("                      +aMat.getLocal()+")", "Basic Machines"                      , 20012, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   6.0F, NBT_RESISTANCE,   6.0F, NBT_INPUT,  128, NBT_TEXTURE, "shredder", NBT_ENERGY_ACCEPTED, TD.Energy.RU, NBT_RECIPEMAP, RM.Shredder, NBT_INV_SIDE_IN, SBIT_U, NBT_INV_SIDE_AUTO_IN, SIDE_TOP, NBT_INV_SIDE_OUT, SBIT_D, NBT_INV_SIDE_AUTO_OUT, SIDE_BOTTOM, NBT_ENERGY_ACCEPTED_SIDES, SBIT_L|SBIT_R), "GDG", "hMw", 'M', OP.casingMachineDouble.dat(aMat), 'G', OP.gearGt.dat(aMat), 'D', OP.plateGem.dat(ANY.Diamond));
		aMat = MT.DATA.Kinetic_T[3];    aRegistry.add("Shredder ("                      +aMat.getLocal()+")", "Basic Machines"                      , 20013, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   9.0F, NBT_RESISTANCE,   9.0F, NBT_INPUT,  512, NBT_TEXTURE, "shredder", NBT_ENERGY_ACCEPTED, TD.Energy.RU, NBT_RECIPEMAP, RM.Shredder, NBT_INV_SIDE_IN, SBIT_U, NBT_INV_SIDE_AUTO_IN, SIDE_TOP, NBT_INV_SIDE_OUT, SBIT_D, NBT_INV_SIDE_AUTO_OUT, SIDE_BOTTOM, NBT_ENERGY_ACCEPTED_SIDES, SBIT_L|SBIT_R), "GDG", "hMw", 'M', OP.casingMachineDouble.dat(aMat), 'G', OP.gearGt.dat(aMat), 'D', OP.plateGem.dat(ANY.Diamond));
		aMat = MT.DATA.Kinetic_T[4];    aRegistry.add("Shredder ("                      +aMat.getLocal()+")", "Basic Machines"                      , 20014, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,  12.5F, NBT_RESISTANCE,  12.5F, NBT_INPUT, 2048, NBT_TEXTURE, "shredder", NBT_ENERGY_ACCEPTED, TD.Energy.RU, NBT_RECIPEMAP, RM.Shredder, NBT_INV_SIDE_IN, SBIT_U, NBT_INV_SIDE_AUTO_IN, SIDE_TOP, NBT_INV_SIDE_OUT, SBIT_D, NBT_INV_SIDE_AUTO_OUT, SIDE_BOTTOM, NBT_ENERGY_ACCEPTED_SIDES, SBIT_L|SBIT_R), "GDG", "hMw", 'M', OP.casingMachineDouble.dat(aMat), 'G', OP.gearGt.dat(aMat), 'D', OP.plateGem.dat(ANY.Diamond));
		
		aClass = MultiTileEntityBasicMachine.class;
		aMat = MT.DATA.Kinetic_T[1];    aRegistry.add("Crusher ("                       +aMat.getLocal()+")", "Basic Machines"                      , 20021, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   7.0F, NBT_RESISTANCE,   7.0F, NBT_INPUT,   32, NBT_TEXTURE, "crusher", NBT_ENERGY_ACCEPTED, TD.Energy.KU, NBT_RECIPEMAP, RM.Crusher, NBT_INV_SIDE_IN, SBIT_U, NBT_INV_SIDE_AUTO_IN, SIDE_TOP, NBT_INV_SIDE_OUT, SBIT_D, NBT_INV_SIDE_AUTO_OUT, SIDE_BOTTOM, NBT_ENERGY_ACCEPTED_SIDES, SBIT_B, NBT_PARALLEL, 4, NBT_PARALLEL_DURATION, T), "DMD", "hSw", 'M', OP.casingMachineDouble.dat(aMat), 'S', OP.spring.dat(aMat), 'D', OP.gem.dat(ANY.Diamond));
		aMat = MT.DATA.Kinetic_T[2];    aRegistry.add("Crusher ("                       +aMat.getLocal()+")", "Basic Machines"                      , 20022, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   6.0F, NBT_RESISTANCE,   6.0F, NBT_INPUT,  128, NBT_TEXTURE, "crusher", NBT_ENERGY_ACCEPTED, TD.Energy.KU, NBT_RECIPEMAP, RM.Crusher, NBT_INV_SIDE_IN, SBIT_U, NBT_INV_SIDE_AUTO_IN, SIDE_TOP, NBT_INV_SIDE_OUT, SBIT_D, NBT_INV_SIDE_AUTO_OUT, SIDE_BOTTOM, NBT_ENERGY_ACCEPTED_SIDES, SBIT_B, NBT_PARALLEL, 8, NBT_PARALLEL_DURATION, T), "DMD", "hSw", 'M', OP.casingMachineDouble.dat(aMat), 'S', OP.spring.dat(aMat), 'D', OP.gem.dat(ANY.Diamond));
		aMat = MT.DATA.Kinetic_T[3];    aRegistry.add("Crusher ("                       +aMat.getLocal()+")", "Basic Machines"                      , 20023, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   9.0F, NBT_RESISTANCE,   9.0F, NBT_INPUT,  512, NBT_TEXTURE, "crusher", NBT_ENERGY_ACCEPTED, TD.Energy.KU, NBT_RECIPEMAP, RM.Crusher, NBT_INV_SIDE_IN, SBIT_U, NBT_INV_SIDE_AUTO_IN, SIDE_TOP, NBT_INV_SIDE_OUT, SBIT_D, NBT_INV_SIDE_AUTO_OUT, SIDE_BOTTOM, NBT_ENERGY_ACCEPTED_SIDES, SBIT_B, NBT_PARALLEL,16, NBT_PARALLEL_DURATION, T), "DMD", "hSw", 'M', OP.casingMachineDouble.dat(aMat), 'S', OP.spring.dat(aMat), 'D', OP.gem.dat(ANY.Diamond));
		aMat = MT.DATA.Kinetic_T[4];    aRegistry.add("Crusher ("                       +aMat.getLocal()+")", "Basic Machines"                      , 20024, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,  12.5F, NBT_RESISTANCE,  12.5F, NBT_INPUT, 2048, NBT_TEXTURE, "crusher", NBT_ENERGY_ACCEPTED, TD.Energy.KU, NBT_RECIPEMAP, RM.Crusher, NBT_INV_SIDE_IN, SBIT_U, NBT_INV_SIDE_AUTO_IN, SIDE_TOP, NBT_INV_SIDE_OUT, SBIT_D, NBT_INV_SIDE_AUTO_OUT, SIDE_BOTTOM, NBT_ENERGY_ACCEPTED_SIDES, SBIT_B, NBT_PARALLEL,32, NBT_PARALLEL_DURATION, T), "DMD", "hSw", 'M', OP.casingMachineDouble.dat(aMat), 'S', OP.spring.dat(aMat), 'D', OP.gem.dat(ANY.Diamond));
		
		aClass = MultiTileEntityBasicMachine.class;
		aMat = MT.DATA.Kinetic_T[1];    aRegistry.add("Lathe ("                         +aMat.getLocal()+")", "Basic Machines"                      , 20041, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   7.0F, NBT_RESISTANCE,   7.0F, NBT_INPUT,   32, NBT_TEXTURE, "lathe", NBT_ENERGY_ACCEPTED, TD.Energy.RU, NBT_RECIPEMAP, RM.Lathe, NBT_INV_SIDE_IN, SBIT_L, NBT_INV_SIDE_AUTO_IN, SIDE_LEFT, NBT_INV_SIDE_OUT, SBIT_R, NBT_INV_SIDE_AUTO_OUT, SIDE_RIGHT, NBT_ENERGY_ACCEPTED_SIDES, SBIT_D), "TDS", "dMG", 'M', OP.casingMachineDouble.dat(aMat), 'T', OP.screw.dat(aMat), 'G', OP.gearGt.dat(aMat), 'S', OP.gearGtSmall.dat(aMat), 'D', OP.plateGemTiny.dat(ANY.Diamond));
		aMat = MT.DATA.Kinetic_T[2];    aRegistry.add("Lathe ("                         +aMat.getLocal()+")", "Basic Machines"                      , 20042, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   6.0F, NBT_RESISTANCE,   6.0F, NBT_INPUT,  128, NBT_TEXTURE, "lathe", NBT_ENERGY_ACCEPTED, TD.Energy.RU, NBT_RECIPEMAP, RM.Lathe, NBT_INV_SIDE_IN, SBIT_L, NBT_INV_SIDE_AUTO_IN, SIDE_LEFT, NBT_INV_SIDE_OUT, SBIT_R, NBT_INV_SIDE_AUTO_OUT, SIDE_RIGHT, NBT_ENERGY_ACCEPTED_SIDES, SBIT_D), "TDS", "dMG", 'M', OP.casingMachineDouble.dat(aMat), 'T', OP.screw.dat(aMat), 'G', OP.gearGt.dat(aMat), 'S', OP.gearGtSmall.dat(aMat), 'D', OP.plateGemTiny.dat(ANY.Diamond));
		aMat = MT.DATA.Kinetic_T[3];    aRegistry.add("Lathe ("                         +aMat.getLocal()+")", "Basic Machines"                      , 20043, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   9.0F, NBT_RESISTANCE,   9.0F, NBT_INPUT,  512, NBT_TEXTURE, "lathe", NBT_ENERGY_ACCEPTED, TD.Energy.RU, NBT_RECIPEMAP, RM.Lathe, NBT_INV_SIDE_IN, SBIT_L, NBT_INV_SIDE_AUTO_IN, SIDE_LEFT, NBT_INV_SIDE_OUT, SBIT_R, NBT_INV_SIDE_AUTO_OUT, SIDE_RIGHT, NBT_ENERGY_ACCEPTED_SIDES, SBIT_D), "TDS", "dMG", 'M', OP.casingMachineDouble.dat(aMat), 'T', OP.screw.dat(aMat), 'G', OP.gearGt.dat(aMat), 'S', OP.gearGtSmall.dat(aMat), 'D', OP.plateGemTiny.dat(ANY.Diamond));
		aMat = MT.DATA.Kinetic_T[4];    aRegistry.add("Lathe ("                         +aMat.getLocal()+")", "Basic Machines"                      , 20044, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,  12.5F, NBT_RESISTANCE,  12.5F, NBT_INPUT, 2048, NBT_TEXTURE, "lathe", NBT_ENERGY_ACCEPTED, TD.Energy.RU, NBT_RECIPEMAP, RM.Lathe, NBT_INV_SIDE_IN, SBIT_L, NBT_INV_SIDE_AUTO_IN, SIDE_LEFT, NBT_INV_SIDE_OUT, SBIT_R, NBT_INV_SIDE_AUTO_OUT, SIDE_RIGHT, NBT_ENERGY_ACCEPTED_SIDES, SBIT_D), "TDS", "dMG", 'M', OP.casingMachineDouble.dat(aMat), 'T', OP.screw.dat(aMat), 'G', OP.gearGt.dat(aMat), 'S', OP.gearGtSmall.dat(aMat), 'D', OP.plateGemTiny.dat(ANY.Diamond));
		
		aClass = MultiTileEntityBasicMachine.class;
		aMat = MT.DATA.Kinetic_T[1];    aRegistry.add("Sifter ("                        +aMat.getLocal()+")", "Basic Machines"                      , 20051, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   7.0F, NBT_RESISTANCE,   7.0F, NBT_INPUT,   32, NBT_TEXTURE, "sifter", NBT_ENERGY_ACCEPTED, TD.Energy.KU, NBT_RECIPEMAP, RM.Sifting, NBT_INV_SIDE_IN, SBIT_U, NBT_INV_SIDE_AUTO_IN, SIDE_TOP, NBT_INV_SIDE_OUT, SBIT_D, NBT_INV_SIDE_AUTO_OUT, SIDE_BOTTOM, NBT_ENERGY_ACCEPTED_SIDES, SBIT_B, NBT_PARALLEL, 4, NBT_PARALLEL_DURATION, T), "WxW", "RMR", "SwS", 'M', OP.casingMachineDouble.dat(aMat), 'S', OP.spring.dat(aMat), 'W', OP.wireFine.dat(aMat), 'R', OP.stick.dat(aMat));
		aMat = MT.DATA.Kinetic_T[2];    aRegistry.add("Sifter ("                        +aMat.getLocal()+")", "Basic Machines"                      , 20052, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   6.0F, NBT_RESISTANCE,   6.0F, NBT_INPUT,  128, NBT_TEXTURE, "sifter", NBT_ENERGY_ACCEPTED, TD.Energy.KU, NBT_RECIPEMAP, RM.Sifting, NBT_INV_SIDE_IN, SBIT_U, NBT_INV_SIDE_AUTO_IN, SIDE_TOP, NBT_INV_SIDE_OUT, SBIT_D, NBT_INV_SIDE_AUTO_OUT, SIDE_BOTTOM, NBT_ENERGY_ACCEPTED_SIDES, SBIT_B, NBT_PARALLEL, 8, NBT_PARALLEL_DURATION, T), "WxW", "RMR", "SwS", 'M', OP.casingMachineDouble.dat(aMat), 'S', OP.spring.dat(aMat), 'W', OP.wireFine.dat(aMat), 'R', OP.stick.dat(aMat));
		aMat = MT.DATA.Kinetic_T[3];    aRegistry.add("Sifter ("                        +aMat.getLocal()+")", "Basic Machines"                      , 20053, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   9.0F, NBT_RESISTANCE,   9.0F, NBT_INPUT,  512, NBT_TEXTURE, "sifter", NBT_ENERGY_ACCEPTED, TD.Energy.KU, NBT_RECIPEMAP, RM.Sifting, NBT_INV_SIDE_IN, SBIT_U, NBT_INV_SIDE_AUTO_IN, SIDE_TOP, NBT_INV_SIDE_OUT, SBIT_D, NBT_INV_SIDE_AUTO_OUT, SIDE_BOTTOM, NBT_ENERGY_ACCEPTED_SIDES, SBIT_B, NBT_PARALLEL,16, NBT_PARALLEL_DURATION, T), "WxW", "RMR", "SwS", 'M', OP.casingMachineDouble.dat(aMat), 'S', OP.spring.dat(aMat), 'W', OP.wireFine.dat(aMat), 'R', OP.stick.dat(aMat));
		aMat = MT.DATA.Kinetic_T[4];    aRegistry.add("Sifter ("                        +aMat.getLocal()+")", "Basic Machines"                      , 20054, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,  12.5F, NBT_RESISTANCE,  12.5F, NBT_INPUT, 2048, NBT_TEXTURE, "sifter", NBT_ENERGY_ACCEPTED, TD.Energy.KU, NBT_RECIPEMAP, RM.Sifting, NBT_INV_SIDE_IN, SBIT_U, NBT_INV_SIDE_AUTO_IN, SIDE_TOP, NBT_INV_SIDE_OUT, SBIT_D, NBT_INV_SIDE_AUTO_OUT, SIDE_BOTTOM, NBT_ENERGY_ACCEPTED_SIDES, SBIT_B, NBT_PARALLEL,32, NBT_PARALLEL_DURATION, T), "WxW", "RMR", "SwS", 'M', OP.casingMachineDouble.dat(aMat), 'S', OP.spring.dat(aMat), 'W', OP.wireFine.dat(aMat), 'R', OP.stick.dat(aMat));
		
		aClass = MultiTileEntityBasicMachine.class;
		aMat = MT.DATA.Kinetic_T[1];    aRegistry.add("Buzzsaw ("                       +aMat.getLocal()+")", "Basic Machines"                      , 20061, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   7.0F, NBT_RESISTANCE,   7.0F, NBT_INPUT,   32, NBT_TEXTURE, "buzzsaw", NBT_ENERGY_ACCEPTED, TD.Energy.RU, NBT_RECIPEMAP, RM.Cutter, NBT_INV_SIDE_IN, SBIT_L, NBT_INV_SIDE_AUTO_IN, SIDE_LEFT, NBT_INV_SIDE_OUT, SBIT_R, NBT_INV_SIDE_AUTO_OUT, SIDE_RIGHT, NBT_TANK_SIDE_IN, SBIT_U|SBIT_D, NBT_TANK_SIDE_AUTO_IN, SIDE_BOTTOM, NBT_ENERGY_ACCEPTED_SIDES, SBIT_B), "DGS", "wMS", 'M', OP.casingMachineDouble.dat(aMat), 'S', OP.gearGtSmall.dat(aMat), 'D', OP.dust.dat(ANY.Diamond), 'G', OP.toolHeadBuzzSaw.dat(ANY.Steel));
		aMat = MT.DATA.Kinetic_T[2];    aRegistry.add("Buzzsaw ("                       +aMat.getLocal()+")", "Basic Machines"                      , 20062, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   6.0F, NBT_RESISTANCE,   6.0F, NBT_INPUT,  128, NBT_TEXTURE, "buzzsaw", NBT_ENERGY_ACCEPTED, TD.Energy.RU, NBT_RECIPEMAP, RM.Cutter, NBT_INV_SIDE_IN, SBIT_L, NBT_INV_SIDE_AUTO_IN, SIDE_LEFT, NBT_INV_SIDE_OUT, SBIT_R, NBT_INV_SIDE_AUTO_OUT, SIDE_RIGHT, NBT_TANK_SIDE_IN, SBIT_U|SBIT_D, NBT_TANK_SIDE_AUTO_IN, SIDE_BOTTOM, NBT_ENERGY_ACCEPTED_SIDES, SBIT_B), "DGS", "wMS", 'M', OP.casingMachineDouble.dat(aMat), 'S', OP.gearGtSmall.dat(aMat), 'D', OP.dust.dat(ANY.Diamond), 'G', OP.toolHeadBuzzSaw.dat(MT.CobaltBrass));
		aMat = MT.DATA.Kinetic_T[3];    aRegistry.add("Buzzsaw ("                       +aMat.getLocal()+")", "Basic Machines"                      , 20063, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   9.0F, NBT_RESISTANCE,   9.0F, NBT_INPUT,  512, NBT_TEXTURE, "buzzsaw", NBT_ENERGY_ACCEPTED, TD.Energy.RU, NBT_RECIPEMAP, RM.Cutter, NBT_INV_SIDE_IN, SBIT_L, NBT_INV_SIDE_AUTO_IN, SIDE_LEFT, NBT_INV_SIDE_OUT, SBIT_R, NBT_INV_SIDE_AUTO_OUT, SIDE_RIGHT, NBT_TANK_SIDE_IN, SBIT_U|SBIT_D, NBT_TANK_SIDE_AUTO_IN, SIDE_BOTTOM, NBT_ENERGY_ACCEPTED_SIDES, SBIT_B), "DGS", "wMS", 'M', OP.casingMachineDouble.dat(aMat), 'S', OP.gearGtSmall.dat(aMat), 'D', OP.dust.dat(ANY.Diamond), 'G', OP.toolHeadBuzzSaw.dat(MT.CobaltBrass));
		aMat = MT.DATA.Kinetic_T[4];    aRegistry.add("Buzzsaw ("                       +aMat.getLocal()+")", "Basic Machines"                      , 20064, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,  12.5F, NBT_RESISTANCE,  12.5F, NBT_INPUT, 2048, NBT_TEXTURE, "buzzsaw", NBT_ENERGY_ACCEPTED, TD.Energy.RU, NBT_RECIPEMAP, RM.Cutter, NBT_INV_SIDE_IN, SBIT_L, NBT_INV_SIDE_AUTO_IN, SIDE_LEFT, NBT_INV_SIDE_OUT, SBIT_R, NBT_INV_SIDE_AUTO_OUT, SIDE_RIGHT, NBT_TANK_SIDE_IN, SBIT_U|SBIT_D, NBT_TANK_SIDE_AUTO_IN, SIDE_BOTTOM, NBT_ENERGY_ACCEPTED_SIDES, SBIT_B), "DGS", "wMS", 'M', OP.casingMachineDouble.dat(aMat), 'S', OP.gearGtSmall.dat(aMat), 'D', OP.dust.dat(ANY.Diamond), 'G', OP.toolHeadBuzzSaw.dat(MT.CobaltBrass));
		
		aClass = MultiTileEntityBasicMachine.class;
		aMat = MT.DATA.Kinetic_T[1];    aRegistry.add("Squeezer ("                      +aMat.getLocal()+")", "Basic Machines"                      , 20071, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   7.0F, NBT_RESISTANCE,   7.0F, NBT_INPUT,   32, NBT_TEXTURE, "squeezer", NBT_ENERGY_ACCEPTED, TD.Energy.KU, NBT_RECIPEMAP, RM.Squeezer, NBT_INV_SIDE_IN, SBIT_L, NBT_INV_SIDE_AUTO_IN, SIDE_LEFT, NBT_INV_SIDE_OUT, SBIT_R, NBT_INV_SIDE_AUTO_OUT, SIDE_RIGHT, NBT_TANK_SIDE_OUT, SBIT_D, NBT_TANK_SIDE_AUTO_OUT, SIDE_BOTTOM, NBT_ENERGY_ACCEPTED_SIDES, SBIT_U, NBT_PARALLEL, 4, NBT_PARALLEL_DURATION, T), "RS", "PM", "Pw", 'M', OP.casingMachineDouble.dat(aMat), 'P', OP.plateTriple.dat(aMat), 'S', OP.spring.dat(aMat), 'R', OP.stick.dat(aMat));
		aMat = MT.DATA.Kinetic_T[2];    aRegistry.add("Squeezer ("                      +aMat.getLocal()+")", "Basic Machines"                      , 20072, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   6.0F, NBT_RESISTANCE,   6.0F, NBT_INPUT,  128, NBT_TEXTURE, "squeezer", NBT_ENERGY_ACCEPTED, TD.Energy.KU, NBT_RECIPEMAP, RM.Squeezer, NBT_INV_SIDE_IN, SBIT_L, NBT_INV_SIDE_AUTO_IN, SIDE_LEFT, NBT_INV_SIDE_OUT, SBIT_R, NBT_INV_SIDE_AUTO_OUT, SIDE_RIGHT, NBT_TANK_SIDE_OUT, SBIT_D, NBT_TANK_SIDE_AUTO_OUT, SIDE_BOTTOM, NBT_ENERGY_ACCEPTED_SIDES, SBIT_U, NBT_PARALLEL, 8, NBT_PARALLEL_DURATION, T), "RS", "PM", "Pw", 'M', OP.casingMachineDouble.dat(aMat), 'P', OP.plateTriple.dat(aMat), 'S', OP.spring.dat(aMat), 'R', OP.stick.dat(aMat));
		aMat = MT.DATA.Kinetic_T[3];    aRegistry.add("Squeezer ("                      +aMat.getLocal()+")", "Basic Machines"                      , 20073, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   9.0F, NBT_RESISTANCE,   9.0F, NBT_INPUT,  512, NBT_TEXTURE, "squeezer", NBT_ENERGY_ACCEPTED, TD.Energy.KU, NBT_RECIPEMAP, RM.Squeezer, NBT_INV_SIDE_IN, SBIT_L, NBT_INV_SIDE_AUTO_IN, SIDE_LEFT, NBT_INV_SIDE_OUT, SBIT_R, NBT_INV_SIDE_AUTO_OUT, SIDE_RIGHT, NBT_TANK_SIDE_OUT, SBIT_D, NBT_TANK_SIDE_AUTO_OUT, SIDE_BOTTOM, NBT_ENERGY_ACCEPTED_SIDES, SBIT_U, NBT_PARALLEL,16, NBT_PARALLEL_DURATION, T), "RS", "PM", "Pw", 'M', OP.casingMachineDouble.dat(aMat), 'P', OP.plateTriple.dat(aMat), 'S', OP.spring.dat(aMat), 'R', OP.stick.dat(aMat));
		aMat = MT.DATA.Kinetic_T[4];    aRegistry.add("Squeezer ("                      +aMat.getLocal()+")", "Basic Machines"                      , 20074, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,  12.5F, NBT_RESISTANCE,  12.5F, NBT_INPUT, 2048, NBT_TEXTURE, "squeezer", NBT_ENERGY_ACCEPTED, TD.Energy.KU, NBT_RECIPEMAP, RM.Squeezer, NBT_INV_SIDE_IN, SBIT_L, NBT_INV_SIDE_AUTO_IN, SIDE_LEFT, NBT_INV_SIDE_OUT, SBIT_R, NBT_INV_SIDE_AUTO_OUT, SIDE_RIGHT, NBT_TANK_SIDE_OUT, SBIT_D, NBT_TANK_SIDE_AUTO_OUT, SIDE_BOTTOM, NBT_ENERGY_ACCEPTED_SIDES, SBIT_U, NBT_PARALLEL,32, NBT_PARALLEL_DURATION, T), "RS", "PM", "Pw", 'M', OP.casingMachineDouble.dat(aMat), 'P', OP.plateTriple.dat(aMat), 'S', OP.spring.dat(aMat), 'R', OP.stick.dat(aMat));
		
		aClass = MultiTileEntityBasicMachine.class;
		aMat = MT.DATA.Kinetic_T[1];    aRegistry.add("Centrifuge ("                    +aMat.getLocal()+")", "Basic Machines"                      , 20081, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   7.0F, NBT_RESISTANCE,   7.0F, NBT_INPUT,   32, NBT_TEXTURE, "centrifuge", NBT_ENERGY_ACCEPTED, TD.Energy.RU, NBT_RECIPEMAP, RM.Centrifuge, NBT_INV_SIDE_IN, SBIT_U, NBT_INV_SIDE_AUTO_IN, SIDE_TOP, NBT_INV_SIDE_OUT, SBIT_R, NBT_INV_SIDE_AUTO_OUT, SIDE_RIGHT, NBT_TANK_SIDE_IN, SBIT_U, NBT_TANK_SIDE_AUTO_IN, SIDE_TOP, NBT_TANK_SIDE_OUT, SBIT_L, NBT_TANK_SIDE_AUTO_OUT, SIDE_LEFT, NBT_ENERGY_ACCEPTED_SIDES, SBIT_D, NBT_PARALLEL,  1, NBT_PARALLEL_DURATION, T), "Gw", "SM", "Gh", 'M', OP.casingMachineDouble.dat(aMat), 'G', OP.gearGt.dat(aMat), 'S', OP.stickLong.dat(aMat));
		aMat = MT.DATA.Kinetic_T[2];    aRegistry.add("Centrifuge ("                    +aMat.getLocal()+")", "Basic Machines"                      , 20082, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   6.0F, NBT_RESISTANCE,   6.0F, NBT_INPUT,  128, NBT_TEXTURE, "centrifuge", NBT_ENERGY_ACCEPTED, TD.Energy.RU, NBT_RECIPEMAP, RM.Centrifuge, NBT_INV_SIDE_IN, SBIT_U, NBT_INV_SIDE_AUTO_IN, SIDE_TOP, NBT_INV_SIDE_OUT, SBIT_R, NBT_INV_SIDE_AUTO_OUT, SIDE_RIGHT, NBT_TANK_SIDE_IN, SBIT_U, NBT_TANK_SIDE_AUTO_IN, SIDE_TOP, NBT_TANK_SIDE_OUT, SBIT_L, NBT_TANK_SIDE_AUTO_OUT, SIDE_LEFT, NBT_ENERGY_ACCEPTED_SIDES, SBIT_D, NBT_PARALLEL,  2, NBT_PARALLEL_DURATION, T), "Gw", "SM", "Gh", 'M', OP.casingMachineDouble.dat(aMat), 'G', OP.gearGt.dat(aMat), 'S', OP.stickLong.dat(aMat));
		aMat = MT.DATA.Kinetic_T[3];    aRegistry.add("Centrifuge ("                    +aMat.getLocal()+")", "Basic Machines"                      , 20083, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   9.0F, NBT_RESISTANCE,   9.0F, NBT_INPUT,  512, NBT_TEXTURE, "centrifuge", NBT_ENERGY_ACCEPTED, TD.Energy.RU, NBT_RECIPEMAP, RM.Centrifuge, NBT_INV_SIDE_IN, SBIT_U, NBT_INV_SIDE_AUTO_IN, SIDE_TOP, NBT_INV_SIDE_OUT, SBIT_R, NBT_INV_SIDE_AUTO_OUT, SIDE_RIGHT, NBT_TANK_SIDE_IN, SBIT_U, NBT_TANK_SIDE_AUTO_IN, SIDE_TOP, NBT_TANK_SIDE_OUT, SBIT_L, NBT_TANK_SIDE_AUTO_OUT, SIDE_LEFT, NBT_ENERGY_ACCEPTED_SIDES, SBIT_D, NBT_PARALLEL,  4, NBT_PARALLEL_DURATION, T), "Gw", "SM", "Gh", 'M', OP.casingMachineDouble.dat(aMat), 'G', OP.gearGt.dat(aMat), 'S', OP.stickLong.dat(aMat));
		aMat = MT.DATA.Kinetic_T[4];    aRegistry.add("Centrifuge ("                    +aMat.getLocal()+")", "Basic Machines"                      , 20084, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,  12.5F, NBT_RESISTANCE,  12.5F, NBT_INPUT, 2048, NBT_TEXTURE, "centrifuge", NBT_ENERGY_ACCEPTED, TD.Energy.RU, NBT_RECIPEMAP, RM.Centrifuge, NBT_INV_SIDE_IN, SBIT_U, NBT_INV_SIDE_AUTO_IN, SIDE_TOP, NBT_INV_SIDE_OUT, SBIT_R, NBT_INV_SIDE_AUTO_OUT, SIDE_RIGHT, NBT_TANK_SIDE_IN, SBIT_U, NBT_TANK_SIDE_AUTO_IN, SIDE_TOP, NBT_TANK_SIDE_OUT, SBIT_L, NBT_TANK_SIDE_AUTO_OUT, SIDE_LEFT, NBT_ENERGY_ACCEPTED_SIDES, SBIT_D, NBT_PARALLEL,  8, NBT_PARALLEL_DURATION, T), "Gw", "SM", "Gh", 'M', OP.casingMachineDouble.dat(aMat), 'G', OP.gearGt.dat(aMat), 'S', OP.stickLong.dat(aMat));
		
		aClass = MultiTileEntityBasicMachineElectric.class;
		aMat = MT.DATA.Electric_T[1];   aRegistry.add("Electrolyzer ("                            +VN[1]+")", "Basic Machines"                      , 20091, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT,   32, NBT_TEXTURE, "electrolyzer", NBT_ENERGY_ACCEPTED, TD.Energy.EU, NBT_RECIPEMAP, RM.Electrolyzer, NBT_INV_SIDE_IN, SBIT_U|SBIT_F|SBIT_B, NBT_INV_SIDE_AUTO_IN, SIDE_TOP, NBT_INV_SIDE_OUT, SBIT_R|SBIT_L, NBT_INV_SIDE_AUTO_OUT, SIDE_RIGHT, NBT_TANK_SIDE_IN, SBIT_U|SBIT_F|SBIT_B, NBT_TANK_SIDE_AUTO_IN, SIDE_TOP, NBT_TANK_SIDE_OUT, SBIT_R|SBIT_L, NBT_TANK_SIDE_AUTO_OUT, SIDE_LEFT, NBT_ENERGY_ACCEPTED_SIDES, SBIT_D, NBT_PARALLEL,  1, NBT_PARALLEL_DURATION, T), "SMS", "WwW", 'M', OP.casingMachine.dat(aMat), 'S', OP.wireGt01.dat(MT.Pt), 'W', MT.DATA.CABLES_01[1]);
		aMat = MT.DATA.Electric_T[2];   aRegistry.add("Electrolyzer ("                            +VN[2]+")", "Basic Machines"                      , 20092, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT,  128, NBT_TEXTURE, "electrolyzer", NBT_ENERGY_ACCEPTED, TD.Energy.EU, NBT_RECIPEMAP, RM.Electrolyzer, NBT_INV_SIDE_IN, SBIT_U|SBIT_F|SBIT_B, NBT_INV_SIDE_AUTO_IN, SIDE_TOP, NBT_INV_SIDE_OUT, SBIT_R|SBIT_L, NBT_INV_SIDE_AUTO_OUT, SIDE_RIGHT, NBT_TANK_SIDE_IN, SBIT_U|SBIT_F|SBIT_B, NBT_TANK_SIDE_AUTO_IN, SIDE_TOP, NBT_TANK_SIDE_OUT, SBIT_R|SBIT_L, NBT_TANK_SIDE_AUTO_OUT, SIDE_LEFT, NBT_ENERGY_ACCEPTED_SIDES, SBIT_D, NBT_PARALLEL,  2, NBT_PARALLEL_DURATION, T), "SMS", "WwW", 'M', OP.casingMachine.dat(aMat), 'S', OP.wireGt01.dat(MT.Pt), 'W', MT.DATA.CABLES_01[2]);
		aMat = MT.DATA.Electric_T[3];   aRegistry.add("Electrolyzer ("                            +VN[3]+")", "Basic Machines"                      , 20093, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT,  512, NBT_TEXTURE, "electrolyzer", NBT_ENERGY_ACCEPTED, TD.Energy.EU, NBT_RECIPEMAP, RM.Electrolyzer, NBT_INV_SIDE_IN, SBIT_U|SBIT_F|SBIT_B, NBT_INV_SIDE_AUTO_IN, SIDE_TOP, NBT_INV_SIDE_OUT, SBIT_R|SBIT_L, NBT_INV_SIDE_AUTO_OUT, SIDE_RIGHT, NBT_TANK_SIDE_IN, SBIT_U|SBIT_F|SBIT_B, NBT_TANK_SIDE_AUTO_IN, SIDE_TOP, NBT_TANK_SIDE_OUT, SBIT_R|SBIT_L, NBT_TANK_SIDE_AUTO_OUT, SIDE_LEFT, NBT_ENERGY_ACCEPTED_SIDES, SBIT_D, NBT_PARALLEL,  4, NBT_PARALLEL_DURATION, T), "SMS", "WwW", 'M', OP.casingMachine.dat(aMat), 'S', OP.wireGt01.dat(MT.Pt), 'W', MT.DATA.CABLES_01[3]);
		aMat = MT.DATA.Electric_T[4];   aRegistry.add("Electrolyzer ("                            +VN[4]+")", "Basic Machines"                      , 20094, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT, 2048, NBT_TEXTURE, "electrolyzer", NBT_ENERGY_ACCEPTED, TD.Energy.EU, NBT_RECIPEMAP, RM.Electrolyzer, NBT_INV_SIDE_IN, SBIT_U|SBIT_F|SBIT_B, NBT_INV_SIDE_AUTO_IN, SIDE_TOP, NBT_INV_SIDE_OUT, SBIT_R|SBIT_L, NBT_INV_SIDE_AUTO_OUT, SIDE_RIGHT, NBT_TANK_SIDE_IN, SBIT_U|SBIT_F|SBIT_B, NBT_TANK_SIDE_AUTO_IN, SIDE_TOP, NBT_TANK_SIDE_OUT, SBIT_R|SBIT_L, NBT_TANK_SIDE_AUTO_OUT, SIDE_LEFT, NBT_ENERGY_ACCEPTED_SIDES, SBIT_D, NBT_PARALLEL,  8, NBT_PARALLEL_DURATION, T), "SMS", "WwW", 'M', OP.casingMachine.dat(aMat), 'S', OP.wireGt01.dat(MT.Pt), 'W', MT.DATA.CABLES_01[4]);
		aMat = MT.DATA.Electric_T[5];   aRegistry.add("Electrolyzer ("                            +VN[5]+")", "Basic Machines"                      , 20095, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT, 8192, NBT_TEXTURE, "electrolyzer", NBT_ENERGY_ACCEPTED, TD.Energy.EU, NBT_RECIPEMAP, RM.Electrolyzer, NBT_INV_SIDE_IN, SBIT_U|SBIT_F|SBIT_B, NBT_INV_SIDE_AUTO_IN, SIDE_TOP, NBT_INV_SIDE_OUT, SBIT_R|SBIT_L, NBT_INV_SIDE_AUTO_OUT, SIDE_RIGHT, NBT_TANK_SIDE_IN, SBIT_U|SBIT_F|SBIT_B, NBT_TANK_SIDE_AUTO_IN, SIDE_TOP, NBT_TANK_SIDE_OUT, SBIT_R|SBIT_L, NBT_TANK_SIDE_AUTO_OUT, SIDE_LEFT, NBT_ENERGY_ACCEPTED_SIDES, SBIT_D, NBT_PARALLEL, 16, NBT_PARALLEL_DURATION, T), "SMS", "WwW", 'M', OP.casingMachine.dat(aMat), 'S', OP.wireGt01.dat(MT.Pt), 'W', MT.DATA.CABLES_01[5]);
		
		aClass = MultiTileEntityBasicMachine.class;
		aMat = MT.DATA.Kinetic_T[1];    aRegistry.add("Compressor ("                    +aMat.getLocal()+")", "Basic Machines"                      , 20101, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   7.0F, NBT_RESISTANCE,   7.0F, NBT_INPUT,   32, NBT_TEXTURE, "compressor", NBT_ENERGY_ACCEPTED, TD.Energy.KU, NBT_RECIPEMAP, RM.Compressor, NBT_INV_SIDE_IN, SBIT_U, NBT_INV_SIDE_AUTO_IN, SIDE_TOP, NBT_INV_SIDE_OUT, SBIT_D, NBT_INV_SIDE_AUTO_OUT, SIDE_BOTTOM, NBT_ENERGY_ACCEPTED_SIDES, SBIT_L, NBT_PARALLEL, 4, NBT_PARALLEL_DURATION, T), "PPR", "wMS", 'M', OP.casingMachineDouble.dat(aMat), 'P', OP.plateQuintuple.dat(aMat), 'S', OP.spring.dat(aMat), 'R', OP.stick.dat(aMat));
		aMat = MT.DATA.Kinetic_T[2];    aRegistry.add("Compressor ("                    +aMat.getLocal()+")", "Basic Machines"                      , 20102, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   6.0F, NBT_RESISTANCE,   6.0F, NBT_INPUT,  128, NBT_TEXTURE, "compressor", NBT_ENERGY_ACCEPTED, TD.Energy.KU, NBT_RECIPEMAP, RM.Compressor, NBT_INV_SIDE_IN, SBIT_U, NBT_INV_SIDE_AUTO_IN, SIDE_TOP, NBT_INV_SIDE_OUT, SBIT_D, NBT_INV_SIDE_AUTO_OUT, SIDE_BOTTOM, NBT_ENERGY_ACCEPTED_SIDES, SBIT_L, NBT_PARALLEL, 8, NBT_PARALLEL_DURATION, T), "PPR", "wMS", 'M', OP.casingMachineDouble.dat(aMat), 'P', OP.plateQuintuple.dat(aMat), 'S', OP.spring.dat(aMat), 'R', OP.stick.dat(aMat));
		aMat = MT.DATA.Kinetic_T[3];    aRegistry.add("Compressor ("                    +aMat.getLocal()+")", "Basic Machines"                      , 20103, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   9.0F, NBT_RESISTANCE,   9.0F, NBT_INPUT,  512, NBT_TEXTURE, "compressor", NBT_ENERGY_ACCEPTED, TD.Energy.KU, NBT_RECIPEMAP, RM.Compressor, NBT_INV_SIDE_IN, SBIT_U, NBT_INV_SIDE_AUTO_IN, SIDE_TOP, NBT_INV_SIDE_OUT, SBIT_D, NBT_INV_SIDE_AUTO_OUT, SIDE_BOTTOM, NBT_ENERGY_ACCEPTED_SIDES, SBIT_L, NBT_PARALLEL,16, NBT_PARALLEL_DURATION, T), "PPR", "wMS", 'M', OP.casingMachineDouble.dat(aMat), 'P', OP.plateQuintuple.dat(aMat), 'S', OP.spring.dat(aMat), 'R', OP.stick.dat(aMat));
		aMat = MT.DATA.Kinetic_T[4];    aRegistry.add("Compressor ("                    +aMat.getLocal()+")", "Basic Machines"                      , 20104, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,  12.5F, NBT_RESISTANCE,  12.5F, NBT_INPUT, 2048, NBT_TEXTURE, "compressor", NBT_ENERGY_ACCEPTED, TD.Energy.KU, NBT_RECIPEMAP, RM.Compressor, NBT_INV_SIDE_IN, SBIT_U, NBT_INV_SIDE_AUTO_IN, SIDE_TOP, NBT_INV_SIDE_OUT, SBIT_D, NBT_INV_SIDE_AUTO_OUT, SIDE_BOTTOM, NBT_ENERGY_ACCEPTED_SIDES, SBIT_L, NBT_PARALLEL,32, NBT_PARALLEL_DURATION, T), "PPR", "wMS", 'M', OP.casingMachineDouble.dat(aMat), 'P', OP.plateQuintuple.dat(aMat), 'S', OP.spring.dat(aMat), 'R', OP.stick.dat(aMat));
		
		aClass = MultiTileEntityBasicMachine.class;
		aMat = MT.DATA.Kinetic_T[1];    aRegistry.add("Rolling Mill ("                  +aMat.getLocal()+")", "Basic Machines"                      , 20111, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   7.0F, NBT_RESISTANCE,   7.0F, NBT_INPUT,   32, NBT_TEXTURE, "rollingmill", NBT_ENERGY_ACCEPTED, TD.Energy.RU, NBT_RECIPEMAP, RM.RollingMill, NBT_INV_SIDE_IN, SBIT_L, NBT_INV_SIDE_AUTO_IN, SIDE_LEFT, NBT_INV_SIDE_OUT, SBIT_R, NBT_INV_SIDE_AUTO_OUT, SIDE_RIGHT, NBT_ENERGY_ACCEPTED_SIDES, SBIT_B), "Gh", "M ", "Gw", 'M', OP.casingMachineDouble.dat(aMat), 'G', OP.gearGt.dat(aMat));
		aMat = MT.DATA.Kinetic_T[2];    aRegistry.add("Rolling Mill ("                  +aMat.getLocal()+")", "Basic Machines"                      , 20112, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   6.0F, NBT_RESISTANCE,   6.0F, NBT_INPUT,  128, NBT_TEXTURE, "rollingmill", NBT_ENERGY_ACCEPTED, TD.Energy.RU, NBT_RECIPEMAP, RM.RollingMill, NBT_INV_SIDE_IN, SBIT_L, NBT_INV_SIDE_AUTO_IN, SIDE_LEFT, NBT_INV_SIDE_OUT, SBIT_R, NBT_INV_SIDE_AUTO_OUT, SIDE_RIGHT, NBT_ENERGY_ACCEPTED_SIDES, SBIT_B), "Gh", "M ", "Gw", 'M', OP.casingMachineDouble.dat(aMat), 'G', OP.gearGt.dat(aMat));
		aMat = MT.DATA.Kinetic_T[3];    aRegistry.add("Rolling Mill ("                  +aMat.getLocal()+")", "Basic Machines"                      , 20113, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   9.0F, NBT_RESISTANCE,   9.0F, NBT_INPUT,  512, NBT_TEXTURE, "rollingmill", NBT_ENERGY_ACCEPTED, TD.Energy.RU, NBT_RECIPEMAP, RM.RollingMill, NBT_INV_SIDE_IN, SBIT_L, NBT_INV_SIDE_AUTO_IN, SIDE_LEFT, NBT_INV_SIDE_OUT, SBIT_R, NBT_INV_SIDE_AUTO_OUT, SIDE_RIGHT, NBT_ENERGY_ACCEPTED_SIDES, SBIT_B), "Gh", "M ", "Gw", 'M', OP.casingMachineDouble.dat(aMat), 'G', OP.gearGt.dat(aMat));
		aMat = MT.DATA.Kinetic_T[4];    aRegistry.add("Rolling Mill ("                  +aMat.getLocal()+")", "Basic Machines"                      , 20114, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,  12.5F, NBT_RESISTANCE,  12.5F, NBT_INPUT, 2048, NBT_TEXTURE, "rollingmill", NBT_ENERGY_ACCEPTED, TD.Energy.RU, NBT_RECIPEMAP, RM.RollingMill, NBT_INV_SIDE_IN, SBIT_L, NBT_INV_SIDE_AUTO_IN, SIDE_LEFT, NBT_INV_SIDE_OUT, SBIT_R, NBT_INV_SIDE_AUTO_OUT, SIDE_RIGHT, NBT_ENERGY_ACCEPTED_SIDES, SBIT_B), "Gh", "M ", "Gw", 'M', OP.casingMachineDouble.dat(aMat), 'G', OP.gearGt.dat(aMat));
		
		aClass = MultiTileEntityBasicMachine.class;
		aMat = MT.DATA.Kinetic_T[1];    aRegistry.add("Roll Bender ("                   +aMat.getLocal()+")", "Basic Machines"                      , 20121, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   7.0F, NBT_RESISTANCE,   7.0F, NBT_INPUT,   32, NBT_TEXTURE, "rollbender", NBT_ENERGY_ACCEPTED, TD.Energy.RU, NBT_RECIPEMAP, RM.RollBender, NBT_INV_SIDE_IN, SBIT_L, NBT_INV_SIDE_AUTO_IN, SIDE_LEFT, NBT_INV_SIDE_OUT, SBIT_R, NBT_INV_SIDE_AUTO_OUT, SIDE_RIGHT, NBT_ENERGY_ACCEPTED_SIDES, SBIT_B), "wS ", "GMG", " Sh", 'M', OP.casingMachineDouble.dat(aMat), 'G', OP.gearGt.dat(aMat), 'S', OP.gearGtSmall.dat(aMat));
		aMat = MT.DATA.Kinetic_T[2];    aRegistry.add("Roll Bender ("                   +aMat.getLocal()+")", "Basic Machines"                      , 20122, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   6.0F, NBT_RESISTANCE,   6.0F, NBT_INPUT,  128, NBT_TEXTURE, "rollbender", NBT_ENERGY_ACCEPTED, TD.Energy.RU, NBT_RECIPEMAP, RM.RollBender, NBT_INV_SIDE_IN, SBIT_L, NBT_INV_SIDE_AUTO_IN, SIDE_LEFT, NBT_INV_SIDE_OUT, SBIT_R, NBT_INV_SIDE_AUTO_OUT, SIDE_RIGHT, NBT_ENERGY_ACCEPTED_SIDES, SBIT_B), "wS ", "GMG", " Sh", 'M', OP.casingMachineDouble.dat(aMat), 'G', OP.gearGt.dat(aMat), 'S', OP.gearGtSmall.dat(aMat));
		aMat = MT.DATA.Kinetic_T[3];    aRegistry.add("Roll Bender ("                   +aMat.getLocal()+")", "Basic Machines"                      , 20123, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   9.0F, NBT_RESISTANCE,   9.0F, NBT_INPUT,  512, NBT_TEXTURE, "rollbender", NBT_ENERGY_ACCEPTED, TD.Energy.RU, NBT_RECIPEMAP, RM.RollBender, NBT_INV_SIDE_IN, SBIT_L, NBT_INV_SIDE_AUTO_IN, SIDE_LEFT, NBT_INV_SIDE_OUT, SBIT_R, NBT_INV_SIDE_AUTO_OUT, SIDE_RIGHT, NBT_ENERGY_ACCEPTED_SIDES, SBIT_B), "wS ", "GMG", " Sh", 'M', OP.casingMachineDouble.dat(aMat), 'G', OP.gearGt.dat(aMat), 'S', OP.gearGtSmall.dat(aMat));
		aMat = MT.DATA.Kinetic_T[4];    aRegistry.add("Roll Bender ("                   +aMat.getLocal()+")", "Basic Machines"                      , 20124, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,  12.5F, NBT_RESISTANCE,  12.5F, NBT_INPUT, 2048, NBT_TEXTURE, "rollbender", NBT_ENERGY_ACCEPTED, TD.Energy.RU, NBT_RECIPEMAP, RM.RollBender, NBT_INV_SIDE_IN, SBIT_L, NBT_INV_SIDE_AUTO_IN, SIDE_LEFT, NBT_INV_SIDE_OUT, SBIT_R, NBT_INV_SIDE_AUTO_OUT, SIDE_RIGHT, NBT_ENERGY_ACCEPTED_SIDES, SBIT_B), "wS ", "GMG", " Sh", 'M', OP.casingMachineDouble.dat(aMat), 'G', OP.gearGt.dat(aMat), 'S', OP.gearGtSmall.dat(aMat));
		
		aClass = MultiTileEntityBasicMachine.class;
		aMat = MT.DATA.Kinetic_T[1];    aRegistry.add("Roll Former ("                   +aMat.getLocal()+")", "Basic Machines"                      , 20131, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   7.0F, NBT_RESISTANCE,   7.0F, NBT_INPUT,   32, NBT_TEXTURE, "rollformer", NBT_ENERGY_ACCEPTED, TD.Energy.RU, NBT_RECIPEMAP, RM.RollFormer, NBT_INV_SIDE_IN, SBIT_L, NBT_INV_SIDE_AUTO_IN, SIDE_LEFT, NBT_INV_SIDE_OUT, SBIT_R, NBT_INV_SIDE_AUTO_OUT, SIDE_RIGHT, NBT_ENERGY_ACCEPTED_SIDES, SBIT_B), "wG ", "GMG", " Gh", 'M', OP.casingMachineDouble.dat(aMat), 'G', OP.gearGt.dat(aMat));
		aMat = MT.DATA.Kinetic_T[2];    aRegistry.add("Roll Former ("                   +aMat.getLocal()+")", "Basic Machines"                      , 20132, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   6.0F, NBT_RESISTANCE,   6.0F, NBT_INPUT,  128, NBT_TEXTURE, "rollformer", NBT_ENERGY_ACCEPTED, TD.Energy.RU, NBT_RECIPEMAP, RM.RollFormer, NBT_INV_SIDE_IN, SBIT_L, NBT_INV_SIDE_AUTO_IN, SIDE_LEFT, NBT_INV_SIDE_OUT, SBIT_R, NBT_INV_SIDE_AUTO_OUT, SIDE_RIGHT, NBT_ENERGY_ACCEPTED_SIDES, SBIT_B), "wG ", "GMG", " Gh", 'M', OP.casingMachineDouble.dat(aMat), 'G', OP.gearGt.dat(aMat));
		aMat = MT.DATA.Kinetic_T[3];    aRegistry.add("Roll Former ("                   +aMat.getLocal()+")", "Basic Machines"                      , 20133, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   9.0F, NBT_RESISTANCE,   9.0F, NBT_INPUT,  512, NBT_TEXTURE, "rollformer", NBT_ENERGY_ACCEPTED, TD.Energy.RU, NBT_RECIPEMAP, RM.RollFormer, NBT_INV_SIDE_IN, SBIT_L, NBT_INV_SIDE_AUTO_IN, SIDE_LEFT, NBT_INV_SIDE_OUT, SBIT_R, NBT_INV_SIDE_AUTO_OUT, SIDE_RIGHT, NBT_ENERGY_ACCEPTED_SIDES, SBIT_B), "wG ", "GMG", " Gh", 'M', OP.casingMachineDouble.dat(aMat), 'G', OP.gearGt.dat(aMat));
		aMat = MT.DATA.Kinetic_T[4];    aRegistry.add("Roll Former ("                   +aMat.getLocal()+")", "Basic Machines"                      , 20134, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,  12.5F, NBT_RESISTANCE,  12.5F, NBT_INPUT, 2048, NBT_TEXTURE, "rollformer", NBT_ENERGY_ACCEPTED, TD.Energy.RU, NBT_RECIPEMAP, RM.RollFormer, NBT_INV_SIDE_IN, SBIT_L, NBT_INV_SIDE_AUTO_IN, SIDE_LEFT, NBT_INV_SIDE_OUT, SBIT_R, NBT_INV_SIDE_AUTO_OUT, SIDE_RIGHT, NBT_ENERGY_ACCEPTED_SIDES, SBIT_B), "wG ", "GMG", " Gh", 'M', OP.casingMachineDouble.dat(aMat), 'G', OP.gearGt.dat(aMat));
		
		aClass = MultiTileEntityBasicMachine.class;
		aMat = MT.DATA.Kinetic_T[1];    aRegistry.add("Cluster Mill ("                  +aMat.getLocal()+")", "Basic Machines"                      , 20141, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   7.0F, NBT_RESISTANCE,   7.0F, NBT_INPUT,   32, NBT_TEXTURE, "clustermill", NBT_ENERGY_ACCEPTED, TD.Energy.RU, NBT_RECIPEMAP, RM.ClusterMill, NBT_INV_SIDE_IN, SBIT_L, NBT_INV_SIDE_AUTO_IN, SIDE_LEFT, NBT_INV_SIDE_OUT, SBIT_R, NBT_INV_SIDE_AUTO_OUT, SIDE_RIGHT, NBT_ENERGY_ACCEPTED_SIDES, SBIT_B), "SSS", "wGh", "SMS", 'M', OP.casingMachineQuadruple.dat(aMat), 'G', OP.gearGt.dat(aMat), 'S', OP.gearGtSmall.dat(aMat));
		aMat = MT.DATA.Kinetic_T[2];    aRegistry.add("Cluster Mill ("                  +aMat.getLocal()+")", "Basic Machines"                      , 20142, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   6.0F, NBT_RESISTANCE,   6.0F, NBT_INPUT,  128, NBT_TEXTURE, "clustermill", NBT_ENERGY_ACCEPTED, TD.Energy.RU, NBT_RECIPEMAP, RM.ClusterMill, NBT_INV_SIDE_IN, SBIT_L, NBT_INV_SIDE_AUTO_IN, SIDE_LEFT, NBT_INV_SIDE_OUT, SBIT_R, NBT_INV_SIDE_AUTO_OUT, SIDE_RIGHT, NBT_ENERGY_ACCEPTED_SIDES, SBIT_B), "SSS", "wGh", "SMS", 'M', OP.casingMachineQuadruple.dat(aMat), 'G', OP.gearGt.dat(aMat), 'S', OP.gearGtSmall.dat(aMat));
		aMat = MT.DATA.Kinetic_T[3];    aRegistry.add("Cluster Mill ("                  +aMat.getLocal()+")", "Basic Machines"                      , 20143, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   9.0F, NBT_RESISTANCE,   9.0F, NBT_INPUT,  512, NBT_TEXTURE, "clustermill", NBT_ENERGY_ACCEPTED, TD.Energy.RU, NBT_RECIPEMAP, RM.ClusterMill, NBT_INV_SIDE_IN, SBIT_L, NBT_INV_SIDE_AUTO_IN, SIDE_LEFT, NBT_INV_SIDE_OUT, SBIT_R, NBT_INV_SIDE_AUTO_OUT, SIDE_RIGHT, NBT_ENERGY_ACCEPTED_SIDES, SBIT_B), "SSS", "wGh", "SMS", 'M', OP.casingMachineQuadruple.dat(aMat), 'G', OP.gearGt.dat(aMat), 'S', OP.gearGtSmall.dat(aMat));
		aMat = MT.DATA.Kinetic_T[4];    aRegistry.add("Cluster Mill ("                  +aMat.getLocal()+")", "Basic Machines"                      , 20144, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,  12.5F, NBT_RESISTANCE,  12.5F, NBT_INPUT, 2048, NBT_TEXTURE, "clustermill", NBT_ENERGY_ACCEPTED, TD.Energy.RU, NBT_RECIPEMAP, RM.ClusterMill, NBT_INV_SIDE_IN, SBIT_L, NBT_INV_SIDE_AUTO_IN, SIDE_LEFT, NBT_INV_SIDE_OUT, SBIT_R, NBT_INV_SIDE_AUTO_OUT, SIDE_RIGHT, NBT_ENERGY_ACCEPTED_SIDES, SBIT_B), "SSS", "wGh", "SMS", 'M', OP.casingMachineQuadruple.dat(aMat), 'G', OP.gearGt.dat(aMat), 'S', OP.gearGtSmall.dat(aMat));
		
		aClass = MultiTileEntityBasicMachine.class;
		aMat = MT.DATA.Kinetic_T[1];    aRegistry.add("Wiremill ("                      +aMat.getLocal()+")", "Basic Machines"                      , 20151, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   7.0F, NBT_RESISTANCE,   7.0F, NBT_INPUT,   32, NBT_TEXTURE, "wiremill", NBT_ENERGY_ACCEPTED, TD.Energy.RU, NBT_RECIPEMAP, RM.Wiremill, NBT_INV_SIDE_IN, SBIT_L, NBT_INV_SIDE_AUTO_IN, SIDE_LEFT, NBT_INV_SIDE_OUT, SBIT_R, NBT_INV_SIDE_AUTO_OUT, SIDE_RIGHT, NBT_ENERGY_ACCEPTED_SIDES, SBIT_B), "SGS", "wMh", 'M', OP.casingMachine.dat(aMat), 'G', OP.gearGt.dat(aMat), 'S', OP.gearGtSmall.dat(aMat));
		aMat = MT.DATA.Kinetic_T[2];    aRegistry.add("Wiremill ("                      +aMat.getLocal()+")", "Basic Machines"                      , 20152, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   6.0F, NBT_RESISTANCE,   6.0F, NBT_INPUT,  128, NBT_TEXTURE, "wiremill", NBT_ENERGY_ACCEPTED, TD.Energy.RU, NBT_RECIPEMAP, RM.Wiremill, NBT_INV_SIDE_IN, SBIT_L, NBT_INV_SIDE_AUTO_IN, SIDE_LEFT, NBT_INV_SIDE_OUT, SBIT_R, NBT_INV_SIDE_AUTO_OUT, SIDE_RIGHT, NBT_ENERGY_ACCEPTED_SIDES, SBIT_B), "SGS", "wMh", 'M', OP.casingMachine.dat(aMat), 'G', OP.gearGt.dat(aMat), 'S', OP.gearGtSmall.dat(aMat));
		aMat = MT.DATA.Kinetic_T[3];    aRegistry.add("Wiremill ("                      +aMat.getLocal()+")", "Basic Machines"                      , 20153, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   9.0F, NBT_RESISTANCE,   9.0F, NBT_INPUT,  512, NBT_TEXTURE, "wiremill", NBT_ENERGY_ACCEPTED, TD.Energy.RU, NBT_RECIPEMAP, RM.Wiremill, NBT_INV_SIDE_IN, SBIT_L, NBT_INV_SIDE_AUTO_IN, SIDE_LEFT, NBT_INV_SIDE_OUT, SBIT_R, NBT_INV_SIDE_AUTO_OUT, SIDE_RIGHT, NBT_ENERGY_ACCEPTED_SIDES, SBIT_B), "SGS", "wMh", 'M', OP.casingMachine.dat(aMat), 'G', OP.gearGt.dat(aMat), 'S', OP.gearGtSmall.dat(aMat));
		aMat = MT.DATA.Kinetic_T[4];    aRegistry.add("Wiremill ("                      +aMat.getLocal()+")", "Basic Machines"                      , 20154, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,  12.5F, NBT_RESISTANCE,  12.5F, NBT_INPUT, 2048, NBT_TEXTURE, "wiremill", NBT_ENERGY_ACCEPTED, TD.Energy.RU, NBT_RECIPEMAP, RM.Wiremill, NBT_INV_SIDE_IN, SBIT_L, NBT_INV_SIDE_AUTO_IN, SIDE_LEFT, NBT_INV_SIDE_OUT, SBIT_R, NBT_INV_SIDE_AUTO_OUT, SIDE_RIGHT, NBT_ENERGY_ACCEPTED_SIDES, SBIT_B), "SGS", "wMh", 'M', OP.casingMachine.dat(aMat), 'G', OP.gearGt.dat(aMat), 'S', OP.gearGtSmall.dat(aMat));
		
		aClass = MultiTileEntityBasicMachineElectric.class;
		aMat = MT.DATA.Electric_T[1];   aRegistry.add("Canning Machine ("                         +VN[1]+")", "Basic Machines"                      , 20161, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT,   32, NBT_TEXTURE, "canner", NBT_ENERGY_ACCEPTED, TD.Energy.EU, NBT_RECIPEMAP, RM.Canner, NBT_INV_SIDE_IN, SBIT_U|SBIT_L, NBT_INV_SIDE_AUTO_IN, SIDE_LEFT, NBT_INV_SIDE_OUT, SBIT_R|SBIT_D, NBT_INV_SIDE_AUTO_OUT, SIDE_RIGHT, NBT_TANK_SIDE_IN, SBIT_U|SBIT_L, NBT_TANK_SIDE_AUTO_IN, SIDE_TOP, NBT_TANK_SIDE_OUT, SBIT_R|SBIT_D, NBT_TANK_SIDE_AUTO_OUT, SIDE_BOTTOM, NBT_ENERGY_ACCEPTED_SIDES, SBIT_B, NBT_USE_OUTPUT_TANK, T, NBT_TANK_CAPACITY,   128000L), "wPh", "XMX", "CPW", 'M', OP.casingMachine.dat(aMat), 'X', IL.PUMPS[1], 'C', OD_CIRCUITS[1], 'W', MT.DATA.CABLES_01[1], 'P', OP.pipeTiny  .dat(MT.StainlessSteel));
		aMat = MT.DATA.Electric_T[2];   aRegistry.add("Canning Machine ("                         +VN[2]+")", "Basic Machines"                      , 20162, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT,  128, NBT_TEXTURE, "canner", NBT_ENERGY_ACCEPTED, TD.Energy.EU, NBT_RECIPEMAP, RM.Canner, NBT_INV_SIDE_IN, SBIT_U|SBIT_L, NBT_INV_SIDE_AUTO_IN, SIDE_LEFT, NBT_INV_SIDE_OUT, SBIT_R|SBIT_D, NBT_INV_SIDE_AUTO_OUT, SIDE_RIGHT, NBT_TANK_SIDE_IN, SBIT_U|SBIT_L, NBT_TANK_SIDE_AUTO_IN, SIDE_TOP, NBT_TANK_SIDE_OUT, SBIT_R|SBIT_D, NBT_TANK_SIDE_AUTO_OUT, SIDE_BOTTOM, NBT_ENERGY_ACCEPTED_SIDES, SBIT_B, NBT_USE_OUTPUT_TANK, T, NBT_TANK_CAPACITY,   512000L), "wPh", "XMX", "CPW", 'M', OP.casingMachine.dat(aMat), 'X', IL.PUMPS[2], 'C', OD_CIRCUITS[2], 'W', MT.DATA.CABLES_01[2], 'P', OP.pipeSmall .dat(MT.StainlessSteel));
		aMat = MT.DATA.Electric_T[3];   aRegistry.add("Canning Machine ("                         +VN[3]+")", "Basic Machines"                      , 20163, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT,  512, NBT_TEXTURE, "canner", NBT_ENERGY_ACCEPTED, TD.Energy.EU, NBT_RECIPEMAP, RM.Canner, NBT_INV_SIDE_IN, SBIT_U|SBIT_L, NBT_INV_SIDE_AUTO_IN, SIDE_LEFT, NBT_INV_SIDE_OUT, SBIT_R|SBIT_D, NBT_INV_SIDE_AUTO_OUT, SIDE_RIGHT, NBT_TANK_SIDE_IN, SBIT_U|SBIT_L, NBT_TANK_SIDE_AUTO_IN, SIDE_TOP, NBT_TANK_SIDE_OUT, SBIT_R|SBIT_D, NBT_TANK_SIDE_AUTO_OUT, SIDE_BOTTOM, NBT_ENERGY_ACCEPTED_SIDES, SBIT_B, NBT_USE_OUTPUT_TANK, T, NBT_TANK_CAPACITY,  2048000L), "wPh", "XMX", "CPW", 'M', OP.casingMachine.dat(aMat), 'X', IL.PUMPS[3], 'C', OD_CIRCUITS[3], 'W', MT.DATA.CABLES_01[3], 'P', OP.pipeMedium.dat(MT.StainlessSteel));
		aMat = MT.DATA.Electric_T[4];   aRegistry.add("Canning Machine ("                         +VN[4]+")", "Basic Machines"                      , 20164, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT, 2048, NBT_TEXTURE, "canner", NBT_ENERGY_ACCEPTED, TD.Energy.EU, NBT_RECIPEMAP, RM.Canner, NBT_INV_SIDE_IN, SBIT_U|SBIT_L, NBT_INV_SIDE_AUTO_IN, SIDE_LEFT, NBT_INV_SIDE_OUT, SBIT_R|SBIT_D, NBT_INV_SIDE_AUTO_OUT, SIDE_RIGHT, NBT_TANK_SIDE_IN, SBIT_U|SBIT_L, NBT_TANK_SIDE_AUTO_IN, SIDE_TOP, NBT_TANK_SIDE_OUT, SBIT_R|SBIT_D, NBT_TANK_SIDE_AUTO_OUT, SIDE_BOTTOM, NBT_ENERGY_ACCEPTED_SIDES, SBIT_B, NBT_USE_OUTPUT_TANK, T, NBT_TANK_CAPACITY,  8192000L), "wPh", "XMX", "CPW", 'M', OP.casingMachine.dat(aMat), 'X', IL.PUMPS[4], 'C', OD_CIRCUITS[4], 'W', MT.DATA.CABLES_01[4], 'P', OP.pipeLarge .dat(MT.StainlessSteel));
		aMat = MT.DATA.Electric_T[5];   aRegistry.add("Canning Machine ("                         +VN[5]+")", "Basic Machines"                      , 20165, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT, 8192, NBT_TEXTURE, "canner", NBT_ENERGY_ACCEPTED, TD.Energy.EU, NBT_RECIPEMAP, RM.Canner, NBT_INV_SIDE_IN, SBIT_U|SBIT_L, NBT_INV_SIDE_AUTO_IN, SIDE_LEFT, NBT_INV_SIDE_OUT, SBIT_R|SBIT_D, NBT_INV_SIDE_AUTO_OUT, SIDE_RIGHT, NBT_TANK_SIDE_IN, SBIT_U|SBIT_L, NBT_TANK_SIDE_AUTO_IN, SIDE_TOP, NBT_TANK_SIDE_OUT, SBIT_R|SBIT_D, NBT_TANK_SIDE_AUTO_OUT, SIDE_BOTTOM, NBT_ENERGY_ACCEPTED_SIDES, SBIT_B, NBT_USE_OUTPUT_TANK, T, NBT_TANK_CAPACITY, 32768000L), "wPh", "XMX", "CPW", 'M', OP.casingMachine.dat(aMat), 'X', IL.PUMPS[5], 'C', OD_CIRCUITS[5], 'W', MT.DATA.CABLES_01[5], 'P', OP.pipeHuge  .dat(MT.StainlessSteel));
		
		aClass = MultiTileEntityBasicMachine.class;
		aMat = MT.DATA.Heat_T[1];       aRegistry.add("Roasting Oven ("                 +aMat.getLocal()+")", "Basic Machines"                      , 20171, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   6.0F, NBT_RESISTANCE,   6.0F, NBT_INPUT,   32, NBT_TEXTURE, "roaster", NBT_ENERGY_ACCEPTED, TD.Energy.HU, NBT_RECIPEMAP, RM.Roasting, NBT_INV_SIDE_IN, SBIT_B|SBIT_L, NBT_INV_SIDE_AUTO_IN, SIDE_LEFT, NBT_INV_SIDE_OUT, SBIT_R, NBT_INV_SIDE_AUTO_OUT, SIDE_RIGHT, NBT_TANK_SIDE_IN, SBIT_B|SBIT_L, NBT_TANK_SIDE_AUTO_IN, SIDE_BACK, NBT_TANK_SIDE_OUT, SBIT_U, NBT_TANK_SIDE_AUTO_OUT, SIDE_TOP, NBT_ENERGY_ACCEPTED_SIDES, SBIT_D, NBT_CHEAP_OVERCLOCKING, T, NBT_PARALLEL, 1), "wPh", "PMP", "BCB", 'M', OP.casingMachine.dat(aMat), 'C', OP.plateDouble.dat(ANY.Cu), 'B', Blocks.brick_block, 'P', OP.pipeMedium.dat(aMat));
		aMat = MT.DATA.Heat_T[2];       aRegistry.add("Roasting Oven ("                 +aMat.getLocal()+")", "Basic Machines"                      , 20172, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT,  128, NBT_TEXTURE, "roaster", NBT_ENERGY_ACCEPTED, TD.Energy.HU, NBT_RECIPEMAP, RM.Roasting, NBT_INV_SIDE_IN, SBIT_B|SBIT_L, NBT_INV_SIDE_AUTO_IN, SIDE_LEFT, NBT_INV_SIDE_OUT, SBIT_R, NBT_INV_SIDE_AUTO_OUT, SIDE_RIGHT, NBT_TANK_SIDE_IN, SBIT_B|SBIT_L, NBT_TANK_SIDE_AUTO_IN, SIDE_BACK, NBT_TANK_SIDE_OUT, SBIT_U, NBT_TANK_SIDE_AUTO_OUT, SIDE_TOP, NBT_ENERGY_ACCEPTED_SIDES, SBIT_D, NBT_CHEAP_OVERCLOCKING, T, NBT_PARALLEL, 2), "wPh", "PMP", "BCB", 'M', OP.casingMachine.dat(aMat), 'C', OP.plateDouble.dat(ANY.Cu), 'B', Blocks.brick_block, 'P', OP.pipeMedium.dat(aMat));
		aMat = MT.DATA.Heat_T[3];       aRegistry.add("Roasting Oven ("                 +aMat.getLocal()+")", "Basic Machines"                      , 20173, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   9.0F, NBT_RESISTANCE,   9.0F, NBT_INPUT,  512, NBT_TEXTURE, "roaster", NBT_ENERGY_ACCEPTED, TD.Energy.HU, NBT_RECIPEMAP, RM.Roasting, NBT_INV_SIDE_IN, SBIT_B|SBIT_L, NBT_INV_SIDE_AUTO_IN, SIDE_LEFT, NBT_INV_SIDE_OUT, SBIT_R, NBT_INV_SIDE_AUTO_OUT, SIDE_RIGHT, NBT_TANK_SIDE_IN, SBIT_B|SBIT_L, NBT_TANK_SIDE_AUTO_IN, SIDE_BACK, NBT_TANK_SIDE_OUT, SBIT_U, NBT_TANK_SIDE_AUTO_OUT, SIDE_TOP, NBT_ENERGY_ACCEPTED_SIDES, SBIT_D, NBT_CHEAP_OVERCLOCKING, T, NBT_PARALLEL, 4), "wPh", "PMP", "BCB", 'M', OP.casingMachine.dat(aMat), 'C', OP.plateDouble.dat(ANY.Cu), 'B', Blocks.brick_block, 'P', OP.pipeMedium.dat(aMat));
		aMat = MT.DATA.Heat_T[4];       aRegistry.add("Roasting Oven ("                 +aMat.getLocal()+")", "Basic Machines"                      , 20174, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,  12.5F, NBT_RESISTANCE,  12.5F, NBT_INPUT, 2048, NBT_TEXTURE, "roaster", NBT_ENERGY_ACCEPTED, TD.Energy.HU, NBT_RECIPEMAP, RM.Roasting, NBT_INV_SIDE_IN, SBIT_B|SBIT_L, NBT_INV_SIDE_AUTO_IN, SIDE_LEFT, NBT_INV_SIDE_OUT, SBIT_R, NBT_INV_SIDE_AUTO_OUT, SIDE_RIGHT, NBT_TANK_SIDE_IN, SBIT_B|SBIT_L, NBT_TANK_SIDE_AUTO_IN, SIDE_BACK, NBT_TANK_SIDE_OUT, SBIT_U, NBT_TANK_SIDE_AUTO_OUT, SIDE_TOP, NBT_ENERGY_ACCEPTED_SIDES, SBIT_D, NBT_CHEAP_OVERCLOCKING, T, NBT_PARALLEL, 8), "wPh", "PMP", "BCB", 'M', OP.casingMachine.dat(aMat), 'C', OP.plateDouble.dat(ANY.Cu), 'B', Blocks.brick_block, 'P', OP.pipeMedium.dat(aMat));
		
		aClass = MultiTileEntityBasicMachine.class;
		aMat = MT.DATA.Kinetic_T[1];    aRegistry.add("Mixer ("                         +aMat.getLocal()+")", "Basic Machines"                      , 20181, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   7.0F, NBT_RESISTANCE,   7.0F, NBT_INPUT,   32, NBT_TEXTURE, "mixer", NBT_ENERGY_ACCEPTED, TD.Energy.RU, NBT_RECIPEMAP, RM.Mixer, NBT_INV_SIDE_IN, SBIT_L|SBIT_U, NBT_INV_SIDE_AUTO_IN, SIDE_LEFT, NBT_INV_SIDE_OUT, SBIT_R|SBIT_B, NBT_INV_SIDE_AUTO_OUT, SIDE_RIGHT, NBT_TANK_SIDE_IN, SBIT_L|SBIT_U, NBT_TANK_SIDE_AUTO_IN, SIDE_TOP, NBT_TANK_SIDE_OUT, SBIT_R|SBIT_B, NBT_TANK_SIDE_AUTO_OUT, SIDE_BACK, NBT_ENERGY_ACCEPTED_SIDES, SBIT_D, NBT_PARALLEL, 4, NBT_PARALLEL_DURATION, T), "PMP", "PRP", "hSw", 'M', OP.casingMachine.dat(aMat), 'S', OP.stick.dat(aMat), 'R', OP.rotor.dat(MT.StainlessSteel), 'P', OP.plate.dat(MT.StainlessSteel));
		aMat = MT.DATA.Kinetic_T[2];    aRegistry.add("Mixer ("                         +aMat.getLocal()+")", "Basic Machines"                      , 20182, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   6.0F, NBT_RESISTANCE,   6.0F, NBT_INPUT,  128, NBT_TEXTURE, "mixer", NBT_ENERGY_ACCEPTED, TD.Energy.RU, NBT_RECIPEMAP, RM.Mixer, NBT_INV_SIDE_IN, SBIT_L|SBIT_U, NBT_INV_SIDE_AUTO_IN, SIDE_LEFT, NBT_INV_SIDE_OUT, SBIT_R|SBIT_B, NBT_INV_SIDE_AUTO_OUT, SIDE_RIGHT, NBT_TANK_SIDE_IN, SBIT_L|SBIT_U, NBT_TANK_SIDE_AUTO_IN, SIDE_TOP, NBT_TANK_SIDE_OUT, SBIT_R|SBIT_B, NBT_TANK_SIDE_AUTO_OUT, SIDE_BACK, NBT_ENERGY_ACCEPTED_SIDES, SBIT_D, NBT_PARALLEL, 8, NBT_PARALLEL_DURATION, T), "PMP", "PRP", "hSw", 'M', OP.casingMachine.dat(aMat), 'S', OP.stick.dat(aMat), 'R', OP.rotor.dat(MT.StainlessSteel), 'P', OP.plateDouble.dat(MT.StainlessSteel));
		aMat = MT.DATA.Kinetic_T[3];    aRegistry.add("Mixer ("                         +aMat.getLocal()+")", "Basic Machines"                      , 20183, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   9.0F, NBT_RESISTANCE,   9.0F, NBT_INPUT,  512, NBT_TEXTURE, "mixer", NBT_ENERGY_ACCEPTED, TD.Energy.RU, NBT_RECIPEMAP, RM.Mixer, NBT_INV_SIDE_IN, SBIT_L|SBIT_U, NBT_INV_SIDE_AUTO_IN, SIDE_LEFT, NBT_INV_SIDE_OUT, SBIT_R|SBIT_B, NBT_INV_SIDE_AUTO_OUT, SIDE_RIGHT, NBT_TANK_SIDE_IN, SBIT_L|SBIT_U, NBT_TANK_SIDE_AUTO_IN, SIDE_TOP, NBT_TANK_SIDE_OUT, SBIT_R|SBIT_B, NBT_TANK_SIDE_AUTO_OUT, SIDE_BACK, NBT_ENERGY_ACCEPTED_SIDES, SBIT_D, NBT_PARALLEL,16, NBT_PARALLEL_DURATION, T), "PMP", "PRP", "hSw", 'M', OP.casingMachine.dat(aMat), 'S', OP.stick.dat(aMat), 'R', OP.rotor.dat(MT.StainlessSteel), 'P', OP.plateTriple.dat(MT.StainlessSteel));
		aMat = MT.DATA.Kinetic_T[4];    aRegistry.add("Mixer ("                         +aMat.getLocal()+")", "Basic Machines"                      , 20184, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,  12.5F, NBT_RESISTANCE,  12.5F, NBT_INPUT, 2048, NBT_TEXTURE, "mixer", NBT_ENERGY_ACCEPTED, TD.Energy.RU, NBT_RECIPEMAP, RM.Mixer, NBT_INV_SIDE_IN, SBIT_L|SBIT_U, NBT_INV_SIDE_AUTO_IN, SIDE_LEFT, NBT_INV_SIDE_OUT, SBIT_R|SBIT_B, NBT_INV_SIDE_AUTO_OUT, SIDE_RIGHT, NBT_TANK_SIDE_IN, SBIT_L|SBIT_U, NBT_TANK_SIDE_AUTO_IN, SIDE_TOP, NBT_TANK_SIDE_OUT, SBIT_R|SBIT_B, NBT_TANK_SIDE_AUTO_OUT, SIDE_BACK, NBT_ENERGY_ACCEPTED_SIDES, SBIT_D, NBT_PARALLEL,32, NBT_PARALLEL_DURATION, T), "PMP", "PRP", "hSw", 'M', OP.casingMachine.dat(aMat), 'S', OP.stick.dat(aMat), 'R', OP.rotor.dat(MT.StainlessSteel), 'P', OP.plateQuadruple.dat(MT.StainlessSteel));
		
		aClass = MultiTileEntityBasicMachine.class;
		aMat = MT.DATA.Heat_T[1];       aRegistry.add("Distillery ("                    +aMat.getLocal()+")", "Basic Machines"                      , 20191, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   6.0F, NBT_RESISTANCE,   6.0F, NBT_INPUT,   32, NBT_TEXTURE, "distillery", NBT_ENERGY_ACCEPTED, TD.Energy.HU, NBT_RECIPEMAP, RM.Distillery, NBT_INV_SIDE_IN, SBIT_U|SBIT_L, NBT_INV_SIDE_AUTO_IN, SIDE_LEFT, NBT_INV_SIDE_OUT, SBIT_R, NBT_INV_SIDE_AUTO_OUT, SIDE_RIGHT, NBT_TANK_SIDE_IN, SBIT_U|SBIT_L, NBT_TANK_SIDE_AUTO_IN, SIDE_TOP, NBT_TANK_SIDE_OUT, SBIT_B, NBT_TANK_SIDE_AUTO_OUT, SIDE_BACK, NBT_ENERGY_ACCEPTED_SIDES, SBIT_D, NBT_CHEAP_OVERCLOCKING, T, NBT_PARALLEL, 8, NBT_PARALLEL_DURATION, T), "GPG", "WMW", "hCw", 'M', OP.casingMachine.dat(aMat), 'W', OP.wireGt02.dat(MT.Constantan), 'C', OP.plateDouble.dat(ANY.Cu), 'G', OD.blockGlassColorless, 'P', OP.pipeTiny  .dat(MT.StainlessSteel));
		aMat = MT.DATA.Heat_T[2];       aRegistry.add("Distillery ("                    +aMat.getLocal()+")", "Basic Machines"                      , 20192, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT,  128, NBT_TEXTURE, "distillery", NBT_ENERGY_ACCEPTED, TD.Energy.HU, NBT_RECIPEMAP, RM.Distillery, NBT_INV_SIDE_IN, SBIT_U|SBIT_L, NBT_INV_SIDE_AUTO_IN, SIDE_LEFT, NBT_INV_SIDE_OUT, SBIT_R, NBT_INV_SIDE_AUTO_OUT, SIDE_RIGHT, NBT_TANK_SIDE_IN, SBIT_U|SBIT_L, NBT_TANK_SIDE_AUTO_IN, SIDE_TOP, NBT_TANK_SIDE_OUT, SBIT_B, NBT_TANK_SIDE_AUTO_OUT, SIDE_BACK, NBT_ENERGY_ACCEPTED_SIDES, SBIT_D, NBT_CHEAP_OVERCLOCKING, T, NBT_PARALLEL,16, NBT_PARALLEL_DURATION, T), "GPG", "WMW", "hCw", 'M', OP.casingMachine.dat(aMat), 'W', OP.wireGt04.dat(MT.Kanthal   ), 'C', OP.plateDouble.dat(ANY.Cu), 'G', OD.blockGlassColorless, 'P', OP.pipeSmall .dat(MT.StainlessSteel));
		aMat = MT.DATA.Heat_T[3];       aRegistry.add("Distillery ("                    +aMat.getLocal()+")", "Basic Machines"                      , 20193, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   9.0F, NBT_RESISTANCE,   9.0F, NBT_INPUT,  512, NBT_TEXTURE, "distillery", NBT_ENERGY_ACCEPTED, TD.Energy.HU, NBT_RECIPEMAP, RM.Distillery, NBT_INV_SIDE_IN, SBIT_U|SBIT_L, NBT_INV_SIDE_AUTO_IN, SIDE_LEFT, NBT_INV_SIDE_OUT, SBIT_R, NBT_INV_SIDE_AUTO_OUT, SIDE_RIGHT, NBT_TANK_SIDE_IN, SBIT_U|SBIT_L, NBT_TANK_SIDE_AUTO_IN, SIDE_TOP, NBT_TANK_SIDE_OUT, SBIT_B, NBT_TANK_SIDE_AUTO_OUT, SIDE_BACK, NBT_ENERGY_ACCEPTED_SIDES, SBIT_D, NBT_CHEAP_OVERCLOCKING, T, NBT_PARALLEL,32, NBT_PARALLEL_DURATION, T), "GPG", "WMW", "hCw", 'M', OP.casingMachine.dat(aMat), 'W', OP.wireGt08.dat(MT.Nichrome  ), 'C', OP.plateDouble.dat(ANY.Cu), 'G', OD.blockGlassColorless, 'P', OP.pipeMedium.dat(MT.StainlessSteel));
		aMat = MT.DATA.Heat_T[4];       aRegistry.add("Distillery ("                    +aMat.getLocal()+")", "Basic Machines"                      , 20194, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,  12.5F, NBT_RESISTANCE,  12.5F, NBT_INPUT, 2048, NBT_TEXTURE, "distillery", NBT_ENERGY_ACCEPTED, TD.Energy.HU, NBT_RECIPEMAP, RM.Distillery, NBT_INV_SIDE_IN, SBIT_U|SBIT_L, NBT_INV_SIDE_AUTO_IN, SIDE_LEFT, NBT_INV_SIDE_OUT, SBIT_R, NBT_INV_SIDE_AUTO_OUT, SIDE_RIGHT, NBT_TANK_SIDE_IN, SBIT_U|SBIT_L, NBT_TANK_SIDE_AUTO_IN, SIDE_TOP, NBT_TANK_SIDE_OUT, SBIT_B, NBT_TANK_SIDE_AUTO_OUT, SIDE_BACK, NBT_ENERGY_ACCEPTED_SIDES, SBIT_D, NBT_CHEAP_OVERCLOCKING, T, NBT_PARALLEL,64, NBT_PARALLEL_DURATION, T), "GPG", "WMW", "hCw", 'M', OP.casingMachine.dat(aMat), 'W', OP.wireGt16.dat(MT.SiC       ), 'C', OP.plateDouble.dat(ANY.Cu), 'G', OD.blockGlassColorless, 'P', OP.pipeLarge .dat(MT.StainlessSteel));
	}
	
	private static void machines2(MultiTileEntityRegistry aRegistry, MultiTileEntityBlock aMetal, MultiTileEntityBlock aMetalChips, MultiTileEntityBlock aMetalWires, MultiTileEntityBlock aMachine, MultiTileEntityBlock aWooden, MultiTileEntityBlock aBush, MultiTileEntityBlock aStone, MultiTileEntityBlock aWool, MultiTileEntityBlock aTNT, MultiTileEntityBlock aHive, MultiTileEntityBlock aUtilMetal, MultiTileEntityBlock aUtilStone, MultiTileEntityBlock aUtilWood, MultiTileEntityBlock aUtilWool, OreDictMaterial aMat, Class<? extends TileEntity> aClass) {
		aClass = MultiTileEntityBasicMachine.class;
		aMat = MT.DATA.Heat_T[1];       aRegistry.add("Low Heat Extruder ("             +aMat.getLocal()+")", "Basic Machines"                      , 20201, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   6.0F, NBT_RESISTANCE,   6.0F, NBT_INPUT,   32, NBT_TEXTURE, "extruder", NBT_ENERGY_ACCEPTED, TD.Energy.HU, NBT_RECIPEMAP, RM.Extruder, NBT_INV_SIDE_IN, SBIT_L, NBT_INV_SIDE_AUTO_IN, SIDE_LEFT, NBT_INV_SIDE_OUT, SBIT_R, NBT_INV_SIDE_AUTO_OUT, SIDE_RIGHT, NBT_ENERGY_ACCEPTED_SIDES, SBIT_D), "GPw", "PMS", "GPD", 'M', OP.casingMachineDouble.dat(aMat), 'S', OP.toolHeadBuzzSaw.dat(ANY.Steel          ), 'D', OP.dust.dat(ANY.Diamond), 'G', OP.gearGt.dat(aMat), 'P', OP.plate            .dat(ANY.Steel));
		aMat = MT.DATA.Heat_T[2];       aRegistry.add("Extruder ("                      +aMat.getLocal()+")", "Basic Machines"                      , 20202, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT,  128, NBT_TEXTURE, "extruder", NBT_ENERGY_ACCEPTED, TD.Energy.HU, NBT_RECIPEMAP, RM.Extruder, NBT_INV_SIDE_IN, SBIT_L, NBT_INV_SIDE_AUTO_IN, SIDE_LEFT, NBT_INV_SIDE_OUT, SBIT_R, NBT_INV_SIDE_AUTO_OUT, SIDE_RIGHT, NBT_ENERGY_ACCEPTED_SIDES, SBIT_D), "GPw", "PMS", "GPD", 'M', OP.casingMachineDouble.dat(aMat), 'S', OP.toolHeadBuzzSaw.dat(MT.TungstenCarbide ), 'D', OP.dust.dat(ANY.Diamond), 'G', OP.gearGt.dat(aMat), 'P', OP.plateDouble      .dat(MT.TungstenCarbide));
		aMat = MT.DATA.Heat_T[3];       aRegistry.add("Extruder ("                      +aMat.getLocal()+")", "Basic Machines"                      , 20203, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   9.0F, NBT_RESISTANCE,   9.0F, NBT_INPUT,  512, NBT_TEXTURE, "extruder", NBT_ENERGY_ACCEPTED, TD.Energy.HU, NBT_RECIPEMAP, RM.Extruder, NBT_INV_SIDE_IN, SBIT_L, NBT_INV_SIDE_AUTO_IN, SIDE_LEFT, NBT_INV_SIDE_OUT, SBIT_R, NBT_INV_SIDE_AUTO_OUT, SIDE_RIGHT, NBT_ENERGY_ACCEPTED_SIDES, SBIT_D), "GPw", "PMS", "GPD", 'M', OP.casingMachineDouble.dat(aMat), 'S', OP.toolHeadBuzzSaw.dat(MT.TungstenCarbide ), 'D', OP.dust.dat(ANY.Diamond), 'G', OP.gearGt.dat(aMat), 'P', OP.plateTriple      .dat(MT.TungstenCarbide));
		aMat = MT.DATA.Heat_T[4];       aRegistry.add("Extruder ("                      +aMat.getLocal()+")", "Basic Machines"                      , 20204, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,  12.5F, NBT_RESISTANCE,  12.5F, NBT_INPUT, 2048, NBT_TEXTURE, "extruder", NBT_ENERGY_ACCEPTED, TD.Energy.HU, NBT_RECIPEMAP, RM.Extruder, NBT_INV_SIDE_IN, SBIT_L, NBT_INV_SIDE_AUTO_IN, SIDE_LEFT, NBT_INV_SIDE_OUT, SBIT_R, NBT_INV_SIDE_AUTO_OUT, SIDE_RIGHT, NBT_ENERGY_ACCEPTED_SIDES, SBIT_D), "GPw", "PMS", "GPD", 'M', OP.casingMachineDouble.dat(aMat), 'S', OP.toolHeadBuzzSaw.dat(MT.TungstenCarbide ), 'D', OP.dust.dat(ANY.Diamond), 'G', OP.gearGt.dat(aMat), 'P', OP.plateQuadruple   .dat(MT.TungstenCarbide));
		
		aClass = MultiTileEntityBasicMachine.class;
		aMat = MT.DATA.Kinetic_T[1];    aRegistry.add("Loom ("                          +aMat.getLocal()+")", "Basic Machines"                      , 20211, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   7.0F, NBT_RESISTANCE,   7.0F, NBT_INPUT,   32, NBT_TEXTURE, "loom", NBT_ENERGY_ACCEPTED, TD.Energy.RU, NBT_RECIPEMAP, RM.Loom, NBT_INV_SIDE_IN, SBIT_U, NBT_INV_SIDE_AUTO_IN, SIDE_TOP, NBT_INV_SIDE_OUT, SBIT_D, NBT_INV_SIDE_AUTO_OUT, SIDE_BOTTOM, NBT_ENERGY_ACCEPTED_SIDES, SBIT_L|SBIT_R), "ShS", "GMG", "SwS", 'M', OP.casingMachine.dat(aMat), 'G', OP.gearGt.dat(aMat), 'S', OP.stickLong.dat(aMat));
		aMat = MT.DATA.Kinetic_T[2];    aRegistry.add("Loom ("                          +aMat.getLocal()+")", "Basic Machines"                      , 20212, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   6.0F, NBT_RESISTANCE,   6.0F, NBT_INPUT,  128, NBT_TEXTURE, "loom", NBT_ENERGY_ACCEPTED, TD.Energy.RU, NBT_RECIPEMAP, RM.Loom, NBT_INV_SIDE_IN, SBIT_U, NBT_INV_SIDE_AUTO_IN, SIDE_TOP, NBT_INV_SIDE_OUT, SBIT_D, NBT_INV_SIDE_AUTO_OUT, SIDE_BOTTOM, NBT_ENERGY_ACCEPTED_SIDES, SBIT_L|SBIT_R), "ShS", "GMG", "SwS", 'M', OP.casingMachine.dat(aMat), 'G', OP.gearGt.dat(aMat), 'S', OP.stickLong.dat(aMat));
		aMat = MT.DATA.Kinetic_T[3];    aRegistry.add("Loom ("                          +aMat.getLocal()+")", "Basic Machines"                      , 20213, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   9.0F, NBT_RESISTANCE,   9.0F, NBT_INPUT,  512, NBT_TEXTURE, "loom", NBT_ENERGY_ACCEPTED, TD.Energy.RU, NBT_RECIPEMAP, RM.Loom, NBT_INV_SIDE_IN, SBIT_U, NBT_INV_SIDE_AUTO_IN, SIDE_TOP, NBT_INV_SIDE_OUT, SBIT_D, NBT_INV_SIDE_AUTO_OUT, SIDE_BOTTOM, NBT_ENERGY_ACCEPTED_SIDES, SBIT_L|SBIT_R), "ShS", "GMG", "SwS", 'M', OP.casingMachine.dat(aMat), 'G', OP.gearGt.dat(aMat), 'S', OP.stickLong.dat(aMat));
		aMat = MT.DATA.Kinetic_T[4];    aRegistry.add("Loom ("                          +aMat.getLocal()+")", "Basic Machines"                      , 20214, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,  12.5F, NBT_RESISTANCE,  12.5F, NBT_INPUT, 2048, NBT_TEXTURE, "loom", NBT_ENERGY_ACCEPTED, TD.Energy.RU, NBT_RECIPEMAP, RM.Loom, NBT_INV_SIDE_IN, SBIT_U, NBT_INV_SIDE_AUTO_IN, SIDE_TOP, NBT_INV_SIDE_OUT, SBIT_D, NBT_INV_SIDE_AUTO_OUT, SIDE_BOTTOM, NBT_ENERGY_ACCEPTED_SIDES, SBIT_L|SBIT_R), "ShS", "GMG", "SwS", 'M', OP.casingMachine.dat(aMat), 'G', OP.gearGt.dat(aMat), 'S', OP.stickLong.dat(aMat));
		
		aClass = MultiTileEntityBasicMachine.class;
		aMat = MT.DATA.Electric_T[1];   aRegistry.add("Polarizer ("                     +aMat.getLocal()+")", "Basic Machines"                      , 20221, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT,   32, NBT_TEXTURE, "polarizer", NBT_ENERGY_ACCEPTED, TD.Energy.MU, NBT_RECIPEMAP, RM.Polarizer, NBT_INV_SIDE_IN, SBIT_L, NBT_INV_SIDE_AUTO_IN, SIDE_LEFT, NBT_INV_SIDE_OUT, SBIT_R, NBT_INV_SIDE_AUTO_OUT, SIDE_RIGHT, NBT_ENERGY_ACCEPTED_SIDES, SBIT_U|SBIT_D), "TwT", "PMP", "TdT", 'M', OP.casingMachine.dat(aMat), 'P', OP.plate.dat(aMat), 'T', OP.screw.dat(aMat));
		aMat = MT.DATA.Electric_T[2];   aRegistry.add("Polarizer ("                     +aMat.getLocal()+")", "Basic Machines"                      , 20222, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT,  128, NBT_TEXTURE, "polarizer", NBT_ENERGY_ACCEPTED, TD.Energy.MU, NBT_RECIPEMAP, RM.Polarizer, NBT_INV_SIDE_IN, SBIT_L, NBT_INV_SIDE_AUTO_IN, SIDE_LEFT, NBT_INV_SIDE_OUT, SBIT_R, NBT_INV_SIDE_AUTO_OUT, SIDE_RIGHT, NBT_ENERGY_ACCEPTED_SIDES, SBIT_U|SBIT_D), "TwT", "PMP", "TdT", 'M', OP.casingMachine.dat(aMat), 'P', OP.plate.dat(aMat), 'T', OP.screw.dat(aMat));
		aMat = MT.DATA.Electric_T[3];   aRegistry.add("Polarizer ("                     +aMat.getLocal()+")", "Basic Machines"                      , 20223, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT,  512, NBT_TEXTURE, "polarizer", NBT_ENERGY_ACCEPTED, TD.Energy.MU, NBT_RECIPEMAP, RM.Polarizer, NBT_INV_SIDE_IN, SBIT_L, NBT_INV_SIDE_AUTO_IN, SIDE_LEFT, NBT_INV_SIDE_OUT, SBIT_R, NBT_INV_SIDE_AUTO_OUT, SIDE_RIGHT, NBT_ENERGY_ACCEPTED_SIDES, SBIT_U|SBIT_D), "TwT", "PMP", "TdT", 'M', OP.casingMachine.dat(aMat), 'P', OP.plate.dat(aMat), 'T', OP.screw.dat(aMat));
		aMat = MT.DATA.Electric_T[4];   aRegistry.add("Polarizer ("                     +aMat.getLocal()+")", "Basic Machines"                      , 20224, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT, 2048, NBT_TEXTURE, "polarizer", NBT_ENERGY_ACCEPTED, TD.Energy.MU, NBT_RECIPEMAP, RM.Polarizer, NBT_INV_SIDE_IN, SBIT_L, NBT_INV_SIDE_AUTO_IN, SIDE_LEFT, NBT_INV_SIDE_OUT, SBIT_R, NBT_INV_SIDE_AUTO_OUT, SIDE_RIGHT, NBT_ENERGY_ACCEPTED_SIDES, SBIT_U|SBIT_D), "TwT", "PMP", "TdT", 'M', OP.casingMachine.dat(aMat), 'P', OP.plate.dat(aMat), 'T', OP.screw.dat(aMat));
		aMat = MT.DATA.Electric_T[5];   aRegistry.add("Polarizer ("                     +aMat.getLocal()+")", "Basic Machines"                      , 20225, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT, 8192, NBT_TEXTURE, "polarizer", NBT_ENERGY_ACCEPTED, TD.Energy.MU, NBT_RECIPEMAP, RM.Polarizer, NBT_INV_SIDE_IN, SBIT_L, NBT_INV_SIDE_AUTO_IN, SIDE_LEFT, NBT_INV_SIDE_OUT, SBIT_R, NBT_INV_SIDE_AUTO_OUT, SIDE_RIGHT, NBT_ENERGY_ACCEPTED_SIDES, SBIT_U|SBIT_D), "TwT", "PMP", "TdT", 'M', OP.casingMachine.dat(aMat), 'P', OP.plate.dat(aMat), 'T', OP.screw.dat(aMat));
		
		aClass = MultiTileEntityBasicMachine.class;
		aMat = MT.DATA.Kinetic_T[1];    aRegistry.add("Press ("                         +aMat.getLocal()+")", "Basic Machines"                      , 20231, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   7.0F, NBT_RESISTANCE,   7.0F, NBT_INPUT,   32, NBT_TEXTURE, "press", NBT_ENERGY_ACCEPTED, TD.Energy.KU, NBT_RECIPEMAP, RM.Press, NBT_INV_SIDE_IN, SBIT_L, NBT_INV_SIDE_AUTO_IN, SIDE_LEFT, NBT_INV_SIDE_OUT, SBIT_R, NBT_INV_SIDE_AUTO_OUT, SIDE_RIGHT, NBT_ENERGY_ACCEPTED_SIDES, SBIT_U, NBT_PARALLEL, 4, NBT_PARALLEL_DURATION, T), "RS", "PM", "Pw", 'M', OP.casingMachine.dat(aMat), 'P', OP.plateDouble.dat(aMat), 'S', OP.spring.dat(aMat), 'R', OP.stick.dat(aMat));
		aMat = MT.DATA.Kinetic_T[2];    aRegistry.add("Press ("                         +aMat.getLocal()+")", "Basic Machines"                      , 20232, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   6.0F, NBT_RESISTANCE,   6.0F, NBT_INPUT,  128, NBT_TEXTURE, "press", NBT_ENERGY_ACCEPTED, TD.Energy.KU, NBT_RECIPEMAP, RM.Press, NBT_INV_SIDE_IN, SBIT_L, NBT_INV_SIDE_AUTO_IN, SIDE_LEFT, NBT_INV_SIDE_OUT, SBIT_R, NBT_INV_SIDE_AUTO_OUT, SIDE_RIGHT, NBT_ENERGY_ACCEPTED_SIDES, SBIT_U, NBT_PARALLEL, 8, NBT_PARALLEL_DURATION, T), "RS", "PM", "Pw", 'M', OP.casingMachine.dat(aMat), 'P', OP.plateDouble.dat(aMat), 'S', OP.spring.dat(aMat), 'R', OP.stick.dat(aMat));
		aMat = MT.DATA.Kinetic_T[3];    aRegistry.add("Press ("                         +aMat.getLocal()+")", "Basic Machines"                      , 20233, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   9.0F, NBT_RESISTANCE,   9.0F, NBT_INPUT,  512, NBT_TEXTURE, "press", NBT_ENERGY_ACCEPTED, TD.Energy.KU, NBT_RECIPEMAP, RM.Press, NBT_INV_SIDE_IN, SBIT_L, NBT_INV_SIDE_AUTO_IN, SIDE_LEFT, NBT_INV_SIDE_OUT, SBIT_R, NBT_INV_SIDE_AUTO_OUT, SIDE_RIGHT, NBT_ENERGY_ACCEPTED_SIDES, SBIT_U, NBT_PARALLEL,16, NBT_PARALLEL_DURATION, T), "RS", "PM", "Pw", 'M', OP.casingMachine.dat(aMat), 'P', OP.plateDouble.dat(aMat), 'S', OP.spring.dat(aMat), 'R', OP.stick.dat(aMat));
		aMat = MT.DATA.Kinetic_T[4];    aRegistry.add("Press ("                         +aMat.getLocal()+")", "Basic Machines"                      , 20234, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,  12.5F, NBT_RESISTANCE,  12.5F, NBT_INPUT, 2048, NBT_TEXTURE, "press", NBT_ENERGY_ACCEPTED, TD.Energy.KU, NBT_RECIPEMAP, RM.Press, NBT_INV_SIDE_IN, SBIT_L, NBT_INV_SIDE_AUTO_IN, SIDE_LEFT, NBT_INV_SIDE_OUT, SBIT_R, NBT_INV_SIDE_AUTO_OUT, SIDE_RIGHT, NBT_ENERGY_ACCEPTED_SIDES, SBIT_U, NBT_PARALLEL,32, NBT_PARALLEL_DURATION, T), "RS", "PM", "Pw", 'M', OP.casingMachine.dat(aMat), 'P', OP.plateDouble.dat(aMat), 'S', OP.spring.dat(aMat), 'R', OP.stick.dat(aMat));
		
		aClass = MultiTileEntityBasicMachine.class;
		aMat = MT.DATA.Heat_T[1];       aRegistry.add("Smelter ("                       +aMat.getLocal()+")", "Basic Machines"                      , 20241, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   6.0F, NBT_RESISTANCE,   6.0F, NBT_INPUT,   32, NBT_TEXTURE, "smelter", NBT_ENERGY_ACCEPTED, TD.Energy.HU, NBT_RECIPEMAP, RM.Smelter, NBT_CHEAP_OVERCLOCKING, T, NBT_INV_SIDE_IN, SBIT_U, NBT_INV_SIDE_AUTO_IN, SIDE_TOP, NBT_INV_SIDE_OUT, SBIT_L, NBT_INV_SIDE_AUTO_OUT, SIDE_LEFT, NBT_TANK_SIDE_IN, SBIT_U, NBT_TANK_SIDE_AUTO_IN, SIDE_TOP, NBT_TANK_SIDE_OUT, SBIT_R, NBT_TANK_SIDE_AUTO_OUT, SIDE_RIGHT, NBT_ENERGY_ACCEPTED_SIDES, SBIT_D, NBT_PARALLEL, 1000, NBT_PARALLEL_DURATION, T), "wUh", "PMP", "BCB", 'M', OP.casingMachine.dat(aMat), 'U', aRegistry.getItem(1024), 'C', OP.plateDouble.dat(ANY.Cu), 'B', Blocks.brick_block, 'P', OP.pipeMedium.dat(aMat));
		aMat = MT.DATA.Heat_T[2];       aRegistry.add("Smelter ("                       +aMat.getLocal()+")", "Basic Machines"                      , 20242, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT,  128, NBT_TEXTURE, "smelter", NBT_ENERGY_ACCEPTED, TD.Energy.HU, NBT_RECIPEMAP, RM.Smelter, NBT_CHEAP_OVERCLOCKING, T, NBT_INV_SIDE_IN, SBIT_U, NBT_INV_SIDE_AUTO_IN, SIDE_TOP, NBT_INV_SIDE_OUT, SBIT_L, NBT_INV_SIDE_AUTO_OUT, SIDE_LEFT, NBT_TANK_SIDE_IN, SBIT_U, NBT_TANK_SIDE_AUTO_IN, SIDE_TOP, NBT_TANK_SIDE_OUT, SBIT_R, NBT_TANK_SIDE_AUTO_OUT, SIDE_RIGHT, NBT_ENERGY_ACCEPTED_SIDES, SBIT_D, NBT_PARALLEL, 1000, NBT_PARALLEL_DURATION, T), "wUh", "PMP", "BCB", 'M', OP.casingMachine.dat(aMat), 'U', aRegistry.getItem(1019), 'C', OP.plateDouble.dat(ANY.Cu), 'B', Blocks.brick_block, 'P', OP.pipeMedium.dat(aMat));
		aMat = MT.DATA.Heat_T[3];       aRegistry.add("Smelter ("                       +aMat.getLocal()+")", "Basic Machines"                      , 20243, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   9.0F, NBT_RESISTANCE,   9.0F, NBT_INPUT,  512, NBT_TEXTURE, "smelter", NBT_ENERGY_ACCEPTED, TD.Energy.HU, NBT_RECIPEMAP, RM.Smelter, NBT_CHEAP_OVERCLOCKING, T, NBT_INV_SIDE_IN, SBIT_U, NBT_INV_SIDE_AUTO_IN, SIDE_TOP, NBT_INV_SIDE_OUT, SBIT_L, NBT_INV_SIDE_AUTO_OUT, SIDE_LEFT, NBT_TANK_SIDE_IN, SBIT_U, NBT_TANK_SIDE_AUTO_IN, SIDE_TOP, NBT_TANK_SIDE_OUT, SBIT_R, NBT_TANK_SIDE_AUTO_OUT, SIDE_RIGHT, NBT_ENERGY_ACCEPTED_SIDES, SBIT_D, NBT_PARALLEL, 1000, NBT_PARALLEL_DURATION, T), "wUh", "PMP", "BCB", 'M', OP.casingMachine.dat(aMat), 'U', aRegistry.getItem(1019), 'C', OP.plateDouble.dat(ANY.Cu), 'B', Blocks.brick_block, 'P', OP.pipeMedium.dat(aMat));
		aMat = MT.DATA.Heat_T[4];       aRegistry.add("Smelter ("                       +aMat.getLocal()+")", "Basic Machines"                      , 20244, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,  12.5F, NBT_RESISTANCE,  12.5F, NBT_INPUT, 2048, NBT_TEXTURE, "smelter", NBT_ENERGY_ACCEPTED, TD.Energy.HU, NBT_RECIPEMAP, RM.Smelter, NBT_CHEAP_OVERCLOCKING, T, NBT_INV_SIDE_IN, SBIT_U, NBT_INV_SIDE_AUTO_IN, SIDE_TOP, NBT_INV_SIDE_OUT, SBIT_L, NBT_INV_SIDE_AUTO_OUT, SIDE_LEFT, NBT_TANK_SIDE_IN, SBIT_U, NBT_TANK_SIDE_AUTO_IN, SIDE_TOP, NBT_TANK_SIDE_OUT, SBIT_R, NBT_TANK_SIDE_AUTO_OUT, SIDE_RIGHT, NBT_ENERGY_ACCEPTED_SIDES, SBIT_D, NBT_PARALLEL, 1000, NBT_PARALLEL_DURATION, T), "wUh", "PMP", "BCB", 'M', OP.casingMachine.dat(aMat), 'U', aRegistry.getItem(1043), 'C', OP.plateDouble.dat(ANY.Cu), 'B', Blocks.brick_block, 'P', OP.pipeMedium.dat(aMat));
		
		aClass = MultiTileEntityBasicMachine.class;
		aMat = MT.DATA.Heat_T[1];       aRegistry.add("Crystallisation Crucible ("      +aMat.getLocal()+")", "Basic Machines"                      , 20251, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   6.0F, NBT_RESISTANCE,   6.0F, NBT_INPUT,   32, NBT_TEXTURE, "crystallisationcrucible", NBT_ENERGY_ACCEPTED, TD.Energy.HU, NBT_RECIPEMAP, RM.CrystallisationCrucible, NBT_INV_SIDE_IN, SBIT_L|SBIT_B|SBIT_U, NBT_INV_SIDE_AUTO_IN, SIDE_TOP, NBT_INV_SIDE_OUT, SBIT_R, NBT_INV_SIDE_AUTO_OUT, SIDE_RIGHT, NBT_TANK_SIDE_IN, SBIT_L|SBIT_B|SBIT_U, NBT_TANK_SIDE_AUTO_IN, SIDE_LEFT, NBT_ENERGY_ACCEPTED_SIDES, SBIT_D), "wUh", "PMP", "BCB", 'M', OP.casingMachineDouble.dat(aMat), 'U', aRegistry.getItem(1018), 'C', OP.plateDouble.dat(ANY.Cu), 'B', Blocks.brick_block, 'P', OP.pipeMedium.dat(aMat));
		aMat = MT.DATA.Heat_T[2];       aRegistry.add("Crystallisation Crucible ("      +aMat.getLocal()+")", "Basic Machines"                      , 20252, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT,  128, NBT_TEXTURE, "crystallisationcrucible", NBT_ENERGY_ACCEPTED, TD.Energy.HU, NBT_RECIPEMAP, RM.CrystallisationCrucible, NBT_INV_SIDE_IN, SBIT_L|SBIT_B|SBIT_U, NBT_INV_SIDE_AUTO_IN, SIDE_TOP, NBT_INV_SIDE_OUT, SBIT_R, NBT_INV_SIDE_AUTO_OUT, SIDE_RIGHT, NBT_TANK_SIDE_IN, SBIT_L|SBIT_B|SBIT_U, NBT_TANK_SIDE_AUTO_IN, SIDE_LEFT, NBT_ENERGY_ACCEPTED_SIDES, SBIT_D), "wUh", "PMP", "BCB", 'M', OP.casingMachineDouble.dat(aMat), 'U', aRegistry.getItem(1039), 'C', OP.plateDouble.dat(ANY.Cu), 'B', Blocks.brick_block, 'P', OP.pipeMedium.dat(aMat));
		aMat = MT.DATA.Heat_T[3];       aRegistry.add("Crystallisation Crucible ("      +aMat.getLocal()+")", "Basic Machines"                      , 20253, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   9.0F, NBT_RESISTANCE,   9.0F, NBT_INPUT,  512, NBT_TEXTURE, "crystallisationcrucible", NBT_ENERGY_ACCEPTED, TD.Energy.HU, NBT_RECIPEMAP, RM.CrystallisationCrucible, NBT_INV_SIDE_IN, SBIT_L|SBIT_B|SBIT_U, NBT_INV_SIDE_AUTO_IN, SIDE_TOP, NBT_INV_SIDE_OUT, SBIT_R, NBT_INV_SIDE_AUTO_OUT, SIDE_RIGHT, NBT_TANK_SIDE_IN, SBIT_L|SBIT_B|SBIT_U, NBT_TANK_SIDE_AUTO_IN, SIDE_LEFT, NBT_ENERGY_ACCEPTED_SIDES, SBIT_D), "wUh", "PMP", "BCB", 'M', OP.casingMachineDouble.dat(aMat), 'U', aRegistry.getItem(1039), 'C', OP.plateDouble.dat(ANY.Cu), 'B', Blocks.brick_block, 'P', OP.pipeMedium.dat(aMat));
		aMat = MT.DATA.Heat_T[4];       aRegistry.add("Crystallisation Crucible ("      +aMat.getLocal()+")", "Basic Machines"                      , 20254, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,  12.5F, NBT_RESISTANCE,  12.5F, NBT_INPUT, 2048, NBT_TEXTURE, "crystallisationcrucible", NBT_ENERGY_ACCEPTED, TD.Energy.HU, NBT_RECIPEMAP, RM.CrystallisationCrucible, NBT_INV_SIDE_IN, SBIT_L|SBIT_B|SBIT_U, NBT_INV_SIDE_AUTO_IN, SIDE_TOP, NBT_INV_SIDE_OUT, SBIT_R, NBT_INV_SIDE_AUTO_OUT, SIDE_RIGHT, NBT_TANK_SIDE_IN, SBIT_L|SBIT_B|SBIT_U, NBT_TANK_SIDE_AUTO_IN, SIDE_LEFT, NBT_ENERGY_ACCEPTED_SIDES, SBIT_D), "wUh", "PMP", "BCB", 'M', OP.casingMachineDouble.dat(aMat), 'U', aRegistry.getItem(1039), 'C', OP.plateDouble.dat(ANY.Cu), 'B', Blocks.brick_block, 'P', OP.pipeMedium.dat(aMat));
		
		aClass = MultiTileEntityBasicMachineElectric.class;
		aMat = MT.DATA.Electric_T[1];   aRegistry.add("Injector ("                                +VN[1]+")", "Basic Machines"                      , 20261, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT,   32, NBT_TEXTURE, "injector", NBT_ENERGY_ACCEPTED, TD.Energy.EU, NBT_RECIPEMAP, RM.Injector, NBT_INV_SIDE_IN, SBIT_U|SBIT_L, NBT_INV_SIDE_AUTO_IN, SIDE_LEFT, NBT_INV_SIDE_OUT, SBIT_R|SBIT_D, NBT_INV_SIDE_AUTO_OUT, SIDE_RIGHT, NBT_TANK_SIDE_IN, SBIT_U|SBIT_L, NBT_TANK_SIDE_AUTO_IN, SIDE_TOP, NBT_TANK_SIDE_OUT, SBIT_R|SBIT_D, NBT_TANK_SIDE_AUTO_OUT, SIDE_BOTTOM, NBT_ENERGY_ACCEPTED_SIDES, SBIT_B), "XPw", "CMW", 'M', OP.casingMachine.dat(aMat), 'X', IL.PISTONS[1], 'C', OD_CIRCUITS[1], 'W', MT.DATA.CABLES_01[1], 'P', OP.pipeTiny  .dat(MT.StainlessSteel));
		aMat = MT.DATA.Electric_T[2];   aRegistry.add("Injector ("                                +VN[2]+")", "Basic Machines"                      , 20262, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT,  128, NBT_TEXTURE, "injector", NBT_ENERGY_ACCEPTED, TD.Energy.EU, NBT_RECIPEMAP, RM.Injector, NBT_INV_SIDE_IN, SBIT_U|SBIT_L, NBT_INV_SIDE_AUTO_IN, SIDE_LEFT, NBT_INV_SIDE_OUT, SBIT_R|SBIT_D, NBT_INV_SIDE_AUTO_OUT, SIDE_RIGHT, NBT_TANK_SIDE_IN, SBIT_U|SBIT_L, NBT_TANK_SIDE_AUTO_IN, SIDE_TOP, NBT_TANK_SIDE_OUT, SBIT_R|SBIT_D, NBT_TANK_SIDE_AUTO_OUT, SIDE_BOTTOM, NBT_ENERGY_ACCEPTED_SIDES, SBIT_B), "XPw", "CMW", 'M', OP.casingMachine.dat(aMat), 'X', IL.PISTONS[2], 'C', OD_CIRCUITS[2], 'W', MT.DATA.CABLES_01[2], 'P', OP.pipeSmall .dat(MT.StainlessSteel));
		aMat = MT.DATA.Electric_T[3];   aRegistry.add("Injector ("                                +VN[3]+")", "Basic Machines"                      , 20263, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT,  512, NBT_TEXTURE, "injector", NBT_ENERGY_ACCEPTED, TD.Energy.EU, NBT_RECIPEMAP, RM.Injector, NBT_INV_SIDE_IN, SBIT_U|SBIT_L, NBT_INV_SIDE_AUTO_IN, SIDE_LEFT, NBT_INV_SIDE_OUT, SBIT_R|SBIT_D, NBT_INV_SIDE_AUTO_OUT, SIDE_RIGHT, NBT_TANK_SIDE_IN, SBIT_U|SBIT_L, NBT_TANK_SIDE_AUTO_IN, SIDE_TOP, NBT_TANK_SIDE_OUT, SBIT_R|SBIT_D, NBT_TANK_SIDE_AUTO_OUT, SIDE_BOTTOM, NBT_ENERGY_ACCEPTED_SIDES, SBIT_B), "XPw", "CMW", 'M', OP.casingMachine.dat(aMat), 'X', IL.PISTONS[3], 'C', OD_CIRCUITS[3], 'W', MT.DATA.CABLES_01[3], 'P', OP.pipeMedium.dat(MT.StainlessSteel));
		aMat = MT.DATA.Electric_T[4];   aRegistry.add("Injector ("                                +VN[4]+")", "Basic Machines"                      , 20264, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT, 2048, NBT_TEXTURE, "injector", NBT_ENERGY_ACCEPTED, TD.Energy.EU, NBT_RECIPEMAP, RM.Injector, NBT_INV_SIDE_IN, SBIT_U|SBIT_L, NBT_INV_SIDE_AUTO_IN, SIDE_LEFT, NBT_INV_SIDE_OUT, SBIT_R|SBIT_D, NBT_INV_SIDE_AUTO_OUT, SIDE_RIGHT, NBT_TANK_SIDE_IN, SBIT_U|SBIT_L, NBT_TANK_SIDE_AUTO_IN, SIDE_TOP, NBT_TANK_SIDE_OUT, SBIT_R|SBIT_D, NBT_TANK_SIDE_AUTO_OUT, SIDE_BOTTOM, NBT_ENERGY_ACCEPTED_SIDES, SBIT_B), "XPw", "CMW", 'M', OP.casingMachine.dat(aMat), 'X', IL.PISTONS[4], 'C', OD_CIRCUITS[4], 'W', MT.DATA.CABLES_01[4], 'P', OP.pipeLarge .dat(MT.StainlessSteel));
		aMat = MT.DATA.Electric_T[5];   aRegistry.add("Injector ("                                +VN[5]+")", "Basic Machines"                      , 20265, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT, 8192, NBT_TEXTURE, "injector", NBT_ENERGY_ACCEPTED, TD.Energy.EU, NBT_RECIPEMAP, RM.Injector, NBT_INV_SIDE_IN, SBIT_U|SBIT_L, NBT_INV_SIDE_AUTO_IN, SIDE_LEFT, NBT_INV_SIDE_OUT, SBIT_R|SBIT_D, NBT_INV_SIDE_AUTO_OUT, SIDE_RIGHT, NBT_TANK_SIDE_IN, SBIT_U|SBIT_L, NBT_TANK_SIDE_AUTO_IN, SIDE_TOP, NBT_TANK_SIDE_OUT, SBIT_R|SBIT_D, NBT_TANK_SIDE_AUTO_OUT, SIDE_BOTTOM, NBT_ENERGY_ACCEPTED_SIDES, SBIT_B), "XPw", "CMW", 'M', OP.casingMachine.dat(aMat), 'X', IL.PISTONS[5], 'C', OD_CIRCUITS[5], 'W', MT.DATA.CABLES_01[5], 'P', OP.pipeHuge  .dat(MT.StainlessSteel));
		
		aClass = MultiTileEntityBasicMachineElectric.class;
		aMat = MT.DATA.Electric_T[1];   aRegistry.add("Printer ("                                 +VN[1]+")", "Basic Machines"                      , 20271, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT,   32, NBT_TEXTURE, "printer", NBT_ENERGY_ACCEPTED, TD.Energy.EU, NBT_RECIPEMAP, RM.Printer, NBT_INV_SIDE_IN, SBIT_U|SBIT_L, NBT_INV_SIDE_AUTO_IN, SIDE_LEFT, NBT_INV_SIDE_OUT, SBIT_R|SBIT_D, NBT_INV_SIDE_AUTO_OUT, SIDE_RIGHT, NBT_TANK_SIDE_IN, SBIT_U|SBIT_L, NBT_TANK_SIDE_AUTO_IN, SIDE_TOP, NBT_ENERGY_ACCEPTED_SIDES, SBIT_B), "CPC", "wXh", "WMW", 'M', OP.casingMachine.dat(aMat), 'X', IL.CONVEYERS[1], 'C', OD_CIRCUITS[1], 'W', MT.DATA.CABLES_01[1], 'P', OP.pipeTiny.dat(MT.StainlessSteel));
		aMat = MT.DATA.Electric_T[2];   aRegistry.add("Printer ("                                 +VN[2]+")", "Basic Machines"                      , 20272, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT,  128, NBT_TEXTURE, "printer", NBT_ENERGY_ACCEPTED, TD.Energy.EU, NBT_RECIPEMAP, RM.Printer, NBT_INV_SIDE_IN, SBIT_U|SBIT_L, NBT_INV_SIDE_AUTO_IN, SIDE_LEFT, NBT_INV_SIDE_OUT, SBIT_R|SBIT_D, NBT_INV_SIDE_AUTO_OUT, SIDE_RIGHT, NBT_TANK_SIDE_IN, SBIT_U|SBIT_L, NBT_TANK_SIDE_AUTO_IN, SIDE_TOP, NBT_ENERGY_ACCEPTED_SIDES, SBIT_B), "CPC", "wXh", "WMW", 'M', OP.casingMachine.dat(aMat), 'X', IL.CONVEYERS[2], 'C', OD_CIRCUITS[2], 'W', MT.DATA.CABLES_01[2], 'P', OP.pipeTiny.dat(MT.StainlessSteel));
		aMat = MT.DATA.Electric_T[3];   aRegistry.add("Printer ("                                 +VN[3]+")", "Basic Machines"                      , 20273, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT,  512, NBT_TEXTURE, "printer", NBT_ENERGY_ACCEPTED, TD.Energy.EU, NBT_RECIPEMAP, RM.Printer, NBT_INV_SIDE_IN, SBIT_U|SBIT_L, NBT_INV_SIDE_AUTO_IN, SIDE_LEFT, NBT_INV_SIDE_OUT, SBIT_R|SBIT_D, NBT_INV_SIDE_AUTO_OUT, SIDE_RIGHT, NBT_TANK_SIDE_IN, SBIT_U|SBIT_L, NBT_TANK_SIDE_AUTO_IN, SIDE_TOP, NBT_ENERGY_ACCEPTED_SIDES, SBIT_B), "CPC", "wXh", "WMW", 'M', OP.casingMachine.dat(aMat), 'X', IL.CONVEYERS[3], 'C', OD_CIRCUITS[3], 'W', MT.DATA.CABLES_01[3], 'P', OP.pipeTiny.dat(MT.StainlessSteel));
		aMat = MT.DATA.Electric_T[4];   aRegistry.add("Printer ("                                 +VN[4]+")", "Basic Machines"                      , 20274, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT, 2048, NBT_TEXTURE, "printer", NBT_ENERGY_ACCEPTED, TD.Energy.EU, NBT_RECIPEMAP, RM.Printer, NBT_INV_SIDE_IN, SBIT_U|SBIT_L, NBT_INV_SIDE_AUTO_IN, SIDE_LEFT, NBT_INV_SIDE_OUT, SBIT_R|SBIT_D, NBT_INV_SIDE_AUTO_OUT, SIDE_RIGHT, NBT_TANK_SIDE_IN, SBIT_U|SBIT_L, NBT_TANK_SIDE_AUTO_IN, SIDE_TOP, NBT_ENERGY_ACCEPTED_SIDES, SBIT_B), "CPC", "wXh", "WMW", 'M', OP.casingMachine.dat(aMat), 'X', IL.CONVEYERS[4], 'C', OD_CIRCUITS[4], 'W', MT.DATA.CABLES_01[4], 'P', OP.pipeTiny.dat(MT.StainlessSteel));
		aMat = MT.DATA.Electric_T[5];   aRegistry.add("Printer ("                                 +VN[5]+")", "Basic Machines"                      , 20275, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT, 8192, NBT_TEXTURE, "printer", NBT_ENERGY_ACCEPTED, TD.Energy.EU, NBT_RECIPEMAP, RM.Printer, NBT_INV_SIDE_IN, SBIT_U|SBIT_L, NBT_INV_SIDE_AUTO_IN, SIDE_LEFT, NBT_INV_SIDE_OUT, SBIT_R|SBIT_D, NBT_INV_SIDE_AUTO_OUT, SIDE_RIGHT, NBT_TANK_SIDE_IN, SBIT_U|SBIT_L, NBT_TANK_SIDE_AUTO_IN, SIDE_TOP, NBT_ENERGY_ACCEPTED_SIDES, SBIT_B), "CPC", "wXh", "WMW", 'M', OP.casingMachine.dat(aMat), 'X', IL.CONVEYERS[5], 'C', OD_CIRCUITS[5], 'W', MT.DATA.CABLES_01[5], 'P', OP.pipeTiny.dat(MT.StainlessSteel));
		
		aClass = MultiTileEntityBasicMachineElectric.class;
		aMat = MT.DATA.Electric_T[1];   aRegistry.add("Scanner (Visuals, "                        +VN[1]+")", "Basic Machines"                      , 20281, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT,   32, NBT_TEXTURE, "scannervisuals", NBT_ENERGY_ACCEPTED, TD.Energy.EU, NBT_RECIPEMAP, RM.ScannerVisuals, NBT_INV_SIDE_IN, SBIT_U|SBIT_L, NBT_INV_SIDE_AUTO_IN, SIDE_LEFT, NBT_INV_SIDE_OUT, SBIT_R|SBIT_D, NBT_INV_SIDE_AUTO_OUT, SIDE_RIGHT, NBT_ENERGY_ACCEPTED_SIDES, SBIT_B), "CPC", "wXh", "WMW", 'M', OP.casingMachine.dat(aMat), 'X', IL.CONVEYERS[1], 'C', OD_CIRCUITS[1], 'W', MT.DATA.CABLES_01[1], 'P', OP.plate.dat(MT.Lumium));
		aMat = MT.DATA.Electric_T[2];   aRegistry.add("Scanner (Visuals, "                        +VN[2]+")", "Basic Machines"                      , 20282, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT,  128, NBT_TEXTURE, "scannervisuals", NBT_ENERGY_ACCEPTED, TD.Energy.EU, NBT_RECIPEMAP, RM.ScannerVisuals, NBT_INV_SIDE_IN, SBIT_U|SBIT_L, NBT_INV_SIDE_AUTO_IN, SIDE_LEFT, NBT_INV_SIDE_OUT, SBIT_R|SBIT_D, NBT_INV_SIDE_AUTO_OUT, SIDE_RIGHT, NBT_ENERGY_ACCEPTED_SIDES, SBIT_B), "CPC", "wXh", "WMW", 'M', OP.casingMachine.dat(aMat), 'X', IL.CONVEYERS[2], 'C', OD_CIRCUITS[2], 'W', MT.DATA.CABLES_01[2], 'P', OP.plate.dat(MT.Lumium));
		aMat = MT.DATA.Electric_T[3];   aRegistry.add("Scanner (Visuals, "                        +VN[3]+")", "Basic Machines"                      , 20283, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT,  512, NBT_TEXTURE, "scannervisuals", NBT_ENERGY_ACCEPTED, TD.Energy.EU, NBT_RECIPEMAP, RM.ScannerVisuals, NBT_INV_SIDE_IN, SBIT_U|SBIT_L, NBT_INV_SIDE_AUTO_IN, SIDE_LEFT, NBT_INV_SIDE_OUT, SBIT_R|SBIT_D, NBT_INV_SIDE_AUTO_OUT, SIDE_RIGHT, NBT_ENERGY_ACCEPTED_SIDES, SBIT_B), "CPC", "wXh", "WMW", 'M', OP.casingMachine.dat(aMat), 'X', IL.CONVEYERS[3], 'C', OD_CIRCUITS[3], 'W', MT.DATA.CABLES_01[3], 'P', OP.plate.dat(MT.Lumium));
		aMat = MT.DATA.Electric_T[4];   aRegistry.add("Scanner (Visuals, "                        +VN[4]+")", "Basic Machines"                      , 20284, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT, 2048, NBT_TEXTURE, "scannervisuals", NBT_ENERGY_ACCEPTED, TD.Energy.EU, NBT_RECIPEMAP, RM.ScannerVisuals, NBT_INV_SIDE_IN, SBIT_U|SBIT_L, NBT_INV_SIDE_AUTO_IN, SIDE_LEFT, NBT_INV_SIDE_OUT, SBIT_R|SBIT_D, NBT_INV_SIDE_AUTO_OUT, SIDE_RIGHT, NBT_ENERGY_ACCEPTED_SIDES, SBIT_B), "CPC", "wXh", "WMW", 'M', OP.casingMachine.dat(aMat), 'X', IL.CONVEYERS[4], 'C', OD_CIRCUITS[4], 'W', MT.DATA.CABLES_01[4], 'P', OP.plate.dat(MT.Lumium));
		aMat = MT.DATA.Electric_T[5];   aRegistry.add("Scanner (Visuals, "                        +VN[5]+")", "Basic Machines"                      , 20285, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT, 8192, NBT_TEXTURE, "scannervisuals", NBT_ENERGY_ACCEPTED, TD.Energy.EU, NBT_RECIPEMAP, RM.ScannerVisuals, NBT_INV_SIDE_IN, SBIT_U|SBIT_L, NBT_INV_SIDE_AUTO_IN, SIDE_LEFT, NBT_INV_SIDE_OUT, SBIT_R|SBIT_D, NBT_INV_SIDE_AUTO_OUT, SIDE_RIGHT, NBT_ENERGY_ACCEPTED_SIDES, SBIT_B), "CPC", "wXh", "WMW", 'M', OP.casingMachine.dat(aMat), 'X', IL.CONVEYERS[5], 'C', OD_CIRCUITS[5], 'W', MT.DATA.CABLES_01[5], 'P', OP.plate.dat(MT.Lumium));
		
		aClass = MultiTileEntityBasicMachine.class;
		aMat = MT.DATA.Kinetic_T[1];    aRegistry.add("Sluice ("                        +aMat.getLocal()+")", "Basic Machines"                      , 20291, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   7.0F, NBT_RESISTANCE,   7.0F, NBT_INPUT,   32, NBT_TEXTURE, "sluice", NBT_ENERGY_ACCEPTED, TD.Energy.RU, NBT_RECIPEMAP, RM.Sluice, NBT_INV_SIDE_IN, SBIT_L|SBIT_U, NBT_INV_SIDE_AUTO_IN, SIDE_LEFT, NBT_INV_SIDE_OUT, SBIT_R|SBIT_D, NBT_INV_SIDE_AUTO_OUT, SIDE_RIGHT, NBT_TANK_SIDE_IN, SBIT_L|SBIT_U, NBT_TANK_SIDE_AUTO_IN, SIDE_TOP, NBT_TANK_SIDE_OUT, SBIT_R|SBIT_D, NBT_TANK_SIDE_AUTO_OUT, SIDE_BOTTOM, NBT_ENERGY_ACCEPTED_SIDES, SBIT_B), "PPP", "RGR", "GMG", 'M', OP.casingMachineDouble.dat(aMat), 'R', OP.rotor.dat(aMat), 'G', OP.gearGt.dat(aMat), 'P', OP.plateDouble.dat(aMat));
		aMat = MT.DATA.Kinetic_T[2];    aRegistry.add("Sluice ("                        +aMat.getLocal()+")", "Basic Machines"                      , 20292, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   6.0F, NBT_RESISTANCE,   6.0F, NBT_INPUT,  128, NBT_TEXTURE, "sluice", NBT_ENERGY_ACCEPTED, TD.Energy.RU, NBT_RECIPEMAP, RM.Sluice, NBT_INV_SIDE_IN, SBIT_L|SBIT_U, NBT_INV_SIDE_AUTO_IN, SIDE_LEFT, NBT_INV_SIDE_OUT, SBIT_R|SBIT_D, NBT_INV_SIDE_AUTO_OUT, SIDE_RIGHT, NBT_TANK_SIDE_IN, SBIT_L|SBIT_U, NBT_TANK_SIDE_AUTO_IN, SIDE_TOP, NBT_TANK_SIDE_OUT, SBIT_R|SBIT_D, NBT_TANK_SIDE_AUTO_OUT, SIDE_BOTTOM, NBT_ENERGY_ACCEPTED_SIDES, SBIT_B), "PPP", "RGR", "GMG", 'M', OP.casingMachineDouble.dat(aMat), 'R', OP.rotor.dat(aMat), 'G', OP.gearGt.dat(aMat), 'P', OP.plateDouble.dat(aMat));
		aMat = MT.DATA.Kinetic_T[3];    aRegistry.add("Sluice ("                        +aMat.getLocal()+")", "Basic Machines"                      , 20293, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   9.0F, NBT_RESISTANCE,   9.0F, NBT_INPUT,  512, NBT_TEXTURE, "sluice", NBT_ENERGY_ACCEPTED, TD.Energy.RU, NBT_RECIPEMAP, RM.Sluice, NBT_INV_SIDE_IN, SBIT_L|SBIT_U, NBT_INV_SIDE_AUTO_IN, SIDE_LEFT, NBT_INV_SIDE_OUT, SBIT_R|SBIT_D, NBT_INV_SIDE_AUTO_OUT, SIDE_RIGHT, NBT_TANK_SIDE_IN, SBIT_L|SBIT_U, NBT_TANK_SIDE_AUTO_IN, SIDE_TOP, NBT_TANK_SIDE_OUT, SBIT_R|SBIT_D, NBT_TANK_SIDE_AUTO_OUT, SIDE_BOTTOM, NBT_ENERGY_ACCEPTED_SIDES, SBIT_B), "PPP", "RGR", "GMG", 'M', OP.casingMachineDouble.dat(aMat), 'R', OP.rotor.dat(aMat), 'G', OP.gearGt.dat(aMat), 'P', OP.plateDouble.dat(aMat));
		aMat = MT.DATA.Kinetic_T[4];    aRegistry.add("Sluice ("                        +aMat.getLocal()+")", "Basic Machines"                      , 20294, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,  12.5F, NBT_RESISTANCE,  12.5F, NBT_INPUT, 2048, NBT_TEXTURE, "sluice", NBT_ENERGY_ACCEPTED, TD.Energy.RU, NBT_RECIPEMAP, RM.Sluice, NBT_INV_SIDE_IN, SBIT_L|SBIT_U, NBT_INV_SIDE_AUTO_IN, SIDE_LEFT, NBT_INV_SIDE_OUT, SBIT_R|SBIT_D, NBT_INV_SIDE_AUTO_OUT, SIDE_RIGHT, NBT_TANK_SIDE_IN, SBIT_L|SBIT_U, NBT_TANK_SIDE_AUTO_IN, SIDE_TOP, NBT_TANK_SIDE_OUT, SBIT_R|SBIT_D, NBT_TANK_SIDE_AUTO_OUT, SIDE_BOTTOM, NBT_ENERGY_ACCEPTED_SIDES, SBIT_B), "PPP", "RGR", "GMG", 'M', OP.casingMachineDouble.dat(aMat), 'R', OP.rotor.dat(aMat), 'G', OP.gearGt.dat(aMat), 'P', OP.plateDouble.dat(aMat));
		
		aClass = MultiTileEntityBasicMachine.class;
		aMat = MT.DATA.Electric_T[1];   aRegistry.add("Magnetic Separator ("            +aMat.getLocal()+")", "Basic Machines"                      , 20301, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT,   32, NBT_TEXTURE, "magneticseparator", NBT_ENERGY_ACCEPTED, TD.Energy.MU, NBT_RECIPEMAP, RM.MagneticSeparator, NBT_INV_SIDE_IN, SBIT_L, NBT_INV_SIDE_AUTO_IN, SIDE_LEFT, NBT_INV_SIDE_OUT, SBIT_R|SBIT_D, NBT_INV_SIDE_AUTO_OUT, SIDE_RIGHT, NBT_TANK_SIDE_IN, SBIT_L, NBT_TANK_SIDE_AUTO_IN, SIDE_LEFT, NBT_TANK_SIDE_OUT, SBIT_R|SBIT_D, NBT_TANK_SIDE_AUTO_OUT, SIDE_BOTTOM, NBT_ENERGY_ACCEPTED_SIDES, SBIT_U), "TwT", "TdT", "PMP", 'M', OP.casingMachine.dat(aMat), 'P', OP.plate.dat(aMat), 'T', OP.screw.dat(aMat));
		aMat = MT.DATA.Electric_T[2];   aRegistry.add("Magnetic Separator ("            +aMat.getLocal()+")", "Basic Machines"                      , 20302, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT,  128, NBT_TEXTURE, "magneticseparator", NBT_ENERGY_ACCEPTED, TD.Energy.MU, NBT_RECIPEMAP, RM.MagneticSeparator, NBT_INV_SIDE_IN, SBIT_L, NBT_INV_SIDE_AUTO_IN, SIDE_LEFT, NBT_INV_SIDE_OUT, SBIT_R|SBIT_D, NBT_INV_SIDE_AUTO_OUT, SIDE_RIGHT, NBT_TANK_SIDE_IN, SBIT_L, NBT_TANK_SIDE_AUTO_IN, SIDE_LEFT, NBT_TANK_SIDE_OUT, SBIT_R|SBIT_D, NBT_TANK_SIDE_AUTO_OUT, SIDE_BOTTOM, NBT_ENERGY_ACCEPTED_SIDES, SBIT_U), "TwT", "TdT", "PMP", 'M', OP.casingMachine.dat(aMat), 'P', OP.plate.dat(aMat), 'T', OP.screw.dat(aMat));
		aMat = MT.DATA.Electric_T[3];   aRegistry.add("Magnetic Separator ("            +aMat.getLocal()+")", "Basic Machines"                      , 20303, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT,  512, NBT_TEXTURE, "magneticseparator", NBT_ENERGY_ACCEPTED, TD.Energy.MU, NBT_RECIPEMAP, RM.MagneticSeparator, NBT_INV_SIDE_IN, SBIT_L, NBT_INV_SIDE_AUTO_IN, SIDE_LEFT, NBT_INV_SIDE_OUT, SBIT_R|SBIT_D, NBT_INV_SIDE_AUTO_OUT, SIDE_RIGHT, NBT_TANK_SIDE_IN, SBIT_L, NBT_TANK_SIDE_AUTO_IN, SIDE_LEFT, NBT_TANK_SIDE_OUT, SBIT_R|SBIT_D, NBT_TANK_SIDE_AUTO_OUT, SIDE_BOTTOM, NBT_ENERGY_ACCEPTED_SIDES, SBIT_U), "TwT", "TdT", "PMP", 'M', OP.casingMachine.dat(aMat), 'P', OP.plate.dat(aMat), 'T', OP.screw.dat(aMat));
		aMat = MT.DATA.Electric_T[4];   aRegistry.add("Magnetic Separator ("            +aMat.getLocal()+")", "Basic Machines"                      , 20304, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT, 2048, NBT_TEXTURE, "magneticseparator", NBT_ENERGY_ACCEPTED, TD.Energy.MU, NBT_RECIPEMAP, RM.MagneticSeparator, NBT_INV_SIDE_IN, SBIT_L, NBT_INV_SIDE_AUTO_IN, SIDE_LEFT, NBT_INV_SIDE_OUT, SBIT_R|SBIT_D, NBT_INV_SIDE_AUTO_OUT, SIDE_RIGHT, NBT_TANK_SIDE_IN, SBIT_L, NBT_TANK_SIDE_AUTO_IN, SIDE_LEFT, NBT_TANK_SIDE_OUT, SBIT_R|SBIT_D, NBT_TANK_SIDE_AUTO_OUT, SIDE_BOTTOM, NBT_ENERGY_ACCEPTED_SIDES, SBIT_U), "TwT", "TdT", "PMP", 'M', OP.casingMachine.dat(aMat), 'P', OP.plate.dat(aMat), 'T', OP.screw.dat(aMat));
		aMat = MT.DATA.Electric_T[5];   aRegistry.add("Magnetic Separator ("            +aMat.getLocal()+")", "Basic Machines"                      , 20305, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT, 8192, NBT_TEXTURE, "magneticseparator", NBT_ENERGY_ACCEPTED, TD.Energy.MU, NBT_RECIPEMAP, RM.MagneticSeparator, NBT_INV_SIDE_IN, SBIT_L, NBT_INV_SIDE_AUTO_IN, SIDE_LEFT, NBT_INV_SIDE_OUT, SBIT_R|SBIT_D, NBT_INV_SIDE_AUTO_OUT, SIDE_RIGHT, NBT_TANK_SIDE_IN, SBIT_L, NBT_TANK_SIDE_AUTO_IN, SIDE_LEFT, NBT_TANK_SIDE_OUT, SBIT_R|SBIT_D, NBT_TANK_SIDE_AUTO_OUT, SIDE_BOTTOM, NBT_ENERGY_ACCEPTED_SIDES, SBIT_U), "TwT", "TdT", "PMP", 'M', OP.casingMachine.dat(aMat), 'P', OP.plate.dat(aMat), 'T', OP.screw.dat(aMat));
		
		aClass = MultiTileEntityBasicMachine.class;
		aMat = MT.DATA.Heat_T[1];       aRegistry.add("Dryer ("                         +aMat.getLocal()+")", "Basic Machines"                      , 20311, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   6.0F, NBT_RESISTANCE,   6.0F, NBT_INPUT,   32, NBT_TEXTURE, "dryer", NBT_ENERGY_ACCEPTED, TD.Energy.HU, NBT_RECIPEMAP, RM.Drying, NBT_INV_SIDE_IN, SBIT_B|SBIT_L, NBT_INV_SIDE_AUTO_IN, SIDE_LEFT, NBT_INV_SIDE_OUT, SBIT_R, NBT_INV_SIDE_AUTO_OUT, SIDE_RIGHT, NBT_TANK_SIDE_IN, SBIT_B|SBIT_L, NBT_TANK_SIDE_AUTO_IN, SIDE_BACK, NBT_TANK_SIDE_OUT, SBIT_U, NBT_TANK_SIDE_AUTO_OUT, SIDE_TOP, NBT_ENERGY_ACCEPTED_SIDES, SBIT_D, NBT_CHEAP_OVERCLOCKING, T, NBT_PARALLEL,  8, NBT_PARALLEL_DURATION, T), "wPh", "BMB", "BCB", 'M', OP.casingMachine.dat(aMat), 'C', OP.plateDouble.dat(ANY.Cu), 'B', Blocks.brick_block, 'P', OP.pipeMedium.dat(aMat));
		aMat = MT.DATA.Heat_T[2];       aRegistry.add("Dryer ("                         +aMat.getLocal()+")", "Basic Machines"                      , 20312, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT,  128, NBT_TEXTURE, "dryer", NBT_ENERGY_ACCEPTED, TD.Energy.HU, NBT_RECIPEMAP, RM.Drying, NBT_INV_SIDE_IN, SBIT_B|SBIT_L, NBT_INV_SIDE_AUTO_IN, SIDE_LEFT, NBT_INV_SIDE_OUT, SBIT_R, NBT_INV_SIDE_AUTO_OUT, SIDE_RIGHT, NBT_TANK_SIDE_IN, SBIT_B|SBIT_L, NBT_TANK_SIDE_AUTO_IN, SIDE_BACK, NBT_TANK_SIDE_OUT, SBIT_U, NBT_TANK_SIDE_AUTO_OUT, SIDE_TOP, NBT_ENERGY_ACCEPTED_SIDES, SBIT_D, NBT_CHEAP_OVERCLOCKING, T, NBT_PARALLEL, 16, NBT_PARALLEL_DURATION, T), "wPh", "BMB", "BCB", 'M', OP.casingMachine.dat(aMat), 'C', OP.plateDouble.dat(ANY.Cu), 'B', Blocks.brick_block, 'P', OP.pipeMedium.dat(aMat));
		aMat = MT.DATA.Heat_T[3];       aRegistry.add("Dryer ("                         +aMat.getLocal()+")", "Basic Machines"                      , 20313, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   9.0F, NBT_RESISTANCE,   9.0F, NBT_INPUT,  512, NBT_TEXTURE, "dryer", NBT_ENERGY_ACCEPTED, TD.Energy.HU, NBT_RECIPEMAP, RM.Drying, NBT_INV_SIDE_IN, SBIT_B|SBIT_L, NBT_INV_SIDE_AUTO_IN, SIDE_LEFT, NBT_INV_SIDE_OUT, SBIT_R, NBT_INV_SIDE_AUTO_OUT, SIDE_RIGHT, NBT_TANK_SIDE_IN, SBIT_B|SBIT_L, NBT_TANK_SIDE_AUTO_IN, SIDE_BACK, NBT_TANK_SIDE_OUT, SBIT_U, NBT_TANK_SIDE_AUTO_OUT, SIDE_TOP, NBT_ENERGY_ACCEPTED_SIDES, SBIT_D, NBT_CHEAP_OVERCLOCKING, T, NBT_PARALLEL, 32, NBT_PARALLEL_DURATION, T), "wPh", "BMB", "BCB", 'M', OP.casingMachine.dat(aMat), 'C', OP.plateDouble.dat(ANY.Cu), 'B', Blocks.brick_block, 'P', OP.pipeMedium.dat(aMat));
		aMat = MT.DATA.Heat_T[4];       aRegistry.add("Dryer ("                         +aMat.getLocal()+")", "Basic Machines"                      , 20314, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,  12.5F, NBT_RESISTANCE,  12.5F, NBT_INPUT, 2048, NBT_TEXTURE, "dryer", NBT_ENERGY_ACCEPTED, TD.Energy.HU, NBT_RECIPEMAP, RM.Drying, NBT_INV_SIDE_IN, SBIT_B|SBIT_L, NBT_INV_SIDE_AUTO_IN, SIDE_LEFT, NBT_INV_SIDE_OUT, SBIT_R, NBT_INV_SIDE_AUTO_OUT, SIDE_RIGHT, NBT_TANK_SIDE_IN, SBIT_B|SBIT_L, NBT_TANK_SIDE_AUTO_IN, SIDE_BACK, NBT_TANK_SIDE_OUT, SBIT_U, NBT_TANK_SIDE_AUTO_OUT, SIDE_TOP, NBT_ENERGY_ACCEPTED_SIDES, SBIT_D, NBT_CHEAP_OVERCLOCKING, T, NBT_PARALLEL, 64, NBT_PARALLEL_DURATION, T), "wPh", "BMB", "BCB", 'M', OP.casingMachine.dat(aMat), 'C', OP.plateDouble.dat(ANY.Cu), 'B', Blocks.brick_block, 'P', OP.pipeMedium.dat(aMat));
		
		aClass = MultiTileEntityBasicMachine.class;
		aMat = MT.DATA.Electric_T[1];   aRegistry.add("Laser Engraver (T1)"                                 , "Basic Machines"                      , 20321, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT,   32, NBT_TEXTURE, "laserengraver", NBT_ENERGY_ACCEPTED, TD.Energy.LU, NBT_RECIPEMAP, RM.LaserEngraver, NBT_INV_SIDE_IN, SBIT_L, NBT_INV_SIDE_AUTO_IN, SIDE_LEFT, NBT_INV_SIDE_OUT, SBIT_R, NBT_INV_SIDE_AUTO_OUT, SIDE_RIGHT, NBT_ENERGY_ACCEPTED_SIDES, SBIT_U), "TdT", "GPG", "CMC", 'M', OP.casingMachine.dat(aMat), 'P', OD.craftingHardenedClay, 'C', OD_CIRCUITS[1], 'T', OP.screw.dat(aMat), 'G', OP.gearGtSmall.dat(aMat));
		aMat = MT.DATA.Electric_T[2];   aRegistry.add("Laser Engraver (T2)"                                 , "Basic Machines"                      , 20322, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT,  128, NBT_TEXTURE, "laserengraver", NBT_ENERGY_ACCEPTED, TD.Energy.LU, NBT_RECIPEMAP, RM.LaserEngraver, NBT_INV_SIDE_IN, SBIT_L, NBT_INV_SIDE_AUTO_IN, SIDE_LEFT, NBT_INV_SIDE_OUT, SBIT_R, NBT_INV_SIDE_AUTO_OUT, SIDE_RIGHT, NBT_ENERGY_ACCEPTED_SIDES, SBIT_U), "TdT", "GPG", "CMC", 'M', OP.casingMachine.dat(aMat), 'P', OD.craftingHardenedClay, 'C', OD_CIRCUITS[2], 'T', OP.screw.dat(aMat), 'G', OP.gearGtSmall.dat(aMat));
		aMat = MT.DATA.Electric_T[3];   aRegistry.add("Laser Engraver (T3)"                                 , "Basic Machines"                      , 20323, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT,  512, NBT_TEXTURE, "laserengraver", NBT_ENERGY_ACCEPTED, TD.Energy.LU, NBT_RECIPEMAP, RM.LaserEngraver, NBT_INV_SIDE_IN, SBIT_L, NBT_INV_SIDE_AUTO_IN, SIDE_LEFT, NBT_INV_SIDE_OUT, SBIT_R, NBT_INV_SIDE_AUTO_OUT, SIDE_RIGHT, NBT_ENERGY_ACCEPTED_SIDES, SBIT_U), "TdT", "GPG", "CMC", 'M', OP.casingMachine.dat(aMat), 'P', OD.craftingHardenedClay, 'C', OD_CIRCUITS[3], 'T', OP.screw.dat(aMat), 'G', OP.gearGtSmall.dat(aMat));
		aMat = MT.DATA.Electric_T[4];   aRegistry.add("Laser Engraver (T4)"                                 , "Basic Machines"                      , 20324, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT, 2048, NBT_TEXTURE, "laserengraver", NBT_ENERGY_ACCEPTED, TD.Energy.LU, NBT_RECIPEMAP, RM.LaserEngraver, NBT_INV_SIDE_IN, SBIT_L, NBT_INV_SIDE_AUTO_IN, SIDE_LEFT, NBT_INV_SIDE_OUT, SBIT_R, NBT_INV_SIDE_AUTO_OUT, SIDE_RIGHT, NBT_ENERGY_ACCEPTED_SIDES, SBIT_U), "TdT", "GPG", "CMC", 'M', OP.casingMachine.dat(aMat), 'P', OD.craftingHardenedClay, 'C', OD_CIRCUITS[4], 'T', OP.screw.dat(aMat), 'G', OP.gearGtSmall.dat(aMat));
		aMat = MT.DATA.Electric_T[5];   aRegistry.add("Laser Engraver (T5)"                                 , "Basic Machines"                      , 20325, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT, 8192, NBT_TEXTURE, "laserengraver", NBT_ENERGY_ACCEPTED, TD.Energy.LU, NBT_RECIPEMAP, RM.LaserEngraver, NBT_INV_SIDE_IN, SBIT_L, NBT_INV_SIDE_AUTO_IN, SIDE_LEFT, NBT_INV_SIDE_OUT, SBIT_R, NBT_INV_SIDE_AUTO_OUT, SIDE_RIGHT, NBT_ENERGY_ACCEPTED_SIDES, SBIT_U), "TdT", "GPG", "CMC", 'M', OP.casingMachine.dat(aMat), 'P', OD.craftingHardenedClay, 'C', OD_CIRCUITS[5], 'T', OP.screw.dat(aMat), 'G', OP.gearGtSmall.dat(aMat));
		
		aClass = MultiTileEntityBasicMachine.class;
		aMat = MT.DATA.Electric_T[1];   aRegistry.add("Laser Welder (T1)"                                   , "Basic Machines"                      , 20331, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT,   32, NBT_TEXTURE, "laserwelder", NBT_ENERGY_ACCEPTED, TD.Energy.LU, NBT_RECIPEMAP, RM.Welder, NBT_INV_SIDE_IN, SBIT_L, NBT_INV_SIDE_AUTO_IN, SIDE_LEFT, NBT_INV_SIDE_OUT, SBIT_R, NBT_INV_SIDE_AUTO_OUT, SIDE_RIGHT, NBT_TANK_SIDE_IN, SBIT_D|SBIT_L, NBT_TANK_SIDE_AUTO_IN, SIDE_BOTTOM, NBT_ENERGY_ACCEPTED_SIDES, SBIT_U), "TLT", "GPG", "CMC", 'M', OP.casingMachine.dat(aMat), 'P', OD.craftingHardenedClay, 'C', OD_CIRCUITS[1], 'L', DYE_OREDICTS_LENS[DYE_INDEX_Yellow], 'T', OP.screw.dat(aMat), 'G', OP.gearGtSmall.dat(aMat));
		aMat = MT.DATA.Electric_T[2];   aRegistry.add("Laser Welder (T2)"                                   , "Basic Machines"                      , 20332, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT,  128, NBT_TEXTURE, "laserwelder", NBT_ENERGY_ACCEPTED, TD.Energy.LU, NBT_RECIPEMAP, RM.Welder, NBT_INV_SIDE_IN, SBIT_L, NBT_INV_SIDE_AUTO_IN, SIDE_LEFT, NBT_INV_SIDE_OUT, SBIT_R, NBT_INV_SIDE_AUTO_OUT, SIDE_RIGHT, NBT_TANK_SIDE_IN, SBIT_D|SBIT_L, NBT_TANK_SIDE_AUTO_IN, SIDE_BOTTOM, NBT_ENERGY_ACCEPTED_SIDES, SBIT_U), "TLT", "GPG", "CMC", 'M', OP.casingMachine.dat(aMat), 'P', OD.craftingHardenedClay, 'C', OD_CIRCUITS[2], 'L', DYE_OREDICTS_LENS[DYE_INDEX_Yellow], 'T', OP.screw.dat(aMat), 'G', OP.gearGtSmall.dat(aMat));
		aMat = MT.DATA.Electric_T[3];   aRegistry.add("Laser Welder (T3)"                                   , "Basic Machines"                      , 20333, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT,  512, NBT_TEXTURE, "laserwelder", NBT_ENERGY_ACCEPTED, TD.Energy.LU, NBT_RECIPEMAP, RM.Welder, NBT_INV_SIDE_IN, SBIT_L, NBT_INV_SIDE_AUTO_IN, SIDE_LEFT, NBT_INV_SIDE_OUT, SBIT_R, NBT_INV_SIDE_AUTO_OUT, SIDE_RIGHT, NBT_TANK_SIDE_IN, SBIT_D|SBIT_L, NBT_TANK_SIDE_AUTO_IN, SIDE_BOTTOM, NBT_ENERGY_ACCEPTED_SIDES, SBIT_U), "TLT", "GPG", "CMC", 'M', OP.casingMachine.dat(aMat), 'P', OD.craftingHardenedClay, 'C', OD_CIRCUITS[3], 'L', DYE_OREDICTS_LENS[DYE_INDEX_Yellow], 'T', OP.screw.dat(aMat), 'G', OP.gearGtSmall.dat(aMat));
		aMat = MT.DATA.Electric_T[4];   aRegistry.add("Laser Welder (T4)"                                   , "Basic Machines"                      , 20334, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT, 2048, NBT_TEXTURE, "laserwelder", NBT_ENERGY_ACCEPTED, TD.Energy.LU, NBT_RECIPEMAP, RM.Welder, NBT_INV_SIDE_IN, SBIT_L, NBT_INV_SIDE_AUTO_IN, SIDE_LEFT, NBT_INV_SIDE_OUT, SBIT_R, NBT_INV_SIDE_AUTO_OUT, SIDE_RIGHT, NBT_TANK_SIDE_IN, SBIT_D|SBIT_L, NBT_TANK_SIDE_AUTO_IN, SIDE_BOTTOM, NBT_ENERGY_ACCEPTED_SIDES, SBIT_U), "TLT", "GPG", "CMC", 'M', OP.casingMachine.dat(aMat), 'P', OD.craftingHardenedClay, 'C', OD_CIRCUITS[4], 'L', DYE_OREDICTS_LENS[DYE_INDEX_Yellow], 'T', OP.screw.dat(aMat), 'G', OP.gearGtSmall.dat(aMat));
		aMat = MT.DATA.Electric_T[5];   aRegistry.add("Laser Welder (T5)"                                   , "Basic Machines"                      , 20335, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT, 8192, NBT_TEXTURE, "laserwelder", NBT_ENERGY_ACCEPTED, TD.Energy.LU, NBT_RECIPEMAP, RM.Welder, NBT_INV_SIDE_IN, SBIT_L, NBT_INV_SIDE_AUTO_IN, SIDE_LEFT, NBT_INV_SIDE_OUT, SBIT_R, NBT_INV_SIDE_AUTO_OUT, SIDE_RIGHT, NBT_TANK_SIDE_IN, SBIT_D|SBIT_L, NBT_TANK_SIDE_AUTO_IN, SIDE_BOTTOM, NBT_ENERGY_ACCEPTED_SIDES, SBIT_U), "TLT", "GPG", "CMC", 'M', OP.casingMachine.dat(aMat), 'P', OD.craftingHardenedClay, 'C', OD_CIRCUITS[5], 'L', DYE_OREDICTS_LENS[DYE_INDEX_Yellow], 'T', OP.screw.dat(aMat), 'G', OP.gearGtSmall.dat(aMat));
		
		aClass = MultiTileEntityBasicMachineElectric.class;
		aMat = MT.DATA.Electric_T[1];   aRegistry.add("Autocrafter ("                             +VN[1]+")", "Basic Machines"                      , 20341, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT,   32, NBT_TEXTURE, "autocrafter", NBT_ENERGY_ACCEPTED, TD.Energy.EU, NBT_RECIPEMAP, RM.Autocrafter, NBT_INV_SIDE_IN, SBIT_U|SBIT_L, NBT_INV_SIDE_AUTO_IN, SIDE_LEFT, NBT_INV_SIDE_OUT, SBIT_R|SBIT_D, NBT_INV_SIDE_AUTO_OUT, SIDE_RIGHT, NBT_ENERGY_ACCEPTED_SIDES, SBIT_U|SBIT_D), "WRW", "RwR", "CMC", 'M', OP.casingMachineDouble.dat(aMat), 'C', OD_CIRCUITS[1], 'W', MT.DATA.CABLES_01[1], 'R', IL.ROBOT_ARMS[1]);
		aMat = MT.DATA.Electric_T[2];   aRegistry.add("Autocrafter ("                             +VN[2]+")", "Basic Machines"                      , 20342, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT,  128, NBT_TEXTURE, "autocrafter", NBT_ENERGY_ACCEPTED, TD.Energy.EU, NBT_RECIPEMAP, RM.Autocrafter, NBT_INV_SIDE_IN, SBIT_U|SBIT_L, NBT_INV_SIDE_AUTO_IN, SIDE_LEFT, NBT_INV_SIDE_OUT, SBIT_R|SBIT_D, NBT_INV_SIDE_AUTO_OUT, SIDE_RIGHT, NBT_ENERGY_ACCEPTED_SIDES, SBIT_U|SBIT_D), "WRW", "RwR", "CMC", 'M', OP.casingMachineDouble.dat(aMat), 'C', OD_CIRCUITS[2], 'W', MT.DATA.CABLES_01[2], 'R', IL.ROBOT_ARMS[2]);
		aMat = MT.DATA.Electric_T[3];   aRegistry.add("Autocrafter ("                             +VN[3]+")", "Basic Machines"                      , 20343, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT,  512, NBT_TEXTURE, "autocrafter", NBT_ENERGY_ACCEPTED, TD.Energy.EU, NBT_RECIPEMAP, RM.Autocrafter, NBT_INV_SIDE_IN, SBIT_U|SBIT_L, NBT_INV_SIDE_AUTO_IN, SIDE_LEFT, NBT_INV_SIDE_OUT, SBIT_R|SBIT_D, NBT_INV_SIDE_AUTO_OUT, SIDE_RIGHT, NBT_ENERGY_ACCEPTED_SIDES, SBIT_U|SBIT_D), "WRW", "RwR", "CMC", 'M', OP.casingMachineDouble.dat(aMat), 'C', OD_CIRCUITS[3], 'W', MT.DATA.CABLES_01[3], 'R', IL.ROBOT_ARMS[3]);
		aMat = MT.DATA.Electric_T[4];   aRegistry.add("Autocrafter ("                             +VN[4]+")", "Basic Machines"                      , 20344, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT, 2048, NBT_TEXTURE, "autocrafter", NBT_ENERGY_ACCEPTED, TD.Energy.EU, NBT_RECIPEMAP, RM.Autocrafter, NBT_INV_SIDE_IN, SBIT_U|SBIT_L, NBT_INV_SIDE_AUTO_IN, SIDE_LEFT, NBT_INV_SIDE_OUT, SBIT_R|SBIT_D, NBT_INV_SIDE_AUTO_OUT, SIDE_RIGHT, NBT_ENERGY_ACCEPTED_SIDES, SBIT_U|SBIT_D), "WRW", "RwR", "CMC", 'M', OP.casingMachineDouble.dat(aMat), 'C', OD_CIRCUITS[4], 'W', MT.DATA.CABLES_01[4], 'R', IL.ROBOT_ARMS[4]);
		aMat = MT.DATA.Electric_T[5];   aRegistry.add("Autocrafter ("                             +VN[5]+")", "Basic Machines"                      , 20345, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT, 8192, NBT_TEXTURE, "autocrafter", NBT_ENERGY_ACCEPTED, TD.Energy.EU, NBT_RECIPEMAP, RM.Autocrafter, NBT_INV_SIDE_IN, SBIT_U|SBIT_L, NBT_INV_SIDE_AUTO_IN, SIDE_LEFT, NBT_INV_SIDE_OUT, SBIT_R|SBIT_D, NBT_INV_SIDE_AUTO_OUT, SIDE_RIGHT, NBT_ENERGY_ACCEPTED_SIDES, SBIT_U|SBIT_D), "WRW", "RwR", "CMC", 'M', OP.casingMachineDouble.dat(aMat), 'C', OD_CIRCUITS[5], 'W', MT.DATA.CABLES_01[5], 'R', IL.ROBOT_ARMS[5]);
		
		aClass = MultiTileEntityBasicMachineElectric.class;
		aMat = MT.DATA.Electric_T[1];   aRegistry.add("Electric Mixer ("                          +VN[1]+")", "Basic Machines"                      , 20351, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT,   32, NBT_TEXTURE, "electricmixer", NBT_ENERGY_ACCEPTED, TD.Energy.EU, NBT_RECIPEMAP, RM.Mixer, NBT_EFFICIENCY, 5000, NBT_INV_SIDE_IN, SBIT_L|SBIT_U, NBT_INV_SIDE_AUTO_IN, SIDE_LEFT, NBT_INV_SIDE_OUT, SBIT_R|SBIT_B, NBT_INV_SIDE_AUTO_OUT, SIDE_RIGHT, NBT_TANK_SIDE_IN, SBIT_L|SBIT_U, NBT_TANK_SIDE_AUTO_IN, SIDE_TOP, NBT_TANK_SIDE_OUT, SBIT_R|SBIT_B, NBT_TANK_SIDE_AUTO_OUT, SIDE_BACK, NBT_ENERGY_ACCEPTED_SIDES, SBIT_D, NBT_PARALLEL, 4, NBT_PARALLEL_DURATION, T), "PMP", "PRP", "hSw", 'M', OP.casingMachine.dat(aMat), 'S', IL.MOTORS[1], 'R', OP.rotor.dat(MT.StainlessSteel), 'P', OP.plate.dat(MT.StainlessSteel));
		aMat = MT.DATA.Electric_T[2];   aRegistry.add("Electric Mixer ("                          +VN[2]+")", "Basic Machines"                      , 20352, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT,  128, NBT_TEXTURE, "electricmixer", NBT_ENERGY_ACCEPTED, TD.Energy.EU, NBT_RECIPEMAP, RM.Mixer, NBT_EFFICIENCY, 5000, NBT_INV_SIDE_IN, SBIT_L|SBIT_U, NBT_INV_SIDE_AUTO_IN, SIDE_LEFT, NBT_INV_SIDE_OUT, SBIT_R|SBIT_B, NBT_INV_SIDE_AUTO_OUT, SIDE_RIGHT, NBT_TANK_SIDE_IN, SBIT_L|SBIT_U, NBT_TANK_SIDE_AUTO_IN, SIDE_TOP, NBT_TANK_SIDE_OUT, SBIT_R|SBIT_B, NBT_TANK_SIDE_AUTO_OUT, SIDE_BACK, NBT_ENERGY_ACCEPTED_SIDES, SBIT_D, NBT_PARALLEL, 8, NBT_PARALLEL_DURATION, T), "PMP", "PRP", "hSw", 'M', OP.casingMachine.dat(aMat), 'S', IL.MOTORS[2], 'R', OP.rotor.dat(MT.StainlessSteel), 'P', OP.plateDouble.dat(MT.StainlessSteel));
		aMat = MT.DATA.Electric_T[3];   aRegistry.add("Electric Mixer ("                          +VN[3]+")", "Basic Machines"                      , 20353, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT,  512, NBT_TEXTURE, "electricmixer", NBT_ENERGY_ACCEPTED, TD.Energy.EU, NBT_RECIPEMAP, RM.Mixer, NBT_EFFICIENCY, 5000, NBT_INV_SIDE_IN, SBIT_L|SBIT_U, NBT_INV_SIDE_AUTO_IN, SIDE_LEFT, NBT_INV_SIDE_OUT, SBIT_R|SBIT_B, NBT_INV_SIDE_AUTO_OUT, SIDE_RIGHT, NBT_TANK_SIDE_IN, SBIT_L|SBIT_U, NBT_TANK_SIDE_AUTO_IN, SIDE_TOP, NBT_TANK_SIDE_OUT, SBIT_R|SBIT_B, NBT_TANK_SIDE_AUTO_OUT, SIDE_BACK, NBT_ENERGY_ACCEPTED_SIDES, SBIT_D, NBT_PARALLEL,16, NBT_PARALLEL_DURATION, T), "PMP", "PRP", "hSw", 'M', OP.casingMachine.dat(aMat), 'S', IL.MOTORS[3], 'R', OP.rotor.dat(MT.StainlessSteel), 'P', OP.plateTriple.dat(MT.StainlessSteel));
		aMat = MT.DATA.Electric_T[4];   aRegistry.add("Electric Mixer ("                          +VN[4]+")", "Basic Machines"                      , 20354, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT, 2048, NBT_TEXTURE, "electricmixer", NBT_ENERGY_ACCEPTED, TD.Energy.EU, NBT_RECIPEMAP, RM.Mixer, NBT_EFFICIENCY, 5000, NBT_INV_SIDE_IN, SBIT_L|SBIT_U, NBT_INV_SIDE_AUTO_IN, SIDE_LEFT, NBT_INV_SIDE_OUT, SBIT_R|SBIT_B, NBT_INV_SIDE_AUTO_OUT, SIDE_RIGHT, NBT_TANK_SIDE_IN, SBIT_L|SBIT_U, NBT_TANK_SIDE_AUTO_IN, SIDE_TOP, NBT_TANK_SIDE_OUT, SBIT_R|SBIT_B, NBT_TANK_SIDE_AUTO_OUT, SIDE_BACK, NBT_ENERGY_ACCEPTED_SIDES, SBIT_D, NBT_PARALLEL,32, NBT_PARALLEL_DURATION, T), "PMP", "PRP", "hSw", 'M', OP.casingMachine.dat(aMat), 'S', IL.MOTORS[4], 'R', OP.rotor.dat(MT.StainlessSteel), 'P', OP.plateQuadruple.dat(MT.StainlessSteel));
		aMat = MT.DATA.Electric_T[5];   aRegistry.add("Electric Mixer ("                          +VN[5]+")", "Basic Machines"                      , 20355, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT, 8192, NBT_TEXTURE, "electricmixer", NBT_ENERGY_ACCEPTED, TD.Energy.EU, NBT_RECIPEMAP, RM.Mixer, NBT_EFFICIENCY, 5000, NBT_INV_SIDE_IN, SBIT_L|SBIT_U, NBT_INV_SIDE_AUTO_IN, SIDE_LEFT, NBT_INV_SIDE_OUT, SBIT_R|SBIT_B, NBT_INV_SIDE_AUTO_OUT, SIDE_RIGHT, NBT_TANK_SIDE_IN, SBIT_L|SBIT_U, NBT_TANK_SIDE_AUTO_IN, SIDE_TOP, NBT_TANK_SIDE_OUT, SBIT_R|SBIT_B, NBT_TANK_SIDE_AUTO_OUT, SIDE_BACK, NBT_ENERGY_ACCEPTED_SIDES, SBIT_D, NBT_PARALLEL,64, NBT_PARALLEL_DURATION, T), "PMP", "PRP", "hSw", 'M', OP.casingMachine.dat(aMat), 'S', IL.MOTORS[5], 'R', OP.rotor.dat(MT.StainlessSteel), 'P', OP.plateQuadruple.dat(MT.StainlessSteel));
		
		aClass = MultiTileEntityBasicMachineElectric.class;
		aMat = MT.DATA.Electric_T[1];   aRegistry.add("Electric Loom ("                           +VN[1]+")", "Basic Machines"                      , 20361, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT,   32, NBT_TEXTURE, "electricloom", NBT_ENERGY_ACCEPTED, TD.Energy.EU, NBT_RECIPEMAP, RM.Loom, NBT_EFFICIENCY, 5000, NBT_INV_SIDE_IN, SBIT_U, NBT_INV_SIDE_AUTO_IN, SIDE_TOP, NBT_INV_SIDE_OUT, SBIT_D, NBT_INV_SIDE_AUTO_OUT, SIDE_BOTTOM, NBT_ENERGY_ACCEPTED_SIDES, SBIT_L|SBIT_R), "ShS", "GMG", "SwS", 'M', OP.casingMachine.dat(aMat), 'G', IL.MOTORS[1], 'S', OP.stickLong.dat(aMat));
		aMat = MT.DATA.Electric_T[2];   aRegistry.add("Electric Loom ("                           +VN[2]+")", "Basic Machines"                      , 20362, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT,  128, NBT_TEXTURE, "electricloom", NBT_ENERGY_ACCEPTED, TD.Energy.EU, NBT_RECIPEMAP, RM.Loom, NBT_EFFICIENCY, 5000, NBT_INV_SIDE_IN, SBIT_U, NBT_INV_SIDE_AUTO_IN, SIDE_TOP, NBT_INV_SIDE_OUT, SBIT_D, NBT_INV_SIDE_AUTO_OUT, SIDE_BOTTOM, NBT_ENERGY_ACCEPTED_SIDES, SBIT_L|SBIT_R), "ShS", "GMG", "SwS", 'M', OP.casingMachine.dat(aMat), 'G', IL.MOTORS[2], 'S', OP.stickLong.dat(aMat));
		aMat = MT.DATA.Electric_T[3];   aRegistry.add("Electric Loom ("                           +VN[3]+")", "Basic Machines"                      , 20363, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT,  512, NBT_TEXTURE, "electricloom", NBT_ENERGY_ACCEPTED, TD.Energy.EU, NBT_RECIPEMAP, RM.Loom, NBT_EFFICIENCY, 5000, NBT_INV_SIDE_IN, SBIT_U, NBT_INV_SIDE_AUTO_IN, SIDE_TOP, NBT_INV_SIDE_OUT, SBIT_D, NBT_INV_SIDE_AUTO_OUT, SIDE_BOTTOM, NBT_ENERGY_ACCEPTED_SIDES, SBIT_L|SBIT_R), "ShS", "GMG", "SwS", 'M', OP.casingMachine.dat(aMat), 'G', IL.MOTORS[3], 'S', OP.stickLong.dat(aMat));
		aMat = MT.DATA.Electric_T[4];   aRegistry.add("Electric Loom ("                           +VN[4]+")", "Basic Machines"                      , 20364, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT, 2048, NBT_TEXTURE, "electricloom", NBT_ENERGY_ACCEPTED, TD.Energy.EU, NBT_RECIPEMAP, RM.Loom, NBT_EFFICIENCY, 5000, NBT_INV_SIDE_IN, SBIT_U, NBT_INV_SIDE_AUTO_IN, SIDE_TOP, NBT_INV_SIDE_OUT, SBIT_D, NBT_INV_SIDE_AUTO_OUT, SIDE_BOTTOM, NBT_ENERGY_ACCEPTED_SIDES, SBIT_L|SBIT_R), "ShS", "GMG", "SwS", 'M', OP.casingMachine.dat(aMat), 'G', IL.MOTORS[4], 'S', OP.stickLong.dat(aMat));
		aMat = MT.DATA.Electric_T[5];   aRegistry.add("Electric Loom ("                           +VN[5]+")", "Basic Machines"                      , 20365, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT, 8192, NBT_TEXTURE, "electricloom", NBT_ENERGY_ACCEPTED, TD.Energy.EU, NBT_RECIPEMAP, RM.Loom, NBT_EFFICIENCY, 5000, NBT_INV_SIDE_IN, SBIT_U, NBT_INV_SIDE_AUTO_IN, SIDE_TOP, NBT_INV_SIDE_OUT, SBIT_D, NBT_INV_SIDE_AUTO_OUT, SIDE_BOTTOM, NBT_ENERGY_ACCEPTED_SIDES, SBIT_L|SBIT_R), "ShS", "GMG", "SwS", 'M', OP.casingMachine.dat(aMat), 'G', IL.MOTORS[5], 'S', OP.stickLong.dat(aMat));
		
		aClass = MultiTileEntityBasicMachineElectric.class;
		aMat = MT.DATA.Electric_T[1];   aRegistry.add("Electric Sifter ("                         +VN[1]+")", "Basic Machines"                      , 20371, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT,   32, NBT_TEXTURE, "electricsifter", NBT_ENERGY_ACCEPTED, TD.Energy.EU, NBT_RECIPEMAP, RM.Sifting, NBT_EFFICIENCY, 5000, NBT_INV_SIDE_IN, SBIT_U, NBT_INV_SIDE_AUTO_IN, SIDE_TOP, NBT_INV_SIDE_OUT, SBIT_D, NBT_INV_SIDE_AUTO_OUT, SIDE_BOTTOM, NBT_ENERGY_ACCEPTED_SIDES, SBIT_B), "WxW", "RMR", "SwS", 'M', OP.casingMachineDouble.dat(aMat), 'S', IL.PISTONS[1], 'W', OP.wireFine.dat(aMat), 'R', OP.stick.dat(aMat));
		aMat = MT.DATA.Electric_T[2];   aRegistry.add("Electric Sifter ("                         +VN[2]+")", "Basic Machines"                      , 20372, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT,  128, NBT_TEXTURE, "electricsifter", NBT_ENERGY_ACCEPTED, TD.Energy.EU, NBT_RECIPEMAP, RM.Sifting, NBT_EFFICIENCY, 5000, NBT_INV_SIDE_IN, SBIT_U, NBT_INV_SIDE_AUTO_IN, SIDE_TOP, NBT_INV_SIDE_OUT, SBIT_D, NBT_INV_SIDE_AUTO_OUT, SIDE_BOTTOM, NBT_ENERGY_ACCEPTED_SIDES, SBIT_B), "WxW", "RMR", "SwS", 'M', OP.casingMachineDouble.dat(aMat), 'S', IL.PISTONS[2], 'W', OP.wireFine.dat(aMat), 'R', OP.stick.dat(aMat));
		aMat = MT.DATA.Electric_T[3];   aRegistry.add("Electric Sifter ("                         +VN[3]+")", "Basic Machines"                      , 20373, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT,  512, NBT_TEXTURE, "electricsifter", NBT_ENERGY_ACCEPTED, TD.Energy.EU, NBT_RECIPEMAP, RM.Sifting, NBT_EFFICIENCY, 5000, NBT_INV_SIDE_IN, SBIT_U, NBT_INV_SIDE_AUTO_IN, SIDE_TOP, NBT_INV_SIDE_OUT, SBIT_D, NBT_INV_SIDE_AUTO_OUT, SIDE_BOTTOM, NBT_ENERGY_ACCEPTED_SIDES, SBIT_B), "WxW", "RMR", "SwS", 'M', OP.casingMachineDouble.dat(aMat), 'S', IL.PISTONS[3], 'W', OP.wireFine.dat(aMat), 'R', OP.stick.dat(aMat));
		aMat = MT.DATA.Electric_T[4];   aRegistry.add("Electric Sifter ("                         +VN[4]+")", "Basic Machines"                      , 20374, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT, 2048, NBT_TEXTURE, "electricsifter", NBT_ENERGY_ACCEPTED, TD.Energy.EU, NBT_RECIPEMAP, RM.Sifting, NBT_EFFICIENCY, 5000, NBT_INV_SIDE_IN, SBIT_U, NBT_INV_SIDE_AUTO_IN, SIDE_TOP, NBT_INV_SIDE_OUT, SBIT_D, NBT_INV_SIDE_AUTO_OUT, SIDE_BOTTOM, NBT_ENERGY_ACCEPTED_SIDES, SBIT_B), "WxW", "RMR", "SwS", 'M', OP.casingMachineDouble.dat(aMat), 'S', IL.PISTONS[4], 'W', OP.wireFine.dat(aMat), 'R', OP.stick.dat(aMat));
		aMat = MT.DATA.Electric_T[5];   aRegistry.add("Electric Sifter ("                         +VN[5]+")", "Basic Machines"                      , 20375, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT, 8192, NBT_TEXTURE, "electricsifter", NBT_ENERGY_ACCEPTED, TD.Energy.EU, NBT_RECIPEMAP, RM.Sifting, NBT_EFFICIENCY, 5000, NBT_INV_SIDE_IN, SBIT_U, NBT_INV_SIDE_AUTO_IN, SIDE_TOP, NBT_INV_SIDE_OUT, SBIT_D, NBT_INV_SIDE_AUTO_OUT, SIDE_BOTTOM, NBT_ENERGY_ACCEPTED_SIDES, SBIT_B), "WxW", "RMR", "SwS", 'M', OP.casingMachineDouble.dat(aMat), 'S', IL.PISTONS[5], 'W', OP.wireFine.dat(aMat), 'R', OP.stick.dat(aMat));
		
		aClass = MultiTileEntityBasicMachineElectric.class;
		aMat = MT.DATA.Electric_T[1];   aRegistry.add("Slicer ("                                  +VN[1]+")", "Basic Machines"                      , 20381, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT,   32, NBT_TEXTURE, "slicer", NBT_ENERGY_ACCEPTED, TD.Energy.EU, NBT_RECIPEMAP, RM.Slicer, NBT_INV_SIDE_IN, SBIT_L|SBIT_U, NBT_INV_SIDE_AUTO_IN, SIDE_LEFT, NBT_INV_SIDE_OUT, SBIT_R|SBIT_D, NBT_INV_SIDE_AUTO_OUT, SIDE_RIGHT, NBT_ENERGY_ACCEPTED_SIDES, SBIT_B), "PRw", "YMC", 'M', OP.casingMachine.dat(aMat), 'P', IL.PISTONS[1], 'Y', IL.CONVEYERS[1], 'C', OD_CIRCUITS[1], 'R', OP.stick.dat(aMat));
		aMat = MT.DATA.Electric_T[2];   aRegistry.add("Slicer ("                                  +VN[2]+")", "Basic Machines"                      , 20382, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT,  128, NBT_TEXTURE, "slicer", NBT_ENERGY_ACCEPTED, TD.Energy.EU, NBT_RECIPEMAP, RM.Slicer, NBT_INV_SIDE_IN, SBIT_L|SBIT_U, NBT_INV_SIDE_AUTO_IN, SIDE_LEFT, NBT_INV_SIDE_OUT, SBIT_R|SBIT_D, NBT_INV_SIDE_AUTO_OUT, SIDE_RIGHT, NBT_ENERGY_ACCEPTED_SIDES, SBIT_B), "PRw", "YMC", 'M', OP.casingMachine.dat(aMat), 'P', IL.PISTONS[2], 'Y', IL.CONVEYERS[2], 'C', OD_CIRCUITS[2], 'R', OP.stick.dat(aMat));
		aMat = MT.DATA.Electric_T[3];   aRegistry.add("Slicer ("                                  +VN[3]+")", "Basic Machines"                      , 20383, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT,  512, NBT_TEXTURE, "slicer", NBT_ENERGY_ACCEPTED, TD.Energy.EU, NBT_RECIPEMAP, RM.Slicer, NBT_INV_SIDE_IN, SBIT_L|SBIT_U, NBT_INV_SIDE_AUTO_IN, SIDE_LEFT, NBT_INV_SIDE_OUT, SBIT_R|SBIT_D, NBT_INV_SIDE_AUTO_OUT, SIDE_RIGHT, NBT_ENERGY_ACCEPTED_SIDES, SBIT_B), "PRw", "YMC", 'M', OP.casingMachine.dat(aMat), 'P', IL.PISTONS[3], 'Y', IL.CONVEYERS[3], 'C', OD_CIRCUITS[3], 'R', OP.stick.dat(aMat));
		aMat = MT.DATA.Electric_T[4];   aRegistry.add("Slicer ("                                  +VN[4]+")", "Basic Machines"                      , 20384, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT, 2048, NBT_TEXTURE, "slicer", NBT_ENERGY_ACCEPTED, TD.Energy.EU, NBT_RECIPEMAP, RM.Slicer, NBT_INV_SIDE_IN, SBIT_L|SBIT_U, NBT_INV_SIDE_AUTO_IN, SIDE_LEFT, NBT_INV_SIDE_OUT, SBIT_R|SBIT_D, NBT_INV_SIDE_AUTO_OUT, SIDE_RIGHT, NBT_ENERGY_ACCEPTED_SIDES, SBIT_B), "PRw", "YMC", 'M', OP.casingMachine.dat(aMat), 'P', IL.PISTONS[4], 'Y', IL.CONVEYERS[4], 'C', OD_CIRCUITS[4], 'R', OP.stick.dat(aMat));
		aMat = MT.DATA.Electric_T[5];   aRegistry.add("Slicer ("                                  +VN[5]+")", "Basic Machines"                      , 20385, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT, 8192, NBT_TEXTURE, "slicer", NBT_ENERGY_ACCEPTED, TD.Energy.EU, NBT_RECIPEMAP, RM.Slicer, NBT_INV_SIDE_IN, SBIT_L|SBIT_U, NBT_INV_SIDE_AUTO_IN, SIDE_LEFT, NBT_INV_SIDE_OUT, SBIT_R|SBIT_D, NBT_INV_SIDE_AUTO_OUT, SIDE_RIGHT, NBT_ENERGY_ACCEPTED_SIDES, SBIT_B), "PRw", "YMC", 'M', OP.casingMachine.dat(aMat), 'P', IL.PISTONS[5], 'Y', IL.CONVEYERS[5], 'C', OD_CIRCUITS[5], 'R', OP.stick.dat(aMat));
		
		aClass = MultiTileEntityBasicMachine.class;
		aMat = MT.DATA.Heat_T[1];       aRegistry.add("Laminator ("                     +aMat.getLocal()+")", "Basic Machines"                      , 20391, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   6.0F, NBT_RESISTANCE,   6.0F, NBT_INPUT,   32, NBT_TEXTURE, "laminator", NBT_ENERGY_ACCEPTED, TD.Energy.HU, NBT_RECIPEMAP, RM.Laminator, NBT_GUI, RES_PATH_GUI + "machines/Laminator.png", NBT_INV_SIDE_IN, SBIT_L|SBIT_U, NBT_INV_SIDE_AUTO_IN, SIDE_LEFT, NBT_INV_SIDE_OUT, SBIT_R, NBT_INV_SIDE_AUTO_OUT, SIDE_RIGHT, NBT_ENERGY_ACCEPTED_SIDES, SBIT_D), "SwS", "GMG", "SCS", 'M', OP.casingMachine.dat(aMat), 'G', OP.gearGtSmall.dat(aMat), 'S', OP.stick.dat(aMat), 'C', OP.plateDouble.dat(ANY.Cu));
		aMat = MT.DATA.Heat_T[2];       aRegistry.add("Laminator ("                     +aMat.getLocal()+")", "Basic Machines"                      , 20392, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT,  128, NBT_TEXTURE, "laminator", NBT_ENERGY_ACCEPTED, TD.Energy.HU, NBT_RECIPEMAP, RM.Laminator, NBT_GUI, RES_PATH_GUI + "machines/Laminator.png", NBT_INV_SIDE_IN, SBIT_L|SBIT_U, NBT_INV_SIDE_AUTO_IN, SIDE_LEFT, NBT_INV_SIDE_OUT, SBIT_R, NBT_INV_SIDE_AUTO_OUT, SIDE_RIGHT, NBT_ENERGY_ACCEPTED_SIDES, SBIT_D), "SwS", "GMG", "SCS", 'M', OP.casingMachine.dat(aMat), 'G', OP.gearGtSmall.dat(aMat), 'S', OP.stick.dat(aMat), 'C', OP.plateDouble.dat(ANY.Cu));
		aMat = MT.DATA.Heat_T[3];       aRegistry.add("Laminator ("                     +aMat.getLocal()+")", "Basic Machines"                      , 20393, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   9.0F, NBT_RESISTANCE,   9.0F, NBT_INPUT,  512, NBT_TEXTURE, "laminator", NBT_ENERGY_ACCEPTED, TD.Energy.HU, NBT_RECIPEMAP, RM.Laminator, NBT_GUI, RES_PATH_GUI + "machines/Laminator.png", NBT_INV_SIDE_IN, SBIT_L|SBIT_U, NBT_INV_SIDE_AUTO_IN, SIDE_LEFT, NBT_INV_SIDE_OUT, SBIT_R, NBT_INV_SIDE_AUTO_OUT, SIDE_RIGHT, NBT_ENERGY_ACCEPTED_SIDES, SBIT_D), "SwS", "GMG", "SCS", 'M', OP.casingMachine.dat(aMat), 'G', OP.gearGtSmall.dat(aMat), 'S', OP.stick.dat(aMat), 'C', OP.plateDouble.dat(ANY.Cu));
		aMat = MT.DATA.Heat_T[4];       aRegistry.add("Laminator ("                     +aMat.getLocal()+")", "Basic Machines"                      , 20394, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,  12.5F, NBT_RESISTANCE,  12.5F, NBT_INPUT, 2048, NBT_TEXTURE, "laminator", NBT_ENERGY_ACCEPTED, TD.Energy.HU, NBT_RECIPEMAP, RM.Laminator, NBT_GUI, RES_PATH_GUI + "machines/Laminator.png", NBT_INV_SIDE_IN, SBIT_L|SBIT_U, NBT_INV_SIDE_AUTO_IN, SIDE_LEFT, NBT_INV_SIDE_OUT, SBIT_R, NBT_INV_SIDE_AUTO_OUT, SIDE_RIGHT, NBT_ENERGY_ACCEPTED_SIDES, SBIT_D), "SwS", "GMG", "SCS", 'M', OP.casingMachine.dat(aMat), 'G', OP.gearGtSmall.dat(aMat), 'S', OP.stick.dat(aMat), 'C', OP.plateDouble.dat(ANY.Cu));
	}
	
	private static void machines3(MultiTileEntityRegistry aRegistry, MultiTileEntityBlock aMetal, MultiTileEntityBlock aMetalChips, MultiTileEntityBlock aMetalWires, MultiTileEntityBlock aMachine, MultiTileEntityBlock aWooden, MultiTileEntityBlock aBush, MultiTileEntityBlock aStone, MultiTileEntityBlock aWool, MultiTileEntityBlock aTNT, MultiTileEntityBlock aHive, MultiTileEntityBlock aUtilMetal, MultiTileEntityBlock aUtilStone, MultiTileEntityBlock aUtilWood, MultiTileEntityBlock aUtilWool, OreDictMaterial aMat, Class<? extends TileEntity> aClass) {
		// TODO: Amplifab at 20401, 20402, 20403, 20404, 20405
		
		aClass = MultiTileEntityBasicMachine.class;
		aMat = MT.Osmiridium;           aRegistry.add("Matter Fabricator (T1)"                              , "Basic Machines"                      , 20411, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,  16.0F, NBT_RESISTANCE,  16.0F, NBT_INPUT,   32, NBT_TEXTURE, "massfab", NBT_ENERGY_ACCEPTED, TD.Energy.QU, NBT_RECIPEMAP, RM.Massfab, NBT_CHEAP_OVERCLOCKING, T, NBT_NO_CONSTANT_POWER, T, NBT_EFFICIENCY,  5000, NBT_INV_SIDE_IN, SBIT_L|SBIT_U, NBT_INV_SIDE_AUTO_IN, SIDE_LEFT, NBT_INV_SIDE_OUT, SBIT_D|SBIT_R, NBT_INV_SIDE_AUTO_OUT, SIDE_RIGHT, NBT_TANK_SIDE_IN, SBIT_L|SBIT_U, NBT_TANK_SIDE_AUTO_IN, SIDE_TOP, NBT_TANK_SIDE_OUT, SBIT_D|SBIT_R, NBT_TANK_SIDE_AUTO_OUT, SIDE_BOTTOM, NBT_ENERGY_ACCEPTED_SIDES, SBIT_B), "RFS", "FMF", "RFS", 'M', OP.casingMachine.dat(aMat), 'R', IL.Processor_Crystal_Ruby, 'S', IL.Processor_Crystal_Sapphire, 'F', IL.FIELD_GENERATORS[1]);
		aMat = MT.Osmiridium;           aRegistry.add("Matter Fabricator (T2)"                              , "Basic Machines"                      , 20412, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,  16.0F, NBT_RESISTANCE,  16.0F, NBT_INPUT,  128, NBT_TEXTURE, "massfab", NBT_ENERGY_ACCEPTED, TD.Energy.QU, NBT_RECIPEMAP, RM.Massfab, NBT_CHEAP_OVERCLOCKING, T, NBT_NO_CONSTANT_POWER, T, NBT_EFFICIENCY,  6250, NBT_INV_SIDE_IN, SBIT_L|SBIT_U, NBT_INV_SIDE_AUTO_IN, SIDE_LEFT, NBT_INV_SIDE_OUT, SBIT_D|SBIT_R, NBT_INV_SIDE_AUTO_OUT, SIDE_RIGHT, NBT_TANK_SIDE_IN, SBIT_L|SBIT_U, NBT_TANK_SIDE_AUTO_IN, SIDE_TOP, NBT_TANK_SIDE_OUT, SBIT_D|SBIT_R, NBT_TANK_SIDE_AUTO_OUT, SIDE_BOTTOM, NBT_ENERGY_ACCEPTED_SIDES, SBIT_B), "RFS", "FMF", "RFS", 'M', OP.casingMachine.dat(aMat), 'R', IL.Processor_Crystal_Ruby, 'S', IL.Processor_Crystal_Sapphire, 'F', IL.FIELD_GENERATORS[2]);
		aMat = MT.Osmiridium;           aRegistry.add("Matter Fabricator (T3)"                              , "Basic Machines"                      , 20413, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,  16.0F, NBT_RESISTANCE,  16.0F, NBT_INPUT,  512, NBT_TEXTURE, "massfab", NBT_ENERGY_ACCEPTED, TD.Energy.QU, NBT_RECIPEMAP, RM.Massfab, NBT_CHEAP_OVERCLOCKING, T, NBT_NO_CONSTANT_POWER, T, NBT_EFFICIENCY,  7500, NBT_INV_SIDE_IN, SBIT_L|SBIT_U, NBT_INV_SIDE_AUTO_IN, SIDE_LEFT, NBT_INV_SIDE_OUT, SBIT_D|SBIT_R, NBT_INV_SIDE_AUTO_OUT, SIDE_RIGHT, NBT_TANK_SIDE_IN, SBIT_L|SBIT_U, NBT_TANK_SIDE_AUTO_IN, SIDE_TOP, NBT_TANK_SIDE_OUT, SBIT_D|SBIT_R, NBT_TANK_SIDE_AUTO_OUT, SIDE_BOTTOM, NBT_ENERGY_ACCEPTED_SIDES, SBIT_B), "RFS", "FMF", "RFS", 'M', OP.casingMachine.dat(aMat), 'R', IL.Processor_Crystal_Ruby, 'S', IL.Processor_Crystal_Sapphire, 'F', IL.FIELD_GENERATORS[3]);
		aMat = MT.Osmiridium;           aRegistry.add("Matter Fabricator (T4)"                              , "Basic Machines"                      , 20414, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,  16.0F, NBT_RESISTANCE,  16.0F, NBT_INPUT, 2048, NBT_TEXTURE, "massfab", NBT_ENERGY_ACCEPTED, TD.Energy.QU, NBT_RECIPEMAP, RM.Massfab, NBT_CHEAP_OVERCLOCKING, T, NBT_NO_CONSTANT_POWER, T, NBT_EFFICIENCY,  8750, NBT_INV_SIDE_IN, SBIT_L|SBIT_U, NBT_INV_SIDE_AUTO_IN, SIDE_LEFT, NBT_INV_SIDE_OUT, SBIT_D|SBIT_R, NBT_INV_SIDE_AUTO_OUT, SIDE_RIGHT, NBT_TANK_SIDE_IN, SBIT_L|SBIT_U, NBT_TANK_SIDE_AUTO_IN, SIDE_TOP, NBT_TANK_SIDE_OUT, SBIT_D|SBIT_R, NBT_TANK_SIDE_AUTO_OUT, SIDE_BOTTOM, NBT_ENERGY_ACCEPTED_SIDES, SBIT_B), "RFS", "FMF", "RFS", 'M', OP.casingMachine.dat(aMat), 'R', IL.Processor_Crystal_Ruby, 'S', IL.Processor_Crystal_Sapphire, 'F', IL.FIELD_GENERATORS[4]);
		aMat = MT.Osmiridium;           aRegistry.add("Matter Fabricator (T5)"                              , "Basic Machines"                      , 20415, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,  16.0F, NBT_RESISTANCE,  16.0F, NBT_INPUT, 8192, NBT_TEXTURE, "massfab", NBT_ENERGY_ACCEPTED, TD.Energy.QU, NBT_RECIPEMAP, RM.Massfab, NBT_CHEAP_OVERCLOCKING, T, NBT_NO_CONSTANT_POWER, T, NBT_EFFICIENCY, 10000, NBT_INV_SIDE_IN, SBIT_L|SBIT_U, NBT_INV_SIDE_AUTO_IN, SIDE_LEFT, NBT_INV_SIDE_OUT, SBIT_D|SBIT_R, NBT_INV_SIDE_AUTO_OUT, SIDE_RIGHT, NBT_TANK_SIDE_IN, SBIT_L|SBIT_U, NBT_TANK_SIDE_AUTO_IN, SIDE_TOP, NBT_TANK_SIDE_OUT, SBIT_D|SBIT_R, NBT_TANK_SIDE_AUTO_OUT, SIDE_BOTTOM, NBT_ENERGY_ACCEPTED_SIDES, SBIT_B), "RFS", "FMF", "RFS", 'M', OP.casingMachine.dat(aMat), 'R', IL.Processor_Crystal_Ruby, 'S', IL.Processor_Crystal_Sapphire, 'F', IL.FIELD_GENERATORS[5]);
		
		aClass = MultiTileEntityBasicMachine.class;
//      aMat = MT.Osmiridium;           aRegistry.add("Molecular Scanner (T1)"                              , "Basic Machines"                      , 20421, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,  16.0F, NBT_RESISTANCE,  16.0F, NBT_INPUT,   32, NBT_TEXTURE, "scannermolecular", NBT_ENERGY_ACCEPTED, TD.Energy.QU, NBT_RECIPEMAP, RM.ScannerMolecular, NBT_EFFICIENCY, 10000, NBT_INV_SIDE_IN, SBIT_L|SBIT_U, NBT_INV_SIDE_AUTO_IN, SIDE_LEFT, NBT_INV_SIDE_OUT, SBIT_D|SBIT_R, NBT_INV_SIDE_AUTO_OUT, SIDE_RIGHT/*, NBT_TANK_SIDE_INPUT, SIDE_BITS[SIDE_LEFT]|SIDE_BITS[SIDE_TOP], NBT_TANK_SIDE_AUTO_INPUT, SIDE_LEFT, NBT_TANK_SIDE_OUTPUT, SIDE_BITS[SIDE_BOTTOM]|SIDE_BITS[SIDE_RIGHT], NBT_TANK_SIDE_AUTO_OUTPUT, SIDE_RIGHT*/, NBT_ENERGY_ACCEPTED_SIDES, SBIT_B), "DXE", "FMF", "RYS", 'M', OP.casingMachine.dat(aMat), 'D', IL.Processor_Crystal_Diamond, 'E', IL.Processor_Crystal_Emerald, 'R', IL.Processor_Crystal_Ruby, 'S', IL.Processor_Crystal_Sapphire, 'F', IL.FIELD_GENERATORS[1], 'X', IL.EMITTERS[1], 'Y', IL.SENSORS[1]);
//      aMat = MT.Osmiridium;           aRegistry.add("Molecular Scanner (T2)"                              , "Basic Machines"                      , 20422, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,  16.0F, NBT_RESISTANCE,  16.0F, NBT_INPUT,  128, NBT_TEXTURE, "scannermolecular", NBT_ENERGY_ACCEPTED, TD.Energy.QU, NBT_RECIPEMAP, RM.ScannerMolecular, NBT_EFFICIENCY, 10000, NBT_INV_SIDE_IN, SBIT_L|SBIT_U, NBT_INV_SIDE_AUTO_IN, SIDE_LEFT, NBT_INV_SIDE_OUT, SBIT_D|SBIT_R, NBT_INV_SIDE_AUTO_OUT, SIDE_RIGHT/*, NBT_TANK_SIDE_INPUT, SIDE_BITS[SIDE_LEFT]|SIDE_BITS[SIDE_TOP], NBT_TANK_SIDE_AUTO_INPUT, SIDE_LEFT, NBT_TANK_SIDE_OUTPUT, SIDE_BITS[SIDE_BOTTOM]|SIDE_BITS[SIDE_RIGHT], NBT_TANK_SIDE_AUTO_OUTPUT, SIDE_RIGHT*/, NBT_ENERGY_ACCEPTED_SIDES, SBIT_B), "DXE", "FMF", "RYS", 'M', OP.casingMachine.dat(aMat), 'D', IL.Processor_Crystal_Diamond, 'E', IL.Processor_Crystal_Emerald, 'R', IL.Processor_Crystal_Ruby, 'S', IL.Processor_Crystal_Sapphire, 'F', IL.FIELD_GENERATORS[2], 'X', IL.EMITTERS[2], 'Y', IL.SENSORS[2]);
		aMat = MT.Osmiridium;           aRegistry.add("Molecular Scanner (T3)"                              , "Basic Machines"                      , 20423, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,  16.0F, NBT_RESISTANCE,  16.0F, NBT_INPUT,  512, NBT_TEXTURE, "scannermolecular", NBT_ENERGY_ACCEPTED, TD.Energy.QU, NBT_RECIPEMAP, RM.ScannerMolecular, NBT_EFFICIENCY, 10000, NBT_INV_SIDE_IN, SBIT_L|SBIT_U, NBT_INV_SIDE_AUTO_IN, SIDE_LEFT, NBT_INV_SIDE_OUT, SBIT_D|SBIT_R, NBT_INV_SIDE_AUTO_OUT, SIDE_RIGHT/*, NBT_TANK_SIDE_INPUT, SIDE_BITS[SIDE_LEFT]|SIDE_BITS[SIDE_TOP], NBT_TANK_SIDE_AUTO_INPUT, SIDE_LEFT, NBT_TANK_SIDE_OUTPUT, SIDE_BITS[SIDE_BOTTOM]|SIDE_BITS[SIDE_RIGHT], NBT_TANK_SIDE_AUTO_OUTPUT, SIDE_RIGHT*/, NBT_ENERGY_ACCEPTED_SIDES, SBIT_B), "DXE", "FMF", "RYS", 'M', OP.casingMachine.dat(aMat), 'D', IL.Processor_Crystal_Diamond, 'E', IL.Processor_Crystal_Emerald, 'R', IL.Processor_Crystal_Ruby, 'S', IL.Processor_Crystal_Sapphire, 'F', IL.FIELD_GENERATORS[3], 'X', IL.EMITTERS[3], 'Y', IL.SENSORS[3]);
//      aMat = MT.Osmiridium;           aRegistry.add("Molecular Scanner (T4)"                              , "Basic Machines"                      , 20424, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,  16.0F, NBT_RESISTANCE,  16.0F, NBT_INPUT, 2048, NBT_TEXTURE, "scannermolecular", NBT_ENERGY_ACCEPTED, TD.Energy.QU, NBT_RECIPEMAP, RM.ScannerMolecular, NBT_EFFICIENCY, 10000, NBT_INV_SIDE_IN, SBIT_L|SBIT_U, NBT_INV_SIDE_AUTO_IN, SIDE_LEFT, NBT_INV_SIDE_OUT, SBIT_D|SBIT_R, NBT_INV_SIDE_AUTO_OUT, SIDE_RIGHT/*, NBT_TANK_SIDE_INPUT, SIDE_BITS[SIDE_LEFT]|SIDE_BITS[SIDE_TOP], NBT_TANK_SIDE_AUTO_INPUT, SIDE_LEFT, NBT_TANK_SIDE_OUTPUT, SIDE_BITS[SIDE_BOTTOM]|SIDE_BITS[SIDE_RIGHT], NBT_TANK_SIDE_AUTO_OUTPUT, SIDE_RIGHT*/, NBT_ENERGY_ACCEPTED_SIDES, SBIT_B), "DXE", "FMF", "RYS", 'M', OP.casingMachine.dat(aMat), 'D', IL.Processor_Crystal_Diamond, 'E', IL.Processor_Crystal_Emerald, 'R', IL.Processor_Crystal_Ruby, 'S', IL.Processor_Crystal_Sapphire, 'F', IL.FIELD_GENERATORS[4], 'X', IL.EMITTERS[4], 'Y', IL.SENSORS[4]);
//      aMat = MT.Osmiridium;           aRegistry.add("Molecular Scanner (T5)"                              , "Basic Machines"                      , 20425, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,  16.0F, NBT_RESISTANCE,  16.0F, NBT_INPUT, 8192, NBT_TEXTURE, "scannermolecular", NBT_ENERGY_ACCEPTED, TD.Energy.QU, NBT_RECIPEMAP, RM.ScannerMolecular, NBT_EFFICIENCY, 10000, NBT_INV_SIDE_IN, SBIT_L|SBIT_U, NBT_INV_SIDE_AUTO_IN, SIDE_LEFT, NBT_INV_SIDE_OUT, SBIT_D|SBIT_R, NBT_INV_SIDE_AUTO_OUT, SIDE_RIGHT/*, NBT_TANK_SIDE_INPUT, SIDE_BITS[SIDE_LEFT]|SIDE_BITS[SIDE_TOP], NBT_TANK_SIDE_AUTO_INPUT, SIDE_LEFT, NBT_TANK_SIDE_OUTPUT, SIDE_BITS[SIDE_BOTTOM]|SIDE_BITS[SIDE_RIGHT], NBT_TANK_SIDE_AUTO_OUTPUT, SIDE_RIGHT*/, NBT_ENERGY_ACCEPTED_SIDES, SBIT_B), "DXE", "FMF", "RYS", 'M', OP.casingMachine.dat(aMat), 'D', IL.Processor_Crystal_Diamond, 'E', IL.Processor_Crystal_Emerald, 'R', IL.Processor_Crystal_Ruby, 'S', IL.Processor_Crystal_Sapphire, 'F', IL.FIELD_GENERATORS[5], 'X', IL.EMITTERS[5], 'Y', IL.SENSORS[5]);
		
		aClass = MultiTileEntityBasicMachine.class;
		aMat = MT.Osmiridium;           aRegistry.add("Matter Replicator (T1)"                              , "Basic Machines"                      , 20431, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,  16.0F, NBT_RESISTANCE,  16.0F, NBT_INPUT,   32, NBT_TEXTURE, "replicator", NBT_ENERGY_ACCEPTED, TD.Energy.QU, NBT_RECIPEMAP, RM.Replicator, NBT_CHEAP_OVERCLOCKING, T, NBT_NO_CONSTANT_POWER, T, NBT_EFFICIENCY,  5000, NBT_INV_SIDE_IN, SBIT_L|SBIT_U, NBT_INV_SIDE_AUTO_IN, SIDE_LEFT, NBT_INV_SIDE_OUT, SBIT_D|SBIT_R, NBT_INV_SIDE_AUTO_OUT, SIDE_RIGHT, NBT_TANK_SIDE_IN, SBIT_L|SBIT_U, NBT_TANK_SIDE_AUTO_IN, SIDE_TOP, NBT_TANK_SIDE_OUT, SBIT_D|SBIT_R, NBT_TANK_SIDE_AUTO_OUT, SIDE_BOTTOM, NBT_ENERGY_ACCEPTED_SIDES, SBIT_B), "EXE", "FMF", "SXS", 'M', OP.casingMachine.dat(aMat), 'E', IL.Processor_Crystal_Emerald, 'S', IL.Processor_Crystal_Sapphire, 'X', IL.EMITTERS[1], 'F', IL.FIELD_GENERATORS[1]);
		aMat = MT.Osmiridium;           aRegistry.add("Matter Replicator (T2)"                              , "Basic Machines"                      , 20432, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,  16.0F, NBT_RESISTANCE,  16.0F, NBT_INPUT,  128, NBT_TEXTURE, "replicator", NBT_ENERGY_ACCEPTED, TD.Energy.QU, NBT_RECIPEMAP, RM.Replicator, NBT_CHEAP_OVERCLOCKING, T, NBT_NO_CONSTANT_POWER, T, NBT_EFFICIENCY,  6250, NBT_INV_SIDE_IN, SBIT_L|SBIT_U, NBT_INV_SIDE_AUTO_IN, SIDE_LEFT, NBT_INV_SIDE_OUT, SBIT_D|SBIT_R, NBT_INV_SIDE_AUTO_OUT, SIDE_RIGHT, NBT_TANK_SIDE_IN, SBIT_L|SBIT_U, NBT_TANK_SIDE_AUTO_IN, SIDE_TOP, NBT_TANK_SIDE_OUT, SBIT_D|SBIT_R, NBT_TANK_SIDE_AUTO_OUT, SIDE_BOTTOM, NBT_ENERGY_ACCEPTED_SIDES, SBIT_B), "EXE", "FMF", "SXS", 'M', OP.casingMachine.dat(aMat), 'E', IL.Processor_Crystal_Emerald, 'S', IL.Processor_Crystal_Sapphire, 'X', IL.EMITTERS[2], 'F', IL.FIELD_GENERATORS[2]);
		aMat = MT.Osmiridium;           aRegistry.add("Matter Replicator (T3)"                              , "Basic Machines"                      , 20433, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,  16.0F, NBT_RESISTANCE,  16.0F, NBT_INPUT,  512, NBT_TEXTURE, "replicator", NBT_ENERGY_ACCEPTED, TD.Energy.QU, NBT_RECIPEMAP, RM.Replicator, NBT_CHEAP_OVERCLOCKING, T, NBT_NO_CONSTANT_POWER, T, NBT_EFFICIENCY,  7500, NBT_INV_SIDE_IN, SBIT_L|SBIT_U, NBT_INV_SIDE_AUTO_IN, SIDE_LEFT, NBT_INV_SIDE_OUT, SBIT_D|SBIT_R, NBT_INV_SIDE_AUTO_OUT, SIDE_RIGHT, NBT_TANK_SIDE_IN, SBIT_L|SBIT_U, NBT_TANK_SIDE_AUTO_IN, SIDE_TOP, NBT_TANK_SIDE_OUT, SBIT_D|SBIT_R, NBT_TANK_SIDE_AUTO_OUT, SIDE_BOTTOM, NBT_ENERGY_ACCEPTED_SIDES, SBIT_B), "EXE", "FMF", "SXS", 'M', OP.casingMachine.dat(aMat), 'E', IL.Processor_Crystal_Emerald, 'S', IL.Processor_Crystal_Sapphire, 'X', IL.EMITTERS[3], 'F', IL.FIELD_GENERATORS[3]);
		aMat = MT.Osmiridium;           aRegistry.add("Matter Replicator (T4)"                              , "Basic Machines"                      , 20434, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,  16.0F, NBT_RESISTANCE,  16.0F, NBT_INPUT, 2048, NBT_TEXTURE, "replicator", NBT_ENERGY_ACCEPTED, TD.Energy.QU, NBT_RECIPEMAP, RM.Replicator, NBT_CHEAP_OVERCLOCKING, T, NBT_NO_CONSTANT_POWER, T, NBT_EFFICIENCY,  8750, NBT_INV_SIDE_IN, SBIT_L|SBIT_U, NBT_INV_SIDE_AUTO_IN, SIDE_LEFT, NBT_INV_SIDE_OUT, SBIT_D|SBIT_R, NBT_INV_SIDE_AUTO_OUT, SIDE_RIGHT, NBT_TANK_SIDE_IN, SBIT_L|SBIT_U, NBT_TANK_SIDE_AUTO_IN, SIDE_TOP, NBT_TANK_SIDE_OUT, SBIT_D|SBIT_R, NBT_TANK_SIDE_AUTO_OUT, SIDE_BOTTOM, NBT_ENERGY_ACCEPTED_SIDES, SBIT_B), "EXE", "FMF", "SXS", 'M', OP.casingMachine.dat(aMat), 'E', IL.Processor_Crystal_Emerald, 'S', IL.Processor_Crystal_Sapphire, 'X', IL.EMITTERS[4], 'F', IL.FIELD_GENERATORS[4]);
		aMat = MT.Osmiridium;           aRegistry.add("Matter Replicator (T5)"                              , "Basic Machines"                      , 20435, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,  16.0F, NBT_RESISTANCE,  16.0F, NBT_INPUT, 8192, NBT_TEXTURE, "replicator", NBT_ENERGY_ACCEPTED, TD.Energy.QU, NBT_RECIPEMAP, RM.Replicator, NBT_CHEAP_OVERCLOCKING, T, NBT_NO_CONSTANT_POWER, T, NBT_EFFICIENCY, 10000, NBT_INV_SIDE_IN, SBIT_L|SBIT_U, NBT_INV_SIDE_AUTO_IN, SIDE_LEFT, NBT_INV_SIDE_OUT, SBIT_D|SBIT_R, NBT_INV_SIDE_AUTO_OUT, SIDE_RIGHT, NBT_TANK_SIDE_IN, SBIT_L|SBIT_U, NBT_TANK_SIDE_AUTO_IN, SIDE_TOP, NBT_TANK_SIDE_OUT, SBIT_D|SBIT_R, NBT_TANK_SIDE_AUTO_OUT, SIDE_BOTTOM, NBT_ENERGY_ACCEPTED_SIDES, SBIT_B), "EXE", "FMF", "SXS", 'M', OP.casingMachine.dat(aMat), 'E', IL.Processor_Crystal_Emerald, 'S', IL.Processor_Crystal_Sapphire, 'X', IL.EMITTERS[5], 'F', IL.FIELD_GENERATORS[5]);
		
		aClass = MultiTileEntityBasicMachine.class;
		aMat = MT.DATA.Electric_T[1];   aRegistry.add("Nanoscale Fabricator ("                    +VN[1]+")", "Basic Machines"                      , 20441, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT,   32, NBT_TEXTURE, "nanofab", NBT_ENERGY_ACCEPTED, TD.Energy.EU, NBT_RECIPEMAP, RM.Nanofab, NBT_INV_SIDE_IN, SBIT_L|SBIT_U, NBT_INV_SIDE_AUTO_IN, SIDE_LEFT, NBT_INV_SIDE_OUT, SBIT_D|SBIT_R, NBT_INV_SIDE_AUTO_OUT, SIDE_RIGHT, NBT_TANK_SIDE_IN, SBIT_L|SBIT_U, NBT_TANK_SIDE_AUTO_IN, SIDE_TOP, NBT_TANK_SIDE_OUT, SBIT_D|SBIT_R, NBT_TANK_SIDE_AUTO_OUT, SIDE_BOTTOM, NBT_ENERGY_ACCEPTED_SIDES, SBIT_B), "KAX", "ZMY", "CSC", 'M', OP.casingMachine.dat(aMat), 'C', OD_CIRCUITS[6], 'A', IL.Comp_Laser_Gas_Ar, 'K', IL.Comp_Laser_Gas_Kr, 'X', IL.Comp_Laser_Gas_Xe, 'S', IL.Processor_Crystal_Sapphire, 'Y', IL.EMITTERS[1], 'Z', IL.SENSORS[1]);
		aMat = MT.DATA.Electric_T[2];   aRegistry.add("Nanoscale Fabricator ("                    +VN[2]+")", "Basic Machines"                      , 20442, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT,  128, NBT_TEXTURE, "nanofab", NBT_ENERGY_ACCEPTED, TD.Energy.EU, NBT_RECIPEMAP, RM.Nanofab, NBT_INV_SIDE_IN, SBIT_L|SBIT_U, NBT_INV_SIDE_AUTO_IN, SIDE_LEFT, NBT_INV_SIDE_OUT, SBIT_D|SBIT_R, NBT_INV_SIDE_AUTO_OUT, SIDE_RIGHT, NBT_TANK_SIDE_IN, SBIT_L|SBIT_U, NBT_TANK_SIDE_AUTO_IN, SIDE_TOP, NBT_TANK_SIDE_OUT, SBIT_D|SBIT_R, NBT_TANK_SIDE_AUTO_OUT, SIDE_BOTTOM, NBT_ENERGY_ACCEPTED_SIDES, SBIT_B), "KAX", "ZMY", "CSC", 'M', OP.casingMachine.dat(aMat), 'C', OD_CIRCUITS[6], 'A', IL.Comp_Laser_Gas_Ar, 'K', IL.Comp_Laser_Gas_Kr, 'X', IL.Comp_Laser_Gas_Xe, 'S', IL.Processor_Crystal_Sapphire, 'Y', IL.EMITTERS[2], 'Z', IL.SENSORS[2]);
		aMat = MT.DATA.Electric_T[3];   aRegistry.add("Nanoscale Fabricator ("                    +VN[3]+")", "Basic Machines"                      , 20443, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT,  512, NBT_TEXTURE, "nanofab", NBT_ENERGY_ACCEPTED, TD.Energy.EU, NBT_RECIPEMAP, RM.Nanofab, NBT_INV_SIDE_IN, SBIT_L|SBIT_U, NBT_INV_SIDE_AUTO_IN, SIDE_LEFT, NBT_INV_SIDE_OUT, SBIT_D|SBIT_R, NBT_INV_SIDE_AUTO_OUT, SIDE_RIGHT, NBT_TANK_SIDE_IN, SBIT_L|SBIT_U, NBT_TANK_SIDE_AUTO_IN, SIDE_TOP, NBT_TANK_SIDE_OUT, SBIT_D|SBIT_R, NBT_TANK_SIDE_AUTO_OUT, SIDE_BOTTOM, NBT_ENERGY_ACCEPTED_SIDES, SBIT_B), "KAX", "ZMY", "CSC", 'M', OP.casingMachine.dat(aMat), 'C', OD_CIRCUITS[6], 'A', IL.Comp_Laser_Gas_Ar, 'K', IL.Comp_Laser_Gas_Kr, 'X', IL.Comp_Laser_Gas_Xe, 'S', IL.Processor_Crystal_Sapphire, 'Y', IL.EMITTERS[3], 'Z', IL.SENSORS[3]);
		aMat = MT.DATA.Electric_T[4];   aRegistry.add("Nanoscale Fabricator ("                    +VN[4]+")", "Basic Machines"                      , 20444, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT, 2048, NBT_TEXTURE, "nanofab", NBT_ENERGY_ACCEPTED, TD.Energy.EU, NBT_RECIPEMAP, RM.Nanofab, NBT_INV_SIDE_IN, SBIT_L|SBIT_U, NBT_INV_SIDE_AUTO_IN, SIDE_LEFT, NBT_INV_SIDE_OUT, SBIT_D|SBIT_R, NBT_INV_SIDE_AUTO_OUT, SIDE_RIGHT, NBT_TANK_SIDE_IN, SBIT_L|SBIT_U, NBT_TANK_SIDE_AUTO_IN, SIDE_TOP, NBT_TANK_SIDE_OUT, SBIT_D|SBIT_R, NBT_TANK_SIDE_AUTO_OUT, SIDE_BOTTOM, NBT_ENERGY_ACCEPTED_SIDES, SBIT_B), "KAX", "ZMY", "CSC", 'M', OP.casingMachine.dat(aMat), 'C', OD_CIRCUITS[6], 'A', IL.Comp_Laser_Gas_Ar, 'K', IL.Comp_Laser_Gas_Kr, 'X', IL.Comp_Laser_Gas_Xe, 'S', IL.Processor_Crystal_Sapphire, 'Y', IL.EMITTERS[4], 'Z', IL.SENSORS[4]);
		aMat = MT.DATA.Electric_T[5];   aRegistry.add("Nanoscale Fabricator ("                    +VN[5]+")", "Basic Machines"                      , 20445, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT, 8192, NBT_TEXTURE, "nanofab", NBT_ENERGY_ACCEPTED, TD.Energy.EU, NBT_RECIPEMAP, RM.Nanofab, NBT_INV_SIDE_IN, SBIT_L|SBIT_U, NBT_INV_SIDE_AUTO_IN, SIDE_LEFT, NBT_INV_SIDE_OUT, SBIT_D|SBIT_R, NBT_INV_SIDE_AUTO_OUT, SIDE_RIGHT, NBT_TANK_SIDE_IN, SBIT_L|SBIT_U, NBT_TANK_SIDE_AUTO_IN, SIDE_TOP, NBT_TANK_SIDE_OUT, SBIT_D|SBIT_R, NBT_TANK_SIDE_AUTO_OUT, SIDE_BOTTOM, NBT_ENERGY_ACCEPTED_SIDES, SBIT_B), "KAX", "ZMY", "CSC", 'M', OP.casingMachine.dat(aMat), 'C', OD_CIRCUITS[6], 'A', IL.Comp_Laser_Gas_Ar, 'K', IL.Comp_Laser_Gas_Kr, 'X', IL.Comp_Laser_Gas_Xe, 'S', IL.Processor_Crystal_Sapphire, 'Y', IL.EMITTERS[5], 'Z', IL.SENSORS[5]);
		
		aClass = MultiTileEntityBasicMachine.class;
		aMat = MT.DATA.Heat_T[1];       aRegistry.add("Catalytic Cracker ("             +aMat.getLocal()+")", "Basic Machines"                      , 20481, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   6.0F, NBT_RESISTANCE,   6.0F, NBT_INPUT,   32, NBT_TEXTURE, "catalyticcracker", NBT_ENERGY_ACCEPTED, TD.Energy.HU, NBT_RECIPEMAP, RM.CatalyticCracking, NBT_INV_SIDE_IN, SBIT_U|SBIT_L, NBT_INV_SIDE_AUTO_IN, SIDE_TOP, NBT_INV_SIDE_OUT, SBIT_R|SBIT_B, NBT_INV_SIDE_AUTO_OUT, SIDE_BACK, NBT_TANK_SIDE_IN, SBIT_U|SBIT_L, NBT_TANK_SIDE_AUTO_IN, SIDE_LEFT, NBT_TANK_SIDE_OUT, SBIT_R|SBIT_B, NBT_TANK_SIDE_AUTO_OUT, SIDE_RIGHT, NBT_ENERGY_ACCEPTED_SIDES, SBIT_D), "IPI", "ZMZ", "ICI", 'M', OP.casingMachineDouble.dat(aMat), 'C', OP.plateDouble   .dat(ANY.Cu), 'I', OP.plateDouble   .dat(MT.Invar), 'P', OP.pipeQuadruple.dat(aMat), 'Z', OP.dust.dat(MT.OREMATS.Zeolite));
		aMat = MT.DATA.Heat_T[2];       aRegistry.add("Catalytic Cracker ("             +aMat.getLocal()+")", "Basic Machines"                      , 20482, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT,  128, NBT_TEXTURE, "catalyticcracker", NBT_ENERGY_ACCEPTED, TD.Energy.HU, NBT_RECIPEMAP, RM.CatalyticCracking, NBT_INV_SIDE_IN, SBIT_U|SBIT_L, NBT_INV_SIDE_AUTO_IN, SIDE_TOP, NBT_INV_SIDE_OUT, SBIT_R|SBIT_B, NBT_INV_SIDE_AUTO_OUT, SIDE_BACK, NBT_TANK_SIDE_IN, SBIT_U|SBIT_L, NBT_TANK_SIDE_AUTO_IN, SIDE_LEFT, NBT_TANK_SIDE_OUT, SBIT_R|SBIT_B, NBT_TANK_SIDE_AUTO_OUT, SIDE_RIGHT, NBT_ENERGY_ACCEPTED_SIDES, SBIT_D), "IPI", "ZMZ", "ICI", 'M', OP.casingMachineDouble.dat(aMat), 'C', OP.plateTriple   .dat(ANY.Cu), 'I', OP.plateTriple   .dat(MT.Invar), 'P', OP.pipeQuadruple.dat(aMat), 'Z', OP.dust.dat(MT.OREMATS.Zeolite));
		aMat = MT.DATA.Heat_T[3];       aRegistry.add("Catalytic Cracker ("             +aMat.getLocal()+")", "Basic Machines"                      , 20483, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   9.0F, NBT_RESISTANCE,   9.0F, NBT_INPUT,  512, NBT_TEXTURE, "catalyticcracker", NBT_ENERGY_ACCEPTED, TD.Energy.HU, NBT_RECIPEMAP, RM.CatalyticCracking, NBT_INV_SIDE_IN, SBIT_U|SBIT_L, NBT_INV_SIDE_AUTO_IN, SIDE_TOP, NBT_INV_SIDE_OUT, SBIT_R|SBIT_B, NBT_INV_SIDE_AUTO_OUT, SIDE_BACK, NBT_TANK_SIDE_IN, SBIT_U|SBIT_L, NBT_TANK_SIDE_AUTO_IN, SIDE_LEFT, NBT_TANK_SIDE_OUT, SBIT_R|SBIT_B, NBT_TANK_SIDE_AUTO_OUT, SIDE_RIGHT, NBT_ENERGY_ACCEPTED_SIDES, SBIT_D), "IPI", "ZMZ", "ICI", 'M', OP.casingMachineDouble.dat(aMat), 'C', OP.plateQuadruple.dat(ANY.Cu), 'I', OP.plateQuadruple.dat(MT.Invar), 'P', OP.pipeQuadruple.dat(aMat), 'Z', OP.dust.dat(MT.OREMATS.Zeolite));
		aMat = MT.DATA.Heat_T[4];       aRegistry.add("Catalytic Cracker ("             +aMat.getLocal()+")", "Basic Machines"                      , 20484, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,  12.5F, NBT_RESISTANCE,  12.5F, NBT_INPUT, 2048, NBT_TEXTURE, "catalyticcracker", NBT_ENERGY_ACCEPTED, TD.Energy.HU, NBT_RECIPEMAP, RM.CatalyticCracking, NBT_INV_SIDE_IN, SBIT_U|SBIT_L, NBT_INV_SIDE_AUTO_IN, SIDE_TOP, NBT_INV_SIDE_OUT, SBIT_R|SBIT_B, NBT_INV_SIDE_AUTO_OUT, SIDE_BACK, NBT_TANK_SIDE_IN, SBIT_U|SBIT_L, NBT_TANK_SIDE_AUTO_IN, SIDE_LEFT, NBT_TANK_SIDE_OUT, SBIT_R|SBIT_B, NBT_TANK_SIDE_AUTO_OUT, SIDE_RIGHT, NBT_ENERGY_ACCEPTED_SIDES, SBIT_D), "IPI", "ZMZ", "ICI", 'M', OP.casingMachineDouble.dat(aMat), 'C', OP.plateQuintuple.dat(ANY.Cu), 'I', OP.plateQuintuple.dat(MT.Invar), 'P', OP.pipeQuadruple.dat(aMat), 'Z', OP.dust.dat(MT.OREMATS.Zeolite));
		
		aClass = MultiTileEntityBasicMachine.class;
		aMat = MT.DATA.Heat_T[1];       aRegistry.add("Steam Cracker ("                 +aMat.getLocal()+")", "Basic Machines"                      , 20491, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   6.0F, NBT_RESISTANCE,   6.0F, NBT_INPUT,   32, NBT_TEXTURE, "steamcracker", NBT_ENERGY_ACCEPTED, TD.Energy.HU, NBT_RECIPEMAP, RM.SteamCracking, NBT_INV_SIDE_IN, SBIT_U|SBIT_L, NBT_INV_SIDE_AUTO_IN, SIDE_TOP, NBT_INV_SIDE_OUT, SBIT_R|SBIT_B, NBT_INV_SIDE_AUTO_OUT, SIDE_BACK, NBT_TANK_SIDE_IN, SBIT_U|SBIT_L, NBT_TANK_SIDE_AUTO_IN, SIDE_LEFT, NBT_TANK_SIDE_OUT, SBIT_R|SBIT_B, NBT_TANK_SIDE_AUTO_OUT, SIDE_RIGHT, NBT_ENERGY_ACCEPTED_SIDES, SBIT_D), "IwI", "PMP", "ICI", 'M', OP.casingMachineDouble.dat(aMat), 'C', OP.plateDouble   .dat(ANY.Cu), 'I', OP.plateDouble   .dat(MT.Invar), 'P', OP.pipeMedium.dat(aMat));
		aMat = MT.DATA.Heat_T[2];       aRegistry.add("Steam Cracker ("                 +aMat.getLocal()+")", "Basic Machines"                      , 20492, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT,  128, NBT_TEXTURE, "steamcracker", NBT_ENERGY_ACCEPTED, TD.Energy.HU, NBT_RECIPEMAP, RM.SteamCracking, NBT_INV_SIDE_IN, SBIT_U|SBIT_L, NBT_INV_SIDE_AUTO_IN, SIDE_TOP, NBT_INV_SIDE_OUT, SBIT_R|SBIT_B, NBT_INV_SIDE_AUTO_OUT, SIDE_BACK, NBT_TANK_SIDE_IN, SBIT_U|SBIT_L, NBT_TANK_SIDE_AUTO_IN, SIDE_LEFT, NBT_TANK_SIDE_OUT, SBIT_R|SBIT_B, NBT_TANK_SIDE_AUTO_OUT, SIDE_RIGHT, NBT_ENERGY_ACCEPTED_SIDES, SBIT_D), "IwI", "PMP", "ICI", 'M', OP.casingMachineDouble.dat(aMat), 'C', OP.plateTriple   .dat(ANY.Cu), 'I', OP.plateTriple   .dat(MT.Invar), 'P', OP.pipeMedium.dat(aMat));
		aMat = MT.DATA.Heat_T[3];       aRegistry.add("Steam Cracker ("                 +aMat.getLocal()+")", "Basic Machines"                      , 20493, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   9.0F, NBT_RESISTANCE,   9.0F, NBT_INPUT,  512, NBT_TEXTURE, "steamcracker", NBT_ENERGY_ACCEPTED, TD.Energy.HU, NBT_RECIPEMAP, RM.SteamCracking, NBT_INV_SIDE_IN, SBIT_U|SBIT_L, NBT_INV_SIDE_AUTO_IN, SIDE_TOP, NBT_INV_SIDE_OUT, SBIT_R|SBIT_B, NBT_INV_SIDE_AUTO_OUT, SIDE_BACK, NBT_TANK_SIDE_IN, SBIT_U|SBIT_L, NBT_TANK_SIDE_AUTO_IN, SIDE_LEFT, NBT_TANK_SIDE_OUT, SBIT_R|SBIT_B, NBT_TANK_SIDE_AUTO_OUT, SIDE_RIGHT, NBT_ENERGY_ACCEPTED_SIDES, SBIT_D), "IwI", "PMP", "ICI", 'M', OP.casingMachineDouble.dat(aMat), 'C', OP.plateQuadruple.dat(ANY.Cu), 'I', OP.plateQuadruple.dat(MT.Invar), 'P', OP.pipeMedium.dat(aMat));
		aMat = MT.DATA.Heat_T[4];       aRegistry.add("Steam Cracker ("                 +aMat.getLocal()+")", "Basic Machines"                      , 20494, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,  12.5F, NBT_RESISTANCE,  12.5F, NBT_INPUT, 2048, NBT_TEXTURE, "steamcracker", NBT_ENERGY_ACCEPTED, TD.Energy.HU, NBT_RECIPEMAP, RM.SteamCracking, NBT_INV_SIDE_IN, SBIT_U|SBIT_L, NBT_INV_SIDE_AUTO_IN, SIDE_TOP, NBT_INV_SIDE_OUT, SBIT_R|SBIT_B, NBT_INV_SIDE_AUTO_OUT, SIDE_BACK, NBT_TANK_SIDE_IN, SBIT_U|SBIT_L, NBT_TANK_SIDE_AUTO_IN, SIDE_LEFT, NBT_TANK_SIDE_OUT, SBIT_R|SBIT_B, NBT_TANK_SIDE_AUTO_OUT, SIDE_RIGHT, NBT_ENERGY_ACCEPTED_SIDES, SBIT_D), "IwI", "PMP", "ICI", 'M', OP.casingMachineDouble.dat(aMat), 'C', OP.plateQuintuple.dat(ANY.Cu), 'I', OP.plateQuintuple.dat(MT.Invar), 'P', OP.pipeMedium.dat(aMat));
		
		aClass = MultiTileEntityBasicMachineElectric.class;
		aMat = MT.DATA.Electric_T[1];   aRegistry.add("Lightning Processor ("                     +VN[1]+")", "Basic Machines"                      , 20501, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT,   32, NBT_TEXTURE, "lightning", NBT_ENERGY_ACCEPTED, TD.Energy.EU, NBT_RECIPEMAP, RM.Lightning, NBT_INV_SIDE_IN, SBIT_U|SBIT_L, NBT_INV_SIDE_AUTO_IN, SIDE_LEFT, NBT_INV_SIDE_OUT, SBIT_R|SBIT_D, NBT_INV_SIDE_AUTO_OUT, SIDE_RIGHT, NBT_TANK_SIDE_IN, SBIT_U|SBIT_L, NBT_TANK_SIDE_AUTO_IN, SIDE_TOP, NBT_TANK_SIDE_OUT, SBIT_R|SBIT_D, NBT_TANK_SIDE_AUTO_OUT, SIDE_BOTTOM, NBT_ENERGY_ACCEPTED_SIDES, SBIT_B, NBT_USE_OUTPUT_TANK, T), "XxX", "WwW", "XMX", 'M', OP.casingMachine.dat(aMat), 'W', MT.DATA.WIRES_04[1], 'X', OP.wireGt01.dat(ANY.Iron));
		aMat = MT.DATA.Electric_T[2];   aRegistry.add("Lightning Processor ("                     +VN[2]+")", "Basic Machines"                      , 20502, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT,  128, NBT_TEXTURE, "lightning", NBT_ENERGY_ACCEPTED, TD.Energy.EU, NBT_RECIPEMAP, RM.Lightning, NBT_INV_SIDE_IN, SBIT_U|SBIT_L, NBT_INV_SIDE_AUTO_IN, SIDE_LEFT, NBT_INV_SIDE_OUT, SBIT_R|SBIT_D, NBT_INV_SIDE_AUTO_OUT, SIDE_RIGHT, NBT_TANK_SIDE_IN, SBIT_U|SBIT_L, NBT_TANK_SIDE_AUTO_IN, SIDE_TOP, NBT_TANK_SIDE_OUT, SBIT_R|SBIT_D, NBT_TANK_SIDE_AUTO_OUT, SIDE_BOTTOM, NBT_ENERGY_ACCEPTED_SIDES, SBIT_B, NBT_USE_OUTPUT_TANK, T), "XxX", "WwW", "XMX", 'M', OP.casingMachine.dat(aMat), 'W', MT.DATA.WIRES_04[2], 'X', OP.wireGt02.dat(ANY.Iron));
		aMat = MT.DATA.Electric_T[3];   aRegistry.add("Lightning Processor ("                     +VN[3]+")", "Basic Machines"                      , 20503, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT,  512, NBT_TEXTURE, "lightning", NBT_ENERGY_ACCEPTED, TD.Energy.EU, NBT_RECIPEMAP, RM.Lightning, NBT_INV_SIDE_IN, SBIT_U|SBIT_L, NBT_INV_SIDE_AUTO_IN, SIDE_LEFT, NBT_INV_SIDE_OUT, SBIT_R|SBIT_D, NBT_INV_SIDE_AUTO_OUT, SIDE_RIGHT, NBT_TANK_SIDE_IN, SBIT_U|SBIT_L, NBT_TANK_SIDE_AUTO_IN, SIDE_TOP, NBT_TANK_SIDE_OUT, SBIT_R|SBIT_D, NBT_TANK_SIDE_AUTO_OUT, SIDE_BOTTOM, NBT_ENERGY_ACCEPTED_SIDES, SBIT_B, NBT_USE_OUTPUT_TANK, T), "XxX", "WwW", "XMX", 'M', OP.casingMachine.dat(aMat), 'W', MT.DATA.WIRES_04[3], 'X', OP.wireGt04.dat(ANY.Iron));
		aMat = MT.DATA.Electric_T[4];   aRegistry.add("Lightning Processor ("                     +VN[4]+")", "Basic Machines"                      , 20504, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT, 2048, NBT_TEXTURE, "lightning", NBT_ENERGY_ACCEPTED, TD.Energy.EU, NBT_RECIPEMAP, RM.Lightning, NBT_INV_SIDE_IN, SBIT_U|SBIT_L, NBT_INV_SIDE_AUTO_IN, SIDE_LEFT, NBT_INV_SIDE_OUT, SBIT_R|SBIT_D, NBT_INV_SIDE_AUTO_OUT, SIDE_RIGHT, NBT_TANK_SIDE_IN, SBIT_U|SBIT_L, NBT_TANK_SIDE_AUTO_IN, SIDE_TOP, NBT_TANK_SIDE_OUT, SBIT_R|SBIT_D, NBT_TANK_SIDE_AUTO_OUT, SIDE_BOTTOM, NBT_ENERGY_ACCEPTED_SIDES, SBIT_B, NBT_USE_OUTPUT_TANK, T), "XxX", "WwW", "XMX", 'M', OP.casingMachine.dat(aMat), 'W', MT.DATA.WIRES_04[4], 'X', OP.wireGt08.dat(ANY.Iron));
		aMat = MT.DATA.Electric_T[5];   aRegistry.add("Lightning Processor ("                     +VN[5]+")", "Basic Machines"                      , 20505, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT, 8192, NBT_TEXTURE, "lightning", NBT_ENERGY_ACCEPTED, TD.Energy.EU, NBT_RECIPEMAP, RM.Lightning, NBT_INV_SIDE_IN, SBIT_U|SBIT_L, NBT_INV_SIDE_AUTO_IN, SIDE_LEFT, NBT_INV_SIDE_OUT, SBIT_R|SBIT_D, NBT_INV_SIDE_AUTO_OUT, SIDE_RIGHT, NBT_TANK_SIDE_IN, SBIT_U|SBIT_L, NBT_TANK_SIDE_AUTO_IN, SIDE_TOP, NBT_TANK_SIDE_OUT, SBIT_R|SBIT_D, NBT_TANK_SIDE_AUTO_OUT, SIDE_BOTTOM, NBT_ENERGY_ACCEPTED_SIDES, SBIT_B, NBT_USE_OUTPUT_TANK, T), "XxX", "WwW", "XMX", 'M', OP.casingMachine.dat(aMat), 'W', MT.DATA.WIRES_04[5], 'X', OP.wireGt16.dat(ANY.Iron));
		
		aClass = MultiTileEntityBasicMachine.class;
		aMat = MT.DATA.Kinetic_T[1];    aRegistry.add("Sanding Machine ("               +aMat.getLocal()+")", "Basic Machines"                      , 20511, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   7.0F, NBT_RESISTANCE,   7.0F, NBT_INPUT,   32, NBT_TEXTURE, "sander", NBT_ENERGY_ACCEPTED, TD.Energy.RU, NBT_RECIPEMAP, RM.Sharpening, NBT_INV_SIDE_IN, SBIT_L, NBT_INV_SIDE_AUTO_IN, SIDE_LEFT, NBT_INV_SIDE_OUT, SBIT_R, NBT_INV_SIDE_AUTO_OUT, SIDE_RIGHT, NBT_ENERGY_ACCEPTED_SIDES, SBIT_U), "SGS", "XXX", "wMh", 'M', OP.casingMachineDouble.dat(aMat), 'S', OP.gearGtSmall.dat(aMat), 'G', OP.gearGt.dat(aMat), 'X', OD.sandstone);
		aMat = MT.DATA.Kinetic_T[2];    aRegistry.add("Sanding Machine ("               +aMat.getLocal()+")", "Basic Machines"                      , 20512, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   6.0F, NBT_RESISTANCE,   6.0F, NBT_INPUT,  128, NBT_TEXTURE, "sander", NBT_ENERGY_ACCEPTED, TD.Energy.RU, NBT_RECIPEMAP, RM.Sharpening, NBT_INV_SIDE_IN, SBIT_L, NBT_INV_SIDE_AUTO_IN, SIDE_LEFT, NBT_INV_SIDE_OUT, SBIT_R, NBT_INV_SIDE_AUTO_OUT, SIDE_RIGHT, NBT_ENERGY_ACCEPTED_SIDES, SBIT_U), "SGS", "XXX", "wMh", 'M', OP.casingMachineDouble.dat(aMat), 'S', OP.gearGtSmall.dat(aMat), 'G', OP.gearGt.dat(aMat), 'X', OD.sandstone);
		aMat = MT.DATA.Kinetic_T[3];    aRegistry.add("Sanding Machine ("               +aMat.getLocal()+")", "Basic Machines"                      , 20513, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   9.0F, NBT_RESISTANCE,   9.0F, NBT_INPUT,  512, NBT_TEXTURE, "sander", NBT_ENERGY_ACCEPTED, TD.Energy.RU, NBT_RECIPEMAP, RM.Sharpening, NBT_INV_SIDE_IN, SBIT_L, NBT_INV_SIDE_AUTO_IN, SIDE_LEFT, NBT_INV_SIDE_OUT, SBIT_R, NBT_INV_SIDE_AUTO_OUT, SIDE_RIGHT, NBT_ENERGY_ACCEPTED_SIDES, SBIT_U), "SGS", "XXX", "wMh", 'M', OP.casingMachineDouble.dat(aMat), 'S', OP.gearGtSmall.dat(aMat), 'G', OP.gearGt.dat(aMat), 'X', OD.sandstone);
		aMat = MT.DATA.Kinetic_T[4];    aRegistry.add("Sanding Machine ("               +aMat.getLocal()+")", "Basic Machines"                      , 20514, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,  12.5F, NBT_RESISTANCE,  12.5F, NBT_INPUT, 2048, NBT_TEXTURE, "sander", NBT_ENERGY_ACCEPTED, TD.Energy.RU, NBT_RECIPEMAP, RM.Sharpening, NBT_INV_SIDE_IN, SBIT_L, NBT_INV_SIDE_AUTO_IN, SIDE_LEFT, NBT_INV_SIDE_OUT, SBIT_R, NBT_INV_SIDE_AUTO_OUT, SIDE_RIGHT, NBT_ENERGY_ACCEPTED_SIDES, SBIT_U), "SGS", "XXX", "wMh", 'M', OP.casingMachineDouble.dat(aMat), 'S', OP.gearGtSmall.dat(aMat), 'G', OP.gearGt.dat(aMat), 'X', OD.sandstone);
		
		aClass = MultiTileEntityBasicMachine.class;
		aMat = MT.DATA.Kinetic_T[1];    aRegistry.add("Burner Mixer ("                  +aMat.getLocal()+")", "Basic Machines"                      , 20521, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   7.0F, NBT_RESISTANCE,   7.0F, NBT_INPUT,   32, NBT_TEXTURE, "burnmixer", NBT_ENERGY_ACCEPTED, TD.Energy.RU, NBT_RECIPEMAP, RM.BurnMixer, NBT_INV_SIDE_IN, SBIT_L|SBIT_U, NBT_INV_SIDE_AUTO_IN, SIDE_LEFT, NBT_INV_SIDE_OUT, SBIT_R|SBIT_B, NBT_INV_SIDE_AUTO_OUT, SIDE_RIGHT, NBT_TANK_SIDE_IN, SBIT_L|SBIT_U, NBT_TANK_SIDE_AUTO_IN, SIDE_TOP, NBT_TANK_SIDE_OUT, SBIT_R|SBIT_B, NBT_TANK_SIDE_AUTO_OUT, SIDE_BACK, NBT_ENERGY_ACCEPTED_SIDES, SBIT_D, NBT_NEEDS_IGNITION, T, NBT_PARALLEL, 4, NBT_PARALLEL_DURATION, T), "PMP", "PRP", "hSw", 'M', OP.casingMachine.dat(aMat), 'S', OP.stick.dat(aMat), 'R', OP.rotor.dat(MT.Invar), 'P', OP.plate.dat(MT.Invar));
		aMat = MT.DATA.Kinetic_T[2];    aRegistry.add("Burner Mixer ("                  +aMat.getLocal()+")", "Basic Machines"                      , 20522, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   6.0F, NBT_RESISTANCE,   6.0F, NBT_INPUT,  128, NBT_TEXTURE, "burnmixer", NBT_ENERGY_ACCEPTED, TD.Energy.RU, NBT_RECIPEMAP, RM.BurnMixer, NBT_INV_SIDE_IN, SBIT_L|SBIT_U, NBT_INV_SIDE_AUTO_IN, SIDE_LEFT, NBT_INV_SIDE_OUT, SBIT_R|SBIT_B, NBT_INV_SIDE_AUTO_OUT, SIDE_RIGHT, NBT_TANK_SIDE_IN, SBIT_L|SBIT_U, NBT_TANK_SIDE_AUTO_IN, SIDE_TOP, NBT_TANK_SIDE_OUT, SBIT_R|SBIT_B, NBT_TANK_SIDE_AUTO_OUT, SIDE_BACK, NBT_ENERGY_ACCEPTED_SIDES, SBIT_D, NBT_NEEDS_IGNITION, T, NBT_PARALLEL, 8, NBT_PARALLEL_DURATION, T), "PMP", "PRP", "hSw", 'M', OP.casingMachine.dat(aMat), 'S', OP.stick.dat(aMat), 'R', OP.rotor.dat(MT.Invar), 'P', OP.plateDouble.dat(MT.Invar));
		aMat = MT.DATA.Kinetic_T[3];    aRegistry.add("Burner Mixer ("                  +aMat.getLocal()+")", "Basic Machines"                      , 20523, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   9.0F, NBT_RESISTANCE,   9.0F, NBT_INPUT,  512, NBT_TEXTURE, "burnmixer", NBT_ENERGY_ACCEPTED, TD.Energy.RU, NBT_RECIPEMAP, RM.BurnMixer, NBT_INV_SIDE_IN, SBIT_L|SBIT_U, NBT_INV_SIDE_AUTO_IN, SIDE_LEFT, NBT_INV_SIDE_OUT, SBIT_R|SBIT_B, NBT_INV_SIDE_AUTO_OUT, SIDE_RIGHT, NBT_TANK_SIDE_IN, SBIT_L|SBIT_U, NBT_TANK_SIDE_AUTO_IN, SIDE_TOP, NBT_TANK_SIDE_OUT, SBIT_R|SBIT_B, NBT_TANK_SIDE_AUTO_OUT, SIDE_BACK, NBT_ENERGY_ACCEPTED_SIDES, SBIT_D, NBT_NEEDS_IGNITION, T, NBT_PARALLEL,16, NBT_PARALLEL_DURATION, T), "PMP", "PRP", "hSw", 'M', OP.casingMachine.dat(aMat), 'S', OP.stick.dat(aMat), 'R', OP.rotor.dat(MT.Invar), 'P', OP.plateTriple.dat(MT.Invar));
		aMat = MT.DATA.Kinetic_T[4];    aRegistry.add("Burner Mixer ("                  +aMat.getLocal()+")", "Basic Machines"                      , 20524, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,  12.5F, NBT_RESISTANCE,  12.5F, NBT_INPUT, 2048, NBT_TEXTURE, "burnmixer", NBT_ENERGY_ACCEPTED, TD.Energy.RU, NBT_RECIPEMAP, RM.BurnMixer, NBT_INV_SIDE_IN, SBIT_L|SBIT_U, NBT_INV_SIDE_AUTO_IN, SIDE_LEFT, NBT_INV_SIDE_OUT, SBIT_R|SBIT_B, NBT_INV_SIDE_AUTO_OUT, SIDE_RIGHT, NBT_TANK_SIDE_IN, SBIT_L|SBIT_U, NBT_TANK_SIDE_AUTO_IN, SIDE_TOP, NBT_TANK_SIDE_OUT, SBIT_R|SBIT_B, NBT_TANK_SIDE_AUTO_OUT, SIDE_BACK, NBT_ENERGY_ACCEPTED_SIDES, SBIT_D, NBT_NEEDS_IGNITION, T, NBT_PARALLEL,32, NBT_PARALLEL_DURATION, T), "PMP", "PRP", "hSw", 'M', OP.casingMachine.dat(aMat), 'S', OP.stick.dat(aMat), 'R', OP.rotor.dat(MT.Invar), 'P', OP.plateQuadruple.dat(MT.Invar));
		
		aClass = MultiTileEntityBasicMachineElectric.class;
		aMat = MT.DATA.Electric_T[1];   aRegistry.add("Plantalyzer ("                             +VN[1]+")", "Basic Machines"                      , 20531, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT,   32, NBT_TEXTURE, "plantalyzer", NBT_ENERGY_ACCEPTED, TD.Energy.EU, NBT_RECIPEMAP, RM.Plantalyzer, NBT_INV_SIDE_IN, SBIT_U|SBIT_L, NBT_INV_SIDE_AUTO_IN, SIDE_LEFT, NBT_INV_SIDE_OUT, SBIT_R|SBIT_D, NBT_INV_SIDE_AUTO_OUT, SIDE_RIGHT, NBT_TANK_SIDE_IN, SBIT_U|SBIT_D, NBT_TANK_SIDE_AUTO_IN, SIDE_TOP, NBT_ENERGY_ACCEPTED_SIDES, SBIT_B, NBT_PARALLEL, 64), "WXW", "ZMP", "CYC", 'M', OP.casingMachine.dat(aMat), 'C', OD_CIRCUITS[1], 'W', MT.DATA.CABLES_01[1], 'P', IL.Processor_Crystal_Diamond, 'X', IL.EMITTERS[1], 'Y', IL.SENSORS[1], 'Z', OP.treeSapling);
		aMat = MT.DATA.Electric_T[2];   aRegistry.add("Plantalyzer ("                             +VN[2]+")", "Basic Machines"                      , 20532, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT,  128, NBT_TEXTURE, "plantalyzer", NBT_ENERGY_ACCEPTED, TD.Energy.EU, NBT_RECIPEMAP, RM.Plantalyzer, NBT_INV_SIDE_IN, SBIT_U|SBIT_L, NBT_INV_SIDE_AUTO_IN, SIDE_LEFT, NBT_INV_SIDE_OUT, SBIT_R|SBIT_D, NBT_INV_SIDE_AUTO_OUT, SIDE_RIGHT, NBT_TANK_SIDE_IN, SBIT_U|SBIT_D, NBT_TANK_SIDE_AUTO_IN, SIDE_TOP, NBT_ENERGY_ACCEPTED_SIDES, SBIT_B, NBT_PARALLEL, 64), "WXW", "ZMP", "CYC", 'M', OP.casingMachine.dat(aMat), 'C', OD_CIRCUITS[2], 'W', MT.DATA.CABLES_01[2], 'P', IL.Processor_Crystal_Diamond, 'X', IL.EMITTERS[2], 'Y', IL.SENSORS[2], 'Z', OP.treeSapling);
		aMat = MT.DATA.Electric_T[3];   aRegistry.add("Plantalyzer ("                             +VN[3]+")", "Basic Machines"                      , 20533, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT,  512, NBT_TEXTURE, "plantalyzer", NBT_ENERGY_ACCEPTED, TD.Energy.EU, NBT_RECIPEMAP, RM.Plantalyzer, NBT_INV_SIDE_IN, SBIT_U|SBIT_L, NBT_INV_SIDE_AUTO_IN, SIDE_LEFT, NBT_INV_SIDE_OUT, SBIT_R|SBIT_D, NBT_INV_SIDE_AUTO_OUT, SIDE_RIGHT, NBT_TANK_SIDE_IN, SBIT_U|SBIT_D, NBT_TANK_SIDE_AUTO_IN, SIDE_TOP, NBT_ENERGY_ACCEPTED_SIDES, SBIT_B, NBT_PARALLEL, 64), "WXW", "ZMP", "CYC", 'M', OP.casingMachine.dat(aMat), 'C', OD_CIRCUITS[3], 'W', MT.DATA.CABLES_01[3], 'P', IL.Processor_Crystal_Diamond, 'X', IL.EMITTERS[3], 'Y', IL.SENSORS[3], 'Z', OP.treeSapling);
		aMat = MT.DATA.Electric_T[4];   aRegistry.add("Plantalyzer ("                             +VN[4]+")", "Basic Machines"                      , 20534, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT, 2048, NBT_TEXTURE, "plantalyzer", NBT_ENERGY_ACCEPTED, TD.Energy.EU, NBT_RECIPEMAP, RM.Plantalyzer, NBT_INV_SIDE_IN, SBIT_U|SBIT_L, NBT_INV_SIDE_AUTO_IN, SIDE_LEFT, NBT_INV_SIDE_OUT, SBIT_R|SBIT_D, NBT_INV_SIDE_AUTO_OUT, SIDE_RIGHT, NBT_TANK_SIDE_IN, SBIT_U|SBIT_D, NBT_TANK_SIDE_AUTO_IN, SIDE_TOP, NBT_ENERGY_ACCEPTED_SIDES, SBIT_B, NBT_PARALLEL, 64), "WXW", "ZMP", "CYC", 'M', OP.casingMachine.dat(aMat), 'C', OD_CIRCUITS[4], 'W', MT.DATA.CABLES_01[4], 'P', IL.Processor_Crystal_Diamond, 'X', IL.EMITTERS[4], 'Y', IL.SENSORS[4], 'Z', OP.treeSapling);
		aMat = MT.DATA.Electric_T[5];   aRegistry.add("Plantalyzer ("                             +VN[5]+")", "Basic Machines"                      , 20535, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT, 8192, NBT_TEXTURE, "plantalyzer", NBT_ENERGY_ACCEPTED, TD.Energy.EU, NBT_RECIPEMAP, RM.Plantalyzer, NBT_INV_SIDE_IN, SBIT_U|SBIT_L, NBT_INV_SIDE_AUTO_IN, SIDE_LEFT, NBT_INV_SIDE_OUT, SBIT_R|SBIT_D, NBT_INV_SIDE_AUTO_OUT, SIDE_RIGHT, NBT_TANK_SIDE_IN, SBIT_U|SBIT_D, NBT_TANK_SIDE_AUTO_IN, SIDE_TOP, NBT_ENERGY_ACCEPTED_SIDES, SBIT_B, NBT_PARALLEL, 64), "WXW", "ZMP", "CYC", 'M', OP.casingMachine.dat(aMat), 'C', OD_CIRCUITS[5], 'W', MT.DATA.CABLES_01[5], 'P', IL.Processor_Crystal_Diamond, 'X', IL.EMITTERS[5], 'Y', IL.SENSORS[5], 'Z', OP.treeSapling);
		
		aClass = MultiTileEntityBasicMachineElectric.class;
		aMat = MT.DATA.Electric_T[1];   aRegistry.add("Bumblelyzer ("                             +VN[1]+")", "Basic Machines"                      , 20541, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT,   32, NBT_TEXTURE, "bumblelyzer", NBT_ENERGY_ACCEPTED, TD.Energy.EU, NBT_RECIPEMAP, RM.Bumblelyzer, NBT_INV_SIDE_IN, SBIT_U|SBIT_L, NBT_INV_SIDE_AUTO_IN, SIDE_LEFT, NBT_INV_SIDE_OUT, SBIT_R|SBIT_D, NBT_INV_SIDE_AUTO_OUT, SIDE_RIGHT, NBT_TANK_SIDE_IN, SBIT_U|SBIT_D, NBT_TANK_SIDE_AUTO_IN, SIDE_TOP, NBT_ENERGY_ACCEPTED_SIDES, SBIT_B, NBT_PARALLEL, 64), "WXW", "ZMP", "CYC", 'M', OP.casingMachine.dat(aMat), 'C', OD_CIRCUITS[1], 'W', MT.DATA.CABLES_01[1], 'P', IL.Processor_Crystal_Diamond, 'X', IL.EMITTERS[1], 'Y', IL.SENSORS[1], 'Z', OD.container1000honey);
		aMat = MT.DATA.Electric_T[2];   aRegistry.add("Bumblelyzer ("                             +VN[2]+")", "Basic Machines"                      , 20542, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT,  128, NBT_TEXTURE, "bumblelyzer", NBT_ENERGY_ACCEPTED, TD.Energy.EU, NBT_RECIPEMAP, RM.Bumblelyzer, NBT_INV_SIDE_IN, SBIT_U|SBIT_L, NBT_INV_SIDE_AUTO_IN, SIDE_LEFT, NBT_INV_SIDE_OUT, SBIT_R|SBIT_D, NBT_INV_SIDE_AUTO_OUT, SIDE_RIGHT, NBT_TANK_SIDE_IN, SBIT_U|SBIT_D, NBT_TANK_SIDE_AUTO_IN, SIDE_TOP, NBT_ENERGY_ACCEPTED_SIDES, SBIT_B, NBT_PARALLEL, 64), "WXW", "ZMP", "CYC", 'M', OP.casingMachine.dat(aMat), 'C', OD_CIRCUITS[2], 'W', MT.DATA.CABLES_01[2], 'P', IL.Processor_Crystal_Diamond, 'X', IL.EMITTERS[2], 'Y', IL.SENSORS[2], 'Z', OD.container1000honey);
		aMat = MT.DATA.Electric_T[3];   aRegistry.add("Bumblelyzer ("                             +VN[3]+")", "Basic Machines"                      , 20543, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT,  512, NBT_TEXTURE, "bumblelyzer", NBT_ENERGY_ACCEPTED, TD.Energy.EU, NBT_RECIPEMAP, RM.Bumblelyzer, NBT_INV_SIDE_IN, SBIT_U|SBIT_L, NBT_INV_SIDE_AUTO_IN, SIDE_LEFT, NBT_INV_SIDE_OUT, SBIT_R|SBIT_D, NBT_INV_SIDE_AUTO_OUT, SIDE_RIGHT, NBT_TANK_SIDE_IN, SBIT_U|SBIT_D, NBT_TANK_SIDE_AUTO_IN, SIDE_TOP, NBT_ENERGY_ACCEPTED_SIDES, SBIT_B, NBT_PARALLEL, 64), "WXW", "ZMP", "CYC", 'M', OP.casingMachine.dat(aMat), 'C', OD_CIRCUITS[3], 'W', MT.DATA.CABLES_01[3], 'P', IL.Processor_Crystal_Diamond, 'X', IL.EMITTERS[3], 'Y', IL.SENSORS[3], 'Z', OD.container1000honey);
		aMat = MT.DATA.Electric_T[4];   aRegistry.add("Bumblelyzer ("                             +VN[4]+")", "Basic Machines"                      , 20544, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT, 2048, NBT_TEXTURE, "bumblelyzer", NBT_ENERGY_ACCEPTED, TD.Energy.EU, NBT_RECIPEMAP, RM.Bumblelyzer, NBT_INV_SIDE_IN, SBIT_U|SBIT_L, NBT_INV_SIDE_AUTO_IN, SIDE_LEFT, NBT_INV_SIDE_OUT, SBIT_R|SBIT_D, NBT_INV_SIDE_AUTO_OUT, SIDE_RIGHT, NBT_TANK_SIDE_IN, SBIT_U|SBIT_D, NBT_TANK_SIDE_AUTO_IN, SIDE_TOP, NBT_ENERGY_ACCEPTED_SIDES, SBIT_B, NBT_PARALLEL, 64), "WXW", "ZMP", "CYC", 'M', OP.casingMachine.dat(aMat), 'C', OD_CIRCUITS[4], 'W', MT.DATA.CABLES_01[4], 'P', IL.Processor_Crystal_Diamond, 'X', IL.EMITTERS[4], 'Y', IL.SENSORS[4], 'Z', OD.container1000honey);
		aMat = MT.DATA.Electric_T[5];   aRegistry.add("Bumblelyzer ("                             +VN[5]+")", "Basic Machines"                      , 20545, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT, 8192, NBT_TEXTURE, "bumblelyzer", NBT_ENERGY_ACCEPTED, TD.Energy.EU, NBT_RECIPEMAP, RM.Bumblelyzer, NBT_INV_SIDE_IN, SBIT_U|SBIT_L, NBT_INV_SIDE_AUTO_IN, SIDE_LEFT, NBT_INV_SIDE_OUT, SBIT_R|SBIT_D, NBT_INV_SIDE_AUTO_OUT, SIDE_RIGHT, NBT_TANK_SIDE_IN, SBIT_U|SBIT_D, NBT_TANK_SIDE_AUTO_IN, SIDE_TOP, NBT_ENERGY_ACCEPTED_SIDES, SBIT_B, NBT_PARALLEL, 64), "WXW", "ZMP", "CYC", 'M', OP.casingMachine.dat(aMat), 'C', OD_CIRCUITS[5], 'W', MT.DATA.CABLES_01[5], 'P', IL.Processor_Crystal_Diamond, 'X', IL.EMITTERS[5], 'Y', IL.SENSORS[5], 'Z', OD.container1000honey);
		
		aClass = MultiTileEntityBasicMachine.class;
		aMat = MT.DATA.Kinetic_T[1];    aRegistry.add("Pressure Washer ("               +aMat.getLocal()+")", "Basic Machines"                      , 20551, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   7.0F, NBT_RESISTANCE,   7.0F, NBT_INPUT,   32, NBT_TEXTURE, "debarker", NBT_ENERGY_ACCEPTED, TD.Energy.RU, NBT_RECIPEMAP, RM.PressureWasher, NBT_INV_SIDE_IN, SBIT_L, NBT_INV_SIDE_AUTO_IN, SIDE_LEFT, NBT_INV_SIDE_OUT, SBIT_R, NBT_INV_SIDE_AUTO_OUT, SIDE_RIGHT, NBT_TANK_SIDE_IN, SBIT_U|SBIT_D, NBT_TANK_SIDE_AUTO_IN, SIDE_TOP, NBT_ENERGY_ACCEPTED_SIDES, SBIT_B), "RPG", "wMG", 'M', OP.casingMachine.dat(aMat), 'G', OP.gearGtSmall.dat(aMat), 'R', OP.rotor.dat(MT.StainlessSteel), 'P', OP.pipeSmall    .dat(MT.StainlessSteel));
		aMat = MT.DATA.Kinetic_T[2];    aRegistry.add("Pressure Washer ("               +aMat.getLocal()+")", "Basic Machines"                      , 20552, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   6.0F, NBT_RESISTANCE,   6.0F, NBT_INPUT,  128, NBT_TEXTURE, "debarker", NBT_ENERGY_ACCEPTED, TD.Energy.RU, NBT_RECIPEMAP, RM.PressureWasher, NBT_INV_SIDE_IN, SBIT_L, NBT_INV_SIDE_AUTO_IN, SIDE_LEFT, NBT_INV_SIDE_OUT, SBIT_R, NBT_INV_SIDE_AUTO_OUT, SIDE_RIGHT, NBT_TANK_SIDE_IN, SBIT_U|SBIT_D, NBT_TANK_SIDE_AUTO_IN, SIDE_TOP, NBT_ENERGY_ACCEPTED_SIDES, SBIT_B), "RPG", "wMG", 'M', OP.casingMachine.dat(aMat), 'G', OP.gearGtSmall.dat(aMat), 'R', OP.rotor.dat(MT.StainlessSteel), 'P', OP.pipeMedium   .dat(MT.StainlessSteel));
		aMat = MT.DATA.Kinetic_T[3];    aRegistry.add("Pressure Washer ("               +aMat.getLocal()+")", "Basic Machines"                      , 20553, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   9.0F, NBT_RESISTANCE,   9.0F, NBT_INPUT,  512, NBT_TEXTURE, "debarker", NBT_ENERGY_ACCEPTED, TD.Energy.RU, NBT_RECIPEMAP, RM.PressureWasher, NBT_INV_SIDE_IN, SBIT_L, NBT_INV_SIDE_AUTO_IN, SIDE_LEFT, NBT_INV_SIDE_OUT, SBIT_R, NBT_INV_SIDE_AUTO_OUT, SIDE_RIGHT, NBT_TANK_SIDE_IN, SBIT_U|SBIT_D, NBT_TANK_SIDE_AUTO_IN, SIDE_TOP, NBT_ENERGY_ACCEPTED_SIDES, SBIT_B), "RPG", "wMG", 'M', OP.casingMachine.dat(aMat), 'G', OP.gearGtSmall.dat(aMat), 'R', OP.rotor.dat(MT.StainlessSteel), 'P', OP.pipeLarge    .dat(MT.StainlessSteel));
		aMat = MT.DATA.Kinetic_T[4];    aRegistry.add("Pressure Washer ("               +aMat.getLocal()+")", "Basic Machines"                      , 20554, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,  12.5F, NBT_RESISTANCE,  12.5F, NBT_INPUT, 2048, NBT_TEXTURE, "debarker", NBT_ENERGY_ACCEPTED, TD.Energy.RU, NBT_RECIPEMAP, RM.PressureWasher, NBT_INV_SIDE_IN, SBIT_L, NBT_INV_SIDE_AUTO_IN, SIDE_LEFT, NBT_INV_SIDE_OUT, SBIT_R, NBT_INV_SIDE_AUTO_OUT, SIDE_RIGHT, NBT_TANK_SIDE_IN, SBIT_U|SBIT_D, NBT_TANK_SIDE_AUTO_IN, SIDE_TOP, NBT_ENERGY_ACCEPTED_SIDES, SBIT_B), "RPG", "wMG", 'M', OP.casingMachine.dat(aMat), 'G', OP.gearGtSmall.dat(aMat), 'R', OP.rotor.dat(MT.StainlessSteel), 'P', OP.pipeHuge     .dat(MT.StainlessSteel));
		
		aClass = MultiTileEntityBasicMachine.class;
		aMat = MT.DATA.Electric_T[1];   aRegistry.add("Freezer (T1)"                                        , "Basic Machines"                      , 20561, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT,   32, NBT_TEXTURE, "freezer", NBT_ENERGY_ACCEPTED, TD.Energy.CU, NBT_RECIPEMAP, RM.Freezer, NBT_INV_SIDE_IN, SBIT_U|SBIT_L, NBT_INV_SIDE_AUTO_IN, SIDE_LEFT, NBT_INV_SIDE_OUT, SBIT_R|SBIT_D, NBT_INV_SIDE_AUTO_OUT, SIDE_RIGHT, NBT_TANK_SIDE_IN, SBIT_U|SBIT_L, NBT_TANK_SIDE_AUTO_IN, SIDE_TOP, NBT_TANK_SIDE_OUT, SBIT_R|SBIT_D, NBT_TANK_SIDE_AUTO_OUT, SIDE_BOTTOM, NBT_ENERGY_ACCEPTED_SIDES, SBIT_B), "hPw", "PMP", "PSP", 'M', OP.casingMachine.dat(aMat), 'S', OP.plate           .dat(MT.Si), 'P', OP.plate          .dat(MT.StainlessSteel));
		aMat = MT.DATA.Electric_T[2];   aRegistry.add("Freezer (T2)"                                        , "Basic Machines"                      , 20562, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT,  128, NBT_TEXTURE, "freezer", NBT_ENERGY_ACCEPTED, TD.Energy.CU, NBT_RECIPEMAP, RM.Freezer, NBT_INV_SIDE_IN, SBIT_U|SBIT_L, NBT_INV_SIDE_AUTO_IN, SIDE_LEFT, NBT_INV_SIDE_OUT, SBIT_R|SBIT_D, NBT_INV_SIDE_AUTO_OUT, SIDE_RIGHT, NBT_TANK_SIDE_IN, SBIT_U|SBIT_L, NBT_TANK_SIDE_AUTO_IN, SIDE_TOP, NBT_TANK_SIDE_OUT, SBIT_R|SBIT_D, NBT_TANK_SIDE_AUTO_OUT, SIDE_BOTTOM, NBT_ENERGY_ACCEPTED_SIDES, SBIT_B), "hPw", "PMP", "PSP", 'M', OP.casingMachine.dat(aMat), 'S', OP.plateDouble     .dat(MT.Si), 'P', OP.plateDouble    .dat(MT.StainlessSteel));
		aMat = MT.DATA.Electric_T[3];   aRegistry.add("Freezer (T3)"                                        , "Basic Machines"                      , 20563, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT,  512, NBT_TEXTURE, "freezer", NBT_ENERGY_ACCEPTED, TD.Energy.CU, NBT_RECIPEMAP, RM.Freezer, NBT_INV_SIDE_IN, SBIT_U|SBIT_L, NBT_INV_SIDE_AUTO_IN, SIDE_LEFT, NBT_INV_SIDE_OUT, SBIT_R|SBIT_D, NBT_INV_SIDE_AUTO_OUT, SIDE_RIGHT, NBT_TANK_SIDE_IN, SBIT_U|SBIT_L, NBT_TANK_SIDE_AUTO_IN, SIDE_TOP, NBT_TANK_SIDE_OUT, SBIT_R|SBIT_D, NBT_TANK_SIDE_AUTO_OUT, SIDE_BOTTOM, NBT_ENERGY_ACCEPTED_SIDES, SBIT_B), "hPw", "PMP", "PSP", 'M', OP.casingMachine.dat(aMat), 'S', OP.plateTriple     .dat(MT.Si), 'P', OP.plateTriple    .dat(MT.StainlessSteel));
		aMat = MT.DATA.Electric_T[4];   aRegistry.add("Freezer (T4)"                                        , "Basic Machines"                      , 20564, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT, 2048, NBT_TEXTURE, "freezer", NBT_ENERGY_ACCEPTED, TD.Energy.CU, NBT_RECIPEMAP, RM.Freezer, NBT_INV_SIDE_IN, SBIT_U|SBIT_L, NBT_INV_SIDE_AUTO_IN, SIDE_LEFT, NBT_INV_SIDE_OUT, SBIT_R|SBIT_D, NBT_INV_SIDE_AUTO_OUT, SIDE_RIGHT, NBT_TANK_SIDE_IN, SBIT_U|SBIT_L, NBT_TANK_SIDE_AUTO_IN, SIDE_TOP, NBT_TANK_SIDE_OUT, SBIT_R|SBIT_D, NBT_TANK_SIDE_AUTO_OUT, SIDE_BOTTOM, NBT_ENERGY_ACCEPTED_SIDES, SBIT_B), "hPw", "PMP", "PSP", 'M', OP.casingMachine.dat(aMat), 'S', OP.plateQuadruple  .dat(MT.Si), 'P', OP.plateQuadruple .dat(MT.StainlessSteel));
		aMat = MT.DATA.Electric_T[5];   aRegistry.add("Freezer (T5)"                                        , "Basic Machines"                      , 20565, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT, 8192, NBT_TEXTURE, "freezer", NBT_ENERGY_ACCEPTED, TD.Energy.CU, NBT_RECIPEMAP, RM.Freezer, NBT_INV_SIDE_IN, SBIT_U|SBIT_L, NBT_INV_SIDE_AUTO_IN, SIDE_LEFT, NBT_INV_SIDE_OUT, SBIT_R|SBIT_D, NBT_INV_SIDE_AUTO_OUT, SIDE_RIGHT, NBT_TANK_SIDE_IN, SBIT_U|SBIT_L, NBT_TANK_SIDE_AUTO_IN, SIDE_TOP, NBT_TANK_SIDE_OUT, SBIT_R|SBIT_D, NBT_TANK_SIDE_AUTO_OUT, SIDE_BOTTOM, NBT_ENERGY_ACCEPTED_SIDES, SBIT_B), "hPw", "PMP", "PSP", 'M', OP.casingMachine.dat(aMat), 'S', OP.plateQuintuple  .dat(MT.Si), 'P', OP.plateQuadruple .dat(MT.StainlessSteel));
		
		aClass = MultiTileEntityBasicMachine.class;
		aMat = MT.DATA.Electric_T[1];   aRegistry.add("Cryo Mixer (T1)"                                     , "Basic Machines"                      , 20571, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT,   32, NBT_TEXTURE, "cryomixer", NBT_ENERGY_ACCEPTED, TD.Energy.CU, NBT_RECIPEMAP, RM.CryoMixer, NBT_INV_SIDE_IN, SBIT_L|SBIT_U, NBT_INV_SIDE_AUTO_IN, SIDE_LEFT, NBT_INV_SIDE_OUT, SBIT_R|SBIT_B, NBT_INV_SIDE_AUTO_OUT, SIDE_RIGHT, NBT_TANK_SIDE_IN, SBIT_L|SBIT_U, NBT_TANK_SIDE_AUTO_IN, SIDE_TOP, NBT_TANK_SIDE_OUT, SBIT_R|SBIT_B, NBT_TANK_SIDE_AUTO_OUT, SIDE_BACK, NBT_ENERGY_ACCEPTED_SIDES, SBIT_D, NBT_PARALLEL, 4, NBT_PARALLEL_DURATION, T), "PMP", "PRP", "hSw", 'M', OP.casingMachine.dat(aMat), 'R', OP.rotor.dat(MT.StainlessSteel), 'S', OP.plate           .dat(MT.Si), 'P', OP.plate          .dat(MT.StainlessSteel));
		aMat = MT.DATA.Electric_T[2];   aRegistry.add("Cryo Mixer (T2)"                                     , "Basic Machines"                      , 20572, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT,  128, NBT_TEXTURE, "cryomixer", NBT_ENERGY_ACCEPTED, TD.Energy.CU, NBT_RECIPEMAP, RM.CryoMixer, NBT_INV_SIDE_IN, SBIT_L|SBIT_U, NBT_INV_SIDE_AUTO_IN, SIDE_LEFT, NBT_INV_SIDE_OUT, SBIT_R|SBIT_B, NBT_INV_SIDE_AUTO_OUT, SIDE_RIGHT, NBT_TANK_SIDE_IN, SBIT_L|SBIT_U, NBT_TANK_SIDE_AUTO_IN, SIDE_TOP, NBT_TANK_SIDE_OUT, SBIT_R|SBIT_B, NBT_TANK_SIDE_AUTO_OUT, SIDE_BACK, NBT_ENERGY_ACCEPTED_SIDES, SBIT_D, NBT_PARALLEL, 8, NBT_PARALLEL_DURATION, T), "PMP", "PRP", "hSw", 'M', OP.casingMachine.dat(aMat), 'R', OP.rotor.dat(MT.StainlessSteel), 'S', OP.plateDouble     .dat(MT.Si), 'P', OP.plateDouble    .dat(MT.StainlessSteel));
		aMat = MT.DATA.Electric_T[3];   aRegistry.add("Cryo Mixer (T3)"                                     , "Basic Machines"                      , 20573, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT,  512, NBT_TEXTURE, "cryomixer", NBT_ENERGY_ACCEPTED, TD.Energy.CU, NBT_RECIPEMAP, RM.CryoMixer, NBT_INV_SIDE_IN, SBIT_L|SBIT_U, NBT_INV_SIDE_AUTO_IN, SIDE_LEFT, NBT_INV_SIDE_OUT, SBIT_R|SBIT_B, NBT_INV_SIDE_AUTO_OUT, SIDE_RIGHT, NBT_TANK_SIDE_IN, SBIT_L|SBIT_U, NBT_TANK_SIDE_AUTO_IN, SIDE_TOP, NBT_TANK_SIDE_OUT, SBIT_R|SBIT_B, NBT_TANK_SIDE_AUTO_OUT, SIDE_BACK, NBT_ENERGY_ACCEPTED_SIDES, SBIT_D, NBT_PARALLEL,16, NBT_PARALLEL_DURATION, T), "PMP", "PRP", "hSw", 'M', OP.casingMachine.dat(aMat), 'R', OP.rotor.dat(MT.StainlessSteel), 'S', OP.plateTriple     .dat(MT.Si), 'P', OP.plateTriple    .dat(MT.StainlessSteel));
		aMat = MT.DATA.Electric_T[4];   aRegistry.add("Cryo Mixer (T4)"                                     , "Basic Machines"                      , 20574, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT, 2048, NBT_TEXTURE, "cryomixer", NBT_ENERGY_ACCEPTED, TD.Energy.CU, NBT_RECIPEMAP, RM.CryoMixer, NBT_INV_SIDE_IN, SBIT_L|SBIT_U, NBT_INV_SIDE_AUTO_IN, SIDE_LEFT, NBT_INV_SIDE_OUT, SBIT_R|SBIT_B, NBT_INV_SIDE_AUTO_OUT, SIDE_RIGHT, NBT_TANK_SIDE_IN, SBIT_L|SBIT_U, NBT_TANK_SIDE_AUTO_IN, SIDE_TOP, NBT_TANK_SIDE_OUT, SBIT_R|SBIT_B, NBT_TANK_SIDE_AUTO_OUT, SIDE_BACK, NBT_ENERGY_ACCEPTED_SIDES, SBIT_D, NBT_PARALLEL,32, NBT_PARALLEL_DURATION, T), "PMP", "PRP", "hSw", 'M', OP.casingMachine.dat(aMat), 'R', OP.rotor.dat(MT.StainlessSteel), 'S', OP.plateQuadruple  .dat(MT.Si), 'P', OP.plateQuadruple .dat(MT.StainlessSteel));
		aMat = MT.DATA.Electric_T[5];   aRegistry.add("Cryo Mixer (T5)"                                     , "Basic Machines"                      , 20575, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT, 8192, NBT_TEXTURE, "cryomixer", NBT_ENERGY_ACCEPTED, TD.Energy.CU, NBT_RECIPEMAP, RM.CryoMixer, NBT_INV_SIDE_IN, SBIT_L|SBIT_U, NBT_INV_SIDE_AUTO_IN, SIDE_LEFT, NBT_INV_SIDE_OUT, SBIT_R|SBIT_B, NBT_INV_SIDE_AUTO_OUT, SIDE_RIGHT, NBT_TANK_SIDE_IN, SBIT_L|SBIT_U, NBT_TANK_SIDE_AUTO_IN, SIDE_TOP, NBT_TANK_SIDE_OUT, SBIT_R|SBIT_B, NBT_TANK_SIDE_AUTO_OUT, SIDE_BACK, NBT_ENERGY_ACCEPTED_SIDES, SBIT_D, NBT_PARALLEL,64, NBT_PARALLEL_DURATION, T), "PMP", "PRP", "hSw", 'M', OP.casingMachine.dat(aMat), 'R', OP.rotor.dat(MT.StainlessSteel), 'S', OP.plateQuintuple  .dat(MT.Si), 'P', OP.plateQuadruple .dat(MT.StainlessSteel));
		
		aClass = MultiTileEntityBasicMachineElectric.class;
		aMat = MT.DATA.Electric_T[1];   aRegistry.add("Boxinator ("                               +VN[1]+")", "Basic Machines"                      , 20581, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT,   32, NBT_TEXTURE, "boxinator", NBT_ENERGY_ACCEPTED, TD.Energy.EU, NBT_RECIPEMAP, RM.Boxinator, NBT_INV_SIDE_IN, SBIT_L|SBIT_U, NBT_INV_SIDE_AUTO_IN, SIDE_LEFT, NBT_INV_SIDE_OUT, SBIT_R, NBT_INV_SIDE_AUTO_OUT, SIDE_RIGHT, NBT_ENERGY_ACCEPTED_SIDES, SBIT_D), "wP", "CY", "CM", 'M', OP.casingMachine.dat(aMat), 'P', IL.PISTONS[1], 'Y', IL.CONVEYERS[1], 'C', OD_CIRCUITS[1]);
		aMat = MT.DATA.Electric_T[2];   aRegistry.add("Boxinator ("                               +VN[2]+")", "Basic Machines"                      , 20582, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT,  128, NBT_TEXTURE, "boxinator", NBT_ENERGY_ACCEPTED, TD.Energy.EU, NBT_RECIPEMAP, RM.Boxinator, NBT_INV_SIDE_IN, SBIT_L|SBIT_U, NBT_INV_SIDE_AUTO_IN, SIDE_LEFT, NBT_INV_SIDE_OUT, SBIT_R, NBT_INV_SIDE_AUTO_OUT, SIDE_RIGHT, NBT_ENERGY_ACCEPTED_SIDES, SBIT_D), "wP", "CY", "CM", 'M', OP.casingMachine.dat(aMat), 'P', IL.PISTONS[2], 'Y', IL.CONVEYERS[2], 'C', OD_CIRCUITS[2]);
		aMat = MT.DATA.Electric_T[3];   aRegistry.add("Boxinator ("                               +VN[3]+")", "Basic Machines"                      , 20583, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT,  512, NBT_TEXTURE, "boxinator", NBT_ENERGY_ACCEPTED, TD.Energy.EU, NBT_RECIPEMAP, RM.Boxinator, NBT_INV_SIDE_IN, SBIT_L|SBIT_U, NBT_INV_SIDE_AUTO_IN, SIDE_LEFT, NBT_INV_SIDE_OUT, SBIT_R, NBT_INV_SIDE_AUTO_OUT, SIDE_RIGHT, NBT_ENERGY_ACCEPTED_SIDES, SBIT_D), "wP", "CY", "CM", 'M', OP.casingMachine.dat(aMat), 'P', IL.PISTONS[3], 'Y', IL.CONVEYERS[3], 'C', OD_CIRCUITS[3]);
		aMat = MT.DATA.Electric_T[4];   aRegistry.add("Boxinator ("                               +VN[4]+")", "Basic Machines"                      , 20584, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT, 2048, NBT_TEXTURE, "boxinator", NBT_ENERGY_ACCEPTED, TD.Energy.EU, NBT_RECIPEMAP, RM.Boxinator, NBT_INV_SIDE_IN, SBIT_L|SBIT_U, NBT_INV_SIDE_AUTO_IN, SIDE_LEFT, NBT_INV_SIDE_OUT, SBIT_R, NBT_INV_SIDE_AUTO_OUT, SIDE_RIGHT, NBT_ENERGY_ACCEPTED_SIDES, SBIT_D), "wP", "CY", "CM", 'M', OP.casingMachine.dat(aMat), 'P', IL.PISTONS[4], 'Y', IL.CONVEYERS[4], 'C', OD_CIRCUITS[4]);
		aMat = MT.DATA.Electric_T[5];   aRegistry.add("Boxinator ("                               +VN[5]+")", "Basic Machines"                      , 20585, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT, 8192, NBT_TEXTURE, "boxinator", NBT_ENERGY_ACCEPTED, TD.Energy.EU, NBT_RECIPEMAP, RM.Boxinator, NBT_INV_SIDE_IN, SBIT_L|SBIT_U, NBT_INV_SIDE_AUTO_IN, SIDE_LEFT, NBT_INV_SIDE_OUT, SBIT_R, NBT_INV_SIDE_AUTO_OUT, SIDE_RIGHT, NBT_ENERGY_ACCEPTED_SIDES, SBIT_D), "wP", "CY", "CM", 'M', OP.casingMachine.dat(aMat), 'P', IL.PISTONS[5], 'Y', IL.CONVEYERS[5], 'C', OD_CIRCUITS[5]);
		
		aClass = MultiTileEntityBasicMachineElectric.class;
		aMat = MT.DATA.Electric_T[1];   aRegistry.add("Unboxinator ("                             +VN[1]+")", "Basic Machines"                      , 20591, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT,   32, NBT_TEXTURE, "unboxinator", NBT_ENERGY_ACCEPTED, TD.Energy.EU, NBT_RECIPEMAP, RM.Unboxinator, NBT_INV_SIDE_IN, SBIT_L|SBIT_U, NBT_INV_SIDE_AUTO_IN, SIDE_LEFT, NBT_INV_SIDE_OUT, SBIT_R, NBT_INV_SIDE_AUTO_OUT, SIDE_RIGHT, NBT_ENERGY_ACCEPTED_SIDES, SBIT_D), "Pw", "YC", "MC", 'M', OP.casingMachine.dat(aMat), 'P', IL.PISTONS[1], 'Y', IL.CONVEYERS[1], 'C', OD_CIRCUITS[1]);
		aMat = MT.DATA.Electric_T[2];   aRegistry.add("Unboxinator ("                             +VN[2]+")", "Basic Machines"                      , 20592, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT,  128, NBT_TEXTURE, "unboxinator", NBT_ENERGY_ACCEPTED, TD.Energy.EU, NBT_RECIPEMAP, RM.Unboxinator, NBT_INV_SIDE_IN, SBIT_L|SBIT_U, NBT_INV_SIDE_AUTO_IN, SIDE_LEFT, NBT_INV_SIDE_OUT, SBIT_R, NBT_INV_SIDE_AUTO_OUT, SIDE_RIGHT, NBT_ENERGY_ACCEPTED_SIDES, SBIT_D), "Pw", "YC", "MC", 'M', OP.casingMachine.dat(aMat), 'P', IL.PISTONS[2], 'Y', IL.CONVEYERS[2], 'C', OD_CIRCUITS[2]);
		aMat = MT.DATA.Electric_T[3];   aRegistry.add("Unboxinator ("                             +VN[3]+")", "Basic Machines"                      , 20593, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT,  512, NBT_TEXTURE, "unboxinator", NBT_ENERGY_ACCEPTED, TD.Energy.EU, NBT_RECIPEMAP, RM.Unboxinator, NBT_INV_SIDE_IN, SBIT_L|SBIT_U, NBT_INV_SIDE_AUTO_IN, SIDE_LEFT, NBT_INV_SIDE_OUT, SBIT_R, NBT_INV_SIDE_AUTO_OUT, SIDE_RIGHT, NBT_ENERGY_ACCEPTED_SIDES, SBIT_D), "Pw", "YC", "MC", 'M', OP.casingMachine.dat(aMat), 'P', IL.PISTONS[3], 'Y', IL.CONVEYERS[3], 'C', OD_CIRCUITS[3]);
		aMat = MT.DATA.Electric_T[4];   aRegistry.add("Unboxinator ("                             +VN[4]+")", "Basic Machines"                      , 20594, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT, 2048, NBT_TEXTURE, "unboxinator", NBT_ENERGY_ACCEPTED, TD.Energy.EU, NBT_RECIPEMAP, RM.Unboxinator, NBT_INV_SIDE_IN, SBIT_L|SBIT_U, NBT_INV_SIDE_AUTO_IN, SIDE_LEFT, NBT_INV_SIDE_OUT, SBIT_R, NBT_INV_SIDE_AUTO_OUT, SIDE_RIGHT, NBT_ENERGY_ACCEPTED_SIDES, SBIT_D), "Pw", "YC", "MC", 'M', OP.casingMachine.dat(aMat), 'P', IL.PISTONS[4], 'Y', IL.CONVEYERS[4], 'C', OD_CIRCUITS[4]);
		aMat = MT.DATA.Electric_T[5];   aRegistry.add("Unboxinator ("                             +VN[5]+")", "Basic Machines"                      , 20595, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   4.0F, NBT_RESISTANCE,   4.0F, NBT_INPUT, 8192, NBT_TEXTURE, "unboxinator", NBT_ENERGY_ACCEPTED, TD.Energy.EU, NBT_RECIPEMAP, RM.Unboxinator, NBT_INV_SIDE_IN, SBIT_L|SBIT_U, NBT_INV_SIDE_AUTO_IN, SIDE_LEFT, NBT_INV_SIDE_OUT, SBIT_R, NBT_INV_SIDE_AUTO_OUT, SIDE_RIGHT, NBT_ENERGY_ACCEPTED_SIDES, SBIT_D), "Pw", "YC", "MC", 'M', OP.casingMachine.dat(aMat), 'P', IL.PISTONS[5], 'Y', IL.CONVEYERS[5], 'C', OD_CIRCUITS[5]);
	}
	
	private static void machines4(MultiTileEntityRegistry aRegistry, MultiTileEntityBlock aMetal, MultiTileEntityBlock aMetalChips, MultiTileEntityBlock aMetalWires, MultiTileEntityBlock aMachine, MultiTileEntityBlock aWooden, MultiTileEntityBlock aBush, MultiTileEntityBlock aStone, MultiTileEntityBlock aWool, MultiTileEntityBlock aTNT, MultiTileEntityBlock aHive, MultiTileEntityBlock aUtilMetal, MultiTileEntityBlock aUtilStone, MultiTileEntityBlock aUtilWood, MultiTileEntityBlock aUtilWool, OreDictMaterial aMat, Class<? extends TileEntity> aClass) {
		aClass = MultiTileEntityBasicMachine.class;
		aMat = MT.StainlessSteel;       aRegistry.add("Coagulator"                                          , "Basic Machines"                      , 22000, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   6.0F, NBT_RESISTANCE,   6.0F, NBT_INPUT, 1, NBT_TEXTURE, "coagulator"    , NBT_ENERGY_ACCEPTED, TD.Energy.TU, NBT_NO_CONSTANT_POWER, T, NBT_RECIPEMAP, RM.Coagulator                                                                           , NBT_INV_SIDE_OUT, SBIT_D|SBIT_R   , NBT_INV_SIDE_AUTO_OUT, SIDE_BOTTOM    , NBT_TANK_SIDE_IN, SBIT_U|SBIT_L   , NBT_TANK_SIDE_AUTO_IN, SIDE_TOP                                                                               , NBT_ENERGY_ACCEPTED_SIDES, 63                       , NBT_INPUT,  1, NBT_INPUT_MIN, 1, NBT_INPUT_MAX, 16), "T T", "hMw", "TdT", 'M', OP.casingMachine.dat(aMat), 'T', OP.screw.dat(aMat));
		aMat = MT.StainlessSteel;       aRegistry.add("Generifier"                                          , "Basic Machines"                      , 22001, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   6.0F, NBT_RESISTANCE,   6.0F, NBT_INPUT, 1, NBT_TEXTURE, "generifier"    , NBT_ENERGY_ACCEPTED, TD.Energy.TU, NBT_NO_CONSTANT_POWER, T, NBT_RECIPEMAP, RM.Generifier   , NBT_INV_SIDE_IN, SBIT_U|SBIT_L    , NBT_INV_SIDE_AUTO_IN, SIDE_LEFT   , NBT_INV_SIDE_OUT, SBIT_D|SBIT_R   , NBT_INV_SIDE_AUTO_OUT, SIDE_RIGHT     , NBT_TANK_SIDE_IN, SBIT_U|SBIT_L   , NBT_TANK_SIDE_AUTO_IN, SIDE_TOP   , NBT_TANK_SIDE_OUT, SBIT_D|SBIT_R  , NBT_TANK_SIDE_AUTO_OUT, SIDE_BOTTOM   , NBT_ENERGY_ACCEPTED_SIDES, 63    , NBT_PARALLEL, 100, NBT_INPUT,  1, NBT_INPUT_MIN, 1, NBT_INPUT_MAX, 16), "ChC", "CMC", "CwC", 'M', OP.casingMachine.dat(aMat), 'C', OP.casingSmall.dat(aMat));
		aMat = MT.StainlessSteel;       aRegistry.add("Bath"                                                , "Basic Machines"                      , 22002, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   6.0F, NBT_RESISTANCE,   6.0F, NBT_INPUT, 1, NBT_TEXTURE, "bath"          , NBT_ENERGY_ACCEPTED, TD.Energy.TU, NBT_NO_CONSTANT_POWER, T, NBT_RECIPEMAP, RM.Bath         , NBT_INV_SIDE_IN, SBIT_U|SBIT_L    , NBT_INV_SIDE_AUTO_IN, SIDE_LEFT   , NBT_INV_SIDE_OUT, SBIT_D|SBIT_R   , NBT_INV_SIDE_AUTO_OUT, SIDE_RIGHT     , NBT_TANK_SIDE_IN, SBIT_U|SBIT_L   , NBT_TANK_SIDE_AUTO_IN, SIDE_TOP   , NBT_TANK_SIDE_OUT, SBIT_D|SBIT_R  , NBT_TANK_SIDE_AUTO_OUT, SIDE_BOTTOM   , NBT_ENERGY_ACCEPTED_SIDES, 63                       , NBT_INPUT,  1, NBT_INPUT_MIN, 1, NBT_INPUT_MAX, 16), "CwC", "PMP", "PPP", 'M', OP.casingMachine.dat(aMat), 'C', OP.casingSmall.dat(aMat), 'P', OP.plate.dat(aMat));
		aMat = MT.StainlessSteel;       aRegistry.add("Fermenter"                                           , "Basic Machines"                      , 22003, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   6.0F, NBT_RESISTANCE,   6.0F, NBT_INPUT,32, NBT_TEXTURE, "fermenter"     , NBT_ENERGY_ACCEPTED, TD.Energy.HU                          , NBT_RECIPEMAP, RM.Fermenter    , NBT_INV_SIDE_IN, SBIT_B|SBIT_L    , NBT_INV_SIDE_AUTO_IN, SIDE_LEFT   , NBT_INV_SIDE_OUT, SBIT_R          , NBT_INV_SIDE_AUTO_OUT, SIDE_RIGHT     , NBT_TANK_SIDE_IN, SBIT_B|SBIT_L   , NBT_TANK_SIDE_AUTO_IN, SIDE_BACK  , NBT_TANK_SIDE_OUT, SBIT_U         , NBT_TANK_SIDE_AUTO_OUT, SIDE_TOP      , NBT_ENERGY_ACCEPTED_SIDES, SBIT_D                   , NBT_INPUT, 32, NBT_INPUT_MIN,16, NBT_INPUT_MAX, 64), "wMh", "PPP", "BCB", 'M', OP.casingMachine.dat(aMat), 'C', OP.plateDouble.dat(ANY.Cu), 'B', Blocks.brick_block, 'P', OP.pipeLarge.dat(aMat));
		aMat = MT.StainlessSteel;       aRegistry.add("Autoclave"                                           , "Basic Machines"                      , 22004, 20001, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   6.0F, NBT_RESISTANCE,   6.0F, NBT_INPUT, 1, NBT_TEXTURE, "autoclave"     , NBT_ENERGY_ACCEPTED, TD.Energy.TU, NBT_NO_CONSTANT_POWER, T, NBT_RECIPEMAP, RM.Autoclave    , NBT_INV_SIDE_IN, SBIT_U|SBIT_L    , NBT_INV_SIDE_AUTO_IN, SIDE_LEFT   , NBT_INV_SIDE_OUT, SBIT_B|SBIT_R   , NBT_INV_SIDE_AUTO_OUT, SIDE_RIGHT     , NBT_TANK_SIDE_IN, SBIT_D|SBIT_L   , NBT_TANK_SIDE_AUTO_IN, SIDE_BOTTOM, NBT_TANK_SIDE_OUT, SBIT_B|SBIT_R  , NBT_TANK_SIDE_AUTO_OUT, SIDE_BACK     , NBT_ENERGY_ACCEPTED_SIDES, 63                       , NBT_INPUT,  1, NBT_INPUT_MIN, 1, NBT_INPUT_MAX, 16), "CwC", "PMP", "GPG", 'M', OP.casingMachineQuadruple.dat(aMat), 'C', OP.casingSmall.dat(aMat), 'G', OP.gearGtSmall.dat(aMat), 'P', OP.pipeSmall.dat(aMat));
	}
	
	private static void kinetic(MultiTileEntityRegistry aRegistry, MultiTileEntityBlock aMetal, MultiTileEntityBlock aMetalChips, MultiTileEntityBlock aMetalWires, MultiTileEntityBlock aMachine, MultiTileEntityBlock aWooden, MultiTileEntityBlock aBush, MultiTileEntityBlock aStone, MultiTileEntityBlock aWool, MultiTileEntityBlock aTNT, MultiTileEntityBlock aHive, MultiTileEntityBlock aUtilMetal, MultiTileEntityBlock aUtilStone, MultiTileEntityBlock aUtilWood, MultiTileEntityBlock aUtilWool, OreDictMaterial aMat, Class<? extends TileEntity> aClass) {
		aClass = MultiTileEntityAxle.class;
		aMat = MT.WoodTreated;
		aRegistry.add(                     "Small Wooden Axle", "Axles and Gearboxes", 24800, 24819, aClass                                  , aMat.mToolQuality, 64, aWooden , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS, 2.0F, NBT_RESISTANCE, 6.0F, NBT_FLAMMABILITY, 150, NBT_PIPESIZE, VMAX[ 0], NBT_PIPEBANDWIDTH,     1, NBT_DIAMETER, PX_P[ 6]), "  S", " r ", "S f", 'S', OP.stick.dat(aMat));
		aRegistry.add(                    "Medium Wooden Axle", "Axles and Gearboxes", 24801, 24819, aClass                                  , aMat.mToolQuality, 64, aWooden , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS, 2.0F, NBT_RESISTANCE, 6.0F, NBT_FLAMMABILITY, 150, NBT_PIPESIZE, VMAX[ 0], NBT_PIPEBANDWIDTH,     2, NBT_DIAMETER, PX_P[ 9]), "  S", " r ", "S f", 'S', OP.stickLong.dat(aMat));
		aRegistry.add(                     "Large Wooden Axle", "Axles and Gearboxes", 24802, 24819, aClass                                  , aMat.mToolQuality, 32, aWooden , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS, 2.0F, NBT_RESISTANCE, 6.0F, NBT_FLAMMABILITY, 150, NBT_PIPESIZE, VMAX[ 0], NBT_PIPEBANDWIDTH,     4, NBT_DIAMETER, PX_P[12]), "  S", "SrS", "S f", 'S', OP.stickLong.dat(aMat));
		aRegistry.add(                      "Huge Wooden Axle", "Axles and Gearboxes", 24803, 24819, aClass                                  , aMat.mToolQuality, 16, aWooden , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS, 2.0F, NBT_RESISTANCE, 6.0F, NBT_FLAMMABILITY, 150, NBT_PIPESIZE, VMAX[ 0], NBT_PIPEBANDWIDTH,     8, NBT_DIAMETER, PX_P[16]), "rS" ,  "Bf", 'S', OD.beamWood, 'B', OD.container1000creosote);
		aRegistry.add(                "Wooden Rotation Engine", "Axles and Gearboxes", 24807, 24819, MultiTileEntityEngineRotation.class     , aMat.mToolQuality, 16, aWooden , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS, 6.0F, NBT_RESISTANCE, 6.0F, NBT_FLAMMABILITY, 150, NBT_INPUT   , V   [ 0], NBT_OUTPUT, V[ 0]/2                   , NBT_WASTE_ENERGY, T, NBT_ENERGY_ACCEPTED, TD.Energy.RU, NBT_ENERGY_EMITTED, TD.Energy.KU), "PSP", "wAL", "GAG", 'S', OP.gearGtSmall.dat(aMat), 'G', OP.gearGt.dat(aMat), 'P', OP.plate.dat(aMat), 'L', OD.itemLubricantEarly, 'A', aRegistry.getItem(24801));
		aRegistry.add(            "Wooden Transformer Gearbox", "Axles and Gearboxes", 24808, 24819, MultiTileEntityTransformerRotation.class, aMat.mToolQuality, 16, aWooden , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS, 6.0F, NBT_RESISTANCE, 6.0F, NBT_FLAMMABILITY, 150, NBT_INPUT   , V   [ 0], NBT_OUTPUT,       2, NBT_MULTIPLIER, 4, NBT_WASTE_ENERGY, T, NBT_ENERGY_ACCEPTED, TD.Energy.RU, NBT_ENERGY_EMITTED, TD.Energy.RU), "ASL", "SGS", "PSA", 'S', OP.gearGtSmall.dat(aMat), 'G', OP.gearGt.dat(aMat), 'P', OP.plate.dat(aMat), 'L', OD.itemLubricantEarly, 'A', aRegistry.getItem(24801));
		aRegistry.add(                 "Custom Wooden Gearbox", "Axles and Gearboxes", 24809, 24819, MultiTileEntityGearBox.class            , aMat.mToolQuality, 16, aWooden , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS, 6.0F, NBT_RESISTANCE, 6.0F, NBT_FLAMMABILITY, 150, NBT_INPUT   , VMAX[ 0]                                                                                                                                  ), "PsP", "ALA", "PAP"                                                         , 'P', OP.plate.dat(aMat), 'L', OD.itemLubricantEarly, 'A', aRegistry.getItem(24801));
		OM.data(aRegistry.getItem(24803), MT.WoodTreated, U*8);
		aMat = MT.Bronze;
		aRegistry.add("Small "  + aMat.mNameLocal +    " Axle", "Axles and Gearboxes", 24810, 24819, aClass                                  , aMat.mToolQuality, 64, aMachine, UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS, 2.0F, NBT_RESISTANCE, 6.0F                       , NBT_PIPESIZE, VMAX[ 1], NBT_PIPEBANDWIDTH,     2, NBT_DIAMETER, PX_P[ 6]), "  S", " h ", "S f", 'S', OP.stick.dat(aMat));
		aRegistry.add("Medium " + aMat.mNameLocal +    " Axle", "Axles and Gearboxes", 24811, 24819, aClass                                  , aMat.mToolQuality, 64, aMachine, UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS, 2.0F, NBT_RESISTANCE, 6.0F                       , NBT_PIPESIZE, VMAX[ 1], NBT_PIPEBANDWIDTH,     4, NBT_DIAMETER, PX_P[ 9]), "  S", " h ", "S f", 'S', OP.stickLong.dat(aMat));
		aRegistry.add("Large "  + aMat.mNameLocal +    " Axle", "Axles and Gearboxes", 24812, 24819, aClass                                  , aMat.mToolQuality, 32, aMachine, UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS, 2.0F, NBT_RESISTANCE, 6.0F                       , NBT_PIPESIZE, VMAX[ 1], NBT_PIPEBANDWIDTH,     8, NBT_DIAMETER, PX_P[12]), "  S", " h ", "S f", 'S', OP.ingotDouble.dat(aMat));
		aRegistry.add("Huge "   + aMat.mNameLocal +    " Axle", "Axles and Gearboxes", 24813, 24819, aClass                                  , aMat.mToolQuality, 16, aMachine, UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS, 2.0F, NBT_RESISTANCE, 6.0F                       , NBT_PIPESIZE, VMAX[ 1], NBT_PIPEBANDWIDTH,    16, NBT_DIAMETER, PX_P[16]), "  S", " h ", "S f", 'S', OP.ingotQuadruple.dat(aMat));
		aRegistry.add(aMat.mNameLocal +     " Rotation Engine", "Axles and Gearboxes", 24817, 24819, MultiTileEntityEngineRotation.class     , aMat.mToolQuality, 16, aMachine, UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS, 6.0F, NBT_RESISTANCE, 6.0F                       , NBT_INPUT   , V   [ 1], NBT_OUTPUT, V[ 1]/2                   , NBT_WASTE_ENERGY, T, NBT_ENERGY_ACCEPTED, TD.Energy.RU, NBT_ENERGY_EMITTED, TD.Energy.KU), "SAS", "wML", "GAG", 'S', OP.gearGtSmall.dat(aMat), 'G', OP.gearGt.dat(aMat), 'M', OP.casingMachine      .dat(aMat), 'L', OD.itemLubricantEarly, 'A', aRegistry.getItem(24811));
		aRegistry.add(aMat.mNameLocal + " Transformer Gearbox", "Axles and Gearboxes", 24818, 24819, MultiTileEntityTransformerRotation.class, aMat.mToolQuality, 16, aMachine, UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS, 6.0F, NBT_RESISTANCE, 6.0F                       , NBT_INPUT   , V   [ 1], NBT_OUTPUT, V[ 0]  , NBT_MULTIPLIER, 4, NBT_WASTE_ENERGY, T, NBT_ENERGY_ACCEPTED, TD.Energy.RU, NBT_ENERGY_EMITTED, TD.Energy.RU), "ASL", "SGS", "MSA", 'S', OP.gearGtSmall.dat(aMat), 'G', OP.gearGt.dat(aMat), 'M', OP.casingMachineDouble.dat(aMat), 'L', OD.itemLubricantEarly, 'A', aRegistry.getItem(24811));
		aRegistry.add("Custom " + aMat.mNameLocal + " Gearbox", "Axles and Gearboxes", 24819, 24819, MultiTileEntityGearBox.class            , aMat.mToolQuality, 16, aMachine, UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS, 6.0F, NBT_RESISTANCE, 6.0F                       , NBT_INPUT   , VMAX[ 1]                                                                                                                                  ), "wAL", "AMA"                                                                , 'M', OP.casingMachine      .dat(aMat), 'L', OD.itemLubricantEarly, 'A', aRegistry.getItem(24811));
		aMat = MT.ArsenicCopper;
		aRegistry.add("Small "  + aMat.mNameLocal +    " Axle", "Axles and Gearboxes", 24780, 24819, aClass                                  , aMat.mToolQuality, 64, aMachine, UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS, 2.0F, NBT_RESISTANCE, 6.0F                       , NBT_PIPESIZE, VMAX[ 1], NBT_PIPEBANDWIDTH,     2, NBT_DIAMETER, PX_P[ 6]), "  S", " h ", "S f", 'S', OP.stick.dat(aMat));
		aRegistry.add("Medium " + aMat.mNameLocal +    " Axle", "Axles and Gearboxes", 24781, 24819, aClass                                  , aMat.mToolQuality, 64, aMachine, UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS, 2.0F, NBT_RESISTANCE, 6.0F                       , NBT_PIPESIZE, VMAX[ 1], NBT_PIPEBANDWIDTH,     4, NBT_DIAMETER, PX_P[ 9]), "  S", " h ", "S f", 'S', OP.stickLong.dat(aMat));
		aRegistry.add("Large "  + aMat.mNameLocal +    " Axle", "Axles and Gearboxes", 24782, 24819, aClass                                  , aMat.mToolQuality, 32, aMachine, UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS, 2.0F, NBT_RESISTANCE, 6.0F                       , NBT_PIPESIZE, VMAX[ 1], NBT_PIPEBANDWIDTH,     8, NBT_DIAMETER, PX_P[12]), "  S", " h ", "S f", 'S', OP.ingotDouble.dat(aMat));
		aRegistry.add("Huge "   + aMat.mNameLocal +    " Axle", "Axles and Gearboxes", 24783, 24819, aClass                                  , aMat.mToolQuality, 16, aMachine, UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS, 2.0F, NBT_RESISTANCE, 6.0F                       , NBT_PIPESIZE, VMAX[ 1], NBT_PIPEBANDWIDTH,    16, NBT_DIAMETER, PX_P[16]), "  S", " h ", "S f", 'S', OP.ingotQuadruple.dat(aMat));
		aRegistry.add(aMat.mNameLocal +     " Rotation Engine", "Axles and Gearboxes", 24787, 24819, MultiTileEntityEngineRotation.class     , aMat.mToolQuality, 16, aMachine, UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS, 6.0F, NBT_RESISTANCE, 6.0F                       , NBT_INPUT   , V   [ 1], NBT_OUTPUT, V[ 1]/2                   , NBT_WASTE_ENERGY, T, NBT_ENERGY_ACCEPTED, TD.Energy.RU, NBT_ENERGY_EMITTED, TD.Energy.KU), "SAS", "wML", "GAG", 'S', OP.gearGtSmall.dat(aMat), 'G', OP.gearGt.dat(aMat), 'M', OP.casingMachine      .dat(aMat), 'L', OD.itemLubricantEarly, 'A', aRegistry.getItem(24781));
		aRegistry.add(aMat.mNameLocal + " Transformer Gearbox", "Axles and Gearboxes", 24788, 24819, MultiTileEntityTransformerRotation.class, aMat.mToolQuality, 16, aMachine, UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS, 6.0F, NBT_RESISTANCE, 6.0F                       , NBT_INPUT   , V   [ 1], NBT_OUTPUT, V[ 0]  , NBT_MULTIPLIER, 4, NBT_WASTE_ENERGY, T, NBT_ENERGY_ACCEPTED, TD.Energy.RU, NBT_ENERGY_EMITTED, TD.Energy.RU), "ASL", "SGS", "MSA", 'S', OP.gearGtSmall.dat(aMat), 'G', OP.gearGt.dat(aMat), 'M', OP.casingMachineDouble.dat(aMat), 'L', OD.itemLubricantEarly, 'A', aRegistry.getItem(24781));
		aRegistry.add("Custom " + aMat.mNameLocal + " Gearbox", "Axles and Gearboxes", 24789, 24819, MultiTileEntityGearBox.class            , aMat.mToolQuality, 16, aMachine, UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS, 6.0F, NBT_RESISTANCE, 6.0F                       , NBT_INPUT   , VMAX[ 1]                                                                                                                                  ), "wAL", "AMA"                                                                , 'M', OP.casingMachine      .dat(aMat), 'L', OD.itemLubricantEarly, 'A', aRegistry.getItem(24781));
		aMat = MT.ArsenicBronze;
		aRegistry.add("Small "  + aMat.mNameLocal +    " Axle", "Axles and Gearboxes", 24790, 24819, aClass                                  , aMat.mToolQuality, 64, aMachine, UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS, 2.0F, NBT_RESISTANCE, 6.0F                       , NBT_PIPESIZE, VMAX[ 1], NBT_PIPEBANDWIDTH,     3, NBT_DIAMETER, PX_P[ 6]), "  S", " h ", "S f", 'S', OP.stick.dat(aMat));
		aRegistry.add("Medium " + aMat.mNameLocal +    " Axle", "Axles and Gearboxes", 24791, 24819, aClass                                  , aMat.mToolQuality, 64, aMachine, UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS, 2.0F, NBT_RESISTANCE, 6.0F                       , NBT_PIPESIZE, VMAX[ 1], NBT_PIPEBANDWIDTH,     6, NBT_DIAMETER, PX_P[ 9]), "  S", " h ", "S f", 'S', OP.stickLong.dat(aMat));
		aRegistry.add("Large "  + aMat.mNameLocal +    " Axle", "Axles and Gearboxes", 24792, 24819, aClass                                  , aMat.mToolQuality, 32, aMachine, UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS, 2.0F, NBT_RESISTANCE, 6.0F                       , NBT_PIPESIZE, VMAX[ 1], NBT_PIPEBANDWIDTH,    12, NBT_DIAMETER, PX_P[12]), "  S", " h ", "S f", 'S', OP.ingotDouble.dat(aMat));
		aRegistry.add("Huge "   + aMat.mNameLocal +    " Axle", "Axles and Gearboxes", 24793, 24819, aClass                                  , aMat.mToolQuality, 16, aMachine, UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS, 2.0F, NBT_RESISTANCE, 6.0F                       , NBT_PIPESIZE, VMAX[ 1], NBT_PIPEBANDWIDTH,    24, NBT_DIAMETER, PX_P[16]), "  S", " h ", "S f", 'S', OP.ingotQuadruple.dat(aMat));
		aRegistry.add(aMat.mNameLocal +     " Rotation Engine", "Axles and Gearboxes", 24797, 24819, MultiTileEntityEngineRotation.class     , aMat.mToolQuality, 16, aMachine, UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS, 6.0F, NBT_RESISTANCE, 6.0F                       , NBT_INPUT   , V   [ 1], NBT_OUTPUT, V[ 1]/2                   , NBT_WASTE_ENERGY, T, NBT_ENERGY_ACCEPTED, TD.Energy.RU, NBT_ENERGY_EMITTED, TD.Energy.KU), "SAS", "wML", "GAG", 'S', OP.gearGtSmall.dat(aMat), 'G', OP.gearGt.dat(aMat), 'M', OP.casingMachine      .dat(aMat), 'L', OD.itemLubricantEarly, 'A', aRegistry.getItem(24791));
		aRegistry.add(aMat.mNameLocal + " Transformer Gearbox", "Axles and Gearboxes", 24798, 24819, MultiTileEntityTransformerRotation.class, aMat.mToolQuality, 16, aMachine, UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS, 6.0F, NBT_RESISTANCE, 6.0F                       , NBT_INPUT   , V   [ 1], NBT_OUTPUT, V[ 0]  , NBT_MULTIPLIER, 4, NBT_WASTE_ENERGY, T, NBT_ENERGY_ACCEPTED, TD.Energy.RU, NBT_ENERGY_EMITTED, TD.Energy.RU), "ASL", "SGS", "MSA", 'S', OP.gearGtSmall.dat(aMat), 'G', OP.gearGt.dat(aMat), 'M', OP.casingMachineDouble.dat(aMat), 'L', OD.itemLubricantEarly, 'A', aRegistry.getItem(24791));
		aRegistry.add("Custom " + aMat.mNameLocal + " Gearbox", "Axles and Gearboxes", 24799, 24819, MultiTileEntityGearBox.class            , aMat.mToolQuality, 16, aMachine, UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS, 6.0F, NBT_RESISTANCE, 6.0F                       , NBT_INPUT   , VMAX[ 1]                                                                                                                                  ), "wAL", "AMA"                                                                , 'M', OP.casingMachine      .dat(aMat), 'L', OD.itemLubricantEarly, 'A', aRegistry.getItem(24791));
		aMat = MT.Steel;
		aRegistry.add("Small "  + aMat.mNameLocal +    " Axle", "Axles and Gearboxes", 24820, 24819, aClass                                  , aMat.mToolQuality, 64, aMachine, UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS, 2.0F, NBT_RESISTANCE, 6.0F                       , NBT_PIPESIZE, VMAX[ 2], NBT_PIPEBANDWIDTH,     4, NBT_DIAMETER, PX_P[ 6]), "  S", " h ", "S f", 'S', OP.stick.dat(ANY.Steel));
		aRegistry.add("Medium " + aMat.mNameLocal +    " Axle", "Axles and Gearboxes", 24821, 24819, aClass                                  , aMat.mToolQuality, 64, aMachine, UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS, 2.0F, NBT_RESISTANCE, 6.0F                       , NBT_PIPESIZE, VMAX[ 2], NBT_PIPEBANDWIDTH,     8, NBT_DIAMETER, PX_P[ 9]), "  S", " h ", "S f", 'S', OP.stickLong.dat(ANY.Steel));
		aRegistry.add("Large "  + aMat.mNameLocal +    " Axle", "Axles and Gearboxes", 24822, 24819, aClass                                  , aMat.mToolQuality, 32, aMachine, UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS, 2.0F, NBT_RESISTANCE, 6.0F                       , NBT_PIPESIZE, VMAX[ 2], NBT_PIPEBANDWIDTH,    16, NBT_DIAMETER, PX_P[12]), "  S", " h ", "S f", 'S', OP.ingotDouble.dat(ANY.Steel));
		aRegistry.add("Huge "   + aMat.mNameLocal +    " Axle", "Axles and Gearboxes", 24823, 24819, aClass                                  , aMat.mToolQuality, 16, aMachine, UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS, 2.0F, NBT_RESISTANCE, 6.0F                       , NBT_PIPESIZE, VMAX[ 2], NBT_PIPEBANDWIDTH,    32, NBT_DIAMETER, PX_P[16]), "  S", " h ", "S f", 'S', OP.ingotQuadruple.dat(ANY.Steel));
		aRegistry.add(aMat.mNameLocal +     " Rotation Engine", "Axles and Gearboxes", 24827, 24819, MultiTileEntityEngineRotation.class     , aMat.mToolQuality, 16, aMachine, UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS, 6.0F, NBT_RESISTANCE, 6.0F                       , NBT_INPUT   , V   [ 2], NBT_OUTPUT, V[ 2]/2                   , NBT_WASTE_ENERGY, T, NBT_ENERGY_ACCEPTED, TD.Energy.RU, NBT_ENERGY_EMITTED, TD.Energy.KU), "SAS", "wML", "GAG", 'S', OP.gearGtSmall.dat(ANY.Steel), 'G', OP.gearGt.dat(ANY.Steel), 'M', OP.casingMachine      .dat(ANY.Steel), 'L', OD.itemLubricant, 'A', aRegistry.getItem(24821));
		aRegistry.add(aMat.mNameLocal + " Transformer Gearbox", "Axles and Gearboxes", 24828, 24819, MultiTileEntityTransformerRotation.class, aMat.mToolQuality, 16, aMachine, UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS, 6.0F, NBT_RESISTANCE, 6.0F                       , NBT_INPUT   , V   [ 2], NBT_OUTPUT, V[ 1]  , NBT_MULTIPLIER, 4, NBT_WASTE_ENERGY, T, NBT_ENERGY_ACCEPTED, TD.Energy.RU, NBT_ENERGY_EMITTED, TD.Energy.RU), "ASL", "SGS", "MSA", 'S', OP.gearGtSmall.dat(ANY.Steel), 'G', OP.gearGt.dat(ANY.Steel), 'M', OP.casingMachineDouble.dat(ANY.Steel), 'L', OD.itemLubricant, 'A', aRegistry.getItem(24821));
		aRegistry.add("Custom " + aMat.mNameLocal + " Gearbox", "Axles and Gearboxes", 24829, 24819, MultiTileEntityGearBox.class            , aMat.mToolQuality, 16, aMachine, UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS, 6.0F, NBT_RESISTANCE, 6.0F                       , NBT_INPUT   , VMAX[ 2]                                                                                                                                  ), "wAL", "AMA"                                                                          , 'M', OP.casingMachine      .dat(ANY.Steel), 'L', OD.itemLubricant, 'A', aRegistry.getItem(24821));
		aMat = MT.Ti;
		aRegistry.add("Small "  + aMat.mNameLocal +    " Axle", "Axles and Gearboxes", 24830, 24819, aClass                                  , aMat.mToolQuality, 64, aMachine, UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS, 2.0F, NBT_RESISTANCE, 6.0F                       , NBT_PIPESIZE, VMAX[ 3], NBT_PIPEBANDWIDTH,     8, NBT_DIAMETER, PX_P[ 6]), "  S", " h ", "S f", 'S', OP.stick.dat(aMat));
		aRegistry.add("Medium " + aMat.mNameLocal +    " Axle", "Axles and Gearboxes", 24831, 24819, aClass                                  , aMat.mToolQuality, 64, aMachine, UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS, 2.0F, NBT_RESISTANCE, 6.0F                       , NBT_PIPESIZE, VMAX[ 3], NBT_PIPEBANDWIDTH,    16, NBT_DIAMETER, PX_P[ 9]), "  S", " h ", "S f", 'S', OP.stickLong.dat(aMat));
		aRegistry.add("Large "  + aMat.mNameLocal +    " Axle", "Axles and Gearboxes", 24832, 24819, aClass                                  , aMat.mToolQuality, 32, aMachine, UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS, 2.0F, NBT_RESISTANCE, 6.0F                       , NBT_PIPESIZE, VMAX[ 3], NBT_PIPEBANDWIDTH,    32, NBT_DIAMETER, PX_P[12]), "  S", " h ", "S f", 'S', OP.ingotDouble.dat(aMat));
		aRegistry.add("Huge "   + aMat.mNameLocal +    " Axle", "Axles and Gearboxes", 24833, 24819, aClass                                  , aMat.mToolQuality, 16, aMachine, UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS, 2.0F, NBT_RESISTANCE, 6.0F                       , NBT_PIPESIZE, VMAX[ 3], NBT_PIPEBANDWIDTH,    64, NBT_DIAMETER, PX_P[16]), "  S", " h ", "S f", 'S', OP.ingotQuadruple.dat(aMat));
		aRegistry.add(aMat.mNameLocal +     " Rotation Engine", "Axles and Gearboxes", 24837, 24819, MultiTileEntityEngineRotation.class     , aMat.mToolQuality, 16, aMachine, UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS, 6.0F, NBT_RESISTANCE, 6.0F                       , NBT_INPUT   , V   [ 3], NBT_OUTPUT, V[ 3]/2                   , NBT_WASTE_ENERGY, T, NBT_ENERGY_ACCEPTED, TD.Energy.RU, NBT_ENERGY_EMITTED, TD.Energy.KU), "SAS", "wML", "GAG", 'S', OP.gearGtSmall.dat(aMat), 'G', OP.gearGt.dat(aMat), 'M', OP.casingMachine      .dat(aMat), 'L', OD.itemLubricant, 'A', aRegistry.getItem(24831));
		aRegistry.add(aMat.mNameLocal + " Transformer Gearbox", "Axles and Gearboxes", 24838, 24819, MultiTileEntityTransformerRotation.class, aMat.mToolQuality, 16, aMachine, UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS, 6.0F, NBT_RESISTANCE, 6.0F                       , NBT_INPUT   , V   [ 3], NBT_OUTPUT, V[ 2]  , NBT_MULTIPLIER, 4, NBT_WASTE_ENERGY, T, NBT_ENERGY_ACCEPTED, TD.Energy.RU, NBT_ENERGY_EMITTED, TD.Energy.RU), "ASL", "SGS", "MSA", 'S', OP.gearGtSmall.dat(aMat), 'G', OP.gearGt.dat(aMat), 'M', OP.casingMachineDouble.dat(aMat), 'L', OD.itemLubricant, 'A', aRegistry.getItem(24831));
		aRegistry.add("Custom " + aMat.mNameLocal + " Gearbox", "Axles and Gearboxes", 24839, 24819, MultiTileEntityGearBox.class            , aMat.mToolQuality, 16, aMachine, UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS, 6.0F, NBT_RESISTANCE, 6.0F                       , NBT_INPUT   , VMAX[ 3]                                                                                                                                  ), "wAL", "AMA"                                                                , 'M', OP.casingMachine      .dat(aMat), 'L', OD.itemLubricant, 'A', aRegistry.getItem(24831));
		aMat = MT.TungstenSteel;
		aRegistry.add("Small "  + aMat.mNameLocal +    " Axle", "Axles and Gearboxes", 24840, 24819, aClass                                  , aMat.mToolQuality, 64, aMachine, UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS, 2.0F, NBT_RESISTANCE, 6.0F                       , NBT_PIPESIZE, VMAX[ 4], NBT_PIPEBANDWIDTH,    16, NBT_DIAMETER, PX_P[ 6]), "  S", " h ", "S f", 'S', OP.stick.dat(aMat));
		aRegistry.add("Medium " + aMat.mNameLocal +    " Axle", "Axles and Gearboxes", 24841, 24819, aClass                                  , aMat.mToolQuality, 64, aMachine, UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS, 2.0F, NBT_RESISTANCE, 6.0F                       , NBT_PIPESIZE, VMAX[ 4], NBT_PIPEBANDWIDTH,    32, NBT_DIAMETER, PX_P[ 9]), "  S", " h ", "S f", 'S', OP.stickLong.dat(aMat));
		aRegistry.add("Large "  + aMat.mNameLocal +    " Axle", "Axles and Gearboxes", 24842, 24819, aClass                                  , aMat.mToolQuality, 32, aMachine, UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS, 2.0F, NBT_RESISTANCE, 6.0F                       , NBT_PIPESIZE, VMAX[ 4], NBT_PIPEBANDWIDTH,    64, NBT_DIAMETER, PX_P[12]), "  S", " h ", "S f", 'S', OP.ingotDouble.dat(aMat));
		aRegistry.add("Huge "   + aMat.mNameLocal +    " Axle", "Axles and Gearboxes", 24843, 24819, aClass                                  , aMat.mToolQuality, 16, aMachine, UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS, 2.0F, NBT_RESISTANCE, 6.0F                       , NBT_PIPESIZE, VMAX[ 4], NBT_PIPEBANDWIDTH,   128, NBT_DIAMETER, PX_P[16]), "  S", " h ", "S f", 'S', OP.ingotQuadruple.dat(aMat));
		aRegistry.add(aMat.mNameLocal +     " Rotation Engine", "Axles and Gearboxes", 24847, 24819, MultiTileEntityEngineRotation.class     , aMat.mToolQuality, 16, aMachine, UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS, 6.0F, NBT_RESISTANCE, 6.0F                       , NBT_INPUT   , V   [ 4], NBT_OUTPUT, V[ 4]/2                   , NBT_WASTE_ENERGY, T, NBT_ENERGY_ACCEPTED, TD.Energy.RU, NBT_ENERGY_EMITTED, TD.Energy.KU), "SAS", "wML", "GAG", 'S', OP.gearGtSmall.dat(aMat), 'G', OP.gearGt.dat(aMat), 'M', OP.casingMachine      .dat(aMat), 'L', OD.itemLubricant, 'A', aRegistry.getItem(24841));
		aRegistry.add(aMat.mNameLocal + " Transformer Gearbox", "Axles and Gearboxes", 24848, 24819, MultiTileEntityTransformerRotation.class, aMat.mToolQuality, 16, aMachine, UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS, 6.0F, NBT_RESISTANCE, 6.0F                       , NBT_INPUT   , V   [ 4], NBT_OUTPUT, V[ 3]  , NBT_MULTIPLIER, 4, NBT_WASTE_ENERGY, T, NBT_ENERGY_ACCEPTED, TD.Energy.RU, NBT_ENERGY_EMITTED, TD.Energy.RU), "ASL", "SGS", "MSA", 'S', OP.gearGtSmall.dat(aMat), 'G', OP.gearGt.dat(aMat), 'M', OP.casingMachineDouble.dat(aMat), 'L', OD.itemLubricant, 'A', aRegistry.getItem(24841));
		aRegistry.add("Custom " + aMat.mNameLocal + " Gearbox", "Axles and Gearboxes", 24849, 24819, MultiTileEntityGearBox.class            , aMat.mToolQuality, 16, aMachine, UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS, 6.0F, NBT_RESISTANCE, 6.0F                       , NBT_INPUT   , VMAX[ 4]                                                                                                                                  ), "wAL", "AMA"                                                                , 'M', OP.casingMachine      .dat(aMat), 'L', OD.itemLubricant, 'A', aRegistry.getItem(24841));
		aMat = MT.Ir;
		aRegistry.add("Small "  + aMat.mNameLocal +    " Axle", "Axles and Gearboxes", 24850, 24819, aClass                                  , aMat.mToolQuality, 64, aMachine, UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS, 2.0F, NBT_RESISTANCE, 6.0F                       , NBT_PIPESIZE, VMAX[ 5], NBT_PIPEBANDWIDTH,    32, NBT_DIAMETER, PX_P[ 6]), "  S", " h ", "S f", 'S', OP.stick.dat(aMat));
		aRegistry.add("Medium " + aMat.mNameLocal +    " Axle", "Axles and Gearboxes", 24851, 24819, aClass                                  , aMat.mToolQuality, 64, aMachine, UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS, 2.0F, NBT_RESISTANCE, 6.0F                       , NBT_PIPESIZE, VMAX[ 5], NBT_PIPEBANDWIDTH,    64, NBT_DIAMETER, PX_P[ 9]), "  S", " h ", "S f", 'S', OP.stickLong.dat(aMat));
		aRegistry.add("Large "  + aMat.mNameLocal +    " Axle", "Axles and Gearboxes", 24852, 24819, aClass                                  , aMat.mToolQuality, 32, aMachine, UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS, 2.0F, NBT_RESISTANCE, 6.0F                       , NBT_PIPESIZE, VMAX[ 5], NBT_PIPEBANDWIDTH,   128, NBT_DIAMETER, PX_P[12]), "  S", " h ", "S f", 'S', OP.ingotDouble.dat(aMat));
		aRegistry.add("Huge "   + aMat.mNameLocal +    " Axle", "Axles and Gearboxes", 24853, 24819, aClass                                  , aMat.mToolQuality, 16, aMachine, UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS, 2.0F, NBT_RESISTANCE, 6.0F                       , NBT_PIPESIZE, VMAX[ 5], NBT_PIPEBANDWIDTH,   256, NBT_DIAMETER, PX_P[16]), "  S", " h ", "S f", 'S', OP.ingotQuadruple.dat(aMat));
		aRegistry.add(aMat.mNameLocal +     " Rotation Engine", "Axles and Gearboxes", 24857, 24819, MultiTileEntityEngineRotation.class     , aMat.mToolQuality, 16, aMachine, UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS, 6.0F, NBT_RESISTANCE, 6.0F                       , NBT_INPUT   , V   [ 5], NBT_OUTPUT, V[ 5]/2                   , NBT_WASTE_ENERGY, T, NBT_ENERGY_ACCEPTED, TD.Energy.RU, NBT_ENERGY_EMITTED, TD.Energy.KU), "SAS", "wML", "GAG", 'S', OP.gearGtSmall.dat(aMat), 'G', OP.gearGt.dat(aMat), 'M', OP.casingMachine      .dat(aMat), 'L', OD.itemLubricant, 'A', aRegistry.getItem(24851));
		aRegistry.add(aMat.mNameLocal + " Transformer Gearbox", "Axles and Gearboxes", 24858, 24819, MultiTileEntityTransformerRotation.class, aMat.mToolQuality, 16, aMachine, UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS, 6.0F, NBT_RESISTANCE, 6.0F                       , NBT_INPUT   , V   [ 5], NBT_OUTPUT, V[ 4]  , NBT_MULTIPLIER, 4, NBT_WASTE_ENERGY, T, NBT_ENERGY_ACCEPTED, TD.Energy.RU, NBT_ENERGY_EMITTED, TD.Energy.RU), "ASL", "SGS", "MSA", 'S', OP.gearGtSmall.dat(aMat), 'G', OP.gearGt.dat(aMat), 'M', OP.casingMachineDouble.dat(aMat), 'L', OD.itemLubricant, 'A', aRegistry.getItem(24851));
		aRegistry.add("Custom " + aMat.mNameLocal + " Gearbox", "Axles and Gearboxes", 24859, 24819, MultiTileEntityGearBox.class            , aMat.mToolQuality, 16, aMachine, UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS, 6.0F, NBT_RESISTANCE, 6.0F                       , NBT_INPUT   , VMAX[ 5]                                                                                                                                  ), "wAL", "AMA"                                                                , 'M', OP.casingMachine      .dat(aMat), 'L', OD.itemLubricant, 'A', aRegistry.getItem(24851));
		aMat = MT.Iritanium;
		aRegistry.add("Small "  + aMat.mNameLocal +    " Axle", "Axles and Gearboxes", 24860, 24819, aClass                                  , aMat.mToolQuality, 64, aMachine, UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS, 2.0F, NBT_RESISTANCE, 6.0F                       , NBT_PIPESIZE, VMAX[ 6], NBT_PIPEBANDWIDTH,    64, NBT_DIAMETER, PX_P[ 6]), "  S", " h ", "S f", 'S', OP.stick.dat(aMat));
		aRegistry.add("Medium " + aMat.mNameLocal +    " Axle", "Axles and Gearboxes", 24861, 24819, aClass                                  , aMat.mToolQuality, 64, aMachine, UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS, 2.0F, NBT_RESISTANCE, 6.0F                       , NBT_PIPESIZE, VMAX[ 6], NBT_PIPEBANDWIDTH,   128, NBT_DIAMETER, PX_P[ 9]), "  S", " h ", "S f", 'S', OP.stickLong.dat(aMat));
		aRegistry.add("Large "  + aMat.mNameLocal +    " Axle", "Axles and Gearboxes", 24862, 24819, aClass                                  , aMat.mToolQuality, 32, aMachine, UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS, 2.0F, NBT_RESISTANCE, 6.0F                       , NBT_PIPESIZE, VMAX[ 6], NBT_PIPEBANDWIDTH,   256, NBT_DIAMETER, PX_P[12]), "  S", " h ", "S f", 'S', OP.ingotDouble.dat(aMat));
		aRegistry.add("Huge "   + aMat.mNameLocal +    " Axle", "Axles and Gearboxes", 24863, 24819, aClass                                  , aMat.mToolQuality, 16, aMachine, UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS, 2.0F, NBT_RESISTANCE, 6.0F                       , NBT_PIPESIZE, VMAX[ 6], NBT_PIPEBANDWIDTH,   512, NBT_DIAMETER, PX_P[16]), "  S", " h ", "S f", 'S', OP.ingotQuadruple.dat(aMat));
		aRegistry.add(aMat.mNameLocal +     " Rotation Engine", "Axles and Gearboxes", 24867, 24819, MultiTileEntityEngineRotation.class     , aMat.mToolQuality, 16, aMachine, UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS, 6.0F, NBT_RESISTANCE, 6.0F                       , NBT_INPUT   , V   [ 6], NBT_OUTPUT, V[ 6]/2                   , NBT_WASTE_ENERGY, T, NBT_ENERGY_ACCEPTED, TD.Energy.RU, NBT_ENERGY_EMITTED, TD.Energy.KU), "SAS", "wML", "GAG", 'S', OP.gearGtSmall.dat(aMat), 'G', OP.gearGt.dat(aMat), 'M', OP.casingMachine      .dat(aMat), 'L', OD.itemLubricant, 'A', aRegistry.getItem(24861));
		aRegistry.add(aMat.mNameLocal + " Transformer Gearbox", "Axles and Gearboxes", 24868, 24819, MultiTileEntityTransformerRotation.class, aMat.mToolQuality, 16, aMachine, UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS, 6.0F, NBT_RESISTANCE, 6.0F                       , NBT_INPUT   , V   [ 6], NBT_OUTPUT, V[ 5]  , NBT_MULTIPLIER, 4, NBT_WASTE_ENERGY, T, NBT_ENERGY_ACCEPTED, TD.Energy.RU, NBT_ENERGY_EMITTED, TD.Energy.RU), "ASL", "SGS", "MSA", 'S', OP.gearGtSmall.dat(aMat), 'G', OP.gearGt.dat(aMat), 'M', OP.casingMachineDouble.dat(aMat), 'L', OD.itemLubricant, 'A', aRegistry.getItem(24861));
		aRegistry.add("Custom " + aMat.mNameLocal + " Gearbox", "Axles and Gearboxes", 24869, 24819, MultiTileEntityGearBox.class            , aMat.mToolQuality, 16, aMachine, UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS, 6.0F, NBT_RESISTANCE, 6.0F                       , NBT_INPUT   , VMAX[ 6]                                                                                                                                  ), "wAL", "AMA"                                                                , 'M', OP.casingMachine      .dat(aMat), 'L', OD.itemLubricant, 'A', aRegistry.getItem(24861));
		aMat = MT.Trinitanium;
		aRegistry.add("Small "  + aMat.mNameLocal +    " Axle", "Axles and Gearboxes", 24870, 24819, aClass                                  , aMat.mToolQuality, 64, aMachine, UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS, 2.0F, NBT_RESISTANCE, 6.0F                       , NBT_PIPESIZE, VMAX[ 7], NBT_PIPEBANDWIDTH,   128, NBT_DIAMETER, PX_P[ 6]), "  S", " h ", "S f", 'S', OP.stick.dat(aMat));
		aRegistry.add("Medium " + aMat.mNameLocal +    " Axle", "Axles and Gearboxes", 24871, 24819, aClass                                  , aMat.mToolQuality, 64, aMachine, UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS, 2.0F, NBT_RESISTANCE, 6.0F                       , NBT_PIPESIZE, VMAX[ 7], NBT_PIPEBANDWIDTH,   256, NBT_DIAMETER, PX_P[ 9]), "  S", " h ", "S f", 'S', OP.stickLong.dat(aMat));
		aRegistry.add("Large "  + aMat.mNameLocal +    " Axle", "Axles and Gearboxes", 24872, 24819, aClass                                  , aMat.mToolQuality, 32, aMachine, UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS, 2.0F, NBT_RESISTANCE, 6.0F                       , NBT_PIPESIZE, VMAX[ 7], NBT_PIPEBANDWIDTH,   512, NBT_DIAMETER, PX_P[12]), "  S", " h ", "S f", 'S', OP.ingotDouble.dat(aMat));
		aRegistry.add("Huge "   + aMat.mNameLocal +    " Axle", "Axles and Gearboxes", 24873, 24819, aClass                                  , aMat.mToolQuality, 16, aMachine, UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS, 2.0F, NBT_RESISTANCE, 6.0F                       , NBT_PIPESIZE, VMAX[ 7], NBT_PIPEBANDWIDTH,  1024, NBT_DIAMETER, PX_P[16]), "  S", " h ", "S f", 'S', OP.ingotQuadruple.dat(aMat));
		aRegistry.add(aMat.mNameLocal +     " Rotation Engine", "Axles and Gearboxes", 24877, 24819, MultiTileEntityEngineRotation.class     , aMat.mToolQuality, 16, aMachine, UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS, 6.0F, NBT_RESISTANCE, 6.0F                       , NBT_INPUT   , V   [ 7], NBT_OUTPUT, V[ 7]/2                   , NBT_WASTE_ENERGY, T, NBT_ENERGY_ACCEPTED, TD.Energy.RU, NBT_ENERGY_EMITTED, TD.Energy.KU), "SAS", "wML", "GAG", 'S', OP.gearGtSmall.dat(aMat), 'G', OP.gearGt.dat(aMat), 'M', OP.casingMachine      .dat(aMat), 'L', OD.itemLubricant, 'A', aRegistry.getItem(24871));
		aRegistry.add(aMat.mNameLocal + " Transformer Gearbox", "Axles and Gearboxes", 24878, 24819, MultiTileEntityTransformerRotation.class, aMat.mToolQuality, 16, aMachine, UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS, 6.0F, NBT_RESISTANCE, 6.0F                       , NBT_INPUT   , V   [ 7], NBT_OUTPUT, V[ 6]  , NBT_MULTIPLIER, 4, NBT_WASTE_ENERGY, T, NBT_ENERGY_ACCEPTED, TD.Energy.RU, NBT_ENERGY_EMITTED, TD.Energy.RU), "ASL", "SGS", "MSA", 'S', OP.gearGtSmall.dat(aMat), 'G', OP.gearGt.dat(aMat), 'M', OP.casingMachineDouble.dat(aMat), 'L', OD.itemLubricant, 'A', aRegistry.getItem(24871));
		aRegistry.add("Custom " + aMat.mNameLocal + " Gearbox", "Axles and Gearboxes", 24879, 24819, MultiTileEntityGearBox.class            , aMat.mToolQuality, 16, aMachine, UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS, 6.0F, NBT_RESISTANCE, 6.0F                       , NBT_INPUT   , VMAX[ 7]                                                                                                                                  ), "wAL", "AMA"                                                                , 'M', OP.casingMachine      .dat(aMat), 'L', OD.itemLubricant, 'A', aRegistry.getItem(24871));
		aMat = MT.Trinaquadalloy;
		aRegistry.add("Small "  + aMat.mNameLocal +    " Axle", "Axles and Gearboxes", 24880, 24819, aClass                                  , aMat.mToolQuality, 64, aMachine, UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS, 2.0F, NBT_RESISTANCE, 6.0F                       , NBT_PIPESIZE, VMAX[ 8], NBT_PIPEBANDWIDTH,   256, NBT_DIAMETER, PX_P[ 6]), "  S", " h ", "S f", 'S', OP.stick.dat(aMat));
		aRegistry.add("Medium " + aMat.mNameLocal +    " Axle", "Axles and Gearboxes", 24881, 24819, aClass                                  , aMat.mToolQuality, 64, aMachine, UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS, 2.0F, NBT_RESISTANCE, 6.0F                       , NBT_PIPESIZE, VMAX[ 8], NBT_PIPEBANDWIDTH,   512, NBT_DIAMETER, PX_P[ 9]), "  S", " h ", "S f", 'S', OP.stickLong.dat(aMat));
		aRegistry.add("Large "  + aMat.mNameLocal +    " Axle", "Axles and Gearboxes", 24882, 24819, aClass                                  , aMat.mToolQuality, 32, aMachine, UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS, 2.0F, NBT_RESISTANCE, 6.0F                       , NBT_PIPESIZE, VMAX[ 8], NBT_PIPEBANDWIDTH,  1024, NBT_DIAMETER, PX_P[12]), "  S", " h ", "S f", 'S', OP.ingotDouble.dat(aMat));
		aRegistry.add("Huge "   + aMat.mNameLocal +    " Axle", "Axles and Gearboxes", 24883, 24819, aClass                                  , aMat.mToolQuality, 16, aMachine, UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS, 2.0F, NBT_RESISTANCE, 6.0F                       , NBT_PIPESIZE, VMAX[ 8], NBT_PIPEBANDWIDTH,  2048, NBT_DIAMETER, PX_P[16]), "  S", " h ", "S f", 'S', OP.ingotQuadruple.dat(aMat));
		aRegistry.add(aMat.mNameLocal +     " Rotation Engine", "Axles and Gearboxes", 24887, 24819, MultiTileEntityEngineRotation.class     , aMat.mToolQuality, 16, aMachine, UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS, 6.0F, NBT_RESISTANCE, 6.0F                       , NBT_INPUT   , V   [ 8], NBT_OUTPUT, V[ 8]/2                   , NBT_WASTE_ENERGY, T, NBT_ENERGY_ACCEPTED, TD.Energy.RU, NBT_ENERGY_EMITTED, TD.Energy.KU), "SAS", "wML", "GAG", 'S', OP.gearGtSmall.dat(aMat), 'G', OP.gearGt.dat(aMat), 'M', OP.casingMachine      .dat(aMat), 'L', OD.itemLubricant, 'A', aRegistry.getItem(24881));
		aRegistry.add(aMat.mNameLocal + " Transformer Gearbox", "Axles and Gearboxes", 24888, 24819, MultiTileEntityTransformerRotation.class, aMat.mToolQuality, 16, aMachine, UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS, 6.0F, NBT_RESISTANCE, 6.0F                       , NBT_INPUT   , V   [ 8], NBT_OUTPUT, V[ 7]  , NBT_MULTIPLIER, 4, NBT_WASTE_ENERGY, T, NBT_ENERGY_ACCEPTED, TD.Energy.RU, NBT_ENERGY_EMITTED, TD.Energy.RU), "ASL", "SGS", "MSA", 'S', OP.gearGtSmall.dat(aMat), 'G', OP.gearGt.dat(aMat), 'M', OP.casingMachineDouble.dat(aMat), 'L', OD.itemLubricant, 'A', aRegistry.getItem(24881));
		aRegistry.add("Custom " + aMat.mNameLocal + " Gearbox", "Axles and Gearboxes", 24889, 24819, MultiTileEntityGearBox.class            , aMat.mToolQuality, 16, aMachine, UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS, 6.0F, NBT_RESISTANCE, 6.0F                       , NBT_INPUT   , VMAX[ 8]                                                                                                                                  ), "wAL", "AMA"                                                                , 'M', OP.casingMachine      .dat(aMat), 'L', OD.itemLubricant, 'A', aRegistry.getItem(24881));
		aMat = MT.Ad;
		aRegistry.add("Small "  + aMat.mNameLocal +    " Axle", "Axles and Gearboxes", 24890, 24819, aClass                                  , aMat.mToolQuality, 64, aMachine, UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS, 2.0F, NBT_RESISTANCE, 6.0F                       , NBT_PIPESIZE, VMAX[ 9], NBT_PIPEBANDWIDTH,   512, NBT_DIAMETER, PX_P[ 6]), "  S", " h ", "S f", 'S', OP.stick.dat(aMat));
		aRegistry.add("Medium " + aMat.mNameLocal +    " Axle", "Axles and Gearboxes", 24891, 24819, aClass                                  , aMat.mToolQuality, 64, aMachine, UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS, 2.0F, NBT_RESISTANCE, 6.0F                       , NBT_PIPESIZE, VMAX[ 9], NBT_PIPEBANDWIDTH,  1024, NBT_DIAMETER, PX_P[ 9]), "  S", " h ", "S f", 'S', OP.stickLong.dat(aMat));
		aRegistry.add("Large "  + aMat.mNameLocal +    " Axle", "Axles and Gearboxes", 24892, 24819, aClass                                  , aMat.mToolQuality, 32, aMachine, UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS, 2.0F, NBT_RESISTANCE, 6.0F                       , NBT_PIPESIZE, VMAX[ 9], NBT_PIPEBANDWIDTH,  2048, NBT_DIAMETER, PX_P[12]), "  S", " h ", "S f", 'S', OP.ingotDouble.dat(aMat));
		aRegistry.add("Huge "   + aMat.mNameLocal +    " Axle", "Axles and Gearboxes", 24893, 24819, aClass                                  , aMat.mToolQuality, 16, aMachine, UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS, 2.0F, NBT_RESISTANCE, 6.0F                       , NBT_PIPESIZE, VMAX[ 9], NBT_PIPEBANDWIDTH,  4096, NBT_DIAMETER, PX_P[16]), "  S", " h ", "S f", 'S', OP.ingotQuadruple.dat(aMat));
		aRegistry.add(aMat.mNameLocal +     " Rotation Engine", "Axles and Gearboxes", 24897, 24819, MultiTileEntityEngineRotation.class     , aMat.mToolQuality, 16, aMachine, UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS, 6.0F, NBT_RESISTANCE, 6.0F                       , NBT_INPUT   , V   [ 9], NBT_OUTPUT, V[ 9]/2                   , NBT_WASTE_ENERGY, T, NBT_ENERGY_ACCEPTED, TD.Energy.RU, NBT_ENERGY_EMITTED, TD.Energy.KU), "SAS", "wML", "GAG", 'S', OP.gearGtSmall.dat(aMat), 'G', OP.gearGt.dat(aMat), 'M', OP.casingMachine      .dat(aMat), 'L', OD.itemLubricant, 'A', aRegistry.getItem(24891));
		aRegistry.add(aMat.mNameLocal + " Transformer Gearbox", "Axles and Gearboxes", 24898, 24819, MultiTileEntityTransformerRotation.class, aMat.mToolQuality, 16, aMachine, UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS, 6.0F, NBT_RESISTANCE, 6.0F                       , NBT_INPUT   , V   [ 9], NBT_OUTPUT, V[ 8]  , NBT_MULTIPLIER, 4, NBT_WASTE_ENERGY, T, NBT_ENERGY_ACCEPTED, TD.Energy.RU, NBT_ENERGY_EMITTED, TD.Energy.RU), "ASL", "SGS", "MSA", 'S', OP.gearGtSmall.dat(aMat), 'G', OP.gearGt.dat(aMat), 'M', OP.casingMachineDouble.dat(aMat), 'L', OD.itemLubricant, 'A', aRegistry.getItem(24891));
		aRegistry.add("Custom " + aMat.mNameLocal + " Gearbox", "Axles and Gearboxes", 24899, 24819, MultiTileEntityGearBox.class            , aMat.mToolQuality, 16, aMachine, UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS, 6.0F, NBT_RESISTANCE, 6.0F                       , NBT_INPUT   , VMAX[ 9]                                                                                                                                  ), "wAL", "AMA"                                                                , 'M', OP.casingMachine      .dat(aMat), 'L', OD.itemLubricant, 'A', aRegistry.getItem(24891));
	}
	
	private static void connectors(MultiTileEntityRegistry aRegistry, MultiTileEntityBlock aMetal, MultiTileEntityBlock aMetalChips, MultiTileEntityBlock aMetalWires, MultiTileEntityBlock aMachine, MultiTileEntityBlock aWooden, MultiTileEntityBlock aBush, MultiTileEntityBlock aStone, MultiTileEntityBlock aWool, MultiTileEntityBlock aTNT, MultiTileEntityBlock aHive, MultiTileEntityBlock aUtilMetal, MultiTileEntityBlock aUtilStone, MultiTileEntityBlock aUtilWood, MultiTileEntityBlock aUtilWool, OreDictMaterial aMat, Class<? extends TileEntity> aClass) {
		aMat = MT.Wax;               OreDictManager.INSTANCE.setTarget_(OP.capcellcon, aMat, aRegistry.add("Capsule-Cell-Container ("+aMat.getLocal()+")", "Fluid Containers", 32600, 32719, MultiTileEntityCell.class, 0, 64, aUtilWood    , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   0.5F, NBT_RESISTANCE,   6.0F, NBT_TANK_CAPACITY, 1000, NBT_PLASMAPROOF, F, NBT_GASPROOF, T, NBT_ACIDPROOF, F, NBT_MAGICPROOF, F, NBT_TEMPERATURE, aMat.mMeltingPoint-10 )), T, F, T);
		aMat = MT.WaxBee;            OreDictManager.INSTANCE.setTarget_(OP.capcellcon, aMat, aRegistry.add("Capsule-Cell-Container ("+aMat.getLocal()+")", "Fluid Containers", 32601, 32719, MultiTileEntityCell.class, 0, 64, aUtilWood    , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   0.5F, NBT_RESISTANCE,   6.0F, NBT_TANK_CAPACITY, 1000, NBT_PLASMAPROOF, F, NBT_GASPROOF, T, NBT_ACIDPROOF, F, NBT_MAGICPROOF, F, NBT_TEMPERATURE, aMat.mMeltingPoint-10 )), T, F, T);
		aMat = MT.WaxPlant;          OreDictManager.INSTANCE.setTarget_(OP.capcellcon, aMat, aRegistry.add("Capsule-Cell-Container ("+aMat.getLocal()+")", "Fluid Containers", 32602, 32719, MultiTileEntityCell.class, 0, 64, aUtilWood    , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   0.5F, NBT_RESISTANCE,   6.0F, NBT_TANK_CAPACITY, 1000, NBT_PLASMAPROOF, F, NBT_GASPROOF, T, NBT_ACIDPROOF, F, NBT_MAGICPROOF, F, NBT_TEMPERATURE, aMat.mMeltingPoint-10 )), T, F, T);
		aMat = MT.WaxParaffin;       OreDictManager.INSTANCE.setTarget_(OP.capcellcon, aMat, aRegistry.add("Capsule-Cell-Container ("+aMat.getLocal()+")", "Fluid Containers", 32603, 32719, MultiTileEntityCell.class, 0, 64, aUtilWood    , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   0.5F, NBT_RESISTANCE,   6.0F, NBT_TANK_CAPACITY, 1000, NBT_PLASMAPROOF, F, NBT_GASPROOF, T, NBT_ACIDPROOF, F, NBT_MAGICPROOF, F, NBT_TEMPERATURE, aMat.mMeltingPoint-10 )), T, F, T);
		aMat = MT.WaxRefractory;     OreDictManager.INSTANCE.setTarget_(OP.capcellcon, aMat, aRegistry.add("Capsule-Cell-Container ("+aMat.getLocal()+")", "Fluid Containers", 32604, 32719, MultiTileEntityCell.class, 0, 64, aUtilWood    , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   0.5F, NBT_RESISTANCE,   6.0F, NBT_TANK_CAPACITY, 1000, NBT_PLASMAPROOF, F, NBT_GASPROOF, T, NBT_ACIDPROOF, T, NBT_MAGICPROOF, F, NBT_TEMPERATURE, aMat.mMeltingPoint-10 )), T, F, T);
		aMat = MT.WaxMagic;          OreDictManager.INSTANCE.setTarget_(OP.capcellcon, aMat, aRegistry.add("Capsule-Cell-Container ("+aMat.getLocal()+")", "Fluid Containers", 32605, 32719, MultiTileEntityCell.class, 0, 64, aUtilWood    , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   0.5F, NBT_RESISTANCE,   6.0F, NBT_TANK_CAPACITY, 1000, NBT_PLASMAPROOF, F, NBT_GASPROOF, T, NBT_ACIDPROOF, T, NBT_MAGICPROOF, T, NBT_TEMPERATURE, 2700                  )), T, F, T);
		aMat = MT.WaxAmnesic;        OreDictManager.INSTANCE.setTarget_(OP.capcellcon, aMat, aRegistry.add("Capsule-Cell-Container ("+aMat.getLocal()+")", "Fluid Containers", 32624, 32719, MultiTileEntityCell.class, 0, 64, aUtilWood    , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   0.5F, NBT_RESISTANCE,   6.0F, NBT_TANK_CAPACITY, 1000, NBT_PLASMAPROOF, F, NBT_GASPROOF, T, NBT_ACIDPROOF, T, NBT_MAGICPROOF, T, NBT_TEMPERATURE, 2700                  )), T, F, T);
		aMat = MT.WaxSoulful;        OreDictManager.INSTANCE.setTarget_(OP.capcellcon, aMat, aRegistry.add("Capsule-Cell-Container ("+aMat.getLocal()+")", "Fluid Containers", 32625, 32719, MultiTileEntityCell.class, 0, 64, aUtilWood    , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   0.5F, NBT_RESISTANCE,   6.0F, NBT_TANK_CAPACITY, 1000, NBT_PLASMAPROOF, F, NBT_GASPROOF, T, NBT_ACIDPROOF, T, NBT_MAGICPROOF, T, NBT_TEMPERATURE, aMat.mMeltingPoint-10 )), T, F, T);
		aMat = MT.Plastic;           OreDictManager.INSTANCE.setTarget_(OP.capcellcon, aMat, aRegistry.add("Capsule-Cell-Container ("+aMat.getLocal()+")", "Fluid Containers", 32606, 32719, MultiTileEntityCell.class, 0, 64, aUtilWood    , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   0.5F, NBT_RESISTANCE,   6.0F, NBT_TANK_CAPACITY, 1000, NBT_PLASMAPROOF, F, NBT_GASPROOF, T, NBT_ACIDPROOF, F, NBT_MAGICPROOF, F, NBT_TEMPERATURE, aMat.mMeltingPoint-10 )), T, F, T);
		aMat = MT.Sn;                OreDictManager.INSTANCE.setTarget_(OP.capcellcon, aMat, aRegistry.add("Capsule-Cell-Container ("+aMat.getLocal()+")", "Fluid Containers", 32607, 32719, MultiTileEntityCell.class, 0, 64, aUtilMetal   , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   0.5F, NBT_RESISTANCE,   6.0F, NBT_TANK_CAPACITY, 1000, NBT_PLASMAPROOF, F, NBT_GASPROOF, T, NBT_ACIDPROOF, F, NBT_MAGICPROOF, F, NBT_TEMPERATURE, aMat.mMeltingPoint-50 )), T, F, T);
		aMat = MT.TinAlloy;          OreDictManager.INSTANCE.setTarget_(OP.capcellcon, aMat, aRegistry.add("Capsule-Cell-Container ("+aMat.getLocal()+")", "Fluid Containers", 32608, 32719, MultiTileEntityCell.class, 0, 64, aUtilMetal   , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   0.5F, NBT_RESISTANCE,   6.0F, NBT_TANK_CAPACITY, 1000, NBT_PLASMAPROOF, F, NBT_GASPROOF, T, NBT_ACIDPROOF, F, NBT_MAGICPROOF, F, NBT_TEMPERATURE, aMat.mMeltingPoint-50 )), T, F, T);
		aMat = MT.Invar;             OreDictManager.INSTANCE.setTarget_(OP.capcellcon, aMat, aRegistry.add("Capsule-Cell-Container ("+aMat.getLocal()+")", "Fluid Containers", 32609, 32719, MultiTileEntityCell.class, 0, 64, aUtilMetal   , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   0.5F, NBT_RESISTANCE,   6.0F, NBT_TANK_CAPACITY, 1000, NBT_PLASMAPROOF, F, NBT_GASPROOF, T, NBT_ACIDPROOF, F, NBT_MAGICPROOF, F, NBT_TEMPERATURE, aMat.mMeltingPoint-50 )), T, F, T);
		aMat = MT.Au;                OreDictManager.INSTANCE.setTarget_(OP.capcellcon, aMat, aRegistry.add("Capsule-Cell-Container ("+aMat.getLocal()+")", "Fluid Containers", 32635, 32719, MultiTileEntityCell.class, 0, 64, aUtilMetal   , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   0.5F, NBT_RESISTANCE,   6.0F, NBT_TANK_CAPACITY, 1000, NBT_PLASMAPROOF, F, NBT_GASPROOF, T, NBT_ACIDPROOF, T, NBT_MAGICPROOF, F, NBT_TEMPERATURE, aMat.mMeltingPoint-50 )), T, F, T);
		aMat = MT.Al;                OreDictManager.INSTANCE.setTarget_(OP.capcellcon, aMat, aRegistry.add("Capsule-Cell-Container ("+aMat.getLocal()+")", "Fluid Containers", 32610, 32719, MultiTileEntityCell.class, 0, 64, aUtilMetal   , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   0.5F, NBT_RESISTANCE,   6.0F, NBT_TANK_CAPACITY, 1000, NBT_PLASMAPROOF, F, NBT_GASPROOF, T, NBT_ACIDPROOF, F, NBT_MAGICPROOF, F, NBT_TEMPERATURE, aMat.mMeltingPoint-50 )), T, F, T);
		aMat = MT.StainlessSteel;    OreDictManager.INSTANCE.setTarget_(OP.capcellcon, aMat, aRegistry.add("Capsule-Cell-Container ("+aMat.getLocal()+")", "Fluid Containers", 32611, 32719, MultiTileEntityCell.class, 0, 64, aUtilMetal   , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   0.5F, NBT_RESISTANCE,   6.0F, NBT_TANK_CAPACITY, 1000, NBT_PLASMAPROOF, F, NBT_GASPROOF, T, NBT_ACIDPROOF, T, NBT_MAGICPROOF, F, NBT_TEMPERATURE, aMat.mMeltingPoint-50 )), T, F, T);
		aMat = MT.TungstenAlloy;     OreDictManager.INSTANCE.setTarget_(OP.capcellcon, aMat, aRegistry.add("Capsule-Cell-Container ("+aMat.getLocal()+")", "Fluid Containers", 32636, 32719, MultiTileEntityCell.class, 0, 64, aUtilMetal   , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   0.5F, NBT_RESISTANCE,   6.0F, NBT_TANK_CAPACITY, 1000, NBT_PLASMAPROOF, F, NBT_GASPROOF, T, NBT_ACIDPROOF, F, NBT_MAGICPROOF, T, NBT_TEMPERATURE, aMat.mMeltingPoint-50 )), T, F, T);
		aMat = MT.Ti;                OreDictManager.INSTANCE.setTarget_(OP.capcellcon, aMat, aRegistry.add("Capsule-Cell-Container ("+aMat.getLocal()+")", "Fluid Containers", 32612, 32719, MultiTileEntityCell.class, 0, 64, aUtilMetal   , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   0.5F, NBT_RESISTANCE,   6.0F, NBT_TANK_CAPACITY, 1000, NBT_PLASMAPROOF, F, NBT_GASPROOF, T, NBT_ACIDPROOF, F, NBT_MAGICPROOF, F, NBT_TEMPERATURE, aMat.mMeltingPoint-50 )), T, F, T);
		aMat = MT.Netherite;         OreDictManager.INSTANCE.setTarget_(OP.capcellcon, aMat, aRegistry.add("Capsule-Cell-Container ("+aMat.getLocal()+")", "Fluid Containers", 32634, 32719, MultiTileEntityCell.class, 0, 64, aUtilMetal   , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   0.5F, NBT_RESISTANCE,   6.0F, NBT_TANK_CAPACITY, 1000, NBT_PLASMAPROOF, T, NBT_GASPROOF, T, NBT_ACIDPROOF, T, NBT_MAGICPROOF, T, NBT_TEMPERATURE, aMat.mMeltingPoint-50 )), T, F, T);
		aMat = MT.TungstenSteel;     OreDictManager.INSTANCE.setTarget_(OP.capcellcon, aMat, aRegistry.add("Capsule-Cell-Container ("+aMat.getLocal()+")", "Fluid Containers", 32613, 32719, MultiTileEntityCell.class, 0, 64, aUtilMetal   , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   0.5F, NBT_RESISTANCE,   6.0F, NBT_TANK_CAPACITY, 1000, NBT_PLASMAPROOF, F, NBT_GASPROOF, T, NBT_ACIDPROOF, F, NBT_MAGICPROOF, T, NBT_TEMPERATURE, aMat.mMeltingPoint-50 )), T, F, T);
		aMat = MT.TungstenCarbide;   OreDictManager.INSTANCE.setTarget_(OP.capcellcon, aMat, aRegistry.add("Capsule-Cell-Container ("+aMat.getLocal()+")", "Fluid Containers", 32614, 32719, MultiTileEntityCell.class, 0, 64, aUtilMetal   , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   0.5F, NBT_RESISTANCE,   6.0F, NBT_TANK_CAPACITY, 1000, NBT_PLASMAPROOF, F, NBT_GASPROOF, T, NBT_ACIDPROOF, F, NBT_MAGICPROOF, T, NBT_TEMPERATURE, aMat.mMeltingPoint-50 )), T, F, T);
		aMat = MT.W;                 OreDictManager.INSTANCE.setTarget_(OP.capcellcon, aMat, aRegistry.add("Capsule-Cell-Container ("+aMat.getLocal()+")", "Fluid Containers", 32615, 32719, MultiTileEntityCell.class, 0, 64, aUtilMetal   , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   0.5F, NBT_RESISTANCE,   6.0F, NBT_TANK_CAPACITY, 1000, NBT_PLASMAPROOF, F, NBT_GASPROOF, T, NBT_ACIDPROOF, T, NBT_MAGICPROOF, T, NBT_TEMPERATURE, aMat.mMeltingPoint-50 )), T, F, T);
		aMat = MT.Pd;                OreDictManager.INSTANCE.setTarget_(OP.capcellcon, aMat, aRegistry.add("Capsule-Cell-Container ("+aMat.getLocal()+")", "Fluid Containers", 32639, 32719, MultiTileEntityCell.class, 0, 64, aUtilMetal   , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   0.5F, NBT_RESISTANCE,   6.0F, NBT_TANK_CAPACITY, 1000, NBT_PLASMAPROOF, F, NBT_GASPROOF, T, NBT_ACIDPROOF, F, NBT_MAGICPROOF, T, NBT_TEMPERATURE, aMat.mMeltingPoint-50 )), T, F, T);
		aMat = MT.Ta4HfC5;           OreDictManager.INSTANCE.setTarget_(OP.capcellcon, aMat, aRegistry.add("Capsule-Cell-Container ("+aMat.getLocal()+")", "Fluid Containers", 32633, 32719, MultiTileEntityCell.class, 0, 64, aUtilMetal   , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   0.5F, NBT_RESISTANCE,   6.0F, NBT_TANK_CAPACITY, 1000, NBT_PLASMAPROOF, F, NBT_GASPROOF, T, NBT_ACIDPROOF, F, NBT_MAGICPROOF, T, NBT_TEMPERATURE, aMat.mMeltingPoint-50 )), T, F, T);
		aMat = MT.Desh;              OreDictManager.INSTANCE.setTarget_(OP.capcellcon, aMat, aRegistry.add("Capsule-Cell-Container ("+aMat.getLocal()+")", "Fluid Containers", 32632, 32719, MultiTileEntityCell.class, 0, 64, aUtilMetal   , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   0.5F, NBT_RESISTANCE,   6.0F, NBT_TANK_CAPACITY, 1000, NBT_PLASMAPROOF, F, NBT_GASPROOF, T, NBT_ACIDPROOF, F, NBT_MAGICPROOF, T, NBT_TEMPERATURE, aMat.mMeltingPoint-50 )), T, F, T);
		aMat = MT.DeshAlloy;         OreDictManager.INSTANCE.setTarget_(OP.capcellcon, aMat, aRegistry.add("Capsule-Cell-Container ("+aMat.getLocal()+")", "Fluid Containers", 32638, 32719, MultiTileEntityCell.class, 0, 64, aUtilMetal   , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   0.5F, NBT_RESISTANCE,   6.0F, NBT_TANK_CAPACITY, 1000, NBT_PLASMAPROOF, F, NBT_GASPROOF, T, NBT_ACIDPROOF, F, NBT_MAGICPROOF, T, NBT_TEMPERATURE, aMat.mMeltingPoint-50 )), T, F, T);
		aMat = MT.Ke;                OreDictManager.INSTANCE.setTarget_(OP.capcellcon, aMat, aRegistry.add("Capsule-Cell-Container ("+aMat.getLocal()+")", "Fluid Containers", 32616, 32719, MultiTileEntityCell.class, 0, 64, aUtilMetal   , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   0.5F, NBT_RESISTANCE,   6.0F, NBT_TANK_CAPACITY, 1000, NBT_PLASMAPROOF, F, NBT_GASPROOF, T, NBT_ACIDPROOF, F, NBT_MAGICPROOF, T, NBT_TEMPERATURE, aMat.mMeltingPoint-50 )), T, F, T);
		aMat = MT.Trinitanium;       OreDictManager.INSTANCE.setTarget_(OP.capcellcon, aMat, aRegistry.add("Capsule-Cell-Container ("+aMat.getLocal()+")", "Fluid Containers", 32617, 32719, MultiTileEntityCell.class, 0, 64, aUtilMetal   , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   0.5F, NBT_RESISTANCE,   6.0F, NBT_TANK_CAPACITY, 1000, NBT_PLASMAPROOF, T, NBT_GASPROOF, T, NBT_ACIDPROOF, F, NBT_MAGICPROOF, T, NBT_TEMPERATURE, aMat.mMeltingPoint-50 )), T, F, T);
		aMat = MT.Ad;                OreDictManager.INSTANCE.setTarget_(OP.capcellcon, aMat, aRegistry.add("Capsule-Cell-Container ("+aMat.getLocal()+")", "Fluid Containers", 32618, 32719, MultiTileEntityCell.class, 0, 64, aUtilMetal   , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   0.5F, NBT_RESISTANCE,   6.0F, NBT_TANK_CAPACITY, 1000, NBT_PLASMAPROOF, T, NBT_GASPROOF, T, NBT_ACIDPROOF, T, NBT_MAGICPROOF, T, NBT_TEMPERATURE, aMat.mMeltingPoint-50 )), T, F, T);
		aMat = MT.Syrmorite;         OreDictManager.INSTANCE.setTarget_(OP.capcellcon, aMat, aRegistry.add("Capsule-Cell-Container ("+aMat.getLocal()+")", "Fluid Containers", 32626, 32719, MultiTileEntityCell.class, 0, 64, aUtilMetal   , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   0.5F, NBT_RESISTANCE,   6.0F, NBT_TANK_CAPACITY, 1000, NBT_PLASMAPROOF, F, NBT_GASPROOF, T, NBT_ACIDPROOF, F, NBT_MAGICPROOF, T, NBT_TEMPERATURE, aMat.mMeltingPoint-50 )), T, F, T);
		aMat = MT.Efrine;            OreDictManager.INSTANCE.setTarget_(OP.capcellcon, aMat, aRegistry.add("Capsule-Cell-Container ("+aMat.getLocal()+")", "Fluid Containers", 32637, 32719, MultiTileEntityCell.class, 0, 64, aUtilMetal   , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   0.5F, NBT_RESISTANCE,   6.0F, NBT_TANK_CAPACITY, 1000, NBT_PLASMAPROOF, T, NBT_GASPROOF, T, NBT_ACIDPROOF, F, NBT_MAGICPROOF, T, NBT_TEMPERATURE, aMat.mMeltingPoint-50 )), T, F, T);
		aMat = MT.Thaumium;          OreDictManager.INSTANCE.setTarget_(OP.capcellcon, aMat, aRegistry.add("Capsule-Cell-Container ("+aMat.getLocal()+")", "Fluid Containers", 32619, 32719, MultiTileEntityCell.class, 0, 64, aUtilMetal   , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   0.5F, NBT_RESISTANCE,   6.0F, NBT_TANK_CAPACITY, 1000, NBT_PLASMAPROOF, F, NBT_GASPROOF, T, NBT_ACIDPROOF, T, NBT_MAGICPROOF, T, NBT_TEMPERATURE, aMat.mMeltingPoint-50 )), T, F, T);
		aMat = MT.VoidMetal;         OreDictManager.INSTANCE.setTarget_(OP.capcellcon, aMat, aRegistry.add("Capsule-Cell-Container ("+aMat.getLocal()+")", "Fluid Containers", 32620, 32719, MultiTileEntityCell.class, 0, 64, aUtilMetal   , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   0.5F, NBT_RESISTANCE,   6.0F, NBT_TANK_CAPACITY, 1000, NBT_PLASMAPROOF, T, NBT_GASPROOF, T, NBT_ACIDPROOF, T, NBT_MAGICPROOF, T, NBT_TEMPERATURE, aMat.mMeltingPoint-50 )), T, F, T);
		aMat = MT.Manasteel;         OreDictManager.INSTANCE.setTarget_(OP.capcellcon, aMat, aRegistry.add("Capsule-Cell-Container ("+aMat.getLocal()+")", "Fluid Containers", 32627, 32719, MultiTileEntityCell.class, 0, 64, aUtilMetal   , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   0.5F, NBT_RESISTANCE,   6.0F, NBT_TANK_CAPACITY, 1000, NBT_PLASMAPROOF, F, NBT_GASPROOF, T, NBT_ACIDPROOF, T, NBT_MAGICPROOF, T, NBT_TEMPERATURE, aMat.mMeltingPoint-50 )), T, F, T);
		aMat = MT.Terrasteel;        OreDictManager.INSTANCE.setTarget_(OP.capcellcon, aMat, aRegistry.add("Capsule-Cell-Container ("+aMat.getLocal()+")", "Fluid Containers", 32628, 32719, MultiTileEntityCell.class, 0, 64, aUtilMetal   , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   0.5F, NBT_RESISTANCE,   6.0F, NBT_TANK_CAPACITY, 1000, NBT_PLASMAPROOF, F, NBT_GASPROOF, T, NBT_ACIDPROOF, T, NBT_MAGICPROOF, T, NBT_TEMPERATURE, aMat.mMeltingPoint-50 )), T, F, T);
		aMat = MT.ElvenElementium;   OreDictManager.INSTANCE.setTarget_(OP.capcellcon, aMat, aRegistry.add("Capsule-Cell-Container ("+aMat.getLocal()+")", "Fluid Containers", 32629, 32719, MultiTileEntityCell.class, 0, 64, aUtilMetal   , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   0.5F, NBT_RESISTANCE,   6.0F, NBT_TANK_CAPACITY, 1000, NBT_PLASMAPROOF, F, NBT_GASPROOF, T, NBT_ACIDPROOF, T, NBT_MAGICPROOF, T, NBT_TEMPERATURE, aMat.mMeltingPoint-50 )), T, F, T);
		aMat = MT.GaiaSpirit;        OreDictManager.INSTANCE.setTarget_(OP.capcellcon, aMat, aRegistry.add("Capsule-Cell-Container ("+aMat.getLocal()+")", "Fluid Containers", 32630, 32719, MultiTileEntityCell.class, 0, 64, aUtilMetal   , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   0.5F, NBT_RESISTANCE,   6.0F, NBT_TANK_CAPACITY, 1000, NBT_PLASMAPROOF, T, NBT_GASPROOF, T, NBT_ACIDPROOF, T, NBT_MAGICPROOF, T, NBT_TEMPERATURE, aMat.mMeltingPoint-50 )), T, F, T);
		aMat = MT.DuraniumAlloy;     OreDictManager.INSTANCE.setTarget_(OP.capcellcon, aMat, aRegistry.add("Capsule-Cell-Container ("+aMat.getLocal()+")", "Fluid Containers", 32621, 32719, MultiTileEntityCell.class, 0, 64, aUtilMetal   , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   0.5F, NBT_RESISTANCE,   6.0F, NBT_TANK_CAPACITY, 1000, NBT_PLASMAPROOF, T, NBT_GASPROOF, T, NBT_ACIDPROOF, T, NBT_MAGICPROOF, T, NBT_TEMPERATURE, aMat.mMeltingPoint-50 )), T, F, T);
		aMat = MT.Draconium;         OreDictManager.INSTANCE.setTarget_(OP.capcellcon, aMat, aRegistry.add("Capsule-Cell-Container ("+aMat.getLocal()+")", "Fluid Containers", 32622, 32719, MultiTileEntityCell.class, 0, 64, aUtilMetal   , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   0.5F, NBT_RESISTANCE,   6.0F, NBT_TANK_CAPACITY, 1000, NBT_PLASMAPROOF, T, NBT_GASPROOF, T, NBT_ACIDPROOF, T, NBT_MAGICPROOF, T, NBT_TEMPERATURE, aMat.mMeltingPoint-50 )), T, F, T);
		aMat = MT.DraconiumAwakened; OreDictManager.INSTANCE.setTarget_(OP.capcellcon, aMat, aRegistry.add("Capsule-Cell-Container ("+aMat.getLocal()+")", "Fluid Containers", 32623, 32719, MultiTileEntityCell.class, 0, 64, aUtilMetal   , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   0.5F, NBT_RESISTANCE,   6.0F, NBT_TANK_CAPACITY, 1000, NBT_PLASMAPROOF, T, NBT_GASPROOF, T, NBT_ACIDPROOF, T, NBT_MAGICPROOF, T, NBT_TEMPERATURE, aMat.mMeltingPoint-50 )), T, F, T);
		aMat = MT.Infinity;          OreDictManager.INSTANCE.setTarget_(OP.capcellcon, aMat, aRegistry.add("Capsule-Cell-Container ("+aMat.getLocal()+")", "Fluid Containers", 32631, 32719, MultiTileEntityCell.class, 0, 64, aUtilMetal   , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   0.5F, NBT_RESISTANCE,   6.0F, NBT_TANK_CAPACITY, 1000, NBT_PLASMAPROOF, T, NBT_GASPROOF, T, NBT_ACIDPROOF, T, NBT_MAGICPROOF, T, NBT_TEMPERATURE, Integer.MAX_VALUE     )), T, F, T);
		// 32640 is next
		
		
		
		aClass = MultiTileEntityWireLaser.class;
		aRegistry.add("Laser Fiber Wire", "Laser Wires", 24900, 24900, aClass, 3, 64, aMetalWires, UT.NBT.make(NBT_MATERIAL, MT.NULL, NBT_HARDNESS, 1.0F, NBT_RESISTANCE, 2.0F, NBT_DIAMETER, PX_P[6], NBT_CONTACTDAMAGE, F), "PGR", "DxD", "RGP", 'P', OP.plate.dat(MT.Ag), 'G', OD.blockGlassColorless, 'D', OP.gem.dat(ANY.Diamond), 'R', OD.itemRedstone);
		
		
		aClass = MultiTileEntityWireLogistics.class;
		aRegistry.add("Logistics Wire", "Logistics", 24901, 17997, aClass, 3, 64, aMetalWires, UT.NBT.make(NBT_MATERIAL, MT.NULL, NBT_HARDNESS, 1.0F, NBT_RESISTANCE, 2.0F, NBT_DIAMETER, PX_P[6], NBT_CONTACTDAMAGE, F), "PEP", "dFx", "POP", 'F', aRegistry.getItem(24900), 'O', OP.wireFine.dat(MT.Os), 'P', OP.foil.dat(ANY.Plastic), 'E', OP.gem.dat(ANY.Emerald));
		
		
		aClass = MultiTileEntityPipeItem.class;
		MultiTileEntityPipeItem.addItemPipes(25000, 25202, 32768,   1, T, T, aRegistry, aMachine    , aClass, MT.Brass);
		MultiTileEntityPipeItem.addItemPipes(25025, 25202, 32768,   1, T, T, aRegistry, aMachine    , aClass, MT.Constantan);
		MultiTileEntityPipeItem.addItemPipes(25050, 25202, 32768,   1, T, T, aRegistry, aMachine    , aClass, MT.CobaltBrass);
		MultiTileEntityPipeItem.addItemPipes(25075, 25202, 32768,   1, T, T, aRegistry, aMachine    , aClass, MT.Ge);
		MultiTileEntityPipeItem.addItemPipes(25350, 25202, 16384,   1, T, T, aRegistry, aMachine    , aClass, MT.ArsenicCopper);
		MultiTileEntityPipeItem.addItemPipes(25375, 25202, 32768,   2, T, T, aRegistry, aMachine    , aClass, MT.ArsenicBronze);
		MultiTileEntityPipeItem.addItemPipes(25100, 25202, 16384,   2, T, T, aRegistry, aMachine    , aClass, MT.Electrum);
		MultiTileEntityPipeItem.addItemPipes(25225, 25202, 16384,   2, T, T, aRegistry, aMachine    , aClass, MT.SterlingSilver);
		MultiTileEntityPipeItem.addItemPipes(25250, 25202, 16384,   2, T, T, aRegistry, aMachine    , aClass, MT.RoseGold);
		MultiTileEntityPipeItem.addItemPipes(25275, 25202, 16384,   2, T, T, aRegistry, aMachine    , aClass, MT.Angmallen);
		MultiTileEntityPipeItem.addItemPipes(25125, 25202, 16384,   2, T, T, aRegistry, aMachine    , aClass, MT.BlackBronze);
		MultiTileEntityPipeItem.addItemPipes(25150, 25202, 16384,   2, T, T, aRegistry, aMachine    , aClass, MT.AluminiumBrass);
		MultiTileEntityPipeItem.addItemPipes(25175, 25202, 16384,   2, T, T, aRegistry, aMachine    , aClass, MT.Manyullyn);
		MultiTileEntityPipeItem.addItemPipes(25325, 25202, 16384,   2, T, T, aRegistry, aMachine    , aClass, MT.Magnalium);
		MultiTileEntityPipeItem.addItemPipes(25200, 25202,  8192,   4, T, T, aRegistry, aMachine    , aClass, MT.Pt);
		MultiTileEntityPipeItem.addItemPipes(25300, 25202,  4096,   8, T, T, aRegistry, aMachine    , aClass, MT.Os);
		MultiTileEntityPipeItem.addItemPipes(25400, 25202,  2048,  16, T, T, aRegistry, aMachine    , aClass, MT.Enderium);
		MultiTileEntityPipeItem.addItemPipes(25425, 25202,  2048,  16, T, T, aRegistry, aMachine    , aClass, MT.Ultimet);
		MultiTileEntityPipeItem.addItemPipes(25475, 25202,  2048,  16, T, T, aRegistry, aMachine    , aClass, MT.ElvenElementium);
		MultiTileEntityPipeItem.addItemPipes(25500, 25202,  1024,  32, T, T, aRegistry, aMachine    , aClass, MT.Osmiridium);
		MultiTileEntityPipeItem.addItemPipes(25900, 25202,    64, 512, T, T, aRegistry, aMachine    , aClass, MT.VibraniumSilver);
		
		aClass = MultiTileEntityPipeFluid.class;
		MultiTileEntityPipeFluid.addFluidPipes(26000, 26142,         50, F, F, F, F, T, T, F, T, aRegistry, aWooden      , aClass, 340, MT.Wood);
		MultiTileEntityPipeFluid.addFluidPipes(26020, 26142,         75, F, F, F, F, T, T, F, T, aRegistry, aWooden      , aClass, 340, MT.WoodTreated);
		MultiTileEntityPipeFluid.addFluidPipes(26080, 26142,        200, T, F, F, T, F, F, T, T, aRegistry, aWooden      , aClass, MT.IronWood);
		MultiTileEntityPipeFluid.addFluidPipes(26060, 26142,        100, T, F, F, F, T, F, F, T, aRegistry, aWooden      , aClass, 370, MT.Plastic);
		MultiTileEntityPipeFluid.addFluidPipes(26520, 26142,        100, T, F, F, F, T, F, F, F, aRegistry, aUtilWool    , aClass, 350, MT.Rubber);
		MultiTileEntityPipeFluid.addFluidPipes(26100, 26142,        100, T, F, F, F, T, F, T, T, aRegistry, aMachine     , aClass, MT.Cu);
		MultiTileEntityPipeFluid.addFluidPipes(26680, 26142,        100, T, T, F, F, T, F, T, T, aRegistry, aMachine     , aClass, MT.Au);
		MultiTileEntityPipeFluid.addFluidPipes(26340, 26142,        100, T, F, F, F, F, F, T, T, aRegistry, aMachine     , aClass, MT.Al);
		MultiTileEntityPipeFluid.addFluidPipes(26040, 26142,        125, T, F, F, F, T, F, T, T, aRegistry, aMachine     , aClass, MT.TinAlloy);
		MultiTileEntityPipeFluid.addFluidPipes(26120, 26142,        150, T, F, F, F, T, F, T, T, aRegistry, aMachine     , aClass, MT.Bronze);
		MultiTileEntityPipeFluid.addFluidPipes(26400, 26142,        200, T, F, F, F, F, F, T, T, aRegistry, aMachine     , aClass, MT.Invar);
		MultiTileEntityPipeFluid.addFluidPipes(26140, 26142,        200, T, F, F, F, T, F, T, T, aRegistry, aMachine     , aClass, MT.Steel);
		MultiTileEntityPipeFluid.addFluidPipes(26620, 26142,        200, T, F, F, T, T, F, T, T, aRegistry, aMachine     , aClass, MT.Desh);
		MultiTileEntityPipeFluid.addFluidPipes(26280, 26142,        200, T, T, F, F, T, F, T, T, aRegistry, aMachine     , aClass, MT.Cr);
		MultiTileEntityPipeFluid.addFluidPipes(26360, 26142,        250, T, F, F, F, T, F, T, T, aRegistry, aMachine     , aClass, MT.HSLA);
		MultiTileEntityPipeFluid.addFluidPipes(26720, 26142,        250, T, F, T, T, F, F, T, T, aRegistry, aMachine     , aClass, MT.Efrine);
		MultiTileEntityPipeFluid.addFluidPipes(26260, 26142,        250, T, F, F, F, T, F, T, T, aRegistry, aMachine     , aClass, MT.SteelGalvanized);
		MultiTileEntityPipeFluid.addFluidPipes(26160, 26142,        250, T, T, F, F, T, F, T, T, aRegistry, aMachine     , aClass, MT.StainlessSteel);
		MultiTileEntityPipeFluid.addFluidPipes(26700, 26142,        300, T, F, F, T, T, F, T, T, aRegistry, aMachine     , aClass, MT.TungstenAlloy);
		MultiTileEntityPipeFluid.addFluidPipes(26180, 26142,        300, T, F, F, F, T, F, T, T, aRegistry, aMachine     , aClass, MT.Ti);
		MultiTileEntityPipeFluid.addFluidPipes(26660, 26142,        300, T, T, T, T, F, F, T, T, aRegistry, aMachine     , aClass, MT.Netherite);
		MultiTileEntityPipeFluid.addFluidPipes(26760, 26142,        350, T, F, F, T, T, F, T, T, aRegistry, aMachine     , aClass, MT.DeshAlloy);
		MultiTileEntityPipeFluid.addFluidPipes(26200, 26142,        350, T, T, F, T, T, F, T, T, aRegistry, aMachine     , aClass, MT.W);
		MultiTileEntityPipeFluid.addFluidPipes(26780, 26142,        400, T, F, F, T, T, F, T, T, aRegistry, aMachine     , aClass, MT.Pd);
		MultiTileEntityPipeFluid.addFluidPipes(26740, 26142,        400, T, T, F, F, T, F, T, T, aRegistry, aMachine     , aClass, MT.VanadiumSteel);
		MultiTileEntityPipeFluid.addFluidPipes(26220, 26142,        400, T, F, F, T, T, F, T, T, aRegistry, aMachine     , aClass, MT.TungstenSteel);
		MultiTileEntityPipeFluid.addFluidPipes(26240, 26142,        450, T, F, F, T, T, F, T, T, aRegistry, aMachine     , aClass, MT.TungstenCarbide);
		MultiTileEntityPipeFluid.addFluidPipes(26440, 26142,        500, T, T, F, T, T, F, T, T, aRegistry, aMachine     , aClass, MT.Ir);
		MultiTileEntityPipeFluid.addFluidPipes(26560, 26142,       1000, T, T, T, T, F, F, T, T, aRegistry, aMachine     , aClass, MT.GaiaSpirit);
		MultiTileEntityPipeFluid.addFluidPipes(26380, 26142,       2500, T, T, T, T, F, F, T, T, aRegistry, aMachine     , aClass, MT.Draconium);
		MultiTileEntityPipeFluid.addFluidPipes(26420, 26142,      10000, T, T, T, T, F, F, T, T, aRegistry, aMachine     , aClass, MT.DraconiumAwakened);
		MultiTileEntityPipeFluid.addFluidPipes(26600, 26142, 1000000000, T, T, T, T, F, F, T, T, aRegistry, aMachine     , aClass, MT.Infinity);
		MultiTileEntityPipeFluid.addFluidPipes(26300, 26142,      10000, T, T, T, T, F, F, T, T, aRegistry, aMachine     , aClass, MT.Ad);
		MultiTileEntityPipeFluid.addFluidPipes(26320, 26142,       1000, T, F, F, T, F, F, T, T, aRegistry, aMachine     , aClass, MT.Bedrock_HSLA_Alloy);
		MultiTileEntityPipeFluid.addFluidPipes(26460, 26142,        250, T, T, F, T, F, F, T, T, aRegistry, aMachine     , aClass, MT.Thaumium);
		MultiTileEntityPipeFluid.addFluidPipes(26540, 26142,        250, T, T, F, T, F, F, T, T, aRegistry, aMachine     , aClass, MT.Manasteel);
		MultiTileEntityPipeFluid.addFluidPipes(26480, 26142,        500, T, T, F, T, F, F, T, T, aRegistry, aMachine     , aClass, MT.VoidMetal);
		MultiTileEntityPipeFluid.addFluidPipes(26580, 26142,        500, T, T, F, T, F, F, T, T, aRegistry, aMachine     , aClass, MT.Terrasteel);
		MultiTileEntityPipeFluid.addFluidPipes(26500, 26142,       1000, T, F, F, F, F, F, F, T, aRegistry, aMachine     , aClass, MT.C);
		MultiTileEntityPipeFluid.addFluidPipes(26640, 26142,        300, T, F, F, T, T, F, T, T, aRegistry, aMachine     , aClass, MT.Ta4HfC5);
		
		CR.shaped(OP.pipeTiny   .mat(MT.Wood, 1), CR.DEF_REV_NCC, "  s", " W ", "r  ", 'W', OD.slabWood);
		CR.shaped(OP.pipeSmall  .mat(MT.Wood, 1), CR.DEF_REV_NCC, "  s", " W ", "r  ", 'W', OD.plankAnyWood);
		CR.shaped(OP.pipeMedium .mat(MT.Wood, 1), CR.DEF_REV_NCC, "  s", "WWW", "r  ", 'W', OD.plankAnyWood);
		CR.shaped(OP.pipeLarge  .mat(MT.Wood, 1), CR.DEF_REV_NCC, "WWs", "W W", "rWW", 'W', OD.plankAnyWood);
		CR.shaped(OP.pipeHuge   .mat(MT.Wood, 1), CR.DEF_REV_NCC, "  s", "W W", "r  ", 'W', OD.beamWood);
		
		aClass = MultiTileEntityWireRedstone.class;
		aMat = MT.RedAlloy;
		OreDictManager.INSTANCE.setTarget_(OP.wireGt01 , aMat, aRegistry.add(aMat.getLocal() + " Wire"    , "Redstone Wires", 27000, 27050, MultiTileEntityWireRedstone         .class, aMat.mToolQuality, 64, aMetalWires, UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS, 1.0F, NBT_RESISTANCE, 2.0F, NBT_PIPERENDER, 0, NBT_DIAMETER, PX_P[2], NBT_PIPELOSS, ITileEntityRedstoneWire.MAX_RANGE / 16)), T, F, T);
		OreDictManager.INSTANCE.setTarget_(OP.cableGt01, aMat, aRegistry.add(aMat.getLocal() + " Cable"   , "Redstone Wires", 27006, 27050, MultiTileEntityWireRedstoneInsulated.class, aMat.mToolQuality, 64, aMetalWires, UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS, 1.0F, NBT_RESISTANCE, 2.0F, NBT_PIPERENDER, 0, NBT_DIAMETER, PX_P[4], NBT_PIPELOSS, ITileEntityRedstoneWire.MAX_RANGE / 16)), T, F, T);
		aMat = MT.Signalum;
		OreDictManager.INSTANCE.setTarget_(OP.wireGt01 , aMat, aRegistry.add(aMat.getLocal() + " Wire"    , "Redstone Wires", 27050, 27050, MultiTileEntityWireRedstone         .class, aMat.mToolQuality, 64, aMetalWires, UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS, 1.0F, NBT_RESISTANCE, 2.0F, NBT_PIPERENDER, 0, NBT_DIAMETER, PX_P[2], NBT_PIPELOSS, ITileEntityRedstoneWire.MAX_RANGE / 64)), T, F, T);
		OreDictManager.INSTANCE.setTarget_(OP.cableGt01, aMat, aRegistry.add(aMat.getLocal() + " Cable"   , "Redstone Wires", 27056, 27050, MultiTileEntityWireRedstoneInsulated.class, aMat.mToolQuality, 64, aMetalWires, UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS, 1.0F, NBT_RESISTANCE, 2.0F, NBT_PIPERENDER, 0, NBT_DIAMETER, PX_P[4], NBT_PIPELOSS, ITileEntityRedstoneWire.MAX_RANGE / 64)), T, F, T);
		aMat = MT.Lumium;
		OreDictManager.INSTANCE.setTarget_(OP.wireGt01 , aMat, aRegistry.add(aMat.getLocal() + " Wirelamp", "Redstone Wires", 27500, 27050, MultiTileEntityWireRedstone         .class, aMat.mToolQuality, 64, aMetalWires, UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS, 1.0F, NBT_RESISTANCE, 2.0F, NBT_PIPERENDER, 0, NBT_DIAMETER, PX_P[2], NBT_PIPELOSS, ITileEntityRedstoneWire.MAX_RANGE / 16)), T, F, T);
		OreDictManager.INSTANCE.setTarget_(OP.cableGt01, aMat, aRegistry.add(aMat.getLocal() + " Cable"   , "Redstone Wires", 27506, 27050, MultiTileEntityWireRedstoneInsulated.class, aMat.mToolQuality, 64, aMetalWires, UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS, 1.0F, NBT_RESISTANCE, 2.0F, NBT_PIPERENDER, 0, NBT_DIAMETER, PX_P[4], NBT_PIPELOSS, ITileEntityRedstoneWire.MAX_RANGE / 16)), T, F, T);
		
		for (OreDictMaterial tMat : ANY.Rubber.mToThis) {
		RM.Laminator.addRecipe2(T, 16, 16, OP.plate.mat(tMat, 1), aRegistry.getItem(27000), aRegistry.getItem(27006));
		RM.Laminator.addRecipe2(T, 16, 16, OP.foil .mat(tMat, 4), aRegistry.getItem(27000), aRegistry.getItem(27006));
		RM.Laminator.addRecipe2(T, 16, 16, OP.plate.mat(tMat, 1), aRegistry.getItem(27050), aRegistry.getItem(27056));
		RM.Laminator.addRecipe2(T, 16, 16, OP.foil .mat(tMat, 4), aRegistry.getItem(27050), aRegistry.getItem(27056));
		RM.Laminator.addRecipe2(T, 16, 16, OP.plate.mat(tMat, 1), aRegistry.getItem(27500), aRegistry.getItem(27506));
		RM.Laminator.addRecipe2(T, 16, 16, OP.foil .mat(tMat, 4), aRegistry.getItem(27500), aRegistry.getItem(27506));
		}
		
		aClass = MultiTileEntityWireElectric.class;
		MultiTileEntityWireElectric.addElectricWires(28050, 28366, V[1]  , 1, 2, 1, T, F, T, aRegistry, aMetalWires, aClass, MT.Sn);
		MultiTileEntityWireElectric.addElectricWires(28100, 28366, V[1]*2, 1, 2, 1, T, F, T, aRegistry, aMetalWires, aClass, MT.Pb);
		
		MultiTileEntityWireElectric.addElectricWires(28300, 28366, V[2]  , 4, 4, 3, T, F, T, aRegistry, aMetalWires, aClass, MT.Constantan);
		MultiTileEntityWireElectric.addElectricWires(28350, 28366, V[2]*2, 1, 2, 1, T, F, T, aRegistry, aMetalWires, aClass, MT.Cu);
		MultiTileEntityWireElectric.addElectricWires(28400, 28366, V[2]*3, 1, 2, 1, T, F, T, aRegistry, aMetalWires, aClass, MT.AnnealedCopper);
		MultiTileEntityWireElectric.addElectricWires(28450, 28366, V[2]*2, 1, 2, 1, T, F, T, aRegistry, aMetalWires, aClass, MT.Efrine);
		
		MultiTileEntityWireElectric.addElectricWires(28600, 28366, V[3]  , 4, 4, 3, T, F, T, aRegistry, aMetalWires, aClass, MT.Kanthal);
		MultiTileEntityWireElectric.addElectricWires(28650, 28366, V[3]*3, 1, 2, 1, T, F, T, aRegistry, aMetalWires, aClass, MT.Ag);
		MultiTileEntityWireElectric.addElectricWires(28700, 28366, V[3]  , 3, 2, 1, T, F, T, aRegistry, aMetalWires, aClass, MT.Au);
		MultiTileEntityWireElectric.addElectricWires(28750, 28366, V[3]*2, 2, 2, 1, T, F, T, aRegistry, aMetalWires, aClass, MT.Electrum);
		MultiTileEntityWireElectric.addElectricWires(28800, 28366, V[3]*3, 2, 2, 1, T, F, T, aRegistry, aMetalWires, aClass, MT.BlueAlloy);
		MultiTileEntityWireElectric.addElectricWires(28850, 28366, V[3]*2, 3, 2, 1, T, F, T, aRegistry, aMetalWires, aClass, MT.ElectrotineAlloy);
		
		MultiTileEntityWireElectric.addElectricWires(28900, 28366, V[4]  , 4, 4, 3, T, F, T, aRegistry, aMetalWires, aClass, MT.Nichrome);
		MultiTileEntityWireElectric.addElectricWires(28950, 28366, V[4]  , 2, 3, 2, T, F, T, aRegistry, aMetalWires, aClass, MT.Steel);
		MultiTileEntityWireElectric.addElectricWires(28250, 28366, V[4]  , 3, 3, 2, T, F, T, aRegistry, aMetalWires, aClass, MT.HSLA);
		MultiTileEntityWireElectric.addElectricWires(29000, 28366, V[4]  , 1, 2, 1, T, F, T, aRegistry, aMetalWires, aClass, MT.Al);
		MultiTileEntityWireElectric.addElectricWires(29050, 28366, V[4]*2, 4, 3, 2, T, F, T, aRegistry, aMetalWires, aClass, MT.TungstenSteel);
		MultiTileEntityWireElectric.addElectricWires(29100, 28366, V[4]*3, 8, 3, 2, T, F, T, aRegistry, aMetalWires, aClass, MT.W);
		MultiTileEntityWireElectric.addElectricWires(29150, 28366, V[4]  , 1, 2, 1, T, F, T, aRegistry, aMetalWires, aClass, MT.Netherite);
		
		MultiTileEntityWireElectric.addElectricWires(29200, 28366, V[5]*2, 4, 4, 3, T, F, T, aRegistry, aMetalWires, aClass, MT.Os);
		MultiTileEntityWireElectric.addElectricWires(29250, 28366, V[5]*3, 2, 2, 1, T, F, T, aRegistry, aMetalWires, aClass, MT.Pt);
		MultiTileEntityWireElectric.addElectricWires(29300, 28366, V[5]*3, 4, 2, 1, T, F, T, aRegistry, aMetalWires, aClass, MT.Osmiridium);
		MultiTileEntityWireElectric.addElectricWires(29350, 28366, V[5]  , 4, 4, 3, T, F, T, aRegistry, aMetalWires, aClass, MT.SiC);
		MultiTileEntityWireElectric.addElectricWires(29400, 28366, V[5]*3, 4, 4, 2, T, F, T, aRegistry, aMetalWires, aClass, MT.Ir);
		
		MultiTileEntityWireElectric.addElectricWires(29500, 28366, V[6]*3, 4, 2, 1, T, F, T, aRegistry, aMetalWires, aClass, MT.Nq);
		MultiTileEntityWireElectric.addElectricWires(29550, 28366, V[6]  , 4, 4, 3, T, F, T, aRegistry, aMetalWires, aClass, MT.NiobiumTitanium);
		MultiTileEntityWireElectric.addElectricWires(29600, 28366, V[6]*2, 4, 4, 3, T, F, T, aRegistry, aMetalWires, aClass, MT.VanadiumGallium);
		MultiTileEntityWireElectric.addElectricWires(29650, 28366, V[6]*3, 4, 4, 3, T, F, T, aRegistry, aMetalWires, aClass, MT.YttriumBariumCuprate);
		
		MultiTileEntityWireElectric.addElectricWires(29800, 28366, V[6]*2, 1, 2, 2, F, F, F, aRegistry, aMetalWires, aClass, MT.Graphene);
		
		MultiTileEntityWireElectric.addElectricWires(29950, 28366, V[15] , 4, 1, 1, F, F, F, aRegistry, aMetalWires, aClass, MT.Superconductor);
	}
	
	private static void extenders(MultiTileEntityRegistry aRegistry, MultiTileEntityBlock aMetal, MultiTileEntityBlock aMetalChips, MultiTileEntityBlock aMetalWires, MultiTileEntityBlock aMachine, MultiTileEntityBlock aWooden, MultiTileEntityBlock aBush, MultiTileEntityBlock aStone, MultiTileEntityBlock aWool, MultiTileEntityBlock aTNT, MultiTileEntityBlock aHive, MultiTileEntityBlock aUtilMetal, MultiTileEntityBlock aUtilStone, MultiTileEntityBlock aUtilWood, MultiTileEntityBlock aUtilWool, OreDictMaterial aMat, Class<? extends TileEntity> aClass) {
		aClass = MultiTileEntityExtender.class;
		aMat = ANY.Steel;           aRegistry.add("Inventory Extender"                                  , "Extenders"                           , 30000, 30000, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   6.0F, NBT_RESISTANCE,   6.0F, NBT_TEXTURE, "inv"             , NBT_MODE, MultiTileEntityExtender.EXTENDER_INV                                        ), " hY", " M ", "Yw ", 'M', OP.casingMachine         .dat(aMat), 'X', OP.pipeMedium.dat(aMat), 'Y', OP.pipeMedium.dat(MT.Electrum));
		aMat = ANY.Steel;           aRegistry.add("Tank Extender"                                       , "Extenders"                           , 30001, 30000, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   6.0F, NBT_RESISTANCE,   6.0F, NBT_TEXTURE, "tank"            , NBT_MODE, MultiTileEntityExtender.EXTENDER_TANK                                       ), "Xh ", " M ", " wX", 'M', OP.casingMachine         .dat(aMat), 'X', OP.pipeMedium.dat(aMat), 'Y', OP.pipeMedium.dat(MT.Electrum));
		aMat = ANY.Steel;           aRegistry.add("Inventory and Tank Extender"                         , "Extenders"                           , 30002, 30000, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   6.0F, NBT_RESISTANCE,   6.0F, NBT_TEXTURE, "inv_tank"        , NBT_MODE, MultiTileEntityExtender.EXTENDER_INV | MultiTileEntityExtender.EXTENDER_TANK), "XhY", " M ", "YwX", 'M', OP.casingMachineDouble   .dat(aMat), 'X', OP.pipeMedium.dat(aMat), 'Y', OP.pipeMedium.dat(MT.Electrum));
		
		aClass = MultiTileEntityExtenderController.class;
		aMat = MT.StainlessSteel;   aRegistry.add("Universal Extender"                                  , "Extenders"                           , 30255, 30000, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   6.0F, NBT_RESISTANCE,   6.0F, NBT_TEXTURE, "universal"       , NBT_MODE, MultiTileEntityExtender.EXTENDER_ALL                                        ), "XRY", "CMG", "YSX", 'M', OP.casingMachineQuadruple.dat(aMat), 'X', OP.pipeMedium.dat(MT.StainlessSteel), 'Y', OP.pipeMedium.dat(MT.Pt), 'S', OP.spring.dat(aMat), 'G', OP.gearGt.dat(aMat), 'R', OP.rotor.dat(aMat), 'C', OD_CIRCUITS[3]);
		
		aClass = MultiTileEntityFilter.class;
		aMat = MT.SteelGalvanized;  aRegistry.add("Filter (Items)"                                      , "Sorting"                             , 30256, 30256, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   6.0F, NBT_RESISTANCE,   6.0F, NBT_TEXTURE, "filter_slots"    , NBT_MODE, MultiTileEntityExtender.EXTENDER_INV                                        ), " hY", "ZMZ", "Yw ", 'M', OP.casingMachine         .dat(aMat), 'X', OP.pipeMedium.dat(aMat), 'Y', OP.pipeMedium.dat(MT.Electrum), 'Z', IL.Cover_Filter_Item                            ); CR.shapeless(aRegistry.getItem(), CR.DEF_NCC, new Object[] {aRegistry.getItem()});
		aMat = MT.SteelGalvanized;  aRegistry.add("Filter (Fluids)"                                     , "Sorting"                             , 30257, 30256, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   6.0F, NBT_RESISTANCE,   6.0F, NBT_TEXTURE, "filter_slots"    , NBT_MODE, MultiTileEntityExtender.EXTENDER_TANK                                       ), "Xh ", "ZMZ", " wX", 'M', OP.casingMachine         .dat(aMat), 'X', OP.pipeMedium.dat(aMat), 'Y', OP.pipeMedium.dat(MT.Electrum), 'Z', IL.Cover_Filter_Fluid                           ); CR.shapeless(aRegistry.getItem(), CR.DEF_NCC, new Object[] {aRegistry.getItem()});
		aMat = MT.SteelGalvanized;  aRegistry.add("Filter (Items & Fluids)"                             , "Sorting"                             , 30258, 30256, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   6.0F, NBT_RESISTANCE,   6.0F, NBT_TEXTURE, "filter_slots"    , NBT_MODE, MultiTileEntityExtender.EXTENDER_INV | MultiTileEntityExtender.EXTENDER_TANK), "XhY", "ZMF", "YwX", 'M', OP.casingMachineDouble   .dat(aMat), 'X', OP.pipeMedium.dat(aMat), 'Y', OP.pipeMedium.dat(MT.Electrum), 'Z', IL.Cover_Filter_Item, 'F', IL.Cover_Filter_Fluid); CR.shapeless(aRegistry.getItem(), CR.DEF_NCC, new Object[] {aRegistry.getItem()});
		aClass = MultiTileEntityFilterPrefix.class;
		aMat = MT.SteelGalvanized;  aRegistry.add("Filter (Ore-Dictionary Prefixes)"                    , "Sorting"                             , 30259, 30256, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   6.0F, NBT_RESISTANCE,   6.0F, NBT_TEXTURE, "filter_prefix"   , NBT_MODE, MultiTileEntityExtender.EXTENDER_INV | MultiTileEntityExtender.EXTENDER_TANK), "XZY", "hMw", "YZX", 'M', OP.casingMachineDouble   .dat(aMat), 'X', OP.pipeMedium.dat(aMat), 'Y', OP.pipeMedium.dat(MT.Electrum), 'Z', IL.Cover_Filter_Item                            ); CR.shapeless(aRegistry.getItem(), CR.DEF_NCC, new Object[] {aRegistry.getItem()});
		
		aClass = MultiTileEntityBridge.class;
		aMat = ANY.Steel;           aRegistry.add("Inventory Bridge"                                    , "Extenders"                           , 30500, 30000, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   6.0F, NBT_RESISTANCE,   6.0F, NBT_TEXTURE, "bridge_inv"      , NBT_MODE, MultiTileEntityExtender.EXTENDER_INV                                        ), "hY ", " M ", " Yw", 'M', OP.casingMachine         .dat(aMat), 'X', OP.pipeMedium.dat(aMat), 'Y', OP.pipeMedium.dat(MT.Electrum));
		aMat = ANY.Steel;           aRegistry.add("Tank Bridge"                                         , "Extenders"                           , 30501, 30000, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   6.0F, NBT_RESISTANCE,   6.0F, NBT_TEXTURE, "bridge_tank"     , NBT_MODE, MultiTileEntityExtender.EXTENDER_TANK                                       ), "h  ", "XMX", "  w", 'M', OP.casingMachine         .dat(aMat), 'X', OP.pipeMedium.dat(aMat), 'Y', OP.pipeMedium.dat(MT.Electrum));
		aMat = ANY.Steel;           aRegistry.add("Inventory and Tank Bridge"                           , "Extenders"                           , 30502, 30000, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   6.0F, NBT_RESISTANCE,   6.0F, NBT_TEXTURE, "bridge_inv_tank" , NBT_MODE, MultiTileEntityExtender.EXTENDER_INV | MultiTileEntityExtender.EXTENDER_TANK), "hY ", "XMX", " Yw", 'M', OP.casingMachineDouble   .dat(aMat), 'X', OP.pipeMedium.dat(aMat), 'Y', OP.pipeMedium.dat(MT.Electrum));
		
		aClass = MultiTileEntityBridgeController.class;
		aMat = MT.StainlessSteel;   aRegistry.add("Universal Bridge"                                    , "Extenders"                           , 30755, 30000, aClass, aMat.mToolQuality, 16, aMachine     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   6.0F, NBT_RESISTANCE,   6.0F, NBT_TEXTURE, "bridge_universal", NBT_MODE, MultiTileEntityExtender.EXTENDER_ALL                                        ), "SYR", "XMX", "CYG", 'M', OP.casingMachineQuadruple.dat(aMat), 'X', OP.pipeMedium.dat(MT.StainlessSteel), 'Y', OP.pipeMedium.dat(MT.Pt), 'S', OP.spring.dat(aMat), 'G', OP.gearGt.dat(aMat), 'R', OP.rotor.dat(aMat), 'C', OD_CIRCUITS[3]);
	}
	
	private static void sensors(MultiTileEntityRegistry aRegistry, MultiTileEntityBlock aMetal, MultiTileEntityBlock aMetalChips, MultiTileEntityBlock aMetalWires, MultiTileEntityBlock aMachine, MultiTileEntityBlock aWooden, MultiTileEntityBlock aBush, MultiTileEntityBlock aStone, MultiTileEntityBlock aWool, MultiTileEntityBlock aTNT, MultiTileEntityBlock aHive, MultiTileEntityBlock aUtilMetal, MultiTileEntityBlock aUtilStone, MultiTileEntityBlock aUtilWood, MultiTileEntityBlock aUtilWool, OreDictMaterial aMat, Class<? extends TileEntity> aClass) {
		aRegistry.add("Thermometer Sensor"                                  , "Sensors"                             , 31000, 31015, MultiTileEntityThermometer.class                        ,                 1, 16, aUtilMetal     , null, "WRW", "RXR", "WPW", 'P', OP.plateDouble.dat(MT.TinAlloy), 'W', OP.wireFine.dat(MT.RedAlloy), 'R', OD.itemRedstone, 'G', OD.blockGlassColorless, 'B', OP.bolt.dat(MT.TinAlloy), 'C', Items.comparator, 'X', IL.Thermometer_Quicksilver                                ); CR.shapeless(aRegistry.getItem(), CR.DEF_NCC, new Object[] {aRegistry.getItem()});
		aRegistry.add("Luminometer Sensor"                                  , "Sensors"                             , 31002, 31015, MultiTileEntityLuminometer.class                        ,                 1, 16, aUtilMetal     , null, "WGW", "YXY", "WPW", 'P', OP.plateDouble.dat(MT.TinAlloy), 'W', OP.wireFine.dat(MT.RedAlloy), 'R', OD.itemRedstone, 'G', OD.blockGlassColorless, 'B', OP.bolt.dat(MT.TinAlloy), 'C', Items.comparator, 'X', OP.plate.dat(ANY.Si), 'Y', OP.wireFine.dat(ANY.Cu)        ); CR.shapeless(aRegistry.getItem(), CR.DEF_NCC, new Object[] {aRegistry.getItem()});
		aRegistry.add("Chronometer Sensor"                                  , "Sensors"                             , 31003, 31015, MultiTileEntityChronometer.class                        ,                 1, 16, aUtilMetal     , null, "WGW", "GXG", "WPW", 'P', OP.plateDouble.dat(MT.TinAlloy), 'W', OP.wireFine.dat(MT.RedAlloy), 'R', OD.itemRedstone, 'G', OD.blockGlassColorless, 'B', OP.bolt.dat(MT.TinAlloy), 'C', Items.comparator, 'X', Items.clock                                               ); CR.shapeless(aRegistry.getItem(), CR.DEF_NCC, new Object[] {aRegistry.getItem()});
		aRegistry.add("Gibbl-O-Meter Sensor"                                , "Sensors"                             , 31001, 31015, MultiTileEntityGibblometer.class                        ,                 1, 16, aUtilMetal     , null, "WPW", "BXB", "WPW", 'P', OP.plateDouble.dat(MT.TinAlloy), 'W', OP.wireFine.dat(MT.RedAlloy), 'R', OD.itemRedstone, 'G', OD.blockGlassColorless, 'B', OP.bolt.dat(MT.TinAlloy), 'C', Items.comparator, 'X', OP.gem.dat(ANY.SiO2)                                      ); CR.shapeless(aRegistry.getItem(), CR.DEF_NCC, new Object[] {aRegistry.getItem()});
		aRegistry.add("Item-O-Meter Sensor"                                 , "Sensors"                             , 31004, 31015, MultiTileEntityItemometer.class                         ,                 1, 16, aUtilMetal     , null, "WYW", "BXB", "WPW", 'P', OP.plateDouble.dat(MT.TinAlloy), 'W', OP.wireFine.dat(MT.RedAlloy), 'R', OD.itemRedstone, 'G', OD.blockGlassColorless, 'B', OP.bolt.dat(MT.TinAlloy), 'C', Items.comparator, 'X', OD.pressurePlateGold , 'Y', OD.craftingChest              ); CR.shapeless(aRegistry.getItem(), CR.DEF_NCC, new Object[] {aRegistry.getItem()});
		aRegistry.add("Stack-O-Meter Sensor"                                , "Sensors"                             , 31005, 31015, MultiTileEntityStackometer.class                        ,                 1, 16, aUtilMetal     , null, "WYW", "BXB", "WPW", 'P', OP.plateDouble.dat(MT.TinAlloy), 'W', OP.wireFine.dat(MT.RedAlloy), 'R', OD.itemRedstone, 'G', OD.blockGlassColorless, 'B', OP.bolt.dat(MT.TinAlloy), 'C', Items.comparator, 'X', OD.pressurePlateIron , 'Y', OD.craftingChest              ); CR.shapeless(aRegistry.getItem(), CR.DEF_NCC, new Object[] {aRegistry.getItem()});
		aRegistry.add("Fluid-O-Meter Sensor"                                , "Sensors"                             , 31006, 31015, MultiTileEntityFluidometer.class                        ,                 1, 16, aUtilMetal     , null, "WYW", "BXB", "WPW", 'P', OP.plateDouble.dat(MT.TinAlloy), 'W', OP.wireFine.dat(MT.RedAlloy), 'R', OD.itemRedstone, 'G', OD.blockGlassColorless, 'B', OP.bolt.dat(MT.TinAlloy), 'C', Items.comparator, 'X', OD.pressurePlateStone, 'Y', Items.bucket                  ); CR.shapeless(aRegistry.getItem(), CR.DEF_NCC, new Object[] {aRegistry.getItem()});
		aRegistry.add("Bucket-O-Meter Sensor"                               , "Sensors"                             , 31007, 31015, MultiTileEntityBucketometer.class                       ,                 1, 16, aUtilMetal     , null, "WYW", "BXB", "WPW", 'P', OP.plateDouble.dat(MT.TinAlloy), 'W', OP.wireFine.dat(MT.RedAlloy), 'R', OD.itemRedstone, 'G', OD.blockGlassColorless, 'B', OP.bolt.dat(MT.TinAlloy), 'C', Items.comparator, 'X', OD.pressurePlateGold , 'Y', Items.bucket                  ); CR.shapeless(aRegistry.getItem(), CR.DEF_NCC, new Object[] {aRegistry.getItem()});
		aRegistry.add("Kilo-Bucket-O-Meter Sensor"                          , "Sensors"                             , 31022, 31015, MultiTileEntityKiloBucketometer.class                   ,                 1, 16, aUtilMetal     , null, "WYW", "BXB", "WPW", 'P', OP.plateDouble.dat(MT.TinAlloy), 'W', OP.wireFine.dat(MT.RedAlloy), 'R', OD.itemRedstone, 'G', OD.blockGlassColorless, 'B', OP.bolt.dat(MT.TinAlloy), 'C', Items.comparator, 'X', OD.pressurePlateIron , 'Y', Items.bucket                  ); CR.shapeless(aRegistry.getItem(), CR.DEF_NCC, new Object[] {aRegistry.getItem()});
		aRegistry.add("Light Weight-O-Meter Sensor"                         , "Sensors"                             , 31010, 31015, MultiTileEntityWeightometerLight.class                  ,                 1, 16, aUtilMetal     , null, "WPW", "BXB", "WPW", 'P', OP.plateDouble.dat(MT.TinAlloy), 'W', OP.wireFine.dat(MT.RedAlloy), 'R', OD.itemRedstone, 'G', OD.blockGlassColorless, 'B', OP.bolt.dat(MT.TinAlloy), 'C', Items.comparator, 'X', OD.pressurePlateWood                                      ); CR.shapeless(aRegistry.getItem(), CR.DEF_NCC, new Object[] {aRegistry.getItem()});
		aRegistry.add("Medium Weight-O-Meter Sensor"                        , "Sensors"                             , 31011, 31015, MultiTileEntityWeightometerMedium.class                 ,                 1, 16, aUtilMetal     , null, "WPW", "BXB", "WPW", 'P', OP.plateDouble.dat(MT.TinAlloy), 'W', OP.wireFine.dat(MT.RedAlloy), 'R', OD.itemRedstone, 'G', OD.blockGlassColorless, 'B', OP.bolt.dat(MT.TinAlloy), 'C', Items.comparator, 'X', OD.pressurePlateStone                                     ); CR.shapeless(aRegistry.getItem(), CR.DEF_NCC, new Object[] {aRegistry.getItem()});
		aRegistry.add("Heavy Weight-O-Meter Sensor"                         , "Sensors"                             , 31012, 31015, MultiTileEntityWeightometerHeavy.class                  ,                 1, 16, aUtilMetal     , null, "WPW", "BXB", "WPW", 'P', OP.plateDouble.dat(MT.TinAlloy), 'W', OP.wireFine.dat(MT.RedAlloy), 'R', OD.itemRedstone, 'G', OD.blockGlassColorless, 'B', OP.bolt.dat(MT.TinAlloy), 'C', Items.comparator, 'X', OD.pressurePlateGold                                      ); CR.shapeless(aRegistry.getItem(), CR.DEF_NCC, new Object[] {aRegistry.getItem()});
		aRegistry.add("Super Heavy Weight-O-Meter Sensor"                   , "Sensors"                             , 31013, 31015, MultiTileEntityWeightometerSuperHeavy.class             ,                 1, 16, aUtilMetal     , null, "WPW", "BXB", "WPW", 'P', OP.plateDouble.dat(MT.TinAlloy), 'W', OP.wireFine.dat(MT.RedAlloy), 'R', OD.itemRedstone, 'G', OD.blockGlassColorless, 'B', OP.bolt.dat(MT.TinAlloy), 'C', Items.comparator, 'X', OD.pressurePlateIron                                      ); CR.shapeless(aRegistry.getItem(), CR.DEF_NCC, new Object[] {aRegistry.getItem()});
		aRegistry.add("TPS Sensor"                                          , "Sensors"                             , 31016, 31015, MultiTileEntityTPSmeter.class                           ,                 1, 16, aUtilMetal     , null, "WGW", "XXX", "WPW", 'P', OP.plateDouble.dat(MT.TinAlloy), 'W', OP.wireFine.dat(MT.RedAlloy), 'R', OD.itemRedstone, 'G', OD.blockGlassColorless, 'B', OP.bolt.dat(MT.TinAlloy), 'C', Items.comparator, 'X', Items.clock                                               ); CR.shapeless(aRegistry.getItem(), CR.DEF_NCC, new Object[] {aRegistry.getItem()});
		aRegistry.add("Player Counter Sensor"                               , "Sensors"                             , 31017, 31015, MultiTileEntityPlayerCounter.class                      ,                 1, 16, aUtilMetal     , null, "WGW", "CXC", "WPW", 'P', OP.plateDouble.dat(MT.TinAlloy), 'W', OP.wireFine.dat(MT.RedAlloy), 'R', OD.itemRedstone, 'G', OD.blockGlassColorless, 'B', OP.bolt.dat(MT.TinAlloy), 'C', Items.comparator, 'X', OD.pressurePlateStone                                     ); CR.shapeless(aRegistry.getItem(), CR.DEF_NCC, new Object[] {aRegistry.getItem()});
		aRegistry.add("Progress Sensor"                                     , "Sensors"                             , 31018, 31015, MultiTileEntityProgressmeter.class                      ,                 1, 16, aUtilMetal     , null, "WGW", "CXC", "WPW", 'P', OP.plateDouble.dat(MT.TinAlloy), 'W', OP.wireFine.dat(MT.RedAlloy), 'R', OD.itemRedstone, 'G', OD.blockGlassColorless, 'B', OP.bolt.dat(MT.TinAlloy), 'C', Items.comparator, 'X', OP.gearGtSmall.dat(MT.Brass)                              ); CR.shapeless(aRegistry.getItem(), CR.DEF_NCC, new Object[] {aRegistry.getItem()});
		aRegistry.add("Geiger Counter Sensor"                               , "Sensors"                             , 31020, 31015, MultiTileEntityGeigerCounter.class                      ,                 1, 16, aUtilMetal     , null, "WGW", "YXY", "WPW", 'P', OP.plateDouble.dat(MT.TinAlloy), 'W', OP.wireFine.dat(MT.RedAlloy), 'R', OD.itemRedstone, 'G', OD.blockGlassColorless, 'B', OP.bolt.dat(MT.TinAlloy), 'C', Items.comparator, 'X', IL.Geiger_Counter, 'Y', OP.plateDouble.dat(MT.Pb)         ); CR.shapeless(aRegistry.getItem(), CR.DEF_NCC, new Object[] {aRegistry.getItem()});
		aRegistry.add("Electrometer Sensor"                                 , "Sensors"                             , 31015, 31015, MultiTileEntityElectrometer.class                       ,                 1, 16, aUtilMetal     , null, "WGW", "YXY", "WPW", 'P', OP.plateDouble.dat(MT.TinAlloy), 'W', OP.wireFine.dat(MT.RedAlloy), 'R', OD.itemRedstone, 'G', OD.blockGlassColorless, 'B', OP.bolt.dat(MT.TinAlloy), 'C', Items.comparator, 'X', IL.Electro_Meter , 'Y', OP.wireGt01.dat(ANY.Cu)           ); CR.shapeless(aRegistry.getItem(), CR.DEF_NCC, new Object[] {aRegistry.getItem()});
		aRegistry.add("Tachometer Sensor"                                   , "Sensors"                             , 31019, 31015, MultiTileEntityTachometer.class                         ,                 1, 16, aUtilMetal     , null, "WGW", "YXY", "WPW", 'P', OP.plateDouble.dat(MT.TinAlloy), 'W', OP.wireFine.dat(MT.RedAlloy), 'R', OD.itemRedstone, 'G', OD.blockGlassColorless, 'B', OP.bolt.dat(MT.TinAlloy), 'C', Items.comparator, 'X', IL.Tacho_Meter   , 'Y', OP.gearGt.dat(MT.Brass)           ); CR.shapeless(aRegistry.getItem(), CR.DEF_NCC, new Object[] {aRegistry.getItem()});
		aRegistry.add("Laser-O-Meter Sensor"                                , "Sensors"                             , 31021, 31015, MultiTileEntityLaserometer.class                        ,                 1, 16, aUtilMetal     , null, "WGW", "YXY", "WPW", 'P', OP.plateDouble.dat(MT.TinAlloy), 'W', OP.wireFine.dat(MT.RedAlloy), 'R', OD.itemRedstone, 'G', OD.blockGlassColorless, 'B', OP.bolt.dat(MT.TinAlloy), 'C', Items.comparator, 'X', IL.SENSORS[1]    , 'Y', OP.wireFine.dat(ANY.Cu)           ); CR.shapeless(aRegistry.getItem(), CR.DEF_NCC, new Object[] {aRegistry.getItem()});
	}
	
	private static void misc(MultiTileEntityRegistry aRegistry, MultiTileEntityBlock aMetal, MultiTileEntityBlock aMetalChips, MultiTileEntityBlock aMetalWires, MultiTileEntityBlock aMachine, MultiTileEntityBlock aWooden, MultiTileEntityBlock aBush, MultiTileEntityBlock aStone, MultiTileEntityBlock aWool, MultiTileEntityBlock aTNT, MultiTileEntityBlock aHive, MultiTileEntityBlock aUtilMetal, MultiTileEntityBlock aUtilStone, MultiTileEntityBlock aUtilWood, MultiTileEntityBlock aUtilWool, OreDictMaterial aMat, Class<? extends TileEntity> aClass) {
		aRegistry.add("Miniature Nether Portal"                             , "Portals"                             , 32766, 32766, MultiTileEntityMiniPortalNether.class                   ,                 3, 16, aStone         , null                                                                                        ,"SSS", "SsS", "SSS", 'S', OP.stickLong.dat(MT.Obsidian));
		aRegistry.add("Miniature End Portal"                                , "Portals"                             , 32000, 32766, MultiTileEntityMiniPortalEnd.class                      ,                 1, 16, aStone         , null                                                                                        ,"ESE", "SGS", "ESE", 'S', OP.stickLong.dat(MT.Endstone), 'E', OP.gem.dat(MT.EnderEye), 'G', Items.ghast_tear);
		aRegistry.add("Miniature Twilight Portal"                           , "Portals"                             , 32001, 32766, MultiTileEntityMiniPortalTwilight.class                 ,                 0, 16, aBush          , UT.NBT.make(NBT_HIDDEN, !MD.TF           .mLoaded), MD.TF           .mLoaded ? new Object[] {"FGF", "GWG", "FGF", 'G', Blocks.grass, 'W', OD.container1000water, 'F', OD.flower} : ZL);
		aRegistry.add("Miniature Erebus Portal"                             , "Portals"                             , 32002, 32766, MultiTileEntityMiniPortalErebus.class                   ,                 0, 16, aStone         , UT.NBT.make(NBT_HIDDEN, !MD.ERE          .mLoaded), MD.ERE          .mLoaded ? new Object[] {"SLS", "LKL", "SLS", 'S', OP.stickLong.dat(MT.STONES.Umber), 'L', OP.treeLeaves, 'K', ST.make(MD.ERE, "gaeanKeystone", 1, 0)} : ZL);
		aRegistry.add("Miniature Atum Portal"                               , "Portals"                             , 32005, 32766, MultiTileEntityMiniPortalAtum.class                     ,                 0, 16, aStone         , UT.NBT.make(NBT_HIDDEN, !MD.ATUM         .mLoaded), MD.ATUM         .mLoaded ? new Object[] {"SSS", "SsS", "SSS", 'S', OP.stickLong.dat(MT.STONES.Limestone)} : ZL);
		aRegistry.add("Miniature Betweenlands Portal"                       , "Portals"                             , 32006, 32766, MultiTileEntityMiniPortalBetweenlands.class             ,                 0, 16, aWooden        , UT.NBT.make(NBT_HIDDEN, !MD.BTL          .mLoaded), MD.BTL          .mLoaded ? new Object[] {"PsP", "PSP", "PGP", 'P', ST.make(MD.BTL, "portalBark", 1, 0), 'S', OP.treeSapling, 'G', Blocks.grass} : ZL);
		aRegistry.add("Miniature Aether Portal"                             , "Portals"                             , 32015, 32766, MultiTileEntityMiniPortalAether.class                   ,                 0, 16, aStone         , UT.NBT.make(NBT_HIDDEN, !MD.AETHER       .mLoaded), MD.AETHER       .mLoaded ? new Object[] {"SSS", "SsS", "SSS", 'S', OP.stickLong.dat(ANY.Glowstone)} : ZL);
		aRegistry.add("Miniature Enviromine Portal"                         , "Portals"                             , 32051, 32766, MultiTileEntityMiniPortalEnviromine.class               ,                 0, 16, aStone         , UT.NBT.make(NBT_HIDDEN, !MD.ENVM         .mLoaded), MD.ENVM         .mLoaded ? new Object[] {"SSS", "SsS", "SSS", 'S', OP.stickLong.dat(MT.STONES.GraniteBlack)} : ZL);
		aRegistry.add("Miniature Mining Dimension Portal"                   , "Portals"                             , 32096, 32766, MultiTileEntityMiniPortalAroma.class                    ,                 0, 16, aStone         , UT.NBT.make(NBT_HIDDEN, !MD.A97_MINING   .mLoaded), MD.A97_MINING   .mLoaded ? new Object[] {"BBB", "ByB", "BBB", 'B', ST.make(MD.A97_MINING, "portalFrame", 1, 0)} : ZL);
		aRegistry.add("Miniature Caveworld Dimension Portal"                , "Portals"                             , 32097, 32766, MultiTileEntityMiniPortalCW2Caveworld.class             ,                 0, 16, aStone         , UT.NBT.make(NBT_HIDDEN, !MD.CW2          .mLoaded), MD.CW2          .mLoaded ? new Object[] {"BBB", "BXB", "BBB", 'B', OP.stoneMossy, 'X', OD.enderChest} : ZL);
		aRegistry.add("Miniature Cavern Dimension Portal"                   , "Portals"                             , 32098, 32766, MultiTileEntityMiniPortalCW2Cavern.class                ,                 0, 16, aStone         , UT.NBT.make(NBT_HIDDEN, !MD.CW2          .mLoaded), MD.CW2          .mLoaded ? new Object[] {"BBB", "BXB", "BBB", 'B', OP.stoneMossy, 'X', OP.gem.dat(MT.Emerald)} : ZL);
		aRegistry.add("Miniature Aqua Cavern Dimension Portal"              , "Portals"                             , 32099, 32766, MultiTileEntityMiniPortalCW2AquaCavern.class            ,                 0, 16, aStone         , UT.NBT.make(NBT_HIDDEN, !MD.CW2          .mLoaded), MD.CW2          .mLoaded ? new Object[] {"BBB", "BXB", "BBB", 'B', OP.stoneMossy, 'X', OP.gem.dat(MT.Aquamarine)} : ZL);
		aRegistry.add("Miniature Caveland Dimension Portal"                 , "Portals"                             , 32100, 32766, MultiTileEntityMiniPortalCW2Caveland.class              ,                 0, 16, aStone         , UT.NBT.make(NBT_HIDDEN, !MD.CW2          .mLoaded), MD.CW2          .mLoaded ? new Object[] {"BBB", "BXB", "BBB", 'B', OP.stoneMossy, 'X', OP.gem.dat(MT.UNUSED.Cavenium)} : ZL);
		aRegistry.add("Miniature Cavenia Dimension Portal"                  , "Portals"                             , 32101, 32766, MultiTileEntityMiniPortalCW2Cavenia.class               ,                 0, 16, aStone         , UT.NBT.make(NBT_HIDDEN, !MD.CW2          .mLoaded), MD.CW2          .mLoaded ? new Object[] {"BBB", "BXB", "BBB", 'B', OP.stoneMossy, 'X', OP.gem.dat(MT.UNUSED.CaveniumRefined)} : ZL);
		aRegistry.add("Miniature Alfheim Portal"                            , "Portals"                             , 32052, 32766, MultiTileEntityMiniPortalAlfheim.class                  ,                 0, 16, aWooden        , UT.NBT.make(NBT_HIDDEN, !MD.ALF          .mLoaded), MD.ALF          .mLoaded ? new Object[] {"SSS", "SXS", "SSS", 'S', OP.stickLong.dat(MT.Dreamwood), 'X', ST.make(MD.ALF, "AlfheimPortal", 1, 0)} : ZL);
		aRegistry.add("Miniature Tropics Portal"                            , "Portals"                             , 32053, 32766, MultiTileEntityMiniPortalTropics.class                  ,                 0, 16, aWooden        , UT.NBT.make(NBT_HIDDEN, !MD.TROPIC       .mLoaded), MD.TROPIC       .mLoaded ? new Object[] {"SSS", "SXS", "SSS", 'S', OD.bamboo, 'X', ST.item(MD.TROPIC, "bucketTropicsWater")} : ZL);
		aRegistry.add("Miniature Candy Portal"                              , "Portals"                             , 32054, 32766, MultiTileEntityMiniPortalCandyCraft.class               ,                 0, 16, aStone         , UT.NBT.make(NBT_HIDDEN, !MD.CANDY        .mLoaded), MD.CANDY        .mLoaded ? new Object[] {"SSS", "SsS", "SSS", 'S', ST.item(MD.CANDY, "I12")} : ZL);
		aRegistry.add("Miniature Deep Dark Portal"                          , "Portals"                             , 32003, 32766, MultiTileEntityMiniPortalDeepDark.class                 ,                 2, 16, aStone         , UT.NBT.make(NBT_HIDDEN, !(MD.ExU.mLoaded || MD.ExS.mLoaded)), MD.ExS.mLoaded ? new Object[] {"SSS", "SXS", "SSS", 'S', OP.stickLong.dat(MT.Obsidian), 'X', ST.make(MD.ExS, "deepPortal", 1, 0)} : MD.ExU.mLoaded ? new Object[] {"SSS", "SXS", "SSS", 'S', OP.stickLong.dat(MT.Obsidian), 'X', ST.make(MD.ExU, "dark_portal", 1, 0)} : ZL);
		aRegistry.add("Miniature Last Millenium Portal"                     , "Portals"                             , 32004, 32766, MultiTileEntityMiniPortalEndOfTime.class                ,                 2, 16, aStone         , UT.NBT.make(NBT_HIDDEN, !(MD.ExU.mLoaded || MD.ExS.mLoaded)), MD.ExS.mLoaded ? new Object[] {"SSS", "SXS", "SSS", 'S', OP.stickLong.dat(MT.Obsidian), 'X', ST.make(MD.ExS, "deepPortal", 1, 2)} : MD.ExU.mLoaded ? new Object[] {"SSS", "SXS", "SSS", 'S', OP.stickLong.dat(MT.Obsidian), 'X', ST.make(MD.ExU, "dark_portal", 1, 2)} : ZL);
		
		aRegistry.add("C-Foam Block"                                        , "C-Foam"                              , 32765, 32765, MultiTileEntityCFoam.class                              ,                 1, 64, aStone         , null);
		aRegistry.add("Loot Crate"                                          , "Untyped"                             , 32110, 32764, MultiTileEntityLootCrate.class                          ,                 0, 64, aUtilWood      , null, "wrd", "FGT", "SLC", 'L', OD.crateGtEmpty, 'G', OP.gearGtSmall.dat(MT.Au), 'S', OP.spring.dat(MT.Au), 'T', OP.screw.dat(MT.Au), 'C', OP.casingSmall.dat(MT.Au), 'F', OP.foil.dat(MT.Au)); IL.Crate_Loot.set(aRegistry.getItem());
		aRegistry.add("Supporter Certificate"                               , "Untyped"                             , 32764, 32764, MultiTileEntityCertificate.class                        ,                 0, 64, aUtilMetal     , UT.NBT.make(NBT_HARDNESS, 0.5F, NBT_RESISTANCE, 0.3F));
		aRegistry.add("Fluid Spring"                                        , "Untyped"                             , 32763, 32764, MultiTileEntityFluidSpring.class                        ,                 0, 64, aStone         , null);
		aRegistry.add("Rubber Resin Hole"                                   , "Untyped"                             , 32762, 32764, MultiTileEntityResinHoleRubber.class                    ,                 0,  1, aWooden        , null);
		aRegistry.add("Tapped Maple"                                        , "Untyped"                             , 32761, 32764, MultiTileEntitySapHoleMaple.class                       ,                 0,  1, aWooden        , null);
		aRegistry.add("Tapped Rainbowood"                                   , "Untyped"                             , 32760, 32764, MultiTileEntitySapHoleRainbowood.class                  ,                 0,  1, aWooden        , null);
		aRegistry.add("Berry Bush"                                          , "Untyped"                             , 32759, 32764, MultiTileEntityBush.class                               ,                 0, 64, aBush          , UT.NBT.make(NBT_HARDNESS, 0.5F, NBT_RESISTANCE, 0.3F)); RM.biomass(aRegistry.getItem());
		aRegistry.add("Greg o'Lantern"                                      , "Untyped"                             , 32758, 32764, MultiTileEntityGregOLantern.class                       ,                 0, 64, aUtilWood      , null, "Pk", "T ", 'P', Blocks.pumpkin, 'T', OD.blockTorch); RM.biomass(aRegistry.getItem());
		aRegistry.add("Sandwich"                                            , "Untyped"                             , 32105, 32764, MultiTileEntitySandwich.class                           ,                 0, 64, aUtilWool      , null);
		aRegistry.add("Rock"                                                , "Untyped"                             , 32757, 32764, gregtech.tileentity.misc.MultiTileEntityRock.class      ,                 0, 64, aUtilStone     , null); // yes I have to pass the "gregtech.tileentity.misc.MultiTileEntityRock" Version!
		aRegistry.add("Rock"                                                , "Untyped"                             , 32074, 32764, MultiTileEntityRockPlaced.class                         ,                 0, 64, aUtilStone     , null);
		aRegistry.add("Stick"                                               , "Untyped"                             , 32756, 32764, MultiTileEntityStick.class                              ,                 0, 64, aUtilWood      , null);
		aRegistry.add("Stick"                                               , "Untyped"                             , 32073, 32764, MultiTileEntityStickPlaced.class                        ,                 0, 64, aUtilWood      , null);
		aRegistry.add("Ingots"                                              , "Untyped"                             , 32084, 32764, MultiTileEntityIngot.class                              ,                 0, 64, aUtilMetal     , null);
		aRegistry.add("Plates"                                              , "Untyped"                             , 32085, 32764, MultiTileEntityPlate.class                              ,                 0, 64, aUtilMetal     , null);
		aRegistry.add("Gem Plates"                                          , "Untyped"                             , 32086, 32764, MultiTileEntityPlateGem.class                           ,                 0, 64, aUtilStone     , null);
		aRegistry.add("Scrap"                                               , "Untyped"                             , 32103, 32764, MultiTileEntityScrap.class                              ,                 0, 64, aUtilMetal     , null);
		aRegistry.add("Bumble Hive"                                         , "Untyped"                             , 32755, 32764, MultiTileEntityBumbleHive.class                         ,                 0, 64, aHive          , null);
		
		for (int i = 0; i < 16; i++) {
			ItemStack
			tPanel = aRegistry.add("Concrete Panel", "Panels", i+32452, 32500, MultiTileEntityPanelConcrete.class, 0, 16, aStone, UT.NBT.make(NBT_COLOR, i));
			CR.shaped(ST.amount(6, tPanel), CR.DEF_REV_NCC_MIR, "TsT", "TPT", "TdT", 'P', ST.make(BlocksGT.Concrete, 1, i), 'T', OP.screw.dat(ANY.Iron));
			CoverRegistry.put(tPanel, new CoverTextureSimple(BlockTextureDefault.get(Textures.BlockIcons.CONCRETE, DYES[i]), SFX.MC_DIG_ROCK));
			
			tPanel = aRegistry.add("C-Foam Panel", "Panels", i+32468, 32500, MultiTileEntityPanelCFoam.class, 0, 16, aStone, UT.NBT.make(NBT_COLOR, i));
			CR.shaped(ST.amount(6, tPanel), CR.DEF_REV_NCC_MIR, "TsT", "TPT", "TdT", 'P', ST.make(BlocksGT.CFoam, 1, i), 'T', OP.screw.dat(ANY.Iron));
			CoverRegistry.put(tPanel, new CoverTextureSimple(BlockTextureDefault.get(Textures.BlockIcons.CFOAM_HARDENED, DYES[i]), SFX.MC_DIG_ROCK));
			
			tPanel = aRegistry.add("Asphalt Panel", "Panels", i+32484, 32500, MultiTileEntityPanelAsphalt.class, 0, 16, aStone, UT.NBT.make(NBT_COLOR, i));
			CR.shaped(ST.amount(6, tPanel), CR.DEF_REV_NCC_MIR, "TsT", "TPT", "TdT", 'P', ST.make(BlocksGT.Asphalt, 1, i), 'T', OP.screw.dat(ANY.Iron));
			CoverRegistry.put(tPanel, new CoverAsphalt(BlockTextureDefault.get(Textures.BlockIcons.ASPHALT, DYES[i])));
		}
		for (int i = 0; i < 100; i++) {
			ItemStack tPanel = aRegistry.add("Wooden Panel", "Panels", i+32500, 32500, MultiTileEntityPanelWood.class, 0, 16, aWooden, UT.NBT.make(NBT_TEXTURE, i, NBT_HIDDEN, ST.invalid(PlankData.PLANKS[i])));
			if (ST.valid(PlankData.PLANKS[i])) {
				CR.shaped(ST.amount(6, tPanel), CR.DEF_REV_NCC_MIR, "TsT", "TPT", "TdT", 'P', PlankData.PLANKS[i], 'T', OP.screw.dat(ANY.Iron));
				CoverRegistry.put(tPanel, new CoverTextureSimple(BlockTextureDefault.get(PlankData.PLANK_ICONS[i]), SFX.MC_DIG_WOOD));
			} else {
				CoverRegistry.put(tPanel, new CoverTextureSimple(BlockTextureCopied.get(Blocks.planks), SFX.MC_DIG_WOOD));
			}
		}
		for (int i = 0; i < 100; i++) {
			ItemStack tPanel = aRegistry.add("Wooden Panel", "Panels", i+32352, 32500, MultiTileEntityPanelWood.class, 0, 16, aWooden, UT.NBT.make(NBT_TEXTURE, i+100, NBT_HIDDEN, ST.invalid(PlankData.PLANKS[i+100])));
			if (ST.valid(PlankData.PLANKS[i+100])) {
				CR.shaped(ST.amount(6, tPanel), CR.DEF_REV_NCC_MIR, "TsT", "TPT", "TdT", 'P', PlankData.PLANKS[i+100], 'T', OP.screw.dat(ANY.Iron));
				CoverRegistry.put(tPanel, new CoverTextureSimple(BlockTextureDefault.get(PlankData.PLANK_ICONS[i+100]), SFX.MC_DIG_WOOD));
			} else {
				CoverRegistry.put(tPanel, new CoverTextureSimple(BlockTextureCopied.get(Blocks.planks), SFX.MC_DIG_WOOD));
			}
		}
		for (int i = 0; i < 100; i++) {
			ItemStack tPanel = aRegistry.add("Wooden Panel", "Panels", i+32252, 32500, MultiTileEntityPanelWood.class, 0, 16, aWooden, UT.NBT.make(NBT_TEXTURE, i+200, NBT_HIDDEN, ST.invalid(PlankData.PLANKS[i+200])));
			if (ST.valid(PlankData.PLANKS[i+200])) {
				CR.shaped(ST.amount(6, tPanel), CR.DEF_REV_NCC_MIR, "TsT", "TPT", "TdT", 'P', PlankData.PLANKS[i+200], 'T', OP.screw.dat(ANY.Iron));
				CoverRegistry.put(tPanel, new CoverTextureSimple(BlockTextureDefault.get(PlankData.PLANK_ICONS[i+200]), SFX.MC_DIG_WOOD));
			} else {
				CoverRegistry.put(tPanel, new CoverTextureSimple(BlockTextureCopied.get(Blocks.planks), SFX.MC_DIG_WOOD));
			}
		}
		
		// 32111 is next, up to 32251
		
		aMat = MT.Brown;            aRegistry.add("Rope"                                                , "Ropes"                               , 32011, 32011, MultiTileEntityRope.class                               ,                 0, 64, aUtilWool      , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   0.5F, NBT_RESISTANCE,   1.0F, NBT_FLAMMABILITY,100),  " S",  "SS",  "Sq", 'S', "cropHemp");                   IL.Rope        .set(aRegistry.getItem(), null, "rope");
		aMat = MT.White;            aRegistry.add("Silk Rope"                                           , "Ropes"                               , 32012, 32011, MultiTileEntityRope.class                               ,                 0, 64, aUtilWool      , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   0.5F, NBT_RESISTANCE,   1.0F                      ),  " S",  "SS",  "Sq", 'S', Items.string);                 IL.Rope_Silk   .set(aRegistry.getItem(), null, "rope");
		aMat = MT.Yellow;           aRegistry.add("Grass Rope"                                          , "Ropes"                               , 32013, 32011, MultiTileEntityRope.class                               ,                 0, 64, aUtilWool      , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   0.5F, NBT_RESISTANCE,   1.0F, NBT_FLAMMABILITY,100), " GG", "GGG", "GGq", 'G', OD.itemGrassDry);              IL.Rope_Grass  .set(aRegistry.getItem(), null, "rope");
		aMat = MT.Green;            aRegistry.add("Vine Rope"                                           , "Ropes"                               , 32108, 32011, MultiTileEntityRope.class                               ,                 0, 64, aUtilWool      , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   0.5F, NBT_RESISTANCE,   1.0F, NBT_FLAMMABILITY,100),  " V",  "VV",  "Vb", 'V', Blocks.vine);                  IL.Rope_Vine   .set(aRegistry.getItem(), null, "rope");
		aMat = ANY.Plastic;         aRegistry.add("Plastic Rope"                                        , "Ropes"                               , 32014, 32011, MultiTileEntityRope.class                               ,                 0, 64, aUtilWool      , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   0.5F, NBT_RESISTANCE,   1.0F                      ),  " P",  "PP",  "Pq", 'P', OP.wireFine.dat(ANY.Plastic)); IL.Rope_Plastic.set(aRegistry.getItem(), null, "rope");
		
		aMat = MT.Porcelain;        aRegistry.add("Porcelain Cup"                                       , "Fluid Containers"                    , 32739, 32719, MultiTileEntityCup.class                                ,                 0, 16, aUtilStone     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   0.5F, NBT_RESISTANCE,   6.0F, NBT_TANK_CAPACITY,  250, NBT_ACIDPROOF, F, NBT_LIQUIDPROOF, T, NBT_GASPROOF, F, NBT_MAGICPROOF, T, NBT_TEMPERATURE, aMat.mMeltingPoint)); IL.Porcelain_Cup.set(aRegistry.getItem(), new OreDictItemData(MT.Porcelain, U*1)); RM.add_smelting(IL.Porcelain_Cup_Raw.get(1), IL.Porcelain_Cup.get(1), F, F, T);
		aMat = MT.Ceramic;          aRegistry.add("Ceramic Jug"                                         , "Fluid Containers"                    , 32740, 32719, MultiTileEntityJug.class                                ,                 0, 16, aUtilStone     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   0.5F, NBT_RESISTANCE,   6.0F, NBT_TANK_CAPACITY, 2000, NBT_ACIDPROOF, F, NBT_LIQUIDPROOF, T, NBT_GASPROOF, F, NBT_MAGICPROOF, F, NBT_TEMPERATURE, aMat.mMeltingPoint)); IL.Ceramic_Jug  .set(aRegistry.getItem(), new OreDictItemData(MT.Ceramic  , U*6)); RM.add_smelting(IL.Ceramic_Jug_Raw  .get(1), IL.Ceramic_Jug  .get(1), F, F, T);
		aMat = MT.Ceramic;          aRegistry.add("Ceramic Measuring Pot"                               , "Fluid Containers"                    , 32738, 32719, MultiTileEntityMeasuringPot.class                       ,                 0, 16, aUtilStone     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   0.5F, NBT_RESISTANCE,   6.0F, NBT_TANK_CAPACITY, 1000, NBT_ACIDPROOF, F, NBT_LIQUIDPROOF, T, NBT_GASPROOF, F, NBT_MAGICPROOF, F, NBT_TEMPERATURE, aMat.mMeltingPoint)); IL.Measuring_Pot.set(aRegistry.getItem(), new OreDictItemData(MT.Ceramic  , U*4)); RM.add_smelting(IL.Measuring_Pot_Raw.get(1), IL.Measuring_Pot.get(1), F, F, T);
		aMat = MT.StainlessSteel;   aRegistry.add("Stainless Measuring Pot"                             , "Fluid Containers"                    , 32743, 32719, MultiTileEntityMeasuringPot.class                       ,                 0, 16, aUtilMetal     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   0.5F, NBT_RESISTANCE,   6.0F, NBT_TANK_CAPACITY, 1000, NBT_ACIDPROOF, T, NBT_LIQUIDPROOF, T, NBT_GASPROOF, F, NBT_MAGICPROOF, F, NBT_TEMPERATURE, aMat.mMeltingPoint-50), "Ch", "Pf", 'P', OP.plate.dat(aMat), 'C', OP.plateCurved.dat(aMat));
		aMat = ANY.W;               aRegistry.add("Tungsten Measuring Pot"                              , "Fluid Containers"                    , 32744, 32719, MultiTileEntityMeasuringPot.class                       ,                 0, 16, aUtilMetal     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   0.5F, NBT_RESISTANCE,  10.0F, NBT_TANK_CAPACITY, 1000, NBT_ACIDPROOF, T, NBT_LIQUIDPROOF, T, NBT_GASPROOF, F, NBT_MAGICPROOF, T, NBT_TEMPERATURE, aMat.mMeltingPoint-50), "Ch", "Pf", 'P', OP.plate.dat(aMat), 'C', OP.plateCurved.dat(aMat));
		aMat = MT.Ta4HfC5;          aRegistry.add("Tantalum Hafnium Carbide Measuring Pot"              , "Fluid Containers"                    , 32077, 32719, MultiTileEntityMeasuringPot.class                       ,                 0, 16, aUtilMetal     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   0.5F, NBT_RESISTANCE,  10.0F, NBT_TANK_CAPACITY, 1000, NBT_ACIDPROOF, F, NBT_LIQUIDPROOF, T, NBT_GASPROOF, F, NBT_MAGICPROOF, T, NBT_TEMPERATURE, aMat.mMeltingPoint-50), "Ch", "Pf", 'P', OP.plate.dat(aMat), 'C', OP.plateCurved.dat(aMat));
		aMat = MT.Al;               aRegistry.add("Thermos Can"                                         , "Fluid Containers"                    , 32737, 32719, MultiTileEntityThermos.class                            ,                 0, 16, aUtilMetal     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   0.5F, NBT_RESISTANCE,   6.0F, NBT_TANK_CAPACITY, 4000, NBT_ACIDPROOF, F, NBT_LIQUIDPROOF, T, NBT_GASPROOF, F, NBT_MAGICPROOF, T, NBT_TEMPERATURE, aMat.mMeltingPoint-50), "hPw", "PAP", "SBS", 'A', OP.pipeMedium.dat(aMat), 'B', OP.pipeLarge.dat(aMat), 'S', OP.foil.dat(MT.Ag), 'P', OP.plateCurved.dat(ANY.Plastic));
		aMat = ANY.Steel;           aRegistry.add("Steel Barometer Gas Cylinder"                        , "Fluid Containers"                    , 32055, 32719, MultiTileEntityBarometerGasCylinder.class               ,                 0, 16, aUtilMetal     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   0.5F, NBT_RESISTANCE,   6.0F, NBT_TANK_CAPACITY, 8000, NBT_ACIDPROOF, F, NBT_LIQUIDPROOF, F, NBT_GASPROOF, T, NBT_MAGICPROOF, F, NBT_TEMPERATURE, aMat.mMeltingPoint-50), "RCR", "BCh", "TPd", 'P', OP.plate.dat(aMat), 'C', OP.plateCurved.dat(aMat), 'R', OP.ring.dat(aMat), 'B', OP.round.dat(aMat), 'T', OP.screw.dat(aMat));
		aMat = MT.StainlessSteel;   aRegistry.add("Stainless Barometer Gas Cylinder"                    , "Fluid Containers"                    , 32056, 32719, MultiTileEntityBarometerGasCylinder.class               ,                 0, 16, aUtilMetal     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   0.5F, NBT_RESISTANCE,   6.0F, NBT_TANK_CAPACITY, 8000, NBT_ACIDPROOF, T, NBT_LIQUIDPROOF, F, NBT_GASPROOF, T, NBT_MAGICPROOF, F, NBT_TEMPERATURE, aMat.mMeltingPoint-50), "RCR", "BCh", "TPd", 'P', OP.plate.dat(aMat), 'C', OP.plateCurved.dat(aMat), 'R', OP.ring.dat(aMat), 'B', OP.round.dat(aMat), 'T', OP.screw.dat(aMat));
		aMat = ANY.W;               aRegistry.add("Tungsten Barometer Gas Cylinder"                     , "Fluid Containers"                    , 32057, 32719, MultiTileEntityBarometerGasCylinder.class               ,                 0, 16, aUtilMetal     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   0.5F, NBT_RESISTANCE,  10.0F, NBT_TANK_CAPACITY, 8000, NBT_ACIDPROOF, T, NBT_LIQUIDPROOF, F, NBT_GASPROOF, T, NBT_MAGICPROOF, T, NBT_TEMPERATURE, aMat.mMeltingPoint-50), "RCR", "BCh", "TPd", 'P', OP.plate.dat(aMat), 'C', OP.plateCurved.dat(aMat), 'R', OP.ring.dat(aMat), 'B', OP.round.dat(aMat), 'T', OP.screw.dat(aMat));
		aMat = MT.Ta4HfC5;          aRegistry.add("Tantalum Hafnium Carbide Barometer Gas Cylinder"     , "Fluid Containers"                    , 32078, 32719, MultiTileEntityBarometerGasCylinder.class               ,                 0, 16, aUtilMetal     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   0.5F, NBT_RESISTANCE,  10.0F, NBT_TANK_CAPACITY, 8000, NBT_ACIDPROOF, F, NBT_LIQUIDPROOF, F, NBT_GASPROOF, T, NBT_MAGICPROOF, T, NBT_TEMPERATURE, aMat.mMeltingPoint-50), "RCR", "BCh", "TPd", 'P', OP.plate.dat(aMat), 'C', OP.plateCurved.dat(aMat), 'R', OP.ring.dat(aMat), 'B', OP.round.dat(aMat), 'T', OP.screw.dat(aMat));
		
		aMat = MT.Ceramic;          aRegistry.add("Ceramic Tap"                                         , "Misc Tool Blocks"                    , 32728, 32720, MultiTileEntityFluidTap.class                           ,                 0, 64, aUtilStone     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   0.5F, NBT_RESISTANCE,   5.0F, NBT_ACIDPROOF, F, NBT_MAGICPROOF, F)); IL.Ceramic_Tap.set(aRegistry.getItem(), new OreDictItemData(MT.Ceramic, U*3)); RM.add_smelting(IL.Ceramic_Tap_Raw.get(1), IL.Ceramic_Tap.get(1), F, F, T);
		aMat = MT.Plastic;          aRegistry.add("Plastic Tap"                                         , "Misc Tool Blocks"                    , 32729, 32720, MultiTileEntityFluidTap.class                           ,                 0, 64, aUtilWood      , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   0.5F, NBT_RESISTANCE,   3.0F, NBT_ACIDPROOF, F, NBT_MAGICPROOF, F), "  s", "PP ", "xP ", 'P', OP.plateCurved.dat(aMat));
		aMat = MT.StainlessSteel;   aRegistry.add("Stainless Tap"                                       , "Misc Tool Blocks"                    , 32730, 32720, MultiTileEntityFluidTap.class                           ,                 0, 64, aUtilMetal     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   0.5F, NBT_RESISTANCE,   6.0F, NBT_ACIDPROOF, T, NBT_MAGICPROOF, F), "  h", "PP ", "oP ", 'P', OP.plateCurved.dat(aMat));
		aMat = ANY.W;               aRegistry.add("Tungsten Tap"                                        , "Misc Tool Blocks"                    , 32731, 32720, MultiTileEntityFluidTap.class                           ,                 0, 64, aUtilMetal     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   0.5F, NBT_RESISTANCE,  10.0F, NBT_ACIDPROOF, T, NBT_MAGICPROOF, T), "  h", "PP ", "oP ", 'P', OP.plateCurved.dat(aMat));
		aMat = MT.Ta4HfC5;          aRegistry.add("Tantalum Hafnium Carbide Tap"                        , "Misc Tool Blocks"                    , 32080, 32720, MultiTileEntityFluidTap.class                           ,                 0, 64, aUtilMetal     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   0.5F, NBT_RESISTANCE,  10.0F, NBT_ACIDPROOF, F, NBT_MAGICPROOF, T), "  h", "PP ", "oP ", 'P', OP.plateCurved.dat(aMat));
		aMat = MT.Ad;               aRegistry.add("Adamantium Tap"                                      , "Misc Tool Blocks"                    , 32732, 32720, MultiTileEntityFluidTap.class                           ,                 0, 64, aUtilMetal     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   0.5F, NBT_RESISTANCE, 100.0F, NBT_ACIDPROOF, T, NBT_MAGICPROOF, T), "  h", "PP ", "oP ", 'P', OP.plateCurved.dat(aMat));
		
		aMat = MT.Ceramic;          aRegistry.add("Ceramic Funnel"                                      , "Misc Tool Blocks"                    , 32723, 32720, MultiTileEntityFluidFunnel.class                        ,                 0, 64, aUtilStone     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   0.5F, NBT_RESISTANCE,   5.0F, NBT_ACIDPROOF, F, NBT_MAGICPROOF, F)); IL.Ceramic_Funnel.set(aRegistry.getItem(), new OreDictItemData(MT.Ceramic, U*3)); RM.add_smelting(IL.Ceramic_Funnel_Raw.get(1), IL.Ceramic_Funnel.get(1), F, F, T);
		aMat = MT.Plastic;          aRegistry.add("Plastic Funnel"                                      , "Misc Tool Blocks"                    , 32724, 32720, MultiTileEntityFluidFunnel.class                        ,                 0, 64, aUtilWood      , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   0.5F, NBT_RESISTANCE,   3.0F, NBT_ACIDPROOF, F, NBT_MAGICPROOF, F), " s ", "PxP", " P ", 'P', OP.plateCurved.dat(aMat));
		aMat = MT.StainlessSteel;   aRegistry.add("Stainless Funnel"                                    , "Misc Tool Blocks"                    , 32725, 32720, MultiTileEntityFluidFunnel.class                        ,                 0, 64, aUtilMetal     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   0.5F, NBT_RESISTANCE,   6.0F, NBT_ACIDPROOF, T, NBT_MAGICPROOF, F), " h ", "PoP", " P ", 'P', OP.plateCurved.dat(aMat));
		aMat = ANY.W;               aRegistry.add("Tungsten Funnel"                                     , "Misc Tool Blocks"                    , 32726, 32720, MultiTileEntityFluidFunnel.class                        ,                 0, 64, aUtilMetal     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   0.5F, NBT_RESISTANCE,  10.0F, NBT_ACIDPROOF, T, NBT_MAGICPROOF, T), " h ", "PoP", " P ", 'P', OP.plateCurved.dat(aMat));
		aMat = MT.Ta4HfC5;          aRegistry.add("Tantalum Hafnium Carbide Funnel"                     , "Misc Tool Blocks"                    , 32081, 32720, MultiTileEntityFluidFunnel.class                        ,                 0, 64, aUtilMetal     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   0.5F, NBT_RESISTANCE,  10.0F, NBT_ACIDPROOF, F, NBT_MAGICPROOF, T), " h ", "PoP", " P ", 'P', OP.plateCurved.dat(aMat));
		aMat = MT.Ad;               aRegistry.add("Adamantium Funnel"                                   , "Misc Tool Blocks"                    , 32727, 32720, MultiTileEntityFluidFunnel.class                        ,                 0, 64, aUtilMetal     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   0.5F, NBT_RESISTANCE, 100.0F, NBT_ACIDPROOF, T, NBT_MAGICPROOF, T), " h ", "PoP", " P ", 'P', OP.plateCurved.dat(aMat));
		
		aMat = MT.Plastic;          aRegistry.add("Plastic Nozzle"                                      , "Misc Tool Blocks"                    , 32747, 32720, MultiTileEntityFluidNozzle.class                        ,                 0, 64, aUtilWood      , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   0.5F, NBT_RESISTANCE,   3.0F, NBT_ACIDPROOF, F, NBT_MAGICPROOF, F), "  s", "PRP", "x  ", 'R', OP.ring.dat(ANY.Rubber), 'P', OP.plateCurved.dat(aMat));
		aMat = ANY.Steel;           aRegistry.add("Steel Nozzle"                                        , "Misc Tool Blocks"                    , 32746, 32720, MultiTileEntityFluidNozzle.class                        ,                 0, 64, aUtilMetal     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   0.5F, NBT_RESISTANCE,   5.0F, NBT_ACIDPROOF, F, NBT_MAGICPROOF, F), "  h", "PRP", "o  ", 'R', OP.ring.dat(ANY.Rubber), 'P', OP.plateCurved.dat(aMat));
		aMat = MT.StainlessSteel;   aRegistry.add("Stainless Nozzle"                                    , "Misc Tool Blocks"                    , 32748, 32720, MultiTileEntityFluidNozzle.class                        ,                 0, 64, aUtilMetal     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   0.5F, NBT_RESISTANCE,   6.0F, NBT_ACIDPROOF, T, NBT_MAGICPROOF, F), "  h", "PRP", "o  ", 'R', OP.ring.dat(ANY.Rubber), 'P', OP.plateCurved.dat(aMat));
		aMat = ANY.W;               aRegistry.add("Tungsten Nozzle"                                     , "Misc Tool Blocks"                    , 32749, 32720, MultiTileEntityFluidNozzle.class                        ,                 0, 64, aUtilMetal     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   0.5F, NBT_RESISTANCE,  10.0F, NBT_ACIDPROOF, T, NBT_MAGICPROOF, T), "  h", "PRP", "o  ", 'R', OP.ring.dat(aMat), 'P', OP.plateCurved.dat(aMat));
		aMat = MT.Ta4HfC5;          aRegistry.add("Tantalum Hafnium Carbide Nozzle"                     , "Misc Tool Blocks"                    , 32079, 32720, MultiTileEntityFluidNozzle.class                        ,                 0, 64, aUtilMetal     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   0.5F, NBT_RESISTANCE,  10.0F, NBT_ACIDPROOF, F, NBT_MAGICPROOF, T), "  h", "PRP", "o  ", 'R', OP.ring.dat(aMat), 'P', OP.plateCurved.dat(aMat));
		aMat = MT.Ad;               aRegistry.add("Adamantium Nozzle"                                   , "Misc Tool Blocks"                    , 32750, 32720, MultiTileEntityFluidNozzle.class                        ,                 0, 64, aUtilMetal     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   0.5F, NBT_RESISTANCE, 100.0F, NBT_ACIDPROOF, T, NBT_MAGICPROOF, T), "  h", "PRP", "o  ", 'R', OP.ring.dat(aMat), 'P', OP.plateCurved.dat(aMat));
		
		aMat = MT.Plastic;          aRegistry.add("Plastic Cap Nozzle"                                  , "Misc Tool Blocks"                    , 32059, 32720, MultiTileEntityFluidCapNozzle.class                     ,                 0, 64, aUtilWood      , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   0.5F, NBT_RESISTANCE,   3.0F, NBT_ACIDPROOF, F, NBT_MAGICPROOF, F), "Rw", "BT", "Nd", 'N', aRegistry.getItem(32747), 'R', OP.ring.dat(ANY.Rubber), 'B', OP.round.dat(aMat), 'T', OP.screw.dat(aMat));
		aMat = ANY.Steel;           aRegistry.add("Steel Cap Nozzle"                                    , "Misc Tool Blocks"                    , 32058, 32720, MultiTileEntityFluidCapNozzle.class                     ,                 0, 64, aUtilMetal     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   0.5F, NBT_RESISTANCE,   5.0F, NBT_ACIDPROOF, F, NBT_MAGICPROOF, F), "Rw", "BT", "Nd", 'N', aRegistry.getItem(32746), 'R', OP.ring.dat(ANY.Rubber), 'B', OP.round.dat(aMat), 'T', OP.screw.dat(aMat));
		aMat = MT.StainlessSteel;   aRegistry.add("Stainless Cap Nozzle"                                , "Misc Tool Blocks"                    , 32060, 32720, MultiTileEntityFluidCapNozzle.class                     ,                 0, 64, aUtilMetal     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   0.5F, NBT_RESISTANCE,   6.0F, NBT_ACIDPROOF, T, NBT_MAGICPROOF, F), "Rw", "BT", "Nd", 'N', aRegistry.getItem(32748), 'R', OP.ring.dat(ANY.Rubber), 'B', OP.round.dat(aMat), 'T', OP.screw.dat(aMat));
		aMat = ANY.W;               aRegistry.add("Tungsten Cap Nozzle"                                 , "Misc Tool Blocks"                    , 32061, 32720, MultiTileEntityFluidCapNozzle.class                     ,                 0, 64, aUtilMetal     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   0.5F, NBT_RESISTANCE,  10.0F, NBT_ACIDPROOF, T, NBT_MAGICPROOF, T), "Rw", "BT", "Nd", 'N', aRegistry.getItem(32749), 'R', OP.ring.dat(aMat), 'B', OP.round.dat(aMat), 'T', OP.screw.dat(aMat));
		aMat = MT.Ta4HfC5;          aRegistry.add("Tantalum Hafnium Carbide Cap Nozzle"                 , "Misc Tool Blocks"                    , 32082, 32720, MultiTileEntityFluidCapNozzle.class                     ,                 0, 64, aUtilMetal     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   0.5F, NBT_RESISTANCE,  10.0F, NBT_ACIDPROOF, F, NBT_MAGICPROOF, T), "Rw", "BT", "Nd", 'N', aRegistry.getItem(32749), 'R', OP.ring.dat(aMat), 'B', OP.round.dat(aMat), 'T', OP.screw.dat(aMat));
		aMat = MT.Ad;               aRegistry.add("Adamantium Cap Nozzle"                               , "Misc Tool Blocks"                    , 32062, 32720, MultiTileEntityFluidCapNozzle.class                     ,                 0, 64, aUtilMetal     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   0.5F, NBT_RESISTANCE, 100.0F, NBT_ACIDPROOF, T, NBT_MAGICPROOF, T), "Rw", "BT", "Nd", 'N', aRegistry.getItem(32750), 'R', OP.ring.dat(aMat), 'B', OP.round.dat(aMat), 'T', OP.screw.dat(aMat));
		
		aMat = ANY.Wood;            aRegistry.add("Wooden Barrel (Cheap)"                               , "Fluid Containers"                    , 32733, 32719, MultiTileEntityBarrelWood.class                         ,                 0, 16, aUtilWood      , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   1.0F, NBT_RESISTANCE,   5.0F, NBT_TANK_CAPACITY,        8000L, NBT_PLASMAPROOF, F, NBT_GASPROOF, F, NBT_ACIDPROOF, F, NBT_MAGICPROOF, F, NBT_CAPACITY_HU,        340, NBT_FLAMMABILITY,       100), "rGs", "PSP", "PSP", 'G', OD.itemGlue, 'P', OD.plankAnyWood   , 'S', OP.stickLong.dat(MT.Pb));
		aMat = ANY.Wood;            aRegistry.add("Wooden Barrel (Cheap)"                               , "Fluid Containers"                    , 32752, 32719, MultiTileEntityBarrelWood.class                         ,                 0, 16, aUtilWood      , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   1.0F, NBT_RESISTANCE,   5.0F, NBT_TANK_CAPACITY,        8000L, NBT_PLASMAPROOF, F, NBT_GASPROOF, F, NBT_ACIDPROOF, F, NBT_MAGICPROOF, F, NBT_CAPACITY_HU,        340, NBT_FLAMMABILITY,       100), "rGs", "PSP", "PSP", 'G', OD.itemGlue, 'P', OD.plankAnyWood   , 'S', OP.stickLong.dat(MT.Bi));
		aMat = ANY.Wood;            aRegistry.add("Wooden Barrel (Cheap)"                               , "Fluid Containers"                    , 32753, 32719, MultiTileEntityBarrelWood.class                         ,                 0, 16, aUtilWood      , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   1.0F, NBT_RESISTANCE,   5.0F, NBT_TANK_CAPACITY,        8000L, NBT_PLASMAPROOF, F, NBT_GASPROOF, F, NBT_ACIDPROOF, F, NBT_MAGICPROOF, F, NBT_CAPACITY_HU,        340, NBT_FLAMMABILITY,       100), "rGs", "PSP", "PSP", 'G', OD.itemGlue, 'P', OD.plankAnyWood   , 'S', OP.stickLong.dat(MT.Bronze));
		aMat = ANY.Wood;            aRegistry.add("Wooden Barrel (Cheap)"                               , "Fluid Containers"                    , 32754, 32719, MultiTileEntityBarrelWood.class                         ,                 0, 16, aUtilWood      , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   1.0F, NBT_RESISTANCE,   5.0F, NBT_TANK_CAPACITY,        8000L, NBT_PLASMAPROOF, F, NBT_GASPROOF, F, NBT_ACIDPROOF, F, NBT_MAGICPROOF, F, NBT_CAPACITY_HU,        340, NBT_FLAMMABILITY,       100), "rGs", "PSP", "PSP", 'G', OD.itemGlue, 'P', OD.plankAnyWood   , 'S', OP.stickLong.dat(MT.Brass));
		aMat = MT.WoodTreated;      aRegistry.add("Wooden Barrel"                                       , "Fluid Containers"                    , 32714, 32719, MultiTileEntityBarrelWood.class                         ,                 0, 16, aUtilWood      , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   1.0F, NBT_RESISTANCE,   5.0F, NBT_TANK_CAPACITY,       16000L, NBT_PLASMAPROOF, F, NBT_GASPROOF, F, NBT_ACIDPROOF, F, NBT_MAGICPROOF, F, NBT_CAPACITY_HU,        340, NBT_FLAMMABILITY,       100), "rGs", "PSP", "PSP", 'G', OD.itemGlue, 'P', OP.plate.dat(aMat), 'S', OP.stickLong.dat(ANY.Iron));
		aMat = MT.WOODS.Rainbowood; aRegistry.add("Rainbowood Barrel"                                   , "Fluid Containers"                    , 32109, 32719, MultiTileEntityBarrelWood.class                         ,                 0, 16, aUtilWood      , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   1.0F, NBT_RESISTANCE,   5.0F, NBT_TANK_CAPACITY,       32000L, NBT_PLASMAPROOF, F, NBT_GASPROOF, F, NBT_ACIDPROOF, F, NBT_MAGICPROOF, T, NBT_CAPACITY_HU,        390                             ), "rGs", "PSP", "PSP", 'G', OD.itemGlue, 'P', OP.plate.dat(aMat), 'S', OP.stickLong.dat(ANY.Iron));
		aMat = MT.Skyroot;          aRegistry.add("Skyroot Barrel"                                      , "Fluid Containers"                    , 32019, 32719, MultiTileEntityBarrelWood.class                         ,                 0, 16, aUtilWood      , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   1.0F, NBT_RESISTANCE,   5.0F, NBT_TANK_CAPACITY,       16000L, NBT_PLASMAPROOF, F, NBT_GASPROOF, F, NBT_ACIDPROOF, F, NBT_MAGICPROOF, T, NBT_CAPACITY_HU,        340, NBT_FLAMMABILITY,       100), "rGs", "PSP", "PSP", 'G', OD.itemGlue, 'P', OD.plankSkyroot   , 'S', OP.stickLong.dat(ANY.Iron));
		aMat = MT.Weedwood;         aRegistry.add("Weedwood Barrel"                                     , "Fluid Containers"                    , 32008, 32719, MultiTileEntityBarrelWood.class                         ,                 0, 16, aUtilWood      , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   1.0F, NBT_RESISTANCE,   5.0F, NBT_TANK_CAPACITY,        8000L, NBT_PLASMAPROOF, F, NBT_GASPROOF, F, NBT_ACIDPROOF, F, NBT_MAGICPROOF, T, NBT_CAPACITY_HU,        340                             ), "rGs", "PSP", "PSP", 'G', OD.itemGlue, 'P', OD.plankWeedwood  , 'S', OP.stickLong.dat(MT.Syrmorite));
		aMat = MT.Livingwood;       aRegistry.add("Livingwood Barrel"                                   , "Fluid Containers"                    , 32010, 32719, MultiTileEntityBarrelWood.class                         ,                 0, 16, aUtilWood      , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   1.0F, NBT_RESISTANCE,   5.0F, NBT_TANK_CAPACITY,       16000L, NBT_PLASMAPROOF, F, NBT_GASPROOF, F, NBT_ACIDPROOF, F, NBT_MAGICPROOF, T, NBT_CAPACITY_HU,        340, NBT_FLAMMABILITY,       100), "rGs", "PSP", "PSP", 'G', OD.itemGlue, 'P', OP.plate.dat(aMat), 'S', OP.stickLong.dat(ANY.Iron));
		aMat = MT.Dreamwood;        aRegistry.add("Dreamwood Barrel"                                    , "Fluid Containers"                    , 32009, 32719, MultiTileEntityBarrelWood.class                         ,                 0, 16, aUtilWood      , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   1.0F, NBT_RESISTANCE,   5.0F, NBT_TANK_CAPACITY,       64000L, NBT_PLASMAPROOF, F, NBT_GASPROOF, F, NBT_ACIDPROOF, F, NBT_MAGICPROOF, T, NBT_CAPACITY_HU,        340                             ), "rGs", "PSP", "PSP", 'G', OD.itemGlue, 'P', OP.plate.dat(aMat), 'S', OP.stickLong.dat(ANY.MagicIron));
		aMat = MT.Shimmerwood;      aRegistry.add("Shimmerwood Barrel"                                  , "Fluid Containers"                    , 32016, 32719, MultiTileEntityBarrelWood.class                         ,                 0, 16, aUtilWood      , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   1.0F, NBT_RESISTANCE,   5.0F, NBT_TANK_CAPACITY,       64000L, NBT_PLASMAPROOF, F, NBT_GASPROOF, F, NBT_ACIDPROOF, F, NBT_MAGICPROOF, T, NBT_CAPACITY_HU,        340                             ), "rGs", "PSP", "PSP", 'G', OD.itemGlue, 'P', OP.plate.dat(aMat), 'S', OP.stickLong.dat(ANY.MagicIron));
		aMat = MT.IronWood;         aRegistry.add("Ironwood Barrel"                                     , "Fluid Containers"                    , 32734, 32719, MultiTileEntityBarrelWood.class                         ,                 0, 16, aUtilWood      , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   1.0F, NBT_RESISTANCE,   5.0F, NBT_TANK_CAPACITY,       32000L, NBT_PLASMAPROOF, F, NBT_GASPROOF, F, NBT_ACIDPROOF, F, NBT_MAGICPROOF, T                                                          ), "rGs", "PSP", "PSP", 'G', OD.itemGlue, 'P', OP.plate.dat(aMat), 'S', OP.stickLong.dat(ANY.Iron));
		aMat = MT.Greatwood;        aRegistry.add("Greatwood Barrel"                                    , "Fluid Containers"                    , 32017, 32719, MultiTileEntityBarrelWood.class                         ,                 0, 16, aUtilWood      , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   1.0F, NBT_RESISTANCE,   5.0F, NBT_TANK_CAPACITY,       16000L, NBT_PLASMAPROOF, F, NBT_GASPROOF, F, NBT_ACIDPROOF, F, NBT_MAGICPROOF, T, NBT_CAPACITY_HU,        390, NBT_FLAMMABILITY,       100), "rGs", "PSP", "PSP", 'G', OD.itemGlue, 'P', OP.plate.dat(aMat), 'S', OP.stickLong.dat(ANY.Iron));
		aMat = MT.Silverwood;       aRegistry.add("Silverwood Barrel"                                   , "Fluid Containers"                    , 32018, 32719, MultiTileEntityBarrelWood.class                         ,                 0, 16, aUtilWood      , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   1.0F, NBT_RESISTANCE,   5.0F, NBT_TANK_CAPACITY,       64000L, NBT_PLASMAPROOF, F, NBT_GASPROOF, F, NBT_ACIDPROOF, F, NBT_MAGICPROOF, T, NBT_CAPACITY_HU,        440                             ), "rGs", "PSP", "PSP", 'G', OD.itemGlue, 'P', OP.plate.dat(aMat), 'S', OP.stickLong.dat(ANY.MagicIron));
		aMat = ANY.Plastic;         aRegistry.add("Plastic Canister"                                    , "Fluid Containers"                    , 32715, 32719, MultiTileEntityBarrelPlastic.class                      ,                 0, 16, aUtilWood      , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   1.0F, NBT_RESISTANCE,   3.0F, NBT_TANK_CAPACITY,       32000L, NBT_PLASMAPROOF, F, NBT_GASPROOF, T, NBT_ACIDPROOF, F, NBT_MAGICPROOF, F, NBT_CAPACITY_HU,        370                             )); IL.PlasticCan.set(aRegistry.getItem(), new OreDictItemData(ANY.Plastic, U*3));
		aMat = MT.Bronze;           aRegistry.add("Bronze Drum"                                         , "Fluid Containers"                    , 32102, 32719, MultiTileEntityBarrelMetal.class                        ,                 0, 16, aUtilMetal     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   1.0F, NBT_RESISTANCE,   6.0F, NBT_TANK_CAPACITY,       64000L, NBT_PLASMAPROOF, F, NBT_GASPROOF, T, NBT_ACIDPROOF, F, NBT_MAGICPROOF, F                                                          ), " h ", "PSP", "PSP", 'P', OP.plateCurved.dat(aMat), 'S', OP.stickLong.dat(aMat));
		aMat = MT.Invar;            aRegistry.add("Invar Drum"                                          , "Fluid Containers"                    , 32064, 32719, MultiTileEntityBarrelMetal.class                        ,                 0, 16, aUtilMetal     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   1.0F, NBT_RESISTANCE,   6.0F, NBT_TANK_CAPACITY,       64000L, NBT_PLASMAPROOF, F, NBT_GASPROOF, T, NBT_ACIDPROOF, F, NBT_MAGICPROOF, F                                                          ), " h ", "PSP", "PSP", 'P', OP.plateCurved.dat(aMat), 'S', OP.stickLong.dat(aMat));
		aMat = MT.StainlessSteel;   aRegistry.add("Stainless Steel Drum"                                , "Fluid Containers"                    , 32716, 32719, MultiTileEntityBarrelMetal.class                        ,                 0, 16, aUtilMetal     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   1.0F, NBT_RESISTANCE,   6.0F, NBT_TANK_CAPACITY,       64000L, NBT_PLASMAPROOF, F, NBT_GASPROOF, T, NBT_ACIDPROOF, T, NBT_MAGICPROOF, F                                                          ), " h ", "PSP", "PSP", 'P', OP.plateCurved.dat(aMat), 'S', OP.stickLong.dat(aMat));
		aMat = MT.Desh;             aRegistry.add("Desh Drum"                                           , "Fluid Containers"                    , 32070, 32719, MultiTileEntityBarrelMetal.class                        ,                 0, 16, aUtilMetal     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   1.0F, NBT_RESISTANCE,   6.0F, NBT_TANK_CAPACITY,       64000L, NBT_PLASMAPROOF, F, NBT_GASPROOF, T, NBT_ACIDPROOF, F, NBT_MAGICPROOF, T                                                          ), " h ", "PSP", "PSP", 'P', OP.plateCurved.dat(aMat), 'S', OP.stickLong.dat(aMat));
		aMat = MT.Syrmorite;        aRegistry.add("Syrmorite Drum"                                      , "Fluid Containers"                    , 32020, 32719, MultiTileEntityBarrelMetal.class                        ,                 0, 16, aUtilMetal     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   1.0F, NBT_RESISTANCE,   6.0F, NBT_TANK_CAPACITY,       64000L, NBT_PLASMAPROOF, F, NBT_GASPROOF, T, NBT_ACIDPROOF, T, NBT_MAGICPROOF, T                                                          ), " h ", "PSP", "PSP", 'P', OP.plateCurved.dat(aMat), 'S', OP.stickLong.dat(aMat));
		aMat = MT.Efrine;           aRegistry.add("Efrine Drum"                                         , "Fluid Containers"                    , 32093, 32719, MultiTileEntityBarrelMetal.class                        ,                 0, 16, aUtilMetal     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   1.0F, NBT_RESISTANCE,   6.0F, NBT_TANK_CAPACITY,       64000L, NBT_PLASMAPROOF, T, NBT_GASPROOF, T, NBT_ACIDPROOF, F, NBT_MAGICPROOF, T                                                          ), " h ", "PSP", "PSP", 'P', OP.plateCurved.dat(aMat), 'S', OP.stickLong.dat(aMat));
		aMat = MT.Thaumium;         aRegistry.add("Thaumium Drum"                                       , "Fluid Containers"                    , 32022, 32719, MultiTileEntityBarrelMetal.class                        ,                 0, 16, aUtilMetal     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   1.0F, NBT_RESISTANCE,   6.0F, NBT_TANK_CAPACITY,       64000L, NBT_PLASMAPROOF, F, NBT_GASPROOF, T, NBT_ACIDPROOF, T, NBT_MAGICPROOF, T                                                          ), " h ", "PSP", "PSP", 'P', OP.plateCurved.dat(aMat), 'S', OP.stickLong.dat(aMat));
		aMat = MT.Manasteel;        aRegistry.add("Manasteel Drum"                                      , "Fluid Containers"                    , 32023, 32719, MultiTileEntityBarrelMetal.class                        ,                 0, 16, aUtilMetal     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   1.0F, NBT_RESISTANCE,   6.0F, NBT_TANK_CAPACITY,       64000L, NBT_PLASMAPROOF, F, NBT_GASPROOF, T, NBT_ACIDPROOF, T, NBT_MAGICPROOF, T                                                          ), " h ", "PSP", "PSP", 'P', OP.plateCurved.dat(aMat), 'S', OP.stickLong.dat(aMat));
		aMat = MT.TungstenAlloy;    aRegistry.add("Tungsten Alloy Drum"                                 , "Fluid Containers"                    , 32090, 32719, MultiTileEntityBarrelMetal.class                        ,                 0, 16, aUtilMetal     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   1.0F, NBT_RESISTANCE,   9.0F, NBT_TANK_CAPACITY,      128000L, NBT_PLASMAPROOF, F, NBT_GASPROOF, T, NBT_ACIDPROOF, F, NBT_MAGICPROOF, T                                                          ), " h ", "PSP", "PSP", 'P', OP.plateCurved.dat(aMat), 'S', OP.stickLong.dat(aMat));
		aMat = MT.Ti;               aRegistry.add("Titanium Drum"                                       , "Fluid Containers"                    , 32742, 32719, MultiTileEntityBarrelMetal.class                        ,                 0, 16, aUtilMetal     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   1.0F, NBT_RESISTANCE,   9.0F, NBT_TANK_CAPACITY,      128000L, NBT_PLASMAPROOF, F, NBT_GASPROOF, T, NBT_ACIDPROOF, F, NBT_MAGICPROOF, F                                                          ), " h ", "PSP", "PSP", 'P', OP.plateCurved.dat(aMat), 'S', OP.stickLong.dat(aMat));
		aMat = MT.Netherite;        aRegistry.add("Netherite Drum"                                      , "Fluid Containers"                    , 32087, 32719, MultiTileEntityBarrelMetal.class                        ,                 0, 16, aUtilMetal     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   1.0F, NBT_RESISTANCE,   9.0F, NBT_TANK_CAPACITY,      128000L, NBT_PLASMAPROOF, T, NBT_GASPROOF, T, NBT_ACIDPROOF, T, NBT_MAGICPROOF, T                                                          ), " h ", "PSP", "PSP", 'P', OP.plateCurved.dat(aMat), 'S', OP.stickLong.dat(aMat));
		aMat = MT.TungstenSteel;    aRegistry.add("Tungstensteel Drum"                                  , "Fluid Containers"                    , 32717, 32719, MultiTileEntityBarrelMetal.class                        ,                 0, 16, aUtilMetal     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   1.0F, NBT_RESISTANCE,  12.5F, NBT_TANK_CAPACITY,      256000L, NBT_PLASMAPROOF, F, NBT_GASPROOF, T, NBT_ACIDPROOF, F, NBT_MAGICPROOF, T                                                          ), " h ", "PSP", "PSP", 'P', OP.plateCurved.dat(aMat), 'S', OP.stickLong.dat(aMat));
		aMat = ANY.W;               aRegistry.add("Tungsten Drum"                                       , "Fluid Containers"                    , 32718, 32719, MultiTileEntityBarrelMetal.class                        ,                 0, 16, aUtilMetal     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   1.0F, NBT_RESISTANCE,  10.0F, NBT_TANK_CAPACITY,      256000L, NBT_PLASMAPROOF, F, NBT_GASPROOF, T, NBT_ACIDPROOF, T, NBT_MAGICPROOF, T                                                          ), " h ", "PSP", "PSP", 'P', OP.plateCurved.dat(aMat), 'S', OP.stickLong.dat(aMat));
		aMat = MT.Ta4HfC5;          aRegistry.add("Tantalum Hafnium Carbide Drum"                       , "Fluid Containers"                    , 32083, 32719, MultiTileEntityBarrelMetal.class                        ,                 0, 16, aUtilMetal     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   1.0F, NBT_RESISTANCE,  10.0F, NBT_TANK_CAPACITY,      512000L, NBT_PLASMAPROOF, F, NBT_GASPROOF, T, NBT_ACIDPROOF, F, NBT_MAGICPROOF, T                                                          ), " h ", "PSP", "PSP", 'P', OP.plateCurved.dat(aMat), 'S', OP.stickLong.dat(aMat));
		aMat = MT.VoidMetal;        aRegistry.add("Voidmetal Drum"                                      , "Fluid Containers"                    , 32063, 32719, MultiTileEntityBarrelMetal.class                        ,                 0, 16, aUtilMetal     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   1.0F, NBT_RESISTANCE,  10.0F, NBT_TANK_CAPACITY,      256000L, NBT_PLASMAPROOF, T, NBT_GASPROOF, T, NBT_ACIDPROOF, T, NBT_MAGICPROOF, T                                                          ), " h ", "PSP", "PSP", 'P', OP.plateCurved.dat(aMat), 'S', OP.stickLong.dat(aMat));
		aMat = MT.GaiaSpirit;       aRegistry.add("Gaia Drum"                                           , "Fluid Containers"                    , 32024, 32719, MultiTileEntityBarrelMetal.class                        ,                 0, 16, aUtilMetal     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   1.0F, NBT_RESISTANCE,  25.0F, NBT_TANK_CAPACITY,     1024000L, NBT_PLASMAPROOF, T, NBT_GASPROOF, T, NBT_ACIDPROOF, T, NBT_MAGICPROOF, T                                                          ), " h ", "PSP", "PSP", 'P', OP.plateCurved.dat(aMat), 'S', OP.stickLong.dat(aMat));
		aMat = MT.Ad;               aRegistry.add("Adamantium Drum"                                     , "Fluid Containers"                    , 32719, 32719, MultiTileEntityBarrelMetal.class                        ,                 0, 16, aUtilMetal     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   1.0F, NBT_RESISTANCE, 100.0F, NBT_TANK_CAPACITY,     4096000L, NBT_PLASMAPROOF, T, NBT_GASPROOF, T, NBT_ACIDPROOF, T, NBT_MAGICPROOF, T                                                          ), " h ", "PSP", "PSP", 'P', OP.plateCurved.dat(aMat), 'S', OP.stickLong.dat(aMat));
		aMat = MT.Draconium;        aRegistry.add("Draconium Drum"                                      , "Fluid Containers"                    , 32021, 32719, MultiTileEntityBarrelMetal.class                        ,                 0, 16, aUtilMetal     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   1.0F, NBT_RESISTANCE, 100.0F, NBT_TANK_CAPACITY,     4096000L, NBT_PLASMAPROOF, T, NBT_GASPROOF, T, NBT_ACIDPROOF, T, NBT_MAGICPROOF, T                                                          ), " h ", "PSP", "PSP", 'P', OP.plateCurved.dat(aMat), 'S', OP.stickLong.dat(aMat));
		aMat = MT.DraconiumAwakened;aRegistry.add("Awakened Draconium Drum"                             , "Fluid Containers"                    , 32066, 32719, MultiTileEntityBarrelMetal.class                        ,                 0, 16, aUtilMetal     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   1.0F, NBT_RESISTANCE, 100.0F, NBT_TANK_CAPACITY,     8192000L, NBT_PLASMAPROOF, T, NBT_GASPROOF, T, NBT_ACIDPROOF, T, NBT_MAGICPROOF, T, NBT_CAPACITY_HU,      10000                             ), " h ", "PSP", "PSP", 'P', OP.plateCurved.dat(aMat), 'S', OP.stickLong.dat(aMat));
		aMat = MT.Infinity;         aRegistry.add("Infinity Drum"                                       , "Fluid Containers"                    , 32067, 32719, MultiTileEntityBarrelMetal.class                        ,                 0, 16, aUtilMetal     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   1.0F, NBT_RESISTANCE, 100.0F, NBT_TANK_CAPACITY, 10000000000L, NBT_PLASMAPROOF, T, NBT_GASPROOF, T, NBT_ACIDPROOF, T, NBT_MAGICPROOF, T, NBT_CAPACITY_HU, 1000000000                             ), " h ", "PSP", "PSP", 'P', OP.plateCurved.dat(aMat), 'S', OP.stickLong.dat(aMat));
		aMat = ANY.W;               aRegistry.add("Logistics Tank"                                      , "Logistics"                           , 32072, 17997, MultiTileEntityBarrelLogistics.class                    ,                 0, 16, aUtilMetal     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   1.0F, NBT_RESISTANCE,  10.0F, NBT_TANK_CAPACITY,     1000000L, NBT_PLASMAPROOF, T, NBT_GASPROOF, T, NBT_ACIDPROOF, T, NBT_MAGICPROOF, T, NBT_CAPACITY_HU,     100000                             ), "TQT", "wFd", "TMT", 'M', aRegistry.getItem(32718), 'T', OP.screw.dat(aMat), 'Q', IL.Cover_Logistics_Generic_Storage, 'F', IL.FIELD_GENERATORS[0]);
		
		aMat = ANY.Wood;            aRegistry.add("Wooden Bathing Pot"                                  , "Misc Tool Blocks"                    , 32721, 32720, MultiTileEntityBathingPotWood.class                     ,                 0, 16, aUtilWood      , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   1.0F, NBT_RESISTANCE,   5.0F, NBT_RECIPEMAP, RM.Bath   , NBT_TANK_CAPACITY,           4000, NBT_FLAMMABILITY, 100), "sGh", "PLP", "PPP", 'P', OD.plankAnyWood, 'L', OP.stickLong.dat(MT.Pb), 'G', OD.itemGlue);
		aMat = ANY.Wood;            aRegistry.add("Wooden Bathing Pot Table"                            , "Misc Tool Blocks"                    , 32720, 32720, MultiTileEntityBathingPotTableWood.class                ,                 0, 16, aUtilWood      , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   1.0F, NBT_RESISTANCE,   5.0F, NBT_RECIPEMAP, RM.Bath   , NBT_TANK_CAPACITY,           4000, NBT_FLAMMABILITY, 100), "M", "S", 'M', aRegistry.getItem(), 'S', ST.make(Blocks.stone_slab, 1, 4));
		aMat = MT.StainlessSteel;   aRegistry.add("Bathing Pot"                                         , "Misc Tool Blocks"                    , 32708, 32720, MultiTileEntityBathingPot.class                         ,                 0, 16, aUtilMetal     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   1.0F, NBT_RESISTANCE,   6.0F, NBT_RECIPEMAP, RM.Bath   , NBT_TANK_CAPACITY,           8000), " f ", "PhP", "PPP", 'P', OP.plate.dat(aMat));
		aMat = MT.StainlessSteel;   aRegistry.add("Bathing Pot Table"                                   , "Misc Tool Blocks"                    , 32707, 32720, MultiTileEntityBathingPotTable.class                    ,                 0, 16, aUtilMetal     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   1.0F, NBT_RESISTANCE,   6.0F, NBT_RECIPEMAP, RM.Bath   , NBT_TANK_CAPACITY,           8000), "M", "S", 'M', aRegistry.getItem(), 'S', ST.make(Blocks.stone_slab, 1, 4));
		aMat = MT.Ceramic;          aRegistry.add("Ceramic Bowl"                                        , "Misc Tool Blocks"                    , 32706, 32720, MultiTileEntityMixingBowl.class                         ,                 0, 16, aUtilStone     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   1.0F, NBT_RESISTANCE,   5.0F, NBT_RECIPEMAP, RM.Mixer  , NBT_TANK_CAPACITY,           8000)); IL.Ceramic_Bowl.set(aRegistry.getItem(), new OreDictItemData(MT.Ceramic, U*5)); RM.add_smelting(IL.Ceramic_Bowl_Raw.get(1), IL.Ceramic_Bowl.get(1), F, F, T);
		aMat = MT.Ceramic;          aRegistry.add("Ceramic Bowl Table"                                  , "Misc Tool Blocks"                    , 32705, 32720, MultiTileEntityMixingBowlTable.class                    ,                 0, 16, aUtilStone     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   1.0F, NBT_RESISTANCE,   5.0F, NBT_RECIPEMAP, RM.Mixer  , NBT_TANK_CAPACITY,           8000), "M", "S", 'M', aRegistry.getItem(), 'S', ST.make(Blocks.stone_slab, 1, 4));
		aMat = MT.Ceramic;          aRegistry.add("Mortar"                                              , "Misc Tool Blocks"                    , 32735, 32720, MultiTileEntityMortar.class                             ,                 0, 16, aUtilStone     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   1.0F, NBT_RESISTANCE,   5.0F, NBT_RECIPEMAP, RM.Mortar , NBT_DESIGN, 0                    ), "P", "B", 'B', IL.Ceramic_Bowl, 'P', OP.ingot.dat(ANY.Iron));
		aMat = MT.Ceramic;          aRegistry.add("Mortar"                                              , "Misc Tool Blocks"                    , 32094, 32720, MultiTileEntityMortar.class                             ,                 0, 16, aUtilStone     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   1.0F, NBT_RESISTANCE,   5.0F, NBT_RECIPEMAP, RM.Mortar , NBT_DESIGN, 1                    ), "P", "B", 'B', IL.Ceramic_Bowl, 'P', OP.ingot.dat(MT.Netherite));
		aMat = MT.Ceramic;          aRegistry.add("Mortar"                                              , "Misc Tool Blocks"                    , 32075, 32720, MultiTileEntityMortar.class                             ,                 0, 16, aUtilStone     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   1.0F, NBT_RESISTANCE,   5.0F, NBT_RECIPEMAP, RM.Mortar , NBT_DESIGN, 2                    ), "P", "B", 'B', IL.Ceramic_Bowl, 'P', OP.gem.dat(ANY.Sapphire));
		aMat = MT.Ceramic;          aRegistry.add("Mortar"                                              , "Misc Tool Blocks"                    , 32076, 32720, MultiTileEntityMortar.class                             ,                 0, 16, aUtilStone     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   1.0F, NBT_RESISTANCE,   5.0F, NBT_RECIPEMAP, RM.Mortar , NBT_DESIGN, 3                    ), "P", "B", 'B', IL.Ceramic_Bowl, 'P', OP.gem.dat(ANY.Diamond));
		aMat = MT.Ceramic;          aRegistry.add("Mortar"                                              , "Misc Tool Blocks"                    , 32089, 32720, MultiTileEntityMortar.class                             ,                 0, 16, aUtilStone     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   1.0F, NBT_RESISTANCE,   5.0F, NBT_RECIPEMAP, RM.Mortar , NBT_DESIGN, 4                    ), "P", "B", 'B', IL.Ceramic_Bowl, 'P', OP.gem.dat(ANY.Amethyst));
		aMat = MT.Ceramic;          aRegistry.add("Juicer"                                              , "Misc Tool Blocks"                    , 32722, 32720, MultiTileEntityJuicer.class                             ,                 0, 16, aUtilStone     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   1.0F, NBT_RESISTANCE,   5.0F, NBT_RECIPEMAP, RM.Juicer                                    )); IL.Juicer.set(aRegistry.getItem(), new OreDictItemData(MT.Ceramic, U*4)); RM.add_smelting(IL.Juicer_Raw.get(1), IL.Juicer.get(1), F, F, T);
		aMat = MT.Stone;            aRegistry.add(aMat.mNameLocal + " Anvil"                            , "Misc Tool Blocks"                    , 32025, 32720, MultiTileEntityAnvil.class                              ,                 0, 16, aUtilStone     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   1.0F, NBT_RESISTANCE,   6.0F                           , NBT_DURABILITY,            10000L), "RRR", "hR ", "RRR", 'R', Blocks.stone);
		aMat = MT.STONES.Blackstone;aRegistry.add(aMat.mNameLocal + " Anvil"                            , "Misc Tool Blocks"                    , 32095, 32720, MultiTileEntityAnvil.class                              ,                 0, 16, aUtilStone     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   1.0F, NBT_RESISTANCE,   6.0F                           , NBT_DURABILITY,           100000L), "RRR", "hR ", "RRR", 'R', OP.stone.dat(aMat));
		aMat = MT.STONES.GraniteBlack;aRegistry.add(aMat.mNameLocal+" Anvil"                            , "Misc Tool Blocks"                    , 32026, 32720, MultiTileEntityAnvil.class                              ,                 0, 16, aUtilStone     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   1.0F, NBT_RESISTANCE,   6.0F                           , NBT_DURABILITY,           100000L), "RRR", "hR ", "RRR", 'R', OP.stone.dat(aMat));
		aMat = MT.STONES.GraniteRed;aRegistry.add(aMat.mNameLocal + " Anvil"                            , "Misc Tool Blocks"                    , 32027, 32720, MultiTileEntityAnvil.class                              ,                 0, 16, aUtilStone     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   1.0F, NBT_RESISTANCE,   6.0F                           , NBT_DURABILITY,           100000L), "RRR", "hR ", "RRR", 'R', OP.stone.dat(aMat));
		aMat = MT.Pb;               aRegistry.add(aMat.mNameLocal + " Anvil"                            , "Misc Tool Blocks"                    , 32050, 32720, MultiTileEntityAnvil.class                              ,                 0, 16, aUtilMetal     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   1.0F, NBT_RESISTANCE,   6.0F                           , NBT_DURABILITY,           800000L), "III", "hI ", "III", 'I', OP.ingot.dat(aMat));
		aMat = MT.Bronze;           aRegistry.add(aMat.mNameLocal + " Anvil"                            , "Misc Tool Blocks"                    , 32028, 32720, MultiTileEntityAnvil.class                              ,                 0, 16, aUtilMetal     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   1.0F, NBT_RESISTANCE,   6.0F                           , NBT_DURABILITY,          1000000L), "III", "hI ", "III", 'I', OP.ingot.dat(aMat));
		aMat = MT.ArsenicCopper;    aRegistry.add(aMat.mNameLocal + " Anvil"                            , "Misc Tool Blocks"                    , 32106, 32720, MultiTileEntityAnvil.class                              ,                 0, 16, aUtilMetal     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   1.0F, NBT_RESISTANCE,   6.0F                           , NBT_DURABILITY,          1000000L), "III", "hI ", "III", 'I', OP.ingot.dat(aMat));
		aMat = MT.ArsenicBronze;    aRegistry.add(aMat.mNameLocal + " Anvil"                            , "Misc Tool Blocks"                    , 32107, 32720, MultiTileEntityAnvil.class                              ,                 0, 16, aUtilMetal     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   1.0F, NBT_RESISTANCE,   6.0F                           , NBT_DURABILITY,          2000000L), "III", "hI ", "III", 'I', OP.ingot.dat(aMat));
		aMat = MT.Syrmorite;        aRegistry.add(aMat.mNameLocal + " Anvil"                            , "Misc Tool Blocks"                    , 32029, 32720, MultiTileEntityAnvil.class                              ,                 0, 16, aUtilMetal     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   1.0F, NBT_RESISTANCE,   6.0F                           , NBT_DURABILITY,          2000000L), "III", "hI ", "III", 'I', OP.ingot.dat(aMat));
		aMat = MT.IronWood;         aRegistry.add(aMat.mNameLocal + " Anvil"                            , "Misc Tool Blocks"                    , 32030, 32720, MultiTileEntityAnvil.class                              ,                 0, 16, aUtilWood      , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   1.0F, NBT_RESISTANCE,   6.0F                           , NBT_DURABILITY,          7500000L), "III", "hI ", "III", 'I', OP.ingot.dat(aMat));
		aMat = ANY.Steel;           aRegistry.add(aMat.mNameLocal + " Anvil"                            , "Misc Tool Blocks"                    , 32031, 32720, MultiTileEntityAnvil.class                              ,                 0, 16, aUtilMetal     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   1.0F, NBT_RESISTANCE,   6.0F                           , NBT_DURABILITY,         10000000L), "III", "hI ", "III", 'I', OP.ingot.dat(aMat));
		aMat = MT.Desh;             aRegistry.add(aMat.mNameLocal + " Anvil"                            , "Misc Tool Blocks"                    , 32071, 32720, MultiTileEntityAnvil.class                              ,                 0, 16, aUtilMetal     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   1.0F, NBT_RESISTANCE,   6.0F                           , NBT_DURABILITY,         12500000L), "III", "hI ", "III", 'I', OP.ingot.dat(aMat));
		aMat = MT.Efrine;           aRegistry.add(aMat.mNameLocal + " Anvil"                            , "Misc Tool Blocks"                    , 32092, 32720, MultiTileEntityAnvil.class                              ,                 0, 16, aUtilMetal     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   1.0F, NBT_RESISTANCE,   6.0F                           , NBT_DURABILITY,         20000000L), "III", "hI ", "III", 'I', OP.ingot.dat(aMat));
		aMat = MT.Thaumium;         aRegistry.add(aMat.mNameLocal + " Anvil"                            , "Misc Tool Blocks"                    , 32032, 32720, MultiTileEntityAnvil.class                              ,                 0, 16, aUtilMetal     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   1.0F, NBT_RESISTANCE,   6.0F                           , NBT_DURABILITY,         25000000L), "III", "hI ", "III", 'I', OP.ingot.dat(aMat));
		aMat = MT.Manasteel;        aRegistry.add(aMat.mNameLocal + " Anvil"                            , "Misc Tool Blocks"                    , 32033, 32720, MultiTileEntityAnvil.class                              ,                 0, 16, aUtilMetal     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   1.0F, NBT_RESISTANCE,   6.0F                           , NBT_DURABILITY,         25000000L), "III", "hI ", "III", 'I', OP.ingot.dat(aMat));
		aMat = ANY.BlackSteel;      aRegistry.add(aMat.mNameLocal + " Anvil"                            , "Misc Tool Blocks"                    , 32034, 32720, MultiTileEntityAnvil.class                              ,                 0, 16, aUtilMetal     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   1.0F, NBT_RESISTANCE,   6.0F                           , NBT_DURABILITY,         30000000L), "III", "hI ", "III", 'I', OP.ingot.dat(aMat));
		aMat = ANY.BlueSteel;       aRegistry.add(aMat.mNameLocal + " Anvil"                            , "Misc Tool Blocks"                    , 32035, 32720, MultiTileEntityAnvil.class                              ,                 0, 16, aUtilMetal     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   1.0F, NBT_RESISTANCE,   6.0F                           , NBT_DURABILITY,         40000000L), "III", "hI ", "III", 'I', OP.ingot.dat(aMat));
		aMat = ANY.RedSteel;        aRegistry.add(aMat.mNameLocal + " Anvil"                            , "Misc Tool Blocks"                    , 32036, 32720, MultiTileEntityAnvil.class                              ,                 0, 16, aUtilMetal     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   1.0F, NBT_RESISTANCE,   6.0F                           , NBT_DURABILITY,         50000000L), "III", "hI ", "III", 'I', OP.ingot.dat(aMat));
		aMat = MT.VanadiumSteel;    aRegistry.add(aMat.mNameLocal + " Anvil"                            , "Misc Tool Blocks"                    , 32037, 32720, MultiTileEntityAnvil.class                              ,                 0, 16, aUtilMetal     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   1.0F, NBT_RESISTANCE,   6.0F                           , NBT_DURABILITY,         70000000L), "III", "hI ", "III", 'I', OP.ingot.dat(aMat));
		aMat = MT.Octine;           aRegistry.add(aMat.mNameLocal + " Anvil"                            , "Misc Tool Blocks"                    , 32038, 32720, MultiTileEntityAnvil.class                              ,                 0, 16, aUtilMetal     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   1.0F, NBT_RESISTANCE,   6.0F                           , NBT_DURABILITY,         80000000L), "III", "hI ", "III", 'I', OP.ingot.dat(aMat));
		aMat = MT.FierySteel;       aRegistry.add(aMat.mNameLocal + " Anvil"                            , "Misc Tool Blocks"                    , 32039, 32720, MultiTileEntityAnvil.class                              ,                 0, 16, aUtilMetal     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   1.0F, NBT_RESISTANCE,   6.0F                           , NBT_DURABILITY,         90000000L), "III", "hI ", "III", 'I', OP.ingot.dat(aMat));
		aMat = MT.TungstenAlloy;    aRegistry.add(aMat.mNameLocal + " Anvil"                            , "Misc Tool Blocks"                    , 32091, 32720, MultiTileEntityAnvil.class                              ,                 0, 16, aUtilMetal     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   1.0F, NBT_RESISTANCE,   6.0F                           , NBT_DURABILITY,        100000000L), "III", "hI ", "III", 'I', OP.ingot.dat(aMat));
		aMat = MT.Ti;               aRegistry.add(aMat.mNameLocal + " Anvil"                            , "Misc Tool Blocks"                    , 32040, 32720, MultiTileEntityAnvil.class                              ,                 0, 16, aUtilMetal     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   1.0F, NBT_RESISTANCE,   6.0F                           , NBT_DURABILITY,        100000000L), "III", "hI ", "III", 'I', OP.ingot.dat(aMat));
		aMat = MT.Netherite;        aRegistry.add(aMat.mNameLocal + " Anvil"                            , "Misc Tool Blocks"                    , 32088, 32720, MultiTileEntityAnvil.class                              ,                 0, 16, aUtilMetal     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   1.0F, NBT_RESISTANCE,   6.0F                           , NBT_DURABILITY,        150000000L), "III", "hI ", "III", 'I', OP.ingot.dat(aMat));
		aMat = MT.Terrasteel;       aRegistry.add(aMat.mNameLocal + " Anvil"                            , "Misc Tool Blocks"                    , 32041, 32720, MultiTileEntityAnvil.class                              ,                 0, 16, aUtilMetal     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   1.0F, NBT_RESISTANCE,   6.0F                           , NBT_DURABILITY,        200000000L), "III", "hI ", "III", 'I', OP.ingot.dat(aMat));
		aMat = MT.VoidMetal;        aRegistry.add(aMat.mNameLocal + " Anvil"                            , "Misc Tool Blocks"                    , 32042, 32720, MultiTileEntityAnvil.class                              ,                 0, 16, aUtilMetal     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   1.0F, NBT_RESISTANCE,   6.0F                           , NBT_DURABILITY,        300000000L), "III", "hI ", "III", 'I', OP.ingot.dat(aMat));
		aMat = MT.TitaniumGold;     aRegistry.add(aMat.mNameLocal + " Anvil"                            , "Misc Tool Blocks"                    , 32043, 32720, MultiTileEntityAnvil.class                              ,                 0, 16, aUtilMetal     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   1.0F, NBT_RESISTANCE,   6.0F                           , NBT_DURABILITY,        400000000L), "III", "hI ", "III", 'I', OP.ingot.dat(aMat));
		aMat = MT.TungstenSteel;    aRegistry.add(aMat.mNameLocal + " Anvil"                            , "Misc Tool Blocks"                    , 32044, 32720, MultiTileEntityAnvil.class                              ,                 0, 16, aUtilMetal     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   1.0F, NBT_RESISTANCE,   6.0F                           , NBT_DURABILITY,       1000000000L), "III", "hI ", "III", 'I', OP.ingot.dat(aMat));
		aMat = ANY.W;               aRegistry.add(aMat.mNameLocal + " Anvil"                            , "Misc Tool Blocks"                    , 32045, 32720, MultiTileEntityAnvil.class                              ,                 0, 16, aUtilMetal     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   1.0F, NBT_RESISTANCE,   6.0F                           , NBT_DURABILITY,       2000000000L), "III", "hI ", "III", 'I', OP.ingot.dat(aMat));
		aMat = MT.Ir;               aRegistry.add(aMat.mNameLocal + " Anvil"                            , "Misc Tool Blocks"                    , 32046, 32720, MultiTileEntityAnvil.class                              ,                 0, 16, aUtilMetal     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   1.0F, NBT_RESISTANCE,   6.0F                           , NBT_DURABILITY,      10000000000L), "III", "hI ", "III", 'I', OP.ingot.dat(aMat));
		aMat = MT.GaiaSpirit;       aRegistry.add(aMat.mNameLocal + " Anvil"                            , "Misc Tool Blocks"                    , 32047, 32720, MultiTileEntityAnvil.class                              ,                 0, 16, aUtilMetal     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   1.0F, NBT_RESISTANCE,   6.0F                           , NBT_DURABILITY,     100000000000L), "III", "hI ", "III", 'I', OP.ingot.dat(aMat));
		aMat = MT.Ad;               aRegistry.add(aMat.mNameLocal + " Anvil"                            , "Misc Tool Blocks"                    , 32048, 32720, MultiTileEntityAnvil.class                              ,                 0, 16, aUtilMetal     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   1.0F, NBT_RESISTANCE,   6.0F                           , NBT_DURABILITY,    1000000000000L), "III", "hI ", "III", 'I', OP.ingot.dat(aMat));
		aMat = MT.Draconium;        aRegistry.add(aMat.mNameLocal + " Anvil"                            , "Misc Tool Blocks"                    , 32049, 32720, MultiTileEntityAnvil.class                              ,                 0, 16, aUtilMetal     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   1.0F, NBT_RESISTANCE,   6.0F                           , NBT_DURABILITY,    1000000000000L), "III", "hI ", "III", 'I', OP.ingot.dat(aMat));
		aMat = MT.DraconiumAwakened;aRegistry.add(aMat.mNameLocal + " Anvil"                            , "Misc Tool Blocks"                    , 32068, 32720, MultiTileEntityAnvil.class                              ,                 0, 16, aUtilMetal     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   1.0F, NBT_RESISTANCE,   6.0F                           , NBT_DURABILITY,    2000000000000L), "III", "hI ", "III", 'I', OP.ingot.dat(aMat));
		aMat = MT.Infinity;         aRegistry.add(aMat.mNameLocal + " Anvil"                            , "Misc Tool Blocks"                    , 32069, 32720, MultiTileEntityAnvil.class                              ,                 0, 16, aUtilMetal     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   1.0F, NBT_RESISTANCE,   6.0F                           , NBT_DURABILITY, 1000000000000000L), "III", "hI ", "III", 'I', OP.ingot.dat(aMat));
		
		aMat = MT.Leather;          aRegistry.add("Resin/Sap Bag"                                       , "Misc Tool Blocks"                    , 32736, 32720, MultiTileEntitySapBag.class                             ,                 0, 64, aUtilWool      , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   0.5F, NBT_RESISTANCE,   3.0F, NBT_TANK_CAPACITY, 8000), "SSS", "LsL", "LLL", 'L', OD.craftingLeather, 'S', OD.stickAnyWood); IL.Bag_Sap_Resin.set(aRegistry.getItem());
		aMat = ANY.Wood;            aRegistry.add("Bumbliary"                                           , "Misc Tool Blocks"                    , 32741, 32720, MultiTileEntityBumbliary.class                          ,                 0, 16, aWooden        , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   5.0F, NBT_RESISTANCE,   5.0F, NBT_RECIPEMAP, RM.BumbleQueens), "PPP", "PBP", "TdT", 'B', aRegistry.getItem(32755), 'P', OP.plate.dat(MT.WoodTreated), 'T', OP.screw.dat(ANY.Iron));
		aMat = MT.StainlessSteel;   aRegistry.add("Advanced Bumbliary"                                  , "Misc Tool Blocks"                    , 32007, 32720, MultiTileEntityBumbliaryAdvanced.class                  ,                 0, 16, aWooden        , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   6.0F, NBT_RESISTANCE,   6.0F, NBT_RECIPEMAP, RM.BumbleQueens), "PRP", "HBH", "PCP", 'B', aRegistry.getItem(32741), 'P', OP.plate.dat(aMat), 'C', OD.craftingChest, 'R', OD.beeCombCrossbred, 'H', OD.container1000honey);
		
		aMat = ANY.Steel;           aRegistry.add("Dust Funnel"                                         , "Misc Tool Blocks"                    , 32704, 32720, MultiTileEntityDustFunnel.class                         ,                 0, 16, aUtilMetal     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   1.0F, NBT_RESISTANCE,   6.0F                                ), "hws", "PHP", "SPS", 'P', OP.plate.dat(ANY.Iron), 'S', OP.stick.dat(ANY.Iron), 'H', Blocks.hopper);
		aMat = ANY.Steel;           aRegistry.add("Grindstone"                                          , "Misc Tool Blocks"                    , 32703, 32720, MultiTileEntityGrindStone.class                         ,                 0, 16, aUtilMetal     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   1.0F, NBT_RESISTANCE,   6.0F, NBT_RECIPEMAP, RM.Sharpening  ), "SAS", "SwS", "PPP", 'P', OP.plateDouble.dat(ANY.Iron), 'S', OP.stickLong.dat(ANY.Iron), 'A', OP.stick.dat(ANY.Iron));
		aMat = ANY.Steel;           aRegistry.add("Sifting Table"                                       , "Misc Tool Blocks"                    , 32702, 32720, MultiTileEntitySiftingTable.class                       ,                 0, 16, aUtilMetal     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   1.0F, NBT_RESISTANCE,   6.0F, NBT_RECIPEMAP, RM.Sifting     ), "TdT", "WxW", "SPS", 'P', OP.plateDouble.dat(ANY.Iron), 'S', OP.stickLong.dat(ANY.Iron), 'T', OP.screw.dat(ANY.Iron), 'W', OP.wireFine.dat(ANY.Iron));
		
		aMat = MT.Ceramic;          aRegistry.add("Universal Plant Pot"                                 , "Misc Tool Blocks"                    , 32065, 32720, MultiTileEntityPlantPot.class                           ,                 0, 16, aUtilStone     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   1.0F, NBT_RESISTANCE,   5.0F), "SEN", "GUC", "MBD", 'U', IL.Ceramic_Basin, 'G', OP.dust.dat(ANY.Stone), 'C', OP.dust.dat(ANY.Clay), 'B', OP.dust.dat(MT.Bone), 'E', OP.dust.dat(MT.Endstone), 'N', OP.dust.dat(MT.SoulSand), 'S', OP.dust.dat(MT.Sand), 'D', OD.itemMud, 'M', OD.listAllmushroom);
		
		aMat = ANY.Steel;           aRegistry.add("Ender Garbage Dump"                                  , "Misc Tool Blocks"                    , 32710, 32720, MultiTileEntityEnderGarbageDump.class                   , aMat.mToolQuality, 16, aMachine       , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   6.0F, NBT_RESISTANCE,   6.0F)); ItemsGT.DEBUG_ITEMS.add(aRegistry.getItem()); ItemsGT.ILLEGAL_DROPS.add(aRegistry.getItem()); GarbageGT.BLACKLIST.add(aRegistry.getItem());
		aMat = ANY.Steel;           aRegistry.add("Ender Garbage Bin"                                   , "Misc Tool Blocks"                    , 32709, 32720, MultiTileEntityEnderGarbageBin.class                    ,                 0, 16, aUtilStone     , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   0.5F, NBT_RESISTANCE,   6.0F), "OOO", "OXO", "PPP", 'O', OP.plate.dat(MT.Obsidian), 'P', OP.plate.dat(ANY.Iron), 'X', OP.gem.dat(MT.EnderEye));
		
		aMat = MT.TinAlloy;  OM.reg(aRegistry.add("Advanced Button"                                     , "Misc Tool Blocks"                    , 32711, 32720, MultiTileEntityButtonAdvanced.class                     , aMat.mToolQuality, 64, aMachine       , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   6.0F, NBT_RESISTANCE,   6.0F), "dPT", "WLW", "TSw", 'W', OP.wireFine.dat(MT.RedAlloy), 'L', OP.wireFine.dat(MT.Lumium), 'P', OP.plateTiny.dat(aMat), 'T', OP.screw.dat(aMat), 'S', OP.springSmall.dat(aMat)), OD.button); CR.shapeless(aRegistry.getItem(), CR.DEF_NCC, new Object[] {aRegistry.getItem()});
		
		aMat = MT.Orange;           aRegistry.add("Boomstick"                                           , "Misc Tool Blocks"                    , 32104, 32720, MultiTileEntityDynamite.class                           ,                 0, 64, aTNT           , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   0.0F, NBT_RESISTANCE,   0.0F, NBT_QUALITY, 10, NBT_FORTUNE, 3, NBT_FLAMMABILITY, 300), " S ", "PGP", "DGD", 'G', OP.dust.dat(MT.Gunpowder), 'D', OP.dust.dat(ANY.SiO2), 'S', OD.itemString, 'P', OD.paperEmpty); IL.Boomstick.set(aRegistry.getItem());
		aMat = MT.Red;              aRegistry.add("Dynamite"                                            , "Misc Tool Blocks"                    , 32713, 32720, MultiTileEntityDynamite.class                           ,                 0, 64, aTNT           , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   0.0F, NBT_RESISTANCE,   0.0F, NBT_QUALITY, 10, NBT_FORTUNE, 5, NBT_FLAMMABILITY, 300)); IL.Dynamite       .set(aRegistry.getItem(), new OreDictItemData(MT.Dynamite, U));
		aMat = MT.Purple;           aRegistry.add("Strong Dynamite"                                     , "Misc Tool Blocks"                    , 32712, 32720, MultiTileEntityDynamite.class                           ,                 0, 64, aTNT           , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   0.0F, NBT_RESISTANCE,   0.0F, NBT_QUALITY, 40, NBT_FORTUNE, 5, NBT_FLAMMABILITY, 300)); IL.Dynamite_Strong.set(aRegistry.getItem(), new OreDictItemData(MT.Dynamite, U*2));
		
		aMat = ANY.Steel;           aRegistry.add("Coinage Mold"                                        , "Misc Tool Blocks"                    , 32701, 32720, MultiTileEntityMoldCoinage.class                        , aMat.mToolQuality, 16, aMetal         , UT.NBT.make(NBT_MATERIAL, aMat, NBT_HARDNESS,   6.0F, NBT_RESISTANCE,   6.0F), "yhf", "PPP", "III", 'P', OP.plateDouble.dat(ANY.Iron), 'I', OP.ingot.dat(ANY.Iron));
									aRegistry.add("Coin"                                                , "Coins"                               , 32700, 32700, MultiTileEntityCoin.class                               ,                 0, 64, aMetalChips    , null);
	}
}
