/**
 * Copyright (c) 2024 GregTech-6 Team
 *
 * This file is part of GregTech.
 *
 * GregTech is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GregTech is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with GregTech. If not, see <http://www.gnu.org/licenses/>.
 */

package gregtech.loaders.a;

import gregapi.data.*;
import gregapi.item.multiitem.food.FoodStatDrink;
import gregapi.old.Textures;
import gregapi.oredict.OreDictMaterial;
import gregapi.render.IIconContainer;
import gregapi.render.TextureSet;
import gregapi.util.ST;
import gregapi.util.UT;
import net.minecraft.init.Items;
import net.minecraft.item.EnumAction;
import net.minecraft.potion.Potion;
import net.minecraftforge.fluids.FluidStack;

import static gregapi.data.CS.*;

public class Loader_Fluids implements Runnable {
	@Override
	public void run() {
		FL.create("HeliumPlasma"             , "Helium Plasma"       , MT.He                 , 3,   1000, 10000).setLuminosity(15);
		FL.create("NitrogenPlasma"           , "Nitrogen Plasma"     , MT.N                  , 3,   1000, 10000).setLuminosity(15);
		
		//-----
		
		FL.create("Propane"                  , null                  , MT.Propane            , 2).setDensity(-1000);
		FL.create("Butane"                   , null                  , MT.Butane             , 2).setDensity(-1000);
		FL.create("Propylene"                , null                  , MT.Propylene          , 2);
		FL.create("Ethylene"                 , null                  , MT.Ethylene           , 2);
		FL.create("dragonbreath"             , "Dragon's Breath"     , null                  , 2,   1000,   300, IL.EtFu_Dragon_Breath.get(1), IL.Bottle_Empty.get(1), 250).setDensity(100).setLuminosity(5);
		FL.create("netherair"                , "Nether Air"          , null                  , 2,   1000,   370).setDensity(0);
		FL.create("enderair"                 , "Ender Air"           , null                  , 2,   1000,   280).setDensity(0);
		FL.create("Steam"                    , "Steam"               , MT.H2O                , 2, 160000, C+100).setDensity(-1000);
		MT.Ice.mGas = MT.H2O.mGas;
		MT.H2O.mGas.getFluid().setTemperature((int)(C+100)).setGaseous(T);
		MT.Steam.gas(FL.Steam.make(160000));
		
		//-----
		
		FL.create("liquid_extra_heavy_oil"   , "Very Heavy Oil"      , null                  , 1).setDensity(  900);
		FL.create("liquid_heavy_oil"         , "Heavy Oil"           , null                  , 1).setDensity(  800);
		FL.create("liquid_medium_oil"        , "Raw Oil"             , null                  , 1).setDensity(  700);
		FL.create("liquid_light_oil"         , "Light Oil"           , null                  , 1).setDensity(  600);
		FL.create("soulsandoil"              , "Soulsand Oil"        , null                  , 1).setDensity(  650);
		FL.create("gas_natural_gas"          , "Natural Gas"         , null                  , 2).setDensity(- 500); // ~95% methane, ~5% ethane and trace amounts of propane and butane
		
		MT.O.gas(FL.Reikygen.make(1000));
		MT.O.liquid(FL.Liquid_Reikygen.make(1000));
		FL.create("liquidoxygen"             , "Liquid Oxygen"       , MT.O                  , 1,   1000,    85);
		
		FL.create("chargedmatter"            , "Charged Matter"      , null                  , 1,      1,     1).setDensity(-5000).setLuminosity(15);
		FL.create("neutralmatter"            , "Neutral Matter"      , null                  , 1,      1,     1).setDensity(-5000).setLuminosity(15);
		FL.create("UUAmplifier"              , null                  , MT.UUAmplifier        , 1,      1,   100);
		FL.create("ic2uumatter"              , null                  , MT.UUMatter           , 1,      1,   100);
		FL.create("ic2constructionfoam"      , null                  , MT.ConstructionFoam   , 1,    100,   300);
		FL.create("ic2distilledwater"        , "Distilled Water"     , MT.DistWater          , 1);
		FL.create("NitroFuel"                , "Nitro Fuel"          , MT.NitroFuel          , 1);
		FL.create("oil"                      , "Oil"                 , MT.Oil                , 1);
		FL.create("fuel"                     , "Fuel Oil"            , MT.Fuel               , 1);
		FL.create("kerosene"                 , "Kerosene"            , MT.Kerosine           , 1);
		FL.create("kerosine"                 , "Kerosine"            , MT.Kerosine           , 1);
		FL.create("diesel"                   , "Diesel"              , MT.Diesel             , 1);
		FL.create("petrol"                   , "Petrol"              , MT.Petrol             , 1);
		FL.create("biomass"                  , "Biomass"             , MT.Biomass            , 1);
		FL.create("ic2biomass"               , "Biomass"             , MT.Biomass            , 1);
		FL.create("ic2coolant"               , "Industrial Coolant"  , null                  , 1);
		FL.create("ic2hotcoolant"            , "Industrial Heatant"  , null                  , 1,   1000,  1200);
		FL.create("hotmoltensodium"          , "Hot Molten Sodium"   , null                  , 1,   1000,  1100);
		FL.create("hotmoltentin"             , "Hot Molten Tin"      , null                  , 1,   1000,  2800);
		FL.create("hotmoltenlicl"            , "Hot Molten Lithium Chloride", null           , 1,   1000,  1600);
		
		FL.create("hotheavywater"            , "Hot Heavy Water"     , null                  , 1,   1000,   600);
		FL.create("hotsemiheavywater"        , "Hot Semiheavy Water" , null                  , 1,   1000,   550);
		FL.create("hottritiatedwater"        , "Hot Tritiated Water" , null                  , 1,   1000,   650);
		
		FL.create("hotcarbondioxide"         , "Hot Carbon Dioxide"  , null                  , 1,   1000,   950);
		FL.create("hothelium"                , "Hot Helium"          , null                  , 1,   1000,  1150);
		FL.create("thoriumsalt"              , "Molten Thorium Salt" , null                  , 1,   1000,   600);
		
		FL.create("ic2pahoehoelava"          , "Pahoehoe Lava"       , null                  , 1,   1000,  1200).setLuminosity(10).setDensity(50000).setViscosity(250000);
		
		MT.Ethanol.liquid(FL.Reikanol.make(1000));
		FL.create("ethanol"                  , "Ethanol"             , MT.Ethanol            , 1);
		FL.create("bioethanol"               , "Ethanol"             , MT.Ethanol            , 1);
		
		FL.create("mcguffium"                , "Mc Guffium 239"      , MT.Mcg                , 1,      L,   300);
		FL.create("hotfryingoil"             , "Hot Frying Oil"      , MT.FryingOilHot       , 1,   1000,   400);
		
		FL.create("fieryblood"               , "Fiery Blood"         , null                  , 1,      L,  1500).setLuminosity(10);
		FL.create("fierytears"               , "Fiery Tears"         , null                  , 1,      L,  1500).setLuminosity(10);
		
		DYE_FLUIDS[0].add(FL.make(FL.create("squidink"    , "Squid Ink"       , null, 1, L, 300), L));
		DYE_FLUIDS[4].add(FL.make(FL.create("indigo"      , "Indigo Dye"      , null, 1, L, 300), L));
		
		IIconContainer
		tDyeWaterMixed  = new Textures.BlockIcons.CustomIcon("fluids/dyes.water"),
		tDyeFlower      = new Textures.BlockIcons.CustomIcon("fluids/dyes.flower"),
		tDyeChemical    = new Textures.BlockIcons.CustomIcon("fluids/dyes.chemical"),
		tDyedCFoam      = new Textures.BlockIcons.CustomIcon("fluids/cfoam");
		
		for (byte i = 0; i < 16; i++) {
			DYE_FLUIDS[i].add(DYE_FLUIDS_WATER   [i] = FL.make(FL.create("dye.watermixed." + DYE_OREDICTS_POST[i].toLowerCase(), tDyeWaterMixed, "Water Mixed " + DYE_NAMES[i] + " Dye", null, DYES[i], 1,   L, 300, NI, NI, 0, FluidsGT.SIMPLE, FluidsGT.DYE), L));
			DYE_FLUIDS[i].add(DYE_FLUIDS_FLOWER  [i] = FL.make(FL.create("dye.flower."     + DYE_OREDICTS_POST[i].toLowerCase(), tDyeFlower    , DYE_NAMES[i] + " Flower Dye"          , null, DYES[i], 1,   L, 300, NI, NI, 0, FluidsGT.SIMPLE, FluidsGT.DYE), L));
			DYE_FLUIDS[i].add(DYE_FLUIDS_CHEMICAL[i] = FL.make(FL.create("dye.chemical."   + DYE_OREDICTS_POST[i].toLowerCase(), tDyeChemical  , "Chemical " + DYE_NAMES[i] + " Dye"   , null, DYES[i], 1,   L, 300, NI, NI, 0, FluidsGT.SIMPLE, FluidsGT.DYE), L));
			DYED_C_FOAMS                         [i] = FL.make(FL.create("cfoam."          + DYE_OREDICTS_POST[i].toLowerCase(), tDyedCFoam    , DYE_NAMES[i] + " C-Foam"              , null, DYES[i], 1, 100, 300, NI, NI, 0), 100);
			DYED_C_FOAMS_OWNED                   [i] = FL.make(FL.create("cfoam.owned."    + DYE_OREDICTS_POST[i].toLowerCase(), tDyedCFoam    , "Advanced " + DYE_NAMES[i] + " C-Foam", null, DYES[i], 1, 100, 300, NI, NI, 0), 100);
		}
		
		//-----
		
		FL.create("pyrotheum"          , "Blazing Pyrotheum"  , MT.Pyrotheum , 1, 250, 4000).setDensity(2000).setViscosity(1200).setLuminosity(15);
		FL.create("cryotheum"          , "Gelid Cryotheum"    , MT.Cryotheum , 1, 250,   50).setDensity(4000).setViscosity(3000);
		FL.create("petrotheum"         , "Tectonic Petrotheum", MT.Petrotheum, 1, 250,  400).setDensity(4000).setViscosity(1500);
		FL.create("aerotheum"          , "Zephyrean Aerotheum", MT.Aerotheum , 2, 250,  300).setDensity(-800).setViscosity( 100);
		
		FluidStack
		tFluid = FL.make("mana", 250);
		if (tFluid != null) {
			MT.Magic.liquid(tFluid);
		}
		tFluid = FL.make("ender", 250);
		if (tFluid != null) {
			tFluid.getFluid().setTemperature((int)MT.EnderPearl.mMeltingPoint);
			MT.EnderPearl.liquid(tFluid);
		}
		tFluid = FL.make("redstone", 100);
		if (tFluid != null) {
			tFluid.getFluid().setTemperature((int)MT.Redstone.mMeltingPoint);
			MT.Redstone.liquid(tFluid);
		}
		tFluid = FL.make("glowstone", 250);
		if (tFluid != null) {
			tFluid.getFluid().setTemperature((int)MT.Glowstone.mBoilingPoint);
			MT.Glowstone.gas(tFluid);
		}
		tFluid = FL.make("molten_tritanium", 144);
		if (tFluid != null) {
			tFluid.getFluid().setTemperature((int)MT.TritaniumAlloy.mMeltingPoint);
			MT.TritaniumAlloy.liquid(tFluid);
		}
		
		tFluid = FL.make("ardite.molten"       , 144); if (tFluid != null) {tFluid.getFluid().setTemperature((int)MT.Ardite.mMeltingPoint); MT.Ardite.liquid(tFluid);}
		tFluid = FL.make("manyullyn.molten"    , 144); if (tFluid != null) {tFluid.getFluid().setTemperature((int)MT.Manyullyn.mMeltingPoint); MT.Manyullyn.liquid(tFluid);}
		tFluid = FL.make("aluminumbrass.molten", 144); if (tFluid != null) {tFluid.getFluid().setTemperature((int)MT.AluminiumBrass.mMeltingPoint); MT.AluminiumBrass.liquid(tFluid);}
		tFluid = FL.make("bronze.molten"       , 144); if (tFluid != null) {tFluid.getFluid().setTemperature((int)MT.Bronze.mMeltingPoint); MT.Bronze.liquid(tFluid);}
		tFluid = FL.make("steel.molten"        , 144); if (tFluid != null) {tFluid.getFluid().setTemperature((int)MT.Steel.mMeltingPoint); MT.Steel.liquid(tFluid);}
		tFluid = FL.make("electrum.molten"     , 144); if (tFluid != null) {tFluid.getFluid().setTemperature((int)MT.Electrum.mMeltingPoint); MT.Electrum.liquid(tFluid);}
		tFluid = FL.make("invar.molten"        , 144); if (tFluid != null) {tFluid.getFluid().setTemperature((int)MT.Invar.mMeltingPoint); MT.Invar.liquid(tFluid);}
		tFluid = FL.make("alumite.molten"      , 144); if (tFluid != null) {tFluid.getFluid().setTemperature((int)MT.Alumite.mMeltingPoint); MT.Alumite.liquid(tFluid);}
		tFluid = FL.make("lumium.molten"       , 144); if (tFluid != null) {tFluid.getFluid().setTemperature((int)MT.Lumium.mMeltingPoint); MT.Lumium.liquid(tFluid);}
		tFluid = FL.make("signalum.molten"     , 144); if (tFluid != null) {tFluid.getFluid().setTemperature((int)MT.Signalum.mMeltingPoint); MT.Signalum.liquid(tFluid);}
		tFluid = FL.make("enderium.molten"     , 144); if (tFluid != null) {tFluid.getFluid().setTemperature((int)MT.Enderium.mMeltingPoint); MT.Enderium.liquid(tFluid);}
		tFluid = FL.make("mithril.molten"      , 144); if (tFluid != null) {tFluid.getFluid().setTemperature((int)MT.Mithril.mMeltingPoint); MT.Mithril.liquid(tFluid);}
		tFluid = FL.make("pigiron.molten"      , 144); if (tFluid != null) {tFluid.getFluid().setTemperature((int)MT.PigIron.mMeltingPoint); MT.PigIron.liquid(tFluid);}
		tFluid = FL.make("molten.aluminum"     , 144); if (tFluid != null) {tFluid.getFluid().setTemperature((int)MT.Al.mMeltingPoint); MT.Al.liquid(tFluid);}
		tFluid = FL.make("aluminium.molten"    , 144); if (tFluid != null) {tFluid.getFluid().setTemperature((int)MT.Al.mMeltingPoint); MT.Al.liquid(tFluid);}
		tFluid = FL.make("aluminum.molten"     , 144); if (tFluid != null) {tFluid.getFluid().setTemperature((int)MT.Al.mMeltingPoint); MT.Al.liquid(tFluid);}
		tFluid = FL.make("titanium.molten"     , 144); if (tFluid != null) {tFluid.getFluid().setTemperature((int)MT.Ti.mMeltingPoint); MT.Ti.liquid(tFluid);}
		tFluid = FL.make("magnesium.molten"    , 144); if (tFluid != null) {tFluid.getFluid().setTemperature((int)MT.Mg.mMeltingPoint); MT.Mg.liquid(tFluid);}
		tFluid = FL.make("zinc.molten"         , 144); if (tFluid != null) {tFluid.getFluid().setTemperature((int)MT.Zn.mMeltingPoint); MT.Zn.liquid(tFluid);}
		tFluid = FL.make("osmium.molten"       , 144); if (tFluid != null) {tFluid.getFluid().setTemperature((int)MT.Ge.mMeltingPoint); MT.Ge.liquid(tFluid);}
		tFluid = FL.make("iron.molten"         , 144); if (tFluid != null) {tFluid.getFluid().setTemperature((int)MT.Fe.mMeltingPoint); MT.Fe.liquid(tFluid);}
		tFluid = FL.make("gold.molten"         , 144); if (tFluid != null) {tFluid.getFluid().setTemperature((int)MT.Au.mMeltingPoint); MT.Au.liquid(tFluid);}
		tFluid = FL.make("silver.molten"       , 144); if (tFluid != null) {tFluid.getFluid().setTemperature((int)MT.Ag.mMeltingPoint); MT.Ag.liquid(tFluid);}
		tFluid = FL.make("lead.molten"         , 144); if (tFluid != null) {tFluid.getFluid().setTemperature((int)MT.Pb.mMeltingPoint); MT.Pb.liquid(tFluid);}
		tFluid = FL.make("copper.molten"       , 144); if (tFluid != null) {tFluid.getFluid().setTemperature((int)MT.Cu.mMeltingPoint); MT.Cu.liquid(tFluid);}
		tFluid = FL.make("tin.molten"          , 144); if (tFluid != null) {tFluid.getFluid().setTemperature((int)MT.Sn.mMeltingPoint); MT.Sn.liquid(tFluid);}
		tFluid = FL.make("nickel.molten"       , 144); if (tFluid != null) {tFluid.getFluid().setTemperature((int)MT.Ni.mMeltingPoint); MT.Ni.liquid(tFluid);}
		tFluid = FL.make("platinum.molten"     , 144); if (tFluid != null) {tFluid.getFluid().setTemperature((int)MT.Pt.mMeltingPoint); MT.Pt.liquid(tFluid);}
		tFluid = FL.make("cobalt.molten"       , 144); if (tFluid != null) {tFluid.getFluid().setTemperature((int)MT.Co.mMeltingPoint); MT.Co.liquid(tFluid);}
		
		FL.create("plastic"                  , "Molten Plastic"      , MT.Plastic        , 1, 1000,   423);
		FL.create("glass"                    , "Molten Glass"        , MT.Glass          , 1,    L,  1200);
		FL.create("molten.enderpearl"        , "Molten Enderpearls"  , MT.EnderPearl     , 1,    L,  2723).setLuminosity( 5);
		FL.create("molten.redstone"          , "Molten Redstone"     , MT.Redstone       , 1,    L,   500).setLuminosity( 5);
		FL.create("blaze"                    , "Blazing Goo"         , MT.Blaze          , 1,  9*L,  4000).setLuminosity(15);
		FL.create("concrete"                 , "Wet Concrete"        , MT.Concrete       , 1,    L,   300);
		FL.create("molten.latex"             , "Latex"               , MT.Latex          , 1,    L, DEF_ENV_TEMP);
		FL.create("latex"                    , "Latex"               , MT.Latex          , 1,    L, DEF_ENV_TEMP);
		FL.create("molten hsla"              , "Molten HSLA Steel"   , MT.HSLA           , 1,    L,  1873).setLuminosity( 5);
		
		FL.createMolten(MT.Chocolate         , TextureSet.SET_FLUID[0].mList.get(IconsGT.INDEX_BLOCK_MOLTEN), FluidsGT.SIMPLE);
		FL.createMolten(MT.Cheese            , TextureSet.SET_FLUID[0].mList.get(IconsGT.INDEX_BLOCK_MOLTEN), FluidsGT.SIMPLE);
		FL.createMolten(MT.Sugar             , TextureSet.SET_FLUID[0].mList.get(IconsGT.INDEX_BLOCK_MOLTEN), FluidsGT.SIMPLE);
		FL.createMolten(MT.Rubber            , TextureSet.SET_FLUID[0].mList.get(IconsGT.INDEX_BLOCK_MOLTEN), FluidsGT.SIMPLE);
		FL.createMolten(MT.Wax               , TextureSet.SET_FLUID[0].mList.get(IconsGT.INDEX_BLOCK_MOLTEN), FluidsGT.SIMPLE);
		FL.createMolten(MT.WaxBee            , TextureSet.SET_FLUID[0].mList.get(IconsGT.INDEX_BLOCK_MOLTEN), FluidsGT.SIMPLE);
		FL.createMolten(MT.WaxParaffin       , TextureSet.SET_FLUID[0].mList.get(IconsGT.INDEX_BLOCK_MOLTEN), FluidsGT.SIMPLE);
		FL.createMolten(MT.WaxPlant          , TextureSet.SET_FLUID[0].mList.get(IconsGT.INDEX_BLOCK_MOLTEN), FluidsGT.SIMPLE);
		FL.createMolten(MT.WaxRefractory     , TextureSet.SET_FLUID[0].mList.get(IconsGT.INDEX_BLOCK_MOLTEN), FluidsGT.SIMPLE);
		FL.createMolten(MT.WaxMagic          , TextureSet.SET_FLUID[0].mList.get(IconsGT.INDEX_BLOCK_MOLTEN), FluidsGT.SIMPLE);
		FL.createMolten(MT.WaxAmnesic        , TextureSet.SET_FLUID[0].mList.get(IconsGT.INDEX_BLOCK_MOLTEN), FluidsGT.SIMPLE);
		FL.createMolten(MT.WaxSoulful        , TextureSet.SET_FLUID[0].mList.get(IconsGT.INDEX_BLOCK_MOLTEN), FluidsGT.SIMPLE);
		
		FL.createMolten(MT.Al2O3             , 504);
		
		/*
		for (OreDictMaterial tMaterial : OreDictMaterial.MATERIAL_MAP.values()) {
			if (tMaterial.mLiquid == null && !tMaterial.contains(TD.Properties.INVALID_MATERIAL) && tMaterial.contains(TD.Properties.MELTING) && tMaterial.mTargetSmelting.mAmount > 0) {
				FL.createMoltenFluid(tMaterial);
				if (tMaterial.mTargetSmelting.mMaterial != tMaterial && tMaterial.mTargetSmelting.mMaterial.mLiquid == null) {
					FL.createMoltenFluid(tMaterial.mTargetSmelting.mMaterial);
				}
			}
		}*/
		
		//-----
		
		IIconContainer tIconPotion = new Textures.BlockIcons.CustomIcon("fluids/potion");
		
		new FoodStatDrink(FL.create("potion.tainted"                                          , "Tainted Brew"                            , null                                                                 , 1, 1000, 300)                                                                                       , "tainted between the lands"               ,  0, 0.0F  ,  20, C+37,  0.00F, EnumAction.drink, T, F, F, Potion.poison           .id, 100, 3, 100, Potion.hunger         .id, 100, 3, 100);
		
		new FoodStatDrink(FL.create("potion.awkward"                                          , "Awkward Brew"                            , null                                                                 , 1, 1000, 300, ST.make(Items.potionitem, 1,    16), IL.Bottle_Empty.get(1), 250)                     , "well, that's awkward"                    ,  0, 0.0F  ,  20, C+37,  0.00F, EnumAction.drink, T, F, F);
		new FoodStatDrink(FL.create("potion.thick"                                            , "Thick Brew"                              , null                                                                 , 1, 1000, 300, ST.make(Items.potionitem, 1,    32), IL.Bottle_Empty.get(1), 250)                     , "thick and gooey"                         ,  0, 0.0F  ,  15, C+37,  0.00F, EnumAction.drink, T, F, F);
		new FoodStatDrink(FL.create("potion.mundane"                                          , "Mundane Brew"                            , null                                                                 , 1, 1000, 300, ST.make(Items.potionitem, 1,    64), IL.Bottle_Empty.get(1), 250)                     , "how mundane of you"                      ,  0, 0.0F  ,  25, C+37,  0.00F, EnumAction.drink, T, F, F);
		new FoodStatDrink(FL.create("potion.damage"                              , tIconPotion, "Harming Brew"                            , null, UT.Code.getRGBaArray(Potion.harm             .getLiquidColor()), 1, 1000, 300, ST.make(Items.potionitem, 1,  8204), IL.Bottle_Empty.get(1), 250)                     , LH.Chat.RED   + "Instant Damage I"        ,  0, 0.0F  ,   0, C+37,  0.00F, EnumAction.drink, T, F, F, Potion.harm             .id,   1, 0, 100);
		new FoodStatDrink(FL.create("potion.damage.strong"                       , tIconPotion, "Strong Harming Brew"                     , null, UT.Code.getRGBaArray(Potion.harm             .getLiquidColor()), 1, 1000, 300, ST.make(Items.potionitem, 1,  8236), IL.Bottle_Empty.get(1), 250).setLuminosity(10)   , LH.Chat.RED   + "Instant Damage II"       ,  0, 0.0F  ,   0, C+37,  0.00F, EnumAction.drink, T, F, F, Potion.harm             .id,   1, 1, 100);
		new FoodStatDrink(FL.create("potion.damage.splash"                       , tIconPotion, "Splash Harming Brew"                     , null, UT.Code.getRGBaArray(Potion.harm             .getLiquidColor()), 1, 1000, 300, ST.make(Items.potionitem, 1, 16396), IL.Bottle_Empty.get(1), 250)                     , LH.Chat.RED   + "Instant Damage I"        ,  0, 0.0F  ,   0, C+37,  0.00F, EnumAction.drink, T, F, F, Potion.harm             .id,   1, 0, 100);
		new FoodStatDrink(FL.create("potion.damage.strong.splash"                , tIconPotion, "Strong Splash Harming Brew"              , null, UT.Code.getRGBaArray(Potion.harm             .getLiquidColor()), 1, 1000, 300, ST.make(Items.potionitem, 1, 16428), IL.Bottle_Empty.get(1), 250).setLuminosity(10)   , LH.Chat.RED   + "Instant Damage II"       ,  0, 0.0F  ,   0, C+37,  0.00F, EnumAction.drink, T, F, F, Potion.harm             .id,   1, 1, 100);
		new FoodStatDrink(FL.create("potion.health"                              , tIconPotion, "Healing Brew"                            , null, UT.Code.getRGBaArray(Potion.heal             .getLiquidColor()), 1, 1000, 300, ST.make(Items.potionitem, 1,  8197), IL.Bottle_Empty.get(1), 250)                     , LH.Chat.PINK  + "Instant Health I"        ,  0, 0.0F  ,   0, C+37,  0.00F, EnumAction.drink, T, F, F, Potion.heal             .id,   1, 0, 100);
		new FoodStatDrink(FL.create("potion.health.strong"                       , tIconPotion, "Strong Healing Brew"                     , null, UT.Code.getRGBaArray(Potion.heal             .getLiquidColor()), 1, 1000, 300, ST.make(Items.potionitem, 1,  8229), IL.Bottle_Empty.get(1), 250).setLuminosity(10)   , LH.Chat.PINK  + "Instant Health II"       ,  0, 0.0F  ,   0, C+37,  0.00F, EnumAction.drink, T, F, F, Potion.heal             .id,   1, 1, 100);
		new FoodStatDrink(FL.create("potion.health.splash"                       , tIconPotion, "Splash Healing Brew"                     , null, UT.Code.getRGBaArray(Potion.heal             .getLiquidColor()), 1, 1000, 300, ST.make(Items.potionitem, 1, 16389), IL.Bottle_Empty.get(1), 250)                     , LH.Chat.PINK  + "Instant Health I"        ,  0, 0.0F  ,   0, C+37,  0.00F, EnumAction.drink, T, F, F, Potion.heal             .id,   1, 0, 100);
		new FoodStatDrink(FL.create("potion.health.strong.splash"                , tIconPotion, "Strong Splash Healing Brew"              , null, UT.Code.getRGBaArray(Potion.heal             .getLiquidColor()), 1, 1000, 300, ST.make(Items.potionitem, 1, 16421), IL.Bottle_Empty.get(1), 250).setLuminosity(10)   , LH.Chat.PINK  + "Instant Health II"       ,  0, 0.0F  ,   0, C+37,  0.00F, EnumAction.drink, T, F, F, Potion.heal             .id,   1, 1, 100);
		new FoodStatDrink(FL.create("potion.jump"                                , tIconPotion, "Jumpy Brew"                              , null, UT.Code.getRGBaArray(Potion.jump             .getLiquidColor()), 1, 1000, 300, ST.make(Items.potionitem, 1,  8203), IL.Bottle_Empty.get(1), 250)                     , LH.Chat.GREEN + "Jump Boost I (3:00)"     ,  0, 0.0F  ,   0, C+37,  0.00F, EnumAction.drink, T, F, F, Potion.jump             .id,3600, 0, 100);
		new FoodStatDrink(FL.create("potion.jump.strong"                         , tIconPotion, "Strong Jumpy Brew"                       , null, UT.Code.getRGBaArray(Potion.jump             .getLiquidColor()), 1, 1000, 300, ST.make(Items.potionitem, 1,  8235), IL.Bottle_Empty.get(1), 250).setLuminosity(10)   , LH.Chat.GREEN + "Jump Boost II (1:30)"    ,  0, 0.0F  ,   0, C+37,  0.00F, EnumAction.drink, T, F, F, Potion.jump             .id,1800, 1, 100);
		new FoodStatDrink(FL.create("potion.jump.splash"                         , tIconPotion, "Splash Jumpy Brew"                       , null, UT.Code.getRGBaArray(Potion.jump             .getLiquidColor()), 1, 1000, 300, ST.make(Items.potionitem, 1, 16395), IL.Bottle_Empty.get(1), 250)                     , LH.Chat.GREEN + "Jump Boost I (2:15)"     ,  0, 0.0F  ,   0, C+37,  0.00F, EnumAction.drink, T, F, F, Potion.jump             .id,2700, 0, 100);
		new FoodStatDrink(FL.create("potion.jump.strong.splash"                  , tIconPotion, "Strong Splash Jumpy Brew"                , null, UT.Code.getRGBaArray(Potion.jump             .getLiquidColor()), 1, 1000, 300, ST.make(Items.potionitem, 1, 16427), IL.Bottle_Empty.get(1), 250).setLuminosity(10)   , LH.Chat.GREEN + "Jump Boost II (1:07)"    ,  0, 0.0F  ,   0, C+37,  0.00F, EnumAction.drink, T, F, F, Potion.jump             .id,1350, 1, 100);
		new FoodStatDrink(FL.create("potion.speed"                               , tIconPotion, "Swiftness Brew"                          , null, UT.Code.getRGBaArray(Potion.moveSpeed        .getLiquidColor()), 1, 1000, 300, ST.make(Items.potionitem, 1,  8194), IL.Bottle_Empty.get(1), 250)                     , LH.Chat.GREEN + "Speed I (3:00)"          ,  0, 0.0F  ,   0, C+37,  0.00F, EnumAction.drink, T, F, F, Potion.moveSpeed        .id,3600, 0, 100);
		new FoodStatDrink(FL.create("potion.speed.strong"                        , tIconPotion, "Strong Swiftness Brew"                   , null, UT.Code.getRGBaArray(Potion.moveSpeed        .getLiquidColor()), 1, 1000, 300, ST.make(Items.potionitem, 1,  8226), IL.Bottle_Empty.get(1), 250).setLuminosity(10)   , LH.Chat.GREEN + "Speed II (1:30)"         ,  0, 0.0F  ,   0, C+37,  0.00F, EnumAction.drink, T, F, F, Potion.moveSpeed        .id,1800, 1, 100);
		new FoodStatDrink(FL.create("potion.speed.long"                          , tIconPotion, "Stretched Swiftness Brew"                , null, UT.Code.getRGBaArray(Potion.moveSpeed        .getLiquidColor()), 1, 1000, 300, ST.make(Items.potionitem, 1,  8258), IL.Bottle_Empty.get(1), 250).setLuminosity( 5)   , LH.Chat.GREEN + "Speed I (8:00)"          ,  0, 0.0F  ,   0, C+37,  0.00F, EnumAction.drink, T, F, F, Potion.moveSpeed        .id,9600, 0, 100);
		new FoodStatDrink(FL.create("potion.speed.splash"                        , tIconPotion, "Splash Swiftness Brew"                   , null, UT.Code.getRGBaArray(Potion.moveSpeed        .getLiquidColor()), 1, 1000, 300, ST.make(Items.potionitem, 1, 16386), IL.Bottle_Empty.get(1), 250)                     , LH.Chat.GREEN + "Speed I (2:15)"          ,  0, 0.0F  ,   0, C+37,  0.00F, EnumAction.drink, T, F, F, Potion.moveSpeed        .id,2700, 0, 100);
		new FoodStatDrink(FL.create("potion.speed.strong.splash"                 , tIconPotion, "Strong Splash Swiftness Brew"            , null, UT.Code.getRGBaArray(Potion.moveSpeed        .getLiquidColor()), 1, 1000, 300, ST.make(Items.potionitem, 1, 16418), IL.Bottle_Empty.get(1), 250).setLuminosity(10)   , LH.Chat.GREEN + "Speed II (1:07)"         ,  0, 0.0F  ,   0, C+37,  0.00F, EnumAction.drink, T, F, F, Potion.moveSpeed        .id,1350, 1, 100);
		new FoodStatDrink(FL.create("potion.speed.long.splash"                   , tIconPotion, "Stretched Splash Swiftness Brew"         , null, UT.Code.getRGBaArray(Potion.moveSpeed        .getLiquidColor()), 1, 1000, 300, ST.make(Items.potionitem, 1, 16450), IL.Bottle_Empty.get(1), 250).setLuminosity( 5)   , LH.Chat.GREEN + "Speed I (6:00)"          ,  0, 0.0F  ,   0, C+37,  0.00F, EnumAction.drink, T, F, F, Potion.moveSpeed        .id,7200, 0, 100);
		new FoodStatDrink(FL.create("potion.strength"                            , tIconPotion, "Strength Brew"                           , null, UT.Code.getRGBaArray(Potion.damageBoost      .getLiquidColor()), 1, 1000, 300, ST.make(Items.potionitem, 1,  8201), IL.Bottle_Empty.get(1), 250)                     , LH.Chat.GREEN + "Strength I (3:00)"       ,  0, 0.0F  ,   0, C+37,  0.00F, EnumAction.drink, T, F, F, Potion.damageBoost      .id,3600, 0, 100);
		new FoodStatDrink(FL.create("potion.strength.strong"                     , tIconPotion, "Strong Strength Brew"                    , null, UT.Code.getRGBaArray(Potion.damageBoost      .getLiquidColor()), 1, 1000, 300, ST.make(Items.potionitem, 1,  8233), IL.Bottle_Empty.get(1), 250).setLuminosity(10)   , LH.Chat.GREEN + "Strength II (1:30)"      ,  0, 0.0F  ,   0, C+37,  0.00F, EnumAction.drink, T, F, F, Potion.damageBoost      .id,1800, 1, 100);
		new FoodStatDrink(FL.create("potion.strength.long"                       , tIconPotion, "Stretched Strength Brew"                 , null, UT.Code.getRGBaArray(Potion.damageBoost      .getLiquidColor()), 1, 1000, 300, ST.make(Items.potionitem, 1,  8265), IL.Bottle_Empty.get(1), 250).setLuminosity( 5)   , LH.Chat.GREEN + "Strength I (8:00)"       ,  0, 0.0F  ,   0, C+37,  0.00F, EnumAction.drink, T, F, F, Potion.damageBoost      .id,9600, 0, 100);
		new FoodStatDrink(FL.create("potion.strength.splash"                     , tIconPotion, "Splash Strength Brew"                    , null, UT.Code.getRGBaArray(Potion.damageBoost      .getLiquidColor()), 1, 1000, 300, ST.make(Items.potionitem, 1, 16393), IL.Bottle_Empty.get(1), 250)                     , LH.Chat.GREEN + "Strength I (2:15)"       ,  0, 0.0F  ,   0, C+37,  0.00F, EnumAction.drink, T, F, F, Potion.damageBoost      .id,2700, 0, 100);
		new FoodStatDrink(FL.create("potion.strength.strong.splash"              , tIconPotion, "Strong Splash Strength Brew"             , null, UT.Code.getRGBaArray(Potion.damageBoost      .getLiquidColor()), 1, 1000, 300, ST.make(Items.potionitem, 1, 16425), IL.Bottle_Empty.get(1), 250).setLuminosity(10)   , LH.Chat.GREEN + "Strength II (1:07)"      ,  0, 0.0F  ,   0, C+37,  0.00F, EnumAction.drink, T, F, F, Potion.damageBoost      .id,1350, 1, 100);
		new FoodStatDrink(FL.create("potion.strength.long.splash"                , tIconPotion, "Stretched Splash Strength Brew"          , null, UT.Code.getRGBaArray(Potion.damageBoost      .getLiquidColor()), 1, 1000, 300, ST.make(Items.potionitem, 1, 16457), IL.Bottle_Empty.get(1), 250).setLuminosity( 5)   , LH.Chat.GREEN + "Strength I (6:00)"       ,  0, 0.0F  ,   0, C+37,  0.00F, EnumAction.drink, T, F, F, Potion.damageBoost      .id,7200, 0, 100);
		new FoodStatDrink(FL.create("potion.regen"                               , tIconPotion, "Regenerating Brew"                       , null, UT.Code.getRGBaArray(Potion.regeneration     .getLiquidColor()), 1, 1000, 300, ST.make(Items.potionitem, 1,  8193), IL.Bottle_Empty.get(1), 250)                     , LH.Chat.PINK  + "Regeneration I (0:45)"   ,  0, 0.0F  ,   0, C+37,  0.00F, EnumAction.drink, T, F, F, Potion.regeneration     .id, 900, 0, 100);
		new FoodStatDrink(FL.create("potion.regen.strong"                        , tIconPotion, "Strong Regenerating Brew"                , null, UT.Code.getRGBaArray(Potion.regeneration     .getLiquidColor()), 1, 1000, 300, ST.make(Items.potionitem, 1,  8225), IL.Bottle_Empty.get(1), 250).setLuminosity(10)   , LH.Chat.PINK  + "Regeneration II (0:22)"  ,  0, 0.0F  ,   0, C+37,  0.00F, EnumAction.drink, T, F, F, Potion.regeneration     .id, 450, 1, 100);
		new FoodStatDrink(FL.create("potion.regen.long"                          , tIconPotion, "Stretched Regenerating Brew"             , null, UT.Code.getRGBaArray(Potion.regeneration     .getLiquidColor()), 1, 1000, 300, ST.make(Items.potionitem, 1,  8257), IL.Bottle_Empty.get(1), 250).setLuminosity( 5)   , LH.Chat.PINK  + "Regeneration I (2:00)"   ,  0, 0.0F  ,   0, C+37,  0.00F, EnumAction.drink, T, F, F, Potion.regeneration     .id,2400, 0, 100);
		new FoodStatDrink(FL.create("potion.regen.splash"                        , tIconPotion, "Splash Regenerating Brew"                , null, UT.Code.getRGBaArray(Potion.regeneration     .getLiquidColor()), 1, 1000, 300, ST.make(Items.potionitem, 1, 16385), IL.Bottle_Empty.get(1), 250)                     , LH.Chat.PINK  + "Regeneration I (0:33)"   ,  0, 0.0F  ,   0, C+37,  0.00F, EnumAction.drink, T, F, F, Potion.regeneration     .id, 666, 0, 100);
		new FoodStatDrink(FL.create("potion.regen.strong.splash"                 , tIconPotion, "Strong Splash Regenerating Brew"         , null, UT.Code.getRGBaArray(Potion.regeneration     .getLiquidColor()), 1, 1000, 300, ST.make(Items.potionitem, 1, 16417), IL.Bottle_Empty.get(1), 250).setLuminosity(10)   , LH.Chat.PINK  + "Regeneration II (0:16)"  ,  0, 0.0F  ,   0, C+37,  0.00F, EnumAction.drink, T, F, F, Potion.regeneration     .id, 333, 1, 100);
		new FoodStatDrink(FL.create("potion.regen.long.splash"                   , tIconPotion, "Stretched Splash Regenerating Brew"      , null, UT.Code.getRGBaArray(Potion.regeneration     .getLiquidColor()), 1, 1000, 300, ST.make(Items.potionitem, 1, 16449), IL.Bottle_Empty.get(1), 250).setLuminosity( 5)   , LH.Chat.PINK  + "Regeneration I (1:30)"   ,  0, 0.0F  ,   0, C+37,  0.00F, EnumAction.drink, T, F, F, Potion.regeneration     .id,1800, 0, 100);
		new FoodStatDrink(FL.create("potion.poison"                              , tIconPotion, "Poisonous Brew"                          , null, UT.Code.getRGBaArray(Potion.poison           .getLiquidColor()), 1, 1000, 300, ST.make(Items.potionitem, 1,  8196), IL.Bottle_Empty.get(1), 250)                     , LH.Chat.RED   + "Poison I (0:45)"         ,  0, 0.0F  ,   0, C+37,  0.00F, EnumAction.drink, T, F, F, Potion.poison           .id, 900, 0, 100);
		new FoodStatDrink(FL.create("potion.poison.strong"                       , tIconPotion, "Strong Poisonous Brew"                   , null, UT.Code.getRGBaArray(Potion.poison           .getLiquidColor()), 1, 1000, 300, ST.make(Items.potionitem, 1,  8228), IL.Bottle_Empty.get(1), 250).setLuminosity(10)   , LH.Chat.RED   + "Poison II (0:22)"        ,  0, 0.0F  ,   0, C+37,  0.00F, EnumAction.drink, T, F, F, Potion.poison           .id, 450, 1, 100);
		new FoodStatDrink(FL.create("potion.poison.long"                         , tIconPotion, "Stretched Poisonous Brew"                , null, UT.Code.getRGBaArray(Potion.poison           .getLiquidColor()), 1, 1000, 300, ST.make(Items.potionitem, 1,  8260), IL.Bottle_Empty.get(1), 250).setLuminosity( 5)   , LH.Chat.RED   + "Poison I (2:00)"         ,  0, 0.0F  ,   0, C+37,  0.00F, EnumAction.drink, T, F, F, Potion.poison           .id,2400, 0, 100);
		new FoodStatDrink(FL.create("potion.poison.splash"                       , tIconPotion, "Splash Poisonous Brew"                   , null, UT.Code.getRGBaArray(Potion.poison           .getLiquidColor()), 1, 1000, 300, ST.make(Items.potionitem, 1, 16388), IL.Bottle_Empty.get(1), 250)                     , LH.Chat.RED   + "Poison I (0:33)"         ,  0, 0.0F  ,   0, C+37,  0.00F, EnumAction.drink, T, F, F, Potion.poison           .id, 666, 0, 100);
		new FoodStatDrink(FL.create("potion.poison.strong.splash"                , tIconPotion, "Strong Splash Poisonous Brew"            , null, UT.Code.getRGBaArray(Potion.poison           .getLiquidColor()), 1, 1000, 300, ST.make(Items.potionitem, 1, 16420), IL.Bottle_Empty.get(1), 250).setLuminosity(10)   , LH.Chat.RED   + "Poison II (0:16)"        ,  0, 0.0F  ,   0, C+37,  0.00F, EnumAction.drink, T, F, F, Potion.poison           .id, 333, 1, 100);
		new FoodStatDrink(FL.create("potion.poison.long.splash"                  , tIconPotion, "Stretched Splash Poisonous Brew"         , null, UT.Code.getRGBaArray(Potion.poison           .getLiquidColor()), 1, 1000, 300, ST.make(Items.potionitem, 1, 16452), IL.Bottle_Empty.get(1), 250).setLuminosity( 5)   , LH.Chat.RED   + "Poison I (1:30)"         ,  0, 0.0F  ,   0, C+37,  0.00F, EnumAction.drink, T, F, F, Potion.poison           .id,1800, 0, 100);
		new FoodStatDrink(FL.create("potion.fireresistance"                      , tIconPotion, "Fire Resistant Brew"                     , null, UT.Code.getRGBaArray(Potion.fireResistance   .getLiquidColor()), 1, 1000, 375, ST.make(Items.potionitem, 1,  8195), IL.Bottle_Empty.get(1), 250).setLuminosity(10)   , LH.Chat.BLUE  + "Fire Resistance (3:00)"  ,  0, 0.0F  ,   0, C+37,  0.00F, EnumAction.drink, T, F, F, Potion.fireResistance   .id,3600, 0, 100);
		new FoodStatDrink(FL.create("potion.fireresistance.long"                 , tIconPotion, "Stretched Fire Resistant Brew"           , null, UT.Code.getRGBaArray(Potion.fireResistance   .getLiquidColor()), 1, 1000, 375, ST.make(Items.potionitem, 1,  8259), IL.Bottle_Empty.get(1), 250).setLuminosity(15)   , LH.Chat.BLUE  + "Fire Resistance (8:00)"  ,  0, 0.0F  ,   0, C+37,  0.00F, EnumAction.drink, T, F, F, Potion.fireResistance   .id,9600, 0, 100);
		new FoodStatDrink(FL.create("potion.fireresistance.splash"               , tIconPotion, "Splash Fire Resistant Brew"              , null, UT.Code.getRGBaArray(Potion.fireResistance   .getLiquidColor()), 1, 1000, 375, ST.make(Items.potionitem, 1, 16387), IL.Bottle_Empty.get(1), 250).setLuminosity(10)   , LH.Chat.BLUE  + "Fire Resistance (2:15)"  ,  0, 0.0F  ,   0, C+37,  0.00F, EnumAction.drink, T, F, F, Potion.fireResistance   .id,2700, 0, 100);
		new FoodStatDrink(FL.create("potion.fireresistance.long.splash"          , tIconPotion, "Stretched Splash Fire Resistant Brew"    , null, UT.Code.getRGBaArray(Potion.fireResistance   .getLiquidColor()), 1, 1000, 375, ST.make(Items.potionitem, 1, 16451), IL.Bottle_Empty.get(1), 250).setLuminosity(15)   , LH.Chat.BLUE  + "Fire Resistance (6:00)"  ,  0, 0.0F  ,   0, C+37,  0.00F, EnumAction.drink, T, F, F, Potion.fireResistance   .id,7200, 0, 100);
		new FoodStatDrink(FL.create("potion.nightvision"                         , tIconPotion, "Night Vision Brew"                       , null, UT.Code.getRGBaArray(Potion.nightVision      .getLiquidColor()), 1, 1000, 300, ST.make(Items.potionitem, 1,  8198), IL.Bottle_Empty.get(1), 250)                     , LH.Chat.CYAN  + "Night Vision (3:00)"     ,  0, 0.0F  ,   0, C+37,  0.00F, EnumAction.drink, T, F, F, Potion.nightVision      .id,3600, 0, 100);
		new FoodStatDrink(FL.create("potion.nightvision.long"                    , tIconPotion, "Stretched Night Vision Brew"             , null, UT.Code.getRGBaArray(Potion.nightVision      .getLiquidColor()), 1, 1000, 300, ST.make(Items.potionitem, 1,  8262), IL.Bottle_Empty.get(1), 250).setLuminosity( 5)   , LH.Chat.CYAN  + "Night Vision (8:00)"     ,  0, 0.0F  ,   0, C+37,  0.00F, EnumAction.drink, T, F, F, Potion.nightVision      .id,9600, 0, 100);
		new FoodStatDrink(FL.create("potion.nightvision.splash"                  , tIconPotion, "Splash Night Vision Brew"                , null, UT.Code.getRGBaArray(Potion.nightVision      .getLiquidColor()), 1, 1000, 300, ST.make(Items.potionitem, 1, 16390), IL.Bottle_Empty.get(1), 250)                     , LH.Chat.CYAN  + "Night Vision (2:15)"     ,  0, 0.0F  ,   0, C+37,  0.00F, EnumAction.drink, T, F, F, Potion.nightVision      .id,2700, 0, 100);
		new FoodStatDrink(FL.create("potion.nightvision.long.splash"             , tIconPotion, "Stretched Splash Night Vision Brew"      , null, UT.Code.getRGBaArray(Potion.nightVision      .getLiquidColor()), 1, 1000, 300, ST.make(Items.potionitem, 1, 16454), IL.Bottle_Empty.get(1), 250).setLuminosity( 5)   , LH.Chat.CYAN  + "Night Vision (6:00)"     ,  0, 0.0F  ,   0, C+37,  0.00F, EnumAction.drink, T, F, F, Potion.nightVision      .id,7200, 0, 100);
		new FoodStatDrink(FL.create("potion.weakness"                            , tIconPotion, "Weakening Brew"                          , null, UT.Code.getRGBaArray(Potion.weakness         .getLiquidColor()), 1, 1000, 300, ST.make(Items.potionitem, 1,  8200), IL.Bottle_Empty.get(1), 250)                     , LH.Chat.DRED  + "Weakness (1:30)"         ,  0, 0.0F  ,   0, C+37,  0.00F, EnumAction.drink, T, F, F, Potion.weakness         .id,1800, 0, 100);
		new FoodStatDrink(FL.create("potion.weakness.long"                       , tIconPotion, "Stretched Weakening Brew"                , null, UT.Code.getRGBaArray(Potion.weakness         .getLiquidColor()), 1, 1000, 300, ST.make(Items.potionitem, 1,  8264), IL.Bottle_Empty.get(1), 250).setLuminosity( 5)   , LH.Chat.DRED  + "Weakness (4:00)"         ,  0, 0.0F  ,   0, C+37,  0.00F, EnumAction.drink, T, F, F, Potion.weakness         .id,4800, 0, 100);
		new FoodStatDrink(FL.create("potion.weakness.splash"                     , tIconPotion, "Splash Weakening Brew"                   , null, UT.Code.getRGBaArray(Potion.weakness         .getLiquidColor()), 1, 1000, 300, ST.make(Items.potionitem, 1, 16392), IL.Bottle_Empty.get(1), 250)                     , LH.Chat.DRED  + "Weakness (1:07)"         ,  0, 0.0F  ,   0, C+37,  0.00F, EnumAction.drink, T, F, F, Potion.weakness         .id,1350, 0, 100);
		new FoodStatDrink(FL.create("potion.weakness.long.splash"                , tIconPotion, "Stretched Splash Weakening Brew"         , null, UT.Code.getRGBaArray(Potion.weakness         .getLiquidColor()), 1, 1000, 300, ST.make(Items.potionitem, 1, 16456), IL.Bottle_Empty.get(1), 250).setLuminosity( 5)   , LH.Chat.DRED  + "Weakness (3:00)"         ,  0, 0.0F  ,   0, C+37,  0.00F, EnumAction.drink, T, F, F, Potion.weakness         .id,3600, 0, 100);
		new FoodStatDrink(FL.create("potion.slowness"                            , tIconPotion, "Lame Brew"                               , null, UT.Code.getRGBaArray(Potion.moveSlowdown     .getLiquidColor()), 1, 1000, 300, ST.make(Items.potionitem, 1,  8202), IL.Bottle_Empty.get(1), 250)                     , LH.Chat.DRED  + "Slowness (1:30)"         ,  0, 0.0F  ,   0, C+37,  0.00F, EnumAction.drink, T, F, F, Potion.moveSlowdown     .id,1800, 0, 100);
		new FoodStatDrink(FL.create("potion.slowness.long"                       , tIconPotion, "Stretched Lame Brew"                     , null, UT.Code.getRGBaArray(Potion.moveSlowdown     .getLiquidColor()), 1, 1000, 300, ST.make(Items.potionitem, 1,  8266), IL.Bottle_Empty.get(1), 250).setLuminosity( 5)   , LH.Chat.DRED  + "Slowness (4:00)"         ,  0, 0.0F  ,   0, C+37,  0.00F, EnumAction.drink, T, F, F, Potion.moveSlowdown     .id,4800, 0, 100);
		new FoodStatDrink(FL.create("potion.slowness.splash"                     , tIconPotion, "Splash Lame Brew"                        , null, UT.Code.getRGBaArray(Potion.moveSlowdown     .getLiquidColor()), 1, 1000, 300, ST.make(Items.potionitem, 1, 16394), IL.Bottle_Empty.get(1), 250)                     , LH.Chat.DRED  + "Slowness (1:07)"         ,  0, 0.0F  ,   0, C+37,  0.00F, EnumAction.drink, T, F, F, Potion.moveSlowdown     .id,1350, 0, 100);
		new FoodStatDrink(FL.create("potion.slowness.long.splash"                , tIconPotion, "Stretched Splash Lame Brew"              , null, UT.Code.getRGBaArray(Potion.moveSlowdown     .getLiquidColor()), 1, 1000, 300, ST.make(Items.potionitem, 1, 16458), IL.Bottle_Empty.get(1), 250).setLuminosity( 5)   , LH.Chat.DRED  + "Slowness (3:00)"         ,  0, 0.0F  ,   0, C+37,  0.00F, EnumAction.drink, T, F, F, Potion.moveSlowdown     .id,3600, 0, 100);
		new FoodStatDrink(FL.create("potion.waterbreathing"                      , tIconPotion, "Fishy Brew"                              , null, UT.Code.getRGBaArray(Potion.waterBreathing   .getLiquidColor()), 1, 1000, 300, ST.make(Items.potionitem, 1,  8205), IL.Bottle_Empty.get(1), 250)                     , LH.Chat.CYAN  + "Water Breathing (3:00)"  ,  0, 0.0F  ,   0, C+37,  0.00F, EnumAction.drink, T, F, F, Potion.waterBreathing   .id,3600, 0, 100);
		new FoodStatDrink(FL.create("potion.waterbreathing.long"                 , tIconPotion, "Stretched Fishy Brew"                    , null, UT.Code.getRGBaArray(Potion.waterBreathing   .getLiquidColor()), 1, 1000, 300, ST.make(Items.potionitem, 1,  8269), IL.Bottle_Empty.get(1), 250).setLuminosity( 5)   , LH.Chat.CYAN  + "Water Breathing (8:00)"  ,  0, 0.0F  ,   0, C+37,  0.00F, EnumAction.drink, T, F, F, Potion.waterBreathing   .id,9600, 0, 100);
		new FoodStatDrink(FL.create("potion.waterbreathing.splash"               , tIconPotion, "Splash Fishy Brew"                       , null, UT.Code.getRGBaArray(Potion.waterBreathing   .getLiquidColor()), 1, 1000, 300, ST.make(Items.potionitem, 1, 16397), IL.Bottle_Empty.get(1), 250)                     , LH.Chat.CYAN  + "Water Breathing (2:15)"  ,  0, 0.0F  ,   0, C+37,  0.00F, EnumAction.drink, T, F, F, Potion.waterBreathing   .id,2700, 0, 100);
		new FoodStatDrink(FL.create("potion.waterbreathing.long.splash"          , tIconPotion, "Stretched Splash Fishy Brew"             , null, UT.Code.getRGBaArray(Potion.waterBreathing   .getLiquidColor()), 1, 1000, 300, ST.make(Items.potionitem, 1, 16461), IL.Bottle_Empty.get(1), 250).setLuminosity( 5)   , LH.Chat.CYAN  + "Water Breathing (6:00)"  ,  0, 0.0F  ,   0, C+37,  0.00F, EnumAction.drink, T, F, F, Potion.waterBreathing   .id,7200, 0, 100);
		new FoodStatDrink(FL.create("potion.invisibility"                        , tIconPotion, "Invisible Brew"                          , null, UT.Code.getRGBaArray(Potion.invisibility     .getLiquidColor()), 1, 1000, 300, ST.make(Items.potionitem, 1,  8206), IL.Bottle_Empty.get(1), 250)                     , LH.Chat.CYAN  + "Invisibility (3:00)"     ,  0, 0.0F  ,   0, C+37,  0.00F, EnumAction.drink, T, F, F, Potion.invisibility     .id,3600, 0, 100);
		new FoodStatDrink(FL.create("potion.invisibility.long"                   , tIconPotion, "Stretched Invisible Brew"                , null, UT.Code.getRGBaArray(Potion.invisibility     .getLiquidColor()), 1, 1000, 300, ST.make(Items.potionitem, 1,  8270), IL.Bottle_Empty.get(1), 250).setLuminosity( 5)   , LH.Chat.CYAN  + "Invisibility (8:00)"     ,  0, 0.0F  ,   0, C+37,  0.00F, EnumAction.drink, T, F, F, Potion.invisibility     .id,9600, 0, 100);
		new FoodStatDrink(FL.create("potion.invisibility.splash"                 , tIconPotion, "Splash Invisible Brew"                   , null, UT.Code.getRGBaArray(Potion.invisibility     .getLiquidColor()), 1, 1000, 300, ST.make(Items.potionitem, 1, 16398), IL.Bottle_Empty.get(1), 250)                     , LH.Chat.CYAN  + "Invisibility (2:15)"     ,  0, 0.0F  ,   0, C+37,  0.00F, EnumAction.drink, T, F, F, Potion.invisibility     .id,2700, 0, 100);
		new FoodStatDrink(FL.create("potion.invisibility.long.splash"            , tIconPotion, "Stretched Splash Invisible Brew"         , null, UT.Code.getRGBaArray(Potion.invisibility     .getLiquidColor()), 1, 1000, 300, ST.make(Items.potionitem, 1, 16462), IL.Bottle_Empty.get(1), 250).setLuminosity( 5)   , LH.Chat.CYAN  + "Invisibility (6:00)"     ,  0, 0.0F  ,   0, C+37,  0.00F, EnumAction.drink, T, F, F, Potion.invisibility     .id,7200, 0, 100);
		
		
		// Those Potions are broken duplicates, which have been improved with Redstone or Glowstone despite the lack of said upgrade availability in the first place, so I need to at least add them for emptying the Bottles.
		FL.reg(FL.make("potion.damage"               , 250), ST.make(Items.potionitem, 1, 0b010000001001100), IL.Bottle_Empty.get(1));
		FL.reg(FL.make("potion.damage.splash"        , 250), ST.make(Items.potionitem, 1, 0b100000001001100), IL.Bottle_Empty.get(1));
		FL.reg(FL.make("potion.health"               , 250), ST.make(Items.potionitem, 1, 0b010000001000101), IL.Bottle_Empty.get(1));
		FL.reg(FL.make("potion.health.splash"        , 250), ST.make(Items.potionitem, 1, 0b100000001000101), IL.Bottle_Empty.get(1));
		FL.reg(FL.make("potion.jump"                 , 250), ST.make(Items.potionitem, 1, 0b010000001001011), IL.Bottle_Empty.get(1));
		FL.reg(FL.make("potion.jump.splash"          , 250), ST.make(Items.potionitem, 1, 0b100000001001011), IL.Bottle_Empty.get(1));
		FL.reg(FL.make("potion.fireresistance"       , 250), ST.make(Items.potionitem, 1, 0b010000000100011), IL.Bottle_Empty.get(1));
		FL.reg(FL.make("potion.fireresistance.splash", 250), ST.make(Items.potionitem, 1, 0b100000000100011), IL.Bottle_Empty.get(1));
		FL.reg(FL.make("potion.nightvision"          , 250), ST.make(Items.potionitem, 1, 0b010000000100110), IL.Bottle_Empty.get(1));
		FL.reg(FL.make("potion.nightvision.splash"   , 250), ST.make(Items.potionitem, 1, 0b100000000100110), IL.Bottle_Empty.get(1));
		FL.reg(FL.make("potion.weakness"             , 250), ST.make(Items.potionitem, 1, 0b010000000101000), IL.Bottle_Empty.get(1));
		FL.reg(FL.make("potion.weakness.splash"      , 250), ST.make(Items.potionitem, 1, 0b100000000101000), IL.Bottle_Empty.get(1));
		FL.reg(FL.make("potion.slowness"             , 250), ST.make(Items.potionitem, 1, 0b010000000101010), IL.Bottle_Empty.get(1));
		FL.reg(FL.make("potion.slowness.splash"      , 250), ST.make(Items.potionitem, 1, 0b100000000101010), IL.Bottle_Empty.get(1));
		FL.reg(FL.make("potion.waterbreathing"       , 250), ST.make(Items.potionitem, 1, 0b010000000101101), IL.Bottle_Empty.get(1));
		FL.reg(FL.make("potion.waterbreathing.splash", 250), ST.make(Items.potionitem, 1, 0b100000000101101), IL.Bottle_Empty.get(1));
		FL.reg(FL.make("potion.invisibility"         , 250), ST.make(Items.potionitem, 1, 0b010000000101110), IL.Bottle_Empty.get(1));
		FL.reg(FL.make("potion.invisibility.splash"  , 250), ST.make(Items.potionitem, 1, 0b100000000101110), IL.Bottle_Empty.get(1));
		
		
		// Et Futurum Lingering Potions
		new FoodStatDrink(FL.create("potion.damage.lingering"                    , tIconPotion, "Lingering Harming Brew"                  , null, UT.Code.getRGBaArray(Potion.harm             .getLiquidColor()), 1, 1000, 300, ST.make(MD.EtFu, "lingering_potion", 1,  8268), IL.Bottle_Empty.get(1), 250)                  , LH.Chat.RED   + "Instant Damage I"        ,  0, 0.0F  ,   0, C+37,  0.00F, EnumAction.drink, T, F, F, Potion.harm             .id,   1, 0, 100);
		new FoodStatDrink(FL.create("potion.damage.strong.lingering"             , tIconPotion, "Strong Lingering Harming Brew"           , null, UT.Code.getRGBaArray(Potion.harm             .getLiquidColor()), 1, 1000, 300, ST.make(MD.EtFu, "lingering_potion", 1,  8236), IL.Bottle_Empty.get(1), 250).setLuminosity(10), LH.Chat.RED   + "Instant Damage II"       ,  0, 0.0F  ,   0, C+37,  0.00F, EnumAction.drink, T, F, F, Potion.harm             .id,   1, 1, 100);
		new FoodStatDrink(FL.create("potion.health.lingering"                    , tIconPotion, "Lingering Healing Brew"                  , null, UT.Code.getRGBaArray(Potion.heal             .getLiquidColor()), 1, 1000, 300, ST.make(MD.EtFu, "lingering_potion", 1,  8261), IL.Bottle_Empty.get(1), 250)                  , LH.Chat.PINK  + "Instant Health I"        ,  0, 0.0F  ,   0, C+37,  0.00F, EnumAction.drink, T, F, F, Potion.heal             .id,   1, 0, 100);
		new FoodStatDrink(FL.create("potion.health.strong.lingering"             , tIconPotion, "Strong Lingering Healing Brew"           , null, UT.Code.getRGBaArray(Potion.heal             .getLiquidColor()), 1, 1000, 300, ST.make(MD.EtFu, "lingering_potion", 1,  8229), IL.Bottle_Empty.get(1), 250).setLuminosity(10), LH.Chat.PINK  + "Instant Health II"       ,  0, 0.0F  ,   0, C+37,  0.00F, EnumAction.drink, T, F, F, Potion.heal             .id,   1, 1, 100);
		new FoodStatDrink(FL.create("potion.jump.lingering"                      , tIconPotion, "Lingering Jumpy Brew"                    , null, UT.Code.getRGBaArray(Potion.jump             .getLiquidColor()), 1, 1000, 300, ST.make(MD.EtFu, "lingering_potion", 1,  8267), IL.Bottle_Empty.get(1), 250)                  , LH.Chat.GREEN + "Jump Boost I (0:45)"     ,  0, 0.0F  ,   0, C+37,  0.00F, EnumAction.drink, T, F, F, Potion.jump             .id, 900, 0, 100);
		new FoodStatDrink(FL.create("potion.jump.strong.lingering"               , tIconPotion, "Strong Lingering Jumpy Brew"             , null, UT.Code.getRGBaArray(Potion.jump             .getLiquidColor()), 1, 1000, 300, ST.make(MD.EtFu, "lingering_potion", 1,  8235), IL.Bottle_Empty.get(1), 250).setLuminosity(10), LH.Chat.GREEN + "Jump Boost II (0:22)"    ,  0, 0.0F  ,   0, C+37,  0.00F, EnumAction.drink, T, F, F, Potion.jump             .id, 450, 1, 100);
		new FoodStatDrink(FL.create("potion.speed.lingering"                     , tIconPotion, "Lingering Swiftness Brew"                , null, UT.Code.getRGBaArray(Potion.moveSpeed        .getLiquidColor()), 1, 1000, 300, ST.make(MD.EtFu, "lingering_potion", 1,  8194), IL.Bottle_Empty.get(1), 250)                  , LH.Chat.GREEN + "Speed I (0:45)"          ,  0, 0.0F  ,   0, C+37,  0.00F, EnumAction.drink, T, F, F, Potion.moveSpeed        .id, 900, 0, 100);
		new FoodStatDrink(FL.create("potion.speed.strong.lingering"              , tIconPotion, "Strong Lingering Swiftness Brew"         , null, UT.Code.getRGBaArray(Potion.moveSpeed        .getLiquidColor()), 1, 1000, 300, ST.make(MD.EtFu, "lingering_potion", 1,  8226), IL.Bottle_Empty.get(1), 250).setLuminosity(10), LH.Chat.GREEN + "Speed II (0:22)"         ,  0, 0.0F  ,   0, C+37,  0.00F, EnumAction.drink, T, F, F, Potion.moveSpeed        .id, 450, 1, 100);
		new FoodStatDrink(FL.create("potion.speed.long.lingering"                , tIconPotion, "Stretched Lingering Swiftness Brew"      , null, UT.Code.getRGBaArray(Potion.moveSpeed        .getLiquidColor()), 1, 1000, 300, ST.make(MD.EtFu, "lingering_potion", 1,  8258), IL.Bottle_Empty.get(1), 250).setLuminosity( 5), LH.Chat.GREEN + "Speed I (2:00)"          ,  0, 0.0F  ,   0, C+37,  0.00F, EnumAction.drink, T, F, F, Potion.moveSpeed        .id,2400, 0, 100);
		new FoodStatDrink(FL.create("potion.strength.lingering"                  , tIconPotion, "Lingering Strength Brew"                 , null, UT.Code.getRGBaArray(Potion.damageBoost      .getLiquidColor()), 1, 1000, 300, ST.make(MD.EtFu, "lingering_potion", 1,  8201), IL.Bottle_Empty.get(1), 250)                  , LH.Chat.GREEN + "Strength I (0:45)"       ,  0, 0.0F  ,   0, C+37,  0.00F, EnumAction.drink, T, F, F, Potion.damageBoost      .id, 900, 0, 100);
		new FoodStatDrink(FL.create("potion.strength.strong.lingering"           , tIconPotion, "Strong Lingering Strength Brew"          , null, UT.Code.getRGBaArray(Potion.damageBoost      .getLiquidColor()), 1, 1000, 300, ST.make(MD.EtFu, "lingering_potion", 1,  8233), IL.Bottle_Empty.get(1), 250).setLuminosity(10), LH.Chat.GREEN + "Strength II (0:22)"      ,  0, 0.0F  ,   0, C+37,  0.00F, EnumAction.drink, T, F, F, Potion.damageBoost      .id, 450, 1, 100);
		new FoodStatDrink(FL.create("potion.strength.long.lingering"             , tIconPotion, "Stretched Lingering Strength Brew"       , null, UT.Code.getRGBaArray(Potion.damageBoost      .getLiquidColor()), 1, 1000, 300, ST.make(MD.EtFu, "lingering_potion", 1,  8265), IL.Bottle_Empty.get(1), 250).setLuminosity( 5), LH.Chat.GREEN + "Strength I (2:00)"       ,  0, 0.0F  ,   0, C+37,  0.00F, EnumAction.drink, T, F, F, Potion.damageBoost      .id,2400, 0, 100);
		new FoodStatDrink(FL.create("potion.regen.lingering"                     , tIconPotion, "Lingering Regenerating Brew"             , null, UT.Code.getRGBaArray(Potion.regeneration     .getLiquidColor()), 1, 1000, 300, ST.make(MD.EtFu, "lingering_potion", 1,  8193), IL.Bottle_Empty.get(1), 250)                  , LH.Chat.PINK  + "Regeneration I (0:11)"   ,  0, 0.0F  ,   0, C+37,  0.00F, EnumAction.drink, T, F, F, Potion.regeneration     .id, 222, 0, 100);
		new FoodStatDrink(FL.create("potion.regen.strong.lingering"              , tIconPotion, "Strong Lingering Regenerating Brew"      , null, UT.Code.getRGBaArray(Potion.regeneration     .getLiquidColor()), 1, 1000, 300, ST.make(MD.EtFu, "lingering_potion", 1,  8225), IL.Bottle_Empty.get(1), 250).setLuminosity(10), LH.Chat.PINK  + "Regeneration II (0:05)"  ,  0, 0.0F  ,   0, C+37,  0.00F, EnumAction.drink, T, F, F, Potion.regeneration     .id, 111, 1, 100);
		new FoodStatDrink(FL.create("potion.regen.long.lingering"                , tIconPotion, "Stretched Lingering Regenerating Brew"   , null, UT.Code.getRGBaArray(Potion.regeneration     .getLiquidColor()), 1, 1000, 300, ST.make(MD.EtFu, "lingering_potion", 1,  8257), IL.Bottle_Empty.get(1), 250).setLuminosity( 5), LH.Chat.PINK  + "Regeneration I (0:30)"   ,  0, 0.0F  ,   0, C+37,  0.00F, EnumAction.drink, T, F, F, Potion.regeneration     .id, 600, 0, 100);
		new FoodStatDrink(FL.create("potion.poison.lingering"                    , tIconPotion, "Lingering Poisonous Brew"                , null, UT.Code.getRGBaArray(Potion.poison           .getLiquidColor()), 1, 1000, 300, ST.make(MD.EtFu, "lingering_potion", 1,  8196), IL.Bottle_Empty.get(1), 250)                  , LH.Chat.RED   + "Poison I (0:11)"         ,  0, 0.0F  ,   0, C+37,  0.00F, EnumAction.drink, T, F, F, Potion.poison           .id, 222, 0, 100);
		new FoodStatDrink(FL.create("potion.poison.strong.lingering"             , tIconPotion, "Strong Lingering Poisonous Brew"         , null, UT.Code.getRGBaArray(Potion.poison           .getLiquidColor()), 1, 1000, 300, ST.make(MD.EtFu, "lingering_potion", 1,  8228), IL.Bottle_Empty.get(1), 250).setLuminosity(10), LH.Chat.RED   + "Poison II (0:05)"        ,  0, 0.0F  ,   0, C+37,  0.00F, EnumAction.drink, T, F, F, Potion.poison           .id, 111, 1, 100);
		new FoodStatDrink(FL.create("potion.poison.long.lingering"               , tIconPotion, "Stretched Lingering Poisonous Brew"      , null, UT.Code.getRGBaArray(Potion.poison           .getLiquidColor()), 1, 1000, 300, ST.make(MD.EtFu, "lingering_potion", 1,  8260), IL.Bottle_Empty.get(1), 250).setLuminosity( 5), LH.Chat.RED   + "Poison I (0:30)"         ,  0, 0.0F  ,   0, C+37,  0.00F, EnumAction.drink, T, F, F, Potion.poison           .id, 600, 0, 100);
		new FoodStatDrink(FL.create("potion.fireresistance.lingering"            , tIconPotion, "Lingering Fire Resistant Brew"           , null, UT.Code.getRGBaArray(Potion.fireResistance   .getLiquidColor()), 1, 1000, 375, ST.make(MD.EtFu, "lingering_potion", 1,  8227), IL.Bottle_Empty.get(1), 250).setLuminosity(10), LH.Chat.BLUE  + "Fire Resistance (0:45)"  ,  0, 0.0F  ,   0, C+37,  0.00F, EnumAction.drink, T, F, F, Potion.fireResistance   .id, 900, 0, 100);
		new FoodStatDrink(FL.create("potion.fireresistance.long.lingering"       , tIconPotion, "Stretched Lingering Fire Resistant Brew" , null, UT.Code.getRGBaArray(Potion.fireResistance   .getLiquidColor()), 1, 1000, 375, ST.make(MD.EtFu, "lingering_potion", 1,  8259), IL.Bottle_Empty.get(1), 250).setLuminosity(15), LH.Chat.BLUE  + "Fire Resistance (2:00)"  ,  0, 0.0F  ,   0, C+37,  0.00F, EnumAction.drink, T, F, F, Potion.fireResistance   .id,2400, 0, 100);
		new FoodStatDrink(FL.create("potion.nightvision.lingering"               , tIconPotion, "Lingering Night Vision Brew"             , null, UT.Code.getRGBaArray(Potion.nightVision      .getLiquidColor()), 1, 1000, 300, ST.make(MD.EtFu, "lingering_potion", 1,  8230), IL.Bottle_Empty.get(1), 250)                  , LH.Chat.CYAN  + "Night Vision (0:45)"     ,  0, 0.0F  ,   0, C+37,  0.00F, EnumAction.drink, T, F, F, Potion.nightVision      .id, 900, 0, 100);
		new FoodStatDrink(FL.create("potion.nightvision.long.lingering"          , tIconPotion, "Stretched Lingering Night Vision Brew"   , null, UT.Code.getRGBaArray(Potion.nightVision      .getLiquidColor()), 1, 1000, 300, ST.make(MD.EtFu, "lingering_potion", 1,  8262), IL.Bottle_Empty.get(1), 250).setLuminosity( 5), LH.Chat.CYAN  + "Night Vision (2:00)"     ,  0, 0.0F  ,   0, C+37,  0.00F, EnumAction.drink, T, F, F, Potion.nightVision      .id,2400, 0, 100);
		new FoodStatDrink(FL.create("potion.weakness.lingering"                  , tIconPotion, "Lingering Weakening Brew"                , null, UT.Code.getRGBaArray(Potion.weakness         .getLiquidColor()), 1, 1000, 300, ST.make(MD.EtFu, "lingering_potion", 1,  8232), IL.Bottle_Empty.get(1), 250)                  , LH.Chat.DRED  + "Weakness (0:22)"         ,  0, 0.0F  ,   0, C+37,  0.00F, EnumAction.drink, T, F, F, Potion.weakness         .id, 450, 0, 100);
		new FoodStatDrink(FL.create("potion.weakness.long.lingering"             , tIconPotion, "Stretched Lingering Weakening Brew"      , null, UT.Code.getRGBaArray(Potion.weakness         .getLiquidColor()), 1, 1000, 300, ST.make(MD.EtFu, "lingering_potion", 1,  8264), IL.Bottle_Empty.get(1), 250).setLuminosity( 5), LH.Chat.DRED  + "Weakness (1:00)"         ,  0, 0.0F  ,   0, C+37,  0.00F, EnumAction.drink, T, F, F, Potion.weakness         .id,1200, 0, 100);
		new FoodStatDrink(FL.create("potion.slowness.lingering"                  , tIconPotion, "Lingering Lame Brew"                     , null, UT.Code.getRGBaArray(Potion.moveSlowdown     .getLiquidColor()), 1, 1000, 300, ST.make(MD.EtFu, "lingering_potion", 1,  8234), IL.Bottle_Empty.get(1), 250)                  , LH.Chat.DRED  + "Slowness (0:22)"         ,  0, 0.0F  ,   0, C+37,  0.00F, EnumAction.drink, T, F, F, Potion.moveSlowdown     .id, 450, 0, 100);
		new FoodStatDrink(FL.create("potion.slowness.long.lingering"             , tIconPotion, "Stretched Lingering Lame Brew"           , null, UT.Code.getRGBaArray(Potion.moveSlowdown     .getLiquidColor()), 1, 1000, 300, ST.make(MD.EtFu, "lingering_potion", 1,  8266), IL.Bottle_Empty.get(1), 250).setLuminosity( 5), LH.Chat.DRED  + "Slowness (1:00)"         ,  0, 0.0F  ,   0, C+37,  0.00F, EnumAction.drink, T, F, F, Potion.moveSlowdown     .id,1200, 0, 100);
		new FoodStatDrink(FL.create("potion.waterbreathing.lingering"            , tIconPotion, "Lingering Fishy Brew"                    , null, UT.Code.getRGBaArray(Potion.waterBreathing   .getLiquidColor()), 1, 1000, 300, ST.make(MD.EtFu, "lingering_potion", 1,  8237), IL.Bottle_Empty.get(1), 250)                  , LH.Chat.CYAN  + "Water Breathing (0:45)"  ,  0, 0.0F  ,   0, C+37,  0.00F, EnumAction.drink, T, F, F, Potion.waterBreathing   .id, 900, 0, 100);
		new FoodStatDrink(FL.create("potion.waterbreathing.long.lingering"       , tIconPotion, "Stretched Lingering Fishy Brew"          , null, UT.Code.getRGBaArray(Potion.waterBreathing   .getLiquidColor()), 1, 1000, 300, ST.make(MD.EtFu, "lingering_potion", 1,  8269), IL.Bottle_Empty.get(1), 250).setLuminosity( 5), LH.Chat.CYAN  + "Water Breathing (2:00)"  ,  0, 0.0F  ,   0, C+37,  0.00F, EnumAction.drink, T, F, F, Potion.waterBreathing   .id,2400, 0, 100);
		new FoodStatDrink(FL.create("potion.invisibility.lingering"              , tIconPotion, "Lingering Invisible Brew"                , null, UT.Code.getRGBaArray(Potion.invisibility     .getLiquidColor()), 1, 1000, 300, ST.make(MD.EtFu, "lingering_potion", 1,  8238), IL.Bottle_Empty.get(1), 250)                  , LH.Chat.CYAN  + "Invisibility (0:45)"     ,  0, 0.0F  ,   0, C+37,  0.00F, EnumAction.drink, T, F, F, Potion.invisibility     .id, 900, 0, 100);
		new FoodStatDrink(FL.create("potion.invisibility.long.lingering"         , tIconPotion, "Stretched Lingering Invisible Brew"      , null, UT.Code.getRGBaArray(Potion.invisibility     .getLiquidColor()), 1, 1000, 300, ST.make(MD.EtFu, "lingering_potion", 1,  8270), IL.Bottle_Empty.get(1), 250).setLuminosity( 5), LH.Chat.CYAN  + "Invisibility (2:00)"     ,  0, 0.0F  ,   0, C+37,  0.00F, EnumAction.drink, T, F, F, Potion.invisibility     .id,2400, 0, 100);
		
		
		
		
		
		
		
		
		
		new FoodStatDrink(FL.create("error"                                      , "Liquid Error"                            , null                  , 1, 1000,   0)                                                                                                , "Do not drink!"                                                   ,  0, 0.0F  ,   0,    0,  1.00F,999,999,999,999,999, EnumAction.drink, T, F, F, Potion.harm                     .id,9999,99, 999, Potion.blindness          .id,9999,99, 999, Potion.weakness           .id,9999,99, 999, Potion.hunger.id,9999,99, 999);
		
		new FoodStatDrink("water"                                                                                                                                                                                                                                   , "Regular H2O, remember to stay hydrated!"                         ,  0, 0.0F  ,  40, C+35,  0.50F,  0,  0,  0,  0,  0, EnumAction.drink, T, F, F);
		new FoodStatDrink(FL.create("riverwater"                                 , "Riverwater"                              , null                  , 1, 1000,   C)                                                                                                , "Fresh Riverwater"                                                ,  0, 0.0F  ,  40, C+35,  0.50F,  0,  0,  0,  0,  0, EnumAction.drink, T, F, F);
		new FoodStatDrink(FL.create("spectral_dew"                               , "Spectral Dew"                            , null                  , 1, 1000, 300)                                                                                                , "Ghostly Water"                                                   ,  0, 0.0F  ,  40, C+37,  0.50F,  0,  0,  0,  0,  0, EnumAction.drink, T, F, F);
		new FoodStatDrink("ic2distilledwater"                                                                                                                                                                                                                       , "Distilled H2O"                                                   ,  0, 0.0F  ,  40, C+35,  0.50F,  0,  0,  0,  0,  0, EnumAction.drink, T, F, F);
		new FoodStatDrink(FL.create("ice"                                        , "Near Frozen Water"                       , MT.Ice                , 1, 1000,   C)                                                                                                , "Almost frozen H2O"                                               ,  0, 0.0F  ,  40, C+30,  0.50F,  0,  0,  0,  0,  0, EnumAction.drink, T, F, F, Potion.moveSlowdown             .id, 400, 1,  40, Potion.digSlowdown        .id, 400, 1,  40, PotionsGT.ID_FROSTBITE       , 400, 1,  10);
		new FoodStatDrink("waterdirty"                                                                                                                                                                                                                              , "Dirty"                                                           ,  0, 0.0F  ,  10, C+37,  0.50F,  0,  0,  5,  0,  0, EnumAction.drink, F, F, F, Potion.hunger                   .id, 200, 1,  80, Potion.poison             .id, 200, 0,  30);
		new FoodStatDrink("seawater"                                                                                                                                                                                                                                , "Salty"                                                           ,  0, 0.0F  ,  10, C+35,  0.50F,  0,  0, 30,  0,  0, EnumAction.drink, F, F, F, Potion.hunger                   .id, 400, 2,  95, PotionsGT.ID_DEHYDRATION     , 400, 1, 100);
		new FoodStatDrink("grccore.saltwater"                                                                                                                                                                                                                       , "Salty"                                                           ,  0, 0.0F  ,  10, C+35,  0.50F,  0,  0, 30,  0,  0, EnumAction.drink, F, F, F, Potion.hunger                   .id, 400, 2,  95, PotionsGT.ID_DEHYDRATION     , 400, 1, 100);
		new FoodStatDrink("tropicswater"                                                                                                                                                                                                                            , "Tropical"                                                        ,  0, 0.0F  ,  10, C+37,  0.50F,  0,  0, 30,  0,  0, EnumAction.drink, F, F, F, Potion.hunger                   .id, 400, 2,  95, PotionsGT.ID_DEHYDRATION     , 400, 1, 100);
		new FoodStatDrink("saltwater"                                                                                                                                                                                                                               , "Saltier than the seven Seas"                                     ,  1, 0.0F  ,  10, C+35,  0.50F,  0,  0, 90,  0,  0, EnumAction.drink, F, F, F, Potion.hunger                   .id, 800, 2, 100, PotionsGT.ID_DEHYDRATION     , 800, 2, 100);
		new FoodStatDrink(FL.create("soda"                                       , "Soda"                                    , null                  , 1, 1000, 300)                                                                                                , "Simply carbonated Water"                                         ,  1, 0.1F  ,  50, C+35,  0.50F,  0,  0,  0,  0,  0, EnumAction.drink, F, F, F);
		new FoodStatDrink(FL.create("potion.mineralwater"                        , "Mineral Water"                           , null                  , 1, 1000, 300)                                                                                                , "Stay hydrated!"                                                  ,  1, 0.1F  ,  40, C+35,  0.50F,  0,  0,  0,  0,  0, EnumAction.drink, F, F, F, Potion.regeneration             .id, 100, 1,  10);
		new FoodStatDrink(FL.create("mineralsoda"                                , "Mineral Soda"                            , null                  , 1, 1000, 300)                                                                                                , "Stay hydrated!"                                                  ,  1, 0.2F  ,  50, C+35,  0.50F,  0,  0,  0,  0,  0, EnumAction.drink, F, F, F, Potion.regeneration             .id, 100, 1,  10);
		new FoodStatDrink(FL.create("watergeothermal"                            , "Hot Spring Water"                        , null                  , 1, 1000, 320)                                                                                                , "Fresh from the Geothermal Hot Spring!"                           ,  1, 0.1F  ,  40, C+40,  0.50F,  0,  0,  0,  0,  0, EnumAction.drink, F, F, F, Potion.regeneration             .id, 100, 1,  20);
		
		
		new FoodStatDrink(FL.create("juice"                                      , "Juice"                                   , null                  , 1, 1000, 300)                                                                                                , "From a Random Fruit"                                             ,  3, 0.4F  ,  20, C+37,  0.50F,  0,  0,  0, 20,  0, EnumAction.drink, F, F, F, Potion.hunger                   .id, 100, 1,  20);
		new FoodStatDrink(FL.create("strawberryjuice"                            , "Strawberry Juice"                        , null                  , 1, 1000, 300)                                                                                                , "Where is the Straw for that Berry Juice?"                        ,  6, 0.4F  ,  20, C+37,  0.50F,  0,  0,  0, 20,  0, EnumAction.drink, F, F, F, Potion.hunger                   .id, 100, 1,  10);
		new FoodStatDrink(FL.create("melonjuice"                                 , "Melon Juice"                             , null                  , 1, 1000, 300)                                                                                                , "Yoshis favourite Fruit Juice"                                    ,  2, 0.4F  ,  40, C+37,  0.50F,  0,  0,  0, 20,  0, EnumAction.drink, F, F, F, Potion.hunger                   .id, 100, 1,  20);
		new FoodStatDrink(FL.create("kiwijuice"                                  , "Kiwi Juice"                              , null                  , 1, 1000, 300)                                                                                                , "Made of little Birds!"                                           ,  4, 0.4F  ,  20, C+37,  0.50F,  0,  0,  0, 20,  0, EnumAction.drink, F, F, F, Potion.digSpeed                 .id,1200, 0,  60, PotionsGT.ID_CONDUCTIVE, 300, 0,  70);
		new FoodStatDrink(FL.create("persimmonjuice"                             , "Persimmon Juice"                         , null                  , 1, 1000, 300)                                                                                                , "Only one per Simon"                                              ,  3, 0.8F  ,  20, C+37,  0.50F,  0,  0,  0, 20,  0, EnumAction.drink, F, F, F, Potion.digSpeed                 .id,1200, 0,  60, PotionsGT.ID_CONDUCTIVE, 300, 0,  70);
		new FoodStatDrink(FL.create("currantjuice"                               , "Currant Juice"                           , null                  , 1, 1000, 300)                                                                                                , "Runs electric Currant"                                           ,  3, 0.4F  ,  30, C+37,  0.50F,  0,  0,  0, 20,  0, EnumAction.drink, F, F, F, Potion.damageBoost              .id, 200, 1,  25);
		new FoodStatDrink(FL.create("raspberryjuice"                             , "Raspberry Juice"                         , null                  , 1, 1000, 300)                                                                                                , "Made of tiny Computers!"                                         ,  3, 0.4F  ,  30, C+37,  0.50F,  0,  0,  0, 20,  0, EnumAction.drink, F, F, F, Potion.damageBoost              .id, 200, 1,  25);
		new FoodStatDrink(FL.create("blackberryjuice"                            , "Blackberry Juice"                        , null                  , 1, 1000, 300)                                                                                                , "Made of Smartphones!"                                            ,  3, 0.4F  ,  30, C+37,  0.50F,  0,  0,  0, 20,  0, EnumAction.drink, F, F, F, Potion.damageBoost              .id, 200, 1,  25);
		new FoodStatDrink(FL.create("blueberryjuice"                             , "Blueberry Juice"                         , null                  , 1, 1000, 300)                                                                                                , "Colors everything Blue"                                          ,  3, 0.4F  ,  30, C+37,  0.50F,  0,  0,  0, 20,  0, EnumAction.drink, F, F, F, Potion.damageBoost              .id, 200, 1,  25);
		new FoodStatDrink(FL.create("gooseberryjuice"                            , "Gooseberry Juice"                        , null                  , 1, 1000, 300)                                                                                                , "Made of real Geese!"                                             ,  3, 0.4F  ,  30, C+37,  0.50F,  0,  0,  0, 20,  0, EnumAction.drink, F, F, F, Potion.damageBoost              .id, 200, 1,  25);
		new FoodStatDrink(FL.create("binnie.juicecranberry"                      , "Cranberry Juice"                         , null                  , 1, 1000, 300)                                                                                                , "Made of real Cranes!"                                            ,  3, 0.4F  ,  30, C+37,  0.50F,  0,  0,  0, 20,  0, EnumAction.drink, F, F, F, Potion.damageBoost              .id, 200, 1,  25);
		new FoodStatDrink(FL.create("binnie.juiceelderberry"                     , "Elderberry Juice"                        , null                  , 1, 1000, 300)                                                                                                , "Made of elderly Berries!"                                        ,  3, 0.4F  ,  30, C+37,  0.50F,  0,  0,  0, 20,  0, EnumAction.drink, F, F, F, Potion.damageBoost              .id, 200, 1,  25);
		new FoodStatDrink(FL.create("hellderberryjuice"                          , "Hellderberry Juice"                      , null                  , 1, 1000, 300)                                                                                                , "Smells quite a bit"                                              ,  3, 0.4F  ,  30, C+37,  0.50F,  0,  0,  0, 20,  0, EnumAction.drink, F, F, F, Potion.damageBoost              .id, 200, 1,  25);
		new FoodStatDrink(FL.create("binnie.juicelemon"                          , "Lemon Juice"                             , null                  , 1, 1000, 300)                                                                                                , "Maybe adding Sugar will make it less sour"                       ,  3, 0.8F  ,  20, C+37,  0.50F,  0,  0,  0, 20,  0, EnumAction.drink, F, F, F, Potion.digSpeed                 .id,1200, 0,  60, PotionsGT.ID_CONDUCTIVE, 300, 0,  70);
		new FoodStatDrink(FL.create("binnie.juicepineapple"                      , "Ananas Juice"                            , null                  , 1, 1000, 300)                                                                                                , "Sponsored by Daniel Rustage!"                                    ,  3, 0.4F  ,  20, C+37,  0.50F,  0,  0,  0, 20,  0, EnumAction.drink, F, F, F, Potion.digSpeed                 .id,1200, 0,  60);
		new FoodStatDrink(FL.create("binnie.juiceorange"                         , "Orange Juice"                            , null                  , 1, 1000, 300)                                                                                                , "All 100% of it!"                                                 ,  3, 0.8F  ,  20, C+37,  0.50F,  0,  0,  0, 20,  0, EnumAction.drink, F, F, F, Potion.digSpeed                 .id,1200, 0,  60, PotionsGT.ID_CONDUCTIVE, 300, 0,  70);
		new FoodStatDrink(FL.create("binnie.juiceapricot"                        , "Apricot Juice"                           , null                  , 1, 1000, 300)                                                                                                , ""                                                                ,  3, 0.8F  ,  20, C+37,  0.50F,  0,  0,  0, 20,  0, EnumAction.drink, F, F, F, Potion.digSpeed                 .id,1200, 0,  60);
		new FoodStatDrink(FL.create("binnie.juicelime"                           , "Lime Juice"                              , null                  , 1, 1000, 300)                                                                                                , ""                                                                ,  3, 0.8F  ,  20, C+37,  0.50F,  0,  0,  0, 20,  0, EnumAction.drink, F, F, F, Potion.digSpeed                 .id,1200, 0,  60, PotionsGT.ID_CONDUCTIVE, 300, 0,  70);
		new FoodStatDrink(FL.create("binnie.juicepear"                           , "Pear Juice"                              , null                  , 1, 1000, 300)                                                                                                , ""                                                                ,  6, 0.4F  ,  20, C+37,  0.50F,  0,  0,  5, 20,  0, EnumAction.drink, F, F, F, Potion.hunger                   .id, 200, 0,  20);
		new FoodStatDrink(FL.create("binnie.juicecherry"                         , "Cherry Juice"                            , null                  , 1, 1000, 300)                                                                                                , ""                                                                ,  6, 0.4F  ,  20, C+37,  0.50F,  0,  0,  0, 20,  0, EnumAction.drink, F, F, F, Potion.hunger                   .id, 100, 1,  10);
		new FoodStatDrink(FL.create("binnie.juiceplum"                           , "Plum Juice"                              , null                  , 1, 1000, 300)                                                                                                , "May have a cleaning effect on your internals."                   ,  2, 0.4F  ,  40, C+37,  0.50F,  0,  0,  0, 20,  0, EnumAction.drink, F, F, F, Potion.hunger                   .id, 100, 1,  20);
		new FoodStatDrink(FL.create("binnie.juicepeach"                          , "Peach Juice"                             , null                  , 1, 1000, 300)                                                                                                , "The Princess is in another Castle"                               ,  2, 0.4F  ,  40, C+37,  0.50F,  0,  0,  0, 20,  0, EnumAction.drink, F, F, F, Potion.hunger                   .id, 100, 1,  20);
		new FoodStatDrink(FL.create("binnie.juicegrapefruit"                     , "Grapefruit Juice"                        , null                  , 1, 1000, 300)                                                                                                , "Not suitable for Diets!"                                         ,  3, 0.8F  ,  20, C+37,  0.50F,  0,  0,  5, 20,  0, EnumAction.drink, F, F, F, Potion.hunger                   .id, 200, 1,  60);
		new FoodStatDrink(FL.create("binnie.juicebanana"                         , "Banana Juice"                            , null                  , 1, 1000, 300)                                                                                                , "Big juiced Banana"                                               ,  6, 0.4F  ,  20, C+37,  0.50F,  0,  0,  0, 20,0,5, EnumAction.drink, F, F, F, Potion.hunger                   .id, 100, 1,  20);
		new FoodStatDrink(FL.create("grapejuice"                                 , "Green Grape Juice"                       , null                  , 1, 1000, 300)                                                                                                , "May have a cleaning effect on your internals."                   ,  4, 0.4F  ,  20, C+37,  0.50F,  0,  0,  5, 20,  0, EnumAction.drink, F, F, F, Potion.hunger                   .id, 200, 1,  60);
		new FoodStatDrink(FL.create("grc.grapewine0"                             , "Purple Grape Juice"                      , null                  , 1, 1000, 300)                                                                                                , "May have a cleaning effect on your internals."                   ,  4, 0.4F  ,  20, C+37,  0.50F,  0,  0,  5, 20,  0, EnumAction.drink, F, F, F, Potion.hunger                   .id, 200, 1,  60);
		new FoodStatDrink(FL.create("binnie.juiceredgrape"                       , "Red Grape Juice"                         , null                  , 1, 1000, 300)                                                                                                , "May have a cleaning effect on your internals."                   ,  4, 0.4F  ,  20, C+37,  0.50F,  0,  0,  5, 20,  0, EnumAction.drink, F, F, F, Potion.hunger                   .id, 200, 1,  60);
		new FoodStatDrink(FL.create("binnie.juicewhitegrape"                     , "White Grape Juice"                       , null                  , 1, 1000, 300)                                                                                                , "May have a cleaning effect on your internals."                   ,  4, 0.4F  ,  20, C+37,  0.50F,  0,  0,  5, 20,  0, EnumAction.drink, F, F, F, Potion.hunger                   .id, 200, 1,  60);
		new FoodStatDrink(FL.create("binnie.juiceapple"                          , "Apple Juice"                             , null                  , 1, 1000, 300)                                                                                                , "Made of the Apples from our best Oak Farms"                      ,  6, 0.4F  ,  20, C+37,  0.50F,  0,  0,  5, 20,  0, EnumAction.drink, F, F, F, Potion.hunger                   .id, 200, 0,  20);
		new FoodStatDrink(FL.create("grc.applecider0"                            , "Apple Juice"                             , null                  , 1, 1000, 300)                                                                                                , "Made of the Apples from our best Oak Farms"                      ,  6, 0.4F  ,  20, C+37,  0.50F,  0,  0,  5, 20,  0, EnumAction.drink, F, F, F, Potion.hunger                   .id, 200, 0,  20);
		new FoodStatDrink(FL.create("figjuice"                                   , "Fig Juice"                               , null                  , 1, 1000, 300)                                                                                                , ""                                                                ,  2, 0.4F  ,  40, C+37,  0.50F,  0,  0,  5, 15,  0, EnumAction.drink, F, F, F, Potion.hunger                   .id, 100, 1,  20);
		new FoodStatDrink(FL.create("pomegranatejuice"                           , "Pomegranate Juice"                       , null                  , 1, 1000, 300)                                                                                                , ""                                                                ,  2, 0.4F  ,  40, C+37,  0.50F,  0,  0,  5, 15,  0, EnumAction.drink, F, F, F, Potion.hunger                   .id, 100, 1,  20);
		new FoodStatDrink(FL.create("mangojuice"                                 , "Mango Juice"                             , null                  , 1, 1000, 300)                                                                                                , ""                                                                ,  3, 0.4F  ,  40, C+37,  0.50F,  0,  0,  0, 20,  0, EnumAction.drink, F, F, F, Potion.hunger                   .id, 100, 1,  20);
		new FoodStatDrink(FL.create("starfruitjuice"                             , "Starfruit Juice"                         , null                  , 1, 1000, 300)                                                                                                , ""                                                                ,  3, 0.4F  ,  40, C+37,  0.50F,  0,  0,  0, 20,  0, EnumAction.drink, F, F, F, Potion.hunger                   .id, 100, 1,  20);
		new FoodStatDrink(FL.create("papayajuice"                                , "Papaya Juice"                            , null                  , 1, 1000, 300)                                                                                                , ""                                                                ,  3, 0.4F  ,  40, C+37,  0.50F,  0,  0,  0, 20,  0, EnumAction.drink, F, F, F, Potion.hunger                   .id, 100, 1,  20);
		new FoodStatDrink(FL.create("coconutmilk"                                , "Coconut Milk"                            , null                  , 1, 1000, 300)                                                                                                , ""                                                                ,  6, 0.8F  ,  40, C+37,  0.50F,  0,  0,  0, 20,  0, EnumAction.drink, F, F, F, Potion.damageBoost              .id, 200, 1,  25);
		
		new FoodStatDrink(FL.create("fruitsmoothie"                              , "Froot Smoothie"                          , null                  , 1, 1000,   C)                                                                                                , ""                                                                ,  2, 0.2F  ,  20, C+35,  0.50F,  0,  0,  0, 20,  0, EnumAction.drink, F, F, F, Potion.hunger                   .id, 100, 1,  20);
		new FoodStatDrink(FL.create("strawberrysmoothie"                         , "Strawberry Smoothie"                     , null                  , 1, 1000,   C)                                                                                                , ""                                                                ,  4, 0.2F  ,  20, C+35,  0.50F,  0,  0,  0, 20,  0, EnumAction.drink, F, F, F, Potion.hunger                   .id, 100, 1,  10);
		new FoodStatDrink(FL.create("melonsmoothie"                              , "Melon Smoothie"                          , null                  , 1, 1000,   C)                                                                                                , ""                                                                ,  1, 0.2F  ,  40, C+35,  0.50F,  0,  0,  0, 20,  0, EnumAction.drink, F, F, F, Potion.hunger                   .id, 100, 1,  20);
		new FoodStatDrink(FL.create("kiwismoothie"                               , "Kiwi Smoothie"                           , null                  , 1, 1000,   C)                                                                                                , ""                                                                ,  3, 0.2F  ,  20, C+35,  0.50F,  0,  0,  0, 20,  0, EnumAction.drink, F, F, F, Potion.digSpeed                 .id,1200, 0,  60, PotionsGT.ID_CONDUCTIVE, 300, 0,  70);
		new FoodStatDrink(FL.create("currantsmoothie"                            , "Currant Smoothie"                        , null                  , 1, 1000,   C)                                                                                                , ""                                                                ,  2, 0.2F  ,  30, C+35,  0.50F,  0,  0,  0, 20,  0, EnumAction.drink, F, F, F, Potion.damageBoost              .id, 200, 1,  25);
		new FoodStatDrink(FL.create("raspberrysmoothie"                          , "Raspberry Smoothie"                      , null                  , 1, 1000,   C)                                                                                                , ""                                                                ,  2, 0.2F  ,  30, C+35,  0.50F,  0,  0,  0, 20,  0, EnumAction.drink, F, F, F, Potion.damageBoost              .id, 200, 1,  25);
		new FoodStatDrink(FL.create("blackberrysmoothie"                         , "Blackberry Smoothie"                     , null                  , 1, 1000,   C)                                                                                                , ""                                                                ,  2, 0.2F  ,  30, C+35,  0.50F,  0,  0,  0, 20,  0, EnumAction.drink, F, F, F, Potion.damageBoost              .id, 200, 1,  25);
		new FoodStatDrink(FL.create("blueberrysmoothie"                          , "Blueberry Smoothie"                      , null                  , 1, 1000,   C)                                                                                                , ""                                                                ,  2, 0.2F  ,  30, C+35,  0.50F,  0,  0,  0, 20,  0, EnumAction.drink, F, F, F, Potion.damageBoost              .id, 200, 1,  25);
		new FoodStatDrink(FL.create("gooseberrysmoothie"                         , "Gooseberry Smoothie"                     , null                  , 1, 1000,   C)                                                                                                , ""                                                                ,  2, 0.2F  ,  30, C+35,  0.50F,  0,  0,  0, 20,  0, EnumAction.drink, F, F, F, Potion.damageBoost              .id, 200, 1,  25);
		new FoodStatDrink(FL.create("cranberrysmoothie"                          , "Cranberry Smoothie"                      , null                  , 1, 1000,   C)                                                                                                , ""                                                                ,  2, 0.2F  ,  30, C+35,  0.50F,  0,  0,  0, 20,  0, EnumAction.drink, F, F, F, Potion.damageBoost              .id, 200, 1,  25);
		new FoodStatDrink(FL.create("elderberrysmoothie"                         , "Elderberry Smoothie"                     , null                  , 1, 1000,   C)                                                                                                , ""                                                                ,  2, 0.2F  ,  30, C+35,  0.50F,  0,  0,  0, 20,  0, EnumAction.drink, F, F, F, Potion.damageBoost              .id, 200, 1,  25);
		new FoodStatDrink(FL.create("lemonsmoothie"                              , "Lemon Smoothie"                          , null                  , 1, 1000,   C)                                                                                                , ""                                                                ,  2, 0.4F  ,  20, C+35,  0.50F,  0,  0,  0, 20,  0, EnumAction.drink, F, F, F, Potion.digSpeed                 .id,1200, 0,  60, PotionsGT.ID_CONDUCTIVE, 300, 0,  70);
		new FoodStatDrink(FL.create("pineapplesmoothie"                          , "Ananas Smoothie"                         , null                  , 1, 1000,   C)                                                                                                , ""                                                                ,  2, 0.2F  ,  20, C+35,  0.50F,  0,  0,  0, 20,  0, EnumAction.drink, F, F, F, Potion.digSpeed                 .id,1200, 0,  60);
		new FoodStatDrink(FL.create("orangesmoothie"                             , "Orange Smoothie"                         , null                  , 1, 1000,   C)                                                                                                , ""                                                                ,  2, 0.4F  ,  20, C+35,  0.50F,  0,  0,  0, 20,  0, EnumAction.drink, F, F, F, Potion.digSpeed                 .id,1200, 0,  60, PotionsGT.ID_CONDUCTIVE, 300, 0,  70);
		new FoodStatDrink(FL.create("persimmonsmoothie"                          , "Persimmon Smoothie"                      , null                  , 1, 1000,   C)                                                                                                , ""                                                                ,  2, 0.4F  ,  20, C+35,  0.50F,  0,  0,  0, 20,  0, EnumAction.drink, F, F, F, Potion.digSpeed                 .id,1200, 0,  60, PotionsGT.ID_CONDUCTIVE, 300, 0,  70);
		new FoodStatDrink(FL.create("apricotsmoothie"                            , "Apricot Smoothie"                        , null                  , 1, 1000,   C)                                                                                                , ""                                                                ,  2, 0.4F  ,  20, C+35,  0.50F,  0,  0,  0, 20,  0, EnumAction.drink, F, F, F, Potion.digSpeed                 .id,1200, 0,  60);
		new FoodStatDrink(FL.create("limesmoothie"                               , "Lime Smoothie"                           , null                  , 1, 1000,   C)                                                                                                , ""                                                                ,  2, 0.4F  ,  20, C+35,  0.50F,  0,  0,  0, 20,  0, EnumAction.drink, F, F, F, Potion.digSpeed                 .id,1200, 0,  60, PotionsGT.ID_CONDUCTIVE, 300, 0,  70);
		new FoodStatDrink(FL.create("pearsmoothie"                               , "Pear Smoothie"                           , null                  , 1, 1000,   C)                                                                                                , ""                                                                ,  4, 0.2F  ,  20, C+35,  0.50F,  0,  0,  5, 20,  0, EnumAction.drink, F, F, F, Potion.hunger                   .id, 200, 0,  20);
		new FoodStatDrink(FL.create("cherrysmoothie"                             , "Cherry Smoothie"                         , null                  , 1, 1000,   C)                                                                                                , ""                                                                ,  4, 0.2F  ,  20, C+35,  0.50F,  0,  0,  0, 20,  0, EnumAction.drink, F, F, F, Potion.hunger                   .id, 100, 1,  10);
		new FoodStatDrink(FL.create("plumsmoothie"                               , "Plum Smoothie"                           , null                  , 1, 1000,   C)                                                                                                , ""                                                                ,  1, 0.2F  ,  40, C+35,  0.50F,  0,  0,  0, 20,  0, EnumAction.drink, F, F, F, Potion.hunger                   .id, 100, 1,  20);
		new FoodStatDrink(FL.create("peachsmoothie"                              , "Peach Smoothie"                          , null                  , 1, 1000,   C)                                                                                                , ""                                                                ,  1, 0.2F  ,  40, C+35,  0.50F,  0,  0,  0, 20,  0, EnumAction.drink, F, F, F, Potion.hunger                   .id, 100, 1,  20);
		new FoodStatDrink(FL.create("grapefruitsmoothie"                         , "Grapefruit Smoothie"                     , null                  , 1, 1000,   C)                                                                                                , ""                                                                ,  2, 0.4F  ,  20, C+35,  0.50F,  0,  0,  5, 20,  0, EnumAction.drink, F, F, F, Potion.hunger                   .id, 200, 1,  60);
		new FoodStatDrink(FL.create("bananasmoothie"                             , "Banana Smoothie"                         , null                  , 1, 1000,   C)                                                                                                , ""                                                                ,  4, 0.2F  ,  20, C+35,  0.50F,  0,  0,  0, 20,0,5, EnumAction.drink, F, F, F, Potion.hunger                   .id, 100, 1,  20);
		new FoodStatDrink(FL.create("redgrapesmoothie"                           , "Grape Smoothie"                          , null                  , 1, 1000,   C)                                                                                                , ""                                                                ,  4, 0.2F  ,  20, C+35,  0.50F,  0,  0,  5, 20,  0, EnumAction.drink, F, F, F, Potion.hunger                   .id, 200, 1,  60);
		new FoodStatDrink(FL.create("whitegrapesmoothie"                         , "Grape Smoothie"                          , null                  , 1, 1000,   C)                                                                                                , ""                                                                ,  4, 0.2F  ,  20, C+35,  0.50F,  0,  0,  5, 20,  0, EnumAction.drink, F, F, F, Potion.hunger                   .id, 200, 1,  60);
		new FoodStatDrink(FL.create("purplegrapesmoothie"                        , "Grape Smoothie"                          , null                  , 1, 1000,   C)                                                                                                , ""                                                                ,  4, 0.2F  ,  20, C+35,  0.50F,  0,  0,  5, 20,  0, EnumAction.drink, F, F, F, Potion.hunger                   .id, 200, 1,  60);
		new FoodStatDrink(FL.create("grapesmoothie"                              , "Grape Smoothie"                          , null                  , 1, 1000,   C)                                                                                                , ""                                                                ,  4, 0.2F  ,  20, C+35,  0.50F,  0,  0,  5, 20,  0, EnumAction.drink, F, F, F, Potion.hunger                   .id, 200, 1,  60);
		new FoodStatDrink(FL.create("applesmoothie"                              , "Apple Smoothie"                          , null                  , 1, 1000,   C)                                                                                                , ""                                                                ,  4, 0.2F  ,  20, C+35,  0.50F,  0,  0,  5, 20,  0, EnumAction.drink, F, F, F, Potion.hunger                   .id, 200, 0,  20);
		new FoodStatDrink(FL.create("figsmoothie"                                , "Fig Smoothie"                            , null                  , 1, 1000,   C)                                                                                                , ""                                                                ,  1, 0.2F  ,  40, C+35,  0.50F,  0,  0,  5, 15,  0, EnumAction.drink, F, F, F, Potion.hunger                   .id, 100, 1,  20);
		new FoodStatDrink(FL.create("pomegranatesmoothie"                        , "Pomegranate Smoothie"                    , null                  , 1, 1000,   C)                                                                                                , ""                                                                ,  1, 0.2F  ,  40, C+35,  0.50F,  0,  0,  5, 15,  0, EnumAction.drink, F, F, F, Potion.hunger                   .id, 100, 1,  20);
		new FoodStatDrink(FL.create("mangosmoothie"                              , "Mango Smoothie"                          , null                  , 1, 1000,   C)                                                                                                , ""                                                                ,  2, 0.2F  ,  40, C+35,  0.50F,  0,  0,  0, 20,  0, EnumAction.drink, F, F, F, Potion.hunger                   .id, 100, 1,  20);
		new FoodStatDrink(FL.create("starfruitsmoothie"                          , "Starfruit Smoothie"                      , null                  , 1, 1000,   C)                                                                                                , ""                                                                ,  2, 0.2F  ,  40, C+35,  0.50F,  0,  0,  0, 20,  0, EnumAction.drink, F, F, F, Potion.hunger                   .id, 100, 1,  20);
		new FoodStatDrink(FL.create("papayasmoothie"                             , "Papaya Smoothie"                         , null                  , 1, 1000,   C)                                                                                                , ""                                                                ,  2, 0.2F  ,  40, C+35,  0.50F,  0,  0,  0, 20,  0, EnumAction.drink, F, F, F, Potion.hunger                   .id, 100, 1,  20);
		new FoodStatDrink(FL.create("coconutsmoothie"                            , "Coconut Smoothie"                        , null                  , 1, 1000,   C)                                                                                                , ""                                                                ,  4, 0.4F  ,  40, C+35,  0.50F,  0,  0,  0, 20,  0, EnumAction.drink, F, F, F, Potion.damageBoost              .id, 200, 1,  25);
		
		
		new FoodStatDrink(FL.create("binnie.juicetomato"                         , "Tomato Juice"                            , null                  , 1, 1000, 300)                                                                                                , "Used for Ketchup and Tomato Sauces"                              ,  1, 0.2F  ,  40, C+37,  0.50F,  0,  0,  0, 20,  0, EnumAction.drink, F, F, F, Potion.heal                     .id,   1, 0,  30);
		new FoodStatDrink(FL.create("binnie.juicecarrot"                         , "Carrot Juice"                            , null                  , 1, 1000, 300)                                                                                                , "Not scientifically proven to improve eyesight!"                  ,  1, 0.2F  ,  40, C+37,  0.50F,  0,  0,  0, 20,  0, EnumAction.drink, F, F, F, Potion.nightVision              .id, 400, 0,  30);
		new FoodStatDrink(FL.create("beetjuice"                                  , "Beet Juice"                              , null                  , 1, 1000, 300)                                                                                                , "Beets me."                                                       ,  1, 0.2F  ,  40, C+37,  0.50F,  0,  0,  0, 40,  0, EnumAction.drink, F, F, F, Potion.damageBoost              .id, 200, 1,  25);
		new FoodStatDrink(FL.create("pumpkinjuice"                               , "Pumpkin Juice"                           , null                  , 1, 1000, 300)                                                                                                , "Perfect for Halloween"                                           ,  1, 0.2F  ,  40, C+37,  0.50F,  0,  0,  0, 20,  0, EnumAction.drink, F, F, F);
		new FoodStatDrink(FL.create("potatojuice"                                , "Potato Juice"                            , null                  , 1, 1000, 300)                                                                                                , "Ever seen Potato Juice in stores? No? That has a reason."        ,  3, 0.3F  ,  20, C+37,  0.50F,  0,  0,  0, 20,  0, EnumAction.drink, F, F, F);
		new FoodStatDrink(FL.create("hopsmash"                                   , "Hops Mash"                               , null                  , 1, 1000, 300)                                                                                                , "Every Beer has a start"                                          ,  1, 0.1F  ,  15, C+37,  0.50F,  0,  0,  0,  0,  0, EnumAction.drink, F, F, F);
		new FoodStatDrink(FL.create("wheathopsmash"                              , "Wheat-Hops Mash"                         , null                  , 1, 1000, 300)                                                                                                , "Also known as 'Duff-Lite'"                                       ,  1, 0.1F  ,  15, C+37,  0.50F,  0,  0,  0,  0,  0, EnumAction.drink, F, F, F);
		new FoodStatDrink(FL.create("binnie.mashwheat"                           , "Wheat Mash"                              , null                  , 1, 1000, 300)                                                                                                , "Is this liquefied Bread or what?"                                ,  2, 0.1F  ,  15, C+37,  0.50F,  0,  0,  0,  0,  0, EnumAction.drink, F, F, F);
		new FoodStatDrink(FL.create("binnie.mashcorn"                            , "Corn Mash"                               , null                  , 1, 1000, 300)                                                                                                , ""                                                                ,  2, 0.1F  ,  15, C+37,  0.50F,  0,  0,  0,  0,  0, EnumAction.drink, F, F, F);
		new FoodStatDrink(FL.create("binnie.mashgrain"                           , "Grain Mash"                              , null                  , 1, 1000, 300)                                                                                                , ""                                                                ,  2, 0.1F  ,  15, C+37,  0.50F,  0,  0,  0,  0,  0, EnumAction.drink, F, F, F);
		new FoodStatDrink(FL.create("binnie.mashrye"                             , "Rye Mash"                                , null                  , 1, 1000, 300)                                                                                                , ""                                                                ,  2, 0.1F  ,  15, C+37,  0.50F,  0,  0,  0,  0,  0, EnumAction.drink, F, F, F);
		new FoodStatDrink(FL.create("ricewater"                                  , "Ricewater"                               , null                  , 1, 1000, 300)                                                                                                , ""                                                                ,  1, 0.1F  ,  20, C+37,  0.50F,  0,  0,  0, 10,  0, EnumAction.drink, F, F, F);
		new FoodStatDrink(FL.create("reedwater"                                  , "Reedwater"                               , null                  , 1, 1000, 300)                                                                                                , "I guess this tastes better when fermented"                       ,  1, 0.1F  ,  20, C+37,  0.50F,  0,  0,  0,  0,  0, EnumAction.drink, F, F, F);
		new FoodStatDrink(FL.create("cactuswater"                                , "Cactuswater"                             , null                  , 1, 1000, 300)                                                                                                , ""                                                                ,  1, 0.1F  ,  10, C+37,  0.50F,  0,  0, 40,  0,  0, EnumAction.drink, F, F, F, Potion.poison                   .id, 100, 0,  90);
		new FoodStatDrink(FL.create("maplesap"                                   , "Maple Sap"                               , null                  , 1, 1000, 300)                                                                                                , "May or may not be Canadian"                                      ,  3, 0.2F  ,  20, C+37,  0.50F,  0,  0,  0, 20,  0, EnumAction.drink, F, F, F, Potion.hunger                   .id, 300, 1,  50, PotionsGT.ID_STICKY, 300, 0, 30);
		new FoodStatDrink(FL.create("rainbowsap"                                 , "Rainbow Sap"                             , null                  , 1, 1000, 300)                                                                                                , "Friendship renews your Power! Or was it Magic? Yeah just Magic." ,  5, 0.5F  ,  30, C+37,  0.75F,  0,  0,  0, 20,  0, EnumAction.drink, F, F, F, Potion.regeneration             .id,  60, 4, 100, PotionsGT.ID_STICKY, 300, 0, 30, Potion.digSpeed.id, 900, 2, 100).setMilk();
		
		
		
		new FoodStatDrink("binnie.juice"            /* Yep, the Fruit Wine has this internal name */                                                                                                                                                                , "What Fruits is this made of?!"                                   ,  2, 0.2F  ,  10, C+37,  0.50F, 30,  0,  0, 10,  0, EnumAction.drink, F, F, F, Potion.heal                     .id,   1, 0,  60);
		new FoodStatDrink("binnie.wineagave"                                                                                                                                                                                                                        , ""                                                                ,  2, 0.2F  ,  10, C+37,  0.50F, 30,  0,  0, 10,  0, EnumAction.drink, F, F, F, Potion.heal                     .id,   1, 0,  60);
		new FoodStatDrink("binnie.wineapricot"                                                                                                                                                                                                                      , ""                                                                ,  2, 0.2F  ,  10, C+37,  0.50F, 30,  0,  0, 10,  0, EnumAction.drink, F, F, F, Potion.heal                     .id,   1, 0,  60);
		new FoodStatDrink("binnie.winebanana"                                                                                                                                                                                                                       , ""                                                                ,  2, 0.2F  ,  10, C+37,  0.50F, 30,  0,  0, 10,0,5, EnumAction.drink, F, F, F, Potion.heal                     .id,   1, 0,  60);
		new FoodStatDrink("binnie.winecarrot"                                                                                                                                                                                                                       , ""                                                                ,  2, 0.2F  ,  10, C+37,  0.50F, 30,  0,  0, 10,  0, EnumAction.drink, F, F, F, Potion.heal                     .id,   1, 0,  60);
		new FoodStatDrink("binnie.winecherry"                                                                                                                                                                                                                       , ""                                                                ,  2, 0.2F  ,  10, C+37,  0.50F, 30,  0,  0, 10,  0, EnumAction.drink, F, F, F, Potion.heal                     .id,   1, 0,  60);
		new FoodStatDrink("binnie.winecitrus"                                                                                                                                                                                                                       , ""                                                                ,  2, 0.2F  ,  10, C+37,  0.50F, 30,  0,  0, 10,  0, EnumAction.drink, F, F, F, Potion.heal                     .id,   1, 0,  60);
		new FoodStatDrink("binnie.winecranberry"                                                                                                                                                                                                                    , ""                                                                ,  2, 0.2F  ,  10, C+37,  0.50F, 30,  0,  0, 10,  0, EnumAction.drink, F, F, F, Potion.heal                     .id,   1, 0,  60);
		new FoodStatDrink("binnie.wineelderberry"                                                                                                                                                                                                                   , ""                                                                ,  2, 0.2F  ,  10, C+37,  0.50F, 30,  0,  0, 10,  0, EnumAction.drink, F, F, F, Potion.heal                     .id,   1, 0,  60);
		new FoodStatDrink("binnie.wineplum"                                                                                                                                                                                                                         , ""                                                                ,  2, 0.2F  ,  10, C+37,  0.50F, 30,  0,  0, 10,  0, EnumAction.drink, F, F, F, Potion.heal                     .id,   1, 0,  60);
		new FoodStatDrink("binnie.winesparkling"                                                                                                                                                                                                                    , ""                                                                ,  2, 0.2F  ,  10, C+37,  0.50F, 30,  0,  0, 10,  0, EnumAction.drink, F, F, F, Potion.heal                     .id,   1, 0,  60);
		new FoodStatDrink("binnie.winetomato"                                                                                                                                                                                                                       , ""                                                                ,  2, 0.2F  ,  10, C+37,  0.50F, 30,  0,  0, 10,  0, EnumAction.drink, F, F, F, Potion.heal                     .id,   1, 0,  60);
		new FoodStatDrink("binnie.winefortified"                                                                                                                                                                                                                    , ""                                                                ,  3, 0.4F  ,  10, C+37,  0.50F, 60,  0,  0, 20,  0, EnumAction.drink, F, F, F, Potion.heal                     .id,   1, 1,  90);
		new FoodStatDrink(FL.create("wine"                                       , "Wine"                                    , null                  , 1, 1000, 300)                                                                                                , "Exquisite"                                                       ,  2, 0.2F  ,  10, C+37,  0.50F, 30,  0,  0, 10,  0, EnumAction.drink, F, F, F, Potion.heal                     .id,   1, 0,  60);
		new FoodStatDrink(FL.create("ricardosanchez"                             , "Ricardo Sanchez"                         , null                  , 1, 1000, 300)                                                                                                , "Wubalubadubdub"                                                  ,  2, 0.2F  ,  10, C+37,  0.50F, 30,  0,  0, 10,  0, EnumAction.drink, F, F, F, Potion.heal                     .id,   1, 0,  60);
		new FoodStatDrink(FL.create("binnie.winered"                             , "Red Wine"                                , null                  , 1, 1000, 300)                                                                                                , "Exquisite"                                                       ,  2, 0.2F  ,  10, C+37,  0.50F, 30,  0,  0, 10,  0, EnumAction.drink, F, F, F, Potion.heal                     .id,   1, 0,  60);
		new FoodStatDrink(FL.create("binnie.winewhite"                           , "White Wine"                              , null                  , 1, 1000, 300)                                                                                                , "Exquisite"                                                       ,  2, 0.2F  ,  10, C+37,  0.50F, 30,  0,  0, 10,  0, EnumAction.drink, F, F, F, Potion.heal                     .id,   1, 0,  60);
		new FoodStatDrink(FL.create("limoncello"                                 , "Limoncello"                              , null                  , 1, 1000, 300, FluidsGT.SIMPLE, FluidsGT.FOOD, FluidsGT.ALCOHOLIC, FluidsGT.WINE)                             , "An alcoholic Drink which tastes like Lemons"                     ,  2, 0.4F  ,  10, C+37,  0.50F, 30,  0,  0, 10,  0, EnumAction.drink, F, F, F, Potion.digSpeed                 .id,1200, 0,  90, PotionsGT.ID_CONDUCTIVE, 300, 0,  70);
		new FoodStatDrink(FL.create("potion.sake"                                , "Sake"                                    , null                  , 1, 1000, 300, FluidsGT.SIMPLE, FluidsGT.FOOD, FluidsGT.ALCOHOLIC, FluidsGT.WINE)                             , "Rice Wine"                                                       ,  4, 0.4F  ,  10, C+37,  0.50F, 30,  0,  0, 10,  0, EnumAction.drink, F, F, F, Potion.damageBoost              .id, 300, 1,  60);
		
		new FoodStatDrink("binnie.beerale"                                                                                                                                                                                                                          , ""                                                                ,  6, 0.4F  ,  10, C+35,  0.50F, 30,  0,  0,  0,  0, EnumAction.drink, F, F, F, Potion.digSpeed                 .id, 400, 2,  60);
		new FoodStatDrink("binnie.beercorn"                                                                                                                                                                                                                         , ""                                                                ,  6, 0.4F  ,  10, C+35,  0.50F, 30,  0,  0,  0,  0, EnumAction.drink, F, F, F, Potion.digSpeed                 .id, 400, 2,  60);
		new FoodStatDrink("binnie.beerrye"                                                                                                                                                                                                                          , ""                                                                ,  6, 0.4F  ,  10, C+35,  0.50F, 30,  0,  0,  0,  0, EnumAction.drink, F, F, F, Potion.digSpeed                 .id, 400, 2,  60);
		new FoodStatDrink("binnie.beerstout"                                                                                                                                                                                                                        , ""                                                                ,  6, 0.4F  ,  10, C+35,  0.50F, 30,  0,  0,  0,  0, EnumAction.drink, F, F, F, Potion.digSpeed                 .id, 400, 2,  60);
		new FoodStatDrink("binnie.beerwheat"                                                                                                                                                                                                                        , ""                                                                ,  6, 0.4F  ,  10, C+35,  0.50F, 30,  0,  0,  0,  0, EnumAction.drink, F, F, F, Potion.digSpeed                 .id, 400, 2,  60);
		new FoodStatDrink("binnie.beerlager"                                                                                                                                                                                                                        , ""                                                                ,  4, 0.4F  ,  10, C+35,  0.50F, 40,  0,  0,  0,  0, EnumAction.drink, F, F, F, Potion.damageBoost              .id, 300, 1,  60);
		new FoodStatDrink(FL.create("beer"                                       , "Beer"                                    , null                  , 1, 1000, 275, FluidsGT.SIMPLE, FluidsGT.FOOD, FluidsGT.ALCOHOLIC, FluidsGT.BEER)                             , "Not to be confused with Beerus, the God of Destruction"          ,  6, 0.4F  ,  10, C+35,  0.50F, 30,  0,  0,  0,  0, EnumAction.drink, F, F, F, Potion.digSpeed                 .id, 400, 2,  60);
		new FoodStatDrink(FL.create("darkbeer"                                   , "Dark Beer"                               , null                  , 1, 1000, 275, FluidsGT.SIMPLE, FluidsGT.FOOD, FluidsGT.ALCOHOLIC, FluidsGT.BEER)                             , "Dark Beer, for the real Men"                                     ,  4, 0.4F  ,  10, C+35,  0.50F, 40,  0,  0,  0,  0, EnumAction.drink, F, F, F, Potion.damageBoost              .id, 300, 1,  60);
		new FoodStatDrink(FL.create("potion.dragonblood"                         , "Dragon Blood"                            , null                  , 1, 1000, 325, FluidsGT.SIMPLE, FluidsGT.FOOD, FluidsGT.ALCOHOLIC, FluidsGT.BEER)                             , "FUS RO DAH!"                                                     ,  4, 0.4F  ,   5, C+40,  0.50F, 70,  0,  0,  0,  0, EnumAction.drink, F, F, F, Potion.damageBoost              .id, 300, 2,  90, PotionsGT.ID_INSANITY, 600, 0, 100);
		
		new FoodStatDrink("binnie.brandyapple"                                                                                                                                                                                                                      , ""                                                                ,  2, 0.1F  ,  10, C+35,  0.50F, 30,  0,  0,  0,  0, EnumAction.drink, F, F, F, Potion.resistance               .id, 400, 1,  60);
		new FoodStatDrink("binnie.brandyapricot"                                                                                                                                                                                                                    , ""                                                                ,  2, 0.1F  ,  10, C+35,  0.50F, 30,  0,  0,  0,  0, EnumAction.drink, F, F, F, Potion.resistance               .id, 400, 1,  60);
		new FoodStatDrink("binnie.brandycherry"                                                                                                                                                                                                                     , ""                                                                ,  2, 0.1F  ,  10, C+35,  0.50F, 30,  0,  0,  0,  0, EnumAction.drink, F, F, F, Potion.resistance               .id, 400, 1,  60);
		new FoodStatDrink("binnie.brandycitrus"                                                                                                                                                                                                                     , ""                                                                ,  2, 0.1F  ,  10, C+35,  0.50F, 30,  0,  0,  0,  0, EnumAction.drink, F, F, F, Potion.resistance               .id, 400, 1,  60);
		new FoodStatDrink("binnie.brandyelderberry"                                                                                                                                                                                                                 , ""                                                                ,  2, 0.1F  ,  10, C+35,  0.50F, 30,  0,  0,  0,  0, EnumAction.drink, F, F, F, Potion.resistance               .id, 400, 1,  60);
		new FoodStatDrink("binnie.brandyfruit"                                                                                                                                                                                                                      , ""                                                                ,  2, 0.1F  ,  10, C+35,  0.50F, 30,  0,  0,  0,  0, EnumAction.drink, F, F, F, Potion.resistance               .id, 400, 1,  60);
		new FoodStatDrink("binnie.brandygrape"                                                                                                                                                                                                                      , ""                                                                ,  2, 0.1F  ,  10, C+35,  0.50F, 30,  0,  0,  0,  0, EnumAction.drink, F, F, F, Potion.resistance               .id, 400, 1,  60);
		new FoodStatDrink("binnie.brandypear"                                                                                                                                                                                                                       , ""                                                                ,  2, 0.1F  ,  10, C+35,  0.50F, 30,  0,  0,  0,  0, EnumAction.drink, F, F, F, Potion.resistance               .id, 400, 1,  60);
		new FoodStatDrink("binnie.brandyplum"                                                                                                                                                                                                                       , ""                                                                ,  2, 0.1F  ,  10, C+35,  0.50F, 30,  0,  0,  0,  0, EnumAction.drink, F, F, F, Potion.resistance               .id, 400, 1,  60);
		
		new FoodStatDrink("binnie.whiskey"                                                                                                                                                                                                                          , ""                                                                ,  2, 0.1F  ,  10, C+35,  0.50F, 30,  0,  0,  0,  0, EnumAction.drink, F, F, F, Potion.resistance               .id, 400, 1,  60);
		new FoodStatDrink("binnie.whiskeycorn"                                                                                                                                                                                                                      , ""                                                                ,  2, 0.1F  ,  10, C+35,  0.50F, 30,  0,  0,  0,  0, EnumAction.drink, F, F, F, Potion.resistance               .id, 400, 1,  60);
		new FoodStatDrink("binnie.whiskeyrye"                                                                                                                                                                                                                       , ""                                                                ,  2, 0.1F  ,  10, C+35,  0.50F, 30,  0,  0,  0,  0, EnumAction.drink, F, F, F, Potion.resistance               .id, 400, 1,  60);
		new FoodStatDrink(FL.create("binnie.whiskeywheat"                        , "Scotch"                                  , null                  , 1, 1000, 275)                                                                                                , "Technically this is just a Whisky"                               ,  2, 0.1F  ,  10, C+35,  0.50F, 30,  0,  0,  0,  0, EnumAction.drink, F, F, F, Potion.resistance               .id, 400, 1,  60);
		new FoodStatDrink(FL.create("glenmckenner"                               , "Glen McKenner"                           , null                  , 1, 1000, 275)                                                                                                , "Don't hand to easily surprised people, they will shatter it."    ,  2, 0.1F  ,   5, C+35,  0.50F, 50,  0,  0,  0,  0, EnumAction.drink, F, F, F, Potion.resistance               .id, 400, 2,  90);
		
		new FoodStatDrink(FL.create("binnie.rumwhite"                            , "Rum"                                     , null                  , 1, 1000, 300)                                                                                                , "A buddle o' rum"                                                 ,  4, 0.4F  ,  10, C+37,  0.50F, 30,  0,  0, 10,  0, EnumAction.drink, F, F, F, Potion.damageBoost              .id, 300, 1,  60);
		new FoodStatDrink(FL.create("binnie.rumdark"                             , "Pirate Brew"                             , null                  , 1, 1000, 300)                                                                                                , "Set the Sails, we are going to Torrentuga!"                      ,  4, 0.4F  ,   5, C+37,  0.50F, 60,  0,  0, 10,  0, EnumAction.drink, F, F, F, Potion.damageBoost              .id, 300, 2,  90);
		new FoodStatDrink(FL.create("pina.colada"                                , "Piña Colada"                             , null                  , 1, 1000, 300)                                                                                                , ""                                                                ,  4, 0.4F  ,  10, C+37,  0.50F, 20,  0,  0, 10,  0, EnumAction.drink, F, F, F, Potion.damageBoost              .id, 300, 1,  60);
		
		new FoodStatDrink("binnie.ciderpear"                                                                                                                                                                                                                        , "If you have nothing better to do with your Pears"                ,  4, 0.2F  ,  10, C+35,  0.50F, 30,  0,  0, 20,  0, EnumAction.drink, F, F, F, Potion.resistance               .id, 400, 1,  60);
		new FoodStatDrink("binnie.ciderpeach"                                                                                                                                                                                                                       , "If you have nothing better to do with your Peaches"              ,  4, 0.2F  ,  10, C+35,  0.50F, 30,  0,  0, 20,  0, EnumAction.drink, F, F, F, Potion.resistance               .id, 400, 1,  60);
		new FoodStatDrink(FL.create("binnie.winepineapple"                       , "Ananas Cider"                            , null                  , 1, 1000, 300)                                                                                                , "If you have nothing better to do with your Pineapples"           ,  4, 0.2F  ,  10, C+35,  0.50F, 30,  0,  0, 10,  0, EnumAction.drink, F, F, F, Potion.resistance               .id, 400, 1,  60);
		new FoodStatDrink(FL.create("binnie.ciderapple"                          , "Cider"                                   , null                  , 1, 1000, 300)                                                                                                , "If you have nothing better to do with your Apples"               ,  4, 0.2F  ,  10, C+35,  0.50F, 30,  0,  0, 20,  0, EnumAction.drink, F, F, F, Potion.resistance               .id, 400, 1,  60);
		
		new FoodStatDrink("binnie.liqueuralmond"                                                                                                                                                                                                                    , ""                                                                ,  4, 0.2F  ,  10, C+35,  0.50F, 30,  0,  0, 20,  0, EnumAction.drink, F, F, F, Potion.resistance               .id, 400, 1,  60);
		new FoodStatDrink("binnie.liqueuranise"                                                                                                                                                                                                                     , ""                                                                ,  4, 0.2F  ,  10, C+35,  0.50F, 30,  0,  0, 20,  0, EnumAction.drink, F, F, F, Potion.resistance               .id, 400, 1,  60);
		new FoodStatDrink("binnie.liqueurbanana"                                                                                                                                                                                                                    , ""                                                                ,  4, 0.2F  ,  10, C+35,  0.50F, 30,  0,  0, 20,0,5, EnumAction.drink, F, F, F, Potion.resistance               .id, 400, 1,  60);
		new FoodStatDrink("binnie.liqueurblackberry"                                                                                                                                                                                                                , ""                                                                ,  4, 0.2F  ,  10, C+35,  0.50F, 30,  0,  0, 20,  0, EnumAction.drink, F, F, F, Potion.resistance               .id, 400, 1,  60);
		new FoodStatDrink("binnie.liqueurblackcurrant"                                                                                                                                                                                                              , ""                                                                ,  4, 0.2F  ,  10, C+35,  0.50F, 30,  0,  0, 20,  0, EnumAction.drink, F, F, F, Potion.resistance               .id, 400, 1,  60);
		new FoodStatDrink("binnie.liqueurcherry"                                                                                                                                                                                                                    , ""                                                                ,  4, 0.2F  ,  10, C+35,  0.50F, 30,  0,  0, 20,  0, EnumAction.drink, F, F, F, Potion.resistance               .id, 400, 1,  60);
		new FoodStatDrink("binnie.liqueurchocolate"                                                                                                                                                                                                                 , ""                                                                ,  4, 0.2F  ,  10, C+35,  0.50F, 30,  0,  0, 20,  0, EnumAction.drink, F, F, F, Potion.resistance               .id, 400, 1,  60);
		new FoodStatDrink("binnie.liqueurcinnamon"                                                                                                                                                                                                                  , ""                                                                ,  4, 0.2F  ,  10, C+35,  0.50F, 30,  0,  0, 20,  0, EnumAction.drink, F, F, F, Potion.resistance               .id, 400, 1,  60);
		new FoodStatDrink("binnie.liqueurcoffee"                                                                                                                                                                                                                    , ""                                                                ,  4, 0.2F  ,  10, C+35,  0.50F, 30,  0,  0, 20,  0, EnumAction.drink, F, F, F, Potion.resistance               .id, 400, 1,  60);
		new FoodStatDrink("binnie.liqueurhazelnut"                                                                                                                                                                                                                  , ""                                                                ,  4, 0.2F  ,  10, C+35,  0.50F, 30,  0,  0, 20,  0, EnumAction.drink, F, F, F, Potion.resistance               .id, 400, 1,  60);
		new FoodStatDrink("binnie.liqueurherbal"                                                                                                                                                                                                                    , ""                                                                ,  4, 0.2F  ,  10, C+35,  0.50F, 30,  0,  0, 20,  0, EnumAction.drink, F, F, F, Potion.resistance               .id, 400, 1,  60);
		new FoodStatDrink("binnie.liqueurlemon"                                                                                                                                                                                                                     , ""                                                                ,  4, 0.2F  ,  10, C+35,  0.50F, 30,  0,  0, 20,  0, EnumAction.drink, F, F, F, Potion.resistance               .id, 400, 1,  60, PotionsGT.ID_CONDUCTIVE, 300, 0,  70);
		new FoodStatDrink("binnie.liqueurmelon"                                                                                                                                                                                                                     , ""                                                                ,  4, 0.2F  ,  10, C+35,  0.50F, 30,  0,  0, 20,  0, EnumAction.drink, F, F, F, Potion.resistance               .id, 400, 1,  60);
		new FoodStatDrink("binnie.liqueurmint"                                                                                                                                                                                                                      , ""                                                                ,  4, 0.2F  ,  10, C+35,  0.50F, 30,  0,  0, 20,  0, EnumAction.drink, F, F, F, Potion.resistance               .id, 400, 1,  60);
		new FoodStatDrink("binnie.liqueurorange"                                                                                                                                                                                                                    , ""                                                                ,  4, 0.2F  ,  10, C+35,  0.50F, 30,  0,  0, 20,  0, EnumAction.drink, F, F, F, Potion.resistance               .id, 400, 1,  60, PotionsGT.ID_CONDUCTIVE, 300, 0,  70);
		new FoodStatDrink("binnie.liqueurpeach"                                                                                                                                                                                                                     , ""                                                                ,  4, 0.2F  ,  10, C+35,  0.50F, 30,  0,  0, 20,  0, EnumAction.drink, F, F, F, Potion.resistance               .id, 400, 1,  60);
		new FoodStatDrink("binnie.liqueurraspberry"                                                                                                                                                                                                                 , ""                                                                ,  4, 0.2F  ,  10, C+35,  0.50F, 30,  0,  0, 20,  0, EnumAction.drink, F, F, F, Potion.resistance               .id, 400, 1,  60);
		
		new FoodStatDrink("binnie.liquorpear"                                                                                                                                                                                                                       , ""                                                                ,  2, 0.2F  ,  10, C+35,  0.50F, 55,  0,  0,  0,  0, EnumAction.drink, F, F, F, Potion.damageBoost              .id, 500, 1,  60);
		new FoodStatDrink("binnie.liquorfruit"                                                                                                                                                                                                                      , ""                                                                ,  2, 0.2F  ,  10, C+35,  0.50F, 55,  0,  0,  0,  0, EnumAction.drink, F, F, F, Potion.damageBoost              .id, 500, 1,  60);
		new FoodStatDrink("binnie.liquorelderberry"                                                                                                                                                                                                                 , ""                                                                ,  2, 0.2F  ,  10, C+35,  0.50F, 55,  0,  0,  0,  0, EnumAction.drink, F, F, F, Potion.damageBoost              .id, 500, 1,  60);
		new FoodStatDrink("binnie.liquorcherry"                                                                                                                                                                                                                     , ""                                                                ,  2, 0.2F  ,  10, C+35,  0.50F, 55,  0,  0,  0,  0, EnumAction.drink, F, F, F, Potion.damageBoost              .id, 500, 1,  60);
		new FoodStatDrink("binnie.liquorapricot"                                                                                                                                                                                                                    , ""                                                                ,  2, 0.2F  ,  10, C+35,  0.50F, 55,  0,  0,  0,  0, EnumAction.drink, F, F, F, Potion.damageBoost              .id, 500, 1,  60);
		new FoodStatDrink("binnie.liquorapple"                                                                                                                                                                                                                      , ""                                                                ,  2, 0.2F  ,  10, C+35,  0.50F, 55,  0,  0,  0,  0, EnumAction.drink, F, F, F, Potion.damageBoost              .id, 500, 1,  60);
		new FoodStatDrink("binnie.spiritsugarcane"                                                                                                                                                                                                                  , ""                                                                ,  2, 0.2F  ,  10, C+35,  0.50F, 55,  0,  0,  0,  0, EnumAction.drink, F, F, F, Potion.damageBoost              .id, 500, 1,  60);
		new FoodStatDrink("binnie.spiritneutral"                                                                                                                                                                                                                    , ""                                                                ,  2, 0.2F  ,  10, C+35,  0.50F, 55,  0,  0,  0,  0, EnumAction.drink, F, F, F, Potion.damageBoost              .id, 500, 1,  60);
		new FoodStatDrink("binnie.spiritgin"                                                                                                                                                                                                                        , ""                                                                ,  2, 0.2F  ,  10, C+35,  0.50F, 55,  0,  0,  0,  0, EnumAction.drink, F, F, F, Potion.damageBoost              .id, 500, 1,  60);
		new FoodStatDrink("binnie.tequila"                                                                                                                                                                                                                          , ""                                                                ,  2, 0.2F  ,  10, C+35,  0.50F, 55,  0,  0,  0,  0, EnumAction.drink, F, F, F, Potion.damageBoost              .id, 500, 1,  60);
		new FoodStatDrink(FL.create("binnie.vodka"                               , "Vodka"                                   , null                  , 1, 1000, 275)                                                                                                , "Not to be confused with Water"                                   ,  2, 0.2F  ,  10, C+35,  0.50F, 55,  0,  0,  0,  0, EnumAction.drink, F, F, F, Potion.damageBoost              .id, 500, 1,  60);
		new FoodStatDrink(FL.create("potion.leninade"                            , "Leninade"                                , null                  , 1, 1000, 275, FluidsGT.SIMPLE, FluidsGT.FOOD, FluidsGT.ALCOHOLIC)                                            , "Let the Communism flow through you!"                             ,  2, 0.2F  ,   5, C+35,  0.50F, 65,  0,  0, 20,  0, EnumAction.drink, F, F, F, Potion.damageBoost              .id, 500, 2,  90);
		new FoodStatDrink(FL.create("potion.alcopops"                            , "Alcopops"                                , null                  , 1, 1000, 275, FluidsGT.SIMPLE, FluidsGT.FOOD, FluidsGT.ALCOHOLIC)                                            , "Don't let your Children drink this junk!"                        ,  2, 0.2F  ,  10, C+30,  0.50F, 30,  0,  0, 30,  0, EnumAction.drink, F, F, F, Potion.digSpeed                 .id, 900, 1,  90);
		new FoodStatDrink(FL.create("short.mead"                                 , "Short Mead"                              , null                  , 1, 1000, 300)                                                                                                , "A Vikings favourite brew"                                        ,  3, 0.1F  ,  10, C+37,  0.50F, 30,  0,  0, 30,  0, EnumAction.drink, F, F, F, Potion.damageBoost              .id, 300, 1,  60, Potion.resistance.id, 300, 1,  60);
		new FoodStatDrink(FL.create("mead"                                       , "Mead"                                    , null                  , 1, 1000, 300)                                                                                                , "A Vikings favourite brew"                                        ,  3, 0.1F  ,  10, C+37,  0.50F, 30,  0,  0, 30,  0, EnumAction.drink, F, F, F, Potion.damageBoost              .id, 300, 1,  60, Potion.resistance.id, 300, 1,  60);
		
		
		
		new FoodStatDrink(FL.create("vinegar"                                    , "Grape Vinegar"                           , null                  , 1, 1000, 300)                                                                                                , ""                                                                ,  2, 0.2F  ,  10, C+37,  0.50F, 30,  0,  0, 20,  0, EnumAction.drink, F, F, F, Potion.heal                     .id,   1, 1,  70);
		new FoodStatDrink(FL.create("applevinegar"                               , "Apple Cider Vinegar"                     , null                  , 1, 1000, 300)                                                                                                , ""                                                                ,  2, 0.2F  ,  10, C+37,  0.50F, 30,  0,  0, 15,  0, EnumAction.drink, F, F, F, Potion.resistance               .id, 400, 2,  70);
		new FoodStatDrink(FL.create("canevinegar"                                , "Cane Vinegar"                            , null                  , 1, 1000, 300)                                                                                                , ""                                                                ,  2, 0.2F  ,  10, C+37,  0.50F, 30,  0,  0, 10,  0, EnumAction.drink, F, F, F, Potion.damageBoost              .id, 300, 2,  70);
		new FoodStatDrink(FL.create("ricevinegar"                                , "Rice Vinegar"                            , null                  , 1, 1000, 300)                                                                                                , ""                                                                ,  2, 0.2F  ,  10, C+37,  0.50F, 30,  0,  0, 10,  0, EnumAction.drink, F, F, F, Potion.damageBoost              .id, 300, 2,  70);
		
		
		new FoodStatDrink(FL.create("chillysauce"                                , "Chili Sauce"                             , null                  , 1, 1000, 300, FluidsGT.SIMPLE, FluidsGT.FOOD)                                                                , "Spicy"                                                           ,  2, 0.1F  ,  10, C+42,  0.50F,  0,  0, 10, 10,  0, EnumAction.drink, F, F, F, PotionsGT.ID_FLAMMABLE, 300, 0, 70, Potion.confusion                .id,1000, 0,  10, Potion.fireResistance.id,1000, 0,  60, PotionsGT.ID_DEHYDRATION      , 400, 0, 100);
		new FoodStatDrink(FL.create("potion.hotsauce"                            , "Hot Sauce"                               , null                  , 1, 1000, 325, FluidsGT.SIMPLE, FluidsGT.FOOD)                                                                , "Very Spicy, I guess?"                                            ,  2, 0.1F  ,  10, C+44,  0.50F,  0,  0, 20, 10,  0, EnumAction.drink, F, F, F, PotionsGT.ID_FLAMMABLE, 300, 0, 70, Potion.confusion                .id,2000, 0,  30, Potion.fireResistance.id,2000, 0,  70, PotionsGT.ID_DEHYDRATION      , 400, 1, 100);
		new FoodStatDrink(FL.create("potion.diabolosauce"                        , "Diabolo Sauce"                           , null                  , 1, 1000, 350, FluidsGT.SIMPLE, FluidsGT.FOOD)                                                                , "As if the Devil made this Sauce"                                 ,  2, 0.1F  ,  10, C+46,  0.50F,  0,  0, 30, 10,  0, EnumAction.drink, F, F, F, PotionsGT.ID_FLAMMABLE, 300, 1, 70, Potion.confusion                .id,3000, 1,  50, Potion.fireResistance.id,3000, 0,  80, PotionsGT.ID_DEHYDRATION      , 400, 2, 100, PotionsGT.ID_INSANITY    , 600, 0, 100);
		new FoodStatDrink(FL.create("potion.diablosauce"                         , "Diablo Sauce"                            , null                  , 1, 1000, 375, FluidsGT.SIMPLE, FluidsGT.FOOD, FluidsGT.ACID)                                                 , "Diablo always comes back!"                                       ,  2, 0.1F  ,  10, C+48,  0.50F,  0,  0, 40, 10,  0, EnumAction.drink, F, F, F, PotionsGT.ID_FLAMMABLE, 300, 1, 70, Potion.confusion                .id,4000, 1,  70, Potion.fireResistance.id,4000, 0,  90, PotionsGT.ID_DEHYDRATION      , 400, 3, 100, PotionsGT.ID_INSANITY    , 600, 1, 100);
		new FoodStatDrink(FL.create("potion.diablosauce.strong"                  , "There is no Cow Sauce"                   , null                  , 1, 1000, 999, FluidsGT.SIMPLE, FluidsGT.FOOD, FluidsGT.ACID, FluidsGT.ENCHANTED_EFFECT).setLuminosity(15)    , "[Missing No]"                                                    ,  2, 0.1F  ,  10, C+50,  0.50F,  0,  0, 99, 10,  0, EnumAction.drink, F, F, F, PotionsGT.ID_FLAMMABLE, 300, 2, 90, Potion.confusion                .id,9999, 2, 999, Potion.fireResistance.id,9999, 9, 999, PotionsGT.ID_DEHYDRATION      , 400, 4, 100, PotionsGT.ID_INSANITY    , 600, 2, 100);
		
		
		new FoodStatDrink(FL.create("honey"                                      , "Honey (Biomes o'Plenty, Erebus)"         , MT.Honey              , 1, 1000, 300)                                                                                                , "Bee careful with it"                                             ,  1, 0.1F  ,  20, C+37,  0.50F,  0,  0,  0, 40,  0, EnumAction.drink, T, F, F, PotionsGT.ID_STICKY, 300, 0, 70).setMilk();
		new FoodStatDrink(FL.create("grc.honey"                                  , "Honey (GrowthCraft)"                     , MT.Honey              , 1, 1000, 300)                                                                                                , "Bee careful with it"                                             ,  1, 0.1F  ,  20, C+37,  0.50F,  0,  0,  0, 40,  0, EnumAction.drink, T, F, F, PotionsGT.ID_STICKY, 300, 0, 70).setMilk();
		new FoodStatDrink(FL.create("for.honey"                                  , "Honey (Forestry, most other Mods)"       , MT.Honey              , 1, 1000, 300)                                                                                                , "Bee careful with it"                                             ,  1, 0.1F  ,  20, C+37,  0.50F,  0,  0,  0, 40,  0, EnumAction.drink, T, F, F, PotionsGT.ID_STICKY, 300, 0, 70).setMilk();
		new FoodStatDrink(FL.create("honeydew"                                   , "Honeydew"                                , MT.Honeydew           , 1, 1000, 300)                                                                                                , "Sweet sweet Honeydew"                                            ,  2, 0.2F  ,  20, C+37,  0.50F, 10,  0,  0, 30,  0, EnumAction.drink, T, F, F, PotionsGT.ID_STICKY, 300, 0, 70, Potion.moveSpeed                .id, 600, 0, 100).setMilk();
		new FoodStatDrink(FL.create("potion.ambrosia"                            , "Ambrosia"                                , null                  , 1, 1000, 275)                                                                                                , "It's the Bee Movie, but everytime someone says Bee, it will..."  ,  2, 0.2F  ,  20, C+37,  0.75F, 30,  0,  0, 40,  0, EnumAction.drink, T, F, F, PotionsGT.ID_STICKY, 300, 0, 70, Potion.regeneration             .id, 150, 0, 100).setMilk();
		new FoodStatDrink(FL.create("royaljelly"                                 , "Royal Jelly"                             , null                  , 1, 1000, 275)                                                                                                , "you jelly?"                                                      ,  2, 0.2F  ,  20, C+37,  0.75F,  0,  0,  0, 40,  0, EnumAction.drink, T, F, F, PotionsGT.ID_STICKY, 300, 0, 70, Potion.regeneration             .id, 150, 1, 100).setMilk();
		
		
		new FoodStatDrink(FL.create("sunfloweroil"                               , "Sunflower Oil"                           , MT.SunflowerOil       , 1, 1000, 300, FluidsGT.SIMPLE, FluidsGT.FOOD, FluidsGT.COOKING_OIL)                                          , ""                                                                ,  2, 0.2F  ,  10, C+37,  0.50F,  0,  0, 20,  0, 20, EnumAction.drink, F, F, F, Potion.hunger                   .id, 400, 1,  70, PotionsGT.ID_SLIPPERY, 300, 1, 70, PotionsGT.ID_FLAMMABLE, 300, 0, 70);
		new FoodStatDrink(FL.create("nutoil"                                     , "Nut Oil"                                 , MT.NutOil             , 1, 1000, 300, FluidsGT.SIMPLE, FluidsGT.FOOD, FluidsGT.COOKING_OIL)                                          , ""                                                                ,  2, 0.2F  ,  10, C+37,  0.50F,  0,  0, 20,  0, 20, EnumAction.drink, F, F, F, Potion.hunger                   .id, 400, 1,  70, PotionsGT.ID_SLIPPERY, 300, 1, 70, PotionsGT.ID_FLAMMABLE, 300, 0, 70);
		new FoodStatDrink(FL.create("binnie.juiceolive"                          , "Olive Oil"                               , MT.OliveOil           , 1, 1000, 300, FluidsGT.SIMPLE, FluidsGT.FOOD, FluidsGT.COOKING_OIL)                                          , ""                                                                ,  2, 0.2F  ,  10, C+37,  0.50F,  0,  0, 20,  0, 20, EnumAction.drink, F, F, F, Potion.hunger                   .id, 400, 1,  70, PotionsGT.ID_SLIPPERY, 300, 1, 70, PotionsGT.ID_FLAMMABLE, 300, 0, 70);
		new FoodStatDrink(FL.create("seedoil"                                    , "Seed Oil"                                , MT.SeedOil            , 1, 1000, 300, FluidsGT.SIMPLE, FluidsGT.FOOD, FluidsGT.COOKING_OIL)                                          , ""                                                                ,  2, 0.2F  ,  10, C+37,  0.50F,  0,  0, 20,  0, 20, EnumAction.drink, F, F, F, Potion.hunger                   .id, 400, 1,  70, PotionsGT.ID_SLIPPERY, 300, 1, 70, PotionsGT.ID_FLAMMABLE, 300, 0, 70);
		new FoodStatDrink(FL.create("linoil"                                     , "Lin Oil"                                 , MT.LinOil             , 1, 1000, 300, FluidsGT.SIMPLE, FluidsGT.FOOD, FluidsGT.COOKING_OIL)                                          , ""                                                                ,  2, 0.2F  ,  10, C+37,  0.50F,  0,  0, 20,  0, 20, EnumAction.drink, F, F, F, Potion.hunger                   .id, 400, 1,  70, PotionsGT.ID_SLIPPERY, 300, 1, 70, PotionsGT.ID_FLAMMABLE, 300, 0, 70);
		new FoodStatDrink(FL.create("hempoil"                                    , "Hemp Oil"                                , MT.HempOil            , 1, 1000, 300, FluidsGT.SIMPLE, FluidsGT.FOOD, FluidsGT.COOKING_OIL)                                          , ""                                                                ,  2, 0.2F  ,  10, C+37,  0.50F,  0,  0, 20,  0, 20, EnumAction.drink, F, F, F, Potion.hunger                   .id, 400, 1,  70, PotionsGT.ID_SLIPPERY, 300, 1, 70, PotionsGT.ID_FLAMMABLE, 300, 0, 70);
		new FoodStatDrink(FL.create("fishoil"                                    , "Fish Oil"                                , MT.FishOil            , 1, 1000, 300, FluidsGT.SIMPLE, FluidsGT.FOOD, FluidsGT.COOKING_OIL)                                          , ""                                                                ,  2, 0.2F  ,  10, C+37,  0.50F,  0,  0, 20,  0, 20, EnumAction.drink, F, F, F, Potion.hunger                   .id, 400, 1,  70, PotionsGT.ID_SLIPPERY, 300, 1, 70, PotionsGT.ID_FLAMMABLE, 300, 0, 70);
		new FoodStatDrink(FL.create("whaleoil"                                   , "Whale Oil"                               , MT.WhaleOil           , 1, 1000, 300, FluidsGT.SIMPLE, FluidsGT.FOOD, FluidsGT.COOKING_OIL)                                          , ""                                                                ,  2, 0.2F  ,  10, C+37,  0.50F,  0,  0, 20,  0, 20, EnumAction.drink, F, F, F, Potion.hunger                   .id, 400, 1,  70, PotionsGT.ID_SLIPPERY, 300, 1, 70, PotionsGT.ID_FLAMMABLE, 300, 0, 70);
		
		
		new FoodStatDrink(FL.create("mayo"                                       , "Mayonnaise"                              , null                  , 1, 1000, 275, FluidsGT.SIMPLE, FluidsGT.FOOD)                                                                , "Tastes like Cardboard"                                           ,  3, 0.5F  ,   5, C+37,  0.25F,  0,  0, 10,  0, 20, EnumAction.eat  , F, F, F, PotionsGT.ID_SLIPPERY, 300, 1, 70);
		new FoodStatDrink(FL.create("potion.dressing"                            , "Dressing"                                , null                  , 1, 1000, 275, FluidsGT.SIMPLE, FluidsGT.FOOD, FluidsGT.ALCOHOLIC)                                            , "For making yourself a Salad"                                     ,  1, 0.5F  ,   5, C+36,  0.25F, 10,  0,  0,  0, 20, EnumAction.drink, F, F, F, PotionsGT.ID_SLIPPERY, 300, 1, 70);
		new FoodStatDrink(FL.create("grcmilk.cream"                              , "Heavy Cream"                             , null                  , 1, 1000, 275, FluidsGT.SIMPLE, FluidsGT.FOOD)                                                                , ""                                                                ,  2, 0.4F  ,  20, C+37,  0.75F,  0,  0,  0, 20, 20, EnumAction.drink, F, F, F);
		new FoodStatDrink(FL.create("coconutcream"                               , "Coconut Cream"                           , null                  , 1, 1000, 275, FluidsGT.SIMPLE, FluidsGT.FOOD)                                                                , ""                                                                ,  2, 0.4F  ,  20, C+37,  0.75F,  0,  0,  0, 15, 15, EnumAction.drink, F, F, F);
		new FoodStatDrink(FL.create("ketchup"                                    , "Tomato Ketchup"                          , null                  , 1, 1000, 300, FluidsGT.SIMPLE, FluidsGT.FOOD)                                                                , "this tooltip doesn't make sans"                                  ,  4, 0.3F  ,  20, C+37,  0.50F,  0,  0,  0, 30,  0, EnumAction.drink, F, F, F, Potion.heal                     .id,   1, 0,  10, Potion.moveSpeed.id, 200, 0,  20);
		new FoodStatDrink(FL.create("bbqsauce"                                   , "Barbecue Sauce"                          , null                  , 1, 1000, 300, FluidsGT.SIMPLE, FluidsGT.FOOD)                                                                , "Also called BBQ Sauce"                                           ,  4, 0.3F  ,  20, C+37,  0.50F,  0,  0,  0, 30,  0, EnumAction.drink, F, F, F, Potion.heal                     .id,   1, 0,  10, Potion.moveSpeed.id, 200, 0,  20);
		new FoodStatDrink(FL.create("chocolatecream"                             , "Chocolate Cream"                         , null                  , 1, 1000, 275, FluidsGT.SIMPLE, FluidsGT.FOOD)                                                                , ""                                                                ,  4, 0.2F  ,   5, C+37,  0.15F,  0,  0,  0, 30, 20, EnumAction.eat  , F, F, F, PotionsGT.ID_STICKY, 300, 0, 70);
		new FoodStatDrink(FL.create("nutella"                                    , "Nutella"                                 , null                  , 1, 1000, 275, FluidsGT.SIMPLE, FluidsGT.FOOD)                                                                , "For Germans: It is 'die' Nutella, not 'der' nor 'das'"           ,  8, 0.4F  ,   5, C+37,  0.15F,  0,  0,  0, 20, 30, EnumAction.eat  , F, F, F, PotionsGT.ID_STICKY, 300, 0, 70);
		new FoodStatDrink(FL.create("peanutbutter"                               , "Peanut Butter"                           , null                  , 1, 1000, 300, FluidsGT.SIMPLE, FluidsGT.FOOD)                                                                , "This is NUTS!!!"                                                 ,  8, 0.4F  ,   5, C+37,  0.15F,  0,  0,  0, 20, 30, EnumAction.eat  , F, F, F, PotionsGT.ID_STICKY, 300, 0, 70);
		new FoodStatDrink(FL.create("maplesyrup"                                 , "Maple Syrup"                             , null                  , 1, 1000, 300, FluidsGT.SIMPLE, FluidsGT.FOOD)                                                                , "Etho paused to look at a vintage Beef, then he unpaused"         ,  4, 0.2F  ,  20, C+37,  0.30F,  0,  0,  0, 40, 10, EnumAction.drink, F, F, F, PotionsGT.ID_STICKY, 300, 0, 70);
		
		
		new FoodStatDrink(FL.create("purpledrink"                                , "Purple Drink"                            , null                  , 1, 1000, 275, FluidsGT.SIMPLE, FluidsGT.FOOD)                                                                , "How about Lemonade? Or some Ice Tea? I got Purple Drink!"        ,  8, 0.2F  ,  30, C+35,  0.50F,  0,  0,  0, 40,  0, EnumAction.drink, F, F, F, Potion.moveSlowdown             .id,1200, 2,  90);
		new FoodStatDrink(FL.create("potion.lemonade"                            , "Lemonade"                                , null                  , 1, 1000, 275, FluidsGT.SIMPLE, FluidsGT.FOOD)                                                                , "Cold and refreshing Lemonade"                                    ,  4, 0.3F  ,  20, C+35,  0.50F,  0,  0,  0, 40,  0, EnumAction.drink, F, F, F, Potion.digSpeed                 .id, 900, 1,  90, PotionsGT.ID_CONDUCTIVE, 300, 0,  70);
		
		
		new FoodStatDrink(FL.create("goldencarrotjuice"                          , "Golden Carrot Juice"                     , null                  , 1, 1000, 300, FluidsGT.SIMPLE, FluidsGT.FOOD, FluidsGT.ENCHANTED_EFFECT, FluidsGT.JUICE)                          .setLuminosity(15)  , "A golden Carrot in liquid form"                          ,  4, 0.2F  , 100, C+37,  0.75F,  0,  0,  0, 20,  0, EnumAction.drink, F, F, F, Potion.nightVision              .id,1200, 0,  90);
		new FoodStatDrink(FL.create("potion.goldenapplejuice"                    , "Golden Apple Juice"                      , null                  , 1, 1000, 300, FluidsGT.SIMPLE, FluidsGT.FOOD, FluidsGT.ENCHANTED_EFFECT, FluidsGT.FRUIT_JUICE, FluidsGT.JUICE)    .setLuminosity(15)  , "A golden Apple in liquid form"                           ,  4, 0.2F  , 100, C+37,  0.75F,  0,  0,  5, 30,  0, EnumAction.drink, F, F, F, Potion.field_76444_x            .id,2400, 0, 100, Potion.regeneration       .id, 100, 1, 100);
		new FoodStatDrink(FL.create("potion.goldencider"                         , "Golden Cider"                            , null                  , 1, 1000, 300, FluidsGT.SIMPLE, FluidsGT.FOOD, FluidsGT.ENCHANTED_EFFECT, FluidsGT.ALCOHOLIC, FluidsGT.CIDER)      .setLuminosity(15)  , "More Resistance, less Regeneration"                      ,  4, 0.2F  , 100, C+37,  0.75F, 40,  0,  5, 30,  0, EnumAction.drink, F, F, F, Potion.field_76444_x            .id,2400, 1,  95);
		new FoodStatDrink(FL.create("potion.idunsapplejuice"                     , "Idun's Apple Juice"                      , null                  , 1, 1000, 300, FluidsGT.SIMPLE, FluidsGT.FOOD, FluidsGT.ENCHANTED_EFFECT, FluidsGT.FRUIT_JUICE, FluidsGT.JUICE)    .setLuminosity(15)  , "So you got the Idea of using Notch Apples for a drink?"  ,  4, 0.2F  , 100, C+37,  0.75F,  0,  0,  5, 30,  0, EnumAction.drink, F, F, F, Potion.regeneration             .id, 600, 4, 100, Potion.field_76444_x      .id,2400, 0, 100, Potion.resistance         .id,6000, 0, 100, Potion.fireResistance .id,6000, 0, 100);
		new FoodStatDrink(FL.create("potion.notchesbrew"                         , "Notches Brew"                            , null                  , 1, 1000, 300, FluidsGT.SIMPLE, FluidsGT.FOOD, FluidsGT.ENCHANTED_EFFECT, FluidsGT.ALCOHOLIC, FluidsGT.CIDER)      .setLuminosity(15)  , "This is just overpowered"                                ,  4, 0.2F  , 100, C+37,  0.75F, 60,  0,  5, 30,  0, EnumAction.drink, F, F, F, Potion.regeneration             .id, 700, 4,  95, Potion.field_76444_x      .id,3000, 1,  95, Potion.resistance         .id,7000, 1,  95, Potion.fireResistance .id,7000, 0,  95);
		
		
		MT.Lubricant.liquid(FL.LubRoCant.make(1000));
		new FoodStatDrink(FL.create("potion.cavejohnsonsgrenadejuice"            , "Cave Johnson's Grenade Juice"            , null                  , 1, 1000, 300, FluidsGT.SIMPLE)                                                                        , "When life gives you Lemons, make Life take them Lemons back!"    ,  0, 0.0F  ,  20, C+37,  0.50F,  0,  0,  0,  0,  0, EnumAction.drink, T, F, F, PotionsGT.ID_CONDUCTIVE            , 300, 0,  70).setExplosive();
		new FoodStatDrink(FL.create("holywater"                                  , "Holy Water"                              , MT.HolyWater          , 1, 1000, 300, FluidsGT.SIMPLE, FluidsGT.ENCHANTED_EFFECT)                                             , "May the holy Planks be with you"                                 ,  0, 0.0F  ,  10, C+30,  0.50F,  0,  0,  0,  0,  0, EnumAction.drink, T, F, F, Potion.poison                   .id, 100, 1, 100, PotionsGT.ID_INSANITY, 600, 1, 100).setMilk();
		new FoodStatDrink(FL.create("glue"                                       , "Glue"                                    , MT.Glue               , 1, 1000, 300, FluidsGT.SIMPLE)                                                                        , "Do not eat!"                                                     ,  1, 0.1F  ,   5, C+37,  0.50F,  0,  0,  0,  0,  0, EnumAction.eat  , T, F, F, Potion.moveSlowdown             .id, 400, 1,  90, Potion.digSlowdown.id, 400, 1,  90, PotionsGT.ID_STICKY, 300, 0, 90);
		new FoodStatDrink(FL.create("lubricant"                                  , "Lubricant"                               , MT.Lubricant          , 1)                                                                                                    , "Industrial Use ONLY!"                                            ,  0, 0.0F  ,   0, C+37,  0.00F,  0,  0,  0,  0,  0, EnumAction.drink, T, F, F, PotionsGT.ID_SLIPPERY              , 300, 1,  90);
		new FoodStatDrink(FL.create("mercury"                                    , "Mercury"                                 , MT.Hg                 , 1, L   , 300, FluidsGT.SIMPLE)                                                                        , "Essence of Immortality"                                          ,  0, 0.0F  ,   0, C+37,  0.00F,  0,  0,  0,  0,  0, EnumAction.drink, T, F, F, PotionsGT.ID_CONDUCTIVE            , 300, 0,  90, Potion.poison     .id,2000, 3, 100);
		new FoodStatDrink(FL.create("sluicejuice"                                , "Sluice Juice"                            , null                  , 1, 1000, 300, FluidsGT.SIMPLE)                                                                        , ""                                                                ,  0, 0.0F  ,   0, C+37,  0.00F,  0,  0,  0,  0,  0, EnumAction.drink, T, F, F, Potion.moveSlowdown             .id,2000, 3, 100, Potion.poison     .id, 100, 1, 100);
		
		
		new FoodStatDrink(FL.create("soymilk"                                    , "Soy Milk"                                , null                  , 1, 1000, 275)                                                                                         , "Milk Substitute"                                                 ,  0, 0.0F  ,  20, C+37,  0.50F,  0,  0,  0, 10,  0, EnumAction.drink, T, F, F).setMilk();
		new FoodStatDrink(FL.create("grcmilk.milk"                               , "Milk"                                    , MT.Milk               , 1, 1000, 300)                                                                                         , "Got Milk?"                                                       ,  0, 0.0F  ,  20, C+37,  0.75F,  0,  0,  0,  0, 10, EnumAction.drink, T, F, F).setMilk();
		new FoodStatDrink(FL.create("milk"                                       , "Milk"                                    , MT.Milk               , 1, 1000, 300, ST.make(Items.milk_bucket,1,0), ST.make(Items.bucket,1,0), 1000)                        , "Got Milk?"                                                       ,  0, 0.0F  ,  20, C+37,  0.75F,  0,  0,  0,  0, 10, EnumAction.drink, T, F, F).setMilk();
		new FoodStatDrink(FL.create("spoiledmilk"                                , "Milk"                                    , null                  , 1, 1000, 300)                                                                                         , "Smells a little"                                                 ,  0, 0.0F  ,   0, C+37,  0.75F,  0,  0,  0,  0,  0, EnumAction.drink, T, F, F, Potion.hunger                   .id, 100, 1, 100);
		new FoodStatDrink(FL.create("rottendrink"                                , "Rotten Drink"                            , null                  , 1, 1000, 275)                                                                                         , "Smells rotten"                                                   ,  0, 0.0F  ,   0, C+37,  0.75F,  0,  0,  0,  0,  0, EnumAction.drink, F, F, F, Potion.hunger                   .id, 100, 1, 100);
		new FoodStatDrink(FL.create("mushroomsoup"                               , "Mushroom Stew"                           , null                  , 1, 1000, 300, ST.make(Items.mushroom_stew,1,0), ST.make(Items.bowl,1,0), 1000)                        , ""                                                                ,  2, 0.6F  ,   5, C+37,  0.15F,  0,  0, 10, 10,  0, EnumAction.eat  , T, F, F);
		
		
		new FoodStatDrink("slime.blue"                                                                                                                                                                                                                       , "Blue Slime Juice"                                                ,  2, 0.5F  ,  20, C+37,  0.50F,  0,  0,  0,  0,  0, EnumAction.drink, F, F, F, Potion.jump                     .id, 600, 0,  50, PotionsGT.ID_STICKY, 300, 0, 90);
		new FoodStatDrink("pinkslime"                                                                                                                                                                                                                        , "Meaty Slime Juice"                                               ,  4, 0.5F  ,  20, C+37,  0.50F,  0,  0,  0, 20,  0, EnumAction.drink, F, F, F, Potion.jump                     .id,1200, 1,  75, PotionsGT.ID_STICKY, 300, 0, 90);
		new FoodStatDrink(FL.create("slime"                                      , "Slime"                                   , null                  , 1, 1000, 300)                                                                                         , "Green Slime Juice"                                               ,  2, 0.5F  ,  20, C+37,  0.50F,  0,  0,  0,  0,  0, EnumAction.drink, F, F, F, Potion.jump                     .id, 600, 0,  50, PotionsGT.ID_STICKY, 300, 0, 90);
		new FoodStatDrink(FL.create("bawls"                                      , "BAWLS"                                   , null                  , 1, 1000, 275)                                                                                         , "Here, take a cold and refreshing sip of my BAWLS"                ,  2, 0.5F  ,  20, C+35,  0.50F,  0,  0,  0,  0,  0, EnumAction.drink, F, F, F, Potion.jump                     .id,1200, 1,  90, PotionsGT.ID_STICKY, 300, 0, 90);
		
		
		new FoodStatDrink(FL.create("potion.darkcoffee"                          , "Dark Coffee"                             , null                  , 1, 1000, 300, FluidsGT.SIMPLE, FluidsGT.FOOD, FluidsGT.THERMOS)                                       , "Coffee, dark, without anything else"                             ,  2, 0.2F  ,   5, C+39,  0.50F,  0, 30, 15,  0,  0, EnumAction.drink, F, F, F);
		new FoodStatDrink(FL.create("potion.darkcafeaulait"                      , "Dark Cafe au lait"                       , null                  , 1, 1000, 300, FluidsGT.SIMPLE, FluidsGT.FOOD, FluidsGT.THERMOS)                                       , "Keeping you awake the whole night"                               ,  2, 0.2F  ,   5, C+39,  0.50F,  0, 30, 15, 20,  0, EnumAction.drink, F, F, F);
		new FoodStatDrink(FL.create("potion.coffee"                              , "Coffee"                                  , null                  , 1, 1000, 300, FluidsGT.SIMPLE, FluidsGT.FOOD, FluidsGT.THERMOS)                                       , "Just the regular morning Coffee"                                 ,  4, 0.4F  ,   5, C+39,  0.50F,  0, 30, 15,  0,  0, EnumAction.drink, F, F, F);
		new FoodStatDrink(FL.create("potion.cafeaulait"                          , "Cafe au lait"                            , null                  , 1, 1000, 300, FluidsGT.SIMPLE, FluidsGT.FOOD, FluidsGT.THERMOS)                                       , "Sweet Coffee"                                                    ,  4, 0.4F  ,   5, C+39,  0.50F,  0, 30, 15, 20,  0, EnumAction.drink, F, F, F);
		new FoodStatDrink(FL.create("potion.laitaucafe"                          , "Lait au cafe"                            , null                  , 1, 1000, 300, FluidsGT.SIMPLE, FluidsGT.FOOD, FluidsGT.THERMOS)                                       , "You want Coffee to your Sugar?"                                  ,  4, 0.4F  ,   5, C+39,  0.50F,  0, 30, 15, 40,  0, EnumAction.drink, F, F, F);
		new FoodStatDrink(FL.create("potion.darkchocolatemilk"                   , "Bitter Chocolate Milk"                   , null                  , 1, 1000, 300, FluidsGT.SIMPLE, FluidsGT.FOOD)                                                         , "A bit bitter, better add a bit Sugar"                            ,  4, 0.4F  ,  10, C+37,  0.50F,  0,  0,  0, 30,  0, EnumAction.drink, F, F, F);
		new FoodStatDrink(FL.create("chocolatemilk"                              , "Chocolate Milk"                          , null                  , 1, 1000, 300)                                                                                         , "Sweet Goodness"                                                  ,  4, 0.4F  ,  10, C+37,  0.50F,  0,  0,  0, 40,  0, EnumAction.drink, F, F, F);
		new FoodStatDrink(FL.create("tea"                                        , "Tea"                                     , null                  , 1, 1000, 300)                                                               , "Side Effects may include: Infinite Wealth, clipping through Walls and ascending to Godhood",  2, 0.2F  ,  20, C+39,  0.50F,  0, 30,  0,  0,  0, EnumAction.drink, F, F, F);
		new FoodStatDrink(FL.create("sweettea"                                   , "Sweet Tea"                               , null                  , 1, 1000, 300)                                                                                         , "How about an actual Tea Party? In Boston?"                       ,  2, 0.2F  ,  20, C+39,  0.50F,  0, 30,  0, 30,  0, EnumAction.drink, F, F, F);
		new FoodStatDrink(FL.create("icetea"                                     , "Ice Tea"                                 , null                  , 1, 1000, 255)                                                                                         , "Ice 'T'"                                                         ,  6, 0.4F  ,  30, C+35,  0.50F,  0, 10,  0, 30,  0, EnumAction.drink, F, F, F);
		
		
		new FoodStatDrink(FL.create("medicine.heal"                              , "Medicine"                                , null                  , 1, 1000, 300)                                                                                         , "Heals up to 20 Hearts"                                           ,  0, 0.0F  ,   0, C+37,  0.00F,  0,  0,  0,  0,  0, EnumAction.drink, T, F, F, Potion.regeneration             .id, 120, 4, 100);
		new FoodStatDrink(FL.create("medicine.laxative"                          , "Laxative"                                , null                  , 1, 1000, 300)                                                                                         , "Removes 10 Hunger/Saturation"                                    ,  0, 0.0F  ,   0, C+37,  0.00F,  0,  0,  0,  0,  0, EnumAction.drink, T, F, F, Potion.hunger                   .id, 300,10, 100);
		
		
		DYE_FLUIDS[DYE_INDEX_Blue].add(FL.make("blueberryjuice", 250));
		DYE_FLUIDS[DYE_INDEX_Red ].add(FL.make("binnie.juicecranberry", 250));
		
		
		for (OreDictMaterial tMaterial : MT.ALL_MATERIALS_REGISTERED_HERE) {
			if (tMaterial.contains(TD.ItemGenerator.LIQUID)) FL.createLiquid(tMaterial);
			if (tMaterial.contains(TD.ItemGenerator.MOLTEN)) FL.createMolten(tMaterial);
			if (tMaterial.contains(TD.ItemGenerator.GASES )) FL.createGas   (tMaterial);
			if (tMaterial.contains(TD.ItemGenerator.VAPORS)) FL.createVapour(tMaterial);
			if (tMaterial.contains(TD.ItemGenerator.PLASMA)) FL.createPlasma(tMaterial);
		}
		
		
		FL.Air       .fluid().setDensity(0);
		FL.Air_Nether.fluid().setDensity(0);
		FL.Air_End   .fluid().setDensity(0);
		
		
		FL.reg(FL.Air                     .make(1000), IL.Cell_Air                                 .get(1), IL.Cell_Empty.get(1), F, T, T);
		FL.reg(FL.Air_Nether              .make(1000), IL.Cell_Air                                 .get(1), IL.Cell_Empty.get(1), F, T, F);
		FL.reg(FL.Air_End                 .make(1000), IL.Cell_Air                                 .get(1), IL.Cell_Empty.get(1), F, T, F);
		FL.reg(FL.Air_End                 .make(1000), IL.BOTA_Ender_Air_Bottle                    .get(1), IL.Bottle_Empty.get(1));
		FL.reg(FL.Juice_Hellderberry      .make( 250), IL.NeLi_Bottle_Hellderberryjuice            .get(1), IL.Bottle_Empty.get(1));
		FL.reg(FL.FieryTears              .make( 250), IL.TF_Vial_FieryTears                       .get(1), IL.Bottle_Empty.get(1));
		FL.reg(FL.FieryBlood              .make( 250), IL.TF_Vial_FieryBlood                       .get(1), IL.Bottle_Empty.get(1));
		FL.reg(MT.Hg                    .liquid(U, T), IL.HBM_Bottle_Mercury.get(1), IL.Bottle_Empty.get(1));
		FL.reg(FL.XP                      .make( 160), ST.make(Items.experience_bottle             , 1, 0), IL.Bottle_Empty.get(1), F, T, T);
		FL.reg(FL.Mob                     .make( 534), ST.make(Items.experience_bottle             , 1, 0), IL.Bottle_Empty.get(1), F, T, F);
		FL.reg(FL.Gas_Natural             .make(1000), ST.make(MD.MaCu, "fluids"                   , 1,27), IL.Bottle_Empty.get(1), F, T, T);
		FL.reg(FL.Gas_Natural             .make(2000), ST.make(MD.MaCu, "fluids"                   , 1, 2), ST.make(MD.MaCu, "fluids", 1, 20), F, T, T);
		FL.reg(FL.Ambrosia                .make(1000), IL.FR_Ambrosia                              .get(1), IL.FR_WaxCapsule.get(1), T, F, F);
		FL.reg(FL.Honey                   .make( 250), IL.EtFu_Bottle_Honey                        .get(1), IL.Bottle_Empty.get(1), F, F, T);
		FL.reg(FL.Honey                   .make(1000), IL.GrC_Honey_Jar                            .get(1), ST.make(Items.flower_pot, 1, 0));
		FL.reg(FL.Honey                   .make( 500), IL.BoP_Jar_Honey                            .get(1), IL.BoP_Jar_Empty.get(1, IL.Bottle_Empty.get(1)));
		FL.reg(FL.Potion_Poison_2         .make( 500), IL.BoP_Jar_Poison                           .get(1), IL.BoP_Jar_Empty.get(1, IL.Bottle_Empty.get(1)));
		FL.reg(FL.Water                   .make(1000), IL.AETHER_Bucket_Water                      .get(1), IL.AETHER_Bucket_Empty.get(1));
		FL.reg(FL.Milk                    .make(1000), IL.AETHER_Bucket_Milk                       .get(1), IL.AETHER_Bucket_Empty.get(1));
		FL.reg(FL.SpDew                   .make(1000), IL.NeLi_Bucket_Spectral_Dew                 .get(1), ST.make(Items.bucket, 1, 0), F, T, T);
		FL.reg(FL.Water                   .make(5000), IL.SC2_Teapot_Water                         .get(1), IL.SC2_Teapot_Empty.get(1), F, T, T);
		FL.reg(FL.DistW                   .make(5000), IL.SC2_Teapot_Water                         .get(1), IL.SC2_Teapot_Empty.get(1), F, T, F);
		FL.reg(FL.SpDew                   .make(5000), IL.SC2_Teapot_Water                         .get(1), IL.SC2_Teapot_Empty.get(1), F, T, F);
		FL.reg(FL.Cold_Water              .make(5000), IL.SC2_Teapot_Water                         .get(1), IL.SC2_Teapot_Empty.get(1), F, T, F);
		FL.reg(FL.Water_Boiling           .make(5000), IL.SC2_Teapot_Boiling                       .get(1), IL.SC2_Teapot_Empty.get(1), F, T, T);
		FL.reg(FL.Water_Hot               .make(5000), IL.SC2_Teapot_Boiling                       .get(1), IL.SC2_Teapot_Empty.get(1), F, T, F);
		FL.reg(FL.Hot_Water               .make(5000), IL.SC2_Teapot_Boiling                       .get(1), IL.SC2_Teapot_Empty.get(1), F, T, F);
		FL.reg(FL.Water_Geothermal        .make(5000), IL.SC2_Teapot_Boiling                       .get(1), IL.SC2_Teapot_Empty.get(1), F, T, F);
		FL.reg(FL.Tea_Sweet               .make(5000), IL.SC2_Teapot_Full                          .get(1), IL.SC2_Teapot_Empty.get(1), F, T, T);
		FL.reg(FL.Tea_Sweet               .make( 500), ST.make(MD.SC2, "ItemTeapot"                , 1, 3), IL.SC2_Teapot_Empty.get(1), F, F, T);
		FL.reg(FL.Tea_Sweet               .make(1000), ST.make(MD.SC2, "ItemTeapot"                , 1, 4), IL.SC2_Teapot_Empty.get(1), F, F, T);
		FL.reg(FL.Tea_Sweet               .make(1500), ST.make(MD.SC2, "ItemTeapot"                , 1, 5), IL.SC2_Teapot_Empty.get(1), F, F, T);
		FL.reg(FL.Tea_Sweet               .make(2000), ST.make(MD.SC2, "ItemTeapot"                , 1, 6), IL.SC2_Teapot_Empty.get(1), F, F, T);
		FL.reg(FL.Tea_Sweet               .make(2500), ST.make(MD.SC2, "ItemTeapot"                , 1, 7), IL.SC2_Teapot_Empty.get(1), F, F, T);
		FL.reg(FL.Tea_Sweet               .make(3000), ST.make(MD.SC2, "ItemTeapot"                , 1, 8), IL.SC2_Teapot_Empty.get(1), F, F, T);
		FL.reg(FL.Tea_Sweet               .make(3500), ST.make(MD.SC2, "ItemTeapot"                , 1, 9), IL.SC2_Teapot_Empty.get(1), F, F, T);
		FL.reg(FL.Tea_Sweet               .make(4000), ST.make(MD.SC2, "ItemTeapot"                , 1,10), IL.SC2_Teapot_Empty.get(1), F, F, T);
		FL.reg(FL.Tea_Sweet               .make(4500), ST.make(MD.SC2, "ItemTeapot"                , 1,11), IL.SC2_Teapot_Empty.get(1), F, F, T);
		FL.reg(FL.Tea_Sweet               .make( 500), IL.SC2_Teacup_Full                          .get(1), IL.SC2_Teacup_Empty.get(1), F, T, T);
		FL.reg(FL.Tea_Sweet               .make(  50), ST.make(MD.SC2, "ItemTeacup"                , 1, 1), IL.SC2_Teacup_Empty.get(1), F, F, T);
		FL.reg(FL.Tea_Sweet               .make( 100), ST.make(MD.SC2, "ItemTeacup"                , 1, 2), IL.SC2_Teacup_Empty.get(1), F, F, T);
		FL.reg(FL.Tea_Sweet               .make( 150), ST.make(MD.SC2, "ItemTeacup"                , 1, 3), IL.SC2_Teacup_Empty.get(1), F, F, T);
		FL.reg(FL.Tea_Sweet               .make( 200), ST.make(MD.SC2, "ItemTeacup"                , 1, 4), IL.SC2_Teacup_Empty.get(1), F, F, T);
		FL.reg(FL.Tea_Sweet               .make( 250), ST.make(MD.SC2, "ItemTeacup"                , 1, 5), IL.SC2_Teacup_Empty.get(1), F, F, T);
		FL.reg(FL.Tea_Sweet               .make( 300), ST.make(MD.SC2, "ItemTeacup"                , 1, 6), IL.SC2_Teacup_Empty.get(1), F, F, T);
		FL.reg(FL.Tea_Sweet               .make( 350), ST.make(MD.SC2, "ItemTeacup"                , 1, 7), IL.SC2_Teacup_Empty.get(1), F, F, T);
		FL.reg(FL.Tea_Sweet               .make( 400), ST.make(MD.SC2, "ItemTeacup"                , 1, 8), IL.SC2_Teacup_Empty.get(1), F, F, T);
		FL.reg(FL.Tea_Sweet               .make( 450), ST.make(MD.SC2, "ItemTeacup"                , 1, 9), IL.SC2_Teacup_Empty.get(1), F, F, T);
		FL.reg(FL.Tar                     .make(1000), IL.DRPG_Bucket_Tar                          .get(1), ST.make(Items.bucket, 1, 0), F, T, T);
		FL.reg(FL.make("sulfuric_acid_fluid"  , 1000), ST.make(MD.HBM, "item.bucket_sulfuric_acid" , 1, 0), ST.make(Items.bucket, 1, 0), F, T, F);
		FL.reg(FL.make("sulfuricacid"         , 1000), ST.make(MD.HBM, "item.bucket_sulfuric_acid" , 1, 0), ST.make(Items.bucket, 1, 0), F, T, T);
		
		/* TODO
		FL.registerFluidContainer(FL.make("potion.poison"        , 125), IL.Arrow_Head_Glass_Poison          .get(1), IL.Arrow_Head_Glass_Empty.get(1));
		FL.registerFluidContainer(FL.make("potion.poison.long"   , 125), IL.Arrow_Head_Glass_Poison_Long     .get(1), IL.Arrow_Head_Glass_Empty.get(1));
		FL.registerFluidContainer(FL.make("potion.poison.strong" , 125), IL.Arrow_Head_Glass_Poison_Strong   .get(1), IL.Arrow_Head_Glass_Empty.get(1));
		FL.registerFluidContainer(FL.make("potion.slowness"      , 125), IL.Arrow_Head_Glass_Slowness        .get(1), IL.Arrow_Head_Glass_Empty.get(1));
		FL.registerFluidContainer(FL.make("potion.slowness.long" , 125), IL.Arrow_Head_Glass_Slowness_Long   .get(1), IL.Arrow_Head_Glass_Empty.get(1));
		FL.registerFluidContainer(FL.make("potion.weakness"      , 125), IL.Arrow_Head_Glass_Weakness        .get(1), IL.Arrow_Head_Glass_Empty.get(1));
		FL.registerFluidContainer(FL.make("potion.weakness.long" , 125), IL.Arrow_Head_Glass_Weakness_Long   .get(1), IL.Arrow_Head_Glass_Empty.get(1));
		FL.registerFluidContainer(FL.make("holywater"            , 125), IL.Arrow_Head_Glass_Holy_Water      .get(1), IL.Arrow_Head_Glass_Empty.get(1));

		FL.registerFluidContainer(FL.make("potion.poison"        , 125), IL.Arrow_Wooden_Glass_Poison        .get(1), IL.Arrow_Wooden_Glass_Empty.get(1));
		FL.registerFluidContainer(FL.make("potion.poison.long"   , 125), IL.Arrow_Wooden_Glass_Poison_Long   .get(1), IL.Arrow_Wooden_Glass_Empty.get(1));
		FL.registerFluidContainer(FL.make("potion.poison.strong" , 125), IL.Arrow_Wooden_Glass_Poison_Strong .get(1), IL.Arrow_Wooden_Glass_Empty.get(1));
		FL.registerFluidContainer(FL.make("potion.slowness"      , 125), IL.Arrow_Wooden_Glass_Slowness      .get(1), IL.Arrow_Wooden_Glass_Empty.get(1));
		FL.registerFluidContainer(FL.make("potion.slowness.long" , 125), IL.Arrow_Wooden_Glass_Slowness_Long .get(1), IL.Arrow_Wooden_Glass_Empty.get(1));
		FL.registerFluidContainer(FL.make("potion.weakness"      , 125), IL.Arrow_Wooden_Glass_Weakness      .get(1), IL.Arrow_Wooden_Glass_Empty.get(1));
		FL.registerFluidContainer(FL.make("potion.weakness.long" , 125), IL.Arrow_Wooden_Glass_Weakness_Long .get(1), IL.Arrow_Wooden_Glass_Empty.get(1));
		FL.registerFluidContainer(FL.make("holywater"            , 125), IL.Arrow_Wooden_Glass_Holy_Water    .get(1), IL.Arrow_Wooden_Glass_Empty.get(1));

		FL.registerFluidContainer(FL.make("potion.poison"        , 125), IL.Arrow_Plastic_Glass_Poison       .get(1), IL.Arrow_Plastic_Glass_Empty.get(1));
		FL.registerFluidContainer(FL.make("potion.poison.long"   , 125), IL.Arrow_Plastic_Glass_Poison_Long  .get(1), IL.Arrow_Plastic_Glass_Empty.get(1));
		FL.registerFluidContainer(FL.make("potion.poison.strong" , 125), IL.Arrow_Plastic_Glass_Poison_Strong.get(1), IL.Arrow_Plastic_Glass_Empty.get(1));
		FL.registerFluidContainer(FL.make("potion.slowness"      , 125), IL.Arrow_Plastic_Glass_Slowness     .get(1), IL.Arrow_Plastic_Glass_Empty.get(1));
		FL.registerFluidContainer(FL.make("potion.slowness.long" , 125), IL.Arrow_Plastic_Glass_Slowness_Long.get(1), IL.Arrow_Plastic_Glass_Empty.get(1));
		FL.registerFluidContainer(FL.make("potion.weakness"      , 125), IL.Arrow_Plastic_Glass_Weakness     .get(1), IL.Arrow_Plastic_Glass_Empty.get(1));
		FL.registerFluidContainer(FL.make("potion.weakness.long" , 125), IL.Arrow_Plastic_Glass_Weakness_Long.get(1), IL.Arrow_Plastic_Glass_Empty.get(1));
		FL.registerFluidContainer(FL.make("holywater"            , 125), IL.Arrow_Plastic_Glass_Holy_Water   .get(1), IL.Arrow_Plastic_Glass_Empty.get(1));
		*/
	}
}
